/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package dispatcher

import (
	"github.com/Shopify/sarama"
	"go.opencensus.io/plugin/ochttp/propagation/tracecontext"
	"go.opencensus.io/trace"
)

const (
	traceParentHeader = "traceparent"
	traceStateHeader  = "tracestate"
)

var format = &tracecontext.HTTPFormat{}

func serializeTrace(spanContext trace.SpanContext) []sarama.RecordHeader {
	tp, ts := format.SpanContextToHeaders(spanContext)

	if ts != "" {
		return []sarama.RecordHeader{{
			Key:   []byte(traceParentHeader),
			Value: []byte(tp),
		}, {
			Key:   []byte(traceStateHeader),
			Value: []byte(ts),
		}}
	}

	return []sarama.RecordHeader{{
		Key:   []byte(traceParentHeader),
		Value: []byte(tp),
	}}
}

func parseSpanContext(headers map[string][]byte) (sc trace.SpanContext, ok bool) {
	tpBytes, ok := headers[traceParentHeader]
	if !ok {
		return trace.SpanContext{}, false
	}
	tp := string(tpBytes)

	ts := ""
	if tsBytes, ok := headers[traceStateHeader]; ok {
		ts = string(tsBytes)
	}

	return format.SpanContextFromHeaders(tp, ts)
}
