/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1alpha1 "knative.dev/eventing/pkg/apis/configs/v1alpha1"
)

// ConfigMapPropagationLister helps list ConfigMapPropagations.
type ConfigMapPropagationLister interface {
	// List lists all ConfigMapPropagations in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.ConfigMapPropagation, err error)
	// ConfigMapPropagations returns an object that can list and get ConfigMapPropagations.
	ConfigMapPropagations(namespace string) ConfigMapPropagationNamespaceLister
	ConfigMapPropagationListerExpansion
}

// configMapPropagationLister implements the ConfigMapPropagationLister interface.
type configMapPropagationLister struct {
	indexer cache.Indexer
}

// NewConfigMapPropagationLister returns a new ConfigMapPropagationLister.
func NewConfigMapPropagationLister(indexer cache.Indexer) ConfigMapPropagationLister {
	return &configMapPropagationLister{indexer: indexer}
}

// List lists all ConfigMapPropagations in the indexer.
func (s *configMapPropagationLister) List(selector labels.Selector) (ret []*v1alpha1.ConfigMapPropagation, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.ConfigMapPropagation))
	})
	return ret, err
}

// ConfigMapPropagations returns an object that can list and get ConfigMapPropagations.
func (s *configMapPropagationLister) ConfigMapPropagations(namespace string) ConfigMapPropagationNamespaceLister {
	return configMapPropagationNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ConfigMapPropagationNamespaceLister helps list and get ConfigMapPropagations.
type ConfigMapPropagationNamespaceLister interface {
	// List lists all ConfigMapPropagations in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.ConfigMapPropagation, err error)
	// Get retrieves the ConfigMapPropagation from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.ConfigMapPropagation, error)
	ConfigMapPropagationNamespaceListerExpansion
}

// configMapPropagationNamespaceLister implements the ConfigMapPropagationNamespaceLister
// interface.
type configMapPropagationNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ConfigMapPropagations in the indexer for a given namespace.
func (s configMapPropagationNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.ConfigMapPropagation, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.ConfigMapPropagation))
	})
	return ret, err
}

// Get retrieves the ConfigMapPropagation from the indexer for a given namespace and name.
func (s configMapPropagationNamespaceLister) Get(name string) (*v1alpha1.ConfigMapPropagation, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("configmappropagation"), name)
	}
	return obj.(*v1alpha1.ConfigMapPropagation), nil
}
