/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha3

import (
	"time"

	v1alpha3 "istio.io/client-go/pkg/apis/networking/v1alpha3"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	scheme "knative.dev/serving/pkg/client/istio/clientset/versioned/scheme"
)

// WorkloadEntriesGetter has a method to return a WorkloadEntryInterface.
// A group's client should implement this interface.
type WorkloadEntriesGetter interface {
	WorkloadEntries(namespace string) WorkloadEntryInterface
}

// WorkloadEntryInterface has methods to work with WorkloadEntry resources.
type WorkloadEntryInterface interface {
	Create(*v1alpha3.WorkloadEntry) (*v1alpha3.WorkloadEntry, error)
	Update(*v1alpha3.WorkloadEntry) (*v1alpha3.WorkloadEntry, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha3.WorkloadEntry, error)
	List(opts v1.ListOptions) (*v1alpha3.WorkloadEntryList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha3.WorkloadEntry, err error)
	WorkloadEntryExpansion
}

// workloadEntries implements WorkloadEntryInterface
type workloadEntries struct {
	client rest.Interface
	ns     string
}

// newWorkloadEntries returns a WorkloadEntries
func newWorkloadEntries(c *NetworkingV1alpha3Client, namespace string) *workloadEntries {
	return &workloadEntries{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the workloadEntry, and returns the corresponding workloadEntry object, and an error if there is any.
func (c *workloadEntries) Get(name string, options v1.GetOptions) (result *v1alpha3.WorkloadEntry, err error) {
	result = &v1alpha3.WorkloadEntry{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("workloadentries").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of WorkloadEntries that match those selectors.
func (c *workloadEntries) List(opts v1.ListOptions) (result *v1alpha3.WorkloadEntryList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha3.WorkloadEntryList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("workloadentries").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested workloadEntries.
func (c *workloadEntries) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("workloadentries").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a workloadEntry and creates it.  Returns the server's representation of the workloadEntry, and an error, if there is any.
func (c *workloadEntries) Create(workloadEntry *v1alpha3.WorkloadEntry) (result *v1alpha3.WorkloadEntry, err error) {
	result = &v1alpha3.WorkloadEntry{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("workloadentries").
		Body(workloadEntry).
		Do().
		Into(result)
	return
}

// Update takes the representation of a workloadEntry and updates it. Returns the server's representation of the workloadEntry, and an error, if there is any.
func (c *workloadEntries) Update(workloadEntry *v1alpha3.WorkloadEntry) (result *v1alpha3.WorkloadEntry, err error) {
	result = &v1alpha3.WorkloadEntry{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("workloadentries").
		Name(workloadEntry.Name).
		Body(workloadEntry).
		Do().
		Into(result)
	return
}

// Delete takes name of the workloadEntry and deletes it. Returns an error if one occurs.
func (c *workloadEntries) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("workloadentries").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *workloadEntries) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("workloadentries").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched workloadEntry.
func (c *workloadEntries) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha3.WorkloadEntry, err error) {
	result = &v1alpha3.WorkloadEntry{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("workloadentries").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
