/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: pkg/autoscaler/metrics/stat.proto

package metrics

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Stat defines a single measurement at a point in time
type Stat struct {
	// The unique identity of this pod.  Used to count how many pods
	// are contributing to the metrics.
	PodName string `protobuf:"bytes,1,opt,name=pod_name,json=podName,proto3" json:"pod_name,omitempty"`
	// Average number of requests currently being handled by this pod.
	AverageConcurrentRequests float64 `protobuf:"fixed64,2,opt,name=average_concurrent_requests,json=averageConcurrentRequests,proto3" json:"average_concurrent_requests,omitempty"`
	// Part of AverageConcurrentRequests, for requests going through a proxy.
	AverageProxiedConcurrentRequests float64 `protobuf:"fixed64,3,opt,name=average_proxied_concurrent_requests,json=averageProxiedConcurrentRequests,proto3" json:"average_proxied_concurrent_requests,omitempty"`
	// Number of requests received since last Stat (approximately requests per second).
	RequestCount float64 `protobuf:"fixed64,4,opt,name=request_count,json=requestCount,proto3" json:"request_count,omitempty"`
	// Part of RequestCount, for requests going through a proxy.
	ProxiedRequestCount float64 `protobuf:"fixed64,5,opt,name=proxied_request_count,json=proxiedRequestCount,proto3" json:"proxied_request_count,omitempty"`
	// Process uptime in seconds.
	ProcessUptime float64 `protobuf:"fixed64,6,opt,name=process_uptime,json=processUptime,proto3" json:"process_uptime,omitempty"`
}

func (m *Stat) Reset()         { *m = Stat{} }
func (m *Stat) String() string { return proto.CompactTextString(m) }
func (*Stat) ProtoMessage()    {}
func (*Stat) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf216df9f6fff44c, []int{0}
}
func (m *Stat) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Stat) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Stat.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Stat) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Stat.Merge(m, src)
}
func (m *Stat) XXX_Size() int {
	return m.Size()
}
func (m *Stat) XXX_DiscardUnknown() {
	xxx_messageInfo_Stat.DiscardUnknown(m)
}

var xxx_messageInfo_Stat proto.InternalMessageInfo

func (m *Stat) GetPodName() string {
	if m != nil {
		return m.PodName
	}
	return ""
}

func (m *Stat) GetAverageConcurrentRequests() float64 {
	if m != nil {
		return m.AverageConcurrentRequests
	}
	return 0
}

func (m *Stat) GetAverageProxiedConcurrentRequests() float64 {
	if m != nil {
		return m.AverageProxiedConcurrentRequests
	}
	return 0
}

func (m *Stat) GetRequestCount() float64 {
	if m != nil {
		return m.RequestCount
	}
	return 0
}

func (m *Stat) GetProxiedRequestCount() float64 {
	if m != nil {
		return m.ProxiedRequestCount
	}
	return 0
}

func (m *Stat) GetProcessUptime() float64 {
	if m != nil {
		return m.ProcessUptime
	}
	return 0
}

func init() {
	proto.RegisterType((*Stat)(nil), "metrics.Stat")
}

func init() { proto.RegisterFile("pkg/autoscaler/metrics/stat.proto", fileDescriptor_cf216df9f6fff44c) }

var fileDescriptor_cf216df9f6fff44c = []byte{
	// 265 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x6c, 0x90, 0xc1, 0x4a, 0x33, 0x31,
	0x14, 0x46, 0x27, 0xfd, 0xfb, 0xb7, 0x1a, 0xac, 0x8b, 0x88, 0x90, 0x22, 0x84, 0xd1, 0x22, 0x74,
	0xe5, 0x80, 0xee, 0x5d, 0xd8, 0xb5, 0x22, 0x23, 0xae, 0x43, 0xcc, 0x5c, 0xca, 0xa0, 0x33, 0x89,
	0xc9, 0x8d, 0xf8, 0x18, 0x3e, 0x8a, 0x8f, 0xe1, 0xb2, 0x4b, 0x97, 0x32, 0xf3, 0x22, 0x62, 0x4c,
	0x45, 0xa1, 0xdb, 0x93, 0x73, 0xbe, 0xc0, 0xa5, 0x87, 0xf6, 0x7e, 0x59, 0xa8, 0x80, 0xc6, 0x6b,
	0xf5, 0x00, 0xae, 0x68, 0x00, 0x5d, 0xad, 0x7d, 0xe1, 0x51, 0xe1, 0x89, 0x75, 0x06, 0x0d, 0x1b,
	0x27, 0x76, 0xf4, 0x3a, 0xa0, 0xc3, 0x1b, 0x54, 0xc8, 0xa6, 0x74, 0xcb, 0x9a, 0x4a, 0xb6, 0xaa,
	0x01, 0x4e, 0x72, 0x32, 0xdf, 0x2e, 0xc7, 0xd6, 0x54, 0x57, 0xaa, 0x01, 0x76, 0x4e, 0x0f, 0xd4,
	0x13, 0x38, 0xb5, 0x04, 0xa9, 0x4d, 0xab, 0x83, 0x73, 0xd0, 0xa2, 0x74, 0xf0, 0x18, 0xc0, 0xa3,
	0xe7, 0x83, 0x9c, 0xcc, 0x49, 0x39, 0x4d, 0xca, 0xe2, 0xc7, 0x28, 0x93, 0xc0, 0x2e, 0xe9, 0x6c,
	0xdd, 0x5b, 0x67, 0x9e, 0x6b, 0xa8, 0x36, 0xee, 0xfc, 0x8b, 0x3b, 0x79, 0x52, 0xaf, 0xbf, 0xcd,
	0x0d, 0x73, 0x33, 0x3a, 0x49, 0x8d, 0xd4, 0x26, 0xb4, 0xc8, 0x87, 0x31, 0xdc, 0x49, 0x70, 0xf1,
	0xc5, 0xd8, 0x29, 0xdd, 0x5f, 0xff, 0xf5, 0x57, 0xfe, 0x1f, 0xe5, 0xbd, 0xf4, 0x58, 0xfe, 0x6e,
	0x8e, 0xe9, 0xae, 0x75, 0x46, 0x83, 0xf7, 0x32, 0x58, 0xac, 0x1b, 0xe0, 0xa3, 0x28, 0x4f, 0x12,
	0xbd, 0x8d, 0xf0, 0x82, 0xbf, 0x75, 0x82, 0xac, 0x3a, 0x41, 0x3e, 0x3a, 0x41, 0x5e, 0x7a, 0x91,
	0xad, 0x7a, 0x91, 0xbd, 0xf7, 0x22, 0xbb, 0x1b, 0xc5, 0xe3, 0x9e, 0x7d, 0x06, 0x00, 0x00, 0xff,
	0xff, 0xa0, 0xd7, 0x6e, 0x87, 0x81, 0x01, 0x00, 0x00,
}

func (m *Stat) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Stat) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Stat) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ProcessUptime != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.ProcessUptime))))
		i--
		dAtA[i] = 0x31
	}
	if m.ProxiedRequestCount != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.ProxiedRequestCount))))
		i--
		dAtA[i] = 0x29
	}
	if m.RequestCount != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.RequestCount))))
		i--
		dAtA[i] = 0x21
	}
	if m.AverageProxiedConcurrentRequests != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.AverageProxiedConcurrentRequests))))
		i--
		dAtA[i] = 0x19
	}
	if m.AverageConcurrentRequests != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.AverageConcurrentRequests))))
		i--
		dAtA[i] = 0x11
	}
	if len(m.PodName) > 0 {
		i -= len(m.PodName)
		copy(dAtA[i:], m.PodName)
		i = encodeVarintStat(dAtA, i, uint64(len(m.PodName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintStat(dAtA []byte, offset int, v uint64) int {
	offset -= sovStat(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Stat) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PodName)
	if l > 0 {
		n += 1 + l + sovStat(uint64(l))
	}
	if m.AverageConcurrentRequests != 0 {
		n += 9
	}
	if m.AverageProxiedConcurrentRequests != 0 {
		n += 9
	}
	if m.RequestCount != 0 {
		n += 9
	}
	if m.ProxiedRequestCount != 0 {
		n += 9
	}
	if m.ProcessUptime != 0 {
		n += 9
	}
	return n
}

func sovStat(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozStat(x uint64) (n int) {
	return sovStat(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Stat) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStat
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Stat: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Stat: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PodName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStat
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthStat
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PodName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field AverageConcurrentRequests", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.AverageConcurrentRequests = float64(math.Float64frombits(v))
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field AverageProxiedConcurrentRequests", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.AverageProxiedConcurrentRequests = float64(math.Float64frombits(v))
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestCount", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.RequestCount = float64(math.Float64frombits(v))
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxiedRequestCount", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.ProxiedRequestCount = float64(math.Float64frombits(v))
		case 6:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessUptime", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.ProcessUptime = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipStat(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStat
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthStat
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipStat(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowStat
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStat
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStat
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthStat
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupStat
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthStat
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthStat        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowStat          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupStat = fmt.Errorf("proto: unexpected end of group")
)
