/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1 "knative.dev/serving/pkg/apis/serving/v1"
)

// ConfigurationLister helps list Configurations.
// All objects returned here must be treated as read-only.
type ConfigurationLister interface {
	// List lists all Configurations in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.Configuration, err error)
	// Configurations returns an object that can list and get Configurations.
	Configurations(namespace string) ConfigurationNamespaceLister
	ConfigurationListerExpansion
}

// configurationLister implements the ConfigurationLister interface.
type configurationLister struct {
	indexer cache.Indexer
}

// NewConfigurationLister returns a new ConfigurationLister.
func NewConfigurationLister(indexer cache.Indexer) ConfigurationLister {
	return &configurationLister{indexer: indexer}
}

// List lists all Configurations in the indexer.
func (s *configurationLister) List(selector labels.Selector) (ret []*v1.Configuration, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.Configuration))
	})
	return ret, err
}

// Configurations returns an object that can list and get Configurations.
func (s *configurationLister) Configurations(namespace string) ConfigurationNamespaceLister {
	return configurationNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ConfigurationNamespaceLister helps list and get Configurations.
// All objects returned here must be treated as read-only.
type ConfigurationNamespaceLister interface {
	// List lists all Configurations in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.Configuration, err error)
	// Get retrieves the Configuration from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.Configuration, error)
	ConfigurationNamespaceListerExpansion
}

// configurationNamespaceLister implements the ConfigurationNamespaceLister
// interface.
type configurationNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Configurations in the indexer for a given namespace.
func (s configurationNamespaceLister) List(selector labels.Selector) (ret []*v1.Configuration, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.Configuration))
	})
	return ret, err
}

// Get retrieves the Configuration from the indexer for a given namespace and name.
func (s configurationNamespaceLister) Get(name string) (*v1.Configuration, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("configuration"), name)
	}
	return obj.(*v1.Configuration), nil
}
