/*
Copyright 2021 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	"context"
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1beta1 "knative.dev/serving/pkg/apis/serving/v1beta1"
	scheme "knative.dev/serving/pkg/client/clientset/versioned/scheme"
)

// DomainMappingsGetter has a method to return a DomainMappingInterface.
// A group's client should implement this interface.
type DomainMappingsGetter interface {
	DomainMappings(namespace string) DomainMappingInterface
}

// DomainMappingInterface has methods to work with DomainMapping resources.
type DomainMappingInterface interface {
	Create(ctx context.Context, domainMapping *v1beta1.DomainMapping, opts v1.CreateOptions) (*v1beta1.DomainMapping, error)
	Update(ctx context.Context, domainMapping *v1beta1.DomainMapping, opts v1.UpdateOptions) (*v1beta1.DomainMapping, error)
	UpdateStatus(ctx context.Context, domainMapping *v1beta1.DomainMapping, opts v1.UpdateOptions) (*v1beta1.DomainMapping, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.DomainMapping, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1beta1.DomainMappingList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.DomainMapping, err error)
	DomainMappingExpansion
}

// domainMappings implements DomainMappingInterface
type domainMappings struct {
	client rest.Interface
	ns     string
}

// newDomainMappings returns a DomainMappings
func newDomainMappings(c *ServingV1beta1Client, namespace string) *domainMappings {
	return &domainMappings{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the domainMapping, and returns the corresponding domainMapping object, and an error if there is any.
func (c *domainMappings) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.DomainMapping, err error) {
	result = &v1beta1.DomainMapping{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("domainmappings").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of DomainMappings that match those selectors.
func (c *domainMappings) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.DomainMappingList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta1.DomainMappingList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("domainmappings").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested domainMappings.
func (c *domainMappings) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("domainmappings").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a domainMapping and creates it.  Returns the server's representation of the domainMapping, and an error, if there is any.
func (c *domainMappings) Create(ctx context.Context, domainMapping *v1beta1.DomainMapping, opts v1.CreateOptions) (result *v1beta1.DomainMapping, err error) {
	result = &v1beta1.DomainMapping{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("domainmappings").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(domainMapping).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a domainMapping and updates it. Returns the server's representation of the domainMapping, and an error, if there is any.
func (c *domainMappings) Update(ctx context.Context, domainMapping *v1beta1.DomainMapping, opts v1.UpdateOptions) (result *v1beta1.DomainMapping, err error) {
	result = &v1beta1.DomainMapping{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("domainmappings").
		Name(domainMapping.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(domainMapping).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *domainMappings) UpdateStatus(ctx context.Context, domainMapping *v1beta1.DomainMapping, opts v1.UpdateOptions) (result *v1beta1.DomainMapping, err error) {
	result = &v1beta1.DomainMapping{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("domainmappings").
		Name(domainMapping.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(domainMapping).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the domainMapping and deletes it. Returns an error if one occurs.
func (c *domainMappings) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("domainmappings").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *domainMappings) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("domainmappings").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched domainMapping.
func (c *domainMappings) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.DomainMapping, err error) {
	result = &v1beta1.DomainMapping{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("domainmappings").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
