/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	"context"
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1beta1 "knative.dev/eventing-kafka/pkg/apis/bindings/v1beta1"
	scheme "knative.dev/eventing-kafka/pkg/client/clientset/versioned/scheme"
)

// KafkaBindingsGetter has a method to return a KafkaBindingInterface.
// A group's client should implement this interface.
type KafkaBindingsGetter interface {
	KafkaBindings(namespace string) KafkaBindingInterface
}

// KafkaBindingInterface has methods to work with KafkaBinding resources.
type KafkaBindingInterface interface {
	Create(ctx context.Context, kafkaBinding *v1beta1.KafkaBinding, opts v1.CreateOptions) (*v1beta1.KafkaBinding, error)
	Update(ctx context.Context, kafkaBinding *v1beta1.KafkaBinding, opts v1.UpdateOptions) (*v1beta1.KafkaBinding, error)
	UpdateStatus(ctx context.Context, kafkaBinding *v1beta1.KafkaBinding, opts v1.UpdateOptions) (*v1beta1.KafkaBinding, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.KafkaBinding, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1beta1.KafkaBindingList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.KafkaBinding, err error)
	KafkaBindingExpansion
}

// kafkaBindings implements KafkaBindingInterface
type kafkaBindings struct {
	client rest.Interface
	ns     string
}

// newKafkaBindings returns a KafkaBindings
func newKafkaBindings(c *BindingsV1beta1Client, namespace string) *kafkaBindings {
	return &kafkaBindings{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the kafkaBinding, and returns the corresponding kafkaBinding object, and an error if there is any.
func (c *kafkaBindings) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.KafkaBinding, err error) {
	result = &v1beta1.KafkaBinding{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("kafkabindings").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of KafkaBindings that match those selectors.
func (c *kafkaBindings) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.KafkaBindingList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta1.KafkaBindingList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("kafkabindings").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested kafkaBindings.
func (c *kafkaBindings) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("kafkabindings").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a kafkaBinding and creates it.  Returns the server's representation of the kafkaBinding, and an error, if there is any.
func (c *kafkaBindings) Create(ctx context.Context, kafkaBinding *v1beta1.KafkaBinding, opts v1.CreateOptions) (result *v1beta1.KafkaBinding, err error) {
	result = &v1beta1.KafkaBinding{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("kafkabindings").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(kafkaBinding).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a kafkaBinding and updates it. Returns the server's representation of the kafkaBinding, and an error, if there is any.
func (c *kafkaBindings) Update(ctx context.Context, kafkaBinding *v1beta1.KafkaBinding, opts v1.UpdateOptions) (result *v1beta1.KafkaBinding, err error) {
	result = &v1beta1.KafkaBinding{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("kafkabindings").
		Name(kafkaBinding.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(kafkaBinding).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *kafkaBindings) UpdateStatus(ctx context.Context, kafkaBinding *v1beta1.KafkaBinding, opts v1.UpdateOptions) (result *v1beta1.KafkaBinding, err error) {
	result = &v1beta1.KafkaBinding{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("kafkabindings").
		Name(kafkaBinding.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(kafkaBinding).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the kafkaBinding and deletes it. Returns an error if one occurs.
func (c *kafkaBindings) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("kafkabindings").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *kafkaBindings) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("kafkabindings").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched kafkaBinding.
func (c *kafkaBindings) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.KafkaBinding, err error) {
	result = &v1beta1.KafkaBinding{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("kafkabindings").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
