// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: networking/v1alpha3/workload_group.proto

// `WorkloadGroup` describes a collection of workload instances.
// It provides a specification that the workload instances can use to bootstrap
// their proxies, including the metadata and identity. It is only intended to
// be used with non-k8s workloads like Virtual Machines, and is meant to mimic
// the existing sidecar injection and deployment specification model used for
// Kubernetes workloads to bootstrap Istio proxies.
//
// The following example declares a workload group representing a collection
// of workloads that will be registered under `reviews` in namespace
// `bookinfo`. The set of labels will be associated with each workload
// instance during the bootstrap process, and the ports 3550 and 8080
// will be associated with the workload group and use service account `default`.
// `app.kubernetes.io/version` is just an arbitrary example of a label.
//
// {{<tabset category-name="example">}}
// {{<tab name="v1alpha3" category-value="v1alpha3">}}
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: WorkloadGroup
// metadata:
//   name: reviews
//   namespace: bookinfo
// spec:
//   metadata:
//     labels:
//       app.kubernetes.io/name: reviews
//       app.kubernetes.io/version: "1.3.4"
//   template:
//     ports:
//       grpc: 3550
//       http: 8080
//     serviceAccount: default
//   probe:
//     initialDelaySeconds: 5
//     timeoutSeconds: 3
//     periodSeconds: 4
//     successThreshold: 3
//     failureThreshold: 3
//     httpGet:
//      path: /foo/bar
//      host: 127.0.0.1
//      port: 3100
//      scheme: https
//      httpHeaders:
//      - name: Lit-Header
//        value: Im-The-Best
// ```
// {{</tab>}}
// {{</tabset>}}
//

package v1alpha3

import (
	bytes "bytes"
	fmt "fmt"
	github_com_gogo_protobuf_jsonpb "github.com/gogo/protobuf/jsonpb"
	proto "github.com/gogo/protobuf/proto"
	_ "istio.io/gogo-genproto/googleapis/google/api"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// MarshalJSON is a custom marshaler for WorkloadGroup
func (this *WorkloadGroup) MarshalJSON() ([]byte, error) {
	str, err := WorkloadGroupMarshaler.MarshalToString(this)
	return []byte(str), err
}

// UnmarshalJSON is a custom unmarshaler for WorkloadGroup
func (this *WorkloadGroup) UnmarshalJSON(b []byte) error {
	return WorkloadGroupUnmarshaler.Unmarshal(bytes.NewReader(b), this)
}

// MarshalJSON is a custom marshaler for WorkloadGroup_ObjectMeta
func (this *WorkloadGroup_ObjectMeta) MarshalJSON() ([]byte, error) {
	str, err := WorkloadGroupMarshaler.MarshalToString(this)
	return []byte(str), err
}

// UnmarshalJSON is a custom unmarshaler for WorkloadGroup_ObjectMeta
func (this *WorkloadGroup_ObjectMeta) UnmarshalJSON(b []byte) error {
	return WorkloadGroupUnmarshaler.Unmarshal(bytes.NewReader(b), this)
}

// MarshalJSON is a custom marshaler for ReadinessProbe
func (this *ReadinessProbe) MarshalJSON() ([]byte, error) {
	str, err := WorkloadGroupMarshaler.MarshalToString(this)
	return []byte(str), err
}

// UnmarshalJSON is a custom unmarshaler for ReadinessProbe
func (this *ReadinessProbe) UnmarshalJSON(b []byte) error {
	return WorkloadGroupUnmarshaler.Unmarshal(bytes.NewReader(b), this)
}

// MarshalJSON is a custom marshaler for HTTPHealthCheckConfig
func (this *HTTPHealthCheckConfig) MarshalJSON() ([]byte, error) {
	str, err := WorkloadGroupMarshaler.MarshalToString(this)
	return []byte(str), err
}

// UnmarshalJSON is a custom unmarshaler for HTTPHealthCheckConfig
func (this *HTTPHealthCheckConfig) UnmarshalJSON(b []byte) error {
	return WorkloadGroupUnmarshaler.Unmarshal(bytes.NewReader(b), this)
}

// MarshalJSON is a custom marshaler for HTTPHeader
func (this *HTTPHeader) MarshalJSON() ([]byte, error) {
	str, err := WorkloadGroupMarshaler.MarshalToString(this)
	return []byte(str), err
}

// UnmarshalJSON is a custom unmarshaler for HTTPHeader
func (this *HTTPHeader) UnmarshalJSON(b []byte) error {
	return WorkloadGroupUnmarshaler.Unmarshal(bytes.NewReader(b), this)
}

// MarshalJSON is a custom marshaler for TCPHealthCheckConfig
func (this *TCPHealthCheckConfig) MarshalJSON() ([]byte, error) {
	str, err := WorkloadGroupMarshaler.MarshalToString(this)
	return []byte(str), err
}

// UnmarshalJSON is a custom unmarshaler for TCPHealthCheckConfig
func (this *TCPHealthCheckConfig) UnmarshalJSON(b []byte) error {
	return WorkloadGroupUnmarshaler.Unmarshal(bytes.NewReader(b), this)
}

// MarshalJSON is a custom marshaler for ExecHealthCheckConfig
func (this *ExecHealthCheckConfig) MarshalJSON() ([]byte, error) {
	str, err := WorkloadGroupMarshaler.MarshalToString(this)
	return []byte(str), err
}

// UnmarshalJSON is a custom unmarshaler for ExecHealthCheckConfig
func (this *ExecHealthCheckConfig) UnmarshalJSON(b []byte) error {
	return WorkloadGroupUnmarshaler.Unmarshal(bytes.NewReader(b), this)
}

var (
	WorkloadGroupMarshaler   = &github_com_gogo_protobuf_jsonpb.Marshaler{}
	WorkloadGroupUnmarshaler = &github_com_gogo_protobuf_jsonpb.Unmarshaler{AllowUnknownFields: true}
)
