// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: networking/v1alpha3/envoy_filter.proto

package v1alpha3

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	io "io"
	_ "istio.io/gogo-genproto/googleapis/google/api"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// `ApplyTo` specifies where in the Envoy configuration, the given patch should be applied.
type EnvoyFilter_ApplyTo int32

const (
	EnvoyFilter_INVALID EnvoyFilter_ApplyTo = 0
	// Applies the patch to the listener.
	EnvoyFilter_LISTENER EnvoyFilter_ApplyTo = 1
	// Applies the patch to the filter chain.
	EnvoyFilter_FILTER_CHAIN EnvoyFilter_ApplyTo = 2
	// Applies the patch to the network filter chain, to modify an
	// existing filter or add a new filter.
	EnvoyFilter_NETWORK_FILTER EnvoyFilter_ApplyTo = 3
	// Applies the patch to the HTTP filter chain in the http
	// connection manager, to modify an existing filter or add a new
	// filter.
	EnvoyFilter_HTTP_FILTER EnvoyFilter_ApplyTo = 4
	// Applies the patch to the Route configuration (rds output)
	// inside a HTTP connection manager. This does not apply to the
	// virtual host. Currently, only `MERGE` operation is allowed on the
	// route configuration objects.
	EnvoyFilter_ROUTE_CONFIGURATION EnvoyFilter_ApplyTo = 5
	// Applies the patch to a virtual host inside a route configuration.
	EnvoyFilter_VIRTUAL_HOST EnvoyFilter_ApplyTo = 6
	// Applies the patch to a route object inside the matched virtual
	// host in a route configuration.
	EnvoyFilter_HTTP_ROUTE EnvoyFilter_ApplyTo = 7
	// Applies the patch to a cluster in a CDS output. Also used to add new clusters.
	EnvoyFilter_CLUSTER EnvoyFilter_ApplyTo = 8
	// Applies the patch to or adds an extension config in ECDS output. Note that ECDS
	// is only supported by HTTP filters.
	EnvoyFilter_EXTENSION_CONFIG EnvoyFilter_ApplyTo = 9
)

var EnvoyFilter_ApplyTo_name = map[int32]string{
	0: "INVALID",
	1: "LISTENER",
	2: "FILTER_CHAIN",
	3: "NETWORK_FILTER",
	4: "HTTP_FILTER",
	5: "ROUTE_CONFIGURATION",
	6: "VIRTUAL_HOST",
	7: "HTTP_ROUTE",
	8: "CLUSTER",
	9: "EXTENSION_CONFIG",
}

var EnvoyFilter_ApplyTo_value = map[string]int32{
	"INVALID":             0,
	"LISTENER":            1,
	"FILTER_CHAIN":        2,
	"NETWORK_FILTER":      3,
	"HTTP_FILTER":         4,
	"ROUTE_CONFIGURATION": 5,
	"VIRTUAL_HOST":        6,
	"HTTP_ROUTE":          7,
	"CLUSTER":             8,
	"EXTENSION_CONFIG":    9,
}

func (x EnvoyFilter_ApplyTo) String() string {
	return proto.EnumName(EnvoyFilter_ApplyTo_name, int32(x))
}

func (EnvoyFilter_ApplyTo) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 0}
}

// PatchContext selects a class of configurations based on the
// traffic flow direction and workload type.
type EnvoyFilter_PatchContext int32

const (
	// All listeners/routes/clusters in both sidecars and gateways.
	EnvoyFilter_ANY EnvoyFilter_PatchContext = 0
	// Inbound listener/route/cluster in sidecar.
	EnvoyFilter_SIDECAR_INBOUND EnvoyFilter_PatchContext = 1
	// Outbound listener/route/cluster in sidecar.
	EnvoyFilter_SIDECAR_OUTBOUND EnvoyFilter_PatchContext = 2
	// Gateway listener/route/cluster.
	EnvoyFilter_GATEWAY EnvoyFilter_PatchContext = 3
)

var EnvoyFilter_PatchContext_name = map[int32]string{
	0: "ANY",
	1: "SIDECAR_INBOUND",
	2: "SIDECAR_OUTBOUND",
	3: "GATEWAY",
}

var EnvoyFilter_PatchContext_value = map[string]int32{
	"ANY":              0,
	"SIDECAR_INBOUND":  1,
	"SIDECAR_OUTBOUND": 2,
	"GATEWAY":          3,
}

func (x EnvoyFilter_PatchContext) String() string {
	return proto.EnumName(EnvoyFilter_PatchContext_name, int32(x))
}

func (EnvoyFilter_PatchContext) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 1}
}

// Action refers to the route action taken by Envoy when a http route matches.
type EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action int32

const (
	// All three route actions
	EnvoyFilter_RouteConfigurationMatch_RouteMatch_ANY EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action = 0
	// Route traffic to a cluster / weighted clusters.
	EnvoyFilter_RouteConfigurationMatch_RouteMatch_ROUTE EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action = 1
	// Redirect request.
	EnvoyFilter_RouteConfigurationMatch_RouteMatch_REDIRECT EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action = 2
	// directly respond to a request with specific payload.
	EnvoyFilter_RouteConfigurationMatch_RouteMatch_DIRECT_RESPONSE EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action = 3
)

var EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action_name = map[int32]string{
	0: "ANY",
	1: "ROUTE",
	2: "REDIRECT",
	3: "DIRECT_RESPONSE",
}

var EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action_value = map[string]int32{
	"ANY":             0,
	"ROUTE":           1,
	"REDIRECT":        2,
	"DIRECT_RESPONSE": 3,
}

func (x EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action) String() string {
	return proto.EnumName(EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action_name, int32(x))
}

func (EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 2, 0, 0}
}

// Operation denotes how the patch should be applied to the selected
// configuration.
type EnvoyFilter_Patch_Operation int32

const (
	EnvoyFilter_Patch_INVALID EnvoyFilter_Patch_Operation = 0
	// Merge the provided config with the generated config using
	// proto merge semantics. If you are specifying config in its
	// entirity, use `REPLACE` instead.
	EnvoyFilter_Patch_MERGE EnvoyFilter_Patch_Operation = 1
	// Add the provided config to an existing list (of listeners,
	// clusters, virtual hosts, network filters, or http
	// filters). This operation will be ignored when `applyTo` is set
	// to `ROUTE_CONFIGURATION`, or `HTTP_ROUTE`.
	EnvoyFilter_Patch_ADD EnvoyFilter_Patch_Operation = 2
	// Remove the selected object from the list (of listeners,
	// clusters, virtual hosts, network filters, routes, or http
	// filters). Does not require a value to be specified. This
	// operation will be ignored when `applyTo` is set to
	// `ROUTE_CONFIGURATION`, or `HTTP_ROUTE`.
	EnvoyFilter_Patch_REMOVE EnvoyFilter_Patch_Operation = 3
	// Insert operation on an array of named objects. This operation
	// is typically useful only in the context of filters or routes,
	// where the order of elements matter. Routes should be ordered
	// based on most to least specific matching criteria since the
	// first matching element is selected. For clusters and virtual hosts,
	// order of the element in the array does not matter. Insert
	// before the selected filter or sub filter. If no filter is
	// selected, the specified filter will be inserted at the front
	// of the list.
	EnvoyFilter_Patch_INSERT_BEFORE EnvoyFilter_Patch_Operation = 4
	// Insert operation on an array of named objects. This operation
	// is typically useful only in the context of filters or routes,
	// where the order of elements matter. Routes should be ordered
	// based on most to least specific matching criteria since the
	// first matching element is selected. For clusters and virtual hosts,
	// order of the element in the array does not matter. Insert
	// after the selected filter or sub filter. If no filter is
	// selected, the specified filter will be inserted at the end
	// of the list.
	EnvoyFilter_Patch_INSERT_AFTER EnvoyFilter_Patch_Operation = 5
	// Insert operation on an array of named objects. This operation
	// is typically useful only in the context of filters or routes,
	// where the order of elements matter. Routes should be ordered
	// based on most to least specific matching criteria since the
	// first matching element is selected. For clusters and virtual hosts,
	// order of the element in the array does not matter. Insert
	// first in the list based on the presence of selected filter or not.
	// This is specifically useful when you want your filter first in the
	// list based on a match condition specified in Match clause.
	EnvoyFilter_Patch_INSERT_FIRST EnvoyFilter_Patch_Operation = 6
	// Replace contents of a named filter with new contents.
	// `REPLACE` operation is only valid for `HTTP_FILTER` and
	// `NETWORK_FILTER`. If the named filter is not found, this operation
	// has no effect.
	EnvoyFilter_Patch_REPLACE EnvoyFilter_Patch_Operation = 7
)

var EnvoyFilter_Patch_Operation_name = map[int32]string{
	0: "INVALID",
	1: "MERGE",
	2: "ADD",
	3: "REMOVE",
	4: "INSERT_BEFORE",
	5: "INSERT_AFTER",
	6: "INSERT_FIRST",
	7: "REPLACE",
}

var EnvoyFilter_Patch_Operation_value = map[string]int32{
	"INVALID":       0,
	"MERGE":         1,
	"ADD":           2,
	"REMOVE":        3,
	"INSERT_BEFORE": 4,
	"INSERT_AFTER":  5,
	"INSERT_FIRST":  6,
	"REPLACE":       7,
}

func (x EnvoyFilter_Patch_Operation) String() string {
	return proto.EnumName(EnvoyFilter_Patch_Operation_name, int32(x))
}

func (EnvoyFilter_Patch_Operation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 4, 0}
}

// FilterClass determines the filter insertion point in the filter chain
// relative to the filters implicitly inserted by the control plane.
// It is used in conjuction with the `ADD` operation.
// This is the preferred insertion mechanism for adding filters over
// the `INSERT_*` operations since those operations rely on potentially unstable
// filter names.
// Filter ordering is important if your filter depends on or affects the
// functioning of a another filter in the filter chain.
// Within a filter class, filters are inserted in the order of processing.
type EnvoyFilter_Patch_FilterClass int32

const (
	// Control plane decides where to insert the filter.
	// Do not specify `FilterClass` if the filter is independent of others.
	EnvoyFilter_Patch_UNSPECIFIED EnvoyFilter_Patch_FilterClass = 0
	// Insert filter after Istio authentication filters.
	EnvoyFilter_Patch_AUTHN EnvoyFilter_Patch_FilterClass = 1
	// Insert filter after Istio authorization filters.
	EnvoyFilter_Patch_AUTHZ EnvoyFilter_Patch_FilterClass = 2
	// Insert filter before Istio stats filters.
	EnvoyFilter_Patch_STATS EnvoyFilter_Patch_FilterClass = 3
)

var EnvoyFilter_Patch_FilterClass_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "AUTHN",
	2: "AUTHZ",
	3: "STATS",
}

var EnvoyFilter_Patch_FilterClass_value = map[string]int32{
	"UNSPECIFIED": 0,
	"AUTHN":       1,
	"AUTHZ":       2,
	"STATS":       3,
}

func (x EnvoyFilter_Patch_FilterClass) String() string {
	return proto.EnumName(EnvoyFilter_Patch_FilterClass_name, int32(x))
}

func (EnvoyFilter_Patch_FilterClass) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 4, 1}
}

// EnvoyFilter provides a mechanism to customize the Envoy configuration
// generated by Istio Pilot.
//
// <!-- crd generation tags
// +cue-gen:EnvoyFilter:groupName:networking.istio.io
// +cue-gen:EnvoyFilter:version:v1alpha3
// +cue-gen:EnvoyFilter:storageVersion
// +cue-gen:EnvoyFilter:annotations:helm.sh/resource-policy=keep
// +cue-gen:EnvoyFilter:labels:app=istio-pilot,chart=istio,heritage=Tiller,release=istio
// +cue-gen:EnvoyFilter:subresource:status
// +cue-gen:EnvoyFilter:scope:Namespaced
// +cue-gen:EnvoyFilter:resource:categories=istio-io,networking-istio-io
// +cue-gen:EnvoyFilter:preserveUnknownFields:true
// -->
//
// <!-- go code generation tags
// +kubetype-gen
// +kubetype-gen:groupVersion=networking.istio.io/v1alpha3
// +genclient
// +k8s:deepcopy-gen=true
// -->
type EnvoyFilter struct {
	// Criteria used to select the specific set of pods/VMs on which
	// this patch configuration should be applied. If omitted, the set
	// of patches in this configuration will be applied to all workload
	// instances in the same namespace.  If omitted, the `EnvoyFilter`
	// patches will be applied to all workloads in the same
	// namespace. If the `EnvoyFilter` is present in the config root
	// namespace, it will be applied to all applicable workloads in any
	// namespace.
	WorkloadSelector *WorkloadSelector `protobuf:"bytes,3,opt,name=workload_selector,json=workloadSelector,proto3" json:"workload_selector,omitempty"`
	// One or more patches with match conditions.
	ConfigPatches        []*EnvoyFilter_EnvoyConfigObjectPatch `protobuf:"bytes,4,rep,name=config_patches,json=configPatches,proto3" json:"config_patches,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *EnvoyFilter) Reset()         { *m = EnvoyFilter{} }
func (m *EnvoyFilter) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter) ProtoMessage()    {}
func (*EnvoyFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0}
}
func (m *EnvoyFilter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter.Merge(m, src)
}
func (m *EnvoyFilter) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter proto.InternalMessageInfo

func (m *EnvoyFilter) GetWorkloadSelector() *WorkloadSelector {
	if m != nil {
		return m.WorkloadSelector
	}
	return nil
}

func (m *EnvoyFilter) GetConfigPatches() []*EnvoyFilter_EnvoyConfigObjectPatch {
	if m != nil {
		return m.ConfigPatches
	}
	return nil
}

// One or more properties of the proxy to match on.
type EnvoyFilter_ProxyMatch struct {
	// A regular expression in golang regex format (RE2) that can be
	// used to select proxies using a specific version of istio
	// proxy. The Istio version for a given proxy is obtained from the
	// node metadata field `ISTIO_VERSION` supplied by the proxy when
	// connecting to Pilot. This value is embedded as an environment
	// variable (`ISTIO_META_ISTIO_VERSION`) in the Istio proxy docker
	// image. Custom proxy implementations should provide this metadata
	// variable to take advantage of the Istio version check option.
	ProxyVersion string `protobuf:"bytes,1,opt,name=proxy_version,json=proxyVersion,proto3" json:"proxy_version,omitempty"`
	// Match on the node metadata supplied by a proxy when connecting
	// to Istio Pilot. Note that while Envoy's node metadata is of
	// type Struct, only string key-value pairs are processed by
	// Pilot. All keys specified in the metadata must match with exact
	// values. The match will fail if any of the specified keys are
	// absent or the values fail to match.
	Metadata             map[string]string `protobuf:"bytes,2,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *EnvoyFilter_ProxyMatch) Reset()         { *m = EnvoyFilter_ProxyMatch{} }
func (m *EnvoyFilter_ProxyMatch) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter_ProxyMatch) ProtoMessage()    {}
func (*EnvoyFilter_ProxyMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 0}
}
func (m *EnvoyFilter_ProxyMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_ProxyMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_ProxyMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_ProxyMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_ProxyMatch.Merge(m, src)
}
func (m *EnvoyFilter_ProxyMatch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_ProxyMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_ProxyMatch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_ProxyMatch proto.InternalMessageInfo

func (m *EnvoyFilter_ProxyMatch) GetProxyVersion() string {
	if m != nil {
		return m.ProxyVersion
	}
	return ""
}

func (m *EnvoyFilter_ProxyMatch) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// Conditions specified in `ClusterMatch` must be met for the patch
// to be applied to a cluster.
type EnvoyFilter_ClusterMatch struct {
	// The service port for which this cluster was generated.  If
	// omitted, applies to clusters for any port.
	PortNumber uint32 `protobuf:"varint,1,opt,name=port_number,json=portNumber,proto3" json:"port_number,omitempty"`
	// The fully qualified service name for this cluster. If omitted,
	// applies to clusters for any service. For services defined
	// through service entries, the service name is same as the hosts
	// defined in the service entry.
	Service string `protobuf:"bytes,2,opt,name=service,proto3" json:"service,omitempty"`
	// The subset associated with the service. If omitted, applies to
	// clusters for any subset of a service.
	Subset string `protobuf:"bytes,3,opt,name=subset,proto3" json:"subset,omitempty"`
	// The exact name of the cluster to match. To match a specific
	// cluster by name, such as the internally generated `Passthrough`
	// cluster, leave all fields in clusterMatch empty, except the
	// name.
	Name                 string   `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EnvoyFilter_ClusterMatch) Reset()         { *m = EnvoyFilter_ClusterMatch{} }
func (m *EnvoyFilter_ClusterMatch) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter_ClusterMatch) ProtoMessage()    {}
func (*EnvoyFilter_ClusterMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 1}
}
func (m *EnvoyFilter_ClusterMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_ClusterMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_ClusterMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_ClusterMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_ClusterMatch.Merge(m, src)
}
func (m *EnvoyFilter_ClusterMatch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_ClusterMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_ClusterMatch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_ClusterMatch proto.InternalMessageInfo

func (m *EnvoyFilter_ClusterMatch) GetPortNumber() uint32 {
	if m != nil {
		return m.PortNumber
	}
	return 0
}

func (m *EnvoyFilter_ClusterMatch) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

func (m *EnvoyFilter_ClusterMatch) GetSubset() string {
	if m != nil {
		return m.Subset
	}
	return ""
}

func (m *EnvoyFilter_ClusterMatch) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Conditions specified in RouteConfigurationMatch must be met for
// the patch to be applied to a route configuration object or a
// specific virtual host within the route configuration.
type EnvoyFilter_RouteConfigurationMatch struct {
	// The service port number or gateway server port number for which
	// this route configuration was generated. If omitted, applies to
	// route configurations for all ports.
	PortNumber uint32 `protobuf:"varint,1,opt,name=port_number,json=portNumber,proto3" json:"port_number,omitempty"`
	// Applicable only for GATEWAY context. The gateway server port
	// name for which this route configuration was generated.
	PortName string `protobuf:"bytes,2,opt,name=port_name,json=portName,proto3" json:"port_name,omitempty"`
	// The Istio gateway config's namespace/name for which this route
	// configuration was generated. Applies only if the context is
	// GATEWAY. Should be in the namespace/name format. Use this field
	// in conjunction with the `portNumber` and `portName` to accurately
	// select the Envoy route configuration for a specific HTTPS
	// server within a gateway config object.
	Gateway string `protobuf:"bytes,3,opt,name=gateway,proto3" json:"gateway,omitempty"`
	// Match a specific virtual host in a route configuration and
	// apply the patch to the virtual host.
	Vhost *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch `protobuf:"bytes,4,opt,name=vhost,proto3" json:"vhost,omitempty"`
	// Route configuration name to match on. Can be used to match a
	// specific route configuration by name, such as the internally
	// generated `http_proxy` route configuration for all sidecars.
	Name                 string   `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EnvoyFilter_RouteConfigurationMatch) Reset()         { *m = EnvoyFilter_RouteConfigurationMatch{} }
func (m *EnvoyFilter_RouteConfigurationMatch) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter_RouteConfigurationMatch) ProtoMessage()    {}
func (*EnvoyFilter_RouteConfigurationMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 2}
}
func (m *EnvoyFilter_RouteConfigurationMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_RouteConfigurationMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_RouteConfigurationMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_RouteConfigurationMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_RouteConfigurationMatch.Merge(m, src)
}
func (m *EnvoyFilter_RouteConfigurationMatch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_RouteConfigurationMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_RouteConfigurationMatch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_RouteConfigurationMatch proto.InternalMessageInfo

func (m *EnvoyFilter_RouteConfigurationMatch) GetPortNumber() uint32 {
	if m != nil {
		return m.PortNumber
	}
	return 0
}

func (m *EnvoyFilter_RouteConfigurationMatch) GetPortName() string {
	if m != nil {
		return m.PortName
	}
	return ""
}

func (m *EnvoyFilter_RouteConfigurationMatch) GetGateway() string {
	if m != nil {
		return m.Gateway
	}
	return ""
}

func (m *EnvoyFilter_RouteConfigurationMatch) GetVhost() *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch {
	if m != nil {
		return m.Vhost
	}
	return nil
}

func (m *EnvoyFilter_RouteConfigurationMatch) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Match a specific route inside a virtual host in a route configuration.
type EnvoyFilter_RouteConfigurationMatch_RouteMatch struct {
	// The Route objects generated by default are named as
	// default.  Route objects generated using a virtual service
	// will carry the name used in the virtual service's HTTP
	// routes.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Match a route with specific action type.
	Action               EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action `protobuf:"varint,2,opt,name=action,proto3,enum=istio.networking.v1alpha3.EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action" json:"action,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                              `json:"-"`
	XXX_unrecognized     []byte                                                `json:"-"`
	XXX_sizecache        int32                                                 `json:"-"`
}

func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) Reset() {
	*m = EnvoyFilter_RouteConfigurationMatch_RouteMatch{}
}
func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) String() string {
	return proto.CompactTextString(m)
}
func (*EnvoyFilter_RouteConfigurationMatch_RouteMatch) ProtoMessage() {}
func (*EnvoyFilter_RouteConfigurationMatch_RouteMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 2, 0}
}
func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_RouteConfigurationMatch_RouteMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_RouteConfigurationMatch_RouteMatch.Merge(m, src)
}
func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_RouteConfigurationMatch_RouteMatch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_RouteConfigurationMatch_RouteMatch proto.InternalMessageInfo

func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) GetAction() EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action {
	if m != nil {
		return m.Action
	}
	return EnvoyFilter_RouteConfigurationMatch_RouteMatch_ANY
}

// Match a specific virtual host inside a route configuration.
type EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch struct {
	// The VirtualHosts objects generated by Istio are named as
	// host:port, where the host typically corresponds to the
	// VirtualService's host field or the hostname of a service in the
	// registry.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Match a specific route within the virtual host.
	Route                *EnvoyFilter_RouteConfigurationMatch_RouteMatch `protobuf:"bytes,2,opt,name=route,proto3" json:"route,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                        `json:"-"`
	XXX_unrecognized     []byte                                          `json:"-"`
	XXX_sizecache        int32                                           `json:"-"`
}

func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) Reset() {
	*m = EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch{}
}
func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) String() string {
	return proto.CompactTextString(m)
}
func (*EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) ProtoMessage() {}
func (*EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 2, 1}
}
func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch.Merge(m, src)
}
func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch proto.InternalMessageInfo

func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) GetRoute() *EnvoyFilter_RouteConfigurationMatch_RouteMatch {
	if m != nil {
		return m.Route
	}
	return nil
}

// Conditions specified in a listener match must be met for the
// patch to be applied to a specific listener across all filter
// chains, or a specific filter chain inside the listener.
type EnvoyFilter_ListenerMatch struct {
	// The service port/gateway port to which traffic is being
	// sent/received. If not specified, matches all listeners. Even though
	// inbound listeners are generated for the instance/pod ports, only
	// service ports should be used to match listeners.
	PortNumber uint32 `protobuf:"varint,1,opt,name=port_number,json=portNumber,proto3" json:"port_number,omitempty"`
	// Instead of using specific port numbers, a set of ports matching
	// a given service's port name can be selected. Matching is case
	// insensitive.
	// Not implemented.
	// $hide_from_docs
	PortName string `protobuf:"bytes,2,opt,name=port_name,json=portName,proto3" json:"port_name,omitempty"`
	// Match a specific filter chain in a listener. If specified, the
	// patch will be applied to the filter chain (and a specific
	// filter if specified) and not to other filter chains in the
	// listener.
	FilterChain *EnvoyFilter_ListenerMatch_FilterChainMatch `protobuf:"bytes,3,opt,name=filter_chain,json=filterChain,proto3" json:"filter_chain,omitempty"`
	// Match a specific listener by its name. The listeners generated
	// by Pilot are typically named as IP:Port.
	Name                 string   `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EnvoyFilter_ListenerMatch) Reset()         { *m = EnvoyFilter_ListenerMatch{} }
func (m *EnvoyFilter_ListenerMatch) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter_ListenerMatch) ProtoMessage()    {}
func (*EnvoyFilter_ListenerMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 3}
}
func (m *EnvoyFilter_ListenerMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_ListenerMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_ListenerMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_ListenerMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_ListenerMatch.Merge(m, src)
}
func (m *EnvoyFilter_ListenerMatch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_ListenerMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_ListenerMatch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_ListenerMatch proto.InternalMessageInfo

func (m *EnvoyFilter_ListenerMatch) GetPortNumber() uint32 {
	if m != nil {
		return m.PortNumber
	}
	return 0
}

func (m *EnvoyFilter_ListenerMatch) GetPortName() string {
	if m != nil {
		return m.PortName
	}
	return ""
}

func (m *EnvoyFilter_ListenerMatch) GetFilterChain() *EnvoyFilter_ListenerMatch_FilterChainMatch {
	if m != nil {
		return m.FilterChain
	}
	return nil
}

func (m *EnvoyFilter_ListenerMatch) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// For listeners with multiple filter chains (e.g., inbound
// listeners on sidecars with permissive mTLS, gateway listeners
// with multiple SNI matches), the filter chain match can be used
// to select a specific filter chain to patch.
type EnvoyFilter_ListenerMatch_FilterChainMatch struct {
	// The name assigned to the filter chain.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The SNI value used by a filter chain's match condition.  This
	// condition will evaluate to false if the filter chain has no
	// sni match.
	Sni string `protobuf:"bytes,2,opt,name=sni,proto3" json:"sni,omitempty"`
	// Applies only to `SIDECAR_INBOUND` context. If non-empty, a
	// transport protocol to consider when determining a filter
	// chain match.  This value will be compared against the
	// transport protocol of a new connection, when it's detected by
	// the `tls_inspector` listener filter.
	//
	// Accepted values include:
	//
	// * `raw_buffer` - default, used when no transport protocol is detected.
	// * `tls` - set when TLS protocol is detected by the TLS inspector.
	TransportProtocol string `protobuf:"bytes,3,opt,name=transport_protocol,json=transportProtocol,proto3" json:"transport_protocol,omitempty"`
	// Applies only to sidecars. If non-empty, a comma separated set
	// of application protocols to consider when determining a
	// filter chain match.  This value will be compared against the
	// application protocols of a new connection, when it's detected
	// by one of the listener filters such as the `http_inspector`.
	//
	// Accepted values include: h2, http/1.1, http/1.0
	ApplicationProtocols string `protobuf:"bytes,4,opt,name=application_protocols,json=applicationProtocols,proto3" json:"application_protocols,omitempty"`
	// The name of a specific filter to apply the patch to. Set this
	// to `envoy.filters.network.http_connection_manager` to add a filter or apply a
	// patch to the HTTP connection manager.
	Filter               *EnvoyFilter_ListenerMatch_FilterMatch `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                               `json:"-"`
	XXX_unrecognized     []byte                                 `json:"-"`
	XXX_sizecache        int32                                  `json:"-"`
}

func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) Reset() {
	*m = EnvoyFilter_ListenerMatch_FilterChainMatch{}
}
func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) String() string {
	return proto.CompactTextString(m)
}
func (*EnvoyFilter_ListenerMatch_FilterChainMatch) ProtoMessage() {}
func (*EnvoyFilter_ListenerMatch_FilterChainMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 3, 0}
}
func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_ListenerMatch_FilterChainMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_ListenerMatch_FilterChainMatch.Merge(m, src)
}
func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_ListenerMatch_FilterChainMatch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_ListenerMatch_FilterChainMatch proto.InternalMessageInfo

func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) GetSni() string {
	if m != nil {
		return m.Sni
	}
	return ""
}

func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) GetTransportProtocol() string {
	if m != nil {
		return m.TransportProtocol
	}
	return ""
}

func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) GetApplicationProtocols() string {
	if m != nil {
		return m.ApplicationProtocols
	}
	return ""
}

func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) GetFilter() *EnvoyFilter_ListenerMatch_FilterMatch {
	if m != nil {
		return m.Filter
	}
	return nil
}

// Conditions to match a specific filter within a filter chain.
type EnvoyFilter_ListenerMatch_FilterMatch struct {
	// The filter name to match on.
	// For standard Envoy filters, [canonical filter](https://www.envoyproxy.io/docs/envoy/latest/version_history/v1.14.0#deprecated)
	// names should be used.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The next level filter within this filter to match
	// upon. Typically used for HTTP Connection Manager filters and
	// Thrift filters.
	SubFilter            *EnvoyFilter_ListenerMatch_SubFilterMatch `protobuf:"bytes,2,opt,name=sub_filter,json=subFilter,proto3" json:"sub_filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                  `json:"-"`
	XXX_unrecognized     []byte                                    `json:"-"`
	XXX_sizecache        int32                                     `json:"-"`
}

func (m *EnvoyFilter_ListenerMatch_FilterMatch) Reset()         { *m = EnvoyFilter_ListenerMatch_FilterMatch{} }
func (m *EnvoyFilter_ListenerMatch_FilterMatch) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter_ListenerMatch_FilterMatch) ProtoMessage()    {}
func (*EnvoyFilter_ListenerMatch_FilterMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 3, 1}
}
func (m *EnvoyFilter_ListenerMatch_FilterMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_ListenerMatch_FilterMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_ListenerMatch_FilterMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_ListenerMatch_FilterMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_ListenerMatch_FilterMatch.Merge(m, src)
}
func (m *EnvoyFilter_ListenerMatch_FilterMatch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_ListenerMatch_FilterMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_ListenerMatch_FilterMatch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_ListenerMatch_FilterMatch proto.InternalMessageInfo

func (m *EnvoyFilter_ListenerMatch_FilterMatch) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EnvoyFilter_ListenerMatch_FilterMatch) GetSubFilter() *EnvoyFilter_ListenerMatch_SubFilterMatch {
	if m != nil {
		return m.SubFilter
	}
	return nil
}

// Conditions to match a specific filter within another
// filter. This field is typically useful to match a HTTP filter
// inside the `envoy.filters.network.http_connection_manager` network filter.
// This could also be applicable for thrift filters.
type EnvoyFilter_ListenerMatch_SubFilterMatch struct {
	// The filter name to match on.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) Reset() {
	*m = EnvoyFilter_ListenerMatch_SubFilterMatch{}
}
func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter_ListenerMatch_SubFilterMatch) ProtoMessage()    {}
func (*EnvoyFilter_ListenerMatch_SubFilterMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 3, 2}
}
func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_ListenerMatch_SubFilterMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_ListenerMatch_SubFilterMatch.Merge(m, src)
}
func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_ListenerMatch_SubFilterMatch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_ListenerMatch_SubFilterMatch proto.InternalMessageInfo

func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Patch specifies how the selected object should be modified.
type EnvoyFilter_Patch struct {
	// Determines how the patch should be applied.
	Operation EnvoyFilter_Patch_Operation `protobuf:"varint,1,opt,name=operation,proto3,enum=istio.networking.v1alpha3.EnvoyFilter_Patch_Operation" json:"operation,omitempty"`
	// The JSON config of the object being patched. This will be merged using
	// proto merge semantics with the existing proto in the path.
	Value *types.Struct `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Determines the filter insertion order.
	FilterClass          EnvoyFilter_Patch_FilterClass `protobuf:"varint,3,opt,name=filter_class,json=filterClass,proto3,enum=istio.networking.v1alpha3.EnvoyFilter_Patch_FilterClass" json:"filter_class,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *EnvoyFilter_Patch) Reset()         { *m = EnvoyFilter_Patch{} }
func (m *EnvoyFilter_Patch) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter_Patch) ProtoMessage()    {}
func (*EnvoyFilter_Patch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 4}
}
func (m *EnvoyFilter_Patch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_Patch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_Patch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_Patch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_Patch.Merge(m, src)
}
func (m *EnvoyFilter_Patch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_Patch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_Patch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_Patch proto.InternalMessageInfo

func (m *EnvoyFilter_Patch) GetOperation() EnvoyFilter_Patch_Operation {
	if m != nil {
		return m.Operation
	}
	return EnvoyFilter_Patch_INVALID
}

func (m *EnvoyFilter_Patch) GetValue() *types.Struct {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *EnvoyFilter_Patch) GetFilterClass() EnvoyFilter_Patch_FilterClass {
	if m != nil {
		return m.FilterClass
	}
	return EnvoyFilter_Patch_UNSPECIFIED
}

// One or more match conditions to be met before a patch is applied
// to the generated configuration for a given proxy.
type EnvoyFilter_EnvoyConfigObjectMatch struct {
	// The specific config generation context to match on. Istio Pilot
	// generates envoy configuration in the context of a gateway,
	// inbound traffic to sidecar and outbound traffic from sidecar.
	Context EnvoyFilter_PatchContext `protobuf:"varint,1,opt,name=context,proto3,enum=istio.networking.v1alpha3.EnvoyFilter_PatchContext" json:"context,omitempty"`
	// Match on properties associated with a proxy.
	Proxy *EnvoyFilter_ProxyMatch `protobuf:"bytes,2,opt,name=proxy,proto3" json:"proxy,omitempty"`
	// Types that are valid to be assigned to ObjectTypes:
	//	*EnvoyFilter_EnvoyConfigObjectMatch_Listener
	//	*EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration
	//	*EnvoyFilter_EnvoyConfigObjectMatch_Cluster
	ObjectTypes          isEnvoyFilter_EnvoyConfigObjectMatch_ObjectTypes `protobuf_oneof:"object_types"`
	XXX_NoUnkeyedLiteral struct{}                                         `json:"-"`
	XXX_unrecognized     []byte                                           `json:"-"`
	XXX_sizecache        int32                                            `json:"-"`
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch) Reset()         { *m = EnvoyFilter_EnvoyConfigObjectMatch{} }
func (m *EnvoyFilter_EnvoyConfigObjectMatch) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter_EnvoyConfigObjectMatch) ProtoMessage()    {}
func (*EnvoyFilter_EnvoyConfigObjectMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 5}
}
func (m *EnvoyFilter_EnvoyConfigObjectMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_EnvoyConfigObjectMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_EnvoyConfigObjectMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_EnvoyConfigObjectMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_EnvoyConfigObjectMatch.Merge(m, src)
}
func (m *EnvoyFilter_EnvoyConfigObjectMatch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_EnvoyConfigObjectMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_EnvoyConfigObjectMatch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_EnvoyConfigObjectMatch proto.InternalMessageInfo

type isEnvoyFilter_EnvoyConfigObjectMatch_ObjectTypes interface {
	isEnvoyFilter_EnvoyConfigObjectMatch_ObjectTypes()
	MarshalTo([]byte) (int, error)
	Size() int
}

type EnvoyFilter_EnvoyConfigObjectMatch_Listener struct {
	Listener *EnvoyFilter_ListenerMatch `protobuf:"bytes,3,opt,name=listener,proto3,oneof"`
}
type EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration struct {
	RouteConfiguration *EnvoyFilter_RouteConfigurationMatch `protobuf:"bytes,4,opt,name=route_configuration,json=routeConfiguration,proto3,oneof"`
}
type EnvoyFilter_EnvoyConfigObjectMatch_Cluster struct {
	Cluster *EnvoyFilter_ClusterMatch `protobuf:"bytes,5,opt,name=cluster,proto3,oneof"`
}

func (*EnvoyFilter_EnvoyConfigObjectMatch_Listener) isEnvoyFilter_EnvoyConfigObjectMatch_ObjectTypes() {
}
func (*EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration) isEnvoyFilter_EnvoyConfigObjectMatch_ObjectTypes() {
}
func (*EnvoyFilter_EnvoyConfigObjectMatch_Cluster) isEnvoyFilter_EnvoyConfigObjectMatch_ObjectTypes() {
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch) GetObjectTypes() isEnvoyFilter_EnvoyConfigObjectMatch_ObjectTypes {
	if m != nil {
		return m.ObjectTypes
	}
	return nil
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch) GetContext() EnvoyFilter_PatchContext {
	if m != nil {
		return m.Context
	}
	return EnvoyFilter_ANY
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch) GetProxy() *EnvoyFilter_ProxyMatch {
	if m != nil {
		return m.Proxy
	}
	return nil
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch) GetListener() *EnvoyFilter_ListenerMatch {
	if x, ok := m.GetObjectTypes().(*EnvoyFilter_EnvoyConfigObjectMatch_Listener); ok {
		return x.Listener
	}
	return nil
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch) GetRouteConfiguration() *EnvoyFilter_RouteConfigurationMatch {
	if x, ok := m.GetObjectTypes().(*EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration); ok {
		return x.RouteConfiguration
	}
	return nil
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch) GetCluster() *EnvoyFilter_ClusterMatch {
	if x, ok := m.GetObjectTypes().(*EnvoyFilter_EnvoyConfigObjectMatch_Cluster); ok {
		return x.Cluster
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*EnvoyFilter_EnvoyConfigObjectMatch) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*EnvoyFilter_EnvoyConfigObjectMatch_Listener)(nil),
		(*EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration)(nil),
		(*EnvoyFilter_EnvoyConfigObjectMatch_Cluster)(nil),
	}
}

// Changes to be made to various envoy config objects.
type EnvoyFilter_EnvoyConfigObjectPatch struct {
	// Specifies where in the Envoy configuration, the patch should be
	// applied.  The match is expected to select the appropriate
	// object based on applyTo.  For example, an applyTo with
	// `HTTP_FILTER` is expected to have a match condition on the
	// listeners, with a network filter selection on
	// `envoy.filters.network.http_connection_manager` and a sub filter selection on the
	// HTTP filter relative to which the insertion should be
	// performed. Similarly, an applyTo on `CLUSTER` should have a match
	// (if provided) on the cluster and not on a listener.
	ApplyTo EnvoyFilter_ApplyTo `protobuf:"varint,1,opt,name=apply_to,json=applyTo,proto3,enum=istio.networking.v1alpha3.EnvoyFilter_ApplyTo" json:"apply_to,omitempty"`
	// Match on listener/route configuration/cluster.
	Match *EnvoyFilter_EnvoyConfigObjectMatch `protobuf:"bytes,2,opt,name=match,proto3" json:"match,omitempty"`
	// The patch to apply along with the operation.
	Patch                *EnvoyFilter_Patch `protobuf:"bytes,3,opt,name=patch,proto3" json:"patch,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *EnvoyFilter_EnvoyConfigObjectPatch) Reset()         { *m = EnvoyFilter_EnvoyConfigObjectPatch{} }
func (m *EnvoyFilter_EnvoyConfigObjectPatch) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter_EnvoyConfigObjectPatch) ProtoMessage()    {}
func (*EnvoyFilter_EnvoyConfigObjectPatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 6}
}
func (m *EnvoyFilter_EnvoyConfigObjectPatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_EnvoyConfigObjectPatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_EnvoyConfigObjectPatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_EnvoyConfigObjectPatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_EnvoyConfigObjectPatch.Merge(m, src)
}
func (m *EnvoyFilter_EnvoyConfigObjectPatch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_EnvoyConfigObjectPatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_EnvoyConfigObjectPatch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_EnvoyConfigObjectPatch proto.InternalMessageInfo

func (m *EnvoyFilter_EnvoyConfigObjectPatch) GetApplyTo() EnvoyFilter_ApplyTo {
	if m != nil {
		return m.ApplyTo
	}
	return EnvoyFilter_INVALID
}

func (m *EnvoyFilter_EnvoyConfigObjectPatch) GetMatch() *EnvoyFilter_EnvoyConfigObjectMatch {
	if m != nil {
		return m.Match
	}
	return nil
}

func (m *EnvoyFilter_EnvoyConfigObjectPatch) GetPatch() *EnvoyFilter_Patch {
	if m != nil {
		return m.Patch
	}
	return nil
}

func init() {
	proto.RegisterEnum("istio.networking.v1alpha3.EnvoyFilter_ApplyTo", EnvoyFilter_ApplyTo_name, EnvoyFilter_ApplyTo_value)
	proto.RegisterEnum("istio.networking.v1alpha3.EnvoyFilter_PatchContext", EnvoyFilter_PatchContext_name, EnvoyFilter_PatchContext_value)
	proto.RegisterEnum("istio.networking.v1alpha3.EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action", EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action_name, EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action_value)
	proto.RegisterEnum("istio.networking.v1alpha3.EnvoyFilter_Patch_Operation", EnvoyFilter_Patch_Operation_name, EnvoyFilter_Patch_Operation_value)
	proto.RegisterEnum("istio.networking.v1alpha3.EnvoyFilter_Patch_FilterClass", EnvoyFilter_Patch_FilterClass_name, EnvoyFilter_Patch_FilterClass_value)
	proto.RegisterType((*EnvoyFilter)(nil), "istio.networking.v1alpha3.EnvoyFilter")
	proto.RegisterType((*EnvoyFilter_ProxyMatch)(nil), "istio.networking.v1alpha3.EnvoyFilter.ProxyMatch")
	proto.RegisterMapType((map[string]string)(nil), "istio.networking.v1alpha3.EnvoyFilter.ProxyMatch.MetadataEntry")
	proto.RegisterType((*EnvoyFilter_ClusterMatch)(nil), "istio.networking.v1alpha3.EnvoyFilter.ClusterMatch")
	proto.RegisterType((*EnvoyFilter_RouteConfigurationMatch)(nil), "istio.networking.v1alpha3.EnvoyFilter.RouteConfigurationMatch")
	proto.RegisterType((*EnvoyFilter_RouteConfigurationMatch_RouteMatch)(nil), "istio.networking.v1alpha3.EnvoyFilter.RouteConfigurationMatch.RouteMatch")
	proto.RegisterType((*EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch)(nil), "istio.networking.v1alpha3.EnvoyFilter.RouteConfigurationMatch.VirtualHostMatch")
	proto.RegisterType((*EnvoyFilter_ListenerMatch)(nil), "istio.networking.v1alpha3.EnvoyFilter.ListenerMatch")
	proto.RegisterType((*EnvoyFilter_ListenerMatch_FilterChainMatch)(nil), "istio.networking.v1alpha3.EnvoyFilter.ListenerMatch.FilterChainMatch")
	proto.RegisterType((*EnvoyFilter_ListenerMatch_FilterMatch)(nil), "istio.networking.v1alpha3.EnvoyFilter.ListenerMatch.FilterMatch")
	proto.RegisterType((*EnvoyFilter_ListenerMatch_SubFilterMatch)(nil), "istio.networking.v1alpha3.EnvoyFilter.ListenerMatch.SubFilterMatch")
	proto.RegisterType((*EnvoyFilter_Patch)(nil), "istio.networking.v1alpha3.EnvoyFilter.Patch")
	proto.RegisterType((*EnvoyFilter_EnvoyConfigObjectMatch)(nil), "istio.networking.v1alpha3.EnvoyFilter.EnvoyConfigObjectMatch")
	proto.RegisterType((*EnvoyFilter_EnvoyConfigObjectPatch)(nil), "istio.networking.v1alpha3.EnvoyFilter.EnvoyConfigObjectPatch")
}

func init() {
	proto.RegisterFile("networking/v1alpha3/envoy_filter.proto", fileDescriptor_16d9b2922bd3e4a9)
}

var fileDescriptor_16d9b2922bd3e4a9 = []byte{
	// 1346 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x57, 0x4d, 0x6f, 0xdb, 0x46,
	0x13, 0x36, 0xf5, 0x61, 0x49, 0x23, 0x59, 0xde, 0xac, 0xf3, 0x26, 0x8e, 0xde, 0x22, 0x71, 0xdd,
	0xa2, 0x08, 0xd0, 0x46, 0x46, 0xe4, 0xa2, 0x08, 0x5a, 0xb4, 0x29, 0x2d, 0xd3, 0x16, 0x53, 0x9b,
	0x14, 0x96, 0x94, 0xf3, 0x75, 0x20, 0x28, 0x7a, 0x6d, 0xb3, 0xa1, 0x49, 0x95, 0xa4, 0x9c, 0x08,
	0xe8, 0xb5, 0xe8, 0xa1, 0x7f, 0xa4, 0x7f, 0xa1, 0xf7, 0x1e, 0x0a, 0xf4, 0xd2, 0x63, 0x8f, 0x41,
	0x7e, 0x42, 0x0f, 0x3d, 0xf5, 0x50, 0xec, 0x07, 0x25, 0x39, 0x51, 0x02, 0x39, 0xe9, 0x6d, 0xf7,
	0xd9, 0x9d, 0x87, 0xcf, 0xec, 0xcc, 0xce, 0x2c, 0xe1, 0xa3, 0x90, 0xa6, 0x4f, 0xa3, 0xf8, 0x89,
	0x1f, 0x1e, 0x6f, 0x9c, 0xdd, 0x76, 0x83, 0xc1, 0x89, 0xbb, 0xb9, 0x41, 0xc3, 0xb3, 0x68, 0xe4,
	0x1c, 0xf9, 0x41, 0x4a, 0xe3, 0xe6, 0x20, 0x8e, 0xd2, 0x08, 0x5f, 0xf3, 0x93, 0xd4, 0x8f, 0x9a,
	0x93, 0xdd, 0xcd, 0x6c, 0x77, 0xe3, 0xc6, 0x71, 0x14, 0x1d, 0x07, 0x74, 0xc3, 0x1d, 0xf8, 0x1b,
	0x47, 0x3e, 0x0d, 0x0e, 0x9d, 0x3e, 0x3d, 0x71, 0xcf, 0xfc, 0x48, 0xda, 0x36, 0xde, 0x93, 0x1b,
	0xf8, 0xac, 0x3f, 0x3c, 0xda, 0x48, 0xd2, 0x78, 0xe8, 0xa5, 0x72, 0xf5, 0xfd, 0x59, 0x0a, 0x12,
	0xff, 0x90, 0x7a, 0xae, 0x24, 0x58, 0xff, 0xe9, 0x1a, 0x54, 0x35, 0xa6, 0x69, 0x87, 0x4b, 0xc2,
	0x0f, 0xe0, 0x12, 0xb3, 0x08, 0x22, 0xf7, 0xd0, 0x49, 0x68, 0x40, 0xbd, 0x34, 0x8a, 0x57, 0xf3,
	0x6b, 0xca, 0xcd, 0x6a, 0xeb, 0xe3, 0xe6, 0x6b, 0x85, 0x36, 0xef, 0x4b, 0x1b, 0x4b, 0x9a, 0x10,
	0xf4, 0xf4, 0x25, 0x04, 0xfb, 0x50, 0xf7, 0xa2, 0xf0, 0xc8, 0x3f, 0x76, 0x06, 0x6e, 0xea, 0x9d,
	0xd0, 0x64, 0xb5, 0xb0, 0x96, 0xbf, 0x59, 0x6d, 0x7d, 0xf9, 0x06, 0xda, 0x29, 0x65, 0x62, 0xdc,
	0xe6, 0x0c, 0x66, 0xff, 0x5b, 0xea, 0xa5, 0x5d, 0x46, 0xb3, 0x95, 0x7f, 0xae, 0xe6, 0xc8, 0x92,
	0x60, 0xee, 0x0a, 0xe2, 0xc6, 0xef, 0x0a, 0x40, 0x37, 0x8e, 0x9e, 0x8d, 0xf6, 0x19, 0x80, 0x3f,
	0x80, 0xa5, 0x01, 0x9b, 0x39, 0x67, 0x34, 0x4e, 0xfc, 0x28, 0x5c, 0x55, 0xd6, 0x94, 0x9b, 0x15,
	0x52, 0xe3, 0xe0, 0x81, 0xc0, 0xf0, 0x63, 0x28, 0x9f, 0xd2, 0xd4, 0x3d, 0x74, 0x53, 0x77, 0x35,
	0xc7, 0x85, 0xdd, 0x9d, 0x53, 0xd8, 0xe4, 0x4b, 0xcd, 0x7d, 0xc9, 0xa0, 0x85, 0x69, 0x3c, 0x22,
	0x63, 0xc2, 0xc6, 0x17, 0xb0, 0x74, 0x6e, 0x09, 0x23, 0xc8, 0x3f, 0xa1, 0x23, 0x29, 0x84, 0x0d,
	0xf1, 0x65, 0x28, 0x9e, 0xb9, 0xc1, 0x90, 0xae, 0xe6, 0x38, 0x26, 0x26, 0x9f, 0xe7, 0xee, 0x28,
	0x8d, 0x21, 0xd4, 0xda, 0xc1, 0x30, 0x49, 0x69, 0x2c, 0xdc, 0xb9, 0x01, 0xd5, 0x41, 0x14, 0xa7,
	0x4e, 0x38, 0x3c, 0xed, 0xd3, 0x98, 0x73, 0x2c, 0x11, 0x60, 0x90, 0xc1, 0x11, 0xbc, 0x0a, 0xa5,
	0x84, 0xc6, 0x67, 0xbe, 0x97, 0x91, 0x65, 0x53, 0x7c, 0x05, 0x16, 0x93, 0x61, 0x3f, 0xa1, 0x29,
	0x0f, 0x69, 0x85, 0xc8, 0x19, 0xc6, 0x50, 0x08, 0xdd, 0x53, 0xba, 0x5a, 0xe0, 0x28, 0x1f, 0x37,
	0x7e, 0x2d, 0xc0, 0x55, 0x12, 0x0d, 0x53, 0x2a, 0xce, 0x7c, 0x18, 0xbb, 0xa9, 0x1f, 0x85, 0x73,
	0x4a, 0xf8, 0x3f, 0x54, 0xc4, 0x06, 0xc6, 0x2a, 0x44, 0x94, 0xf9, 0xb2, 0x7b, 0x4a, 0x99, 0xbe,
	0x63, 0x37, 0xa5, 0x4f, 0xdd, 0x91, 0x94, 0x91, 0x4d, 0x31, 0x85, 0xe2, 0xd9, 0x49, 0x94, 0xa4,
	0x5c, 0x48, 0xb5, 0x65, 0xce, 0x19, 0x81, 0xd7, 0xc8, 0x6c, 0x1e, 0xf8, 0x71, 0x3a, 0x74, 0x83,
	0x4e, 0x94, 0xa4, 0x1c, 0x20, 0x82, 0x7d, 0xec, 0x6e, 0x71, 0xca, 0x5d, 0x96, 0x33, 0x9c, 0x47,
	0x78, 0x98, 0x6d, 0x51, 0x26, 0x5b, 0xf0, 0x09, 0x2c, 0xba, 0x1e, 0x63, 0xe7, 0x1e, 0xd5, 0x5b,
	0xdd, 0x77, 0x94, 0x37, 0xf9, 0x5c, 0x53, 0xe5, 0xbc, 0x44, 0xf2, 0xaf, 0xdf, 0x85, 0x45, 0x81,
	0xe0, 0x12, 0xe4, 0x55, 0xe3, 0x21, 0x5a, 0xc0, 0x15, 0x28, 0x12, 0xb3, 0x67, 0x6b, 0x48, 0xc1,
	0x35, 0x28, 0x13, 0x6d, 0x5b, 0x27, 0x5a, 0xdb, 0x46, 0x39, 0xbc, 0x02, 0xcb, 0x62, 0xec, 0x10,
	0xcd, 0xea, 0x9a, 0x86, 0xa5, 0xa1, 0x7c, 0xe3, 0x47, 0x05, 0xd0, 0xcb, 0xde, 0xcf, 0xf4, 0xc9,
	0x81, 0x62, 0xcc, 0x64, 0x70, 0x97, 0xaa, 0x2d, 0xfd, 0x3f, 0x73, 0x89, 0x08, 0xde, 0xc6, 0x5f,
	0x05, 0x58, 0xda, 0xf3, 0x93, 0x94, 0x86, 0x73, 0xe7, 0xef, 0x1b, 0x93, 0xe7, 0x04, 0x6a, 0xa2,
	0x7a, 0x3a, 0xde, 0x89, 0xeb, 0x87, 0xb2, 0x36, 0x69, 0x73, 0xea, 0x3e, 0xa7, 0xa4, 0x29, 0xc0,
	0x36, 0xe3, 0x11, 0x9a, 0xab, 0x47, 0x13, 0x64, 0xe6, 0xa5, 0xf8, 0x5b, 0x01, 0xf4, 0xb2, 0xd5,
	0xcc, 0x73, 0x45, 0x90, 0x4f, 0x42, 0x5f, 0xaa, 0x67, 0x43, 0x7c, 0x0b, 0x70, 0x1a, 0xbb, 0x61,
	0xc2, 0x5d, 0xe3, 0xc5, 0xd7, 0x8b, 0x02, 0x79, 0x01, 0x2e, 0x8d, 0x57, 0xba, 0x72, 0x01, 0x6f,
	0xc2, 0xff, 0xdc, 0xc1, 0x20, 0xf0, 0x3d, 0x7e, 0xba, 0x63, 0x83, 0x44, 0xca, 0xb9, 0x3c, 0xb5,
	0x98, 0xd9, 0x24, 0xf8, 0x01, 0x2c, 0x0a, 0x0f, 0x78, 0x6a, 0x57, 0x5b, 0x5f, 0xbf, 0xc3, 0xb1,
	0x88, 0x13, 0x91, 0x7c, 0x8d, 0x1f, 0x14, 0xa8, 0x4e, 0xe1, 0x33, 0x7d, 0xee, 0x03, 0x24, 0xc3,
	0xbe, 0x6c, 0x6e, 0x32, 0xa1, 0xda, 0x6f, 0xa5, 0xc0, 0x1a, 0xf6, 0xa7, 0x45, 0x54, 0x92, 0x6c,
	0xde, 0xf8, 0x10, 0xea, 0xe7, 0x17, 0x67, 0x29, 0x69, 0xfc, 0x9c, 0x87, 0x22, 0x6f, 0x06, 0xd8,
	0x86, 0x4a, 0x34, 0xa0, 0x22, 0x45, 0xf9, 0x96, 0x7a, 0xeb, 0xb3, 0x79, 0xeb, 0x3a, 0x97, 0x62,
	0x66, 0xd6, 0x64, 0x42, 0x84, 0x6f, 0x4d, 0x17, 0xeb, 0x6a, 0xeb, 0x6a, 0x53, 0xb4, 0xe1, 0x66,
	0xd6, 0x86, 0x9b, 0x16, 0x6f, 0xc3, 0xb2, 0x8a, 0xe3, 0xc7, 0x93, 0x9c, 0x0d, 0xdc, 0x24, 0xe1,
	0x41, 0xaf, 0xb7, 0xee, 0x5c, 0x48, 0x87, 0xcc, 0x3a, 0x66, 0x3f, 0x4e, 0x53, 0x36, 0x59, 0xff,
	0x1e, 0x2a, 0x63, 0x8d, 0xb8, 0x0a, 0x25, 0xdd, 0x38, 0x50, 0xf7, 0xf4, 0x6d, 0x51, 0x32, 0xf6,
	0x35, 0xb2, 0xcb, 0x4a, 0x06, 0x2b, 0x23, 0xdb, 0xdb, 0x28, 0x87, 0x01, 0x16, 0x89, 0xb6, 0x6f,
	0x1e, 0x68, 0x28, 0x8f, 0x2f, 0xc1, 0x92, 0x6e, 0x58, 0x1a, 0xb1, 0x9d, 0x2d, 0x6d, 0xc7, 0x24,
	0x1a, 0x2a, 0x60, 0x04, 0x35, 0x09, 0xa9, 0x3b, 0xb6, 0x46, 0x50, 0x71, 0x0a, 0xd9, 0xd1, 0x89,
	0x65, 0xa3, 0x45, 0xf6, 0x0d, 0xa2, 0x75, 0xf7, 0xd4, 0xb6, 0x86, 0x4a, 0xeb, 0x77, 0xb3, 0xb4,
	0xe0, 0x62, 0xf0, 0x32, 0x54, 0x7b, 0x86, 0xd5, 0xd5, 0xda, 0xfa, 0x8e, 0xae, 0x49, 0x0d, 0x6a,
	0xcf, 0xee, 0x18, 0x48, 0xc9, 0x86, 0x8f, 0x50, 0x8e, 0x0d, 0x2d, 0x5b, 0xb5, 0x2d, 0x94, 0x6f,
	0xfc, 0x99, 0x87, 0x2b, 0xaf, 0xb4, 0x76, 0x11, 0xd9, 0x7d, 0x28, 0x79, 0x51, 0x98, 0xd2, 0x67,
	0xa9, 0x8c, 0xdc, 0xe6, 0x45, 0x4e, 0xac, 0x2d, 0x4c, 0x49, 0xc6, 0x81, 0x77, 0xa1, 0xc8, 0x3b,
	0xbe, 0x0c, 0xda, 0xed, 0x0b, 0xb7, 0x77, 0x22, 0xec, 0x31, 0x81, 0x72, 0x20, 0xd3, 0x55, 0x96,
	0x9f, 0x4f, 0xdf, 0x26, 0xcb, 0x3b, 0x0b, 0x64, 0xcc, 0x83, 0xbf, 0x83, 0x15, 0x5e, 0x2f, 0x1d,
	0x6f, 0xba, 0xa8, 0xca, 0x3e, 0xf8, 0xd5, 0xbb, 0x55, 0xe5, 0xce, 0x02, 0xc1, 0xf1, 0x2b, 0x4b,
	0xd8, 0x84, 0x92, 0x27, 0xde, 0x15, 0xb2, 0x5a, 0xcc, 0x7b, 0xbc, 0xd3, 0xaf, 0x91, 0xce, 0x02,
	0xc9, 0x58, 0xb6, 0xea, 0x50, 0x8b, 0x78, 0xf8, 0x9c, 0x74, 0x34, 0xa0, 0x49, 0xe3, 0x1f, 0x65,
	0x46, 0x68, 0xc5, 0xb5, 0xd4, 0xa1, 0xcc, 0x0a, 0xd8, 0xc8, 0x49, 0x23, 0x19, 0xdb, 0xe6, 0x9c,
	0x1f, 0x57, 0x99, 0x99, 0x1d, 0x91, 0x92, 0x2b, 0x06, 0xd8, 0x82, 0xe2, 0x29, 0xe3, 0x94, 0x61,
	0x7d, 0xeb, 0xe7, 0xa4, 0x0c, 0x31, 0xe7, 0xc2, 0x5b, 0x50, 0xe4, 0xaf, 0x54, 0x19, 0xdf, 0x4f,
	0x2e, 0x92, 0x78, 0x44, 0x98, 0xae, 0xff, 0xa2, 0x40, 0x49, 0xaa, 0x3d, 0x7f, 0x2f, 0x6b, 0x50,
	0xde, 0xd3, 0x2d, 0x5b, 0x33, 0x34, 0x82, 0x14, 0x76, 0xc1, 0x76, 0xf4, 0x3d, 0x5b, 0x23, 0x4e,
	0xbb, 0xa3, 0xea, 0x06, 0xca, 0x61, 0x0c, 0x75, 0x43, 0xb3, 0xef, 0x9b, 0xe4, 0x1b, 0x47, 0xac,
	0xa0, 0x3c, 0xbb, 0x58, 0x1d, 0xdb, 0xee, 0x66, 0x40, 0x01, 0x5f, 0x85, 0x15, 0xfe, 0x1e, 0x70,
	0xda, 0xa6, 0xb1, 0xa3, 0xef, 0xf6, 0x88, 0x6a, 0xeb, 0xa6, 0x21, 0x2e, 0xec, 0x81, 0x4e, 0xec,
	0x9e, 0xba, 0xe7, 0x74, 0x4c, 0x7e, 0x61, 0xeb, 0x00, 0xdc, 0x56, 0xbc, 0x1f, 0x4a, 0x4c, 0x4c,
	0x7b, 0xaf, 0x67, 0x31, 0x9e, 0x32, 0xbe, 0x0c, 0x48, 0x7b, 0x60, 0x6b, 0x86, 0xa5, 0x9b, 0x86,
	0xe4, 0x42, 0x95, 0x75, 0x13, 0x6a, 0xd3, 0x97, 0x68, 0xf2, 0x0c, 0x59, 0x81, 0x65, 0x4b, 0xdf,
	0xd6, 0xda, 0x2a, 0x71, 0x74, 0x63, 0xcb, 0xec, 0x19, 0xdb, 0x48, 0x61, 0x1c, 0x19, 0x68, 0xf6,
	0x6c, 0x81, 0xe6, 0xd8, 0x67, 0x76, 0x55, 0x5b, 0xbb, 0xaf, 0x3e, 0x44, 0xf9, 0x7b, 0x85, 0xb2,
	0x82, 0x72, 0xf7, 0x0a, 0xe5, 0x1c, 0xca, 0x93, 0x92, 0x28, 0x5f, 0x09, 0x59, 0x1e, 0xff, 0x6a,
	0x04, 0x6e, 0x9f, 0x06, 0xc9, 0x56, 0xf3, 0xb7, 0x17, 0xd7, 0x95, 0x3f, 0x5e, 0x5c, 0x57, 0x9e,
	0xbf, 0xb8, 0xae, 0x3c, 0x5a, 0x13, 0x87, 0xee, 0x47, 0xfc, 0xff, 0x67, 0xc6, 0xbf, 0x4c, 0x7f,
	0x91, 0x17, 0xdc, 0xcd, 0x7f, 0x03, 0x00, 0x00, 0xff, 0xff, 0x74, 0xa4, 0xa4, 0xaa, 0x6b, 0x0d,
	0x00, 0x00,
}

func (m *EnvoyFilter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ConfigPatches) > 0 {
		for iNdEx := len(m.ConfigPatches) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ConfigPatches[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if m.WorkloadSelector != nil {
		{
			size, err := m.WorkloadSelector.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_ProxyMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_ProxyMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_ProxyMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Metadata) > 0 {
		for k := range m.Metadata {
			v := m.Metadata[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ProxyVersion) > 0 {
		i -= len(m.ProxyVersion)
		copy(dAtA[i:], m.ProxyVersion)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.ProxyVersion)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_ClusterMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_ClusterMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_ClusterMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Subset) > 0 {
		i -= len(m.Subset)
		copy(dAtA[i:], m.Subset)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.Subset)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Service) > 0 {
		i -= len(m.Service)
		copy(dAtA[i:], m.Service)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.Service)))
		i--
		dAtA[i] = 0x12
	}
	if m.PortNumber != 0 {
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.PortNumber))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_RouteConfigurationMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_RouteConfigurationMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_RouteConfigurationMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Vhost != nil {
		{
			size, err := m.Vhost.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Gateway) > 0 {
		i -= len(m.Gateway)
		copy(dAtA[i:], m.Gateway)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.Gateway)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.PortName) > 0 {
		i -= len(m.PortName)
		copy(dAtA[i:], m.PortName)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.PortName)))
		i--
		dAtA[i] = 0x12
	}
	if m.PortNumber != 0 {
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.PortNumber))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Action != 0 {
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.Action))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Route != nil {
		{
			size, err := m.Route.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_ListenerMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_ListenerMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_ListenerMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x22
	}
	if m.FilterChain != nil {
		{
			size, err := m.FilterChain.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.PortName) > 0 {
		i -= len(m.PortName)
		copy(dAtA[i:], m.PortName)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.PortName)))
		i--
		dAtA[i] = 0x12
	}
	if m.PortNumber != 0 {
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.PortNumber))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Filter != nil {
		{
			size, err := m.Filter.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ApplicationProtocols) > 0 {
		i -= len(m.ApplicationProtocols)
		copy(dAtA[i:], m.ApplicationProtocols)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.ApplicationProtocols)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.TransportProtocol) > 0 {
		i -= len(m.TransportProtocol)
		copy(dAtA[i:], m.TransportProtocol)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.TransportProtocol)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Sni) > 0 {
		i -= len(m.Sni)
		copy(dAtA[i:], m.Sni)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.Sni)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_ListenerMatch_FilterMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_ListenerMatch_FilterMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_ListenerMatch_FilterMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.SubFilter != nil {
		{
			size, err := m.SubFilter.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_Patch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_Patch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_Patch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.FilterClass != 0 {
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.FilterClass))
		i--
		dAtA[i] = 0x18
	}
	if m.Value != nil {
		{
			size, err := m.Value.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Operation != 0 {
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.Operation))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ObjectTypes != nil {
		{
			size := m.ObjectTypes.Size()
			i -= size
			if _, err := m.ObjectTypes.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Proxy != nil {
		{
			size, err := m.Proxy.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Context != 0 {
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.Context))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch_Listener) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch_Listener) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Listener != nil {
		{
			size, err := m.Listener.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.RouteConfiguration != nil {
		{
			size, err := m.RouteConfiguration.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *EnvoyFilter_EnvoyConfigObjectMatch_Cluster) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch_Cluster) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Cluster != nil {
		{
			size, err := m.Cluster.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	return len(dAtA) - i, nil
}
func (m *EnvoyFilter_EnvoyConfigObjectPatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_EnvoyConfigObjectPatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvoyFilter_EnvoyConfigObjectPatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Patch != nil {
		{
			size, err := m.Patch.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Match != nil {
		{
			size, err := m.Match.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.ApplyTo != 0 {
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.ApplyTo))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintEnvoyFilter(dAtA []byte, offset int, v uint64) int {
	offset -= sovEnvoyFilter(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *EnvoyFilter) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.WorkloadSelector != nil {
		l = m.WorkloadSelector.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if len(m.ConfigPatches) > 0 {
		for _, e := range m.ConfigPatches {
			l = e.Size()
			n += 1 + l + sovEnvoyFilter(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_ProxyMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ProxyVersion)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if len(m.Metadata) > 0 {
		for k, v := range m.Metadata {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovEnvoyFilter(uint64(len(k))) + 1 + len(v) + sovEnvoyFilter(uint64(len(v)))
			n += mapEntrySize + 1 + sovEnvoyFilter(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_ClusterMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.PortNumber != 0 {
		n += 1 + sovEnvoyFilter(uint64(m.PortNumber))
	}
	l = len(m.Service)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	l = len(m.Subset)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_RouteConfigurationMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.PortNumber != 0 {
		n += 1 + sovEnvoyFilter(uint64(m.PortNumber))
	}
	l = len(m.PortName)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	l = len(m.Gateway)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.Vhost != nil {
		l = m.Vhost.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.Action != 0 {
		n += 1 + sovEnvoyFilter(uint64(m.Action))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.Route != nil {
		l = m.Route.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_ListenerMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.PortNumber != 0 {
		n += 1 + sovEnvoyFilter(uint64(m.PortNumber))
	}
	l = len(m.PortName)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.FilterChain != nil {
		l = m.FilterChain.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	l = len(m.Sni)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	l = len(m.TransportProtocol)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	l = len(m.ApplicationProtocols)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.Filter != nil {
		l = m.Filter.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_ListenerMatch_FilterMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.SubFilter != nil {
		l = m.SubFilter.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_Patch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Operation != 0 {
		n += 1 + sovEnvoyFilter(uint64(m.Operation))
	}
	if m.Value != nil {
		l = m.Value.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.FilterClass != 0 {
		n += 1 + sovEnvoyFilter(uint64(m.FilterClass))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != 0 {
		n += 1 + sovEnvoyFilter(uint64(m.Context))
	}
	if m.Proxy != nil {
		l = m.Proxy.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.ObjectTypes != nil {
		n += m.ObjectTypes.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_EnvoyConfigObjectMatch_Listener) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Listener != nil {
		l = m.Listener.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	return n
}
func (m *EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RouteConfiguration != nil {
		l = m.RouteConfiguration.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	return n
}
func (m *EnvoyFilter_EnvoyConfigObjectMatch_Cluster) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Cluster != nil {
		l = m.Cluster.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	return n
}
func (m *EnvoyFilter_EnvoyConfigObjectPatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ApplyTo != 0 {
		n += 1 + sovEnvoyFilter(uint64(m.ApplyTo))
	}
	if m.Match != nil {
		l = m.Match.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.Patch != nil {
		l = m.Patch.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovEnvoyFilter(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozEnvoyFilter(x uint64) (n int) {
	return sovEnvoyFilter(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *EnvoyFilter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EnvoyFilter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EnvoyFilter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkloadSelector", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkloadSelector == nil {
				m.WorkloadSelector = &WorkloadSelector{}
			}
			if err := m.WorkloadSelector.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConfigPatches", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ConfigPatches = append(m.ConfigPatches, &EnvoyFilter_EnvoyConfigObjectPatch{})
			if err := m.ConfigPatches[len(m.ConfigPatches)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_ProxyMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProxyMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProxyMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProxyVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowEnvoyFilter
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowEnvoyFilter
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthEnvoyFilter
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthEnvoyFilter
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowEnvoyFilter
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthEnvoyFilter
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthEnvoyFilter
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthEnvoyFilter
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Metadata[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_ClusterMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PortNumber", wireType)
			}
			m.PortNumber = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PortNumber |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Service", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Service = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subset", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subset = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_RouteConfigurationMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RouteConfigurationMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RouteConfigurationMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PortNumber", wireType)
			}
			m.PortNumber = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PortNumber |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PortName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PortName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gateway", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Gateway = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Vhost", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Vhost == nil {
				m.Vhost = &EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch{}
			}
			if err := m.Vhost.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_RouteConfigurationMatch_RouteMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RouteMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RouteMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			m.Action = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Action |= EnvoyFilter_RouteConfigurationMatch_RouteMatch_Action(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VirtualHostMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VirtualHostMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Route", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Route == nil {
				m.Route = &EnvoyFilter_RouteConfigurationMatch_RouteMatch{}
			}
			if err := m.Route.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_ListenerMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListenerMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListenerMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PortNumber", wireType)
			}
			m.PortNumber = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PortNumber |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PortName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PortName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilterChain", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FilterChain == nil {
				m.FilterChain = &EnvoyFilter_ListenerMatch_FilterChainMatch{}
			}
			if err := m.FilterChain.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_ListenerMatch_FilterChainMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FilterChainMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FilterChainMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sni", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sni = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransportProtocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TransportProtocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApplicationProtocols", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApplicationProtocols = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Filter == nil {
				m.Filter = &EnvoyFilter_ListenerMatch_FilterMatch{}
			}
			if err := m.Filter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_ListenerMatch_FilterMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FilterMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FilterMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubFilter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SubFilter == nil {
				m.SubFilter = &EnvoyFilter_ListenerMatch_SubFilterMatch{}
			}
			if err := m.SubFilter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_ListenerMatch_SubFilterMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SubFilterMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SubFilterMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_Patch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Patch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Patch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Operation", wireType)
			}
			m.Operation = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Operation |= EnvoyFilter_Patch_Operation(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Value == nil {
				m.Value = &types.Struct{}
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilterClass", wireType)
			}
			m.FilterClass = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FilterClass |= EnvoyFilter_Patch_FilterClass(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_EnvoyConfigObjectMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EnvoyConfigObjectMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EnvoyConfigObjectMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			m.Context = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Context |= EnvoyFilter_PatchContext(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Proxy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Proxy == nil {
				m.Proxy = &EnvoyFilter_ProxyMatch{}
			}
			if err := m.Proxy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Listener", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &EnvoyFilter_ListenerMatch{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ObjectTypes = &EnvoyFilter_EnvoyConfigObjectMatch_Listener{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RouteConfiguration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &EnvoyFilter_RouteConfigurationMatch{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ObjectTypes = &EnvoyFilter_EnvoyConfigObjectMatch_RouteConfiguration{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cluster", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &EnvoyFilter_ClusterMatch{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ObjectTypes = &EnvoyFilter_EnvoyConfigObjectMatch_Cluster{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_EnvoyConfigObjectPatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EnvoyConfigObjectPatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EnvoyConfigObjectPatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApplyTo", wireType)
			}
			m.ApplyTo = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ApplyTo |= EnvoyFilter_ApplyTo(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Match", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Match == nil {
				m.Match = &EnvoyFilter_EnvoyConfigObjectMatch{}
			}
			if err := m.Match.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Patch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Patch == nil {
				m.Patch = &EnvoyFilter_Patch{}
			}
			if err := m.Patch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipEnvoyFilter(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthEnvoyFilter
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthEnvoyFilter
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowEnvoyFilter
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipEnvoyFilter(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthEnvoyFilter
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthEnvoyFilter = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowEnvoyFilter   = fmt.Errorf("proto: integer overflow")
)
