/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1alpha1 "knative.dev/networking/pkg/apis/networking/v1alpha1"
	scheme "knative.dev/networking/pkg/client/clientset/versioned/scheme"
)

// RealmsGetter has a method to return a RealmInterface.
// A group's client should implement this interface.
type RealmsGetter interface {
	Realms() RealmInterface
}

// RealmInterface has methods to work with Realm resources.
type RealmInterface interface {
	Create(*v1alpha1.Realm) (*v1alpha1.Realm, error)
	Update(*v1alpha1.Realm) (*v1alpha1.Realm, error)
	UpdateStatus(*v1alpha1.Realm) (*v1alpha1.Realm, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.Realm, error)
	List(opts v1.ListOptions) (*v1alpha1.RealmList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.Realm, err error)
	RealmExpansion
}

// realms implements RealmInterface
type realms struct {
	client rest.Interface
}

// newRealms returns a Realms
func newRealms(c *NetworkingV1alpha1Client) *realms {
	return &realms{
		client: c.RESTClient(),
	}
}

// Get takes name of the realm, and returns the corresponding realm object, and an error if there is any.
func (c *realms) Get(name string, options v1.GetOptions) (result *v1alpha1.Realm, err error) {
	result = &v1alpha1.Realm{}
	err = c.client.Get().
		Resource("realms").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Realms that match those selectors.
func (c *realms) List(opts v1.ListOptions) (result *v1alpha1.RealmList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.RealmList{}
	err = c.client.Get().
		Resource("realms").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested realms.
func (c *realms) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("realms").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a realm and creates it.  Returns the server's representation of the realm, and an error, if there is any.
func (c *realms) Create(realm *v1alpha1.Realm) (result *v1alpha1.Realm, err error) {
	result = &v1alpha1.Realm{}
	err = c.client.Post().
		Resource("realms").
		Body(realm).
		Do().
		Into(result)
	return
}

// Update takes the representation of a realm and updates it. Returns the server's representation of the realm, and an error, if there is any.
func (c *realms) Update(realm *v1alpha1.Realm) (result *v1alpha1.Realm, err error) {
	result = &v1alpha1.Realm{}
	err = c.client.Put().
		Resource("realms").
		Name(realm.Name).
		Body(realm).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *realms) UpdateStatus(realm *v1alpha1.Realm) (result *v1alpha1.Realm, err error) {
	result = &v1alpha1.Realm{}
	err = c.client.Put().
		Resource("realms").
		Name(realm.Name).
		SubResource("status").
		Body(realm).
		Do().
		Into(result)
	return
}

// Delete takes name of the realm and deletes it. Returns an error if one occurs.
func (c *realms) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("realms").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *realms) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("realms").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched realm.
func (c *realms) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.Realm, err error) {
	result = &v1alpha1.Realm{}
	err = c.client.Patch(pt).
		Resource("realms").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
