package lttb

import (
	"reflect"
	"strconv"
	"testing"
)

func TestGolden(t *testing.T) {

	for i, v := range []int{10, 20, 50, 100, 200, 500, 1000, 2000} {

		t.Run(strconv.Itoa(v), func(t *testing.T) {
			points := LTTB(data, v)
			var downsampled [][2]float64
			for _, pp := range points {
				downsampled = append(downsampled, [2]float64{pp.X, pp.Y})
			}

			if !reflect.DeepEqual(downsampled, golden[i]) {
				t.Errorf("golden mismatch for downsample %d\ngot : %v\n want: %v", v, downsampled, golden[i])
			}
		})
	}
}

var golden = [][][2]float64{
	{{0, 29.357995947822218}, {594, 42.917712727399795}, {1042, 27.792537058477052}, {1721, 42.73710053588433}, {2074, 25.848284039508844}, {2583, 44.058494616358495}, {3275, 29.06160851755138}, {3910, 47.79168684198062}, {4663, 49.467384079074314}, {4999, 34.07622604782128}},
	{{0, 29.357995947822218}, {85, 24.75335912549342}, {429, 25.922770964698366}, {594, 42.917712727399795}, {887, 29.315297425726456}, {1195, 38.53261361058563}, {1413, 24.34074260607449}, {1721, 42.73710053588433}, {2074, 25.848284039508844}, {2497, 44.29101702903774}, {2758, 26.699917649004856}, {2966, 23.71814837085052}, {3217, 38.18103211360699}, {3497, 29.47070713463634}, {3871, 45.141313850266805}, {4133, 48.00314297086582}, {4433, 35.93959392178788}, {4661, 49.44973560609625}, {4721, 41.15180912858265}, {4999, 34.07622604782128}},
	{{0, 29.357995947822218}, {85, 24.75335912549342}, {122, 30.374496989862006}, {259, 25.78663848060838}, {317, 31.288951935975373}, {429, 25.922770964698366}, {594, 42.917712727399795}, {662, 35.88734753480093}, {770, 43.21939147903337}, {887, 29.315297425726456}, {960, 36.718644368420634}, {1042, 27.792537058477052}, {1195, 38.53261361058563}, {1280, 36.330656914157935}, {1372, 24.40430526113091}, {1485, 36.06846197316916}, {1614, 31.34160341506861}, {1721, 42.73710053588433}, {1843, 40.98904213311685}, {1894, 34.57305509209034}, {2074, 25.848284039508844}, {2121, 31.996984724582912}, {2229, 38.45249609002218}, {2303, 35.67840840680457}, {2497, 44.29101702903774}, {2583, 44.058494616358495}, {2621, 37.5842486836372}, {2778, 25.447443897366075}, {2879, 31.92180528432921}, {2966, 23.71814837085052}, {3035, 34.55394232184136}, {3217, 38.18103211360699}, {3275, 29.06160851755138}, {3418, 37.374869441323746}, {3461, 30.109943743087637}, {3643, 28.98075756334753}, {3729, 37.24781768842208}, {3766, 35.32968089985233}, {3910, 47.79168684198062}, {3962, 41.139227053508684}, {4133, 48.00314297086582}, {4178, 40.72846655122725}, {4346, 46.26785697686892}, {4414, 36.21992527315708}, {4529, 39.075001110176856}, {4661, 49.44973560609625}, {4699, 40.804558836186786}, {4840, 43.989916759215}, {4965, 33.18029169046981}, {4999, 34.07622604782128}},
	{{0, 29.357995947822218}, {8, 31.38899603525572}, {85, 24.75335912549342}, {122, 30.374496989862006}, {182, 26.061343714664623}, {205, 28.87895845286964}, {259, 25.78663848060838}, {330, 31.51994434827819}, {377, 26.564904718909652}, {429, 25.922770964698366}, {509, 36.91759867136517}, {556, 35.53756438274776}, {594, 42.917712727399795}, {648, 36.15953352691078}, {714, 40.43514365409954}, {740, 36.768283960686276}, {770, 43.21939147903337}, {837, 35.26479970268285}, {887, 29.315297425726456}, {960, 36.718644368420634}, {989, 29.709033348016842}, {1021, 34.16915786529838}, {1088, 29.252834071159857}, {1133, 36.90897436886569}, {1195, 38.53261361058563}, {1271, 36.248018614293784}, {1290, 32.607679572698984}, {1372, 24.40430526113091}, {1418, 24.6651943693905}, {1440, 30.862182502538953}, {1485, 36.06846197316916}, {1572, 35.65901988130965}, {1614, 31.34160341506861}, {1671, 32.39849660167694}, {1721, 42.73710053588433}, {1784, 38.0512977550727}, {1804, 41.59421552557119}, {1847, 37.531170184849564}, {1926, 37.82863560027054}, {1986, 34.69468439935647}, {2001, 29.32024170286219}, {2074, 25.848284039508844}, {2121, 31.996984724582912}, {2162, 29.808188744723488}, {2229, 38.45249609002218}, {2282, 33.48007351832354}, {2339, 39.768877736103605}, {2366, 36.94671668201051}, {2430, 37.20194861904684}, {2497, 44.29101702903774}, {2511, 39.95979151189301}, {2583, 44.058494616358495}, {2621, 37.5842486836372}, {2702, 35.587731051837416}, {2730, 28.61563883266229}, {2795, 25.111955575936644}, {2816, 28.496172416512515}, {2879, 31.92180528432921}, {2957, 24.034114487943505}, {3005, 26.263116669541553}, {3035, 34.55394232184136}, {3066, 29.42426454491802}, {3160, 30.967056835014755}, {3201, 37.68701715509432}, {3264, 31.640748236625246}, {3281, 29.070477635815827}, {3316, 34.21313709031122}, {3415, 37.19283547903976}, {3461, 30.109943743087637}, {3469, 31.965622730682476}, {3557, 33.94494214738513}, {3587, 30.14165312650818}, {3636, 35.32696073852328}, {3685, 30.1261971935347}, {3729, 37.24781768842208}, {3823, 38.445919893706396}, {3843, 43.97481631223127}, {3910, 47.79168684198062}, {3960, 41.190483201302776}, {4003, 45.332476785661704}, {4042, 40.40121722063858}, {4128, 47.83269632839022}, {4178, 40.72846655122725}, {4232, 46.07574947104996}, {4247, 43.08447818539749}, {4292, 46.60711089281704}, {4346, 46.26785697686892}, {4414, 36.21992527315708}, {4477, 37.4556569056629}, {4496, 40.71073257614338}, {4544, 39.967275063438045}, {4611, 42.02391206710711}, {4663, 49.467384079074314}, {4699, 40.804558836186786}, {4744, 44.52826323886761}, {4840, 43.989916759215}, {4867, 37.71021607139222}, {4897, 42.063060621486514}, {4965, 33.18029169046981}, {4999, 34.07622604782128}},
	{{0, 29.357995947822218}, {8, 31.38899603525572}, {49, 25.80790898978574}, {75, 28.576637206595993}, {85, 24.75335912549342}, {122, 30.374496989862006}, {130, 28.877260649054524}, {155, 29.942433471924208}, {182, 26.061343714664623}, {205, 28.87895845286964}, {233, 26.50503068257422}, {264, 25.880978465490344}, {298, 31.22392323854322}, {308, 29.11707721446215}, {330, 31.51994434827819}, {377, 26.564904718909652}, {392, 28.353947742891283}, {407, 25.78486318168484}, {452, 27.8971845311884}, {461, 31.03092246398632}, {483, 31.49429616322668}, {513, 37.943749079996564}, {550, 35.58380480655832}, {563, 38.33987731208528}, {594, 42.917712727399795}, {610, 39.198802516126015}, {648, 36.15953352691078}, {670, 38.198701944392226}, {705, 36.645909925459954}, {714, 40.43514365409954}, {740, 36.768283960686276}, {765, 43.00326844639773}, {793, 39.2299512438198}, {822, 39.84149848240294}, {837, 35.26479970268285}, {861, 36.11980562386126}, {887, 29.315297425726456}, {917, 33.50228160406862}, {953, 36.40171114341679}, {976, 31.360355110091252}, {989, 29.709033348016842}, {1013, 34.555509854599876}, {1042, 27.792537058477052}, {1066, 33.54826648297002}, {1088, 29.252834071159857}, {1133, 36.90897436886569}, {1156, 33.90560409554212}, {1164, 32.73740982908738}, {1193, 38.44788884052119}, {1231, 37.98350758652906}, {1248, 34.80315462413555}, {1280, 36.330656914157935}, {1290, 32.607679572698984}, {1313, 33.07070289905697}, {1357, 31.471490532081248}, {1372, 24.40430526113091}, {1397, 28.490364050694232}, {1418, 24.6651943693905}, {1440, 30.862182502538953}, {1485, 36.06846197316916}, {1500, 34.01906505065623}, {1520, 36.014438556584366}, {1553, 33.68659149830347}, {1572, 35.65901988130965}, {1607, 31.55600150552031}, {1638, 35.11945078307172}, {1665, 32.78927293361512}, {1683, 33.847057378024175}, {1694, 38.68369317469104}, {1721, 42.73710053588433}, {1765, 38.86948923485995}, {1784, 38.0512977550727}, {1804, 41.59421552557119}, {1824, 38.4982817921926}, {1843, 40.98904213311685}, {1873, 36.620496899833185}, {1918, 34.10174900420402}, {1926, 37.82863560027054}, {1963, 32.78020946544929}, {1980, 35.185492244262484}, {2001, 29.32024170286219}, {2034, 27.251995482961384}, {2049, 28.898451768426284}, {2074, 25.848284039508844}, {2096, 29.905243264397946}, {2122, 32.01819220164321}, {2162, 29.808188744723488}, {2182, 34.05607738376311}, {2208, 32.870015366666216}, {2229, 38.45249609002218}, {2265, 34.799856216789664}, {2282, 33.48007351832354}, {2309, 37.317285421916054}, {2339, 39.768877736103605}, {2366, 36.94671668201051}, {2383, 39.69431724624071}, {2403, 37.20884959153676}, {2440, 39.11691716267563}, {2473, 35.86422187859753}, {2491, 43.42510969518392}, {2511, 39.95979151189301}, {2526, 42.70557759253858}, {2564, 38.98058165621274}, {2583, 44.058494616358495}, {2621, 37.5842486836372}, {2640, 39.55798120001941}, {2659, 34.672906766786355}, {2700, 35.53420547926852}, {2718, 30.539601797884956}, {2730, 28.61563883266229}, {2766, 27.998508184180817}, {2795, 25.111955575936644}, {2816, 28.496172416512515}, {2852, 26.269936477378405}, {2875, 31.71938876522025}, {2895, 28.965028596965585}, {2910, 31.416675748910425}, {2939, 25.932006217741982}, {2966, 23.71814837085052}, {3003, 26.088631779268834}, {3028, 32.411088299325755}, {3035, 34.55394232184136}, {3066, 29.42426454491802}, {3092, 28.88512555430076}, {3115, 32.30837337558492}, {3140, 33.65570232797892}, {3167, 31.180181319988332}, {3194, 37.152845814499535}, {3217, 38.18103211360699}, {3245, 33.207146127232235}, {3275, 29.06160851755138}, {3297, 33.83571180198559}, {3318, 34.189075319669456}, {3340, 30.389128544023528}, {3377, 32.45224067089088}, {3393, 36.97802352361716}, {3418, 37.374869441323746}, {3449, 31.735215667970092}, {3462, 30.081678413940462}, {3497, 29.47070713463634}, {3518, 32.43271679812625}, {3557, 33.94494214738513}, {3581, 30.647189213101132}, {3607, 33.10476073358268}, {3632, 34.98860015194777}, {3643, 28.98075756334753}, {3685, 30.1261971935347}, {3705, 34.35768750096602}, {3729, 37.24781768842208}, {3736, 35.94802206870304}, {3766, 35.32968089985233}, {3803, 40.40447274896678}, {3823, 38.445919893706396}, {3843, 43.97481631223127}, {3868, 43.15798450802592}, {3910, 47.79168684198062}, {3919, 43.18101584512046}, {3962, 41.139227053508684}, {3977, 44.85103730540091}, {4004, 45.32599258516697}, {4025, 41.580902668274064}, {4043, 40.405347534544276}, {4065, 43.52840705131174}, {4096, 43.93629699159078}, {4133, 48.00314297086582}, {4160, 45.93018712100647}, {4178, 40.72846655122725}, {4215, 42.062223021469975}, {4232, 46.07574947104996}, {4247, 43.08447818539749}, {4274, 46.3349833461467}, {4295, 43.10115465773163}, {4324, 42.099203979340935}, {4344, 46.27972490525816}, {4382, 43.69386481163199}, {4414, 36.21992527315708}, {4423, 38.82569943174218}, {4458, 36.83626164610845}, {4468, 38.61705719495839}, {4517, 41.646176394626345}, {4529, 39.075001110176856}, {4568, 44.0470084423368}, {4579, 41.46655883593124}, {4611, 42.02391206710711}, {4626, 45.984997240186246}, {4663, 49.467384079074314}, {4683, 44.55687451719093}, {4699, 40.804558836186786}, {4727, 45.87658310035213}, {4766, 40.44563966701578}, {4772, 41.98448907911279}, {4802, 40.980911652896054}, {4840, 43.989916759215}, {4867, 37.71021607139222}, {4893, 42.65573412390896}, {4914, 38.70041746310922}, {4931, 39.74434633216348}, {4965, 33.18029169046981}, {4986, 35.471233571041964}, {4999, 34.07622604782128}},
	{{0, 29.357995947822218}, {8, 31.38899603525572}, {15, 29.54668002901058}, {26, 30.3711931235659}, {38, 30.013856636945924}, {49, 25.80790898978574}, {54, 27.28963669872412}, {61, 26.326019357967294}, {75, 28.576637206595993}, {85, 24.75335912549342}, {99, 25.318121919340044}, {106, 28.476933177720472}, {114, 29.266136201836588}, {122, 30.374496989862006}, {131, 29.100160763856657}, {143, 30.206305874273855}, {155, 29.942433471924208}, {163, 27.244815449582045}, {171, 27.941108395946074}, {182, 26.061343714664623}, {197, 28.693644963914128}, {210, 27.4034023213343}, {215, 28.955222450571647}, {227, 27.057357503159633}, {239, 26.50890594997075}, {248, 28.522618646129153}, {259, 25.78663848060838}, {266, 27.726596358113618}, {281, 26.617667215269847}, {283, 26.195989054524656}, {293, 30.70537467842703}, {308, 29.11707721446215}, {317, 31.288951935975373}, {323, 28.710256908027688}, {333, 31.007757592227232}, {345, 28.25734414947841}, {354, 29.943653842668887}, {362, 29.97536581410366}, {377, 26.564904718909652}, {390, 28.196204812447014}, {396, 28.13948170648531}, {407, 25.78486318168484}, {418, 28.011098852919908}, {427, 25.8834697613218}, {437, 29.462067517762534}, {445, 27.572194900322412}, {452, 27.8971845311884}, {462, 31.1306416649066}, {479, 31.218212979786024}, {488, 33.87564290993047}, {500, 34.099389551023904}, {509, 36.91759867136517}, {521, 35.238662967688704}, {526, 37.88944422270623}, {533, 36.98172720447497}, {549, 35.60660078018533}, {556, 35.53756438274776}, {563, 38.33987731208528}, {577, 38.55996270262097}, {586, 42.44197850928179}, {594, 42.917712727399795}, {610, 39.198802516126015}, {616, 42.56501744522036}, {623, 39.84656589770128}, {637, 37.47764070721714}, {646, 38.19873503550377}, {654, 36.12499971175383}, {670, 38.198701944392226}, {675, 36.526503465131775}, {688, 36.732765304609515}, {693, 38.65064301128746}, {705, 36.645909925459954}, {714, 40.43514365409954}, {731, 40.72045099279074}, {734, 37.190128597342806}, {749, 37.25181149353707}, {755, 41.2027128451164}, {770, 43.21939147903337}, {773, 41.96625047640962}, {792, 39.36239492015202}, {797, 40.08078557739916}, {809, 38.003564811967195}, {814, 39.82593927687213}, {828, 39.060815486719235}, {837, 35.26479970268285}, {852, 36.9122685068765}, {858, 35.23328368215224}, {873, 34.89082477498721}, {882, 30.11896242237412}, {887, 29.315297425726456}, {897, 31.69516453152183}, {911, 31.069356216279907}, {917, 33.50228160406862}, {931, 31.21936553988134}, {941, 31.57998061624259}, {953, 36.40171114341679}, {962, 36.58675202460727}, {967, 33.68329350874763}, {976, 31.360355110091252}, {989, 29.709033348016842}, {1002, 32.404705995647134}, {1013, 34.555509854599876}, {1016, 33.15444517016032}, {1025, 33.779257221704746}, {1042, 27.792537058477052}, {1046, 31.673417165689862}, {1054, 33.00087402494973}, {1066, 33.54826648297002}, {1075, 33.78768855190261}, {1088, 29.252834071159857}, {1101, 33.487267406897004}, {1110, 32.49004088753038}, {1115, 34.21219988578758}, {1133, 36.90897436886569}, {1144, 36.523711914237204}, {1149, 34.22551552384586}, {1164, 32.73740982908738}, {1166, 36.38448730256452}, {1181, 35.97470028204401}, {1185, 37.6485574658129}, {1195, 38.53261361058563}, {1205, 37.39010863231819}, {1220, 38.153189871670634}, {1228, 36.574577925568015}, {1237, 37.355020597223806}, {1248, 34.80315462413555}, {1255, 36.27186268761327}, {1265, 34.07163330273662}, {1280, 36.330656914157935}, {1290, 32.607679572698984}, {1300, 34.03662018610426}, {1308, 34.50821094970082}, {1315, 32.35364095869243}, {1326, 30.397821572277874}, {1339, 31.09586849152352}, {1347, 28.96213974116116}, {1357, 31.471490532081248}, {1365, 25.95144210780829}, {1377, 24.723127466527284}, {1391, 27.41659614028529}, {1399, 28.487368411327616}, {1413, 24.34074260607449}, {1423, 25.505668659821385}, {1433, 29.738295917981866}, {1440, 30.862182502538953}, {1451, 28.98662862990845}, {1463, 31.279393484956277}, {1474, 30.906433524045895}, {1485, 36.06846197316916}, {1489, 34.27429545432343}, {1504, 34.837013970080854}, {1514, 34.29076290991813}, {1520, 36.014438556584366}, {1533, 33.675446148880425}, {1545, 35.236518386423754}, {1553, 33.68659149830347}, {1558, 35.03821600965653}, {1572, 35.65901988130965}, {1581, 33.30095950674964}, {1594, 34.36417258641864}, {1600, 32.03520633056414}, {1614, 31.34160341506861}, {1618, 33.6696207424472}, {1631, 31.569967535436145}, {1638, 35.11945078307172}, {1647, 35.12923123083873}, {1656, 33.551479085175345}, {1671, 32.39849660167694}, {1683, 33.847057378024175}, {1689, 37.93153971576717}, {1706, 38.153737338484326}, {1716, 41.609581527655735}, {1721, 42.73710053588433}, {1728, 41.24861627279633}, {1740, 42.07661962525981}, {1754, 39.752239396736506}, {1765, 38.86948923485995}, {1775, 40.41694728495109}, {1784, 38.0512977550727}, {1796, 41.015089776340226}, {1804, 41.59421552557119}, {1808, 39.62606546104271}, {1824, 38.4982817921926}, {1828, 39.59936421761144}, {1843, 40.98904213311685}, {1847, 37.531170184849564}, {1864, 39.60131420080908}, {1873, 36.620496899833185}, {1882, 37.02130072401423}, {1894, 34.57305509209034}, {1897, 35.47101264307737}, {1912, 34.279540168694986}, {1922, 34.18838364564101}, {1927, 37.52980493319014}, {1944, 36.76798510268848}, {1951, 34.55133668610086}, {1964, 32.75918431846117}, {1971, 34.79011341612875}, {1986, 34.69468439935647}, {1988, 33.199535764838636}, {2001, 29.32024170286219}, {2009, 30.353380249710128}, {2024, 28.172545798424313}, {2034, 27.251995482961384}, {2039, 28.350786367009555}, {2049, 28.898451768426284}, {2062, 26.779917891194174}, {2074, 25.848284039508844}, {2078, 28.147220846160913}, {2089, 29.692597123031344}, {2098, 29.044952829872138}, {2114, 29.49100419801057}, {2121, 31.996984724582912}, {2128, 29.906138940448397}, {2140, 29.839193019325773}, {2157, 31.837154644201334}, {2162, 29.808188744723488}, {2176, 33.159103841393794}, {2182, 34.05607738376311}, {2193, 32.18858592278298}, {2201, 33.710578425275074}, {2214, 33.66791505848393}, {2220, 37.84817431115949}, {2229, 38.45249609002218}, {2239, 37.069212698488194}, {2250, 37.63036405693426}, {2259, 35.48805636280678}, {2269, 35.7847373835048}, {2282, 33.48007351832354}, {2292, 36.82497371024283}, {2303, 35.67840840680457}, {2309, 37.317285421916054}, {2323, 36.53900862036208}, {2332, 39.13171392966848}, {2339, 39.768877736103605}, {2356, 39.57233319093269}, {2366, 36.94671668201051}, {2369, 38.107005730339885}, {2383, 39.69431724624071}, {2391, 37.29737183692541}, {2403, 37.20884959153676}, {2416, 38.96954505622985}, {2426, 38.11238736059342}, {2430, 37.20194861904684}, {2440, 39.11691716267563}, {2457, 38.66797170791196}, {2461, 37.08263012999697}, {2473, 35.86422187859753}, {2481, 39.76987261793349}, {2497, 44.29101702903774}, {2502, 41.79435089000459}, {2512, 39.95821075474937}, {2522, 43.469996426408535}, {2537, 41.721596977396956}, {2545, 39.67254038329676}, {2555, 41.62699785722495}, {2564, 38.98058165621274}, {2571, 41.71741296575474}, {2583, 44.058494616358495}, {2597, 40.55335045136749}, {2604, 39.4574717226145}, {2610, 40.05829543634176}, {2622, 37.50572067949534}, {2637, 39.24100815688652}, {2647, 36.23295703793576}, {2653, 36.64494239211856}, {2660, 34.63171730160524}, {2677, 33.61921918842873}, {2680, 34.47612413434144}, {2691, 33.31758465582364}, {2702, 35.587731051837416}, {2718, 30.539601797884956}, {2726, 30.631386637749323}, {2730, 28.61563883266229}, {2743, 29.384319812035454}, {2757, 26.76662330440143}, {2766, 27.998508184180817}, {2778, 25.447443897366075}, {2790, 26.63041226276307}, {2795, 25.111955575936644}, {2807, 27.54190493767045}, {2813, 26.423373614090597}, {2822, 27.905344738574847}, {2838, 28.753984952852}, {2848, 26.392688537225578}, {2856, 28.41596094710675}, {2868, 27.83432934764762}, {2875, 31.71938876522025}, {2886, 29.472355419791427}, {2895, 28.965028596965585}, {2901, 31.460128657051456}, {2916, 30.968361747768547}, {2930, 29.022303006465368}, {2939, 25.932006217741982}, {2948, 27.072069424664924}, {2957, 24.034114487943505}, {2966, 23.71814837085052}, {2974, 26.312249087826}, {2990, 26.054077155633216}, {2991, 25.652831846415367}, {3005, 26.263116669541553}, {3017, 27.652745228165806}, {3028, 32.411088299325755}, {3035, 34.55394232184136}, {3049, 31.418578354753414}, {3059, 33.104577943842884}, {3062, 29.93908316497376}, {3079, 30.808812815476546}, {3091, 28.90734498274122}, {3099, 30.81125656901041}, {3109, 30.23362298145734}, {3115, 32.30837337558492}, {3128, 30.082238264022603}, {3140, 33.65570232797892}, {3147, 33.328724603980014}, {3154, 31.177003426608458}, {3167, 31.180181319988332}, {3172, 32.851230576948424}, {3186, 33.48014088578789}, {3194, 37.152845814499535}, {3211, 37.47601907379215}, {3217, 38.18103211360699}, {3222, 35.732925176029}, {3234, 36.19636620447901}, {3245, 33.207146127232235}, {3259, 33.54075000081999}, {3263, 31.758176393318287}, {3275, 29.06160851755138}, {3287, 32.72273350370443}, {3297, 33.83571180198559}, {3309, 32.842151272849485}, {3314, 34.3994082345058}, {3324, 31.212041654609635}, {3334, 32.234779372557384}, {3343, 30.56960911154055}, {3353, 31.09897337898735}, {3363, 33.26855777434632}, {3377, 32.45224067089088}, {3386, 33.01273553419829}, {3393, 36.97802352361716}, {3407, 34.68233052858934}, {3413, 37.17740333669563}, {3423, 35.66846294670802}, {3441, 34.877437006370286}, {3449, 31.735215667970092}, {3457, 33.25145744811404}, {3463, 30.071462139339655}, {3475, 31.65967766234796}, {3488, 30.560174724155342}, {3497, 29.47070713463634}, {3503, 31.469315701418683}, {3518, 32.43271679812625}, {3526, 30.082639749439995}, {3537, 32.98014017195333}, {3547, 31.549033274787455}, {3557, 33.94494214738513}, {3572, 33.012962884618574}, {3574, 31.491346373021337}, {3587, 30.14165312650818}, {3601, 32.560705734243456}, {3607, 33.10476073358268}, {3618, 30.67015361507686}, {3632, 34.98860015194777}, {3642, 29.121801087250198}, {3648, 31.88964085600857}, {3654, 30.39733248162421}, {3669, 30.057913986094512}, {3674, 31.47426930437642}, {3685, 30.1261971935347}, {3700, 31.62129391692174}, {3705, 34.35768750096602}, {3723, 34.32925786634385}, {3729, 37.24781768842208}, {3735, 35.86481428501773}, {3744, 36.911971103005506}, {3759, 37.44627314073198}, {3766, 35.32968089985233}, {3774, 38.457277972233115}, {3793, 37.87348574106414}, {3803, 40.40447274896678}, {3809, 39.07804466925928}, {3823, 38.445919893706396}, {3833, 41.25954776973257}, {3843, 43.97481631223127}, {3850, 41.89851060373508}, {3854, 43.00859290667485}, {3871, 45.141313850266805}, {3875, 43.98425210064129}, {3890, 44.64183638547881}, {3895, 46.69554397624657}, {3910, 47.79168684198062}, {3919, 43.18101584512046}, {3925, 43.711364180631804}, {3941, 42.368141211578596}, {3947, 43.67566420376484}, {3960, 41.190483201302776}, {3968, 43.53636550586511}, {3977, 44.85103730540091}, {3988, 43.39572733345793}, {3997, 45.20628655580068}, {4007, 45.03190754404627}, {4023, 42.28588980382473}, {4030, 42.88411017501612}, {4042, 40.40121722063858}, {4052, 43.376033472640444}, {4056, 44.35550220099082}, {4074, 42.579441010470354}, {4076, 44.21857842681485}, {4087, 43.49185769105879}, {4101, 45.228836061954944}, {4110, 46.058774601853955}, {4116, 44.766511487040916}, {4128, 47.83269632839022}, {4135, 44.90413846099235}, {4149, 46.36607159615689}, {4160, 45.93018712100647}, {4166, 43.32162929680021}, {4178, 40.72846655122725}, {4186, 42.55329890940964}, {4199, 41.991890779837725}, {4209, 43.19323932573483}, {4218, 41.59881716888323}, {4230, 45.88537683206737}, {4241, 46.07894808606258}, {4247, 43.08447818539749}, {4258, 44.779096753781424}, {4269, 44.30870396354328}, {4278, 46.30744653697344}, {4292, 46.60711089281704}, {4296, 43.384267987646375}, {4307, 44.24245012746741}, {4324, 42.099203979340935}, {4329, 44.8390211407645}, {4344, 46.27972490525816}, {4351, 44.05034495051119}, {4361, 44.4297999192324}, {4375, 42.16975466552083}, {4382, 43.69386481163199}, {4391, 39.38331357790885}, {4397, 40.49257098503543}, {4414, 36.21992527315708}, {4423, 38.82569943174218}, {4433, 35.93959392178788}, {4443, 38.21664941647024}, {4455, 37.09540108270616}, {4466, 38.730315146387746}, {4476, 37.423877674083585}, {4486, 38.13255323384495}, {4488, 39.74784443380604}, {4497, 40.614825837238605}, {4507, 39.85851159258621}, {4517, 41.646176394626345}, {4529, 39.075001110176856}, {4545, 40.042315039135865}, {4553, 41.90167025496052}, {4566, 43.86137004897719}, {4572, 44.14608921239006}, {4579, 41.46655883593124}, {4590, 42.13012135355233}, {4600, 41.53894095306525}, {4611, 42.02391206710711}, {4626, 45.984997240186246}, {4630, 44.651596037353286}, {4639, 46.97672701088541}, {4647, 46.10452178892155}, {4661, 49.44973560609625}, {4675, 48.92579198716452}, {4682, 44.72899549055614}, {4690, 44.77024206609575}, {4699, 40.804558836186786}, {4709, 42.978169988498536}, {4727, 45.87658310035213}, {4728, 43.6183451512828}, {4739, 42.53626377548142}, {4754, 44.60107183314088}, {4760, 41.15252150405892}, {4772, 41.98448907911279}, {4779, 40.66303052923502}, {4791, 41.8142881123724}, {4802, 40.980911652896054}, {4808, 42.70943804743709}, {4824, 41.21364184446058}, {4831, 43.55500018064631}, {4840, 43.989916759215}, {4856, 39.88125368753376}, {4867, 37.71021607139222}, {4873, 39.5198852558182}, {4878, 39.66661286220836}, {4893, 42.65573412390896}, {4902, 40.08190763242786}, {4909, 41.19823454109512}, {4920, 38.474735694735124}, {4931, 39.74434633216348}, {4942, 37.41788048991505}, {4949, 37.64359097418195}, {4960, 33.9039081124664}, {4977, 32.8267558087521}, {4986, 35.471233571041964}, {4998, 33.21364571883214}, {4999, 34.07622604782128}},
	{{0, 29.357995947822218}, {4, 30.7726859735917}, {8, 31.38899603525572}, {15, 29.54668002901058}, {18, 30.74066032317061}, {21, 30.057979182917986}, {27, 30.355932660992572}, {31, 29.16161297604625}, {38, 30.013856636945924}, {41, 28.103057873678374}, {49, 25.80790898978574}, {54, 27.28963669872412}, {59, 26.21938188318228}, {62, 27.592635104460253}, {66, 27.170789712751404}, {75, 28.576637206595993}, {76, 27.763715461946813}, {85, 24.75335912549342}, {88, 25.33621421606084}, {95, 26.448419417928317}, {99, 25.318121919340044}, {105, 27.45775156727039}, {109, 27.007320452528134}, {111, 28.669197835798027}, {117, 28.92417256867908}, {122, 30.374496989862006}, {130, 28.877260649054524}, {135, 29.875645922022283}, {136, 29.32336837740634}, {143, 30.206305874273855}, {148, 28.668390496723326}, {155, 29.942433471924208}, {157, 29.081114874079432}, {163, 27.244815449582045}, {167, 28.333335545414524}, {172, 27.155839334130572}, {177, 27.83845450366903}, {182, 26.061343714664623}, {186, 27.607455732128237}, {193, 27.052060260660955}, {197, 28.693644963914128}, {205, 28.87895845286964}, {207, 27.543826104728634}, {215, 28.955222450571647}, {219, 28.037741647416063}, {221, 28.411225526795217}, {227, 27.057357503159633}, {233, 26.50503068257422}, {236, 27.58607997646959}, {242, 27.206837899664286}, {248, 28.522618646129153}, {253, 26.815819408391537}, {259, 25.78663848060838}, {264, 25.880978465490344}, {266, 27.726596358113618}, {275, 27.032793497721116}, {279, 27.759761781417595}, {283, 26.195989054524656}, {287, 27.43948527543756}, {293, 30.70537467842703}, {298, 31.22392323854322}, {304, 31.025310612429436}, {308, 29.11707721446215}, {312, 30.193073601940906}, {317, 31.288951935975373}, {323, 28.710256908027688}, {330, 31.51994434827819}, {334, 29.912529162927882}, {340, 30.269814084876984}, {345, 28.25734414947841}, {350, 28.15110192590233}, {354, 29.943653842668887}, {356, 28.627878421859094}, {362, 29.97536581410366}, {367, 27.701450632319055}, {371, 28.04360951096915}, {377, 26.564904718909652}, {382, 27.3376969508508}, {386, 27.24426813335004}, {392, 28.353947742891283}, {399, 26.76664288679182}, {404, 27.037728660238816}, {407, 25.78486318168484}, {412, 27.226357547185447}, {418, 28.011098852919908}, {422, 26.710013475304418}, {427, 25.8834697613218}, {434, 26.68923906981248}, {437, 29.462067517762534}, {444, 27.568707173494055}, {446, 28.94876289646488}, {452, 27.8971845311884}, {458, 30.2987283695555}, {464, 31.302761670091414}, {466, 30.49414678626753}, {475, 31.402733294236572}, {479, 31.218212979786024}, {483, 31.49429616322668}, {488, 33.87564290993047}, {492, 33.57726370546161}, {496, 34.72554255082181}, {501, 34.22803109888905}, {509, 36.91759867136517}, {513, 37.943749079996564}, {519, 35.88305508619134}, {522, 35.204473848884604}, {526, 37.88944422270623}, {531, 36.83537718548058}, {536, 37.291084012425635}, {545, 36.754028252130254}, {549, 35.60660078018533}, {551, 36.15574897354542}, {556, 35.53756438274776}, {563, 38.33987731208528}, {568, 37.52932323225818}, {573, 39.30100206552399}, {577, 38.55996270262097}, {585, 41.84405324758257}, {586, 42.44197850928179}, {594, 42.917712727399795}, {596, 41.98001270512809}, {605, 39.65057441921113}, {610, 39.198802516126015}, {615, 42.31117692587696}, {617, 40.75017426985965}, {621, 39.799369403233875}, {627, 40.24059624379228}, {632, 39.6862655989382}, {637, 37.47764070721714}, {646, 38.19873503550377}, {648, 36.15953352691078}, {653, 36.50375344553345}, {661, 36.1345774586021}, {664, 37.494624894014834}, {670, 38.198701944392226}, {675, 36.526503465131775}, {678, 37.19943347657908}, {683, 37.71513970238973}, {688, 36.732765304609515}, {693, 38.65064301128746}, {698, 38.63409846835321}, {703, 36.598956314019325}, {709, 37.312534314076736}, {714, 40.43514365409954}, {717, 39.4239320658717}, {726, 39.42713453659046}, {731, 40.72045099279074}, {733, 37.63394119070095}, {740, 36.768283960686276}, {744, 37.65237108287256}, {749, 37.25181149353707}, {755, 41.2027128451164}, {761, 41.57431095381387}, {764, 42.943817792210965}, {770, 43.21939147903337}, {773, 41.96625047640962}, {778, 42.13720797898185}, {783, 41.84729249879647}, {787, 40.33193886547389}, {793, 39.2299512438198}, {797, 40.08078557739916}, {806, 38.62608414650186}, {809, 38.003564811967195}, {814, 39.82593927687213}, {819, 39.3691037472924}, {822, 39.84149848240294}, {831, 38.46243114268653}, {834, 35.65801215219413}, {839, 36.707855369730034}, {843, 36.175883792606705}, {847, 36.499637035175965}, {853, 36.84193719836966}, {858, 35.23328368215224}, {862, 35.987081872648865}, {870, 33.95310090031108}, {875, 34.818344629526955}, {877, 32.4461932776035}, {882, 30.11896242237412}, {887, 29.315297425726456}, {893, 31.19665096563887}, {897, 31.69516453152183}, {906, 31.952233276070345}, {911, 31.069356216279907}, {914, 32.88848724097737}, {921, 32.69683391724602}, {926, 33.576629314879405}, {931, 31.21936553988134}, {932, 32.02350301138198}, {941, 31.57998061624259}, {944, 33.57148226581986}, {948, 35.0394972266412}, {953, 36.40171114341679}, {961, 36.658954226071046}, {965, 35.92838317262612}, {967, 33.68329350874763}, {976, 31.360355110091252}, {980, 31.76928554942759}, {985, 30.369022511891757}, {989, 29.709033348016842}, {994, 30.269521765071406}, {1000, 31.925382030352395}, {1002, 32.404705995647134}, {1007, 32.06571185804976}, {1013, 34.555509854599876}, {1017, 33.25999551152861}, {1022, 33.91355886515464}, {1030, 33.398428332372106}, {1033, 31.58571790720343}, {1040, 32.71362639662142}, {1042, 27.792537058477052}, {1050, 32.72027856671056}, {1053, 33.19971370723099}, {1057, 32.30498262311541}, {1066, 33.54826648297002}, {1071, 32.27203157051601}, {1075, 33.78768855190261}, {1078, 31.147232293821737}, {1086, 31.118733218136573}, {1088, 29.252834071159857}, {1093, 30.161758590806624}, {1101, 33.487267406897004}, {1104, 32.50713483623776}, {1110, 32.49004088753038}, {1115, 34.21219988578758}, {1121, 33.60777850243776}, {1124, 35.08344176854378}, {1129, 34.9547553234651}, {1133, 36.90897436886569}, {1138, 36.15108571210806}, {1144, 36.523711914237204}, {1149, 34.22551552384586}, {1156, 33.90560409554212}, {1159, 35.459597394271825}, {1164, 32.73740982908738}, {1167, 35.69198792205293}, {1176, 36.68858364718202}, {1181, 35.97470028204401}, {1185, 37.6485574658129}, {1190, 37.60117292673316}, {1193, 38.44788884052119}, {1200, 38.28171670233931}, {1202, 37.469381149070585}, {1210, 38.20048604682538}, {1213, 37.85109980183144}, {1220, 38.153189871670634}, {1226, 37.24273013769576}, {1228, 36.574577925568015}, {1233, 37.87253628352105}, {1240, 35.569737001180215}, {1246, 36.7654190000416}, {1248, 34.80315462413555}, {1255, 36.27186268761327}, {1261, 34.705612847987084}, {1266, 34.061764136955}, {1271, 36.248018614293784}, {1275, 35.339226659095814}, {1280, 36.330656914157935}, {1285, 35.05450151673027}, {1290, 32.607679572698984}, {1297, 32.79448909601}, {1300, 34.03662018610426}, {1305, 33.486732091763336}, {1308, 34.50821094970082}, {1315, 32.35364095869243}, {1321, 32.01319521995405}, {1326, 30.397821572277874}, {1330, 30.762480629193092}, {1333, 30.401524153538364}, {1339, 31.09586849152352}, {1347, 28.96213974116116}, {1348, 30.094589411608464}, {1357, 31.471490532081248}, {1362, 29.0952884352307}, {1365, 25.95144210780829}, {1372, 24.40430526113091}, {1374, 24.868258110961357}, {1380, 25.403952465657824}, {1385, 25.184633998151693}, {1391, 27.41659614028529}, {1397, 28.490364050694232}, {1402, 27.75784788858771}, {1403, 26.388008503362745}, {1409, 25.928237301882948}, {1413, 24.34074260607449}, {1418, 24.6651943693905}, {1426, 26.031451433938873}, {1429, 28.12071488383503}, {1433, 29.738295917981866}, {1440, 30.862182502538953}, {1447, 30.164364772985248}, {1451, 28.98662862990845}, {1453, 29.70066010243845}, {1461, 29.757994213197602}, {1463, 31.279393484956277}, {1471, 30.890723656435668}, {1475, 31.094199381637562}, {1479, 34.1769485077606}, {1485, 36.06846197316916}, {1489, 34.27429545432343}, {1494, 34.691697874937915}, {1500, 34.01906505065623}, {1504, 34.837013970080854}, {1511, 34.1793952178106}, {1514, 34.29076290991813}, {1520, 36.014438556584366}, {1527, 35.58080982359661}, {1532, 33.77867219668047}, {1536, 33.83706673096555}, {1538, 34.67898341154741}, {1547, 35.51129848892317}, {1552, 33.831408529297455}, {1554, 34.76348070802675}, {1561, 34.05122520128333}, {1567, 35.10444315366103}, {1569, 34.56235394065422}, {1574, 35.43427648307305}, {1581, 33.30095950674964}, {1587, 33.25298440074963}, {1591, 33.77554531353173}, {1595, 34.31644882079321}, {1600, 32.03520633056414}, {1607, 31.55600150552031}, {1608, 32.275031428073206}, {1614, 31.34160341506861}, {1618, 33.6696207424472}, {1625, 31.745665996112034}, {1631, 31.569967535436145}, {1633, 32.930732352651475}, {1638, 35.11945078307172}, {1647, 35.12923123083873}, {1648, 34.19771898956377}, {1654, 33.54101912632574}, {1659, 33.914956135823154}, {1665, 32.78927293361512}, {1671, 32.39849660167694}, {1674, 33.73004210039798}, {1682, 33.78773476628623}, {1687, 35.40140497372611}, {1689, 37.93153971576717}, {1695, 38.79215511609461}, {1700, 39.16182425119748}, {1703, 38.24474852988975}, {1709, 38.18750466726223}, {1715, 41.3269897150344}, {1721, 42.73710053588433}, {1724, 41.92253556951924}, {1731, 42.17909911414902}, {1735, 41.22195929777421}, {1740, 42.07661962525981}, {1743, 40.958470191837534}, {1749, 41.017801824810185}, {1756, 39.55588740392734}, {1759, 40.39693575020464}, {1765, 38.86948923485995}, {1772, 38.83322167157176}, {1774, 40.33223301684341}, {1780, 40.57894081959218}, {1784, 38.0512977550727}, {1792, 38.82328669157878}, {1796, 41.015089776340226}, {1798, 40.53994999420047}, {1804, 41.59421552557119}, {1808, 39.62606546104271}, {1817, 38.77749075357144}, {1822, 38.63589451271645}, {1826, 39.59621160868451}, {1832, 39.71328630121623}, {1835, 38.74032920127892}, {1842, 41.006778236777826}, {1847, 37.531170184849564}, {1850, 38.64900610422957}, {1855, 38.46493433585336}, {1862, 39.532635843081685}, {1867, 38.15677220409511}, {1871, 38.39888830728324}, {1873, 36.620496899833185}, {1882, 37.02130072401423}, {1884, 35.989467257305485}, {1889, 36.23934542841747}, {1894, 34.57305509209034}, {1903, 35.37294264170206}, {1904, 34.459027714667855}, {1913, 35.1096803630126}, {1918, 34.10174900420402}, {1922, 34.18838364564101}, {1926, 37.82863560027054}, {1930, 37.11106227609642}, {1936, 37.33863802694112}, {1941, 36.62130515314802}, {1947, 36.28861461359311}, {1951, 34.55133668610086}, {1957, 35.63073140705392}, {1963, 32.78020946544929}, {1967, 35.25828074460553}, {1970, 34.12397376413126}, {1976, 34.83272344102554}, {1981, 33.550787666460536}, {1986, 34.69468439935647}, {1992, 32.1006804695537}, {1998, 31.004611604459708}, {2001, 29.32024170286219}, {2004, 30.117663632341145}, {2009, 30.353380249710128}, {2014, 29.207874497314503}, {2022, 29.54604416792868}, {2024, 28.172545798424313}, {2033, 27.367870148995426}, {2034, 27.251995482961384}, {2039, 28.350786367009555}, {2046, 27.771048205304385}, {2049, 28.898451768426284}, {2057, 28.531458363352172}, {2062, 26.779917891194174}, {2066, 27.399456700893154}, {2073, 26.840190037017013}, {2074, 25.848284039508844}, {2079, 28.116929624170805}, {2087, 29.665040474972592}, {2090, 28.981378296214995}, {2094, 29.957633494290146}, {2099, 29.266240445467794}, {2104, 29.95602684268363}, {2109, 29.56478041606059}, {2114, 29.49100419801057}, {2121, 31.996984724582912}, {2124, 30.096046165850005}, {2131, 30.820165055355577}, {2135, 29.643987595361455}, {2142, 31.25546101123808}, {2146, 30.170151295689198}, {2150, 31.31604954619179}, {2158, 31.806849694846097}, {2162, 29.808188744723488}, {2164, 30.606670887563382}, {2173, 30.99276274081928}, {2176, 33.159103841393794}, {2182, 34.05607738376311}, {2188, 33.94841513146962}, {2193, 32.18858592278298}, {2196, 33.33520209595963}, {2201, 33.710578425275074}, {2208, 32.870015366666216}, {2213, 33.579287468108}, {2217, 36.88357351027984}, {2220, 37.84817431115949}, {2228, 37.24084436632412}, {2229, 38.45249609002218}, {2234, 37.16649173849021}, {2243, 36.89130918063377}, {2245, 37.20202075141188}, {2250, 37.63036405693426}, {2258, 35.733553198879285}, {2263, 35.9725442605288}, {2265, 34.799856216789664}, {2269, 35.7847373835048}, {2275, 34.48805775061282}, {2282, 33.48007351832354}, {2286, 35.522962489940845}, {2292, 36.82497371024283}, {2296, 37.24345441577025}, {2299, 35.88555065526424}, {2307, 37.10057430482785}, {2313, 36.872868345401656}, {2318, 37.4312789350087}, {2323, 36.53900862036208}, {2324, 37.02861438655951}, {2332, 39.13171392966848}, {2338, 38.91508217017819}, {2339, 39.768877736103605}, {2345, 38.98575368659195}, {2351, 39.76991133023266}, {2354, 38.84802165134902}, {2361, 38.972137312472306}, {2366, 36.94671668201051}, {2369, 38.107005730339885}, {2377, 38.001562339346805}, {2382, 39.632666785719366}, {2384, 38.45229246819694}, {2389, 38.97420423718335}, {2396, 37.497742223483016}, {2403, 37.20884959153676}, {2405, 38.163601842424356}, {2410, 37.132399280518335}, {2416, 38.96954505622985}, {2421, 38.36989947803435}, {2428, 38.16577426042987}, {2430, 37.20194861904684}, {2434, 38.665082590845316}, {2440, 39.11691716267563}, {2446, 38.02954799036356}, {2453, 37.98072923120449}, {2457, 38.66797170791196}, {2461, 37.08263012999697}, {2468, 37.478003899130535}, {2472, 35.87090337493837}, {2478, 37.1957829652079}, {2481, 39.76987261793349}, {2487, 40.80366573878367}, {2491, 43.42510969518392}, {2497, 44.29101702903774}, {2502, 41.79435089000459}, {2506, 43.178994474468176}, {2511, 39.95979151189301}, {2517, 40.811835396416136}, {2522, 43.469996426408535}, {2529, 41.641644251781955}, {2533, 42.09104450737047}, {2537, 41.721596977396956}, {2541, 39.90420781213615}, {2547, 39.738281539976}, {2553, 41.411980447849764}, {2555, 41.62699785722495}, {2564, 38.98058165621274}, {2569, 41.43936550130537}, {2573, 41.86906945022645}, {2576, 40.858767555527805}, {2583, 44.058494616358495}, {2585, 42.70233698941648}, {2591, 42.810258239438845}, {2597, 40.55335045136749}, {2604, 39.4574717226145}, {2606, 40.13087881643223}, {2610, 40.05829543634176}, {2618, 39.14891944323103}, {2621, 37.5842486836372}, {2628, 38.7335220955414}, {2632, 37.90928164592873}, {2637, 39.24100815688652}, {2640, 39.55798120001941}, {2647, 36.23295703793576}, {2653, 36.64494239211856}, {2659, 34.672906766786355}, {2664, 34.771606902340174}, {2666, 35.02613347813431}, {2670, 34.21234874898513}, {2677, 33.61921918842873}, {2680, 34.47612413434144}, {2687, 34.540332423206024}, {2691, 33.31758465582364}, {2695, 35.27834052976643}, {2702, 35.587731051837416}, {2705, 34.03444342209502}, {2713, 31.763850208735782}, {2717, 31.89442805523013}, {2720, 30.570511736331543}, {2726, 30.631386637749323}, {2730, 28.61563883266229}, {2737, 29.646954975157882}, {2744, 28.16252911704915}, {2748, 28.61247793755877}, {2753, 28.43557149451693}, {2755, 27.037025918511283}, {2761, 26.760134602011636}, {2766, 27.998508184180817}, {2773, 27.457194113628123}, {2778, 25.447443897366075}, {2781, 25.911262332850754}, {2789, 26.528383252253256}, {2792, 25.824556557378628}, {2795, 25.111955575936644}, {2803, 25.968428482836103}, {2807, 27.54190493767045}, {2813, 26.423373614090597}, {2816, 28.496172416512515}, {2821, 27.399970276602343}, {2827, 27.37610449016281}, {2830, 28.168201851600365}, {2836, 27.233402978544067}, {2840, 28.607099713321475}, {2848, 26.392688537225578}, {2852, 26.269936477378405}, {2856, 28.41596094710675}, {2864, 27.372749995542335}, {2868, 27.83432934764762}, {2870, 29.79498828662717}, {2875, 31.71938876522025}, {2881, 31.681403018636786}, {2886, 29.472355419791427}, {2894, 29.124858728303685}, {2898, 31.215229365152215}, {2900, 30.857590831985288}, {2909, 31.434858618252605}, {2912, 29.93565034197684}, {2916, 30.968361747768547}, {2922, 30.147767848823545}, {2926, 28.51448224611682}, {2930, 29.022303006465368}, {2937, 26.408787788436918}, {2941, 25.822279798439705}, {2948, 27.072069424664924}, {2953, 26.299532712205195}, {2957, 24.034114487943505}, {2962, 23.85023866590447}, {2966, 23.71814837085052}, {2971, 25.840255119538664}, {2979, 26.074627484746603}, {2982, 26.62269151997738}, {2987, 26.05243489612348}, {2991, 25.652831846415367}, {2998, 26.901808522372313}, {3003, 26.088631779268834}, {3009, 27.782632975155}, {3012, 27.388829894601574}, {3017, 27.652745228165806}, {3020, 29.524598241887276}, {3027, 30.73034455732333}, {3033, 34.14238204328724}, {3035, 34.55394232184136}, {3040, 32.87558231122469}, {3049, 31.418578354753414}, {3052, 31.478771719965934}, {3059, 33.104577943842884}, {3062, 29.93908316497376}, {3066, 29.42426454491802}, {3071, 30.39121521041002}, {3079, 30.808812815476546}, {3084, 30.20172837588546}, {3088, 31.03257471371818}, {3091, 28.90734498274122}, {3099, 30.81125656901041}, {3100, 29.607530596142997}, {3106, 31.32710063553683}, {3110, 30.61875215657774}, {3115, 32.30837337558492}, {3122, 30.304134609467486}, {3128, 30.082238264022603}, {3135, 31.425832509717182}, {3140, 33.65570232797892}, {3143, 32.67952645100101}, {3147, 33.328724603980014}, {3154, 31.177003426608458}, {3160, 30.967056835014755}, {3165, 32.38149340842041}, {3167, 31.180181319988332}, {3171, 32.867677415690224}, {3180, 32.93786082284114}, {3182, 33.89537603616726}, {3186, 33.48014088578789}, {3194, 37.152845814499535}, {3197, 36.72395148805289}, {3201, 37.68701715509432}, {3207, 37.177958656048105}, {3213, 37.75965833545013}, {3217, 38.18103211360699}, {3221, 35.76343601069714}, {3228, 35.60401961780849}, {3234, 36.19636620447901}, {3236, 34.782382760280335}, {3241, 34.81821831651344}, {3246, 33.350131113450125}, {3251, 32.596084703753874}, {3259, 33.54075000081999}, {3263, 31.758176393318287}, {3267, 32.09409145385511}, {3275, 29.06160851755138}, {3276, 29.649133669716544}, {3281, 29.070477635815827}, {3287, 32.72273350370443}, {3295, 32.726785325793635}, {3297, 33.83571180198559}, {3304, 33.627821807306546}, {3309, 32.842151272849485}, {3314, 34.3994082345058}, {3320, 33.99963167652209}, {3324, 31.212041654609635}, {3327, 32.055153913003146}, {3334, 32.234779372557384}, {3338, 30.740013555537057}, {3345, 30.56283258873671}, {3349, 31.14637617533282}, {3352, 30.97866560996787}, {3357, 31.615018574293643}, {3363, 33.26855777434632}, {3370, 32.89226183861777}, {3374, 33.52629206488907}, {3377, 32.45224067089088}, {3383, 34.27142675843858}, {3386, 33.01273553419829}, {3393, 36.97802352361716}, {3398, 36.90031551517573}, {3401, 35.499445889025864}, {3408, 34.68606294217492}, {3413, 37.17740333669563}, {3418, 37.374869441323746}, {3421, 35.7790596667844}, {3426, 36.02197200446126}, {3432, 34.924601234309385}, {3436, 34.4572696783567}, {3441, 34.877437006370286}, {3449, 31.735215667970092}, {3454, 33.15034114204495}, {3457, 33.25145744811404}, {3461, 30.109943743087637}, {3466, 31.65842780226553}, {3473, 30.577964817545922}, {3476, 31.650632080520086}, {3485, 31.84548063776127}, {3488, 30.560174724155342}, {3493, 31.887381742205424}, {3497, 29.47070713463634}, {3503, 31.469315701418683}, {3510, 30.95557997606788}, {3511, 31.980223292918765}, {3518, 32.43271679812625}, {3525, 30.39386488435902}, {3528, 31.43839740369831}, {3535, 30.662258590716984}, {3537, 32.98014017195333}, {3545, 31.689101326443183}, {3548, 32.92223632877409}, {3554, 32.09927951615547}, {3556, 33.86320988116308}, {3563, 33.597392261160415}, {3569, 31.69972472198296}, {3572, 33.012962884618574}, {3580, 30.83902872742016}, {3585, 30.323171221808224}, {3590, 30.697580128792886}, {3592, 30.22933286653618}, {3598, 31.248343781043335}, {3601, 32.560705734243456}, {3607, 33.10476073358268}, {3612, 32.24939276030207}, {3618, 30.67015361507686}, {3623, 31.191057259483284}, {3630, 33.091418882239445}, {3635, 35.222998429400846}, {3638, 33.955178987781}, {3642, 29.121801087250198}, {3648, 31.88964085600857}, {3652, 30.50628535976767}, {3659, 31.559828803294607}, {3661, 30.605373430398316}, {3669, 30.057913986094512}, {3674, 31.47426930437642}, {3680, 31.223367625034683}, {3682, 30.19829216553304}, {3687, 31.047595403218057}, {3693, 30.603549759307885}, {3700, 31.62129391692174}, {3705, 34.35768750096602}, {3706, 33.480461372240505}, {3711, 34.77481188799792}, {3718, 34.16518765028321}, {3725, 34.525950151725944}, {3729, 37.24781768842208}, {3735, 35.86481428501773}, {3737, 37.14027447150489}, {3741, 37.908095460582}, {3750, 36.30880218835804}, {3752, 36.93776738041527}, {3759, 37.44627314073198}, {3766, 35.32968089985233}, {3771, 36.31609256803086}, {3773, 38.43083167710727}, {3777, 37.94556968927861}, {3782, 38.70813805142539}, {3789, 38.87303482456266}, {3793, 37.87348574106414}, {3797, 39.31444077052365}, {3803, 40.40447274896678}, {3809, 39.07804466925928}, {3813, 39.61292554954707}, {3820, 39.52465873164222}, {3823, 38.445919893706396}, {3828, 40.07164954275041}, {3833, 41.25954776973257}, {3837, 40.59686023107034}, {3843, 43.97481631223127}, {3850, 41.89851060373508}, {3854, 43.00859290667485}, {3857, 42.58554402244061}, {3866, 43.29419748320046}, {3869, 44.936354699949135}, {3875, 43.98425210064129}, {3879, 44.54003640246446}, {3883, 44.084088844428344}, {3890, 44.64183638547881}, {3895, 46.69554397624657}, {3901, 46.06654509998825}, {3902, 46.57689530438109}, {3910, 47.79168684198062}, {3915, 44.43233105401431}, {3919, 43.18101584512046}, {3925, 43.711364180631804}, {3930, 42.639952988135626}, {3935, 43.637554324106404}, {3937, 44.47718122890482}, {3943, 42.58290514752061}, {3947, 43.67566420376484}, {3956, 43.15013781306844}, {3960, 41.190483201302776}, {3965, 41.29178612732812}, {3968, 43.53636550586511}, {3973, 42.17938430330037}, {3977, 44.85103730540091}, {3984, 43.27719869525927}, {3990, 43.627624602729895}, {3992, 44.957885207190635}, {3999, 44.40459780963831}, {4004, 45.32599258516697}, {4008, 43.66039558703255}, {4012, 44.44658393531378}, {4019, 43.84846576986777}, {4025, 41.580902668274064}, {4029, 42.88514428175226}, {4034, 41.46983767233033}, {4041, 42.09809076103792}, {4042, 40.40121722063858}, {4047, 40.85226478482957}, {4052, 43.376033472640444}, {4057, 44.303862119305684}, {4064, 44.08049094209474}, {4067, 43.42547149366908}, {4074, 42.579441010470354}, {4077, 44.096520800225065}, {4085, 44.64257806553344}, {4087, 43.49185769105879}, {4092, 44.608267360939585}, {4098, 44.436560493979954}, {4103, 45.317252160358144}, {4110, 46.058774601853955}, {4116, 44.766511487040916}, {4118, 45.521105859507294}, {4124, 45.42131956848279}, {4128, 47.83269632839022}, {4135, 44.90413846099235}, {4139, 46.58227592497253}, {4143, 46.500309270278464}, {4150, 45.33765696135226}, {4153, 45.64354971534378}, {4160, 45.93018712100647}, {4164, 43.25559660341626}, {4169, 43.92613927037596}, {4174, 43.62114145159183}, {4178, 40.72846655122725}, {4186, 42.55329890940964}, {4189, 41.678572270110294}, {4193, 40.829011801535664}, {4197, 42.800600639022605}, {4202, 41.99633327331731}, {4209, 43.19323932573483}, {4212, 42.18530485919557}, {4218, 41.59881716888323}, {4223, 42.441042770154844}, {4228, 45.53797859707034}, {4232, 46.07574947104996}, {4241, 46.07894808606258}, {4242, 44.286086348874676}, {4247, 43.08447818539749}, {4254, 43.2384965784782}, {4258, 44.779096753781424}, {4263, 44.94257959545199}, {4269, 44.30870396354328}, {4273, 46.26696427252453}, {4278, 46.30744653697344}, {4283, 45.827017445641175}, {4288, 43.781370713844545}, {4292, 46.60711089281704}, {4297, 43.335817467294284}, {4305, 44.16868478059633}, {4309, 43.44755931800053}, {4312, 43.891606967283025}, {4320, 43.79297096639801}, {4324, 42.099203979340935}, {4329, 44.8390211407645}, {4336, 46.132237714004425}, {4339, 44.56756839730384}, {4343, 46.24568332480992}, {4351, 44.05034495051119}, {4355, 45.09815452419815}, {4357, 44.35190888940349}, {4365, 43.25758809794344}, {4368, 44.14477410502386}, {4376, 41.93028553518078}, {4382, 43.69386481163199}, {4384, 42.343580110976134}, {4391, 39.38331357790885}, {4397, 40.49257098503543}, {4400, 38.65146414419247}, {4406, 39.040498102853704}, {4411, 36.71659398164643}, {4414, 36.21992527315708}, {4418, 37.86983316239789}, {4424, 38.79645166307203}, {4428, 36.974042644355606}, {4433, 35.93959392178788}, {4439, 35.97790853205448}, {4443, 38.21664941647024}, {4450, 38.44876254366418}, {4455, 37.09540108270616}, {4460, 36.95018579100306}, {4466, 38.730315146387746}, {4469, 37.872865556491874}, {4476, 37.423877674083585}, {4478, 37.96421499308509}, {4487, 38.08371503820191}, {4488, 39.74784443380604}, {4496, 40.71073257614338}, {4501, 40.60312836705065}, {4504, 39.40056608371914}, {4508, 40.22426761068521}, {4517, 41.646176394626345}, {4521, 40.41889455210564}, {4525, 40.60519761105382}, {4529, 39.075001110176856}, {4536, 40.26787350849}, {4541, 40.65187955527909}, {4544, 39.967275063438045}, {4549, 40.450392865002364}, {4553, 41.90167025496052}, {4561, 42.667331833071664}, {4566, 43.86137004897719}, {4572, 44.14608921239006}, {4575, 42.10202383999383}, {4579, 41.46655883593124}, {4584, 41.91347248013341}, {4592, 42.11677669401778}, {4593, 41.43172999572018}, {4600, 41.53894095306525}, {4607, 42.40289053451183}, {4611, 42.02391206710711}, {4617, 43.2708291680743}, {4621, 43.03671781336059}, {4626, 45.984997240186246}, {4630, 44.651596037353286}, {4637, 45.729375501632695}, {4639, 46.97672701088541}, {4646, 45.55249821676164}, {4648, 46.657238306997954}, {4653, 47.87910231233235}, {4659, 47.75882142791673}, {4663, 49.467384079074314}, {4668, 48.696827533051106}, {4675, 48.92579198716452}, {4682, 44.72899549055614}, {4687, 44.08997798757562}, {4690, 44.77024206609575}, {4697, 42.05490971051252}, {4699, 40.804558836186786}, {4705, 42.35954965911466}, {4711, 42.92136840228886}, {4716, 41.51956996493458}, {4721, 41.15180912858265}, {4727, 45.87658310035213}, {4728, 43.6183451512828}, {4737, 42.81785284737095}, {4739, 42.53626377548142}, {4743, 44.471678262389915}, {4750, 43.47296751071649}, {4754, 44.60107183314088}, {4760, 41.15252150405892}, {4766, 40.44563966701578}, {4772, 41.98448907911279}, {4774, 41.831147917269575}, {4779, 40.66303052923502}, {4786, 41.793314227583664}, {4788, 41.147687532911064}, {4793, 41.63707209178867}, {4802, 40.980911652896054}, {4803, 41.734203454889105}, {4808, 42.70943804743709}, {4813, 41.94637435030276}, {4819, 42.58423495563741}, {4824, 41.21364184446058}, {4831, 43.55500018064631}, {4835, 42.75390903216747}, {4840, 43.989916759215}, {4847, 42.65060540788467}, {4851, 41.10868413269653}, {4856, 39.88125368753376}, {4860, 40.67992036846289}, {4864, 38.018950718551935}, {4871, 38.34361998177123}, {4873, 39.5198852558182}, {4878, 39.66661286220836}, {4883, 41.40919784184403}, {4891, 42.51566334270849}, {4897, 42.063060621486514}, {4902, 40.08190763242786}, {4906, 41.27896864220977}, {4909, 41.19823454109512}, {4913, 38.86084836942058}, {4920, 38.474735694735124}, {4923, 38.29265621342109}, {4928, 39.753432401888055}, {4937, 38.84416930772779}, {4942, 37.41788048991505}, {4943, 38.32825078053794}, {4949, 37.64359097418195}, {4953, 36.10850429296769}, {4960, 33.9039081124664}, {4964, 34.53854603237626}, {4968, 33.690731394344716}, {4976, 33.76315401597445}, {4979, 32.55733463964615}, {4985, 35.37591959109057}, {4989, 34.37111074112498}, {4998, 33.21364571883214}, {4999, 34.07622604782128}},
	{{0, 29.357995947822218}, {2, 29.28168582006162}, {3, 30.409965579108867}, {7, 31.203663004229718}, {10, 30.467811944911556}, {12, 30.59789593509767}, {15, 29.54668002901058}, {17, 30.53743760171474}, {18, 30.74066032317061}, {21, 30.057979182917986}, {23, 30.293450053773604}, {27, 30.355932660992572}, {30, 29.557268760451187}, {31, 29.16161297604625}, {33, 30.246270628292226}, {36, 29.52892023906641}, {39, 29.818636169776926}, {41, 28.103057873678374}, {45, 28.06872431241809}, {47, 26.606504358317906}, {48, 27.220308136213916}, {52, 25.824433242208308}, {54, 27.28963669872412}, {56, 27.298211480886604}, {59, 26.21938188318228}, {62, 27.592635104460253}, {65, 27.30713964830731}, {66, 27.170789712751404}, {69, 27.55974343996647}, {71, 28.284229862452584}, {75, 28.576637206595993}, {76, 27.763715461946813}, {78, 27.304006460281794}, {82, 26.09406789919051}, {84, 26.145181108429618}, {86, 24.787772395126176}, {88, 25.33621421606084}, {91, 25.34334450564347}, {95, 26.448419417928317}, {97, 26.332417666691025}, {99, 25.318121919340044}, {102, 26.65713935644778}, {105, 27.45775156727039}, {106, 28.476933177720472}, {109, 27.007320452528134}, {111, 28.669197835798027}, {114, 29.266136201836588}, {117, 28.92417256867908}, {120, 29.407882394097168}, {122, 30.374496989862006}, {123, 29.75867484229172}, {127, 29.891515813029994}, {128, 29.224842590902917}, {132, 29.11303194254891}, {135, 29.875645922022283}, {136, 29.32336837740634}, {138, 29.916122460150415}, {142, 30.01603062688162}, {143, 30.206305874273855}, {146, 29.479249298103124}, {148, 28.668390496723326}, {151, 29.514646394709878}, {155, 29.942433471924208}, {157, 29.081114874079432}, {159, 29.17427761652929}, {162, 28.615830690136196}, {163, 27.244815449582045}, {167, 28.333335545414524}, {170, 28.110663780904385}, {172, 27.155839334130572}, {174, 27.822551655905976}, {177, 27.83845450366903}, {179, 26.470510229480666}, {182, 26.061343714664623}, {185, 27.54560649645601}, {187, 27.3151823435893}, {189, 27.564104270774138}, {191, 27.158236015306873}, {194, 27.170854273897024}, {197, 28.693644963914128}, {200, 28.227269873938933}, {202, 28.326544342536973}, {205, 28.87895845286964}, {207, 27.543826104728634}, {210, 27.4034023213343}, {212, 28.51752545491846}, {215, 28.955222450571647}, {217, 28.512855374048605}, {220, 28.758762367232816}, {222, 28.081382658095393}, {225, 27.729482622798493}, {227, 27.057357503159633}, {230, 27.624460374012415}, {231, 26.6107079586933}, {234, 26.528094947562206}, {236, 27.58607997646959}, {239, 26.50890594997075}, {241, 27.241646652930587}, {243, 27.806910729195003}, {247, 28.50754775235408}, {250, 28.142446798473102}, {251, 27.493875384325104}, {254, 26.66806605894335}, {257, 26.805339614467922}, {259, 25.78663848060838}, {262, 26.950679537489023}, {264, 25.880978465490344}, {266, 27.726596358113618}, {269, 27.721698306913026}, {271, 27.957187159455156}, {275, 27.032793497721116}, {276, 27.507939311361685}, {279, 27.759761781417595}, {281, 26.617667215269847}, {283, 26.195989054524656}, {287, 27.43948527543756}, {288, 28.0008367927751}, {291, 29.512759843423506}, {293, 30.70537467842703}, {296, 30.73440265654596}, {298, 31.22392323854322}, {302, 30.716789453632746}, {304, 31.025310612429436}, {306, 31.16989662941391}, {308, 29.11707721446215}, {311, 29.360034344664133}, {314, 30.094809176026143}, {316, 31.24738345775188}, {320, 30.172789122099953}, {322, 30.02896795596743}, {323, 28.710256908027688}, {326, 29.154793392113767}, {330, 31.51994434827819}, {331, 31.14360887134284}, {334, 29.912529162927882}, {336, 30.286270410087386}, {340, 30.269814084876984}, {341, 29.48743777656781}, {345, 28.25734414947841}, {347, 28.212727797755832}, {350, 28.15110192590233}, {352, 29.53367482995351}, {354, 29.943653842668887}, {356, 28.627878421859094}, {358, 29.421837208187565}, {362, 29.97536581410366}, {363, 29.090848126781193}, {367, 27.701450632319055}, {370, 27.712418470005847}, {371, 28.04360951096915}, {375, 27.715275282261704}, {377, 26.564904718909652}, {379, 27.17971899490677}, {381, 26.98833921789535}, {383, 27.36673199620505}, {386, 27.24426813335004}, {390, 28.196204812447014}, {391, 27.570724094739713}, {393, 28.264285808134655}, {396, 28.13948170648531}, {399, 26.76664288679182}, {402, 26.35282363879538}, {404, 27.037728660238816}, {407, 25.78486318168484}, {410, 25.86809752383717}, {412, 27.226357547185447}, {414, 26.435002451423312}, {417, 27.09418382303274}, {418, 28.011098852919908}, {422, 26.710013475304418}, {425, 26.57172379809563}, {427, 25.8834697613218}, {429, 25.922770964698366}, {431, 26.7196171595444}, {434, 26.68923906981248}, {437, 29.462067517762534}, {440, 29.716399938469106}, {441, 29.697795912329543}, {444, 27.568707173494055}, {446, 28.94876289646488}, {450, 28.98764510982713}, {452, 27.8971845311884}, {454, 29.550067169716076}, {457, 29.444893222605785}, {458, 30.2987283695555}, {461, 31.03092246398632}, {465, 31.287884426895985}, {466, 30.49414678626753}, {469, 31.65627890749247}, {471, 31.009412915052188}, {474, 31.095825728106682}, {477, 31.600766880442425}, {479, 31.218212979786024}, {482, 31.590576295671646}, {483, 31.49429616322668}, {487, 32.89146487332367}, {488, 33.87564290993047}, {492, 33.57726370546161}, {494, 34.26212065396207}, {496, 34.72554255082181}, {500, 34.099389551023904}, {501, 34.22803109888905}, {505, 35.02095234082352}, {507, 36.39939489896903}, {509, 36.91759867136517}, {511, 36.637052547917165}, {513, 37.943749079996564}, {516, 37.50103188910752}, {519, 35.88305508619134}, {522, 35.204473848884604}, {524, 37.10654099191614}, {526, 37.88944422270623}, {528, 36.952108419930035}, {532, 37.241795032269486}, {533, 36.98172720447497}, {536, 37.291084012425635}, {539, 36.56539045560211}, {542, 36.413434939980604}, {543, 36.830541819855966}, {546, 36.86880281045058}, {549, 35.60660078018533}, {551, 36.15574897354542}, {554, 36.1246059100681}, {556, 35.53756438274776}, {560, 36.902047436744915}, {562, 36.97312505169229}, {563, 38.33987731208528}, {566, 37.91294220403035}, {568, 37.52932323225818}, {572, 38.82875488776441}, {573, 39.30100206552399}, {577, 38.55996270262097}, {578, 39.53759984840164}, {582, 39.83799518416734}, {583, 41.066310308184526}, {586, 42.44197850928179}, {590, 41.86201338457368}, {592, 42.38604395890263}, {594, 42.917712727399795}, {596, 41.98001270512809}, {600, 41.151843749654674}, {602, 41.07670022261416}, {605, 39.65057441921113}, {606, 40.59197307871199}, {610, 39.198802516126015}, {611, 40.28881956306739}, {615, 42.31117692587696}, {616, 42.56501744522036}, {618, 40.54474737773533}, {621, 39.799369403233875}, {624, 40.51863738080248}, {626, 39.577466020927666}, {629, 39.06459566315487}, {632, 39.6862655989382}, {635, 38.90143970392931}, {637, 37.47764070721714}, {638, 38.14287868141234}, {641, 38.08870157682401}, {644, 37.661339861002425}, {646, 38.19873503550377}, {648, 36.15953352691078}, {651, 36.747404928048674}, {654, 36.12499971175383}, {657, 36.13550126300937}, {659, 36.52934581511136}, {662, 35.88734753480093}, {664, 37.494624894014834}, {667, 37.42672416426224}, {670, 38.198701944392226}, {671, 37.672228180889036}, {675, 36.526503465131775}, {676, 37.14283711760895}, {679, 37.030753837557455}, {681, 37.34909191845969}, {683, 37.71513970238973}, {686, 36.671363246669195}, {690, 37.100425916489115}, {691, 37.80849557841213}, {693, 38.65064301128746}, {697, 38.51329094834429}, {698, 38.63409846835321}, {701, 37.20625176875522}, {703, 36.598956314019325}, {706, 36.931378033672665}, {709, 37.312534314076736}, {712, 39.50821685803287}, {714, 40.43514365409954}, {717, 39.4239320658717}, {719, 39.70807547297041}, {722, 40.02829005394066}, {724, 39.88229973919716}, {727, 39.43664948339558}, {730, 40.7177664595581}, {731, 40.72045099279074}, {733, 37.63394119070095}, {736, 37.09659077679385}, {740, 36.768283960686276}, {742, 37.00023584840072}, {744, 37.65237108287256}, {747, 37.26755576516154}, {749, 37.25181149353707}, {752, 38.50060736503108}, {755, 41.2027128451164}, {757, 41.42756394972893}, {758, 41.20791889996719}, {761, 41.57431095381387}, {764, 42.943817792210965}, {767, 42.72385932125831}, {770, 43.21939147903337}, {771, 42.593500985806116}, {773, 41.96625047640962}, {777, 42.108251206065354}, {779, 41.734510693754125}, {782, 41.83653956517087}, {783, 41.84729249879647}, {787, 40.33193886547389}, {790, 40.56930078212437}, {792, 39.36239492015202}, {794, 39.98930528782557}, {797, 40.08078557739916}, {798, 39.9026881045777}, {801, 39.779536346223246}, {803, 39.04248228046798}, {806, 38.62608414650186}, {809, 38.003564811967195}, {811, 39.32280711240079}, {814, 39.82593927687213}, {816, 39.632089125382805}, {819, 39.3691037472924}, {822, 39.84149848240294}, {825, 38.983001317774516}, {827, 39.11241986582127}, {828, 39.060815486719235}, {831, 38.46243114268653}, {834, 35.65801215219413}, {837, 35.26479970268285}, {839, 36.707855369730034}, {843, 36.175883792606705}, {845, 36.721302046157795}, {846, 36.738751647960406}, {850, 36.138203284641186}, {852, 36.9122685068765}, {854, 36.016869149964144}, {858, 35.23328368215224}, {860, 35.441912396566295}, {861, 36.11980562386126}, {864, 35.11437170180045}, {867, 35.26826901332004}, {870, 33.95310090031108}, {871, 34.76854906618263}, {875, 34.818344629526955}, {877, 32.4461932776035}, {879, 32.571549274273316}, {882, 30.11896242237412}, {884, 30.151470049420453}, {887, 29.315297425726456}, {889, 30.38412313034993}, {893, 31.19665096563887}, {895, 30.214575260830543}, {897, 31.69516453152183}, {899, 31.3260343161325}, {903, 31.77933470325809}, {904, 31.54527210384609}, {906, 31.952233276070345}, {909, 31.26054806750292}, {913, 31.446602308578885}, {914, 32.88848724097737}, {918, 33.57376811625785}, {920, 32.739675795181945}, {922, 33.81401934792278}, {925, 32.71783936639953}, {927, 33.496669377208725}, {930, 31.681562294745188}, {933, 31.99391696064781}, {934, 31.222294641434715}, {936, 31.60562877897029}, {940, 31.839975677295737}, {941, 31.57998061624259}, {944, 33.57148226581986}, {948, 35.0394972266412}, {949, 35.06221556029825}, {953, 36.40171114341679}, {954, 35.651733034914436}, {956, 36.194620959224366}, {960, 36.718644368420634}, {963, 35.89078679017791}, {965, 35.92838317262612}, {967, 33.68329350874763}, {970, 33.48546378484414}, {971, 33.729671379093105}, {974, 31.882058598338592}, {976, 31.360355110091252}, {980, 31.76928554942759}, {981, 31.596565826225252}, {985, 30.369022511891757}, {988, 30.543171096017304}, {989, 29.709033348016842}, {993, 30.110594653721783}, {995, 30.887702552351005}, {997, 30.96235060201595}, {1000, 31.925382030352395}, {1002, 32.404705995647134}, {1004, 32.105619052543034}, {1007, 32.06571185804976}, {1010, 32.45637104295923}, {1011, 33.97355416481095}, {1015, 34.028775375039515}, {1016, 33.15444517016032}, {1020, 34.6557254577998}, {1023, 33.53814944935212}, {1025, 33.779257221704746}, {1028, 33.308377022855574}, {1030, 33.398428332372106}, {1033, 31.58571790720343}, {1034, 32.16172427938117}, {1036, 31.632175065844496}, {1040, 32.71362639662142}, {1042, 27.792537058477052}, {1044, 30.591065858607116}, {1046, 31.673417165689862}, {1049, 31.420045699024275}, {1051, 32.70728464282712}, {1055, 32.99077340899255}, {1057, 32.30498262311541}, {1059, 32.940891339151776}, {1063, 32.289791532294295}, {1065, 33.33078243465505}, {1068, 33.41296471315078}, {1070, 32.33224727266914}, {1072, 32.26109905266389}, {1075, 33.78768855190261}, {1078, 31.147232293821737}, {1080, 31.71150780117646}, {1082, 30.955859429080363}, {1085, 31.16579586461409}, {1088, 29.252834071159857}, {1089, 29.685743434805644}, {1093, 30.161758590806624}, {1094, 30.779652282941164}, {1096, 31.56528710281942}, {1100, 32.18402247418236}, {1101, 33.487267406897004}, {1104, 32.50713483623776}, {1106, 32.78927126650209}, {1110, 32.49004088753038}, {1113, 33.01159487630862}, {1115, 34.21219988578758}, {1118, 34.275948039809364}, {1120, 33.57361872056542}, {1123, 34.101866130091636}, {1124, 35.08344176854378}, {1126, 34.99789523160777}, {1129, 34.9547553234651}, {1133, 36.90897436886569}, {1134, 36.68925056413046}, {1138, 36.15108571210806}, {1139, 36.31887166999472}, {1143, 36.459483786091326}, {1145, 35.76502964124057}, {1147, 36.143227345894964}, {1149, 34.22551552384586}, {1152, 35.02162912627897}, {1155, 33.989361791250865}, {1156, 33.90560409554212}, {1159, 35.459597394271825}, {1163, 34.87027987153975}, {1164, 32.73740982908738}, {1166, 36.38448730256452}, {1169, 35.67047911791235}, {1171, 35.63860255804954}, {1174, 36.42873315721097}, {1177, 36.68542383419321}, {1180, 35.97612499492244}, {1181, 35.97470028204401}, {1184, 37.398624973193115}, {1186, 37.59944793075436}, {1190, 37.60117292673316}, {1193, 38.44788884052119}, {1195, 38.53261361058563}, {1196, 38.20625193191746}, {1200, 38.28171670233931}, {1202, 37.469381149070585}, {1204, 37.996863546861626}, {1208, 37.56402382212345}, {1210, 38.20048604682538}, {1213, 37.85109980183144}, {1214, 37.8667193253515}, {1217, 37.507680665850124}, {1220, 38.153189871670634}, {1221, 37.705945919911386}, {1224, 37.86005819640923}, {1228, 36.574577925568015}, {1230, 37.93262825928585}, {1233, 37.87253628352105}, {1234, 37.03465628886385}, {1237, 37.355020597223806}, {1239, 35.71849960760021}, {1242, 36.67505414760637}, {1244, 36.17805747298349}, {1246, 36.7654190000416}, {1249, 34.79204497446974}, {1253, 35.17789113339765}, {1255, 36.27186268761327}, {1257, 35.56797468172719}, {1260, 34.959780400150386}, {1263, 35.54647234411569}, {1265, 34.07163330273662}, {1267, 34.98718482740182}, {1269, 34.814779163097306}, {1271, 36.248018614293784}, {1275, 35.339226659095814}, {1276, 36.04365822060287}, {1280, 36.330656914157935}, {1283, 35.20967589696835}, {1285, 35.05450151673027}, {1286, 34.083660774124404}, {1290, 32.607679572698984}, {1293, 32.50260313437235}, {1295, 32.66682027747426}, {1297, 32.79448909601}, {1300, 34.03662018610426}, {1301, 33.471561770605334}, {1305, 33.486732091763336}, {1308, 34.50821094970082}, {1310, 34.07699583444763}, {1311, 33.29032898991077}, {1315, 32.35364095869243}, {1317, 32.001227569765504}, {1319, 32.17192961357054}, {1322, 31.361540797597904}, {1325, 31.385674150907523}, {1326, 30.397821572277874}, {1330, 30.762480629193092}, {1333, 30.401524153538364}, {1334, 30.862514784963658}, {1336, 30.546876105280212}, {1339, 31.09586849152352}, {1343, 29.60468065056554}, {1344, 29.518027759834045}, {1347, 28.96213974116116}, {1349, 30.027880530088794}, {1351, 30.7570211333231}, {1354, 31.25924961163502}, {1357, 31.471490532081248}, {1359, 29.51601931381402}, {1362, 29.0952884352307}, {1365, 25.95144210780829}, {1368, 25.654123815674225}, {1370, 25.841597348616787}, {1372, 24.40430526113091}, {1374, 24.868258110961357}, {1377, 24.723127466527284}, {1380, 25.403952465657824}, {1383, 25.168837708367573}, {1384, 25.822974064286573}, {1387, 25.493115319468433}, {1390, 26.63671721716633}, {1391, 27.41659614028529}, {1394, 27.41516507193562}, {1397, 28.490364050694232}, {1399, 28.487368411327616}, {1403, 26.388008503362745}, {1405, 26.804841863728445}, {1407, 25.978560150820044}, {1410, 25.750677096758384}, {1413, 24.34074260607449}, {1414, 24.754961425981048}, {1418, 24.6651943693905}, {1419, 25.194960339720506}, {1423, 25.505668659821385}, {1424, 25.930434241278466}, {1426, 26.031451433938873}, {1429, 28.12071488383503}, {1433, 29.738295917981866}, {1435, 29.63633778940114}, {1438, 29.539149897548384}, {1440, 30.862182502538953}, {1441, 30.42493141449586}, {1444, 30.537509584235174}, {1447, 30.164364772985248}, {1449, 29.280495127154293}, {1452, 29.752510306571484}, {1455, 29.25016590767666}, {1457, 29.533981898101043}, {1460, 29.731805290138638}, {1463, 31.279393484956277}, {1465, 31.39987446802975}, {1466, 30.81523244839042}, {1469, 31.378064726660238}, {1471, 30.890723656435668}, {1474, 30.906433524045895}, {1478, 31.863329580086756}, {1479, 34.1769485077606}, {1481, 34.032560599893785}, {1485, 36.06846197316916}, {1487, 34.95879681397107}, {1489, 34.27429545432343}, {1491, 34.8837191993053}, {1494, 34.691697874937915}, {1498, 34.711467226688804}, {1500, 34.01906505065623}, {1502, 34.645939695035565}, {1504, 34.837013970080854}, {1506, 34.21433963893517}, {1509, 34.372533557964495}, {1511, 34.1793952178106}, {1514, 34.29076290991813}, {1516, 34.88183138613434}, {1520, 36.014438556584366}, {1523, 35.809274512011065}, {1525, 35.44019543122139}, {1526, 35.64144780604629}, {1529, 35.467238834711935}, {1532, 33.77867219668047}, {1534, 34.29649579312852}, {1536, 33.83706673096555}, {1540, 34.88435222539337}, {1543, 34.316664346866176}, {1544, 35.1429379016867}, {1548, 35.55074228557621}, {1550, 35.1614123321548}, {1553, 33.68659149830347}, {1554, 34.76348070802675}, {1557, 34.40743801250581}, {1559, 35.074059881857586}, {1561, 34.05122520128333}, {1565, 34.42016699549108}, {1568, 35.21667415434252}, {1569, 34.56235394065422}, {1572, 35.65901988130965}, {1574, 35.43427648307305}, {1578, 34.64250053081252}, {1580, 34.61935447447808}, {1581, 33.30095950674964}, {1584, 33.22017010546928}, {1588, 33.25372890621039}, {1589, 33.55633290212615}, {1593, 33.758375775192526}, {1595, 34.31644882079321}, {1596, 33.55182639869085}, {1600, 32.03520633056414}, {1602, 32.3728274207352}, {1605, 32.2486900311155}, {1607, 31.55600150552031}, {1609, 32.27879842764017}, {1613, 32.90499426727991}, {1614, 31.34160341506861}, {1616, 33.3133749284244}, {1619, 33.44727416894953}, {1621, 32.42098193976603}, {1625, 31.745665996112034}, {1628, 32.18895805255132}, {1630, 31.634810462741328}, {1631, 31.569967535436145}, {1634, 33.03934988366926}, {1637, 33.39655980314689}, {1639, 35.076572468626274}, {1643, 34.64396731467868}, {1644, 34.03523254807719}, {1647, 35.12923123083873}, {1649, 34.081163717338875}, {1651, 34.03909563960654}, {1654, 33.54101912632574}, {1657, 34.17014679283176}, {1659, 33.914956135823154}, {1663, 33.53164709646962}, {1664, 32.942749249597995}, {1668, 32.49005865138826}, {1671, 32.39849660167694}, {1672, 33.26082532734355}, {1674, 33.73004210039798}, {1678, 33.46610598060115}, {1681, 34.06829829976045}, {1683, 33.847057378024175}, {1684, 35.250271418221374}, {1687, 35.40140497372611}, {1689, 37.93153971576717}, {1693, 38.20599590804662}, {1694, 38.68369317469104}, {1698, 38.96421874631208}, {1700, 39.16182425119748}, {1703, 38.24474852988975}, {1704, 38.38469009174058}, {1708, 38.280563758044565}, {1710, 38.56983066481024}, {1713, 40.39204144577866}, {1715, 41.3269897150344}, {1718, 41.837313217148804}, {1721, 42.73710053588433}, {1723, 42.096157824123665}, {1726, 41.97608613143687}, {1728, 41.24861627279633}, {1729, 41.87472943187815}, {1733, 41.97474828244962}, {1735, 41.22195929777421}, {1738, 41.34843546848941}, {1740, 42.07661962525981}, {1743, 40.958470191837534}, {1746, 41.46906637533652}, {1748, 40.610182804195105}, {1749, 41.017801824810185}, {1752, 40.70503981535662}, {1754, 39.752239396736506}, {1757, 39.74727156272358}, {1761, 40.25136763580497}, {1762, 39.38556407545778}, {1765, 38.86948923485995}, {1768, 39.514089866690526}, {1771, 38.80478381534035}, {1772, 38.83322167157176}, {1774, 40.33223301684341}, {1778, 39.77916448556436}, {1780, 40.57894081959218}, {1782, 39.35261558123242}, {1784, 38.0512977550727}, {1787, 39.10252385765842}, {1790, 39.41049327702329}, {1792, 38.82328669157878}, {1796, 41.015089776340226}, {1798, 40.53994999420047}, {1800, 41.17619373256442}, {1802, 40.98189573065346}, {1804, 41.59421552557119}, {1807, 39.92415966374783}, {1811, 39.6974862276464}, {1813, 39.30199180817845}, {1815, 39.5287187420122}, {1817, 38.77749075357144}, {1820, 39.149292277699324}, {1822, 38.63589451271645}, {1824, 38.4982817921926}, {1827, 39.45833354062081}, {1831, 39.71569674116191}, {1832, 39.71328630121623}, {1835, 38.74032920127892}, {1838, 39.34422885689023}, {1840, 40.71459696346432}, {1843, 40.98904213311685}, {1846, 39.23842350070322}, {1847, 37.531170184849564}, {1850, 38.64900610422957}, {1853, 38.72332458907287}, {1855, 38.46493433585336}, {1857, 38.764010535750494}, {1859, 38.078366113942565}, {1862, 39.532635843081685}, {1866, 39.25082176080607}, {1867, 38.15677220409511}, {1871, 38.39888830728324}, {1873, 36.620496899833185}, {1874, 36.76592939311881}, {1878, 37.19484339680942}, {1880, 36.977258419880144}, {1882, 37.02130072401423}, {1884, 35.989467257305485}, {1888, 36.49326570398064}, {1891, 35.09797528518658}, {1893, 35.311414001953885}, {1894, 34.57305509209034}, {1897, 35.47101264307737}, {1901, 35.01261679236839}, {1903, 35.37294264170206}, {1904, 34.459027714667855}, {1908, 35.125600870401854}, {1911, 34.31203602602105}, {1913, 35.1096803630126}, {1914, 34.514233849300744}, {1918, 34.10174900420402}, {1921, 34.19594013042914}, {1922, 34.18838364564101}, {1926, 37.82863560027054}, {1927, 37.52980493319014}, {1930, 37.11106227609642}, {1933, 37.29059943130983}, {1936, 37.33863802694112}, {1937, 36.93793225844994}, {1939, 37.079544775050316}, {1942, 36.64654224799271}, {1944, 36.76798510268848}, {1947, 36.28861461359311}, {1951, 34.55133668610086}, {1952, 35.092025906373635}, {1956, 35.09859916781124}, {1957, 35.63073140705392}, {1960, 34.87959003890974}, {1963, 32.78020946544929}, {1966, 32.93198375479733}, {1967, 35.25828074460553}, {1970, 34.12397376413126}, {1972, 34.64686103755323}, {1976, 34.83272344102554}, {1977, 34.49913157098365}, {1980, 35.185492244262484}, {1982, 34.02484580154227}, {1986, 34.69468439935647}, {1988, 33.199535764838636}, {1991, 33.126250139798344}, {1992, 32.1006804695537}, {1996, 30.96324192071878}, {1998, 31.004611604459708}, {2001, 29.32024170286219}, {2003, 29.758958255855212}, {2004, 30.117663632341145}, {2007, 29.38762759040267}, {2009, 30.353380249710128}, {2012, 29.36114381531963}, {2016, 29.11037246533442}, {2017, 29.98833975350206}, {2019, 29.196369679790173}, {2023, 28.36216318117799}, {2026, 29.134747648857985}, {2027, 28.0133642954549}, {2031, 28.388216858848796}, {2033, 27.367870148995426}, {2034, 27.251995482961384}, {2037, 28.028729073068334}, {2039, 28.350786367009555}, {2042, 28.211139910084785}, {2046, 27.771048205304385}, {2048, 27.956754355558264}, {2049, 28.898451768426284}, {2053, 28.519256261795114}, {2056, 28.425823720753847}, {2058, 28.371986321151727}, {2059, 27.281010674258564}, {2062, 26.779917891194174}, {2064, 27.261844645356348}, {2068, 27.27964623953228}, {2071, 27.57032488737316}, {2073, 26.840190037017013}, {2074, 25.848284039508844}, {2077, 28.626766043264496}, {2080, 28.006707726319842}, {2083, 28.44881078446907}, {2084, 28.407665090419357}, {2087, 29.665040474972592}, {2090, 28.981378296214995}, {2092, 29.103036068928503}, {2094, 29.957633494290146}, {2097, 29.046115152161175}, {2099, 29.266240445467794}, {2102, 30.01909364831503}, {2106, 29.870132199150568}, {2107, 30.054469107153587}, {2109, 29.56478041606059}, {2112, 30.309630232664347}, {2114, 29.49100419801057}, {2118, 31.112159919665434}, {2121, 31.996984724582912}, {2123, 29.835521461379106}, {2124, 30.096046165850005}, {2128, 29.906138940448397}, {2131, 30.820165055355577}, {2133, 29.933937853455785}, {2135, 29.643987595361455}, {2137, 30.22542736675569}, {2140, 29.839193019325773}, {2142, 31.25546101123808}, {2146, 30.170151295689198}, {2147, 30.295207809019463}, {2150, 31.31604954619179}, {2152, 30.864704949670024}, {2156, 31.18805814717659}, {2157, 31.837154644201334}, {2160, 31.640559706015285}, {2162, 29.808188744723488}, {2164, 30.606670887563382}, {2167, 30.76154769857017}, {2171, 31.388864514313752}, {2173, 30.99276274081928}, {2176, 33.159103841393794}, {2177, 33.29787809852651}, {2181, 33.00728410289347}, {2182, 34.05607738376311}, {2184, 33.43289159046996}, {2188, 33.94841513146962}, {2189, 33.30304766805812}, {2193, 32.18858592278298}, {2196, 33.33520209595963}, {2198, 32.710035724800086}, {2201, 33.710578425275074}, {2203, 33.25527764293191}, {2206, 33.73810431818219}, {2208, 32.870015366666216}, {2211, 33.89423423998636}, {2213, 33.579287468108}, {2215, 34.38967435369897}, {2217, 36.88357351027984}, {2220, 37.84817431115949}, {2223, 37.32997096688406}, {2225, 38.101980955554055}, {2228, 37.24084436632412}, {2229, 38.45249609002218}, {2232, 37.34244352498811}, {2235, 37.47322953068236}, {2238, 36.93966508491671}, {2241, 37.12637993171949}, {2242, 36.91777324959473}, {2245, 37.20202075141188}, {2247, 36.830944738890715}, {2250, 37.63036405693426}, {2253, 36.353792852732994}, {2256, 36.87350479821814}, {2258, 35.733553198879285}, {2259, 35.48805636280678}, {2263, 35.9725442605288}, {2265, 34.799856216789664}, {2268, 35.52063000497536}, {2269, 35.7847373835048}, {2273, 35.152141159882405}, {2275, 34.48805775061282}, {2278, 34.39912341428924}, {2281, 33.48991097769715}, {2282, 33.48007351832354}, {2284, 34.81847331063591}, {2288, 36.11012685056512}, {2291, 36.19988717533946}, {2292, 36.82497371024283}, {2296, 37.24345441577025}, {2298, 35.8576345692627}, {2300, 36.06990172210221}, {2303, 35.67840840680457}, {2304, 36.24622015952215}, {2307, 37.10057430482785}, {2311, 37.331141223084856}, {2312, 36.8562932336869}, {2314, 37.29544282161283}, {2318, 37.4312789350087}, {2321, 36.8242524461256}, {2323, 36.53900862036208}, {2324, 37.02861438655951}, {2327, 37.48320749003392}, {2329, 38.226516715835075}, {2332, 39.13171392966848}, {2335, 38.96816384019192}, {2338, 38.91508217017819}, {2339, 39.768877736103605}, {2342, 39.28514875368393}, {2345, 38.98575368659195}, {2348, 39.534223631257824}, {2351, 39.76991133023266}, {2353, 38.78464337191674}, {2356, 39.57233319093269}, {2357, 39.4775906546037}, {2359, 38.57809299449735}, {2362, 38.48045973837729}, {2366, 36.94671668201051}, {2368, 37.56900473168416}, {2369, 38.107005730339885}, {2373, 37.980026494228056}, {2376, 38.184818957491586}, {2378, 38.17115924132589}, {2379, 38.02933185572005}, {2382, 39.632666785719366}, {2384, 38.45229246819694}, {2388, 38.983429309450706}, {2391, 37.29737183692541}, {2392, 37.45124430298096}, {2394, 37.95222937643749}, {2398, 37.30971600962666}, {2400, 37.53645804280457}, {2403, 37.20884959153676}, {2405, 38.163601842424356}, {2407, 38.22526886325096}, {2410, 37.132399280518335}, {2413, 37.8352174960965}, {2415, 38.81615407880503}, {2417, 38.51014481284331}, {2419, 38.8330673644232}, {2422, 38.38299952696908}, {2426, 38.11238736059342}, {2428, 38.16577426042987}, {2429, 37.21503059523459}, {2432, 37.73740404804743}, {2434, 38.665082590845316}, {2438, 39.070111723777586}, {2441, 38.48057387525625}, {2443, 38.643673021215534}, {2446, 38.02954799036356}, {2447, 38.37221447795219}, {2451, 38.54182197292112}, {2452, 37.97168851025008}, {2454, 38.500048729444565}, {2457, 38.66797170791196}, {2461, 37.08263012999697}, {2463, 37.74228959632586}, {2466, 36.96662265441138}, {2468, 37.478003899130535}, {2471, 36.05942648742004}, {2473, 35.86422187859753}, {2476, 37.3789805517048}, {2478, 37.1957829652079}, {2481, 39.76987261793349}, {2483, 39.46441746053927}, {2486, 40.96173004505429}, {2487, 40.80366573878367}, {2491, 43.42510969518392}, {2492, 43.3467495490359}, {2496, 43.50241651823093}, {2497, 44.29101702903774}, {2501, 42.20225850019654}, {2503, 41.76196350512668}, {2505, 43.10084057387829}, {2509, 42.76222854703309}, {2511, 39.95979151189301}, {2513, 40.79681508224348}, {2515, 40.86098377024993}, {2517, 40.811835396416136}, {2520, 42.08290785008212}, {2522, 43.469996426408535}, {2525, 42.68285436365714}, {2529, 41.641644251781955}, {2530, 41.995153297318495}, {2533, 42.09104450737047}, {2535, 41.604667841842605}, {2537, 41.721596977396956}, {2541, 39.90420781213615}, {2544, 40.07480007115982}, {2545, 39.67254038329676}, {2548, 40.68871115360799}, {2551, 40.56134401134031}, {2553, 41.411980447849764}, {2555, 41.62699785722495}, {2559, 40.692726642278075}, {2561, 39.59727702576626}, {2564, 38.98058165621274}, {2566, 40.27851337856}, {2569, 41.43936550130537}, {2570, 41.01778584521347}, {2573, 41.86906945022645}, {2576, 40.858767555527805}, {2577, 41.20327089795783}, {2580, 43.02032269889916}, {2583, 44.058494616358495}, {2585, 42.70233698941648}, {2588, 43.08913827262613}, {2591, 42.810258239438845}, {2592, 41.86604756233666}, {2596, 41.362278318282556}, {2597, 40.55335045136749}, {2601, 40.600759547237764}, {2604, 39.4574717226145}, {2605, 40.060274508040756}, {2609, 39.96436408170099}, {2610, 40.05829543634176}, {2612, 39.18728728622009}, {2615, 39.274474362783934}, {2618, 39.14891944323103}, {2621, 37.5842486836372}, {2624, 37.460762948164124}, {2626, 37.9284949964923}, {2628, 38.7335220955414}, {2631, 38.15225856809112}, {2632, 37.90928164592873}, {2636, 38.96022542956203}, {2637, 39.24100815688652}, {2640, 39.55798120001941}, {2644, 37.543315900244956}, {2646, 37.28692975360062}, {2647, 36.23295703793576}, {2650, 35.959764744648616}, {2653, 36.64494239211856}, {2655, 35.6375906092785}, {2657, 35.57068617114742}, {2660, 34.63171730160524}, {2663, 34.65402092594314}, {2666, 35.02613347813431}, {2667, 34.46478240438498}, {2670, 34.21234874898513}, {2674, 33.96946719921404}, {2676, 34.10711370082857}, {2677, 33.61921918842873}, {2680, 34.47612413434144}, {2684, 33.8706108159827}, {2685, 34.38200284883451}, {2689, 34.23917159483758}, {2691, 33.31758465582364}, {2694, 35.18897714992098}, {2696, 35.30947212883306}, {2697, 34.697407680416966}, {2700, 35.53420547926852}, {2702, 35.587731051837416}, {2705, 34.03444342209502}, {2709, 33.404308515206424}, {2710, 32.5794052072048}, {2713, 31.763850208735782}, {2716, 31.713589796403312}, {2718, 30.539601797884956}, {2721, 30.436298375688793}, {2723, 30.65434061186432}, {2726, 30.631386637749323}, {2729, 28.896044518517407}, {2730, 28.61563883266229}, {2733, 29.55609328115069}, {2735, 29.07942162200021}, {2737, 29.646954975157882}, {2741, 28.774518059870104}, {2743, 29.384319812035454}, {2745, 28.370968057426175}, {2748, 28.61247793755877}, {2750, 27.951340656361044}, {2753, 28.43557149451693}, {2755, 27.037025918511283}, {2758, 26.699917649004856}, {2761, 26.760134602011636}, {2762, 27.18343703683992}, {2766, 27.998508184180817}, {2767, 27.90008295282876}, {2770, 27.17477572419831}, {2773, 27.457194113628123}, {2775, 27.153488900596923}, {2778, 25.447443897366075}, {2781, 25.911262332850754}, {2784, 25.87141867343481}, {2785, 26.127903579867812}, {2787, 25.968383286170432}, {2790, 26.63041226276307}, {2792, 25.824556557378628}, {2795, 25.111955575936644}, {2799, 25.487771689167698}, {2800, 25.81216153045184}, {2803, 25.968428482836103}, {2805, 26.49882702247749}, {2807, 27.54190493767045}, {2811, 26.587265607613453}, {2813, 26.423373614090597}, {2815, 28.207557672760228}, {2819, 28.611122350682358}, {2821, 27.399970276602343}, {2822, 27.905344738574847}, {2826, 27.832235140508022}, {2827, 27.37610449016281}, {2830, 28.168201851600365}, {2834, 27.900129431796973}, {2836, 27.233402978544067}, {2837, 28.62270120196561}, {2841, 28.581922133054277}, {2843, 28.502126322789735}, {2846, 28.09977585227804}, {2848, 26.392688537225578}, {2851, 26.439538464328816}, {2853, 26.512109899359487}, {2856, 28.41596094710675}, {2857, 27.45862971920284}, {2861, 27.950894827790314}, {2864, 27.372749995542335}, {2865, 27.521145751594496}, {2868, 27.83432934764762}, {2870, 29.79498828662717}, {2873, 29.63961776908481}, {2875, 31.71938876522025}, {2879, 31.92180528432921}, {2881, 31.681403018636786}, {2883, 30.912044142938722}, {2886, 29.472355419791427}, {2889, 30.09718091452955}, {2890, 30.431387560542564}, {2892, 29.246495986640035}, {2896, 29.08714179149652}, {2898, 31.215229365152215}, {2900, 30.857590831985288}, {2904, 31.299914014945326}, {2906, 30.967174302858048}, {2909, 31.434858618252605}, {2911, 30.205448705736853}, {2914, 30.21957109990217}, {2916, 30.968361747768547}, {2917, 30.009066802972328}, {2920, 30.404844874889584}, {2922, 30.147767848823545}, {2926, 28.51448224611682}, {2927, 28.76793928928293}, {2930, 29.022303006465368}, {2933, 27.729183209158307}, {2935, 27.640659462246116}, {2937, 26.408787788436918}, {2941, 25.822279798439705}, {2942, 26.35586961220703}, {2945, 25.974095714129387}, {2948, 27.072069424664924}, {2951, 25.905671210399422}, {2953, 26.299532712205195}, {2955, 24.888869198579197}, {2957, 24.034114487943505}, {2961, 24.544330149848985}, {2962, 23.85023866590447}, {2966, 23.71814837085052}, {2967, 24.703335417148605}, {2970, 24.853870491674087}, {2974, 26.312249087826}, {2975, 26.081048566805045}, {2977, 26.03568726819535}, {2980, 26.040651463264155}, {2982, 26.62269151997738}, {2986, 26.479253919810066}, {2987, 26.05243489612348}, {2991, 25.652831846415367}, {2993, 26.316574636642432}, {2996, 26.427205343025584}, {2997, 26.798259276629466}, {3001, 27.034524957712406}, {3003, 26.088631779268834}, {3005, 26.263116669541553}, {3008, 27.05636721935326}, {3010, 28.239461231129635}, {3012, 27.388829894601574}, {3016, 27.76330159496823}, {3019, 29.760186326718667}, {3020, 29.524598241887276}, {3023, 29.991328977556655}, {3025, 30.358833052283288}, {3028, 32.411088299325755}, {3030, 32.40261565557047}, {3033, 34.14238204328724}, {3035, 34.55394232184136}, {3039, 32.710090552383846}, {3040, 32.87558231122469}, {3044, 32.485577854400574}, {3046, 32.72824138287855}, {3049, 31.418578354753414}, {3050, 31.974802932294068}, {3052, 31.478771719965934}, {3056, 32.92288104967725}, {3059, 33.104577943842884}, {3061, 30.759481316657414}, {3062, 29.93908316497376}, {3066, 29.42426454491802}, {3069, 30.339341677481386}, {3071, 30.39121521041002}, {3074, 29.755321684850596}, {3075, 30.254534421486376}, {3079, 30.808812815476546}, {3080, 30.541034763482905}, {3084, 30.20172837588546}, {3086, 31.018620896589276}, {3088, 31.03257471371818}, {3091, 28.90734498274122}, {3092, 28.88512555430076}, {3095, 29.265927078146902}, {3099, 30.81125656901041}, {3100, 29.607530596142997}, {3104, 30.289365730425246}, {3106, 31.32710063553683}, {3108, 30.22467645076004}, {3111, 30.98837784635033}, {3114, 31.79541274581999}, {3115, 32.30837337558492}, {3117, 31.248323567786898}, {3120, 31.28299461589361}, {3122, 30.304134609467486}, {3125, 30.923176972067218}, {3128, 30.082238264022603}, {3130, 31.235939986705212}, {3134, 31.466063254090106}, {3135, 31.425832509717182}, {3139, 33.35536331207698}, {3140, 33.65570232797892}, {3143, 32.67952645100101}, {3146, 32.59144411017273}, {3147, 33.328724603980014}, {3150, 31.909366787173354}, {3152, 32.01030930891559}, {3155, 31.269152245617928}, {3157, 31.185431050212017}, {3161, 31.937036635712108}, {3164, 31.462330205674178}, {3165, 32.38149340842041}, {3167, 31.180181319988332}, {3171, 32.867677415690224}, {3174, 32.327497251158114}, {3176, 33.219908261056695}, {3178, 32.91346861269424}, {3181, 33.05108392047543}, {3182, 33.89537603616726}, {3186, 33.48014088578789}, {3187, 33.99535008164156}, {3191, 34.47433796931576}, {3194, 37.152845814499535}, {3196, 36.924986340055234}, {3197, 36.72395148805289}, {3201, 37.68701715509432}, {3202, 36.94563230667493}, {3206, 37.36244560706185}, {3208, 37.17234726327357}, {3210, 37.443103290909}, {3213, 37.75965833545013}, {3216, 37.05950813066276}, {3217, 38.18103211360699}, {3221, 35.76343601069714}, {3223, 36.030449190392034}, {3225, 35.46682168640866}, {3229, 35.7950184685732}, {3230, 35.680731912648454}, {3234, 36.19636620447901}, {3236, 34.782382760280335}, {3239, 34.01850844249432}, {3241, 34.81821831651344}, {3243, 33.50257123928646}, {3245, 33.207146127232235}, {3248, 33.25208316113067}, {3251, 32.596084703753874}, {3253, 32.989201391855794}, {3255, 32.76607998687764}, {3259, 33.54075000081999}, {3261, 33.37480509177156}, {3262, 32.04401143262248}, {3265, 31.64024961699623}, {3267, 32.09409145385511}, {3270, 31.61485887968538}, {3272, 30.343098748976058}, {3275, 29.06160851755138}, {3279, 29.875185928183274}, {3281, 29.070477635815827}, {3282, 30.080721132734187}, {3286, 30.743451866698816}, {3287, 32.72273350370443}, {3290, 32.42498977194752}, {3292, 32.9308941823172}, {3295, 32.726785325793635}, {3297, 33.83571180198559}, {3300, 33.162168528911174}, {3304, 33.627821807306546}, {3305, 33.198515456466744}, {3309, 32.842151272849485}, {3311, 32.957185834270064}, {3314, 34.3994082345058}, {3316, 34.21313709031122}, {3318, 34.189075319669456}, {3321, 33.824584145650626}, {3324, 31.212041654609635}, {3326, 31.795752220664465}, {3327, 32.055153913003146}, {3332, 32.30648496829282}, {3334, 32.234779372557384}, {3336, 31.175617555355522}, {3338, 30.740013555537057}, {3340, 30.389128544023528}, {3343, 30.56960911154055}, {3345, 30.56283258873671}, {3349, 31.14637617533282}, {3352, 30.97866560996787}, {3354, 31.592251360854707}, {3357, 31.615018574293643}, {3359, 32.26754114906748}, {3362, 32.12743992074132}, {3363, 33.26855777434632}, {3366, 33.276565557113116}, {3369, 33.197145715564346}, {3371, 32.63753378800023}, {3374, 33.52629206488907}, {3377, 32.45224067089088}, {3378, 33.536730399855294}, {3382, 33.68914809456685}, {3384, 34.3384613970915}, {3386, 33.01273553419829}, {3388, 34.24585759532097}, {3392, 35.41194481617064}, {3393, 36.97802352361716}, {3395, 36.46776848088892}, {3398, 36.90031551517573}, {3401, 35.499445889025864}, {3404, 35.19377350745659}, {3407, 34.68233052858934}, {3408, 34.68606294217492}, {3410, 36.152459222278075}, {3413, 37.17740333669563}, {3416, 37.067139992874246}, {3418, 37.374869441323746}, {3420, 35.8685171365076}, {3423, 35.66846294670802}, {3425, 36.0480945234249}, {3429, 35.481336812650724}, {3431, 35.58736423372758}, {3433, 34.90979132407057}, {3435, 35.27414359176062}, {3438, 34.7694402963776}, {3441, 34.877437006370286}, {3444, 34.396642283465276}, {3445, 33.719365607039315}, {3449, 31.735215667970092}, {3450, 32.52074978898301}, {3453, 32.00635868003232}, {3457, 33.25145744811404}, {3458, 31.855456989765536}, {3461, 30.109943743087637}, {3464, 31.811852478724177}, {3467, 31.645232457369303}, {3469, 31.965622730682476}, {3472, 31.615309544387085}, {3473, 30.577964817545922}, {3475, 31.65967766234796}, {3478, 31.46866237334157}, {3481, 31.843475655353362}, {3483, 31.83374497628001}, {3486, 30.76165139386353}, {3488, 30.560174724155342}, {3491, 31.47065724426264}, {3493, 31.887381742205424}, {3497, 29.47070713463634}, {3499, 30.80347150519261}, {3500, 31.10662961863165}, {3503, 31.469315701418683}, {3506, 30.880459790358785}, {3508, 31.666863184217398}, {3510, 30.95557997606788}, {3513, 31.69007433474044}, {3515, 32.15852386773846}, {3518, 32.43271679812625}, {3520, 31.634677292557605}, {3524, 30.95348491889584}, {3526, 30.082639749439995}, {3528, 31.43839740369831}, {3530, 31.24190268841608}, {3533, 30.98293712220932}, {3535, 30.662258590716984}, {3538, 32.718573086874514}, {3541, 32.79981705652948}, {3544, 31.785544957781138}, {3547, 31.549033274787455}, {3548, 32.92223632877409}, {3551, 33.36379119283432}, {3554, 32.09927951615547}, {3556, 33.86320988116308}, {3558, 33.529412010032885}, {3561, 33.31012171482195}, {3563, 33.597392261160415}, {3567, 33.44158744976233}, {3568, 31.864631180692385}, {3571, 33.02109212331147}, {3574, 31.491346373021337}, {3577, 31.785970967334098}, {3578, 31.302173527640477}, {3581, 30.647189213101132}, {3583, 30.635220918876687}, {3587, 30.14165312650818}, {3588, 30.587932180323367}, {3592, 30.22933286653618}, {3594, 30.563655322165122}, {3596, 31.266903691899042}, {3598, 31.248343781043335}, {3601, 32.560705734243456}, {3604, 32.648994209302636}, {3607, 33.10476073358268}, {3608, 32.127562371704016}, {3612, 32.24939276030207}, {3614, 31.75980113913783}, {3616, 30.82883453465096}, {3618, 30.67015361507686}, {3621, 31.39570326592559}, {3623, 31.191057259483284}, {3626, 31.7421965553774}, {3628, 32.83045534082564}, {3632, 34.98860015194777}, {3634, 34.52612439270598}, {3636, 35.32696073852328}, {3639, 32.98821123005988}, {3642, 29.121801087250198}, {3644, 29.21120341558452}, {3645, 28.94324522035289}, {3648, 31.88964085600857}, {3650, 30.80739952109552}, {3654, 30.39733248162421}, {3657, 30.464941464184626}, {3659, 31.559828803294607}, {3660, 30.4775995110338}, {3664, 30.45394463567413}, {3667, 30.76197883114409}, {3668, 30.17037689073509}, {3672, 30.246448076959325}, {3674, 31.47426930437642}, {3675, 31.010529526010682}, {3679, 30.69183779794675}, {3680, 31.223367625034683}, {3683, 30.363595369442493}, {3687, 31.047595403218057}, {3689, 30.543388017289054}, {3692, 30.68310619503808}, {3693, 30.603549759307885}, {3696, 31.904273713484496}, {3699, 31.82770668437377}, {3701, 33.01039885910495}, {3703, 33.11606920366353}, {3705, 34.35768750096602}, {3708, 33.89279065017372}, {3710, 34.935789977307365}, {3713, 34.049290860266446}, {3716, 34.69594103398987}, {3719, 34.23763587885022}, {3722, 35.59749071347688}, {3723, 34.32925786634385}, {3725, 34.525950151725944}, {3729, 37.24781768842208}, {3731, 37.30863902603817}, {3734, 36.001098652284306}, {3737, 37.14027447150489}, {3738, 36.258549896818224}, {3741, 37.908095460582}, {3744, 36.911971103005506}, {3745, 36.621626787271495}, {3748, 36.846211552881314}, {3750, 36.30880218835804}, {3753, 36.92794573529495}, {3757, 37.25861213788812}, {3759, 37.44627314073198}, {3762, 36.18844767465498}, {3763, 36.58284312296601}, {3766, 35.32968089985233}, {3769, 36.10451903716811}, {3771, 36.31609256803086}, {3773, 38.43083167710727}, {3777, 37.94556968927861}, {3779, 38.87016646551586}, {3780, 38.96356411591443}, {3783, 38.36257955910033}, {3787, 38.456878484269325}, {3789, 38.87303482456266}, {3791, 38.08710058110894}, {3793, 37.87348574106414}, {3797, 39.31444077052365}, {3799, 39.265510040584786}, {3801, 39.23029087940918}, {3803, 40.40447274896678}, {3806, 39.568796564237815}, {3809, 39.07804466925928}, {3812, 39.59388813521032}, {3813, 39.61292554954707}, {3816, 39.364325046233276}, {3818, 38.91030638030182}, {3820, 39.52465873164222}, {3823, 38.445919893706396}, {3825, 38.722751358387455}, {3828, 40.07164954275041}, {3832, 40.35632841195591}, {3833, 41.25954776973257}, {3837, 40.59686023107034}, {3839, 41.73206011126974}, {3840, 41.83313880921912}, {3843, 43.97481631223127}, {3845, 42.88682049659426}, {3849, 42.68248973003122}, {3850, 41.89851060373508}, {3854, 43.00859290667485}, {3857, 42.58554402244061}, {3858, 42.94977322974173}, {3861, 43.5526747563676}, {3864, 43.890847555316626}, {3867, 43.19271817040813}, {3869, 44.936354699949135}, {3872, 45.15805553382705}, {3873, 45.175146274315395}, {3875, 43.98425210064129}, {3879, 44.54003640246446}, {3882, 44.08660155118512}, {3884, 44.678908282742874}, {3887, 44.70003406608551}, {3889, 44.598427607594914}, {3892, 45.213056881203656}, {3893, 45.83751311620533}, {3895, 46.69554397624657}, {3898, 46.485265361946965}, {3901, 46.06654509998825}, {3903, 46.23083598006043}, {3905, 46.78507045779222}, {3909, 47.46573772776851}, {3910, 47.79168684198062}, {3913, 45.57512279475959}, {3915, 44.43233105401431}, {3919, 43.18101584512046}, {3922, 43.21124585054493}, {3923, 43.54158862241011}, {3925, 43.711364180631804}, {3928, 42.910583730646124}, {3930, 42.639952988135626}, {3933, 43.19594242280566}, {3937, 44.47718122890482}, {3938, 42.71893554253818}, {3941, 42.368141211578596}, {3944, 42.500109121456575}, {3947, 43.67566420376484}, {3949, 43.12282803410909}, {3950, 43.53504871953674}, {3953, 42.975278393392486}, {3957, 43.05005871018039}, {3959, 41.40330273303392}, {3962, 41.139227053508684}, {3963, 41.262957426835335}, {3965, 41.29178612732812}, {3968, 43.53636550586511}, {3971, 42.4092975371573}, {3973, 42.17938430330037}, {3977, 44.85103730540091}, {3978, 43.686022699020185}, {3980, 44.066949791075196}, {3984, 43.27719869525927}, {3985, 43.520080202226026}, {3988, 43.39572733345793}, {3991, 44.99085408453511}, {3993, 44.75608239056898}, {3997, 45.20628655580068}, {3999, 44.40459780963831}, {4000, 44.84911779417697}, {4003, 45.332476785661704}, {4007, 45.03190754404627}, {4008, 43.66039558703255}, {4012, 44.44658393531378}, {4013, 43.738910733073006}, {4015, 44.10630077043948}, {4019, 43.84846576986777}, {4020, 42.71505037386405}, {4023, 42.28588980382473}, {4025, 41.580902668274064}, {4029, 42.88514428175226}, {4032, 42.423161360690465}, {4034, 41.46983767233033}, {4037, 41.497581890358525}, {4039, 42.01458088760071}, {4042, 40.40121722063858}, {4044, 41.45596015966376}, {4047, 40.85226478482957}, {4049, 42.28054826801833}, {4052, 43.376033472640444}, {4054, 42.91653543267234}, {4056, 44.35550220099082}, {4058, 44.268994539070036}, {4061, 43.847891173179995}, {4064, 44.08049094209474}, {4065, 43.52840705131174}, {4069, 43.62469613986601}, {4072, 43.21270244719499}, {4074, 42.579441010470354}, {4076, 44.21857842681485}, {4079, 43.882145702606714}, {4082, 44.08280580012843}, {4084, 44.63027712418217}, {4087, 43.49185769105879}, {4089, 44.55770909655596}, {4091, 44.70529568081817}, {4093, 44.32192140208638}, {4096, 43.93629699159078}, {4099, 45.03381928301654}, {4102, 44.96315616449893}, {4103, 45.317252160358144}, {4105, 44.99809335119828}, {4108, 45.23753191697613}, {4110, 46.058774601853955}, {4114, 45.483336441906616}, {4116, 44.766511487040916}, {4118, 45.521105859507294}, {4122, 45.66840481231619}, {4124, 45.42131956848279}, {4125, 46.48565429648017}, {4128, 47.83269632839022}, {4130, 47.904859885869236}, {4133, 48.00314297086582}, {4135, 44.90413846099235}, {4139, 46.58227592497253}, {4140, 46.17055554294809}, {4143, 46.500309270278464}, {4147, 45.85490163160914}, {4149, 46.36607159615689}, {4150, 45.33765696135226}, {4153, 45.64354971534378}, {4157, 45.6060530616635}, {4159, 45.92037288384215}, {4160, 45.93018712100647}, {4163, 43.60804290415924}, {4167, 43.220797929589125}, {4169, 43.92613927037596}, {4171, 43.33758546950846}, {4174, 43.62114145159183}, {4176, 41.79257202974383}, {4178, 40.72846655122725}, {4181, 41.43693955839994}, {4183, 41.3152306690082}, {4186, 42.55329890940964}, {4189, 41.678572270110294}, {4192, 41.41582587790593}, {4193, 40.829011801535664}, {4197, 42.800600639022605}, {4198, 42.07267000939594}, {4202, 41.99633327331731}, {4204, 42.41931446868698}, {4207, 43.10274662201198}, {4210, 43.15253357742187}, {4211, 42.158082291323616}, {4215, 42.062223021469975}, {4217, 41.49506764318014}, {4218, 41.59881716888323}, {4221, 42.26187787539394}, {4223, 42.441042770154844}, {4226, 44.94461257206579}, {4228, 45.53797859707034}, {4232, 46.07574947104996}, {4233, 46.060884716412254}, {4236, 45.51959493255436}, {4239, 46.109945660686115}, {4242, 44.286086348874676}, {4245, 44.16033974830902}, {4247, 43.08447818539749}, {4250, 43.37829207780095}, {4251, 43.10867398251995}, {4254, 43.2384965784782}, {4257, 44.34389839798999}, {4258, 44.779096753781424}, {4262, 44.82258689695792}, {4265, 44.83403801956116}, {4267, 44.246909347585806}, {4269, 44.30870396354328}, {4271, 45.325741450057016}, {4273, 46.26696427252453}, {4277, 45.69088772324733}, {4278, 46.30744653697344}, {4282, 45.93683158647156}, {4284, 44.898780786668084}, {4286, 44.78129029650326}, {4290, 43.70136533034899}, {4292, 46.60711089281704}, {4293, 43.20999116221206}, {4297, 43.335817467294284}, {4300, 43.74264705432361}, {4302, 43.1793620620206}, {4303, 44.06844891439754}, {4307, 44.24245012746741}, {4309, 43.44755931800053}, {4312, 43.891606967283025}, {4313, 43.61609318450177}, {4316, 43.320512498718685}, {4320, 43.79297096639801}, {4322, 42.492817070603124}, {4324, 42.099203979340935}, {4327, 43.802920465762334}, {4329, 44.8390211407645}, {4331, 44.160162794499165}, {4334, 45.71896157142412}, {4336, 46.132237714004425}, {4339, 44.56756839730384}, {4341, 44.59101148982434}, {4343, 46.24568332480992}, {4346, 46.26785697686892}, {4348, 46.01333033455775}, {4351, 44.05034495051119}, {4355, 45.09815452419815}, {4356, 44.23545269297595}, {4358, 44.44376512206195}, {4361, 44.4297999192324}, {4365, 43.25758809794344}, {4366, 43.817908095986404}, {4368, 44.14477410502386}, {4371, 42.8796997482786}, {4373, 42.77727527309622}, {4376, 41.93028553518078}, {4378, 41.17204610689614}, {4382, 43.69386481163199}, {4384, 42.343580110976134}, {4387, 42.568896188906415}, {4388, 42.64410302487118}, {4391, 39.38331357790885}, {4394, 40.13352169285055}, {4397, 40.49257098503543}, {4400, 38.65146414419247}, {4402, 38.82824084957831}, {4405, 38.30201987865161}, {4406, 39.040498102853704}, {4410, 37.572863184633725}, {4411, 36.71659398164643}, {4414, 36.21992527315708}, {4417, 37.040712123103496}, {4418, 37.86983316239789}, {4421, 37.80334582875091}, {4424, 38.79645166307203}, {4426, 37.343389010610906}, {4429, 37.10878943344164}, {4431, 36.31927104688222}, {4433, 35.93959392178788}, {4436, 36.48729877130802}, {4439, 35.97790853205448}, {4441, 37.34763949569804}, {4443, 38.21664941647024}, {4447, 38.257644304614324}, {4450, 38.44876254366418}, {4452, 37.688682446222174}, {4455, 37.09540108270616}, {4457, 37.81369411954859}, {4458, 36.83626164610845}, {4462, 37.15237030254232}, {4463, 37.049394970609185}, {4466, 38.730315146387746}, {4469, 37.872865556491874}, {4471, 38.16788956159939}, {4473, 37.73726372456453}, {4477, 37.4556569056629}, {4478, 37.96421499308509}, {4482, 38.312564817548534}, {4484, 38.61409094278309}, {4487, 38.08371503820191}, {4488, 39.74784443380604}, {4492, 39.4716793618942}, {4495, 40.63456793316489}, {4496, 40.71073257614338}, {4498, 40.52093195142476}, {4502, 40.45124308705166}, {4504, 39.40056608371914}, {4506, 40.068292685250626}, {4508, 40.22426761068521}, {4512, 40.33883934166413}, {4514, 39.97935686013634}, {4517, 41.646176394626345}, {4519, 40.79730768415044}, {4521, 40.41889455210564}, {4524, 40.009568103338225}, {4527, 40.39015160569152}, {4529, 39.075001110176856}, {4531, 39.648058502641085}, {4533, 39.324207361611386}, {4536, 40.26787350849}, {4540, 40.66689326871952}, {4542, 39.934274637704824}, {4543, 40.300330136488476}, {4547, 40.061258001400915}, {4549, 40.450392865002364}, {4551, 41.296599615123064}, {4553, 41.90167025496052}, {4557, 42.10129865988418}, {4559, 42.826247977993646}, {4561, 42.667331833071664}, {4565, 43.2237675498371}, {4566, 43.86137004897719}, {4570, 43.33351237600878}, {4572, 44.14608921239006}, {4575, 42.10202383999383}, {4576, 42.045575631273714}, {4579, 41.46655883593124}, {4581, 42.28588201326873}, {4583, 41.752838975392386}, {4586, 41.9507666881852}, {4588, 41.95079936213436}, {4592, 42.11677669401778}, {4593, 41.43172999572018}, {4597, 41.81317893158739}, {4600, 41.53894095306525}, {4602, 41.885739012000045}, {4603, 42.06290639339678}, {4607, 42.40289053451183}, {4610, 42.003884006662666}, {4612, 42.43143955801055}, {4615, 42.50861804985267}, {4617, 43.2708291680743}, {4620, 43.02540169744918}, {4621, 43.03671781336059}, {4623, 43.620694664026104}, {4626, 45.984997240186246}, {4630, 44.651596037353286}, {4631, 45.8360412664365}, {4633, 45.34523081375098}, {4637, 45.729375501632695}, {4639, 46.97672701088541}, {4642, 46.176535515295534}, {4644, 46.07078753090914}, {4646, 45.55249821676164}, {4648, 46.657238306997954}, {4651, 46.75145539959066}, {4653, 47.87910231233235}, {4656, 48.14012518669324}, {4659, 47.75882142791673}, {4661, 49.44973560609625}, {4665, 49.361539089859946}, {4666, 48.923792508100405}, {4668, 48.696827533051106}, {4672, 49.08423254107231}, {4674, 48.38289408354073}, {4677, 48.54115658361094}, {4680, 47.732252711009075}, {4682, 44.72899549055614}, {4683, 44.55687451719093}, {4687, 44.08997798757562}, {4690, 44.77024206609575}, {4692, 44.29090624408688}, {4693, 43.49452874948875}, {4696, 42.887727362033345}, {4699, 40.804558836186786}, {4701, 41.52072176780903}, {4704, 41.49643711525131}, {4706, 42.254443486387316}, {4709, 42.978169988498536}, {4711, 42.92136840228886}, {4715, 42.40503671098323}, {4716, 41.51956996493458}, {4719, 41.642970570173034}, {4721, 41.15180912858265}, {4725, 42.69832068724076}, {4727, 45.87658310035213}, {4728, 43.6183451512828}, {4732, 44.01998787494774}, {4735, 43.28245959362667}, {4737, 42.81785284737095}, {4739, 42.53626377548142}, {4741, 44.1194336467924}, {4744, 44.52826323886761}, {4746, 44.23885158768107}, {4750, 43.47296751071649}, {4752, 43.53066942512155}, {4754, 44.60107183314088}, {4756, 42.99334677650617}, {4760, 41.15252150405892}, {4761, 41.65062666173321}, {4763, 41.80167602812174}, {4766, 40.44563966701578}, {4769, 40.88937124246862}, {4772, 41.98448907911279}, {4774, 41.831147917269575}, {4777, 41.31691388756026}, {4779, 40.66303052923502}, {4782, 41.224220277952135}, {4784, 41.19227291002064}, {4786, 41.793314227583664}, {4788, 41.147687532911064}, {4791, 41.8142881123724}, {4795, 40.810470695252555}, {4797, 40.9449761604474}, {4798, 41.15181950532048}, {4802, 40.980911652896054}, {4803, 41.734203454889105}, {4806, 41.51414417468774}, {4808, 42.70943804743709}, {4812, 42.62139441696377}, {4813, 41.94637435030276}, {4816, 42.28223265087694}, {4820, 41.359861111288104}, {4822, 42.24941093960088}, {4824, 41.21364184446058}, {4826, 42.53601771160175}, {4830, 42.76148923124109}, {4831, 43.55500018064631}, {4835, 42.75390903216747}, {4837, 43.365066775687346}, {4840, 43.989916759215}, {4841, 43.56253598246386}, {4845, 42.58288520924721}, {4847, 42.65060540788467}, {4849, 41.646360968682984}, {4851, 41.10868413269653}, {4853, 41.36004588804885}, {4856, 39.88125368753376}, {4860, 40.67992036846289}, {4861, 39.19323041879348}, {4864, 38.018950718551935}, {4867, 37.71021607139222}, {4868, 38.422846767406455}, {4871, 38.34361998177123}, {4873, 39.5198852558182}, {4876, 39.37969949452826}, {4878, 39.66661286220836}, {4882, 41.20372788803875}, {4883, 41.40919784184403}, {4886, 41.63320805924114}, {4888, 41.59463339227347}, {4891, 42.51566334270849}, {4893, 42.65573412390896}, {4897, 42.063060621486514}, {4898, 40.8631606909062}, {4902, 40.08190763242786}, {4904, 40.97087104137605}, {4906, 41.27896864220977}, {4909, 41.19823454109512}, {4912, 40.22428726447587}, {4913, 38.86084836942058}, {4916, 38.64467182897344}, {4918, 38.929014450694986}, {4921, 38.66300047873025}, {4923, 38.29265621342109}, {4926, 39.34561928924596}, {4928, 39.753432401888055}, {4931, 39.74434633216348}, {4935, 38.77958154299146}, {4937, 38.84416930772779}, {4939, 38.13839982421345}, {4941, 38.384878790359856}, {4944, 37.27571543485687}, {4947, 37.686425234248986}, {4949, 37.64359097418195}, {4952, 36.826705097979186}, {4953, 36.10850429296769}, {4956, 35.877106950223286}, {4960, 33.9039081124664}, {4961, 34.50994734260132}, {4965, 33.18029169046981}, {4966, 33.74849740086445}, {4970, 33.94382441333488}, {4971, 33.56341790269826}, {4975, 33.76379562158691}, {4977, 32.8267558087521}, {4979, 32.55733463964615}, {4982, 33.73081923269426}, {4984, 35.07176548766099}, {4986, 35.471233571041964}, {4989, 34.37111074112498}, {4992, 34.36407537164143}, {4994, 34.71701325993874}, {4998, 33.21364571883214}, {4999, 34.07622604782128}},
}
