/*
Copyright 2021 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
	kafkav1alpha1 "knative.dev/eventing-kafka/pkg/apis/kafka/v1alpha1"
	versioned "knative.dev/eventing-kafka/pkg/client/clientset/versioned"
	internalinterfaces "knative.dev/eventing-kafka/pkg/client/informers/externalversions/internalinterfaces"
	v1alpha1 "knative.dev/eventing-kafka/pkg/client/listers/kafka/v1alpha1"
)

// ResetOffsetInformer provides access to a shared informer and lister for
// ResetOffsets.
type ResetOffsetInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1alpha1.ResetOffsetLister
}

type resetOffsetInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewResetOffsetInformer constructs a new informer for ResetOffset type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewResetOffsetInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredResetOffsetInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredResetOffsetInformer constructs a new informer for ResetOffset type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredResetOffsetInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.KafkaV1alpha1().ResetOffsets(namespace).List(context.TODO(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.KafkaV1alpha1().ResetOffsets(namespace).Watch(context.TODO(), options)
			},
		},
		&kafkav1alpha1.ResetOffset{},
		resyncPeriod,
		indexers,
	)
}

func (f *resetOffsetInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredResetOffsetInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *resetOffsetInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&kafkav1alpha1.ResetOffset{}, f.defaultInformer)
}

func (f *resetOffsetInformer) Lister() v1alpha1.ResetOffsetLister {
	return v1alpha1.NewResetOffsetLister(f.Informer().GetIndexer())
}
