/*
Copyright 2019 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package resources

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
)

const (
	// controllerAgentName is the string used by this controller to identify
	// itself when creating events.
	controllerAgentName = "kafka-source-controller"
)

func GetLabels(name string) map[string]string {
	return map[string]string{
		"eventing.knative.dev/source":     controllerAgentName,
		"eventing.knative.dev/sourceName": name,
	}
}

// GetLabelsAsSelector returns labels wrapped as Selector object
func GetLabelsAsSelector(name string) (labels.Selector, error) {
	labels := GetLabels(name)
	var labelSelector metav1.LabelSelector
	labelSelector.MatchLabels = labels
	selector, err := metav1.LabelSelectorAsSelector(&labelSelector)
	return selector, err
}
