/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1alpha1 "knative.dev/eventing-kafka/pkg/apis/sources/v1alpha1"
)

// KafkaSourceLister helps list KafkaSources.
type KafkaSourceLister interface {
	// List lists all KafkaSources in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.KafkaSource, err error)
	// KafkaSources returns an object that can list and get KafkaSources.
	KafkaSources(namespace string) KafkaSourceNamespaceLister
	KafkaSourceListerExpansion
}

// kafkaSourceLister implements the KafkaSourceLister interface.
type kafkaSourceLister struct {
	indexer cache.Indexer
}

// NewKafkaSourceLister returns a new KafkaSourceLister.
func NewKafkaSourceLister(indexer cache.Indexer) KafkaSourceLister {
	return &kafkaSourceLister{indexer: indexer}
}

// List lists all KafkaSources in the indexer.
func (s *kafkaSourceLister) List(selector labels.Selector) (ret []*v1alpha1.KafkaSource, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.KafkaSource))
	})
	return ret, err
}

// KafkaSources returns an object that can list and get KafkaSources.
func (s *kafkaSourceLister) KafkaSources(namespace string) KafkaSourceNamespaceLister {
	return kafkaSourceNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// KafkaSourceNamespaceLister helps list and get KafkaSources.
type KafkaSourceNamespaceLister interface {
	// List lists all KafkaSources in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.KafkaSource, err error)
	// Get retrieves the KafkaSource from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.KafkaSource, error)
	KafkaSourceNamespaceListerExpansion
}

// kafkaSourceNamespaceLister implements the KafkaSourceNamespaceLister
// interface.
type kafkaSourceNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all KafkaSources in the indexer for a given namespace.
func (s kafkaSourceNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.KafkaSource, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.KafkaSource))
	})
	return ret, err
}

// Get retrieves the KafkaSource from the indexer for a given namespace and name.
func (s kafkaSourceNamespaceLister) Get(name string) (*v1alpha1.KafkaSource, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("kafkasource"), name)
	}
	return obj.(*v1alpha1.KafkaSource), nil
}
