/*
Copyright 2021 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package pod

import (
	"context"

	"knative.dev/reconciler-test/pkg/feature"
	"knative.dev/reconciler-test/pkg/manifest"
)

// Install will create a Pod with defaults that can be overwritten by
// the With* methods.
func Install(name string, opts ...manifest.CfgFn) feature.StepFn {
	cfg := map[string]interface{}{
		"name":   name,
		"labels": map[string]string{"app": name},         // default
		"image":  "gcr.io/knative-samples/helloworld-go", // default
		"port":   8080,                                   // default
	}

	for _, fn := range opts {
		fn(cfg)
	}

	return func(ctx context.Context, t feature.T) {
		if _, err := manifest.InstallLocalYaml(ctx, cfg); err != nil {
			t.Fatal(err)
		}
	}
}

// WithLabels sets the given labels on the Pod.
func WithLabels(labels map[string]string) manifest.CfgFn {
	return func(cfg map[string]interface{}) {
		if labels != nil {
			cfg["labels"] = labels
		}
	}
}

// WithImage sets the given image on the Pod spec.
func WithImage(image string) manifest.CfgFn {
	return func(cfg map[string]interface{}) {
		if image != "" {
			cfg["image"] = image
		}
	}
}
