/*
Copyright (c) 2014-2021 VMware, Inc. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package types

import (
	"reflect"

	"github.com/vmware/govmomi/vim25/types"
)

func (b *VslmFault) GetVslmFault() *VslmFault { return b }

type BaseVslmFault interface {
	GetVslmFault() *VslmFault
}

func init() {
	types.Add("BaseVslmFault", reflect.TypeOf((*VslmFault)(nil)).Elem())
}

func (b *VslmTaskReason) GetVslmTaskReason() *VslmTaskReason { return b }

type BaseVslmTaskReason interface {
	GetVslmTaskReason() *VslmTaskReason
}

func init() {
	types.Add("BaseVslmTaskReason", reflect.TypeOf((*VslmTaskReason)(nil)).Elem())
}
