<!-- markdownlint-disable MD033 -->

# vSphere CSI Driver - Supported Features Matrix

|                                                          | **Native K8s on vSphere 6.7U3 with CSI v1.0.2, v1.0.3, v2.0.0, v2.0.1, v2.1.0, v2.1.1** | **Native K8s on vSphere 7.0 with CSI v2.0.0, v2.0.1, v2.1.0, v2.1.1** | **Native K8s on vSphere 7.0u1 with CSI v2.1.0, v2.1.1** | **vSphere with Tanzu on vSphere 7.0 – Supervisor Cluster** | **vSphere with Tanzu on vSphere 7.0u1 – Supervisor Cluster** | **vSphere with Tanzu on vSphere 7.0 – TKG Service ‘Guest’ Cluster** | **vSphere with Tanzu on vSphere 7.0u1 – TKG Service ‘Guest’ Cluster** |
|----------------------------------------------------------|:-------------------------------------------------------------------------------:|:-------------------------------------------------------------:|:-----------------------------------------------:|:----------------------------------------------------------:|:------------------------------------------------------------:|:-------------------------------------------------------------------:|:---------------------------------------------------------------------:|
| CNS UI Support                                           | Yes                                                                             | Yes                                                           | Yes                                             | Yes                                                        | Yes                                                          | Yes                                                                 | Yes                                                                   |
| Enhanced Object Health in UI                             | Yes (vSAN only)                                                                 | Yes (vSAN only)                                               | Yes (vSAN only)                                 | Yes (vSAN only)                                            | Yes (vSAN only)                                              | Yes (vSAN only)                                                     | Yes (vSAN only)                                                       |
| Dynamic Block PV support (`Read-Write-Once` Access Mode) | Yes                                                                             | Yes                                                           | Yes                                             | Yes                                                        | Yes                                                          | Yes                                                                 | Yes                                                                   |
| Dynamic File PV support (`Read-Write-Many` Access Mode)  | No                                                                              | Yes (vSAN only)                                               | Yes (vSAN only)                                 | No                                                         | No                                                           | No                                                                  | No                                                                    |
| Encryption support via VMcrypt                           | No                                                                              | Yes (Block Volume)                                            | Yes (Block Volume)                              | No                                                         | No                                                           | No                                                                  | No                                                                    |
| Dynamic Virtual Volume (vVOL) PV support                 | Yes                                                                             | Yes                                                           | Yes                                             | Yes                                                        | Yes                                                          | Yes                                                                 | Yes                                                                   |
| Offline Volume Expansion support (beta)                  | No                                                                              | Yes (Block Volume)                                            | Yes (Block Volume)                              | No                                                         | No                                                           | No                                                                  | Yes (Block Volume)                                                    |
| Topology/Availability Zone support (beta)                | Yes (Block Volume)                                                              | Yes (Block Volume)                                            | Yes (Block Volume)                              | No                                                         | No                                                           | No                                                                  | No                                                                    |
| Static PV Provisioning                                   | Yes                                                                             | Yes                                                           | Yes                                             | No                                                         | Yes                                                          | Yes                                                                 | Yes                                                                   |
| K8s Multi-node Control Plane support                     | Yes                                                                             | Yes                                                           | Yes                                             | Yes                                                        | Yes                                                          | Yes                                                                 | Yes                                                                   |
| `WaitForFirstConsumer` (beta)                            | Yes                                                                             | Yes                                                           | Yes                                             | No                                                         | No                                                           | No                                                                  | No                                                                    |
| Volume Health                                            | No                                                                              | No                                                            | No                                              | No                                                         | Yes (Block Volume)                                           | No                                                                  | Yes (Block Volume)                                                    |
| In-tree vSphere volume migration to CSI (beta)           | No                                                                              | No                                                            | Yes                                             | Not Applicable                                             | Not Applicable                                               | Not Applicable                                                      | Not Applicable                                                        |

_Notes_:

* We do not recommend `beta` features for production use. Subsequent releases may introduce incompatible changes.
* vSphere CSI driver is not supported on Windows based vCenter.
* vSphere CSI driver is not supported on vSAN stretch cluster.
* vSphere CSI driver and Cloud Native Storage in vSphere does not currently support Storage DRS feature in vSphere.
* The dynamic creation of read-write-many (`RWX`) and read-only-many (`ROX`) file based Persistent Volumes is only available in vSphere 7.0 through vSAN 7.0 File Services.
* PV Encryption, offline volume expansion and Topology/AZ support are only available on block based Persistent Volumes. These features are not available with PVs backed by file shares.
* Offline volume expansion requires a minimum Kubernetes version of 1.16+.
* Multi-node Control Planes only supports having a single CSI Pod being active at any time (replica = 1 in controller manifest).
* [`WaitForFirstConsumer`](https://kubernetes.io/docs/concepts/storage/storage-classes/) is a K8s feature that delays volume binding until the Pod has been scheduled, and is used for Pod and PV placement.
