// Code generated by go-swagger; DO NOT EDIT.

// Copyright Prometheus Team
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package silence

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/swag"

	strfmt "github.com/go-openapi/strfmt"
)

// PostSilencesReader is a Reader for the PostSilences structure.
type PostSilencesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PostSilencesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {

	case 200:
		result := NewPostSilencesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil

	case 400:
		result := NewPostSilencesBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 404:
		result := NewPostSilencesNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("unknown error", response, response.Code())
	}
}

// NewPostSilencesOK creates a PostSilencesOK with default headers values
func NewPostSilencesOK() *PostSilencesOK {
	return &PostSilencesOK{}
}

/*PostSilencesOK handles this case with default header values.

Create / update silence response
*/
type PostSilencesOK struct {
	Payload *PostSilencesOKBody
}

func (o *PostSilencesOK) Error() string {
	return fmt.Sprintf("[POST /silences][%d] postSilencesOK  %+v", 200, o.Payload)
}

func (o *PostSilencesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(PostSilencesOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPostSilencesBadRequest creates a PostSilencesBadRequest with default headers values
func NewPostSilencesBadRequest() *PostSilencesBadRequest {
	return &PostSilencesBadRequest{}
}

/*PostSilencesBadRequest handles this case with default header values.

Bad request
*/
type PostSilencesBadRequest struct {
	Payload string
}

func (o *PostSilencesBadRequest) Error() string {
	return fmt.Sprintf("[POST /silences][%d] postSilencesBadRequest  %+v", 400, o.Payload)
}

func (o *PostSilencesBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPostSilencesNotFound creates a PostSilencesNotFound with default headers values
func NewPostSilencesNotFound() *PostSilencesNotFound {
	return &PostSilencesNotFound{}
}

/*PostSilencesNotFound handles this case with default header values.

A silence with the specified ID was not found
*/
type PostSilencesNotFound struct {
	Payload string
}

func (o *PostSilencesNotFound) Error() string {
	return fmt.Sprintf("[POST /silences][%d] postSilencesNotFound  %+v", 404, o.Payload)
}

func (o *PostSilencesNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*PostSilencesOKBody post silences o k body
swagger:model PostSilencesOKBody
*/
type PostSilencesOKBody struct {

	// silence ID
	SilenceID string `json:"silenceID,omitempty"`
}

// Validate validates this post silences o k body
func (o *PostSilencesOKBody) Validate(formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PostSilencesOKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PostSilencesOKBody) UnmarshalBinary(b []byte) error {
	var res PostSilencesOKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
