package documentdbapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/cosmos-db/mgmt/2015-04-08/documentdb"
	"github.com/Azure/go-autorest/autorest"
)

// DatabaseAccountsClientAPI contains the set of methods on the DatabaseAccountsClient type.
type DatabaseAccountsClientAPI interface {
	CheckNameExists(ctx context.Context, accountName string) (result autorest.Response, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, accountName string, createUpdateParameters documentdb.DatabaseAccountCreateUpdateParameters) (result documentdb.DatabaseAccountsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.DatabaseAccountsDeleteFuture, err error)
	FailoverPriorityChange(ctx context.Context, resourceGroupName string, accountName string, failoverParameters documentdb.FailoverPolicies) (result documentdb.DatabaseAccountsFailoverPriorityChangeFuture, err error)
	Get(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.DatabaseAccount, err error)
	GetReadOnlyKeys(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.DatabaseAccountListReadOnlyKeysResult, err error)
	List(ctx context.Context) (result documentdb.DatabaseAccountsListResult, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result documentdb.DatabaseAccountsListResult, err error)
	ListConnectionStrings(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.DatabaseAccountListConnectionStringsResult, err error)
	ListKeys(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.DatabaseAccountListKeysResult, err error)
	ListMetricDefinitions(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.MetricDefinitionsListResult, err error)
	ListMetrics(ctx context.Context, resourceGroupName string, accountName string, filter string) (result documentdb.MetricListResult, err error)
	ListReadOnlyKeys(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.DatabaseAccountListReadOnlyKeysResult, err error)
	ListUsages(ctx context.Context, resourceGroupName string, accountName string, filter string) (result documentdb.UsagesResult, err error)
	OfflineRegion(ctx context.Context, resourceGroupName string, accountName string, regionParameterForOffline documentdb.RegionForOnlineOffline) (result documentdb.DatabaseAccountsOfflineRegionFuture, err error)
	OnlineRegion(ctx context.Context, resourceGroupName string, accountName string, regionParameterForOnline documentdb.RegionForOnlineOffline) (result documentdb.DatabaseAccountsOnlineRegionFuture, err error)
	Patch(ctx context.Context, resourceGroupName string, accountName string, updateParameters documentdb.DatabaseAccountPatchParameters) (result documentdb.DatabaseAccountsPatchFuture, err error)
	RegenerateKey(ctx context.Context, resourceGroupName string, accountName string, keyToRegenerate documentdb.DatabaseAccountRegenerateKeyParameters) (result documentdb.DatabaseAccountsRegenerateKeyFuture, err error)
}

var _ DatabaseAccountsClientAPI = (*documentdb.DatabaseAccountsClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result documentdb.OperationListResultPage, err error)
}

var _ OperationsClientAPI = (*documentdb.OperationsClient)(nil)

// DatabaseClientAPI contains the set of methods on the DatabaseClient type.
type DatabaseClientAPI interface {
	ListMetricDefinitions(ctx context.Context, resourceGroupName string, accountName string, databaseRid string) (result documentdb.MetricDefinitionsListResult, err error)
	ListMetrics(ctx context.Context, resourceGroupName string, accountName string, databaseRid string, filter string) (result documentdb.MetricListResult, err error)
	ListUsages(ctx context.Context, resourceGroupName string, accountName string, databaseRid string, filter string) (result documentdb.UsagesResult, err error)
}

var _ DatabaseClientAPI = (*documentdb.DatabaseClient)(nil)

// CollectionClientAPI contains the set of methods on the CollectionClient type.
type CollectionClientAPI interface {
	ListMetricDefinitions(ctx context.Context, resourceGroupName string, accountName string, databaseRid string, collectionRid string) (result documentdb.MetricDefinitionsListResult, err error)
	ListMetrics(ctx context.Context, resourceGroupName string, accountName string, databaseRid string, collectionRid string, filter string) (result documentdb.MetricListResult, err error)
	ListUsages(ctx context.Context, resourceGroupName string, accountName string, databaseRid string, collectionRid string, filter string) (result documentdb.UsagesResult, err error)
}

var _ CollectionClientAPI = (*documentdb.CollectionClient)(nil)

// CollectionRegionClientAPI contains the set of methods on the CollectionRegionClient type.
type CollectionRegionClientAPI interface {
	ListMetrics(ctx context.Context, resourceGroupName string, accountName string, region string, databaseRid string, collectionRid string, filter string) (result documentdb.MetricListResult, err error)
}

var _ CollectionRegionClientAPI = (*documentdb.CollectionRegionClient)(nil)

// DatabaseAccountRegionClientAPI contains the set of methods on the DatabaseAccountRegionClient type.
type DatabaseAccountRegionClientAPI interface {
	ListMetrics(ctx context.Context, resourceGroupName string, accountName string, region string, filter string) (result documentdb.MetricListResult, err error)
}

var _ DatabaseAccountRegionClientAPI = (*documentdb.DatabaseAccountRegionClient)(nil)

// PercentileSourceTargetClientAPI contains the set of methods on the PercentileSourceTargetClient type.
type PercentileSourceTargetClientAPI interface {
	ListMetrics(ctx context.Context, resourceGroupName string, accountName string, sourceRegion string, targetRegion string, filter string) (result documentdb.PercentileMetricListResult, err error)
}

var _ PercentileSourceTargetClientAPI = (*documentdb.PercentileSourceTargetClient)(nil)

// PercentileTargetClientAPI contains the set of methods on the PercentileTargetClient type.
type PercentileTargetClientAPI interface {
	ListMetrics(ctx context.Context, resourceGroupName string, accountName string, targetRegion string, filter string) (result documentdb.PercentileMetricListResult, err error)
}

var _ PercentileTargetClientAPI = (*documentdb.PercentileTargetClient)(nil)

// PercentileClientAPI contains the set of methods on the PercentileClient type.
type PercentileClientAPI interface {
	ListMetrics(ctx context.Context, resourceGroupName string, accountName string, filter string) (result documentdb.PercentileMetricListResult, err error)
}

var _ PercentileClientAPI = (*documentdb.PercentileClient)(nil)

// CollectionPartitionRegionClientAPI contains the set of methods on the CollectionPartitionRegionClient type.
type CollectionPartitionRegionClientAPI interface {
	ListMetrics(ctx context.Context, resourceGroupName string, accountName string, region string, databaseRid string, collectionRid string, filter string) (result documentdb.PartitionMetricListResult, err error)
}

var _ CollectionPartitionRegionClientAPI = (*documentdb.CollectionPartitionRegionClient)(nil)

// CollectionPartitionClientAPI contains the set of methods on the CollectionPartitionClient type.
type CollectionPartitionClientAPI interface {
	ListMetrics(ctx context.Context, resourceGroupName string, accountName string, databaseRid string, collectionRid string, filter string) (result documentdb.PartitionMetricListResult, err error)
	ListUsages(ctx context.Context, resourceGroupName string, accountName string, databaseRid string, collectionRid string, filter string) (result documentdb.PartitionUsagesResult, err error)
}

var _ CollectionPartitionClientAPI = (*documentdb.CollectionPartitionClient)(nil)

// PartitionKeyRangeIDClientAPI contains the set of methods on the PartitionKeyRangeIDClient type.
type PartitionKeyRangeIDClientAPI interface {
	ListMetrics(ctx context.Context, resourceGroupName string, accountName string, databaseRid string, collectionRid string, partitionKeyRangeID string, filter string) (result documentdb.PartitionMetricListResult, err error)
}

var _ PartitionKeyRangeIDClientAPI = (*documentdb.PartitionKeyRangeIDClient)(nil)

// PartitionKeyRangeIDRegionClientAPI contains the set of methods on the PartitionKeyRangeIDRegionClient type.
type PartitionKeyRangeIDRegionClientAPI interface {
	ListMetrics(ctx context.Context, resourceGroupName string, accountName string, region string, databaseRid string, collectionRid string, partitionKeyRangeID string, filter string) (result documentdb.PartitionMetricListResult, err error)
}

var _ PartitionKeyRangeIDRegionClientAPI = (*documentdb.PartitionKeyRangeIDRegionClient)(nil)
