/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/k8snetworkplumbingwg/sriov-network-operator/api/v1"
	scheme "github.com/k8snetworkplumbingwg/sriov-network-operator/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// SriovNetworkNodePoliciesGetter has a method to return a SriovNetworkNodePolicyInterface.
// A group's client should implement this interface.
type SriovNetworkNodePoliciesGetter interface {
	SriovNetworkNodePolicies(namespace string) SriovNetworkNodePolicyInterface
}

// SriovNetworkNodePolicyInterface has methods to work with SriovNetworkNodePolicy resources.
type SriovNetworkNodePolicyInterface interface {
	Create(ctx context.Context, sriovNetworkNodePolicy *v1.SriovNetworkNodePolicy, opts metav1.CreateOptions) (*v1.SriovNetworkNodePolicy, error)
	Update(ctx context.Context, sriovNetworkNodePolicy *v1.SriovNetworkNodePolicy, opts metav1.UpdateOptions) (*v1.SriovNetworkNodePolicy, error)
	UpdateStatus(ctx context.Context, sriovNetworkNodePolicy *v1.SriovNetworkNodePolicy, opts metav1.UpdateOptions) (*v1.SriovNetworkNodePolicy, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.SriovNetworkNodePolicy, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.SriovNetworkNodePolicyList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.SriovNetworkNodePolicy, err error)
	SriovNetworkNodePolicyExpansion
}

// sriovNetworkNodePolicies implements SriovNetworkNodePolicyInterface
type sriovNetworkNodePolicies struct {
	client rest.Interface
	ns     string
}

// newSriovNetworkNodePolicies returns a SriovNetworkNodePolicies
func newSriovNetworkNodePolicies(c *SriovnetworkV1Client, namespace string) *sriovNetworkNodePolicies {
	return &sriovNetworkNodePolicies{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the sriovNetworkNodePolicy, and returns the corresponding sriovNetworkNodePolicy object, and an error if there is any.
func (c *sriovNetworkNodePolicies) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.SriovNetworkNodePolicy, err error) {
	result = &v1.SriovNetworkNodePolicy{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("sriovnetworknodepolicies").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of SriovNetworkNodePolicies that match those selectors.
func (c *sriovNetworkNodePolicies) List(ctx context.Context, opts metav1.ListOptions) (result *v1.SriovNetworkNodePolicyList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.SriovNetworkNodePolicyList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("sriovnetworknodepolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested sriovNetworkNodePolicies.
func (c *sriovNetworkNodePolicies) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("sriovnetworknodepolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a sriovNetworkNodePolicy and creates it.  Returns the server's representation of the sriovNetworkNodePolicy, and an error, if there is any.
func (c *sriovNetworkNodePolicies) Create(ctx context.Context, sriovNetworkNodePolicy *v1.SriovNetworkNodePolicy, opts metav1.CreateOptions) (result *v1.SriovNetworkNodePolicy, err error) {
	result = &v1.SriovNetworkNodePolicy{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("sriovnetworknodepolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(sriovNetworkNodePolicy).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a sriovNetworkNodePolicy and updates it. Returns the server's representation of the sriovNetworkNodePolicy, and an error, if there is any.
func (c *sriovNetworkNodePolicies) Update(ctx context.Context, sriovNetworkNodePolicy *v1.SriovNetworkNodePolicy, opts metav1.UpdateOptions) (result *v1.SriovNetworkNodePolicy, err error) {
	result = &v1.SriovNetworkNodePolicy{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("sriovnetworknodepolicies").
		Name(sriovNetworkNodePolicy.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(sriovNetworkNodePolicy).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *sriovNetworkNodePolicies) UpdateStatus(ctx context.Context, sriovNetworkNodePolicy *v1.SriovNetworkNodePolicy, opts metav1.UpdateOptions) (result *v1.SriovNetworkNodePolicy, err error) {
	result = &v1.SriovNetworkNodePolicy{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("sriovnetworknodepolicies").
		Name(sriovNetworkNodePolicy.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(sriovNetworkNodePolicy).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the sriovNetworkNodePolicy and deletes it. Returns an error if one occurs.
func (c *sriovNetworkNodePolicies) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("sriovnetworknodepolicies").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *sriovNetworkNodePolicies) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("sriovnetworknodepolicies").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched sriovNetworkNodePolicy.
func (c *sriovNetworkNodePolicies) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.SriovNetworkNodePolicy, err error) {
	result = &v1.SriovNetworkNodePolicy{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("sriovnetworknodepolicies").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
