// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package securityhub

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAcceptInvitation = "AcceptInvitation"

// AcceptInvitationRequest generates a "aws/request.Request" representing the
// client's request for the AcceptInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptInvitation for more information on using the AcceptInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcceptInvitationRequest method.
//    req, resp := client.AcceptInvitationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptInvitation
func (c *SecurityHub) AcceptInvitationRequest(input *AcceptInvitationInput) (req *request.Request, output *AcceptInvitationOutput) {
	op := &request.Operation{
		Name:       opAcceptInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/master",
	}

	if input == nil {
		input = &AcceptInvitationInput{}
	}

	output = &AcceptInvitationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AcceptInvitation API operation for AWS SecurityHub.
//
// Accepts the invitation to be monitored by a master SecurityHub account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation AcceptInvitation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The request was rejected because the specified resource cannot be found.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptInvitation
func (c *SecurityHub) AcceptInvitation(input *AcceptInvitationInput) (*AcceptInvitationOutput, error) {
	req, out := c.AcceptInvitationRequest(input)
	return out, req.Send()
}

// AcceptInvitationWithContext is the same as AcceptInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) AcceptInvitationWithContext(ctx aws.Context, input *AcceptInvitationInput, opts ...request.Option) (*AcceptInvitationOutput, error) {
	req, out := c.AcceptInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDisableStandards = "BatchDisableStandards"

// BatchDisableStandardsRequest generates a "aws/request.Request" representing the
// client's request for the BatchDisableStandards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDisableStandards for more information on using the BatchDisableStandards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDisableStandardsRequest method.
//    req, resp := client.BatchDisableStandardsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchDisableStandards
func (c *SecurityHub) BatchDisableStandardsRequest(input *BatchDisableStandardsInput) (req *request.Request, output *BatchDisableStandardsOutput) {
	op := &request.Operation{
		Name:       opBatchDisableStandards,
		HTTPMethod: "POST",
		HTTPPath:   "/standards/deregister",
	}

	if input == nil {
		input = &BatchDisableStandardsInput{}
	}

	output = &BatchDisableStandardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDisableStandards API operation for AWS SecurityHub.
//
// Disables the standards specified by the standards subscription ARNs. In the
// context of Security Hub, supported standards (for example, CIS AWS Foundations)
// are automated and continuous checks that help determine your compliance status
// against security industry (including AWS) best practices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation BatchDisableStandards for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchDisableStandards
func (c *SecurityHub) BatchDisableStandards(input *BatchDisableStandardsInput) (*BatchDisableStandardsOutput, error) {
	req, out := c.BatchDisableStandardsRequest(input)
	return out, req.Send()
}

// BatchDisableStandardsWithContext is the same as BatchDisableStandards with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDisableStandards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) BatchDisableStandardsWithContext(ctx aws.Context, input *BatchDisableStandardsInput, opts ...request.Option) (*BatchDisableStandardsOutput, error) {
	req, out := c.BatchDisableStandardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchEnableStandards = "BatchEnableStandards"

// BatchEnableStandardsRequest generates a "aws/request.Request" representing the
// client's request for the BatchEnableStandards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchEnableStandards for more information on using the BatchEnableStandards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchEnableStandardsRequest method.
//    req, resp := client.BatchEnableStandardsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchEnableStandards
func (c *SecurityHub) BatchEnableStandardsRequest(input *BatchEnableStandardsInput) (req *request.Request, output *BatchEnableStandardsOutput) {
	op := &request.Operation{
		Name:       opBatchEnableStandards,
		HTTPMethod: "POST",
		HTTPPath:   "/standards/register",
	}

	if input == nil {
		input = &BatchEnableStandardsInput{}
	}

	output = &BatchEnableStandardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchEnableStandards API operation for AWS SecurityHub.
//
// Enables the standards specified by the standards ARNs. In the context of
// Security Hub, supported standards (for example, CIS AWS Foundations) are
// automated and continuous checks that help determine your compliance status
// against security industry (including AWS) best practices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation BatchEnableStandards for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchEnableStandards
func (c *SecurityHub) BatchEnableStandards(input *BatchEnableStandardsInput) (*BatchEnableStandardsOutput, error) {
	req, out := c.BatchEnableStandardsRequest(input)
	return out, req.Send()
}

// BatchEnableStandardsWithContext is the same as BatchEnableStandards with the addition of
// the ability to pass a context and additional request options.
//
// See BatchEnableStandards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) BatchEnableStandardsWithContext(ctx aws.Context, input *BatchEnableStandardsInput, opts ...request.Option) (*BatchEnableStandardsOutput, error) {
	req, out := c.BatchEnableStandardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchImportFindings = "BatchImportFindings"

// BatchImportFindingsRequest generates a "aws/request.Request" representing the
// client's request for the BatchImportFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchImportFindings for more information on using the BatchImportFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchImportFindingsRequest method.
//    req, resp := client.BatchImportFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchImportFindings
func (c *SecurityHub) BatchImportFindingsRequest(input *BatchImportFindingsInput) (req *request.Request, output *BatchImportFindingsOutput) {
	op := &request.Operation{
		Name:       opBatchImportFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/findings/import",
	}

	if input == nil {
		input = &BatchImportFindingsInput{}
	}

	output = &BatchImportFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchImportFindings API operation for AWS SecurityHub.
//
// Imports security findings that are generated by the integrated third-party
// products into Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation BatchImportFindings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchImportFindings
func (c *SecurityHub) BatchImportFindings(input *BatchImportFindingsInput) (*BatchImportFindingsOutput, error) {
	req, out := c.BatchImportFindingsRequest(input)
	return out, req.Send()
}

// BatchImportFindingsWithContext is the same as BatchImportFindings with the addition of
// the ability to pass a context and additional request options.
//
// See BatchImportFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) BatchImportFindingsWithContext(ctx aws.Context, input *BatchImportFindingsInput, opts ...request.Option) (*BatchImportFindingsOutput, error) {
	req, out := c.BatchImportFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInsight = "CreateInsight"

// CreateInsightRequest generates a "aws/request.Request" representing the
// client's request for the CreateInsight operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInsight for more information on using the CreateInsight
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInsightRequest method.
//    req, resp := client.CreateInsightRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateInsight
func (c *SecurityHub) CreateInsightRequest(input *CreateInsightInput) (req *request.Request, output *CreateInsightOutput) {
	op := &request.Operation{
		Name:       opCreateInsight,
		HTTPMethod: "POST",
		HTTPPath:   "/insights",
	}

	if input == nil {
		input = &CreateInsightInput{}
	}

	output = &CreateInsightOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInsight API operation for AWS SecurityHub.
//
// Creates an insight, which is a consolidation of findings that identifies
// a security area that requires attention or intervention.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation CreateInsight for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   The resource specified in the request conflicts with an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateInsight
func (c *SecurityHub) CreateInsight(input *CreateInsightInput) (*CreateInsightOutput, error) {
	req, out := c.CreateInsightRequest(input)
	return out, req.Send()
}

// CreateInsightWithContext is the same as CreateInsight with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInsight for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) CreateInsightWithContext(ctx aws.Context, input *CreateInsightInput, opts ...request.Option) (*CreateInsightOutput, error) {
	req, out := c.CreateInsightRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMembers = "CreateMembers"

// CreateMembersRequest generates a "aws/request.Request" representing the
// client's request for the CreateMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMembers for more information on using the CreateMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMembersRequest method.
//    req, resp := client.CreateMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateMembers
func (c *SecurityHub) CreateMembersRequest(input *CreateMembersInput) (req *request.Request, output *CreateMembersOutput) {
	op := &request.Operation{
		Name:       opCreateMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members",
	}

	if input == nil {
		input = &CreateMembersInput{}
	}

	output = &CreateMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMembers API operation for AWS SecurityHub.
//
// Creates member Security Hub accounts in the current AWS account (which becomes
// the master Security Hub account) that has Security Hub enabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation CreateMembers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   The resource specified in the request conflicts with an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateMembers
func (c *SecurityHub) CreateMembers(input *CreateMembersInput) (*CreateMembersOutput, error) {
	req, out := c.CreateMembersRequest(input)
	return out, req.Send()
}

// CreateMembersWithContext is the same as CreateMembers with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) CreateMembersWithContext(ctx aws.Context, input *CreateMembersInput, opts ...request.Option) (*CreateMembersOutput, error) {
	req, out := c.CreateMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeclineInvitations = "DeclineInvitations"

// DeclineInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the DeclineInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeclineInvitations for more information on using the DeclineInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeclineInvitationsRequest method.
//    req, resp := client.DeclineInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeclineInvitations
func (c *SecurityHub) DeclineInvitationsRequest(input *DeclineInvitationsInput) (req *request.Request, output *DeclineInvitationsOutput) {
	op := &request.Operation{
		Name:       opDeclineInvitations,
		HTTPMethod: "POST",
		HTTPPath:   "/invitations/decline",
	}

	if input == nil {
		input = &DeclineInvitationsInput{}
	}

	output = &DeclineInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeclineInvitations API operation for AWS SecurityHub.
//
// Declines invitations that are sent to this AWS account (invitee) by the AWS
// accounts (inviters) that are specified by the account IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeclineInvitations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The request was rejected because the specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeclineInvitations
func (c *SecurityHub) DeclineInvitations(input *DeclineInvitationsInput) (*DeclineInvitationsOutput, error) {
	req, out := c.DeclineInvitationsRequest(input)
	return out, req.Send()
}

// DeclineInvitationsWithContext is the same as DeclineInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See DeclineInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeclineInvitationsWithContext(ctx aws.Context, input *DeclineInvitationsInput, opts ...request.Option) (*DeclineInvitationsOutput, error) {
	req, out := c.DeclineInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInsight = "DeleteInsight"

// DeleteInsightRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInsight operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInsight for more information on using the DeleteInsight
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInsightRequest method.
//    req, resp := client.DeleteInsightRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInsight
func (c *SecurityHub) DeleteInsightRequest(input *DeleteInsightInput) (req *request.Request, output *DeleteInsightOutput) {
	op := &request.Operation{
		Name:       opDeleteInsight,
		HTTPMethod: "DELETE",
		HTTPPath:   "/insights/{InsightArn+}",
	}

	if input == nil {
		input = &DeleteInsightInput{}
	}

	output = &DeleteInsightOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInsight API operation for AWS SecurityHub.
//
// Deletes an insight that is specified by the insight ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeleteInsight for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The request was rejected because the specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInsight
func (c *SecurityHub) DeleteInsight(input *DeleteInsightInput) (*DeleteInsightOutput, error) {
	req, out := c.DeleteInsightRequest(input)
	return out, req.Send()
}

// DeleteInsightWithContext is the same as DeleteInsight with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInsight for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeleteInsightWithContext(ctx aws.Context, input *DeleteInsightInput, opts ...request.Option) (*DeleteInsightOutput, error) {
	req, out := c.DeleteInsightRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInvitations = "DeleteInvitations"

// DeleteInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInvitations for more information on using the DeleteInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInvitationsRequest method.
//    req, resp := client.DeleteInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInvitations
func (c *SecurityHub) DeleteInvitationsRequest(input *DeleteInvitationsInput) (req *request.Request, output *DeleteInvitationsOutput) {
	op := &request.Operation{
		Name:       opDeleteInvitations,
		HTTPMethod: "POST",
		HTTPPath:   "/invitations/delete",
	}

	if input == nil {
		input = &DeleteInvitationsInput{}
	}

	output = &DeleteInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInvitations API operation for AWS SecurityHub.
//
// Deletes invitations that are sent to this AWS account (invitee) by the AWS
// accounts (inviters) that are specified by their account IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeleteInvitations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The request was rejected because the specified resource cannot be found.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInvitations
func (c *SecurityHub) DeleteInvitations(input *DeleteInvitationsInput) (*DeleteInvitationsOutput, error) {
	req, out := c.DeleteInvitationsRequest(input)
	return out, req.Send()
}

// DeleteInvitationsWithContext is the same as DeleteInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeleteInvitationsWithContext(ctx aws.Context, input *DeleteInvitationsInput, opts ...request.Option) (*DeleteInvitationsOutput, error) {
	req, out := c.DeleteInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMembers = "DeleteMembers"

// DeleteMembersRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMembers for more information on using the DeleteMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMembersRequest method.
//    req, resp := client.DeleteMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteMembers
func (c *SecurityHub) DeleteMembersRequest(input *DeleteMembersInput) (req *request.Request, output *DeleteMembersOutput) {
	op := &request.Operation{
		Name:       opDeleteMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members/delete",
	}

	if input == nil {
		input = &DeleteMembersInput{}
	}

	output = &DeleteMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMembers API operation for AWS SecurityHub.
//
// Deletes the Security Hub member accounts that are specified by the account
// IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeleteMembers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The request was rejected because the specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteMembers
func (c *SecurityHub) DeleteMembers(input *DeleteMembersInput) (*DeleteMembersOutput, error) {
	req, out := c.DeleteMembersRequest(input)
	return out, req.Send()
}

// DeleteMembersWithContext is the same as DeleteMembers with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeleteMembersWithContext(ctx aws.Context, input *DeleteMembersInput, opts ...request.Option) (*DeleteMembersOutput, error) {
	req, out := c.DeleteMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableImportFindingsForProduct = "DisableImportFindingsForProduct"

// DisableImportFindingsForProductRequest generates a "aws/request.Request" representing the
// client's request for the DisableImportFindingsForProduct operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableImportFindingsForProduct for more information on using the DisableImportFindingsForProduct
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableImportFindingsForProductRequest method.
//    req, resp := client.DisableImportFindingsForProductRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableImportFindingsForProduct
func (c *SecurityHub) DisableImportFindingsForProductRequest(input *DisableImportFindingsForProductInput) (req *request.Request, output *DisableImportFindingsForProductOutput) {
	op := &request.Operation{
		Name:       opDisableImportFindingsForProduct,
		HTTPMethod: "DELETE",
		HTTPPath:   "/productSubscriptions/{ProductSubscriptionArn+}",
	}

	if input == nil {
		input = &DisableImportFindingsForProductInput{}
	}

	output = &DisableImportFindingsForProductOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableImportFindingsForProduct API operation for AWS SecurityHub.
//
// Cancels the subscription that allows a findings-generating solution (product)
// to import its findings into Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DisableImportFindingsForProduct for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The request was rejected because the specified resource cannot be found.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableImportFindingsForProduct
func (c *SecurityHub) DisableImportFindingsForProduct(input *DisableImportFindingsForProductInput) (*DisableImportFindingsForProductOutput, error) {
	req, out := c.DisableImportFindingsForProductRequest(input)
	return out, req.Send()
}

// DisableImportFindingsForProductWithContext is the same as DisableImportFindingsForProduct with the addition of
// the ability to pass a context and additional request options.
//
// See DisableImportFindingsForProduct for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DisableImportFindingsForProductWithContext(ctx aws.Context, input *DisableImportFindingsForProductInput, opts ...request.Option) (*DisableImportFindingsForProductOutput, error) {
	req, out := c.DisableImportFindingsForProductRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableSecurityHub = "DisableSecurityHub"

// DisableSecurityHubRequest generates a "aws/request.Request" representing the
// client's request for the DisableSecurityHub operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableSecurityHub for more information on using the DisableSecurityHub
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableSecurityHubRequest method.
//    req, resp := client.DisableSecurityHubRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableSecurityHub
func (c *SecurityHub) DisableSecurityHubRequest(input *DisableSecurityHubInput) (req *request.Request, output *DisableSecurityHubOutput) {
	op := &request.Operation{
		Name:       opDisableSecurityHub,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts",
	}

	if input == nil {
		input = &DisableSecurityHubInput{}
	}

	output = &DisableSecurityHubOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableSecurityHub API operation for AWS SecurityHub.
//
// Disables the AWS Security Hub Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DisableSecurityHub for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The request was rejected because the specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableSecurityHub
func (c *SecurityHub) DisableSecurityHub(input *DisableSecurityHubInput) (*DisableSecurityHubOutput, error) {
	req, out := c.DisableSecurityHubRequest(input)
	return out, req.Send()
}

// DisableSecurityHubWithContext is the same as DisableSecurityHub with the addition of
// the ability to pass a context and additional request options.
//
// See DisableSecurityHub for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DisableSecurityHubWithContext(ctx aws.Context, input *DisableSecurityHubInput, opts ...request.Option) (*DisableSecurityHubOutput, error) {
	req, out := c.DisableSecurityHubRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateFromMasterAccount = "DisassociateFromMasterAccount"

// DisassociateFromMasterAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateFromMasterAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateFromMasterAccount for more information on using the DisassociateFromMasterAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateFromMasterAccountRequest method.
//    req, resp := client.DisassociateFromMasterAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromMasterAccount
func (c *SecurityHub) DisassociateFromMasterAccountRequest(input *DisassociateFromMasterAccountInput) (req *request.Request, output *DisassociateFromMasterAccountOutput) {
	op := &request.Operation{
		Name:       opDisassociateFromMasterAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/master/disassociate",
	}

	if input == nil {
		input = &DisassociateFromMasterAccountInput{}
	}

	output = &DisassociateFromMasterAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateFromMasterAccount API operation for AWS SecurityHub.
//
// Disassociates the current Security Hub member account from its master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DisassociateFromMasterAccount for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The request was rejected because the specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromMasterAccount
func (c *SecurityHub) DisassociateFromMasterAccount(input *DisassociateFromMasterAccountInput) (*DisassociateFromMasterAccountOutput, error) {
	req, out := c.DisassociateFromMasterAccountRequest(input)
	return out, req.Send()
}

// DisassociateFromMasterAccountWithContext is the same as DisassociateFromMasterAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateFromMasterAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DisassociateFromMasterAccountWithContext(ctx aws.Context, input *DisassociateFromMasterAccountInput, opts ...request.Option) (*DisassociateFromMasterAccountOutput, error) {
	req, out := c.DisassociateFromMasterAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateMembers = "DisassociateMembers"

// DisassociateMembersRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateMembers for more information on using the DisassociateMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateMembersRequest method.
//    req, resp := client.DisassociateMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateMembers
func (c *SecurityHub) DisassociateMembersRequest(input *DisassociateMembersInput) (req *request.Request, output *DisassociateMembersOutput) {
	op := &request.Operation{
		Name:       opDisassociateMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members/disassociate",
	}

	if input == nil {
		input = &DisassociateMembersInput{}
	}

	output = &DisassociateMembersOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateMembers API operation for AWS SecurityHub.
//
// Disassociates the Security Hub member accounts that are specified by the
// account IDs from their master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DisassociateMembers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The request was rejected because the specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateMembers
func (c *SecurityHub) DisassociateMembers(input *DisassociateMembersInput) (*DisassociateMembersOutput, error) {
	req, out := c.DisassociateMembersRequest(input)
	return out, req.Send()
}

// DisassociateMembersWithContext is the same as DisassociateMembers with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DisassociateMembersWithContext(ctx aws.Context, input *DisassociateMembersInput, opts ...request.Option) (*DisassociateMembersOutput, error) {
	req, out := c.DisassociateMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableImportFindingsForProduct = "EnableImportFindingsForProduct"

// EnableImportFindingsForProductRequest generates a "aws/request.Request" representing the
// client's request for the EnableImportFindingsForProduct operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableImportFindingsForProduct for more information on using the EnableImportFindingsForProduct
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableImportFindingsForProductRequest method.
//    req, resp := client.EnableImportFindingsForProductRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableImportFindingsForProduct
func (c *SecurityHub) EnableImportFindingsForProductRequest(input *EnableImportFindingsForProductInput) (req *request.Request, output *EnableImportFindingsForProductOutput) {
	op := &request.Operation{
		Name:       opEnableImportFindingsForProduct,
		HTTPMethod: "POST",
		HTTPPath:   "/productSubscriptions",
	}

	if input == nil {
		input = &EnableImportFindingsForProductInput{}
	}

	output = &EnableImportFindingsForProductOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnableImportFindingsForProduct API operation for AWS SecurityHub.
//
// Sets up the subscription that enables a findings-generating solution (product)
// to import its findings into Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation EnableImportFindingsForProduct for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   The resource specified in the request conflicts with an existing resource.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableImportFindingsForProduct
func (c *SecurityHub) EnableImportFindingsForProduct(input *EnableImportFindingsForProductInput) (*EnableImportFindingsForProductOutput, error) {
	req, out := c.EnableImportFindingsForProductRequest(input)
	return out, req.Send()
}

// EnableImportFindingsForProductWithContext is the same as EnableImportFindingsForProduct with the addition of
// the ability to pass a context and additional request options.
//
// See EnableImportFindingsForProduct for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) EnableImportFindingsForProductWithContext(ctx aws.Context, input *EnableImportFindingsForProductInput, opts ...request.Option) (*EnableImportFindingsForProductOutput, error) {
	req, out := c.EnableImportFindingsForProductRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableSecurityHub = "EnableSecurityHub"

// EnableSecurityHubRequest generates a "aws/request.Request" representing the
// client's request for the EnableSecurityHub operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableSecurityHub for more information on using the EnableSecurityHub
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableSecurityHubRequest method.
//    req, resp := client.EnableSecurityHubRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableSecurityHub
func (c *SecurityHub) EnableSecurityHubRequest(input *EnableSecurityHubInput) (req *request.Request, output *EnableSecurityHubOutput) {
	op := &request.Operation{
		Name:       opEnableSecurityHub,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts",
	}

	if input == nil {
		input = &EnableSecurityHubInput{}
	}

	output = &EnableSecurityHubOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableSecurityHub API operation for AWS SecurityHub.
//
// Enables the AWS Security Hub service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation EnableSecurityHub for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   The resource specified in the request conflicts with an existing resource.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have permission to to perform the action specified in the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableSecurityHub
func (c *SecurityHub) EnableSecurityHub(input *EnableSecurityHubInput) (*EnableSecurityHubOutput, error) {
	req, out := c.EnableSecurityHubRequest(input)
	return out, req.Send()
}

// EnableSecurityHubWithContext is the same as EnableSecurityHub with the addition of
// the ability to pass a context and additional request options.
//
// See EnableSecurityHub for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) EnableSecurityHubWithContext(ctx aws.Context, input *EnableSecurityHubInput, opts ...request.Option) (*EnableSecurityHubOutput, error) {
	req, out := c.EnableSecurityHubRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEnabledStandards = "GetEnabledStandards"

// GetEnabledStandardsRequest generates a "aws/request.Request" representing the
// client's request for the GetEnabledStandards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEnabledStandards for more information on using the GetEnabledStandards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEnabledStandardsRequest method.
//    req, resp := client.GetEnabledStandardsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetEnabledStandards
func (c *SecurityHub) GetEnabledStandardsRequest(input *GetEnabledStandardsInput) (req *request.Request, output *GetEnabledStandardsOutput) {
	op := &request.Operation{
		Name:       opGetEnabledStandards,
		HTTPMethod: "POST",
		HTTPPath:   "/standards/get",
	}

	if input == nil {
		input = &GetEnabledStandardsInput{}
	}

	output = &GetEnabledStandardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEnabledStandards API operation for AWS SecurityHub.
//
// Lists and describes enabled standards.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetEnabledStandards for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetEnabledStandards
func (c *SecurityHub) GetEnabledStandards(input *GetEnabledStandardsInput) (*GetEnabledStandardsOutput, error) {
	req, out := c.GetEnabledStandardsRequest(input)
	return out, req.Send()
}

// GetEnabledStandardsWithContext is the same as GetEnabledStandards with the addition of
// the ability to pass a context and additional request options.
//
// See GetEnabledStandards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetEnabledStandardsWithContext(ctx aws.Context, input *GetEnabledStandardsInput, opts ...request.Option) (*GetEnabledStandardsOutput, error) {
	req, out := c.GetEnabledStandardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFindings = "GetFindings"

// GetFindingsRequest generates a "aws/request.Request" representing the
// client's request for the GetFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFindings for more information on using the GetFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFindingsRequest method.
//    req, resp := client.GetFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings
func (c *SecurityHub) GetFindingsRequest(input *GetFindingsInput) (req *request.Request, output *GetFindingsOutput) {
	op := &request.Operation{
		Name:       opGetFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/findings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetFindingsInput{}
	}

	output = &GetFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFindings API operation for AWS SecurityHub.
//
// Lists and describes Security Hub-aggregated findings that are specified by
// filter attributes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetFindings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings
func (c *SecurityHub) GetFindings(input *GetFindingsInput) (*GetFindingsOutput, error) {
	req, out := c.GetFindingsRequest(input)
	return out, req.Send()
}

// GetFindingsWithContext is the same as GetFindings with the addition of
// the ability to pass a context and additional request options.
//
// See GetFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetFindingsWithContext(ctx aws.Context, input *GetFindingsInput, opts ...request.Option) (*GetFindingsOutput, error) {
	req, out := c.GetFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetFindingsPages iterates over the pages of a GetFindings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetFindings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetFindings operation.
//    pageNum := 0
//    err := client.GetFindingsPages(params,
//        func(page *GetFindingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) GetFindingsPages(input *GetFindingsInput, fn func(*GetFindingsOutput, bool) bool) error {
	return c.GetFindingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetFindingsPagesWithContext same as GetFindingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetFindingsPagesWithContext(ctx aws.Context, input *GetFindingsInput, fn func(*GetFindingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetFindingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetFindingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetFindingsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetInsightResults = "GetInsightResults"

// GetInsightResultsRequest generates a "aws/request.Request" representing the
// client's request for the GetInsightResults operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInsightResults for more information on using the GetInsightResults
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInsightResultsRequest method.
//    req, resp := client.GetInsightResultsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsightResults
func (c *SecurityHub) GetInsightResultsRequest(input *GetInsightResultsInput) (req *request.Request, output *GetInsightResultsOutput) {
	op := &request.Operation{
		Name:       opGetInsightResults,
		HTTPMethod: "GET",
		HTTPPath:   "/insights/results/{InsightArn+}",
	}

	if input == nil {
		input = &GetInsightResultsInput{}
	}

	output = &GetInsightResultsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInsightResults API operation for AWS SecurityHub.
//
// Lists the results of the Security Hub insight specified by the insight ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetInsightResults for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The request was rejected because the specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsightResults
func (c *SecurityHub) GetInsightResults(input *GetInsightResultsInput) (*GetInsightResultsOutput, error) {
	req, out := c.GetInsightResultsRequest(input)
	return out, req.Send()
}

// GetInsightResultsWithContext is the same as GetInsightResults with the addition of
// the ability to pass a context and additional request options.
//
// See GetInsightResults for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetInsightResultsWithContext(ctx aws.Context, input *GetInsightResultsInput, opts ...request.Option) (*GetInsightResultsOutput, error) {
	req, out := c.GetInsightResultsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInsights = "GetInsights"

// GetInsightsRequest generates a "aws/request.Request" representing the
// client's request for the GetInsights operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInsights for more information on using the GetInsights
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInsightsRequest method.
//    req, resp := client.GetInsightsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights
func (c *SecurityHub) GetInsightsRequest(input *GetInsightsInput) (req *request.Request, output *GetInsightsOutput) {
	op := &request.Operation{
		Name:       opGetInsights,
		HTTPMethod: "POST",
		HTTPPath:   "/insights/get",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetInsightsInput{}
	}

	output = &GetInsightsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInsights API operation for AWS SecurityHub.
//
// Lists and describes insights that are specified by insight ARNs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetInsights for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The request was rejected because the specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights
func (c *SecurityHub) GetInsights(input *GetInsightsInput) (*GetInsightsOutput, error) {
	req, out := c.GetInsightsRequest(input)
	return out, req.Send()
}

// GetInsightsWithContext is the same as GetInsights with the addition of
// the ability to pass a context and additional request options.
//
// See GetInsights for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetInsightsWithContext(ctx aws.Context, input *GetInsightsInput, opts ...request.Option) (*GetInsightsOutput, error) {
	req, out := c.GetInsightsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetInsightsPages iterates over the pages of a GetInsights operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetInsights method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetInsights operation.
//    pageNum := 0
//    err := client.GetInsightsPages(params,
//        func(page *GetInsightsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) GetInsightsPages(input *GetInsightsInput, fn func(*GetInsightsOutput, bool) bool) error {
	return c.GetInsightsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetInsightsPagesWithContext same as GetInsightsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetInsightsPagesWithContext(ctx aws.Context, input *GetInsightsInput, fn func(*GetInsightsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetInsightsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetInsightsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetInsightsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetInvitationsCount = "GetInvitationsCount"

// GetInvitationsCountRequest generates a "aws/request.Request" representing the
// client's request for the GetInvitationsCount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInvitationsCount for more information on using the GetInvitationsCount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInvitationsCountRequest method.
//    req, resp := client.GetInvitationsCountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInvitationsCount
func (c *SecurityHub) GetInvitationsCountRequest(input *GetInvitationsCountInput) (req *request.Request, output *GetInvitationsCountOutput) {
	op := &request.Operation{
		Name:       opGetInvitationsCount,
		HTTPMethod: "GET",
		HTTPPath:   "/invitations/count",
	}

	if input == nil {
		input = &GetInvitationsCountInput{}
	}

	output = &GetInvitationsCountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInvitationsCount API operation for AWS SecurityHub.
//
// Returns the count of all Security Hub membership invitations that were sent
// to the current member account, not including the currently accepted invitation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetInvitationsCount for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInvitationsCount
func (c *SecurityHub) GetInvitationsCount(input *GetInvitationsCountInput) (*GetInvitationsCountOutput, error) {
	req, out := c.GetInvitationsCountRequest(input)
	return out, req.Send()
}

// GetInvitationsCountWithContext is the same as GetInvitationsCount with the addition of
// the ability to pass a context and additional request options.
//
// See GetInvitationsCount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetInvitationsCountWithContext(ctx aws.Context, input *GetInvitationsCountInput, opts ...request.Option) (*GetInvitationsCountOutput, error) {
	req, out := c.GetInvitationsCountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMasterAccount = "GetMasterAccount"

// GetMasterAccountRequest generates a "aws/request.Request" representing the
// client's request for the GetMasterAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMasterAccount for more information on using the GetMasterAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMasterAccountRequest method.
//    req, resp := client.GetMasterAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMasterAccount
func (c *SecurityHub) GetMasterAccountRequest(input *GetMasterAccountInput) (req *request.Request, output *GetMasterAccountOutput) {
	op := &request.Operation{
		Name:       opGetMasterAccount,
		HTTPMethod: "GET",
		HTTPPath:   "/master",
	}

	if input == nil {
		input = &GetMasterAccountInput{}
	}

	output = &GetMasterAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMasterAccount API operation for AWS SecurityHub.
//
// Provides the details for the Security Hub master account to the current member
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetMasterAccount for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The request was rejected because the specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMasterAccount
func (c *SecurityHub) GetMasterAccount(input *GetMasterAccountInput) (*GetMasterAccountOutput, error) {
	req, out := c.GetMasterAccountRequest(input)
	return out, req.Send()
}

// GetMasterAccountWithContext is the same as GetMasterAccount with the addition of
// the ability to pass a context and additional request options.
//
// See GetMasterAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetMasterAccountWithContext(ctx aws.Context, input *GetMasterAccountInput, opts ...request.Option) (*GetMasterAccountOutput, error) {
	req, out := c.GetMasterAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMembers = "GetMembers"

// GetMembersRequest generates a "aws/request.Request" representing the
// client's request for the GetMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMembers for more information on using the GetMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMembersRequest method.
//    req, resp := client.GetMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMembers
func (c *SecurityHub) GetMembersRequest(input *GetMembersInput) (req *request.Request, output *GetMembersOutput) {
	op := &request.Operation{
		Name:       opGetMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members/get",
	}

	if input == nil {
		input = &GetMembersInput{}
	}

	output = &GetMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMembers API operation for AWS SecurityHub.
//
// Returns the details on the Security Hub member accounts that are specified
// by the account IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetMembers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The request was rejected because the specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMembers
func (c *SecurityHub) GetMembers(input *GetMembersInput) (*GetMembersOutput, error) {
	req, out := c.GetMembersRequest(input)
	return out, req.Send()
}

// GetMembersWithContext is the same as GetMembers with the addition of
// the ability to pass a context and additional request options.
//
// See GetMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetMembersWithContext(ctx aws.Context, input *GetMembersInput, opts ...request.Option) (*GetMembersOutput, error) {
	req, out := c.GetMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInviteMembers = "InviteMembers"

// InviteMembersRequest generates a "aws/request.Request" representing the
// client's request for the InviteMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InviteMembers for more information on using the InviteMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the InviteMembersRequest method.
//    req, resp := client.InviteMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/InviteMembers
func (c *SecurityHub) InviteMembersRequest(input *InviteMembersInput) (req *request.Request, output *InviteMembersOutput) {
	op := &request.Operation{
		Name:       opInviteMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members/invite",
	}

	if input == nil {
		input = &InviteMembersInput{}
	}

	output = &InviteMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InviteMembers API operation for AWS SecurityHub.
//
// Invites other AWS accounts to enable Security Hub and become Security Hub
// member accounts. When an account accepts the invitation and becomes a member
// account, the master account can view Security Hub findings of the member
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation InviteMembers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The request was rejected because the specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/InviteMembers
func (c *SecurityHub) InviteMembers(input *InviteMembersInput) (*InviteMembersOutput, error) {
	req, out := c.InviteMembersRequest(input)
	return out, req.Send()
}

// InviteMembersWithContext is the same as InviteMembers with the addition of
// the ability to pass a context and additional request options.
//
// See InviteMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) InviteMembersWithContext(ctx aws.Context, input *InviteMembersInput, opts ...request.Option) (*InviteMembersOutput, error) {
	req, out := c.InviteMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEnabledProductsForImport = "ListEnabledProductsForImport"

// ListEnabledProductsForImportRequest generates a "aws/request.Request" representing the
// client's request for the ListEnabledProductsForImport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEnabledProductsForImport for more information on using the ListEnabledProductsForImport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEnabledProductsForImportRequest method.
//    req, resp := client.ListEnabledProductsForImportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport
func (c *SecurityHub) ListEnabledProductsForImportRequest(input *ListEnabledProductsForImportInput) (req *request.Request, output *ListEnabledProductsForImportOutput) {
	op := &request.Operation{
		Name:       opListEnabledProductsForImport,
		HTTPMethod: "GET",
		HTTPPath:   "/productSubscriptions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnabledProductsForImportInput{}
	}

	output = &ListEnabledProductsForImportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEnabledProductsForImport API operation for AWS SecurityHub.
//
// Lists all findings-generating solutions (products) whose findings you've
// subscribed to receive in Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListEnabledProductsForImport for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport
func (c *SecurityHub) ListEnabledProductsForImport(input *ListEnabledProductsForImportInput) (*ListEnabledProductsForImportOutput, error) {
	req, out := c.ListEnabledProductsForImportRequest(input)
	return out, req.Send()
}

// ListEnabledProductsForImportWithContext is the same as ListEnabledProductsForImport with the addition of
// the ability to pass a context and additional request options.
//
// See ListEnabledProductsForImport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListEnabledProductsForImportWithContext(ctx aws.Context, input *ListEnabledProductsForImportInput, opts ...request.Option) (*ListEnabledProductsForImportOutput, error) {
	req, out := c.ListEnabledProductsForImportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEnabledProductsForImportPages iterates over the pages of a ListEnabledProductsForImport operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEnabledProductsForImport method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEnabledProductsForImport operation.
//    pageNum := 0
//    err := client.ListEnabledProductsForImportPages(params,
//        func(page *ListEnabledProductsForImportOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) ListEnabledProductsForImportPages(input *ListEnabledProductsForImportInput, fn func(*ListEnabledProductsForImportOutput, bool) bool) error {
	return c.ListEnabledProductsForImportPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEnabledProductsForImportPagesWithContext same as ListEnabledProductsForImportPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListEnabledProductsForImportPagesWithContext(ctx aws.Context, input *ListEnabledProductsForImportInput, fn func(*ListEnabledProductsForImportOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEnabledProductsForImportInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEnabledProductsForImportRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListEnabledProductsForImportOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListInvitations = "ListInvitations"

// ListInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the ListInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInvitations for more information on using the ListInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInvitationsRequest method.
//    req, resp := client.ListInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations
func (c *SecurityHub) ListInvitationsRequest(input *ListInvitationsInput) (req *request.Request, output *ListInvitationsOutput) {
	op := &request.Operation{
		Name:       opListInvitations,
		HTTPMethod: "GET",
		HTTPPath:   "/invitations",
	}

	if input == nil {
		input = &ListInvitationsInput{}
	}

	output = &ListInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInvitations API operation for AWS SecurityHub.
//
// Lists all Security Hub membership invitations that were sent to the current
// AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListInvitations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations
func (c *SecurityHub) ListInvitations(input *ListInvitationsInput) (*ListInvitationsOutput, error) {
	req, out := c.ListInvitationsRequest(input)
	return out, req.Send()
}

// ListInvitationsWithContext is the same as ListInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See ListInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListInvitationsWithContext(ctx aws.Context, input *ListInvitationsInput, opts ...request.Option) (*ListInvitationsOutput, error) {
	req, out := c.ListInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListMembers = "ListMembers"

// ListMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMembers for more information on using the ListMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMembersRequest method.
//    req, resp := client.ListMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers
func (c *SecurityHub) ListMembersRequest(input *ListMembersInput) (req *request.Request, output *ListMembersOutput) {
	op := &request.Operation{
		Name:       opListMembers,
		HTTPMethod: "GET",
		HTTPPath:   "/members",
	}

	if input == nil {
		input = &ListMembersInput{}
	}

	output = &ListMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMembers API operation for AWS SecurityHub.
//
// Lists details about all member accounts for the current Security Hub master
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListMembers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers
func (c *SecurityHub) ListMembers(input *ListMembersInput) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	return out, req.Send()
}

// ListMembersWithContext is the same as ListMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListMembersWithContext(ctx aws.Context, input *ListMembersInput, opts ...request.Option) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFindings = "UpdateFindings"

// UpdateFindingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFindings for more information on using the UpdateFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFindingsRequest method.
//    req, resp := client.UpdateFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindings
func (c *SecurityHub) UpdateFindingsRequest(input *UpdateFindingsInput) (req *request.Request, output *UpdateFindingsOutput) {
	op := &request.Operation{
		Name:       opUpdateFindings,
		HTTPMethod: "PATCH",
		HTTPPath:   "/findings",
	}

	if input == nil {
		input = &UpdateFindingsInput{}
	}

	output = &UpdateFindingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateFindings API operation for AWS SecurityHub.
//
// Updates the AWS Security Hub-aggregated findings specified by the filter
// attributes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateFindings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The request was rejected because the specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindings
func (c *SecurityHub) UpdateFindings(input *UpdateFindingsInput) (*UpdateFindingsOutput, error) {
	req, out := c.UpdateFindingsRequest(input)
	return out, req.Send()
}

// UpdateFindingsWithContext is the same as UpdateFindings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateFindingsWithContext(ctx aws.Context, input *UpdateFindingsInput, opts ...request.Option) (*UpdateFindingsOutput, error) {
	req, out := c.UpdateFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInsight = "UpdateInsight"

// UpdateInsightRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInsight operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInsight for more information on using the UpdateInsight
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateInsightRequest method.
//    req, resp := client.UpdateInsightRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateInsight
func (c *SecurityHub) UpdateInsightRequest(input *UpdateInsightInput) (req *request.Request, output *UpdateInsightOutput) {
	op := &request.Operation{
		Name:       opUpdateInsight,
		HTTPMethod: "PATCH",
		HTTPPath:   "/insights/{InsightArn+}",
	}

	if input == nil {
		input = &UpdateInsightInput{}
	}

	output = &UpdateInsightOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateInsight API operation for AWS SecurityHub.
//
// Updates the AWS Security Hub insight specified by the insight ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateInsight for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   Internal server error.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeInvalidAccessException "InvalidAccessException"
//   AWS Security Hub is not enabled for the account used to make this request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error code describes the limit exceeded.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The request was rejected because the specified resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateInsight
func (c *SecurityHub) UpdateInsight(input *UpdateInsightInput) (*UpdateInsightOutput, error) {
	req, out := c.UpdateInsightRequest(input)
	return out, req.Send()
}

// UpdateInsightWithContext is the same as UpdateInsight with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInsight for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateInsightWithContext(ctx aws.Context, input *UpdateInsightInput, opts ...request.Option) (*UpdateInsightOutput, error) {
	req, out := c.UpdateInsightRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AcceptInvitationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the invitation that is sent to the AWS account by the Security
	// Hub master account.
	InvitationId *string `type:"string"`

	// The account ID of the master Security Hub account whose invitation you're
	// accepting.
	MasterId *string `type:"string"`
}

// String returns the string representation
func (s AcceptInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptInvitationInput) GoString() string {
	return s.String()
}

// SetInvitationId sets the InvitationId field's value.
func (s *AcceptInvitationInput) SetInvitationId(v string) *AcceptInvitationInput {
	s.InvitationId = &v
	return s
}

// SetMasterId sets the MasterId field's value.
func (s *AcceptInvitationInput) SetMasterId(v string) *AcceptInvitationInput {
	s.MasterId = &v
	return s
}

type AcceptInvitationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AcceptInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptInvitationOutput) GoString() string {
	return s.String()
}

// The details of an AWS account.
type AccountDetails struct {
	_ struct{} `type:"structure"`

	// The ID of an AWS account.
	AccountId *string `type:"string"`

	// The email of an AWS account.
	Email *string `type:"string"`
}

// String returns the string representation
func (s AccountDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountDetails) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AccountDetails) SetAccountId(v string) *AccountDetails {
	s.AccountId = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *AccountDetails) SetEmail(v string) *AccountDetails {
	s.Email = &v
	return s
}

// The details of an AWS EC2 instance.
type AwsEc2InstanceDetails struct {
	_ struct{} `type:"structure"`

	// The IAM profile ARN of the instance.
	IamInstanceProfileArn *string `type:"string"`

	// The Amazon Machine Image (AMI) ID of the instance.
	ImageId *string `type:"string"`

	// The IPv4 addresses associated with the instance.
	IpV4Addresses []*string `type:"list"`

	// The IPv6 addresses associated with the instance.
	IpV6Addresses []*string `type:"list"`

	// The key name associated with the instance.
	KeyName *string `type:"string"`

	// The date/time the instance was launched.
	LaunchedAt *string `type:"string"`

	// The identifier of the subnet in which the instance was launched.
	SubnetId *string `type:"string"`

	// The instance type of the instance.
	Type *string `type:"string"`

	// The identifier of the VPC in which the instance was launched.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2InstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsEc2InstanceDetails) GoString() string {
	return s.String()
}

// SetIamInstanceProfileArn sets the IamInstanceProfileArn field's value.
func (s *AwsEc2InstanceDetails) SetIamInstanceProfileArn(v string) *AwsEc2InstanceDetails {
	s.IamInstanceProfileArn = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *AwsEc2InstanceDetails) SetImageId(v string) *AwsEc2InstanceDetails {
	s.ImageId = &v
	return s
}

// SetIpV4Addresses sets the IpV4Addresses field's value.
func (s *AwsEc2InstanceDetails) SetIpV4Addresses(v []*string) *AwsEc2InstanceDetails {
	s.IpV4Addresses = v
	return s
}

// SetIpV6Addresses sets the IpV6Addresses field's value.
func (s *AwsEc2InstanceDetails) SetIpV6Addresses(v []*string) *AwsEc2InstanceDetails {
	s.IpV6Addresses = v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *AwsEc2InstanceDetails) SetKeyName(v string) *AwsEc2InstanceDetails {
	s.KeyName = &v
	return s
}

// SetLaunchedAt sets the LaunchedAt field's value.
func (s *AwsEc2InstanceDetails) SetLaunchedAt(v string) *AwsEc2InstanceDetails {
	s.LaunchedAt = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *AwsEc2InstanceDetails) SetSubnetId(v string) *AwsEc2InstanceDetails {
	s.SubnetId = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsEc2InstanceDetails) SetType(v string) *AwsEc2InstanceDetails {
	s.Type = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsEc2InstanceDetails) SetVpcId(v string) *AwsEc2InstanceDetails {
	s.VpcId = &v
	return s
}

// AWS IAM access key details related to a finding.
type AwsIamAccessKeyDetails struct {
	_ struct{} `type:"structure"`

	// The creation date/time of the IAM access key related to a finding.
	CreatedAt *string `type:"string"`

	// The status of the IAM access key related to a finding.
	Status *string `type:"string" enum:"AwsIamAccessKeyStatus"`

	// The user associated with the IAM access key related to a finding.
	UserName *string `type:"string"`
}

// String returns the string representation
func (s AwsIamAccessKeyDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsIamAccessKeyDetails) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AwsIamAccessKeyDetails) SetCreatedAt(v string) *AwsIamAccessKeyDetails {
	s.CreatedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsIamAccessKeyDetails) SetStatus(v string) *AwsIamAccessKeyDetails {
	s.Status = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *AwsIamAccessKeyDetails) SetUserName(v string) *AwsIamAccessKeyDetails {
	s.UserName = &v
	return s
}

// The details of an AWS S3 Bucket.
type AwsS3BucketDetails struct {
	_ struct{} `type:"structure"`

	// The canonical user ID of the owner of the S3 bucket.
	OwnerId *string `type:"string"`

	// The display name of the owner of the S3 bucket.
	OwnerName *string `type:"string"`
}

// String returns the string representation
func (s AwsS3BucketDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsS3BucketDetails) GoString() string {
	return s.String()
}

// SetOwnerId sets the OwnerId field's value.
func (s *AwsS3BucketDetails) SetOwnerId(v string) *AwsS3BucketDetails {
	s.OwnerId = &v
	return s
}

// SetOwnerName sets the OwnerName field's value.
func (s *AwsS3BucketDetails) SetOwnerName(v string) *AwsS3BucketDetails {
	s.OwnerName = &v
	return s
}

// Provides consistent format for the contents of the Security Hub-aggregated
// findings. AwsSecurityFinding format enables you to share findings between
// AWS security services and third-party solutions, and compliance checks.
//
// A finding is a potential security issue generated either by AWS services
// (GuardDuty, Inspector, Macie) or by the integrated third-party solutions
// and compliance checks.
type AwsSecurityFinding struct {
	_ struct{} `type:"structure"`

	// The AWS account ID in which a finding is generated.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `type:"string" required:"true"`

	// This data type is exclusive to findings that are generated as the result
	// of a check run against a specific rule in a supported standard (for example,
	// AWS CIS Foundations). Contains compliance-related finding details.
	Compliance *Compliance `type:"structure"`

	// A finding's confidence. Confidence is defined as the likelihood that a finding
	// accurately identifies the behavior or issue that it was intended to identify.
	// Confidence is scored on a 0-100 basis using a ratio scale. 0 equates zero
	// percent confidence and 100 equates to 100 percent confidence.
	Confidence *int64 `type:"integer"`

	// An ISO8601-formatted timestamp that indicates when the potential security
	// issue captured by a finding was created by the security findings provider.
	//
	// CreatedAt is a required field
	CreatedAt *string `type:"string" required:"true"`

	// The level of importance assigned to the resources associated with the finding.
	// A score of 0 means the underlying resources have no criticality, and a score
	// of 100 is reserved for the most critical resources.
	Criticality *int64 `type:"integer"`

	// A finding's description.
	//
	// In this release, Description is a required property.
	Description *string `type:"string"`

	// An ISO8601-formatted timestamp that indicates when the potential security
	// issue captured by a finding was first observed by the security findings provider.
	FirstObservedAt *string `type:"string"`

	// This is the identifier for the solution-specific component (a discrete unit
	// of logic) that generated a finding. In various security findings provider's
	// solutions, this generator can be called a rule, a check, a detector, a plug-in,
	// etc.
	//
	// GeneratorId is a required field
	GeneratorId *string `type:"string" required:"true"`

	// The security findings provider-specific identifier for a finding.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// An ISO8601-formatted timestamp that indicates when the potential security
	// issue captured by a finding was most recently observed by the security findings
	// provider.
	LastObservedAt *string `type:"string"`

	// A list of malware related to a finding.
	Malware []*Malware `type:"list"`

	// The details of network-related information about a finding.
	Network *Network `type:"structure"`

	// A user-defined note added to a finding.
	Note *Note `type:"structure"`

	// The details of process-related information about a finding.
	Process *ProcessDetails `type:"structure"`

	// The ARN generated by Security Hub that uniquely identifies a third-party
	// company (security findings provider) once this provider's product (solution
	// that generates findings) is registered with Security Hub.
	//
	// ProductArn is a required field
	ProductArn *string `type:"string" required:"true"`

	// A data type where security findings providers can include additional solution-specific
	// details that are not part of the defined AwsSecurityFinding format.
	ProductFields map[string]*string `type:"map"`

	// The record state of a finding.
	RecordState *string `type:"string" enum:"RecordState"`

	// A list of related findings.
	RelatedFindings []*RelatedFinding `type:"list"`

	// An data type that describes the remediation options for a finding.
	Remediation *Remediation `type:"structure"`

	// A set of resource data types that describe the resources to which the finding
	// refers.
	//
	// Resources is a required field
	Resources []*Resource `type:"list" required:"true"`

	// The schema version for which a finding is formatted.
	//
	// SchemaVersion is a required field
	SchemaVersion *string `type:"string" required:"true"`

	// A finding's severity.
	//
	// Severity is a required field
	Severity *Severity `type:"structure" required:"true"`

	// A URL that links to a page about the current finding in the security findings
	// provider's solution.
	SourceUrl *string `type:"string"`

	// Threat intel details related to a finding.
	ThreatIntelIndicators []*ThreatIntelIndicator `type:"list"`

	// A finding's title.
	//
	// In this release, Title is a required property.
	Title *string `type:"string"`

	// One or more finding types in the format of 'namespace/category/classifier'
	// that classify a finding.
	//
	// Valid namespace values are: Software and Configuration Checks | TTPs | Effects
	// | Unusual Behaviors | Sensitive Data Identifications
	//
	// Types is a required field
	Types []*string `type:"list" required:"true"`

	// An ISO8601-formatted timestamp that indicates when the finding record was
	// last updated by the security findings provider.
	//
	// UpdatedAt is a required field
	UpdatedAt *string `type:"string" required:"true"`

	// A list of name/value string pairs associated with the finding. These are
	// custom, user-defined fields added to a finding.
	UserDefinedFields map[string]*string `type:"map"`

	// Indicates the veracity of a finding.
	VerificationState *string `type:"string" enum:"VerificationState"`

	// The workflow state of a finding.
	WorkflowState *string `type:"string" enum:"WorkflowState"`
}

// String returns the string representation
func (s AwsSecurityFinding) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsSecurityFinding) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsSecurityFinding) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsSecurityFinding"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.CreatedAt == nil {
		invalidParams.Add(request.NewErrParamRequired("CreatedAt"))
	}
	if s.GeneratorId == nil {
		invalidParams.Add(request.NewErrParamRequired("GeneratorId"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.ProductArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductArn"))
	}
	if s.Resources == nil {
		invalidParams.Add(request.NewErrParamRequired("Resources"))
	}
	if s.SchemaVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaVersion"))
	}
	if s.Severity == nil {
		invalidParams.Add(request.NewErrParamRequired("Severity"))
	}
	if s.Types == nil {
		invalidParams.Add(request.NewErrParamRequired("Types"))
	}
	if s.UpdatedAt == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdatedAt"))
	}
	if s.Malware != nil {
		for i, v := range s.Malware {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Malware", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Note != nil {
		if err := s.Note.Validate(); err != nil {
			invalidParams.AddNested("Note", err.(request.ErrInvalidParams))
		}
	}
	if s.RelatedFindings != nil {
		for i, v := range s.RelatedFindings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RelatedFindings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Resources != nil {
		for i, v := range s.Resources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Resources", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Severity != nil {
		if err := s.Severity.Validate(); err != nil {
			invalidParams.AddNested("Severity", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *AwsSecurityFinding) SetAwsAccountId(v string) *AwsSecurityFinding {
	s.AwsAccountId = &v
	return s
}

// SetCompliance sets the Compliance field's value.
func (s *AwsSecurityFinding) SetCompliance(v *Compliance) *AwsSecurityFinding {
	s.Compliance = v
	return s
}

// SetConfidence sets the Confidence field's value.
func (s *AwsSecurityFinding) SetConfidence(v int64) *AwsSecurityFinding {
	s.Confidence = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AwsSecurityFinding) SetCreatedAt(v string) *AwsSecurityFinding {
	s.CreatedAt = &v
	return s
}

// SetCriticality sets the Criticality field's value.
func (s *AwsSecurityFinding) SetCriticality(v int64) *AwsSecurityFinding {
	s.Criticality = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsSecurityFinding) SetDescription(v string) *AwsSecurityFinding {
	s.Description = &v
	return s
}

// SetFirstObservedAt sets the FirstObservedAt field's value.
func (s *AwsSecurityFinding) SetFirstObservedAt(v string) *AwsSecurityFinding {
	s.FirstObservedAt = &v
	return s
}

// SetGeneratorId sets the GeneratorId field's value.
func (s *AwsSecurityFinding) SetGeneratorId(v string) *AwsSecurityFinding {
	s.GeneratorId = &v
	return s
}

// SetId sets the Id field's value.
func (s *AwsSecurityFinding) SetId(v string) *AwsSecurityFinding {
	s.Id = &v
	return s
}

// SetLastObservedAt sets the LastObservedAt field's value.
func (s *AwsSecurityFinding) SetLastObservedAt(v string) *AwsSecurityFinding {
	s.LastObservedAt = &v
	return s
}

// SetMalware sets the Malware field's value.
func (s *AwsSecurityFinding) SetMalware(v []*Malware) *AwsSecurityFinding {
	s.Malware = v
	return s
}

// SetNetwork sets the Network field's value.
func (s *AwsSecurityFinding) SetNetwork(v *Network) *AwsSecurityFinding {
	s.Network = v
	return s
}

// SetNote sets the Note field's value.
func (s *AwsSecurityFinding) SetNote(v *Note) *AwsSecurityFinding {
	s.Note = v
	return s
}

// SetProcess sets the Process field's value.
func (s *AwsSecurityFinding) SetProcess(v *ProcessDetails) *AwsSecurityFinding {
	s.Process = v
	return s
}

// SetProductArn sets the ProductArn field's value.
func (s *AwsSecurityFinding) SetProductArn(v string) *AwsSecurityFinding {
	s.ProductArn = &v
	return s
}

// SetProductFields sets the ProductFields field's value.
func (s *AwsSecurityFinding) SetProductFields(v map[string]*string) *AwsSecurityFinding {
	s.ProductFields = v
	return s
}

// SetRecordState sets the RecordState field's value.
func (s *AwsSecurityFinding) SetRecordState(v string) *AwsSecurityFinding {
	s.RecordState = &v
	return s
}

// SetRelatedFindings sets the RelatedFindings field's value.
func (s *AwsSecurityFinding) SetRelatedFindings(v []*RelatedFinding) *AwsSecurityFinding {
	s.RelatedFindings = v
	return s
}

// SetRemediation sets the Remediation field's value.
func (s *AwsSecurityFinding) SetRemediation(v *Remediation) *AwsSecurityFinding {
	s.Remediation = v
	return s
}

// SetResources sets the Resources field's value.
func (s *AwsSecurityFinding) SetResources(v []*Resource) *AwsSecurityFinding {
	s.Resources = v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *AwsSecurityFinding) SetSchemaVersion(v string) *AwsSecurityFinding {
	s.SchemaVersion = &v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *AwsSecurityFinding) SetSeverity(v *Severity) *AwsSecurityFinding {
	s.Severity = v
	return s
}

// SetSourceUrl sets the SourceUrl field's value.
func (s *AwsSecurityFinding) SetSourceUrl(v string) *AwsSecurityFinding {
	s.SourceUrl = &v
	return s
}

// SetThreatIntelIndicators sets the ThreatIntelIndicators field's value.
func (s *AwsSecurityFinding) SetThreatIntelIndicators(v []*ThreatIntelIndicator) *AwsSecurityFinding {
	s.ThreatIntelIndicators = v
	return s
}

// SetTitle sets the Title field's value.
func (s *AwsSecurityFinding) SetTitle(v string) *AwsSecurityFinding {
	s.Title = &v
	return s
}

// SetTypes sets the Types field's value.
func (s *AwsSecurityFinding) SetTypes(v []*string) *AwsSecurityFinding {
	s.Types = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AwsSecurityFinding) SetUpdatedAt(v string) *AwsSecurityFinding {
	s.UpdatedAt = &v
	return s
}

// SetUserDefinedFields sets the UserDefinedFields field's value.
func (s *AwsSecurityFinding) SetUserDefinedFields(v map[string]*string) *AwsSecurityFinding {
	s.UserDefinedFields = v
	return s
}

// SetVerificationState sets the VerificationState field's value.
func (s *AwsSecurityFinding) SetVerificationState(v string) *AwsSecurityFinding {
	s.VerificationState = &v
	return s
}

// SetWorkflowState sets the WorkflowState field's value.
func (s *AwsSecurityFinding) SetWorkflowState(v string) *AwsSecurityFinding {
	s.WorkflowState = &v
	return s
}

// A collection of attributes that are applied to all active Security Hub-aggregated
// findings and that result in a subset of findings that are included in this
// insight.
type AwsSecurityFindingFilters struct {
	_ struct{} `type:"structure"`

	// The AWS account ID in which a finding is generated.
	AwsAccountId []*StringFilter `type:"list"`

	// The name of the findings provider (company) that owns the solution (product)
	// that generates findings.
	CompanyName []*StringFilter `type:"list"`

	// Exclusive to findings that are generated as the result of a check run against
	// a specific rule in a supported standard (for example, AWS CIS Foundations).
	// Contains compliance-related finding details.
	ComplianceStatus []*StringFilter `type:"list"`

	// A finding's confidence. Confidence is defined as the likelihood that a finding
	// accurately identifies the behavior or issue that it was intended to identify.
	// Confidence is scored on a 0-100 basis using a ratio scale. 0 equates zero
	// percent confidence and 100 equates to 100 percent confidence.
	Confidence []*NumberFilter `type:"list"`

	// An ISO8601-formatted timestamp that indicates when the potential security
	// issue captured by a finding was created by the security findings provider.
	CreatedAt []*DateFilter `type:"list"`

	// The level of importance assigned to the resources associated with the finding.
	// A score of 0 means the underlying resources have no criticality, and a score
	// of 100 is reserved for the most critical resources.
	Criticality []*NumberFilter `type:"list"`

	// A finding's description.
	Description []*StringFilter `type:"list"`

	// An ISO8601-formatted timestamp that indicates when the potential security
	// issue captured by a finding was first observed by the security findings provider.
	FirstObservedAt []*DateFilter `type:"list"`

	// This is the identifier for the solution-specific component (a discrete unit
	// of logic) that generated a finding. In various security findings provider's
	// solutions, this generator can be called a rule, a check, a detector, a plug-in,
	// etc.
	GeneratorId []*StringFilter `type:"list"`

	// The security findings provider-specific identifier for a finding.
	Id []*StringFilter `type:"list"`

	// A keyword for a finding.
	Keyword []*KeywordFilter `type:"list"`

	// An ISO8601-formatted timestamp that indicates when the potential security
	// issue captured by a finding was most recently observed by the security findings
	// provider.
	LastObservedAt []*DateFilter `type:"list"`

	// The name of the malware that was observed.
	MalwareName []*StringFilter `type:"list"`

	// The filesystem path of the malware that was observed.
	MalwarePath []*StringFilter `type:"list"`

	// The state of the malware that was observed.
	MalwareState []*StringFilter `type:"list"`

	// The type of the malware that was observed.
	MalwareType []*StringFilter `type:"list"`

	// The destination domain of network-related information about a finding.
	NetworkDestinationDomain []*StringFilter `type:"list"`

	// The destination IPv4 address of network-related information about a finding.
	NetworkDestinationIpV4 []*IpFilter `type:"list"`

	// The destination IPv6 address of network-related information about a finding.
	NetworkDestinationIpV6 []*IpFilter `type:"list"`

	// The destination port of network-related information about a finding.
	NetworkDestinationPort []*NumberFilter `type:"list"`

	// Indicates the direction of network traffic associated with a finding.
	NetworkDirection []*StringFilter `type:"list"`

	// The protocol of network-related information about a finding.
	NetworkProtocol []*StringFilter `type:"list"`

	// The source domain of network-related information about a finding.
	NetworkSourceDomain []*StringFilter `type:"list"`

	// The source IPv4 address of network-related information about a finding.
	NetworkSourceIpV4 []*IpFilter `type:"list"`

	// The source IPv6 address of network-related information about a finding.
	NetworkSourceIpV6 []*IpFilter `type:"list"`

	// The source media access control (MAC) address of network-related information
	// about a finding.
	NetworkSourceMac []*StringFilter `type:"list"`

	// The source port of network-related information about a finding.
	NetworkSourcePort []*NumberFilter `type:"list"`

	// The text of a note.
	NoteText []*StringFilter `type:"list"`

	// The timestamp of when the note was updated.
	NoteUpdatedAt []*DateFilter `type:"list"`

	// The principal that created a note.
	NoteUpdatedBy []*StringFilter `type:"list"`

	// The date/time that the process was launched.
	ProcessLaunchedAt []*DateFilter `type:"list"`

	// The name of the process.
	ProcessName []*StringFilter `type:"list"`

	// The parent process ID.
	ProcessParentPid []*NumberFilter `type:"list"`

	// The path to the process executable.
	ProcessPath []*StringFilter `type:"list"`

	// The process ID.
	ProcessPid []*NumberFilter `type:"list"`

	// The date/time that the process was terminated.
	ProcessTerminatedAt []*DateFilter `type:"list"`

	// The ARN generated by Security Hub that uniquely identifies a third-party
	// company (security findings provider) once this provider's product (solution
	// that generates findings) is registered with Security Hub.
	ProductArn []*StringFilter `type:"list"`

	// A data type where security findings providers can include additional solution-specific
	// details that are not part of the defined AwsSecurityFinding format.
	ProductFields []*MapFilter `type:"list"`

	// The name of the solution (product) that generates findings.
	ProductName []*StringFilter `type:"list"`

	// The recommendation of what to do about the issue described in a finding.
	RecommendationText []*StringFilter `type:"list"`

	// The updated record state for the finding.
	RecordState []*StringFilter `type:"list"`

	// The solution-generated identifier for a related finding.
	RelatedFindingsId []*StringFilter `type:"list"`

	// The ARN of the solution that generated a related finding.
	RelatedFindingsProductArn []*StringFilter `type:"list"`

	// The IAM profile ARN of the instance.
	ResourceAwsEc2InstanceIamInstanceProfileArn []*StringFilter `type:"list"`

	// The Amazon Machine Image (AMI) ID of the instance.
	ResourceAwsEc2InstanceImageId []*StringFilter `type:"list"`

	// The IPv4 addresses associated with the instance.
	ResourceAwsEc2InstanceIpV4Addresses []*IpFilter `type:"list"`

	// The IPv6 addresses associated with the instance.
	ResourceAwsEc2InstanceIpV6Addresses []*IpFilter `type:"list"`

	// The key name associated with the instance.
	ResourceAwsEc2InstanceKeyName []*StringFilter `type:"list"`

	// The date/time the instance was launched.
	ResourceAwsEc2InstanceLaunchedAt []*DateFilter `type:"list"`

	// The identifier of the subnet in which the instance was launched.
	ResourceAwsEc2InstanceSubnetId []*StringFilter `type:"list"`

	// The instance type of the instance.
	ResourceAwsEc2InstanceType []*StringFilter `type:"list"`

	// The identifier of the VPC in which the instance was launched.
	ResourceAwsEc2InstanceVpcId []*StringFilter `type:"list"`

	// The creation date/time of the IAM access key related to a finding.
	ResourceAwsIamAccessKeyCreatedAt []*DateFilter `type:"list"`

	// The status of the IAM access key related to a finding.
	ResourceAwsIamAccessKeyStatus []*StringFilter `type:"list"`

	// The user associated with the IAM access key related to a finding.
	ResourceAwsIamAccessKeyUserName []*StringFilter `type:"list"`

	// The canonical user ID of the owner of the S3 bucket.
	ResourceAwsS3BucketOwnerId []*StringFilter `type:"list"`

	// The display name of the owner of the S3 bucket.
	ResourceAwsS3BucketOwnerName []*StringFilter `type:"list"`

	// The identifier of the image related to a finding.
	ResourceContainerImageId []*StringFilter `type:"list"`

	// The name of the image related to a finding.
	ResourceContainerImageName []*StringFilter `type:"list"`

	// The date/time that the container was started.
	ResourceContainerLaunchedAt []*DateFilter `type:"list"`

	// The name of the container related to a finding.
	ResourceContainerName []*StringFilter `type:"list"`

	// The details of a resource that does not have a specific sub-field for the
	// resource type defined.
	ResourceDetailsOther []*MapFilter `type:"list"`

	// The canonical identifier for the given resource type.
	ResourceId []*StringFilter `type:"list"`

	// The canonical AWS partition name to which the region is assigned.
	ResourcePartition []*StringFilter `type:"list"`

	// The canonical AWS external region name where this resource is located.
	ResourceRegion []*StringFilter `type:"list"`

	// A list of AWS tags associated with a resource at the time the finding was
	// processed.
	ResourceTags []*MapFilter `type:"list"`

	// Specifies the type of the resource for which details are provided.
	ResourceType []*StringFilter `type:"list"`

	// The label of a finding's severity.
	SeverityLabel []*StringFilter `type:"list"`

	// The normalized severity of a finding.
	SeverityNormalized []*NumberFilter `type:"list"`

	// The native severity as defined by the security findings provider's solution
	// that generated the finding.
	SeverityProduct []*NumberFilter `type:"list"`

	// A URL that links to a page about the current finding in the security findings
	// provider's solution.
	SourceUrl []*StringFilter `type:"list"`

	// The category of a threat intel indicator.
	ThreatIntelIndicatorCategory []*StringFilter `type:"list"`

	// The date/time of the last observation of a threat intel indicator.
	ThreatIntelIndicatorLastObservedAt []*DateFilter `type:"list"`

	// The source of the threat intel.
	ThreatIntelIndicatorSource []*StringFilter `type:"list"`

	// The URL for more details from the source of the threat intel.
	ThreatIntelIndicatorSourceUrl []*StringFilter `type:"list"`

	// The type of a threat intel indicator.
	ThreatIntelIndicatorType []*StringFilter `type:"list"`

	// The value of a threat intel indicator.
	ThreatIntelIndicatorValue []*StringFilter `type:"list"`

	// A finding's title.
	Title []*StringFilter `type:"list"`

	// A finding type in the format of 'namespace/category/classifier' that classifies
	// a finding.
	Type []*StringFilter `type:"list"`

	// An ISO8601-formatted timestamp that indicates when the finding record was
	// last updated by the security findings provider.
	UpdatedAt []*DateFilter `type:"list"`

	// A list of name/value string pairs associated with the finding. These are
	// custom, user-defined fields added to a finding.
	UserDefinedFields []*MapFilter `type:"list"`

	// Indicates the veracity of a finding.
	VerificationState []*StringFilter `type:"list"`

	// The workflow state of a finding.
	WorkflowState []*StringFilter `type:"list"`
}

// String returns the string representation
func (s AwsSecurityFindingFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsSecurityFindingFilters) GoString() string {
	return s.String()
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *AwsSecurityFindingFilters) SetAwsAccountId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.AwsAccountId = v
	return s
}

// SetCompanyName sets the CompanyName field's value.
func (s *AwsSecurityFindingFilters) SetCompanyName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.CompanyName = v
	return s
}

// SetComplianceStatus sets the ComplianceStatus field's value.
func (s *AwsSecurityFindingFilters) SetComplianceStatus(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ComplianceStatus = v
	return s
}

// SetConfidence sets the Confidence field's value.
func (s *AwsSecurityFindingFilters) SetConfidence(v []*NumberFilter) *AwsSecurityFindingFilters {
	s.Confidence = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AwsSecurityFindingFilters) SetCreatedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.CreatedAt = v
	return s
}

// SetCriticality sets the Criticality field's value.
func (s *AwsSecurityFindingFilters) SetCriticality(v []*NumberFilter) *AwsSecurityFindingFilters {
	s.Criticality = v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsSecurityFindingFilters) SetDescription(v []*StringFilter) *AwsSecurityFindingFilters {
	s.Description = v
	return s
}

// SetFirstObservedAt sets the FirstObservedAt field's value.
func (s *AwsSecurityFindingFilters) SetFirstObservedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.FirstObservedAt = v
	return s
}

// SetGeneratorId sets the GeneratorId field's value.
func (s *AwsSecurityFindingFilters) SetGeneratorId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.GeneratorId = v
	return s
}

// SetId sets the Id field's value.
func (s *AwsSecurityFindingFilters) SetId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.Id = v
	return s
}

// SetKeyword sets the Keyword field's value.
func (s *AwsSecurityFindingFilters) SetKeyword(v []*KeywordFilter) *AwsSecurityFindingFilters {
	s.Keyword = v
	return s
}

// SetLastObservedAt sets the LastObservedAt field's value.
func (s *AwsSecurityFindingFilters) SetLastObservedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.LastObservedAt = v
	return s
}

// SetMalwareName sets the MalwareName field's value.
func (s *AwsSecurityFindingFilters) SetMalwareName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.MalwareName = v
	return s
}

// SetMalwarePath sets the MalwarePath field's value.
func (s *AwsSecurityFindingFilters) SetMalwarePath(v []*StringFilter) *AwsSecurityFindingFilters {
	s.MalwarePath = v
	return s
}

// SetMalwareState sets the MalwareState field's value.
func (s *AwsSecurityFindingFilters) SetMalwareState(v []*StringFilter) *AwsSecurityFindingFilters {
	s.MalwareState = v
	return s
}

// SetMalwareType sets the MalwareType field's value.
func (s *AwsSecurityFindingFilters) SetMalwareType(v []*StringFilter) *AwsSecurityFindingFilters {
	s.MalwareType = v
	return s
}

// SetNetworkDestinationDomain sets the NetworkDestinationDomain field's value.
func (s *AwsSecurityFindingFilters) SetNetworkDestinationDomain(v []*StringFilter) *AwsSecurityFindingFilters {
	s.NetworkDestinationDomain = v
	return s
}

// SetNetworkDestinationIpV4 sets the NetworkDestinationIpV4 field's value.
func (s *AwsSecurityFindingFilters) SetNetworkDestinationIpV4(v []*IpFilter) *AwsSecurityFindingFilters {
	s.NetworkDestinationIpV4 = v
	return s
}

// SetNetworkDestinationIpV6 sets the NetworkDestinationIpV6 field's value.
func (s *AwsSecurityFindingFilters) SetNetworkDestinationIpV6(v []*IpFilter) *AwsSecurityFindingFilters {
	s.NetworkDestinationIpV6 = v
	return s
}

// SetNetworkDestinationPort sets the NetworkDestinationPort field's value.
func (s *AwsSecurityFindingFilters) SetNetworkDestinationPort(v []*NumberFilter) *AwsSecurityFindingFilters {
	s.NetworkDestinationPort = v
	return s
}

// SetNetworkDirection sets the NetworkDirection field's value.
func (s *AwsSecurityFindingFilters) SetNetworkDirection(v []*StringFilter) *AwsSecurityFindingFilters {
	s.NetworkDirection = v
	return s
}

// SetNetworkProtocol sets the NetworkProtocol field's value.
func (s *AwsSecurityFindingFilters) SetNetworkProtocol(v []*StringFilter) *AwsSecurityFindingFilters {
	s.NetworkProtocol = v
	return s
}

// SetNetworkSourceDomain sets the NetworkSourceDomain field's value.
func (s *AwsSecurityFindingFilters) SetNetworkSourceDomain(v []*StringFilter) *AwsSecurityFindingFilters {
	s.NetworkSourceDomain = v
	return s
}

// SetNetworkSourceIpV4 sets the NetworkSourceIpV4 field's value.
func (s *AwsSecurityFindingFilters) SetNetworkSourceIpV4(v []*IpFilter) *AwsSecurityFindingFilters {
	s.NetworkSourceIpV4 = v
	return s
}

// SetNetworkSourceIpV6 sets the NetworkSourceIpV6 field's value.
func (s *AwsSecurityFindingFilters) SetNetworkSourceIpV6(v []*IpFilter) *AwsSecurityFindingFilters {
	s.NetworkSourceIpV6 = v
	return s
}

// SetNetworkSourceMac sets the NetworkSourceMac field's value.
func (s *AwsSecurityFindingFilters) SetNetworkSourceMac(v []*StringFilter) *AwsSecurityFindingFilters {
	s.NetworkSourceMac = v
	return s
}

// SetNetworkSourcePort sets the NetworkSourcePort field's value.
func (s *AwsSecurityFindingFilters) SetNetworkSourcePort(v []*NumberFilter) *AwsSecurityFindingFilters {
	s.NetworkSourcePort = v
	return s
}

// SetNoteText sets the NoteText field's value.
func (s *AwsSecurityFindingFilters) SetNoteText(v []*StringFilter) *AwsSecurityFindingFilters {
	s.NoteText = v
	return s
}

// SetNoteUpdatedAt sets the NoteUpdatedAt field's value.
func (s *AwsSecurityFindingFilters) SetNoteUpdatedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.NoteUpdatedAt = v
	return s
}

// SetNoteUpdatedBy sets the NoteUpdatedBy field's value.
func (s *AwsSecurityFindingFilters) SetNoteUpdatedBy(v []*StringFilter) *AwsSecurityFindingFilters {
	s.NoteUpdatedBy = v
	return s
}

// SetProcessLaunchedAt sets the ProcessLaunchedAt field's value.
func (s *AwsSecurityFindingFilters) SetProcessLaunchedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.ProcessLaunchedAt = v
	return s
}

// SetProcessName sets the ProcessName field's value.
func (s *AwsSecurityFindingFilters) SetProcessName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ProcessName = v
	return s
}

// SetProcessParentPid sets the ProcessParentPid field's value.
func (s *AwsSecurityFindingFilters) SetProcessParentPid(v []*NumberFilter) *AwsSecurityFindingFilters {
	s.ProcessParentPid = v
	return s
}

// SetProcessPath sets the ProcessPath field's value.
func (s *AwsSecurityFindingFilters) SetProcessPath(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ProcessPath = v
	return s
}

// SetProcessPid sets the ProcessPid field's value.
func (s *AwsSecurityFindingFilters) SetProcessPid(v []*NumberFilter) *AwsSecurityFindingFilters {
	s.ProcessPid = v
	return s
}

// SetProcessTerminatedAt sets the ProcessTerminatedAt field's value.
func (s *AwsSecurityFindingFilters) SetProcessTerminatedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.ProcessTerminatedAt = v
	return s
}

// SetProductArn sets the ProductArn field's value.
func (s *AwsSecurityFindingFilters) SetProductArn(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ProductArn = v
	return s
}

// SetProductFields sets the ProductFields field's value.
func (s *AwsSecurityFindingFilters) SetProductFields(v []*MapFilter) *AwsSecurityFindingFilters {
	s.ProductFields = v
	return s
}

// SetProductName sets the ProductName field's value.
func (s *AwsSecurityFindingFilters) SetProductName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ProductName = v
	return s
}

// SetRecommendationText sets the RecommendationText field's value.
func (s *AwsSecurityFindingFilters) SetRecommendationText(v []*StringFilter) *AwsSecurityFindingFilters {
	s.RecommendationText = v
	return s
}

// SetRecordState sets the RecordState field's value.
func (s *AwsSecurityFindingFilters) SetRecordState(v []*StringFilter) *AwsSecurityFindingFilters {
	s.RecordState = v
	return s
}

// SetRelatedFindingsId sets the RelatedFindingsId field's value.
func (s *AwsSecurityFindingFilters) SetRelatedFindingsId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.RelatedFindingsId = v
	return s
}

// SetRelatedFindingsProductArn sets the RelatedFindingsProductArn field's value.
func (s *AwsSecurityFindingFilters) SetRelatedFindingsProductArn(v []*StringFilter) *AwsSecurityFindingFilters {
	s.RelatedFindingsProductArn = v
	return s
}

// SetResourceAwsEc2InstanceIamInstanceProfileArn sets the ResourceAwsEc2InstanceIamInstanceProfileArn field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceIamInstanceProfileArn(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceIamInstanceProfileArn = v
	return s
}

// SetResourceAwsEc2InstanceImageId sets the ResourceAwsEc2InstanceImageId field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceImageId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceImageId = v
	return s
}

// SetResourceAwsEc2InstanceIpV4Addresses sets the ResourceAwsEc2InstanceIpV4Addresses field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceIpV4Addresses(v []*IpFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceIpV4Addresses = v
	return s
}

// SetResourceAwsEc2InstanceIpV6Addresses sets the ResourceAwsEc2InstanceIpV6Addresses field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceIpV6Addresses(v []*IpFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceIpV6Addresses = v
	return s
}

// SetResourceAwsEc2InstanceKeyName sets the ResourceAwsEc2InstanceKeyName field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceKeyName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceKeyName = v
	return s
}

// SetResourceAwsEc2InstanceLaunchedAt sets the ResourceAwsEc2InstanceLaunchedAt field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceLaunchedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceLaunchedAt = v
	return s
}

// SetResourceAwsEc2InstanceSubnetId sets the ResourceAwsEc2InstanceSubnetId field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceSubnetId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceSubnetId = v
	return s
}

// SetResourceAwsEc2InstanceType sets the ResourceAwsEc2InstanceType field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceType(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceType = v
	return s
}

// SetResourceAwsEc2InstanceVpcId sets the ResourceAwsEc2InstanceVpcId field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceVpcId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceVpcId = v
	return s
}

// SetResourceAwsIamAccessKeyCreatedAt sets the ResourceAwsIamAccessKeyCreatedAt field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsIamAccessKeyCreatedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsIamAccessKeyCreatedAt = v
	return s
}

// SetResourceAwsIamAccessKeyStatus sets the ResourceAwsIamAccessKeyStatus field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsIamAccessKeyStatus(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsIamAccessKeyStatus = v
	return s
}

// SetResourceAwsIamAccessKeyUserName sets the ResourceAwsIamAccessKeyUserName field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsIamAccessKeyUserName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsIamAccessKeyUserName = v
	return s
}

// SetResourceAwsS3BucketOwnerId sets the ResourceAwsS3BucketOwnerId field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsS3BucketOwnerId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsS3BucketOwnerId = v
	return s
}

// SetResourceAwsS3BucketOwnerName sets the ResourceAwsS3BucketOwnerName field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsS3BucketOwnerName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsS3BucketOwnerName = v
	return s
}

// SetResourceContainerImageId sets the ResourceContainerImageId field's value.
func (s *AwsSecurityFindingFilters) SetResourceContainerImageId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceContainerImageId = v
	return s
}

// SetResourceContainerImageName sets the ResourceContainerImageName field's value.
func (s *AwsSecurityFindingFilters) SetResourceContainerImageName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceContainerImageName = v
	return s
}

// SetResourceContainerLaunchedAt sets the ResourceContainerLaunchedAt field's value.
func (s *AwsSecurityFindingFilters) SetResourceContainerLaunchedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.ResourceContainerLaunchedAt = v
	return s
}

// SetResourceContainerName sets the ResourceContainerName field's value.
func (s *AwsSecurityFindingFilters) SetResourceContainerName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceContainerName = v
	return s
}

// SetResourceDetailsOther sets the ResourceDetailsOther field's value.
func (s *AwsSecurityFindingFilters) SetResourceDetailsOther(v []*MapFilter) *AwsSecurityFindingFilters {
	s.ResourceDetailsOther = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *AwsSecurityFindingFilters) SetResourceId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceId = v
	return s
}

// SetResourcePartition sets the ResourcePartition field's value.
func (s *AwsSecurityFindingFilters) SetResourcePartition(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourcePartition = v
	return s
}

// SetResourceRegion sets the ResourceRegion field's value.
func (s *AwsSecurityFindingFilters) SetResourceRegion(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceRegion = v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *AwsSecurityFindingFilters) SetResourceTags(v []*MapFilter) *AwsSecurityFindingFilters {
	s.ResourceTags = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AwsSecurityFindingFilters) SetResourceType(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceType = v
	return s
}

// SetSeverityLabel sets the SeverityLabel field's value.
func (s *AwsSecurityFindingFilters) SetSeverityLabel(v []*StringFilter) *AwsSecurityFindingFilters {
	s.SeverityLabel = v
	return s
}

// SetSeverityNormalized sets the SeverityNormalized field's value.
func (s *AwsSecurityFindingFilters) SetSeverityNormalized(v []*NumberFilter) *AwsSecurityFindingFilters {
	s.SeverityNormalized = v
	return s
}

// SetSeverityProduct sets the SeverityProduct field's value.
func (s *AwsSecurityFindingFilters) SetSeverityProduct(v []*NumberFilter) *AwsSecurityFindingFilters {
	s.SeverityProduct = v
	return s
}

// SetSourceUrl sets the SourceUrl field's value.
func (s *AwsSecurityFindingFilters) SetSourceUrl(v []*StringFilter) *AwsSecurityFindingFilters {
	s.SourceUrl = v
	return s
}

// SetThreatIntelIndicatorCategory sets the ThreatIntelIndicatorCategory field's value.
func (s *AwsSecurityFindingFilters) SetThreatIntelIndicatorCategory(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ThreatIntelIndicatorCategory = v
	return s
}

// SetThreatIntelIndicatorLastObservedAt sets the ThreatIntelIndicatorLastObservedAt field's value.
func (s *AwsSecurityFindingFilters) SetThreatIntelIndicatorLastObservedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.ThreatIntelIndicatorLastObservedAt = v
	return s
}

// SetThreatIntelIndicatorSource sets the ThreatIntelIndicatorSource field's value.
func (s *AwsSecurityFindingFilters) SetThreatIntelIndicatorSource(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ThreatIntelIndicatorSource = v
	return s
}

// SetThreatIntelIndicatorSourceUrl sets the ThreatIntelIndicatorSourceUrl field's value.
func (s *AwsSecurityFindingFilters) SetThreatIntelIndicatorSourceUrl(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ThreatIntelIndicatorSourceUrl = v
	return s
}

// SetThreatIntelIndicatorType sets the ThreatIntelIndicatorType field's value.
func (s *AwsSecurityFindingFilters) SetThreatIntelIndicatorType(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ThreatIntelIndicatorType = v
	return s
}

// SetThreatIntelIndicatorValue sets the ThreatIntelIndicatorValue field's value.
func (s *AwsSecurityFindingFilters) SetThreatIntelIndicatorValue(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ThreatIntelIndicatorValue = v
	return s
}

// SetTitle sets the Title field's value.
func (s *AwsSecurityFindingFilters) SetTitle(v []*StringFilter) *AwsSecurityFindingFilters {
	s.Title = v
	return s
}

// SetType sets the Type field's value.
func (s *AwsSecurityFindingFilters) SetType(v []*StringFilter) *AwsSecurityFindingFilters {
	s.Type = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AwsSecurityFindingFilters) SetUpdatedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.UpdatedAt = v
	return s
}

// SetUserDefinedFields sets the UserDefinedFields field's value.
func (s *AwsSecurityFindingFilters) SetUserDefinedFields(v []*MapFilter) *AwsSecurityFindingFilters {
	s.UserDefinedFields = v
	return s
}

// SetVerificationState sets the VerificationState field's value.
func (s *AwsSecurityFindingFilters) SetVerificationState(v []*StringFilter) *AwsSecurityFindingFilters {
	s.VerificationState = v
	return s
}

// SetWorkflowState sets the WorkflowState field's value.
func (s *AwsSecurityFindingFilters) SetWorkflowState(v []*StringFilter) *AwsSecurityFindingFilters {
	s.WorkflowState = v
	return s
}

type BatchDisableStandardsInput struct {
	_ struct{} `type:"structure"`

	// The ARNS of the standards subscriptions that you want to disable.
	//
	// StandardsSubscriptionArns is a required field
	StandardsSubscriptionArns []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDisableStandardsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDisableStandardsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDisableStandardsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDisableStandardsInput"}
	if s.StandardsSubscriptionArns == nil {
		invalidParams.Add(request.NewErrParamRequired("StandardsSubscriptionArns"))
	}
	if s.StandardsSubscriptionArns != nil && len(s.StandardsSubscriptionArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StandardsSubscriptionArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStandardsSubscriptionArns sets the StandardsSubscriptionArns field's value.
func (s *BatchDisableStandardsInput) SetStandardsSubscriptionArns(v []*string) *BatchDisableStandardsInput {
	s.StandardsSubscriptionArns = v
	return s
}

type BatchDisableStandardsOutput struct {
	_ struct{} `type:"structure"`

	// The details of the standards subscriptions that were disabled.
	StandardsSubscriptions []*StandardsSubscription `type:"list"`
}

// String returns the string representation
func (s BatchDisableStandardsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDisableStandardsOutput) GoString() string {
	return s.String()
}

// SetStandardsSubscriptions sets the StandardsSubscriptions field's value.
func (s *BatchDisableStandardsOutput) SetStandardsSubscriptions(v []*StandardsSubscription) *BatchDisableStandardsOutput {
	s.StandardsSubscriptions = v
	return s
}

type BatchEnableStandardsInput struct {
	_ struct{} `type:"structure"`

	// The list of standards that you want to enable.
	//
	// In this release, Security Hub only supports the CIS AWS Foundations standard.
	//
	// Its ARN is arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0.
	//
	// StandardsSubscriptionRequests is a required field
	StandardsSubscriptionRequests []*StandardsSubscriptionRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchEnableStandardsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchEnableStandardsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchEnableStandardsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchEnableStandardsInput"}
	if s.StandardsSubscriptionRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("StandardsSubscriptionRequests"))
	}
	if s.StandardsSubscriptionRequests != nil && len(s.StandardsSubscriptionRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StandardsSubscriptionRequests", 1))
	}
	if s.StandardsSubscriptionRequests != nil {
		for i, v := range s.StandardsSubscriptionRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StandardsSubscriptionRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStandardsSubscriptionRequests sets the StandardsSubscriptionRequests field's value.
func (s *BatchEnableStandardsInput) SetStandardsSubscriptionRequests(v []*StandardsSubscriptionRequest) *BatchEnableStandardsInput {
	s.StandardsSubscriptionRequests = v
	return s
}

type BatchEnableStandardsOutput struct {
	_ struct{} `type:"structure"`

	// The details of the standards subscriptions that were enabled.
	StandardsSubscriptions []*StandardsSubscription `type:"list"`
}

// String returns the string representation
func (s BatchEnableStandardsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchEnableStandardsOutput) GoString() string {
	return s.String()
}

// SetStandardsSubscriptions sets the StandardsSubscriptions field's value.
func (s *BatchEnableStandardsOutput) SetStandardsSubscriptions(v []*StandardsSubscription) *BatchEnableStandardsOutput {
	s.StandardsSubscriptions = v
	return s
}

type BatchImportFindingsInput struct {
	_ struct{} `type:"structure"`

	// A list of findings that you want to import. Must be submitted in the AWSSecurityFinding
	// format.
	//
	// Findings is a required field
	Findings []*AwsSecurityFinding `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchImportFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchImportFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchImportFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchImportFindingsInput"}
	if s.Findings == nil {
		invalidParams.Add(request.NewErrParamRequired("Findings"))
	}
	if s.Findings != nil {
		for i, v := range s.Findings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Findings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFindings sets the Findings field's value.
func (s *BatchImportFindingsInput) SetFindings(v []*AwsSecurityFinding) *BatchImportFindingsInput {
	s.Findings = v
	return s
}

type BatchImportFindingsOutput struct {
	_ struct{} `type:"structure"`

	// The number of findings that cannot be imported.
	//
	// FailedCount is a required field
	FailedCount *int64 `type:"integer" required:"true"`

	// The list of the findings that cannot be imported.
	FailedFindings []*ImportFindingsError `type:"list"`

	// The number of findings that were successfully imported
	//
	// SuccessCount is a required field
	SuccessCount *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s BatchImportFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchImportFindingsOutput) GoString() string {
	return s.String()
}

// SetFailedCount sets the FailedCount field's value.
func (s *BatchImportFindingsOutput) SetFailedCount(v int64) *BatchImportFindingsOutput {
	s.FailedCount = &v
	return s
}

// SetFailedFindings sets the FailedFindings field's value.
func (s *BatchImportFindingsOutput) SetFailedFindings(v []*ImportFindingsError) *BatchImportFindingsOutput {
	s.FailedFindings = v
	return s
}

// SetSuccessCount sets the SuccessCount field's value.
func (s *BatchImportFindingsOutput) SetSuccessCount(v int64) *BatchImportFindingsOutput {
	s.SuccessCount = &v
	return s
}

// Exclusive to findings that are generated as the result of a check run against
// a specific rule in a supported standard (for example, AWS CIS Foundations).
// Contains compliance-related finding details.
type Compliance struct {
	_ struct{} `type:"structure"`

	// Indicates the result of a compliance check.
	Status *string `type:"string" enum:"ComplianceStatus"`
}

// String returns the string representation
func (s Compliance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Compliance) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *Compliance) SetStatus(v string) *Compliance {
	s.Status = &v
	return s
}

// Container details related to a finding.
type ContainerDetails struct {
	_ struct{} `type:"structure"`

	// The identifier of the image related to a finding.
	ImageId *string `type:"string"`

	// The name of the image related to a finding.
	ImageName *string `type:"string"`

	// The date/time that the container was started.
	LaunchedAt *string `type:"string"`

	// The name of the container related to a finding.
	Name *string `type:"string"`
}

// String returns the string representation
func (s ContainerDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContainerDetails) GoString() string {
	return s.String()
}

// SetImageId sets the ImageId field's value.
func (s *ContainerDetails) SetImageId(v string) *ContainerDetails {
	s.ImageId = &v
	return s
}

// SetImageName sets the ImageName field's value.
func (s *ContainerDetails) SetImageName(v string) *ContainerDetails {
	s.ImageName = &v
	return s
}

// SetLaunchedAt sets the LaunchedAt field's value.
func (s *ContainerDetails) SetLaunchedAt(v string) *ContainerDetails {
	s.LaunchedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *ContainerDetails) SetName(v string) *ContainerDetails {
	s.Name = &v
	return s
}

type CreateInsightInput struct {
	_ struct{} `type:"structure"`

	// A collection of attributes that are applied to all active Security Hub-aggregated
	// findings and that result in a subset of findings that are included in this
	// insight.
	//
	// Filters is a required field
	Filters *AwsSecurityFindingFilters `type:"structure" required:"true"`

	// The attribute by which the insight's findings are grouped. This attribute
	// is used as a findings aggregator for the purposes of viewing and managing
	// multiple related findings under a single operand.
	//
	// GroupByAttribute is a required field
	GroupByAttribute *string `type:"string" required:"true"`

	// The user-defined name that identifies the insight that you want to create.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateInsightInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInsightInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInsightInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInsightInput"}
	if s.Filters == nil {
		invalidParams.Add(request.NewErrParamRequired("Filters"))
	}
	if s.GroupByAttribute == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupByAttribute"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *CreateInsightInput) SetFilters(v *AwsSecurityFindingFilters) *CreateInsightInput {
	s.Filters = v
	return s
}

// SetGroupByAttribute sets the GroupByAttribute field's value.
func (s *CreateInsightInput) SetGroupByAttribute(v string) *CreateInsightInput {
	s.GroupByAttribute = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateInsightInput) SetName(v string) *CreateInsightInput {
	s.Name = &v
	return s
}

type CreateInsightOutput struct {
	_ struct{} `type:"structure"`

	// The ARN Of the created insight.
	//
	// InsightArn is a required field
	InsightArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateInsightOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInsightOutput) GoString() string {
	return s.String()
}

// SetInsightArn sets the InsightArn field's value.
func (s *CreateInsightOutput) SetInsightArn(v string) *CreateInsightOutput {
	s.InsightArn = &v
	return s
}

type CreateMembersInput struct {
	_ struct{} `type:"structure"`

	// A list of account ID and email address pairs of the accounts that you want
	// to associate with the master Security Hub account.
	AccountDetails []*AccountDetails `type:"list"`
}

// String returns the string representation
func (s CreateMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMembersInput) GoString() string {
	return s.String()
}

// SetAccountDetails sets the AccountDetails field's value.
func (s *CreateMembersInput) SetAccountDetails(v []*AccountDetails) *CreateMembersInput {
	s.AccountDetails = v
	return s
}

type CreateMembersOutput struct {
	_ struct{} `type:"structure"`

	// A list of account ID and email address pairs of the AWS accounts that could
	// not be processed.
	UnprocessedAccounts []*Result `type:"list"`
}

// String returns the string representation
func (s CreateMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMembersOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *CreateMembersOutput) SetUnprocessedAccounts(v []*Result) *CreateMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

// A date filter for querying findings.
type DateFilter struct {
	_ struct{} `type:"structure"`

	// A date range for the date filter.
	DateRange *DateRange `type:"structure"`

	// An end date for the date filter.
	End *string `type:"string"`

	// A start date for the date filter.
	Start *string `type:"string"`
}

// String returns the string representation
func (s DateFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DateFilter) GoString() string {
	return s.String()
}

// SetDateRange sets the DateRange field's value.
func (s *DateFilter) SetDateRange(v *DateRange) *DateFilter {
	s.DateRange = v
	return s
}

// SetEnd sets the End field's value.
func (s *DateFilter) SetEnd(v string) *DateFilter {
	s.End = &v
	return s
}

// SetStart sets the Start field's value.
func (s *DateFilter) SetStart(v string) *DateFilter {
	s.Start = &v
	return s
}

// A date range for the date filter.
type DateRange struct {
	_ struct{} `type:"structure"`

	// A date range unit for the date filter.
	Unit *string `type:"string" enum:"DateRangeUnit"`

	// A date range value for the date filter.
	Value *int64 `type:"integer"`
}

// String returns the string representation
func (s DateRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DateRange) GoString() string {
	return s.String()
}

// SetUnit sets the Unit field's value.
func (s *DateRange) SetUnit(v string) *DateRange {
	s.Unit = &v
	return s
}

// SetValue sets the Value field's value.
func (s *DateRange) SetValue(v int64) *DateRange {
	s.Value = &v
	return s
}

type DeclineInvitationsInput struct {
	_ struct{} `type:"structure"`

	// A list of account IDs specifying accounts whose invitations to Security Hub
	// you want to decline.
	AccountIds []*string `type:"list"`
}

// String returns the string representation
func (s DeclineInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeclineInvitationsInput) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *DeclineInvitationsInput) SetAccountIds(v []*string) *DeclineInvitationsInput {
	s.AccountIds = v
	return s
}

type DeclineInvitationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of account ID and email address pairs of the AWS accounts that could
	// not be processed.
	UnprocessedAccounts []*Result `type:"list"`
}

// String returns the string representation
func (s DeclineInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeclineInvitationsOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *DeclineInvitationsOutput) SetUnprocessedAccounts(v []*Result) *DeclineInvitationsOutput {
	s.UnprocessedAccounts = v
	return s
}

type DeleteInsightInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the insight that you want to delete.
	//
	// InsightArn is a required field
	InsightArn *string `location:"uri" locationName:"InsightArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInsightInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInsightInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInsightInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInsightInput"}
	if s.InsightArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InsightArn"))
	}
	if s.InsightArn != nil && len(*s.InsightArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InsightArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInsightArn sets the InsightArn field's value.
func (s *DeleteInsightInput) SetInsightArn(v string) *DeleteInsightInput {
	s.InsightArn = &v
	return s
}

type DeleteInsightOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the insight that was deleted.
	//
	// InsightArn is a required field
	InsightArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInsightOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInsightOutput) GoString() string {
	return s.String()
}

// SetInsightArn sets the InsightArn field's value.
func (s *DeleteInsightOutput) SetInsightArn(v string) *DeleteInsightOutput {
	s.InsightArn = &v
	return s
}

type DeleteInvitationsInput struct {
	_ struct{} `type:"structure"`

	// A list of account IDs specifying accounts whose invitations to Security Hub
	// you want to delete.
	AccountIds []*string `type:"list"`
}

// String returns the string representation
func (s DeleteInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInvitationsInput) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *DeleteInvitationsInput) SetAccountIds(v []*string) *DeleteInvitationsInput {
	s.AccountIds = v
	return s
}

type DeleteInvitationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of account ID and email address pairs of the AWS accounts that could
	// not be processed.
	UnprocessedAccounts []*Result `type:"list"`
}

// String returns the string representation
func (s DeleteInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInvitationsOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *DeleteInvitationsOutput) SetUnprocessedAccounts(v []*Result) *DeleteInvitationsOutput {
	s.UnprocessedAccounts = v
	return s
}

type DeleteMembersInput struct {
	_ struct{} `type:"structure"`

	// A list of account IDs of the Security Hub member accounts that you want to
	// delete.
	AccountIds []*string `type:"list"`
}

// String returns the string representation
func (s DeleteMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMembersInput) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *DeleteMembersInput) SetAccountIds(v []*string) *DeleteMembersInput {
	s.AccountIds = v
	return s
}

type DeleteMembersOutput struct {
	_ struct{} `type:"structure"`

	// A list of account ID and email address pairs of the AWS accounts that could
	// not be processed.
	UnprocessedAccounts []*Result `type:"list"`
}

// String returns the string representation
func (s DeleteMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMembersOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *DeleteMembersOutput) SetUnprocessedAccounts(v []*Result) *DeleteMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

type DisableImportFindingsForProductInput struct {
	_ struct{} `type:"structure"`

	// The ARN of a resource that represents your subscription to a supported product.
	//
	// ProductSubscriptionArn is a required field
	ProductSubscriptionArn *string `location:"uri" locationName:"ProductSubscriptionArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableImportFindingsForProductInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableImportFindingsForProductInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableImportFindingsForProductInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableImportFindingsForProductInput"}
	if s.ProductSubscriptionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductSubscriptionArn"))
	}
	if s.ProductSubscriptionArn != nil && len(*s.ProductSubscriptionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProductSubscriptionArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProductSubscriptionArn sets the ProductSubscriptionArn field's value.
func (s *DisableImportFindingsForProductInput) SetProductSubscriptionArn(v string) *DisableImportFindingsForProductInput {
	s.ProductSubscriptionArn = &v
	return s
}

type DisableImportFindingsForProductOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableImportFindingsForProductOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableImportFindingsForProductOutput) GoString() string {
	return s.String()
}

type DisableSecurityHubInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableSecurityHubInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableSecurityHubInput) GoString() string {
	return s.String()
}

type DisableSecurityHubOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableSecurityHubOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableSecurityHubOutput) GoString() string {
	return s.String()
}

type DisassociateFromMasterAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateFromMasterAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateFromMasterAccountInput) GoString() string {
	return s.String()
}

type DisassociateFromMasterAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateFromMasterAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateFromMasterAccountOutput) GoString() string {
	return s.String()
}

type DisassociateMembersInput struct {
	_ struct{} `type:"structure"`

	// The account IDs of the member accounts that you want to disassociate from
	// the master account.
	AccountIds []*string `type:"list"`
}

// String returns the string representation
func (s DisassociateMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateMembersInput) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *DisassociateMembersInput) SetAccountIds(v []*string) *DisassociateMembersInput {
	s.AccountIds = v
	return s
}

type DisassociateMembersOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateMembersOutput) GoString() string {
	return s.String()
}

type EnableImportFindingsForProductInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the product that generates findings that you want to import into
	// Security Hub.
	//
	// ProductArn is a required field
	ProductArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EnableImportFindingsForProductInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableImportFindingsForProductInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableImportFindingsForProductInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableImportFindingsForProductInput"}
	if s.ProductArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProductArn sets the ProductArn field's value.
func (s *EnableImportFindingsForProductInput) SetProductArn(v string) *EnableImportFindingsForProductInput {
	s.ProductArn = &v
	return s
}

type EnableImportFindingsForProductOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of a resource that represents your subscription to the product that
	// generates the findings that you want to import into Security Hub.
	ProductSubscriptionArn *string `type:"string"`
}

// String returns the string representation
func (s EnableImportFindingsForProductOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableImportFindingsForProductOutput) GoString() string {
	return s.String()
}

// SetProductSubscriptionArn sets the ProductSubscriptionArn field's value.
func (s *EnableImportFindingsForProductOutput) SetProductSubscriptionArn(v string) *EnableImportFindingsForProductOutput {
	s.ProductSubscriptionArn = &v
	return s
}

type EnableSecurityHubInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableSecurityHubInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableSecurityHubInput) GoString() string {
	return s.String()
}

type EnableSecurityHubOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableSecurityHubOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableSecurityHubOutput) GoString() string {
	return s.String()
}

type GetEnabledStandardsInput struct {
	_ struct{} `type:"structure"`

	// Indicates the maximum number of items that you want in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// Paginates results. Set the value of this parameter to NULL on your first
	// call to the GetEnabledStandards operation. For subsequent calls to the operation,
	// fill nextToken in the request with the value of nextToken from the previous
	// response to continue listing data.
	NextToken *string `type:"string"`

	// The list of standards subscription ARNS that you want to list and describe.
	StandardsSubscriptionArns []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s GetEnabledStandardsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEnabledStandardsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEnabledStandardsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEnabledStandardsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.StandardsSubscriptionArns != nil && len(s.StandardsSubscriptionArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StandardsSubscriptionArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetEnabledStandardsInput) SetMaxResults(v int64) *GetEnabledStandardsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetEnabledStandardsInput) SetNextToken(v string) *GetEnabledStandardsInput {
	s.NextToken = &v
	return s
}

// SetStandardsSubscriptionArns sets the StandardsSubscriptionArns field's value.
func (s *GetEnabledStandardsInput) SetStandardsSubscriptionArns(v []*string) *GetEnabledStandardsInput {
	s.StandardsSubscriptionArns = v
	return s
}

type GetEnabledStandardsOutput struct {
	_ struct{} `type:"structure"`

	// The token that is required for pagination.
	NextToken *string `type:"string"`

	// The standards subscription details returned by the operation.
	StandardsSubscriptions []*StandardsSubscription `type:"list"`
}

// String returns the string representation
func (s GetEnabledStandardsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEnabledStandardsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetEnabledStandardsOutput) SetNextToken(v string) *GetEnabledStandardsOutput {
	s.NextToken = &v
	return s
}

// SetStandardsSubscriptions sets the StandardsSubscriptions field's value.
func (s *GetEnabledStandardsOutput) SetStandardsSubscriptions(v []*StandardsSubscription) *GetEnabledStandardsOutput {
	s.StandardsSubscriptions = v
	return s
}

type GetFindingsInput struct {
	_ struct{} `type:"structure"`

	// A collection of attributes that is use for querying findings.
	Filters *AwsSecurityFindingFilters `type:"structure"`

	// Indicates the maximum number of items that you want in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// Paginates results. Set the value of this parameter to NULL on your first
	// call to the GetFindings operation. For subsequent calls to the operation,
	// fill nextToken in the request with the value of nextToken from the previous
	// response to continue listing data.
	NextToken *string `type:"string"`

	// A collection of attributes used for sorting findings.
	SortCriteria []*SortCriterion `type:"list"`
}

// String returns the string representation
func (s GetFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFindingsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *GetFindingsInput) SetFilters(v *AwsSecurityFindingFilters) *GetFindingsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetFindingsInput) SetMaxResults(v int64) *GetFindingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetFindingsInput) SetNextToken(v string) *GetFindingsInput {
	s.NextToken = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *GetFindingsInput) SetSortCriteria(v []*SortCriterion) *GetFindingsInput {
	s.SortCriteria = v
	return s
}

type GetFindingsOutput struct {
	_ struct{} `type:"structure"`

	// Findings details returned by the operation.
	//
	// Findings is a required field
	Findings []*AwsSecurityFinding `type:"list" required:"true"`

	// The token that is required for pagination.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFindingsOutput) GoString() string {
	return s.String()
}

// SetFindings sets the Findings field's value.
func (s *GetFindingsOutput) SetFindings(v []*AwsSecurityFinding) *GetFindingsOutput {
	s.Findings = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetFindingsOutput) SetNextToken(v string) *GetFindingsOutput {
	s.NextToken = &v
	return s
}

type GetInsightResultsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the insight whose results you want to see.
	//
	// InsightArn is a required field
	InsightArn *string `location:"uri" locationName:"InsightArn" type:"string" required:"true"`
}

// String returns the string representation
func (s GetInsightResultsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInsightResultsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInsightResultsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInsightResultsInput"}
	if s.InsightArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InsightArn"))
	}
	if s.InsightArn != nil && len(*s.InsightArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InsightArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInsightArn sets the InsightArn field's value.
func (s *GetInsightResultsInput) SetInsightArn(v string) *GetInsightResultsInput {
	s.InsightArn = &v
	return s
}

type GetInsightResultsOutput struct {
	_ struct{} `type:"structure"`

	// The insight results returned by the operation.
	//
	// InsightResults is a required field
	InsightResults *InsightResults `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetInsightResultsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInsightResultsOutput) GoString() string {
	return s.String()
}

// SetInsightResults sets the InsightResults field's value.
func (s *GetInsightResultsOutput) SetInsightResults(v *InsightResults) *GetInsightResultsOutput {
	s.InsightResults = v
	return s
}

type GetInsightsInput struct {
	_ struct{} `type:"structure"`

	// The ARNS of the insights that you want to describe.
	InsightArns []*string `type:"list"`

	// Indicates the maximum number of items that you want in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// Paginates results. Set the value of this parameter to NULL on your first
	// call to the GetInsights operation. For subsequent calls to the operation,
	// fill nextToken in the request with the value of nextToken from the previous
	// response to continue listing data.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetInsightsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInsightsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInsightsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInsightsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInsightArns sets the InsightArns field's value.
func (s *GetInsightsInput) SetInsightArns(v []*string) *GetInsightsInput {
	s.InsightArns = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetInsightsInput) SetMaxResults(v int64) *GetInsightsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetInsightsInput) SetNextToken(v string) *GetInsightsInput {
	s.NextToken = &v
	return s
}

type GetInsightsOutput struct {
	_ struct{} `type:"structure"`

	// The insights returned by the operation.
	//
	// Insights is a required field
	Insights []*Insight `type:"list" required:"true"`

	// The token that is required for pagination.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetInsightsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInsightsOutput) GoString() string {
	return s.String()
}

// SetInsights sets the Insights field's value.
func (s *GetInsightsOutput) SetInsights(v []*Insight) *GetInsightsOutput {
	s.Insights = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetInsightsOutput) SetNextToken(v string) *GetInsightsOutput {
	s.NextToken = &v
	return s
}

type GetInvitationsCountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetInvitationsCountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInvitationsCountInput) GoString() string {
	return s.String()
}

type GetInvitationsCountOutput struct {
	_ struct{} `type:"structure"`

	// The number of all membership invitations sent to this Security Hub member
	// account, not including the currently accepted invitation.
	InvitationsCount *int64 `type:"integer"`
}

// String returns the string representation
func (s GetInvitationsCountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInvitationsCountOutput) GoString() string {
	return s.String()
}

// SetInvitationsCount sets the InvitationsCount field's value.
func (s *GetInvitationsCountOutput) SetInvitationsCount(v int64) *GetInvitationsCountOutput {
	s.InvitationsCount = &v
	return s
}

type GetMasterAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetMasterAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMasterAccountInput) GoString() string {
	return s.String()
}

type GetMasterAccountOutput struct {
	_ struct{} `type:"structure"`

	// A list of details about the Security Hub master account for the current member
	// account.
	Master *Invitation `type:"structure"`
}

// String returns the string representation
func (s GetMasterAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMasterAccountOutput) GoString() string {
	return s.String()
}

// SetMaster sets the Master field's value.
func (s *GetMasterAccountOutput) SetMaster(v *Invitation) *GetMasterAccountOutput {
	s.Master = v
	return s
}

type GetMembersInput struct {
	_ struct{} `type:"structure"`

	// A list of account IDs for the Security Hub member accounts on which you want
	// to return the details.
	//
	// AccountIds is a required field
	AccountIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s GetMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMembersInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *GetMembersInput) SetAccountIds(v []*string) *GetMembersInput {
	s.AccountIds = v
	return s
}

type GetMembersOutput struct {
	_ struct{} `type:"structure"`

	// A list of details about the Security Hub member accounts.
	Members []*Member `type:"list"`

	// A list of account ID and email address pairs of the AWS accounts that could
	// not be processed.
	UnprocessedAccounts []*Result `type:"list"`
}

// String returns the string representation
func (s GetMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMembersOutput) GoString() string {
	return s.String()
}

// SetMembers sets the Members field's value.
func (s *GetMembersOutput) SetMembers(v []*Member) *GetMembersOutput {
	s.Members = v
	return s
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *GetMembersOutput) SetUnprocessedAccounts(v []*Result) *GetMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

// Includes details of the list of the findings that cannot be imported.
type ImportFindingsError struct {
	_ struct{} `type:"structure"`

	// The code of the error made during the BatchImportFindings operation.
	//
	// ErrorCode is a required field
	ErrorCode *string `type:"string" required:"true"`

	// The message of the error made during the BatchImportFindings operation.
	//
	// ErrorMessage is a required field
	ErrorMessage *string `type:"string" required:"true"`

	// The id of the error made during the BatchImportFindings operation.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ImportFindingsError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportFindingsError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ImportFindingsError) SetErrorCode(v string) *ImportFindingsError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ImportFindingsError) SetErrorMessage(v string) *ImportFindingsError {
	s.ErrorMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *ImportFindingsError) SetId(v string) *ImportFindingsError {
	s.Id = &v
	return s
}

// Contains information about a Security Hub insight.
type Insight struct {
	_ struct{} `type:"structure"`

	// A collection of attributes that are applied to all active Security Hub-aggregated
	// findings and that result in a subset of findings that are included in this
	// insight.
	//
	// Filters is a required field
	Filters *AwsSecurityFindingFilters `type:"structure" required:"true"`

	// The attribute by which the insight's findings are grouped. This attribute
	// is used as a findings aggregator for the purposes of viewing and managing
	// multiple related findings under a single operand.
	//
	// GroupByAttribute is a required field
	GroupByAttribute *string `type:"string" required:"true"`

	// The ARN of a Security Hub insight.
	//
	// InsightArn is a required field
	InsightArn *string `type:"string" required:"true"`

	// The name of a Security Hub insight.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Insight) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Insight) GoString() string {
	return s.String()
}

// SetFilters sets the Filters field's value.
func (s *Insight) SetFilters(v *AwsSecurityFindingFilters) *Insight {
	s.Filters = v
	return s
}

// SetGroupByAttribute sets the GroupByAttribute field's value.
func (s *Insight) SetGroupByAttribute(v string) *Insight {
	s.GroupByAttribute = &v
	return s
}

// SetInsightArn sets the InsightArn field's value.
func (s *Insight) SetInsightArn(v string) *Insight {
	s.InsightArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *Insight) SetName(v string) *Insight {
	s.Name = &v
	return s
}

// The insight result values returned by the GetInsightResults operation.
type InsightResultValue struct {
	_ struct{} `type:"structure"`

	// The number of findings returned for each GroupByAttributeValue.
	//
	// Count is a required field
	Count *int64 `type:"integer" required:"true"`

	// The value of the attribute by which the findings are grouped for the insight's
	// whose results are returned by the GetInsightResults operation.
	//
	// GroupByAttributeValue is a required field
	GroupByAttributeValue *string `type:"string" required:"true"`
}

// String returns the string representation
func (s InsightResultValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InsightResultValue) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *InsightResultValue) SetCount(v int64) *InsightResultValue {
	s.Count = &v
	return s
}

// SetGroupByAttributeValue sets the GroupByAttributeValue field's value.
func (s *InsightResultValue) SetGroupByAttributeValue(v string) *InsightResultValue {
	s.GroupByAttributeValue = &v
	return s
}

// The insight results returned by the GetInsightResults operation.
type InsightResults struct {
	_ struct{} `type:"structure"`

	// The attribute by which the findings are grouped for the insight's whose results
	// are returned by the GetInsightResults operation.
	//
	// GroupByAttribute is a required field
	GroupByAttribute *string `type:"string" required:"true"`

	// The ARN of the insight whose results are returned by the GetInsightResults
	// operation.
	//
	// InsightArn is a required field
	InsightArn *string `type:"string" required:"true"`

	// The list of insight result values returned by the GetInsightResults operation.
	//
	// ResultValues is a required field
	ResultValues []*InsightResultValue `type:"list" required:"true"`
}

// String returns the string representation
func (s InsightResults) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InsightResults) GoString() string {
	return s.String()
}

// SetGroupByAttribute sets the GroupByAttribute field's value.
func (s *InsightResults) SetGroupByAttribute(v string) *InsightResults {
	s.GroupByAttribute = &v
	return s
}

// SetInsightArn sets the InsightArn field's value.
func (s *InsightResults) SetInsightArn(v string) *InsightResults {
	s.InsightArn = &v
	return s
}

// SetResultValues sets the ResultValues field's value.
func (s *InsightResults) SetResultValues(v []*InsightResultValue) *InsightResults {
	s.ResultValues = v
	return s
}

// The details of an invitation sent to an AWS account by the Security Hub master
// account.
type Invitation struct {
	_ struct{} `type:"structure"`

	// The account ID of the master Security Hub account who sent the invitation.
	AccountId *string `type:"string"`

	// The ID of the invitation sent by the master Security Hub account.
	InvitationId *string `type:"string"`

	// The timestamp of when the invitation was sent.
	InvitedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The current relationship status between the inviter and invitee accounts.
	MemberStatus *string `type:"string"`
}

// String returns the string representation
func (s Invitation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Invitation) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Invitation) SetAccountId(v string) *Invitation {
	s.AccountId = &v
	return s
}

// SetInvitationId sets the InvitationId field's value.
func (s *Invitation) SetInvitationId(v string) *Invitation {
	s.InvitationId = &v
	return s
}

// SetInvitedAt sets the InvitedAt field's value.
func (s *Invitation) SetInvitedAt(v time.Time) *Invitation {
	s.InvitedAt = &v
	return s
}

// SetMemberStatus sets the MemberStatus field's value.
func (s *Invitation) SetMemberStatus(v string) *Invitation {
	s.MemberStatus = &v
	return s
}

type InviteMembersInput struct {
	_ struct{} `type:"structure"`

	// A list of IDs of the AWS accounts that you want to invite to Security Hub
	// as members.
	AccountIds []*string `type:"list"`
}

// String returns the string representation
func (s InviteMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InviteMembersInput) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *InviteMembersInput) SetAccountIds(v []*string) *InviteMembersInput {
	s.AccountIds = v
	return s
}

type InviteMembersOutput struct {
	_ struct{} `type:"structure"`

	// A list of account ID and email address pairs of the AWS accounts that could
	// not be processed.
	UnprocessedAccounts []*Result `type:"list"`
}

// String returns the string representation
func (s InviteMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InviteMembersOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *InviteMembersOutput) SetUnprocessedAccounts(v []*Result) *InviteMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

// The IP filter for querying findings.>
type IpFilter struct {
	_ struct{} `type:"structure"`

	// Finding's CIDR value.
	Cidr *string `type:"string"`
}

// String returns the string representation
func (s IpFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpFilter) GoString() string {
	return s.String()
}

// SetCidr sets the Cidr field's value.
func (s *IpFilter) SetCidr(v string) *IpFilter {
	s.Cidr = &v
	return s
}

// A keyword filter for querying findings.
type KeywordFilter struct {
	_ struct{} `type:"structure"`

	// A value for the keyword.
	Value *string `type:"string"`
}

// String returns the string representation
func (s KeywordFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeywordFilter) GoString() string {
	return s.String()
}

// SetValue sets the Value field's value.
func (s *KeywordFilter) SetValue(v string) *KeywordFilter {
	s.Value = &v
	return s
}

type ListEnabledProductsForImportInput struct {
	_ struct{} `type:"structure"`

	// Indicates the maximum number of items that you want in the response.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// Paginates results. Set the value of this parameter to NULL on your first
	// call to the ListEnabledProductsForImport operation. For subsequent calls
	// to the operation, fill nextToken in the request with the value of NextToken
	// from the previous response to continue listing data.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListEnabledProductsForImportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEnabledProductsForImportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEnabledProductsForImportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEnabledProductsForImportInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEnabledProductsForImportInput) SetMaxResults(v int64) *ListEnabledProductsForImportInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnabledProductsForImportInput) SetNextToken(v string) *ListEnabledProductsForImportInput {
	s.NextToken = &v
	return s
}

type ListEnabledProductsForImportOutput struct {
	_ struct{} `type:"structure"`

	// The token that is required for pagination.
	NextToken *string `type:"string"`

	// A list of ARNs for the resources that represent your subscriptions to products.
	ProductSubscriptions []*string `type:"list"`
}

// String returns the string representation
func (s ListEnabledProductsForImportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEnabledProductsForImportOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnabledProductsForImportOutput) SetNextToken(v string) *ListEnabledProductsForImportOutput {
	s.NextToken = &v
	return s
}

// SetProductSubscriptions sets the ProductSubscriptions field's value.
func (s *ListEnabledProductsForImportOutput) SetProductSubscriptions(v []*string) *ListEnabledProductsForImportOutput {
	s.ProductSubscriptions = v
	return s
}

type ListInvitationsInput struct {
	_ struct{} `type:"structure"`

	// Indicates the maximum number of items that you want in the response.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// Paginates results. Set the value of this parameter to NULL on your first
	// call to the ListInvitations operation. For subsequent calls to the operation,
	// fill nextToken in the request with the value of NextToken from the previous
	// response to continue listing data.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInvitationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInvitationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInvitationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInvitationsInput) SetMaxResults(v int64) *ListInvitationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInvitationsInput) SetNextToken(v string) *ListInvitationsInput {
	s.NextToken = &v
	return s
}

type ListInvitationsOutput struct {
	_ struct{} `type:"structure"`

	// The details of the invitations returned by the operation.
	Invitations []*Invitation `type:"list"`

	// The token that is required for pagination.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInvitationsOutput) GoString() string {
	return s.String()
}

// SetInvitations sets the Invitations field's value.
func (s *ListInvitationsOutput) SetInvitations(v []*Invitation) *ListInvitationsOutput {
	s.Invitations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInvitationsOutput) SetNextToken(v string) *ListInvitationsOutput {
	s.NextToken = &v
	return s
}

type ListMembersInput struct {
	_ struct{} `type:"structure"`

	// Indicates the maximum number of items that you want in the response.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// Paginates results. Set the value of this parameter to NULL on your first
	// call to the ListMembers operation. For subsequent calls to the operation,
	// fill nextToken in the request with the value of NextToken from the previous
	// response to continue listing data.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// Specifies what member accounts the response includes based on their relationship
	// status with the master account. The default value is TRUE. If onlyAssociated
	// is set to TRUE, the response includes member accounts whose relationship
	// status with the master is set to ENABLED or DISABLED. If onlyAssociated is
	// set to FALSE, the response includes all existing member accounts.
	OnlyAssociated *bool `location:"querystring" locationName:"OnlyAssociated" type:"boolean"`
}

// String returns the string representation
func (s ListMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMembersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMembersInput) SetMaxResults(v int64) *ListMembersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMembersInput) SetNextToken(v string) *ListMembersInput {
	s.NextToken = &v
	return s
}

// SetOnlyAssociated sets the OnlyAssociated field's value.
func (s *ListMembersInput) SetOnlyAssociated(v bool) *ListMembersInput {
	s.OnlyAssociated = &v
	return s
}

type ListMembersOutput struct {
	_ struct{} `type:"structure"`

	// Member details returned by the operation.
	Members []*Member `type:"list"`

	// The token that is required for pagination.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMembersOutput) GoString() string {
	return s.String()
}

// SetMembers sets the Members field's value.
func (s *ListMembersOutput) SetMembers(v []*Member) *ListMembersOutput {
	s.Members = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMembersOutput) SetNextToken(v string) *ListMembersOutput {
	s.NextToken = &v
	return s
}

// A list of malware related to a finding.
type Malware struct {
	_ struct{} `type:"structure"`

	// The name of the malware that was observed.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The filesystem path of the malware that was observed.
	Path *string `type:"string"`

	// The state of the malware that was observed.
	State *string `type:"string" enum:"MalwareState"`

	// The type of the malware that was observed.
	Type *string `type:"string" enum:"MalwareType"`
}

// String returns the string representation
func (s Malware) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Malware) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Malware) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Malware"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Malware) SetName(v string) *Malware {
	s.Name = &v
	return s
}

// SetPath sets the Path field's value.
func (s *Malware) SetPath(v string) *Malware {
	s.Path = &v
	return s
}

// SetState sets the State field's value.
func (s *Malware) SetState(v string) *Malware {
	s.State = &v
	return s
}

// SetType sets the Type field's value.
func (s *Malware) SetType(v string) *Malware {
	s.Type = &v
	return s
}

// The map filter for querying findings.
type MapFilter struct {
	_ struct{} `type:"structure"`

	// Represents the condition to be applied to a key value when querying for findings
	// with a map filter.
	Comparison *string `type:"string" enum:"MapFilterComparison"`

	// The key of the map filter.
	Key *string `type:"string"`

	// The value for the key in the map filter.
	Value *string `type:"string"`
}

// String returns the string representation
func (s MapFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MapFilter) GoString() string {
	return s.String()
}

// SetComparison sets the Comparison field's value.
func (s *MapFilter) SetComparison(v string) *MapFilter {
	s.Comparison = &v
	return s
}

// SetKey sets the Key field's value.
func (s *MapFilter) SetKey(v string) *MapFilter {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MapFilter) SetValue(v string) *MapFilter {
	s.Value = &v
	return s
}

// The details for a Security Hub member account.
type Member struct {
	_ struct{} `type:"structure"`

	// The AWS account ID of a Security Hub member account.
	AccountId *string `type:"string"`

	// The email of a Security Hub member account.
	Email *string `type:"string"`

	// Time stamp at which the member account was invited to Security Hub.
	InvitedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The AWS account ID of the master Security Hub account to this member account.
	MasterId *string `type:"string"`

	// The status of the relationship between the member account and its master
	// account.
	MemberStatus *string `type:"string"`

	// Time stamp at which this member account was updated.
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s Member) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Member) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Member) SetAccountId(v string) *Member {
	s.AccountId = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *Member) SetEmail(v string) *Member {
	s.Email = &v
	return s
}

// SetInvitedAt sets the InvitedAt field's value.
func (s *Member) SetInvitedAt(v time.Time) *Member {
	s.InvitedAt = &v
	return s
}

// SetMasterId sets the MasterId field's value.
func (s *Member) SetMasterId(v string) *Member {
	s.MasterId = &v
	return s
}

// SetMemberStatus sets the MemberStatus field's value.
func (s *Member) SetMemberStatus(v string) *Member {
	s.MemberStatus = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Member) SetUpdatedAt(v time.Time) *Member {
	s.UpdatedAt = &v
	return s
}

// The details of network-related information about a finding.
type Network struct {
	_ struct{} `type:"structure"`

	// The destination domain of network-related information about a finding.
	DestinationDomain *string `type:"string"`

	// The destination IPv4 address of network-related information about a finding.
	DestinationIpV4 *string `type:"string"`

	// The destination IPv6 address of network-related information about a finding.
	DestinationIpV6 *string `type:"string"`

	// The destination port of network-related information about a finding.
	DestinationPort *int64 `type:"integer"`

	// Indicates the direction of network traffic associated with a finding.
	Direction *string `type:"string" enum:"NetworkDirection"`

	// The protocol of network-related information about a finding.
	Protocol *string `type:"string"`

	// The source domain of network-related information about a finding.
	SourceDomain *string `type:"string"`

	// The source IPv4 address of network-related information about a finding.
	SourceIpV4 *string `type:"string"`

	// The source IPv6 address of network-related information about a finding.
	SourceIpV6 *string `type:"string"`

	// The source media access control (MAC) address of network-related information
	// about a finding.
	SourceMac *string `type:"string"`

	// The source port of network-related information about a finding.
	SourcePort *int64 `type:"integer"`
}

// String returns the string representation
func (s Network) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Network) GoString() string {
	return s.String()
}

// SetDestinationDomain sets the DestinationDomain field's value.
func (s *Network) SetDestinationDomain(v string) *Network {
	s.DestinationDomain = &v
	return s
}

// SetDestinationIpV4 sets the DestinationIpV4 field's value.
func (s *Network) SetDestinationIpV4(v string) *Network {
	s.DestinationIpV4 = &v
	return s
}

// SetDestinationIpV6 sets the DestinationIpV6 field's value.
func (s *Network) SetDestinationIpV6(v string) *Network {
	s.DestinationIpV6 = &v
	return s
}

// SetDestinationPort sets the DestinationPort field's value.
func (s *Network) SetDestinationPort(v int64) *Network {
	s.DestinationPort = &v
	return s
}

// SetDirection sets the Direction field's value.
func (s *Network) SetDirection(v string) *Network {
	s.Direction = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *Network) SetProtocol(v string) *Network {
	s.Protocol = &v
	return s
}

// SetSourceDomain sets the SourceDomain field's value.
func (s *Network) SetSourceDomain(v string) *Network {
	s.SourceDomain = &v
	return s
}

// SetSourceIpV4 sets the SourceIpV4 field's value.
func (s *Network) SetSourceIpV4(v string) *Network {
	s.SourceIpV4 = &v
	return s
}

// SetSourceIpV6 sets the SourceIpV6 field's value.
func (s *Network) SetSourceIpV6(v string) *Network {
	s.SourceIpV6 = &v
	return s
}

// SetSourceMac sets the SourceMac field's value.
func (s *Network) SetSourceMac(v string) *Network {
	s.SourceMac = &v
	return s
}

// SetSourcePort sets the SourcePort field's value.
func (s *Network) SetSourcePort(v int64) *Network {
	s.SourcePort = &v
	return s
}

// A user-defined note added to a finding.
type Note struct {
	_ struct{} `type:"structure"`

	// The text of a note.
	//
	// Text is a required field
	Text *string `type:"string" required:"true"`

	// The timestamp of when the note was updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *string `type:"string" required:"true"`

	// The principal that created a note.
	//
	// UpdatedBy is a required field
	UpdatedBy *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Note) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Note) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Note) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Note"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.UpdatedAt == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdatedAt"))
	}
	if s.UpdatedBy == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdatedBy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *Note) SetText(v string) *Note {
	s.Text = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Note) SetUpdatedAt(v string) *Note {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *Note) SetUpdatedBy(v string) *Note {
	s.UpdatedBy = &v
	return s
}

// The updated note.
type NoteUpdate struct {
	_ struct{} `type:"structure"`

	// The updated note text.
	//
	// Text is a required field
	Text *string `type:"string" required:"true"`

	// The principal that updated the note.
	//
	// UpdatedBy is a required field
	UpdatedBy *string `type:"string" required:"true"`
}

// String returns the string representation
func (s NoteUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoteUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NoteUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NoteUpdate"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.UpdatedBy == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdatedBy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *NoteUpdate) SetText(v string) *NoteUpdate {
	s.Text = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *NoteUpdate) SetUpdatedBy(v string) *NoteUpdate {
	s.UpdatedBy = &v
	return s
}

// A number filter for querying findings.
type NumberFilter struct {
	_ struct{} `type:"structure"`

	// Represents the "equal to" condition to be applied to a single field when
	// querying for findings.
	Eq *float64 `type:"double"`

	// Represents the "greater than equal" condition to be applied to a single field
	// when querying for findings.
	Gte *float64 `type:"double"`

	// Represents the "less than equal" condition to be applied to a single field
	// when querying for findings.
	Lte *float64 `type:"double"`
}

// String returns the string representation
func (s NumberFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NumberFilter) GoString() string {
	return s.String()
}

// SetEq sets the Eq field's value.
func (s *NumberFilter) SetEq(v float64) *NumberFilter {
	s.Eq = &v
	return s
}

// SetGte sets the Gte field's value.
func (s *NumberFilter) SetGte(v float64) *NumberFilter {
	s.Gte = &v
	return s
}

// SetLte sets the Lte field's value.
func (s *NumberFilter) SetLte(v float64) *NumberFilter {
	s.Lte = &v
	return s
}

// The details of process-related information about a finding.
type ProcessDetails struct {
	_ struct{} `type:"structure"`

	// The date/time that the process was launched.
	LaunchedAt *string `type:"string"`

	// The name of the process.
	Name *string `type:"string"`

	// The parent process ID.
	ParentPid *int64 `type:"integer"`

	// The path to the process executable.
	Path *string `type:"string"`

	// The process ID.
	Pid *int64 `type:"integer"`

	// The date/time that the process was terminated.
	TerminatedAt *string `type:"string"`
}

// String returns the string representation
func (s ProcessDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProcessDetails) GoString() string {
	return s.String()
}

// SetLaunchedAt sets the LaunchedAt field's value.
func (s *ProcessDetails) SetLaunchedAt(v string) *ProcessDetails {
	s.LaunchedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *ProcessDetails) SetName(v string) *ProcessDetails {
	s.Name = &v
	return s
}

// SetParentPid sets the ParentPid field's value.
func (s *ProcessDetails) SetParentPid(v int64) *ProcessDetails {
	s.ParentPid = &v
	return s
}

// SetPath sets the Path field's value.
func (s *ProcessDetails) SetPath(v string) *ProcessDetails {
	s.Path = &v
	return s
}

// SetPid sets the Pid field's value.
func (s *ProcessDetails) SetPid(v int64) *ProcessDetails {
	s.Pid = &v
	return s
}

// SetTerminatedAt sets the TerminatedAt field's value.
func (s *ProcessDetails) SetTerminatedAt(v string) *ProcessDetails {
	s.TerminatedAt = &v
	return s
}

// Provides a recommendation on how to remediate the issue identified within
// a finding.
type Recommendation struct {
	_ struct{} `type:"structure"`

	// The recommendation of what to do about the issue described in a finding.
	Text *string `type:"string"`

	// A URL to link to general remediation information for the finding type of
	// a finding.
	Url *string `type:"string"`
}

// String returns the string representation
func (s Recommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Recommendation) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *Recommendation) SetText(v string) *Recommendation {
	s.Text = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *Recommendation) SetUrl(v string) *Recommendation {
	s.Url = &v
	return s
}

// Related finding's details.
type RelatedFinding struct {
	_ struct{} `type:"structure"`

	// The solution-generated identifier for a related finding.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The ARN of the solution that generated a related finding.
	//
	// ProductArn is a required field
	ProductArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RelatedFinding) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RelatedFinding) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RelatedFinding) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RelatedFinding"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.ProductArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *RelatedFinding) SetId(v string) *RelatedFinding {
	s.Id = &v
	return s
}

// SetProductArn sets the ProductArn field's value.
func (s *RelatedFinding) SetProductArn(v string) *RelatedFinding {
	s.ProductArn = &v
	return s
}

// The remediation options for a finding.
type Remediation struct {
	_ struct{} `type:"structure"`

	// Provides a recommendation on how to remediate the issue identified within
	// a finding.
	Recommendation *Recommendation `type:"structure"`
}

// String returns the string representation
func (s Remediation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Remediation) GoString() string {
	return s.String()
}

// SetRecommendation sets the Recommendation field's value.
func (s *Remediation) SetRecommendation(v *Recommendation) *Remediation {
	s.Recommendation = v
	return s
}

// A resource data type that describes a resource to which the finding refers.
type Resource struct {
	_ struct{} `type:"structure"`

	// Provides additional details about the resource.
	Details *ResourceDetails `type:"structure"`

	// The canonical identifier for the given resource type.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The canonical AWS partition name to which the region is assigned.
	Partition *string `type:"string" enum:"Partition"`

	// The canonical AWS external region name where this resource is located.
	Region *string `type:"string"`

	// A list of AWS tags associated with a resource at the time the finding was
	// processed.
	Tags map[string]*string `type:"map"`

	// Specifies the type of the resource for which details are provided.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Resource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Resource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Resource"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetails sets the Details field's value.
func (s *Resource) SetDetails(v *ResourceDetails) *Resource {
	s.Details = v
	return s
}

// SetId sets the Id field's value.
func (s *Resource) SetId(v string) *Resource {
	s.Id = &v
	return s
}

// SetPartition sets the Partition field's value.
func (s *Resource) SetPartition(v string) *Resource {
	s.Partition = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Resource) SetRegion(v string) *Resource {
	s.Region = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Resource) SetTags(v map[string]*string) *Resource {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *Resource) SetType(v string) *Resource {
	s.Type = &v
	return s
}

// Provides additional details about the resource.
type ResourceDetails struct {
	_ struct{} `type:"structure"`

	// The details of an AWS EC2 instance.
	AwsEc2Instance *AwsEc2InstanceDetails `type:"structure"`

	// AWS IAM access key details related to a finding.
	AwsIamAccessKey *AwsIamAccessKeyDetails `type:"structure"`

	// The details of an AWS S3 Bucket.
	AwsS3Bucket *AwsS3BucketDetails `type:"structure"`

	// Container details related to a finding.
	Container *ContainerDetails `type:"structure"`

	// The details of a resource that does not have a specific sub-field for the
	// resource type defined.
	Other map[string]*string `type:"map"`
}

// String returns the string representation
func (s ResourceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceDetails) GoString() string {
	return s.String()
}

// SetAwsEc2Instance sets the AwsEc2Instance field's value.
func (s *ResourceDetails) SetAwsEc2Instance(v *AwsEc2InstanceDetails) *ResourceDetails {
	s.AwsEc2Instance = v
	return s
}

// SetAwsIamAccessKey sets the AwsIamAccessKey field's value.
func (s *ResourceDetails) SetAwsIamAccessKey(v *AwsIamAccessKeyDetails) *ResourceDetails {
	s.AwsIamAccessKey = v
	return s
}

// SetAwsS3Bucket sets the AwsS3Bucket field's value.
func (s *ResourceDetails) SetAwsS3Bucket(v *AwsS3BucketDetails) *ResourceDetails {
	s.AwsS3Bucket = v
	return s
}

// SetContainer sets the Container field's value.
func (s *ResourceDetails) SetContainer(v *ContainerDetails) *ResourceDetails {
	s.Container = v
	return s
}

// SetOther sets the Other field's value.
func (s *ResourceDetails) SetOther(v map[string]*string) *ResourceDetails {
	s.Other = v
	return s
}

// The account details that could not be processed.
type Result struct {
	_ struct{} `type:"structure"`

	// An ID of the AWS account that could not be processed.
	AccountId *string `type:"string"`

	// The reason for why an account could not be processed.
	ProcessingResult *string `type:"string"`
}

// String returns the string representation
func (s Result) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Result) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Result) SetAccountId(v string) *Result {
	s.AccountId = &v
	return s
}

// SetProcessingResult sets the ProcessingResult field's value.
func (s *Result) SetProcessingResult(v string) *Result {
	s.ProcessingResult = &v
	return s
}

// A finding's severity.
type Severity struct {
	_ struct{} `type:"structure"`

	// The normalized severity of a finding.
	//
	// Normalized is a required field
	Normalized *int64 `type:"integer" required:"true"`

	// The native severity as defined by the security findings provider's solution
	// that generated the finding.
	Product *float64 `type:"double"`
}

// String returns the string representation
func (s Severity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Severity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Severity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Severity"}
	if s.Normalized == nil {
		invalidParams.Add(request.NewErrParamRequired("Normalized"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNormalized sets the Normalized field's value.
func (s *Severity) SetNormalized(v int64) *Severity {
	s.Normalized = &v
	return s
}

// SetProduct sets the Product field's value.
func (s *Severity) SetProduct(v float64) *Severity {
	s.Product = &v
	return s
}

// A collection of attributes used for sorting findings.
type SortCriterion struct {
	_ struct{} `type:"structure"`

	// The finding attribute used for sorting findings.
	Field *string `type:"string"`

	// The order used for sorting findings.
	SortOrder *string `type:"string" enum:"SortOrder"`
}

// String returns the string representation
func (s SortCriterion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SortCriterion) GoString() string {
	return s.String()
}

// SetField sets the Field field's value.
func (s *SortCriterion) SetField(v string) *SortCriterion {
	s.Field = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *SortCriterion) SetSortOrder(v string) *SortCriterion {
	s.SortOrder = &v
	return s
}

// A resource that represents your subscription to a supported standard.
type StandardsSubscription struct {
	_ struct{} `type:"structure"`

	// The ARN of a standard.
	//
	// In this release, Security Hub only supports the CIS AWS Foundations standard.
	//
	// Its ARN is arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0.
	//
	// StandardsArn is a required field
	StandardsArn *string `type:"string" required:"true"`

	// StandardsInput is a required field
	StandardsInput map[string]*string `type:"map" required:"true"`

	// The standard's status.
	//
	// StandardsStatus is a required field
	StandardsStatus *string `type:"string" required:"true" enum:"StandardsStatus"`

	// The ARN of a resource that represents your subscription to a supported standard.
	//
	// StandardsSubscriptionArn is a required field
	StandardsSubscriptionArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StandardsSubscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StandardsSubscription) GoString() string {
	return s.String()
}

// SetStandardsArn sets the StandardsArn field's value.
func (s *StandardsSubscription) SetStandardsArn(v string) *StandardsSubscription {
	s.StandardsArn = &v
	return s
}

// SetStandardsInput sets the StandardsInput field's value.
func (s *StandardsSubscription) SetStandardsInput(v map[string]*string) *StandardsSubscription {
	s.StandardsInput = v
	return s
}

// SetStandardsStatus sets the StandardsStatus field's value.
func (s *StandardsSubscription) SetStandardsStatus(v string) *StandardsSubscription {
	s.StandardsStatus = &v
	return s
}

// SetStandardsSubscriptionArn sets the StandardsSubscriptionArn field's value.
func (s *StandardsSubscription) SetStandardsSubscriptionArn(v string) *StandardsSubscription {
	s.StandardsSubscriptionArn = &v
	return s
}

// The standard that you want to enable.
type StandardsSubscriptionRequest struct {
	_ struct{} `type:"structure"`

	// The ARN of the standard that you want to enable.
	//
	// In this release, Security Hub only supports the CIS AWS Foundations standard.
	//
	// Its ARN is arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0.
	//
	// StandardsArn is a required field
	StandardsArn *string `type:"string" required:"true"`

	StandardsInput map[string]*string `type:"map"`
}

// String returns the string representation
func (s StandardsSubscriptionRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StandardsSubscriptionRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StandardsSubscriptionRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StandardsSubscriptionRequest"}
	if s.StandardsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StandardsArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStandardsArn sets the StandardsArn field's value.
func (s *StandardsSubscriptionRequest) SetStandardsArn(v string) *StandardsSubscriptionRequest {
	s.StandardsArn = &v
	return s
}

// SetStandardsInput sets the StandardsInput field's value.
func (s *StandardsSubscriptionRequest) SetStandardsInput(v map[string]*string) *StandardsSubscriptionRequest {
	s.StandardsInput = v
	return s
}

// A string filter for querying findings.
type StringFilter struct {
	_ struct{} `type:"structure"`

	// Represents the condition to be applied to a string value when querying for
	// findings.
	Comparison *string `type:"string" enum:"StringFilterComparison"`

	// The string filter value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s StringFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StringFilter) GoString() string {
	return s.String()
}

// SetComparison sets the Comparison field's value.
func (s *StringFilter) SetComparison(v string) *StringFilter {
	s.Comparison = &v
	return s
}

// SetValue sets the Value field's value.
func (s *StringFilter) SetValue(v string) *StringFilter {
	s.Value = &v
	return s
}

// Threat intel details related to a finding.
type ThreatIntelIndicator struct {
	_ struct{} `type:"structure"`

	// The category of a threat intel indicator.
	Category *string `type:"string" enum:"ThreatIntelIndicatorCategory"`

	// The date/time of the last observation of a threat intel indicator.
	LastObservedAt *string `type:"string"`

	// The source of the threat intel.
	Source *string `type:"string"`

	// The URL for more details from the source of the threat intel.
	SourceUrl *string `type:"string"`

	// The type of a threat intel indicator.
	Type *string `type:"string" enum:"ThreatIntelIndicatorType"`

	// The value of a threat intel indicator.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ThreatIntelIndicator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThreatIntelIndicator) GoString() string {
	return s.String()
}

// SetCategory sets the Category field's value.
func (s *ThreatIntelIndicator) SetCategory(v string) *ThreatIntelIndicator {
	s.Category = &v
	return s
}

// SetLastObservedAt sets the LastObservedAt field's value.
func (s *ThreatIntelIndicator) SetLastObservedAt(v string) *ThreatIntelIndicator {
	s.LastObservedAt = &v
	return s
}

// SetSource sets the Source field's value.
func (s *ThreatIntelIndicator) SetSource(v string) *ThreatIntelIndicator {
	s.Source = &v
	return s
}

// SetSourceUrl sets the SourceUrl field's value.
func (s *ThreatIntelIndicator) SetSourceUrl(v string) *ThreatIntelIndicator {
	s.SourceUrl = &v
	return s
}

// SetType sets the Type field's value.
func (s *ThreatIntelIndicator) SetType(v string) *ThreatIntelIndicator {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ThreatIntelIndicator) SetValue(v string) *ThreatIntelIndicator {
	s.Value = &v
	return s
}

type UpdateFindingsInput struct {
	_ struct{} `type:"structure"`

	// A collection of attributes that specify what findings you want to update.
	//
	// Filters is a required field
	Filters *AwsSecurityFindingFilters `type:"structure" required:"true"`

	// The updated note for the finding.
	Note *NoteUpdate `type:"structure"`

	// The updated record state for the finding.
	RecordState *string `type:"string" enum:"RecordState"`
}

// String returns the string representation
func (s UpdateFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFindingsInput"}
	if s.Filters == nil {
		invalidParams.Add(request.NewErrParamRequired("Filters"))
	}
	if s.Note != nil {
		if err := s.Note.Validate(); err != nil {
			invalidParams.AddNested("Note", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *UpdateFindingsInput) SetFilters(v *AwsSecurityFindingFilters) *UpdateFindingsInput {
	s.Filters = v
	return s
}

// SetNote sets the Note field's value.
func (s *UpdateFindingsInput) SetNote(v *NoteUpdate) *UpdateFindingsInput {
	s.Note = v
	return s
}

// SetRecordState sets the RecordState field's value.
func (s *UpdateFindingsInput) SetRecordState(v string) *UpdateFindingsInput {
	s.RecordState = &v
	return s
}

type UpdateFindingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFindingsOutput) GoString() string {
	return s.String()
}

type UpdateInsightInput struct {
	_ struct{} `type:"structure"`

	// The updated filters that define this insight.
	Filters *AwsSecurityFindingFilters `type:"structure"`

	// The updated GroupBy attribute that defines this insight.
	GroupByAttribute *string `type:"string"`

	// The ARN of the insight that you want to update.
	//
	// InsightArn is a required field
	InsightArn *string `location:"uri" locationName:"InsightArn" type:"string" required:"true"`

	// The updated name for the insight.
	Name *string `type:"string"`
}

// String returns the string representation
func (s UpdateInsightInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInsightInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateInsightInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateInsightInput"}
	if s.InsightArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InsightArn"))
	}
	if s.InsightArn != nil && len(*s.InsightArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InsightArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *UpdateInsightInput) SetFilters(v *AwsSecurityFindingFilters) *UpdateInsightInput {
	s.Filters = v
	return s
}

// SetGroupByAttribute sets the GroupByAttribute field's value.
func (s *UpdateInsightInput) SetGroupByAttribute(v string) *UpdateInsightInput {
	s.GroupByAttribute = &v
	return s
}

// SetInsightArn sets the InsightArn field's value.
func (s *UpdateInsightInput) SetInsightArn(v string) *UpdateInsightInput {
	s.InsightArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateInsightInput) SetName(v string) *UpdateInsightInput {
	s.Name = &v
	return s
}

type UpdateInsightOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateInsightOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInsightOutput) GoString() string {
	return s.String()
}

const (
	// AwsIamAccessKeyStatusActive is a AwsIamAccessKeyStatus enum value
	AwsIamAccessKeyStatusActive = "Active"

	// AwsIamAccessKeyStatusInactive is a AwsIamAccessKeyStatus enum value
	AwsIamAccessKeyStatusInactive = "Inactive"
)

const (
	// ComplianceStatusPassed is a ComplianceStatus enum value
	ComplianceStatusPassed = "PASSED"

	// ComplianceStatusWarning is a ComplianceStatus enum value
	ComplianceStatusWarning = "WARNING"

	// ComplianceStatusFailed is a ComplianceStatus enum value
	ComplianceStatusFailed = "FAILED"

	// ComplianceStatusNotAvailable is a ComplianceStatus enum value
	ComplianceStatusNotAvailable = "NOT_AVAILABLE"
)

const (
	// DateRangeUnitDays is a DateRangeUnit enum value
	DateRangeUnitDays = "DAYS"
)

const (
	// MalwareStateObserved is a MalwareState enum value
	MalwareStateObserved = "OBSERVED"

	// MalwareStateRemovalFailed is a MalwareState enum value
	MalwareStateRemovalFailed = "REMOVAL_FAILED"

	// MalwareStateRemoved is a MalwareState enum value
	MalwareStateRemoved = "REMOVED"
)

const (
	// MalwareTypeAdware is a MalwareType enum value
	MalwareTypeAdware = "ADWARE"

	// MalwareTypeBlendedThreat is a MalwareType enum value
	MalwareTypeBlendedThreat = "BLENDED_THREAT"

	// MalwareTypeBotnetAgent is a MalwareType enum value
	MalwareTypeBotnetAgent = "BOTNET_AGENT"

	// MalwareTypeCoinMiner is a MalwareType enum value
	MalwareTypeCoinMiner = "COIN_MINER"

	// MalwareTypeExploitKit is a MalwareType enum value
	MalwareTypeExploitKit = "EXPLOIT_KIT"

	// MalwareTypeKeylogger is a MalwareType enum value
	MalwareTypeKeylogger = "KEYLOGGER"

	// MalwareTypeMacro is a MalwareType enum value
	MalwareTypeMacro = "MACRO"

	// MalwareTypePotentiallyUnwanted is a MalwareType enum value
	MalwareTypePotentiallyUnwanted = "POTENTIALLY_UNWANTED"

	// MalwareTypeSpyware is a MalwareType enum value
	MalwareTypeSpyware = "SPYWARE"

	// MalwareTypeRansomware is a MalwareType enum value
	MalwareTypeRansomware = "RANSOMWARE"

	// MalwareTypeRemoteAccess is a MalwareType enum value
	MalwareTypeRemoteAccess = "REMOTE_ACCESS"

	// MalwareTypeRootkit is a MalwareType enum value
	MalwareTypeRootkit = "ROOTKIT"

	// MalwareTypeTrojan is a MalwareType enum value
	MalwareTypeTrojan = "TROJAN"

	// MalwareTypeVirus is a MalwareType enum value
	MalwareTypeVirus = "VIRUS"

	// MalwareTypeWorm is a MalwareType enum value
	MalwareTypeWorm = "WORM"
)

const (
	// MapFilterComparisonContains is a MapFilterComparison enum value
	MapFilterComparisonContains = "CONTAINS"
)

const (
	// NetworkDirectionIn is a NetworkDirection enum value
	NetworkDirectionIn = "IN"

	// NetworkDirectionOut is a NetworkDirection enum value
	NetworkDirectionOut = "OUT"
)

const (
	// PartitionAws is a Partition enum value
	PartitionAws = "aws"

	// PartitionAwsCn is a Partition enum value
	PartitionAwsCn = "aws-cn"

	// PartitionAwsUsGov is a Partition enum value
	PartitionAwsUsGov = "aws-us-gov"
)

const (
	// RecordStateActive is a RecordState enum value
	RecordStateActive = "ACTIVE"

	// RecordStateArchived is a RecordState enum value
	RecordStateArchived = "ARCHIVED"
)

const (
	// SortOrderAsc is a SortOrder enum value
	SortOrderAsc = "asc"

	// SortOrderDesc is a SortOrder enum value
	SortOrderDesc = "desc"
)

const (
	// StandardsStatusPending is a StandardsStatus enum value
	StandardsStatusPending = "PENDING"

	// StandardsStatusReady is a StandardsStatus enum value
	StandardsStatusReady = "READY"

	// StandardsStatusFailed is a StandardsStatus enum value
	StandardsStatusFailed = "FAILED"

	// StandardsStatusDeleting is a StandardsStatus enum value
	StandardsStatusDeleting = "DELETING"
)

const (
	// StringFilterComparisonEquals is a StringFilterComparison enum value
	StringFilterComparisonEquals = "EQUALS"

	// StringFilterComparisonContains is a StringFilterComparison enum value
	StringFilterComparisonContains = "CONTAINS"

	// StringFilterComparisonPrefix is a StringFilterComparison enum value
	StringFilterComparisonPrefix = "PREFIX"
)

const (
	// ThreatIntelIndicatorCategoryBackdoor is a ThreatIntelIndicatorCategory enum value
	ThreatIntelIndicatorCategoryBackdoor = "BACKDOOR"

	// ThreatIntelIndicatorCategoryCardStealer is a ThreatIntelIndicatorCategory enum value
	ThreatIntelIndicatorCategoryCardStealer = "CARD_STEALER"

	// ThreatIntelIndicatorCategoryCommandAndControl is a ThreatIntelIndicatorCategory enum value
	ThreatIntelIndicatorCategoryCommandAndControl = "COMMAND_AND_CONTROL"

	// ThreatIntelIndicatorCategoryDropSite is a ThreatIntelIndicatorCategory enum value
	ThreatIntelIndicatorCategoryDropSite = "DROP_SITE"

	// ThreatIntelIndicatorCategoryExploitSite is a ThreatIntelIndicatorCategory enum value
	ThreatIntelIndicatorCategoryExploitSite = "EXPLOIT_SITE"

	// ThreatIntelIndicatorCategoryKeylogger is a ThreatIntelIndicatorCategory enum value
	ThreatIntelIndicatorCategoryKeylogger = "KEYLOGGER"
)

const (
	// ThreatIntelIndicatorTypeDomain is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeDomain = "DOMAIN"

	// ThreatIntelIndicatorTypeEmailAddress is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeEmailAddress = "EMAIL_ADDRESS"

	// ThreatIntelIndicatorTypeHashMd5 is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeHashMd5 = "HASH_MD5"

	// ThreatIntelIndicatorTypeHashSha1 is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeHashSha1 = "HASH_SHA1"

	// ThreatIntelIndicatorTypeHashSha256 is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeHashSha256 = "HASH_SHA256"

	// ThreatIntelIndicatorTypeHashSha512 is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeHashSha512 = "HASH_SHA512"

	// ThreatIntelIndicatorTypeIpv4Address is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeIpv4Address = "IPV4_ADDRESS"

	// ThreatIntelIndicatorTypeIpv6Address is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeIpv6Address = "IPV6_ADDRESS"

	// ThreatIntelIndicatorTypeMutex is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeMutex = "MUTEX"

	// ThreatIntelIndicatorTypeProcess is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeProcess = "PROCESS"

	// ThreatIntelIndicatorTypeUrl is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeUrl = "URL"
)

const (
	// VerificationStateUnknown is a VerificationState enum value
	VerificationStateUnknown = "UNKNOWN"

	// VerificationStateTruePositive is a VerificationState enum value
	VerificationStateTruePositive = "TRUE_POSITIVE"

	// VerificationStateFalsePositive is a VerificationState enum value
	VerificationStateFalsePositive = "FALSE_POSITIVE"

	// VerificationStateBenignPositive is a VerificationState enum value
	VerificationStateBenignPositive = "BENIGN_POSITIVE"
)

const (
	// WorkflowStateNew is a WorkflowState enum value
	WorkflowStateNew = "NEW"

	// WorkflowStateAssigned is a WorkflowState enum value
	WorkflowStateAssigned = "ASSIGNED"

	// WorkflowStateInProgress is a WorkflowState enum value
	WorkflowStateInProgress = "IN_PROGRESS"

	// WorkflowStateDeferred is a WorkflowState enum value
	WorkflowStateDeferred = "DEFERRED"

	// WorkflowStateResolved is a WorkflowState enum value
	WorkflowStateResolved = "RESOLVED"
)
