/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	sriovnetworkv1 "github.com/openshift/sriov-network-operator/pkg/apis/sriovnetwork/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeSriovNetworks implements SriovNetworkInterface
type FakeSriovNetworks struct {
	Fake *FakeSriovnetworkV1
	ns   string
}

var sriovnetworksResource = schema.GroupVersionResource{Group: "sriovnetwork.openshift.io", Version: "v1", Resource: "sriovnetworks"}

var sriovnetworksKind = schema.GroupVersionKind{Group: "sriovnetwork.openshift.io", Version: "v1", Kind: "SriovNetwork"}

// Get takes name of the sriovNetwork, and returns the corresponding sriovNetwork object, and an error if there is any.
func (c *FakeSriovNetworks) Get(ctx context.Context, name string, options v1.GetOptions) (result *sriovnetworkv1.SriovNetwork, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(sriovnetworksResource, c.ns, name), &sriovnetworkv1.SriovNetwork{})

	if obj == nil {
		return nil, err
	}
	return obj.(*sriovnetworkv1.SriovNetwork), err
}

// List takes label and field selectors, and returns the list of SriovNetworks that match those selectors.
func (c *FakeSriovNetworks) List(ctx context.Context, opts v1.ListOptions) (result *sriovnetworkv1.SriovNetworkList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(sriovnetworksResource, sriovnetworksKind, c.ns, opts), &sriovnetworkv1.SriovNetworkList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &sriovnetworkv1.SriovNetworkList{ListMeta: obj.(*sriovnetworkv1.SriovNetworkList).ListMeta}
	for _, item := range obj.(*sriovnetworkv1.SriovNetworkList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested sriovNetworks.
func (c *FakeSriovNetworks) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(sriovnetworksResource, c.ns, opts))

}

// Create takes the representation of a sriovNetwork and creates it.  Returns the server's representation of the sriovNetwork, and an error, if there is any.
func (c *FakeSriovNetworks) Create(ctx context.Context, sriovNetwork *sriovnetworkv1.SriovNetwork, opts v1.CreateOptions) (result *sriovnetworkv1.SriovNetwork, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(sriovnetworksResource, c.ns, sriovNetwork), &sriovnetworkv1.SriovNetwork{})

	if obj == nil {
		return nil, err
	}
	return obj.(*sriovnetworkv1.SriovNetwork), err
}

// Update takes the representation of a sriovNetwork and updates it. Returns the server's representation of the sriovNetwork, and an error, if there is any.
func (c *FakeSriovNetworks) Update(ctx context.Context, sriovNetwork *sriovnetworkv1.SriovNetwork, opts v1.UpdateOptions) (result *sriovnetworkv1.SriovNetwork, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(sriovnetworksResource, c.ns, sriovNetwork), &sriovnetworkv1.SriovNetwork{})

	if obj == nil {
		return nil, err
	}
	return obj.(*sriovnetworkv1.SriovNetwork), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeSriovNetworks) UpdateStatus(ctx context.Context, sriovNetwork *sriovnetworkv1.SriovNetwork, opts v1.UpdateOptions) (*sriovnetworkv1.SriovNetwork, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(sriovnetworksResource, "status", c.ns, sriovNetwork), &sriovnetworkv1.SriovNetwork{})

	if obj == nil {
		return nil, err
	}
	return obj.(*sriovnetworkv1.SriovNetwork), err
}

// Delete takes name of the sriovNetwork and deletes it. Returns an error if one occurs.
func (c *FakeSriovNetworks) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(sriovnetworksResource, c.ns, name), &sriovnetworkv1.SriovNetwork{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeSriovNetworks) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(sriovnetworksResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &sriovnetworkv1.SriovNetworkList{})
	return err
}

// Patch applies the patch and returns the patched sriovNetwork.
func (c *FakeSriovNetworks) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *sriovnetworkv1.SriovNetwork, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(sriovnetworksResource, c.ns, name, pt, data, subresources...), &sriovnetworkv1.SriovNetwork{})

	if obj == nil {
		return nil, err
	}
	return obj.(*sriovnetworkv1.SriovNetwork), err
}
