// Code generated by "go generate gonum.org/v1/gonum/unit”; DO NOT EDIT.

// Copyright ©2014 The Gonum Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package unit

import (
	"errors"
	"fmt"
	"math"
	"unicode/utf8"
)

// AbsorbedRadioactiveDose is a measure of absorbed dose of ionizing radiation in grays.
type AbsorbedRadioactiveDose float64

const (
	Yottagray AbsorbedRadioactiveDose = 1e24
	Zettagray AbsorbedRadioactiveDose = 1e21
	Exagray   AbsorbedRadioactiveDose = 1e18
	Petagray  AbsorbedRadioactiveDose = 1e15
	Teragray  AbsorbedRadioactiveDose = 1e12
	Gigagray  AbsorbedRadioactiveDose = 1e9
	Megagray  AbsorbedRadioactiveDose = 1e6
	Kilogray  AbsorbedRadioactiveDose = 1e3
	Hectogray AbsorbedRadioactiveDose = 1e2
	Decagray  AbsorbedRadioactiveDose = 1e1
	Gray      AbsorbedRadioactiveDose = 1.0
	Decigray  AbsorbedRadioactiveDose = 1e-1
	Centigray AbsorbedRadioactiveDose = 1e-2
	Milligray AbsorbedRadioactiveDose = 1e-3
	Microgray AbsorbedRadioactiveDose = 1e-6
	Nanogray  AbsorbedRadioactiveDose = 1e-9
	Picogray  AbsorbedRadioactiveDose = 1e-12
	Femtogray AbsorbedRadioactiveDose = 1e-15
	Attogray  AbsorbedRadioactiveDose = 1e-18
	Zeptogray AbsorbedRadioactiveDose = 1e-21
	Yoctogray AbsorbedRadioactiveDose = 1e-24
)

// Unit converts the AbsorbedRadioactiveDose to a *Unit
func (a AbsorbedRadioactiveDose) Unit() *Unit {
	return New(float64(a), Dimensions{
		LengthDim: 2,
		TimeDim:   -2,
	})
}

// AbsorbedRadioactiveDose allows AbsorbedRadioactiveDose to implement a AbsorbedRadioactiveDoseer interface
func (a AbsorbedRadioactiveDose) AbsorbedRadioactiveDose() AbsorbedRadioactiveDose {
	return a
}

// From converts the unit into the receiver. From returns an
// error if there is a mismatch in dimension
func (a *AbsorbedRadioactiveDose) From(u Uniter) error {
	if !DimensionsMatch(u, Gray) {
		*a = AbsorbedRadioactiveDose(math.NaN())
		return errors.New("Dimension mismatch")
	}
	*a = AbsorbedRadioactiveDose(u.Unit().Value())
	return nil
}

func (a AbsorbedRadioactiveDose) Format(fs fmt.State, c rune) {
	switch c {
	case 'v':
		if fs.Flag('#') {
			fmt.Fprintf(fs, "%T(%v)", a, float64(a))
			return
		}
		fallthrough
	case 'e', 'E', 'f', 'F', 'g', 'G':
		p, pOk := fs.Precision()
		w, wOk := fs.Width()
		const unit = " Gy"
		switch {
		case pOk && wOk:
			fmt.Fprintf(fs, "%*.*"+string(c), pos(w-utf8.RuneCount([]byte(unit))), p, float64(a))
		case pOk:
			fmt.Fprintf(fs, "%.*"+string(c), p, float64(a))
		case wOk:
			fmt.Fprintf(fs, "%*"+string(c), pos(w-utf8.RuneCount([]byte(unit))), float64(a))
		default:
			fmt.Fprintf(fs, "%"+string(c), float64(a))
		}
		fmt.Fprint(fs, unit)
	default:
		fmt.Fprintf(fs, "%%!%c(%T=%g Gy)", c, a, float64(a))
	}
}
