// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/resources/media_file.proto

package resources // import "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import enums "google.golang.org/genproto/googleapis/ads/googleads/v0/enums"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A media file.
type MediaFile struct {
	// The resource name of the media file.
	// Media file resource names have the form:
	//
	// `customers/{customer_id}/mediaFiles/{media_file_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The ID of the media file.
	Id *wrappers.Int64Value `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Type of the media file.
	Type enums.MediaTypeEnum_MediaType `protobuf:"varint,5,opt,name=type,proto3,enum=google.ads.googleads.v0.enums.MediaTypeEnum_MediaType" json:"type,omitempty"`
	// The mime type of the media file.
	MimeType enums.MimeTypeEnum_MimeType `protobuf:"varint,6,opt,name=mime_type,json=mimeType,proto3,enum=google.ads.googleads.v0.enums.MimeTypeEnum_MimeType" json:"mime_type,omitempty"`
	// The URL of where the original media file was downloaded from (or a file
	// name).
	SourceUrl *wrappers.StringValue `protobuf:"bytes,7,opt,name=source_url,json=sourceUrl,proto3" json:"source_url,omitempty"`
	// The name of the media file. The name can be used by clients to help
	// identify previously uploaded media.
	Name *wrappers.StringValue `protobuf:"bytes,8,opt,name=name,proto3" json:"name,omitempty"`
	// The size of the media file in bytes.
	FileSize *wrappers.Int64Value `protobuf:"bytes,9,opt,name=file_size,json=fileSize,proto3" json:"file_size,omitempty"`
	// The specific type of the media file.
	//
	// Types that are valid to be assigned to Mediatype:
	//	*MediaFile_Image
	//	*MediaFile_MediaBundle
	//	*MediaFile_Audio
	//	*MediaFile_Video
	Mediatype            isMediaFile_Mediatype `protobuf_oneof:"mediatype"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *MediaFile) Reset()         { *m = MediaFile{} }
func (m *MediaFile) String() string { return proto.CompactTextString(m) }
func (*MediaFile) ProtoMessage()    {}
func (*MediaFile) Descriptor() ([]byte, []int) {
	return fileDescriptor_media_file_29fb685b40df9f39, []int{0}
}
func (m *MediaFile) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MediaFile.Unmarshal(m, b)
}
func (m *MediaFile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MediaFile.Marshal(b, m, deterministic)
}
func (dst *MediaFile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MediaFile.Merge(dst, src)
}
func (m *MediaFile) XXX_Size() int {
	return xxx_messageInfo_MediaFile.Size(m)
}
func (m *MediaFile) XXX_DiscardUnknown() {
	xxx_messageInfo_MediaFile.DiscardUnknown(m)
}

var xxx_messageInfo_MediaFile proto.InternalMessageInfo

func (m *MediaFile) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *MediaFile) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *MediaFile) GetType() enums.MediaTypeEnum_MediaType {
	if m != nil {
		return m.Type
	}
	return enums.MediaTypeEnum_UNSPECIFIED
}

func (m *MediaFile) GetMimeType() enums.MimeTypeEnum_MimeType {
	if m != nil {
		return m.MimeType
	}
	return enums.MimeTypeEnum_UNSPECIFIED
}

func (m *MediaFile) GetSourceUrl() *wrappers.StringValue {
	if m != nil {
		return m.SourceUrl
	}
	return nil
}

func (m *MediaFile) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *MediaFile) GetFileSize() *wrappers.Int64Value {
	if m != nil {
		return m.FileSize
	}
	return nil
}

type isMediaFile_Mediatype interface {
	isMediaFile_Mediatype()
}

type MediaFile_Image struct {
	Image *MediaImage `protobuf:"bytes,3,opt,name=image,proto3,oneof"`
}

type MediaFile_MediaBundle struct {
	MediaBundle *MediaBundle `protobuf:"bytes,4,opt,name=media_bundle,json=mediaBundle,proto3,oneof"`
}

type MediaFile_Audio struct {
	Audio *MediaAudio `protobuf:"bytes,10,opt,name=audio,proto3,oneof"`
}

type MediaFile_Video struct {
	Video *MediaVideo `protobuf:"bytes,11,opt,name=video,proto3,oneof"`
}

func (*MediaFile_Image) isMediaFile_Mediatype() {}

func (*MediaFile_MediaBundle) isMediaFile_Mediatype() {}

func (*MediaFile_Audio) isMediaFile_Mediatype() {}

func (*MediaFile_Video) isMediaFile_Mediatype() {}

func (m *MediaFile) GetMediatype() isMediaFile_Mediatype {
	if m != nil {
		return m.Mediatype
	}
	return nil
}

func (m *MediaFile) GetImage() *MediaImage {
	if x, ok := m.GetMediatype().(*MediaFile_Image); ok {
		return x.Image
	}
	return nil
}

func (m *MediaFile) GetMediaBundle() *MediaBundle {
	if x, ok := m.GetMediatype().(*MediaFile_MediaBundle); ok {
		return x.MediaBundle
	}
	return nil
}

func (m *MediaFile) GetAudio() *MediaAudio {
	if x, ok := m.GetMediatype().(*MediaFile_Audio); ok {
		return x.Audio
	}
	return nil
}

func (m *MediaFile) GetVideo() *MediaVideo {
	if x, ok := m.GetMediatype().(*MediaFile_Video); ok {
		return x.Video
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*MediaFile) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _MediaFile_OneofMarshaler, _MediaFile_OneofUnmarshaler, _MediaFile_OneofSizer, []interface{}{
		(*MediaFile_Image)(nil),
		(*MediaFile_MediaBundle)(nil),
		(*MediaFile_Audio)(nil),
		(*MediaFile_Video)(nil),
	}
}

func _MediaFile_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*MediaFile)
	// mediatype
	switch x := m.Mediatype.(type) {
	case *MediaFile_Image:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Image); err != nil {
			return err
		}
	case *MediaFile_MediaBundle:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MediaBundle); err != nil {
			return err
		}
	case *MediaFile_Audio:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Audio); err != nil {
			return err
		}
	case *MediaFile_Video:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Video); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("MediaFile.Mediatype has unexpected type %T", x)
	}
	return nil
}

func _MediaFile_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*MediaFile)
	switch tag {
	case 3: // mediatype.image
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MediaImage)
		err := b.DecodeMessage(msg)
		m.Mediatype = &MediaFile_Image{msg}
		return true, err
	case 4: // mediatype.media_bundle
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MediaBundle)
		err := b.DecodeMessage(msg)
		m.Mediatype = &MediaFile_MediaBundle{msg}
		return true, err
	case 10: // mediatype.audio
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MediaAudio)
		err := b.DecodeMessage(msg)
		m.Mediatype = &MediaFile_Audio{msg}
		return true, err
	case 11: // mediatype.video
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MediaVideo)
		err := b.DecodeMessage(msg)
		m.Mediatype = &MediaFile_Video{msg}
		return true, err
	default:
		return false, nil
	}
}

func _MediaFile_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*MediaFile)
	// mediatype
	switch x := m.Mediatype.(type) {
	case *MediaFile_Image:
		s := proto.Size(x.Image)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MediaFile_MediaBundle:
		s := proto.Size(x.MediaBundle)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MediaFile_Audio:
		s := proto.Size(x.Audio)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MediaFile_Video:
		s := proto.Size(x.Video)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Encapsulates an Image.
type MediaImage struct {
	// Raw image data.
	Data                 *wrappers.BytesValue `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *MediaImage) Reset()         { *m = MediaImage{} }
func (m *MediaImage) String() string { return proto.CompactTextString(m) }
func (*MediaImage) ProtoMessage()    {}
func (*MediaImage) Descriptor() ([]byte, []int) {
	return fileDescriptor_media_file_29fb685b40df9f39, []int{1}
}
func (m *MediaImage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MediaImage.Unmarshal(m, b)
}
func (m *MediaImage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MediaImage.Marshal(b, m, deterministic)
}
func (dst *MediaImage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MediaImage.Merge(dst, src)
}
func (m *MediaImage) XXX_Size() int {
	return xxx_messageInfo_MediaImage.Size(m)
}
func (m *MediaImage) XXX_DiscardUnknown() {
	xxx_messageInfo_MediaImage.DiscardUnknown(m)
}

var xxx_messageInfo_MediaImage proto.InternalMessageInfo

func (m *MediaImage) GetData() *wrappers.BytesValue {
	if m != nil {
		return m.Data
	}
	return nil
}

// Represents a ZIP archive media the content of which contains HTML5 assets.
type MediaBundle struct {
	// Raw zipped data.
	Data                 *wrappers.BytesValue `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *MediaBundle) Reset()         { *m = MediaBundle{} }
func (m *MediaBundle) String() string { return proto.CompactTextString(m) }
func (*MediaBundle) ProtoMessage()    {}
func (*MediaBundle) Descriptor() ([]byte, []int) {
	return fileDescriptor_media_file_29fb685b40df9f39, []int{2}
}
func (m *MediaBundle) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MediaBundle.Unmarshal(m, b)
}
func (m *MediaBundle) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MediaBundle.Marshal(b, m, deterministic)
}
func (dst *MediaBundle) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MediaBundle.Merge(dst, src)
}
func (m *MediaBundle) XXX_Size() int {
	return xxx_messageInfo_MediaBundle.Size(m)
}
func (m *MediaBundle) XXX_DiscardUnknown() {
	xxx_messageInfo_MediaBundle.DiscardUnknown(m)
}

var xxx_messageInfo_MediaBundle proto.InternalMessageInfo

func (m *MediaBundle) GetData() *wrappers.BytesValue {
	if m != nil {
		return m.Data
	}
	return nil
}

// Encapsulates an Audio.
type MediaAudio struct {
	// The duration of the Audio in milliseconds.
	AdDurationMillis     *wrappers.Int64Value `protobuf:"bytes,1,opt,name=ad_duration_millis,json=adDurationMillis,proto3" json:"ad_duration_millis,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *MediaAudio) Reset()         { *m = MediaAudio{} }
func (m *MediaAudio) String() string { return proto.CompactTextString(m) }
func (*MediaAudio) ProtoMessage()    {}
func (*MediaAudio) Descriptor() ([]byte, []int) {
	return fileDescriptor_media_file_29fb685b40df9f39, []int{3}
}
func (m *MediaAudio) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MediaAudio.Unmarshal(m, b)
}
func (m *MediaAudio) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MediaAudio.Marshal(b, m, deterministic)
}
func (dst *MediaAudio) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MediaAudio.Merge(dst, src)
}
func (m *MediaAudio) XXX_Size() int {
	return xxx_messageInfo_MediaAudio.Size(m)
}
func (m *MediaAudio) XXX_DiscardUnknown() {
	xxx_messageInfo_MediaAudio.DiscardUnknown(m)
}

var xxx_messageInfo_MediaAudio proto.InternalMessageInfo

func (m *MediaAudio) GetAdDurationMillis() *wrappers.Int64Value {
	if m != nil {
		return m.AdDurationMillis
	}
	return nil
}

// Encapsulates a Video.
type MediaVideo struct {
	// The duration of the Video in milliseconds.
	AdDurationMillis *wrappers.Int64Value `protobuf:"bytes,1,opt,name=ad_duration_millis,json=adDurationMillis,proto3" json:"ad_duration_millis,omitempty"`
	// The YouTube video ID (as seen in YouTube URLs).
	YoutubeVideoId *wrappers.StringValue `protobuf:"bytes,2,opt,name=youtube_video_id,json=youtubeVideoId,proto3" json:"youtube_video_id,omitempty"`
	// The Advertising Digital Identification code for this video, as defined by
	// the American Association of Advertising Agencies, used mainly for
	// television commercials.
	AdvertisingIdCode *wrappers.StringValue `protobuf:"bytes,3,opt,name=advertising_id_code,json=advertisingIdCode,proto3" json:"advertising_id_code,omitempty"`
	// The Industry Standard Commercial Identifier code for this video, used
	// mainly for television commercials.
	IsciCode             *wrappers.StringValue `protobuf:"bytes,4,opt,name=isci_code,json=isciCode,proto3" json:"isci_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *MediaVideo) Reset()         { *m = MediaVideo{} }
func (m *MediaVideo) String() string { return proto.CompactTextString(m) }
func (*MediaVideo) ProtoMessage()    {}
func (*MediaVideo) Descriptor() ([]byte, []int) {
	return fileDescriptor_media_file_29fb685b40df9f39, []int{4}
}
func (m *MediaVideo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MediaVideo.Unmarshal(m, b)
}
func (m *MediaVideo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MediaVideo.Marshal(b, m, deterministic)
}
func (dst *MediaVideo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MediaVideo.Merge(dst, src)
}
func (m *MediaVideo) XXX_Size() int {
	return xxx_messageInfo_MediaVideo.Size(m)
}
func (m *MediaVideo) XXX_DiscardUnknown() {
	xxx_messageInfo_MediaVideo.DiscardUnknown(m)
}

var xxx_messageInfo_MediaVideo proto.InternalMessageInfo

func (m *MediaVideo) GetAdDurationMillis() *wrappers.Int64Value {
	if m != nil {
		return m.AdDurationMillis
	}
	return nil
}

func (m *MediaVideo) GetYoutubeVideoId() *wrappers.StringValue {
	if m != nil {
		return m.YoutubeVideoId
	}
	return nil
}

func (m *MediaVideo) GetAdvertisingIdCode() *wrappers.StringValue {
	if m != nil {
		return m.AdvertisingIdCode
	}
	return nil
}

func (m *MediaVideo) GetIsciCode() *wrappers.StringValue {
	if m != nil {
		return m.IsciCode
	}
	return nil
}

func init() {
	proto.RegisterType((*MediaFile)(nil), "google.ads.googleads.v0.resources.MediaFile")
	proto.RegisterType((*MediaImage)(nil), "google.ads.googleads.v0.resources.MediaImage")
	proto.RegisterType((*MediaBundle)(nil), "google.ads.googleads.v0.resources.MediaBundle")
	proto.RegisterType((*MediaAudio)(nil), "google.ads.googleads.v0.resources.MediaAudio")
	proto.RegisterType((*MediaVideo)(nil), "google.ads.googleads.v0.resources.MediaVideo")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/resources/media_file.proto", fileDescriptor_media_file_29fb685b40df9f39)
}

var fileDescriptor_media_file_29fb685b40df9f39 = []byte{
	// 670 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x95, 0xed, 0x6a, 0x13, 0x4f,
	0x14, 0xc6, 0x9b, 0x6d, 0xda, 0x7f, 0x76, 0xd2, 0x7f, 0xa9, 0xe3, 0x97, 0xa5, 0x8a, 0xb4, 0x91,
	0x42, 0x41, 0x3a, 0x1b, 0x6a, 0x29, 0xba, 0x45, 0x21, 0xd1, 0xbe, 0xa4, 0x58, 0xa9, 0x5b, 0x8d,
	0x20, 0x81, 0x65, 0x92, 0x39, 0x5d, 0x06, 0x76, 0x77, 0x96, 0x9d, 0xdd, 0x48, 0x7a, 0x39, 0x7e,
	0x12, 0x2f, 0xc5, 0x6b, 0xf0, 0x0a, 0xbc, 0x05, 0xbf, 0xc8, 0xcc, 0xbe, 0x24, 0xa0, 0x6d, 0x5a,
	0xf0, 0xdb, 0x99, 0xec, 0xf3, 0xfc, 0xe6, 0x39, 0x27, 0x27, 0x1b, 0xb4, 0xeb, 0x0b, 0xe1, 0x07,
	0x60, 0x53, 0x26, 0xed, 0xbc, 0x54, 0xd5, 0xb8, 0x6d, 0x27, 0x20, 0x45, 0x96, 0x8c, 0x40, 0xda,
	0x21, 0x30, 0x4e, 0xbd, 0x4b, 0x1e, 0x00, 0x89, 0x13, 0x91, 0x0a, 0xbc, 0x99, 0x0b, 0x09, 0x65,
	0x92, 0x54, 0x1e, 0x32, 0x6e, 0x93, 0xca, 0xb3, 0x4e, 0xae, 0xc3, 0x42, 0x94, 0x85, 0x25, 0x32,
	0x9d, 0xc4, 0x05, 0x72, 0x7d, 0x67, 0x8e, 0x9e, 0x87, 0x30, 0x2b, 0x7f, 0x54, 0xc8, 0xf5, 0x69,
	0x98, 0x5d, 0xda, 0x9f, 0x13, 0x1a, 0xc7, 0x90, 0xc8, 0xfc, 0x79, 0xeb, 0xc7, 0x12, 0x32, 0xcf,
	0xd4, 0x1d, 0x47, 0x3c, 0x00, 0xfc, 0x18, 0xfd, 0x5f, 0x26, 0xf3, 0x22, 0x1a, 0x82, 0x55, 0xdb,
	0xa8, 0x6d, 0x9b, 0xee, 0x4a, 0xf9, 0xe1, 0x5b, 0x1a, 0x02, 0x7e, 0x82, 0x0c, 0xce, 0x2c, 0x63,
	0xa3, 0xb6, 0xdd, 0xdc, 0x7d, 0x50, 0xc4, 0x27, 0x25, 0x9f, 0xf4, 0xa2, 0x74, 0x7f, 0xaf, 0x4f,
	0x83, 0x0c, 0x5c, 0x83, 0x33, 0x7c, 0x8a, 0xea, 0x2a, 0x8d, 0xb5, 0xb4, 0x51, 0xdb, 0x5e, 0xdd,
	0xdd, 0x27, 0xd7, 0x0d, 0x44, 0xa7, 0x27, 0x3a, 0xc9, 0xfb, 0x49, 0x0c, 0x87, 0x51, 0x16, 0x4e,
	0x4f, 0xae, 0x66, 0xe0, 0x77, 0xc8, 0xac, 0xda, 0xb3, 0x96, 0x35, 0x70, 0x6f, 0x1e, 0x90, 0x87,
	0x30, 0xe5, 0x15, 0x07, 0xb7, 0x11, 0x16, 0x15, 0x3e, 0x40, 0xa8, 0x68, 0x37, 0x4b, 0x02, 0xeb,
	0x3f, 0xdd, 0xd3, 0xc3, 0x3f, 0x7a, 0xba, 0x48, 0x13, 0x1e, 0xf9, 0x79, 0x53, 0x66, 0xae, 0xff,
	0x90, 0x04, 0xb8, 0x8d, 0xea, 0x7a, 0x48, 0x8d, 0x5b, 0xd8, 0xb4, 0x12, 0x3f, 0x43, 0xa6, 0xda,
	0x0e, 0x4f, 0xf2, 0x2b, 0xb0, 0xcc, 0xf9, 0x13, 0x6c, 0x28, 0xf5, 0x05, 0xbf, 0x02, 0x7c, 0x88,
	0x96, 0x78, 0x48, 0x7d, 0xb0, 0x16, 0xb5, 0x6b, 0x87, 0xcc, 0xdd, 0xac, 0x7c, 0x7c, 0x3d, 0x65,
	0x3a, 0x59, 0x70, 0x73, 0x37, 0xbe, 0x40, 0x2b, 0xf9, 0x46, 0x0d, 0xb3, 0x88, 0x05, 0x60, 0xd5,
	0x35, 0x8d, 0xdc, 0x96, 0xd6, 0xd5, 0xae, 0x93, 0x05, 0xb7, 0x19, 0x4e, 0x8f, 0x2a, 0x1b, 0xcd,
	0x18, 0x17, 0x16, 0xba, 0x5b, 0xb6, 0x8e, 0x32, 0xa9, 0x6c, 0xda, 0xad, 0x30, 0x63, 0xce, 0x40,
	0x58, 0xcd, 0xbb, 0x61, 0xfa, 0xca, 0xa4, 0x30, 0xda, 0xdd, 0x6d, 0x22, 0x53, 0x87, 0x53, 0x5b,
	0xd2, 0x7a, 0x81, 0xd0, 0x74, 0x0c, 0xd8, 0x46, 0x75, 0x46, 0x53, 0xaa, 0xb7, 0xfa, 0x6f, 0x93,
	0xef, 0x4e, 0x52, 0x90, 0xc5, 0xf7, 0xa5, 0x84, 0xad, 0x97, 0xa8, 0x39, 0xd3, 0xf7, 0xdd, 0xfd,
	0x1f, 0x8b, 0xeb, 0x75, 0xa7, 0xb8, 0x87, 0x30, 0x65, 0x1e, 0xcb, 0x12, 0x9a, 0x72, 0x11, 0x79,
	0x21, 0x0f, 0x02, 0x2e, 0xaf, 0x85, 0xcd, 0xac, 0xc1, 0x1a, 0x65, 0xaf, 0x0b, 0xd7, 0x99, 0x36,
	0xb5, 0xbe, 0x1a, 0x05, 0x59, 0x37, 0xff, 0x0f, 0xc9, 0xf8, 0x08, 0xad, 0x4d, 0x44, 0x96, 0x66,
	0x43, 0xf0, 0xf4, 0x3c, 0xbd, 0xea, 0xb7, 0x7e, 0xf3, 0x82, 0xaf, 0x16, 0x2e, 0x1d, 0xa8, 0xc7,
	0xf0, 0x1b, 0x74, 0x9f, 0xb2, 0x31, 0x24, 0x29, 0x97, 0x3c, 0xf2, 0x3d, 0xce, 0xbc, 0x91, 0x60,
	0xe5, 0xfa, 0xde, 0x8c, 0xba, 0x37, 0x63, 0xec, 0xb1, 0x57, 0x82, 0x01, 0x7e, 0x8e, 0x4c, 0x2e,
	0x47, 0x3c, 0x67, 0xd4, 0x6f, 0xc1, 0x68, 0x28, 0xb9, 0xb2, 0x76, 0x7f, 0xd5, 0xd0, 0xd6, 0x48,
	0x84, 0xf3, 0xb7, 0xa9, 0xbb, 0x5a, 0xbd, 0x08, 0xcf, 0x15, 0xf2, 0xbc, 0xf6, 0xe9, 0xb4, 0x30,
	0xf9, 0x22, 0xa0, 0x91, 0x4f, 0x44, 0xe2, 0xdb, 0x3e, 0x44, 0xfa, 0xc2, 0xf2, 0xe5, 0x1b, 0x73,
	0x79, 0xc3, 0x5f, 0xc2, 0x41, 0x55, 0x7d, 0x31, 0x16, 0x8f, 0x3b, 0x9d, 0x6f, 0xc6, 0xe6, 0x71,
	0x8e, 0xec, 0x30, 0x49, 0xf2, 0x52, 0x55, 0xfd, 0x36, 0x71, 0x4b, 0xe5, 0xf7, 0x52, 0x33, 0xe8,
	0x30, 0x39, 0xa8, 0x34, 0x83, 0x7e, 0x7b, 0x50, 0x69, 0x7e, 0x1a, 0x5b, 0xf9, 0x03, 0xc7, 0xe9,
	0x30, 0xe9, 0x38, 0x95, 0xca, 0x71, 0xfa, 0x6d, 0xc7, 0xa9, 0x74, 0xc3, 0x65, 0x1d, 0xf6, 0xe9,
	0xef, 0x00, 0x00, 0x00, 0xff, 0xff, 0xea, 0xa9, 0x7d, 0xf7, 0xbe, 0x06, 0x00, 0x00,
}
