# Change Log

## [0.9.0](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.9.0) (2019-04-11)
[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.8.1...0.9.0)

**Implemented enhancements:**

- feat\(packageserver\): support apps.redhat.com and operators.coreos.com [\#788](https://github.com/operator-framework/operator-lifecycle-manager/pull/788) ([njhale](https://github.com/njhale))
- fix\(metrics\): add service monitor config [\#682](https://github.com/operator-framework/operator-lifecycle-manager/pull/682) ([jpeeler](https://github.com/jpeeler))

**Fixed bugs:**

- fix\(annotation\): don't annotate deployments that aren't owned by a CSV [\#792](https://github.com/operator-framework/operator-lifecycle-manager/pull/792) ([ecordell](https://github.com/ecordell))
- fix\(packageserver\): add struct tags to PackageManifestList [\#791](https://github.com/operator-framework/operator-lifecycle-manager/pull/791) ([njhale](https://github.com/njhale))
- fix\(olm\): use hashes for provided api labels [\#778](https://github.com/operator-framework/operator-lifecycle-manager/pull/778) ([ecordell](https://github.com/ecordell))

**Closed issues:**

- git add issue [\#797](https://github.com/operator-framework/operator-lifecycle-manager/issues/797)
- Unable to install the latest version on minishift [\#780](https://github.com/operator-framework/operator-lifecycle-manager/issues/780)
- scripts/install\_local.sh: upstream-operators.catalogsource.yaml not written correctly [\#772](https://github.com/operator-framework/operator-lifecycle-manager/issues/772)
- flag provided but not defined: -writeStatusName [\#770](https://github.com/operator-framework/operator-lifecycle-manager/issues/770)
- ClusterServiceVersion Status: Failed [\#769](https://github.com/operator-framework/operator-lifecycle-manager/issues/769)
- Upstream quickstart and latest manifests should deploy same OLM image [\#747](https://github.com/operator-framework/operator-lifecycle-manager/issues/747)

**Other changes:**

- Fix modules [\#805](https://github.com/operator-framework/operator-lifecycle-manager/pull/805) ([njhale](https://github.com/njhale))
- Cut Release 0.9.0 [\#802](https://github.com/operator-framework/operator-lifecycle-manager/pull/802) ([alecmerdler](https://github.com/alecmerdler))
- Bump OLM Release Version to 0.9.0 [\#801](https://github.com/operator-framework/operator-lifecycle-manager/pull/801) ([alecmerdler](https://github.com/alecmerdler))
- Update Kubernetes dependencies to 1.12.7 [\#793](https://github.com/operator-framework/operator-lifecycle-manager/pull/793) ([jpeeler](https://github.com/jpeeler))
- chore\(build\): build binaries locally and load them into containers [\#777](https://github.com/operator-framework/operator-lifecycle-manager/pull/777) ([ecordell](https://github.com/ecordell))
- chore\(catalog\): add ClusterOperator status for catalog operator [\#776](https://github.com/operator-framework/operator-lifecycle-manager/pull/776) ([ecordell](https://github.com/ecordell))
- chore\(deploy\): set priorityclass on olm pods [\#775](https://github.com/operator-framework/operator-lifecycle-manager/pull/775) ([ecordell](https://github.com/ecordell))
- chore\(api\): bump operatorgroup and packagemanifest to v1  [\#774](https://github.com/operator-framework/operator-lifecycle-manager/pull/774) ([ecordell](https://github.com/ecordell))
- chore\(manifests\): recut 0.8.1 [\#771](https://github.com/operator-framework/operator-lifecycle-manager/pull/771) ([njhale](https://github.com/njhale))
- docs\(subscriptions\): add improved sub status proposal [\#741](https://github.com/operator-framework/operator-lifecycle-manager/pull/741) ([njhale](https://github.com/njhale))

## [0.8.1](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.8.1) (2019-03-20)
[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.7.1...0.8.1)

**Implemented enhancements:**

- Grant namespace list to global operators [\#764](https://github.com/operator-framework/operator-lifecycle-manager/pull/764) ([ecordell](https://github.com/ecordell))
- feat\(csv\): requeue csvs on change to CRDs [\#763](https://github.com/operator-framework/operator-lifecycle-manager/pull/763) ([njhale](https://github.com/njhale))
- Add upstream catalog [\#762](https://github.com/operator-framework/operator-lifecycle-manager/pull/762) ([ecordell](https://github.com/ecordell))
- refactor\(images\): use operator-framework namespace for all olm images [\#752](https://github.com/operator-framework/operator-lifecycle-manager/pull/752) ([njhale](https://github.com/njhale))
- clusteroperator: Report when OLM reaches "level" and check syncs [\#748](https://github.com/operator-framework/operator-lifecycle-manager/pull/748) ([smarterclayton](https://github.com/smarterclayton))
- feat\(test\): adds CSV phase reporting for package server [\#745](https://github.com/operator-framework/operator-lifecycle-manager/pull/745) ([jpeeler](https://github.com/jpeeler))
- Add minKubeVersion validation to templates [\#739](https://github.com/operator-framework/operator-lifecycle-manager/pull/739) ([dinhxuanvu](https://github.com/dinhxuanvu))
- OperatorGroup expansion/contraction [\#736](https://github.com/operator-framework/operator-lifecycle-manager/pull/736) ([ecordell](https://github.com/ecordell))
- docs\(operatorgroups\): add more extensive docs [\#721](https://github.com/operator-framework/operator-lifecycle-manager/pull/721) ([njhale](https://github.com/njhale))
- add all-in-one yaml and helper script [\#720](https://github.com/operator-framework/operator-lifecycle-manager/pull/720) ([dmesser](https://github.com/dmesser))
- feat\(csv\): allow use verb in permissions [\#717](https://github.com/operator-framework/operator-lifecycle-manager/pull/717) ([ecordell](https://github.com/ecordell))
- Add Graceful Shutdown to PackageManifest Server [\#711](https://github.com/operator-framework/operator-lifecycle-manager/pull/711) ([alecmerdler](https://github.com/alecmerdler))
- feat\(catalogsource\): allow grpc source types that don't require an image [\#709](https://github.com/operator-framework/operator-lifecycle-manager/pull/709) ([njhale](https://github.com/njhale))
- remove minishift support [\#704](https://github.com/operator-framework/operator-lifecycle-manager/pull/704) ([leseb](https://github.com/leseb))
- fix\(packagemanifest\): Add InstallModes info from CSV to PackageManifest [\#697](https://github.com/operator-framework/operator-lifecycle-manager/pull/697) ([dinhxuanvu](https://github.com/dinhxuanvu))
- fix\(installplans\): add ability to apply Services [\#674](https://github.com/operator-framework/operator-lifecycle-manager/pull/674) ([njhale](https://github.com/njhale))
- test\(validation\): add test to verify OLM can use bundles with CRDs with min/max fields [\#672](https://github.com/operator-framework/operator-lifecycle-manager/pull/672) ([njhale](https://github.com/njhale))
- test\(catalog\): add e2e test to verify configmap changes are detected [\#670](https://github.com/operator-framework/operator-lifecycle-manager/pull/670) ([ecordell](https://github.com/ecordell))
- fix\(operatorgroups\): write out CSV status on OperatorGroup issues [\#669](https://github.com/operator-framework/operator-lifecycle-manager/pull/669) ([njhale](https://github.com/njhale))
- Add minimum kube version to CSV & check it against server version [\#663](https://github.com/operator-framework/operator-lifecycle-manager/pull/663) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Watch all namespaces in local setup by removing watchedNamespaces in local-values [\#657](https://github.com/operator-framework/operator-lifecycle-manager/pull/657) ([chancez](https://github.com/chancez))
- Write cluster operator status after successful startup \(attempt \#2\) [\#652](https://github.com/operator-framework/operator-lifecycle-manager/pull/652) ([jpeeler](https://github.com/jpeeler))
- Consume Operator Registry from PackageManifest Server [\#650](https://github.com/operator-framework/operator-lifecycle-manager/pull/650) ([njhale](https://github.com/njhale))
- update codegen for 2019 [\#646](https://github.com/operator-framework/operator-lifecycle-manager/pull/646) ([jcantrill](https://github.com/jcantrill))
- test\(catalog\): add an e2e test verifying that the rh-operators catalog starts [\#643](https://github.com/operator-framework/operator-lifecycle-manager/pull/643) ([ecordell](https://github.com/ecordell))
- feat\(csv\): add installmodes to CSV spec [\#640](https://github.com/operator-framework/operator-lifecycle-manager/pull/640) ([njhale](https://github.com/njhale))
- feat\(resolver\): take all subscriptions into account when resolving [\#638](https://github.com/operator-framework/operator-lifecycle-manager/pull/638) ([ecordell](https://github.com/ecordell))
- Requeue subscriptions on catalogsource change [\#633](https://github.com/operator-framework/operator-lifecycle-manager/pull/633) ([ecordell](https://github.com/ecordell))
- Add view permissions for CRDs on provided APIs [\#618](https://github.com/operator-framework/operator-lifecycle-manager/pull/618) ([ecordell](https://github.com/ecordell))
- Require pluralname for APIServiceDefinitions in CSVs [\#617](https://github.com/operator-framework/operator-lifecycle-manager/pull/617) ([ecordell](https://github.com/ecordell))
- Verify CRD's condition to ensure it's registered with k8s API \(rebased\) [\#614](https://github.com/operator-framework/operator-lifecycle-manager/pull/614) ([jpeeler](https://github.com/jpeeler))
- chore\(release\): switch image-reference tag to operator-lifecycle-manager [\#612](https://github.com/operator-framework/operator-lifecycle-manager/pull/612) ([ecordell](https://github.com/ecordell))
- feat\(package-server\): create subscription manifest [\#609](https://github.com/operator-framework/operator-lifecycle-manager/pull/609) ([njhale](https://github.com/njhale))
- use quay.io vs registry.reg-aws.openshift.com [\#608](https://github.com/operator-framework/operator-lifecycle-manager/pull/608) ([jboyd01](https://github.com/jboyd01))
- feat\(ci\): remove e2e tests from gitlab [\#602](https://github.com/operator-framework/operator-lifecycle-manager/pull/602) ([ecordell](https://github.com/ecordell))
- feat\(package-server\): self-host package-server with CSV [\#594](https://github.com/operator-framework/operator-lifecycle-manager/pull/594) ([njhale](https://github.com/njhale))
- test\(csv\): use mock-ext-server for owned apiservice e2e test [\#593](https://github.com/operator-framework/operator-lifecycle-manager/pull/593) ([njhale](https://github.com/njhale))
- Add operator namespace [\#591](https://github.com/operator-framework/operator-lifecycle-manager/pull/591) ([jpeeler](https://github.com/jpeeler))
- Don't process CSVs without operatorgroup [\#589](https://github.com/operator-framework/operator-lifecycle-manager/pull/589) ([ecordell](https://github.com/ecordell))
- Adding description to package manifest object [\#587](https://github.com/operator-framework/operator-lifecycle-manager/pull/587) ([galletti94](https://github.com/galletti94))
- Propagate Labels from `CatalogSource` to `PackageManifests` [\#576](https://github.com/operator-framework/operator-lifecycle-manager/pull/576) ([alecmerdler](https://github.com/alecmerdler))
- Make use a valid clusterPermissions rule verb [\#575](https://github.com/operator-framework/operator-lifecycle-manager/pull/575) ([wongma7](https://github.com/wongma7))
- Create role bindings for operator service accounts  [\#571](https://github.com/operator-framework/operator-lifecycle-manager/pull/571) ([ecordell](https://github.com/ecordell))
- feat\(olm\): use cache listers in olm-operator [\#569](https://github.com/operator-framework/operator-lifecycle-manager/pull/569) ([njhale](https://github.com/njhale))
- Operator group follow ups [\#568](https://github.com/operator-framework/operator-lifecycle-manager/pull/568) ([jpeeler](https://github.com/jpeeler))
- feat\(mocks\): generate fakes and mocks in a container [\#564](https://github.com/operator-framework/operator-lifecycle-manager/pull/564) ([njhale](https://github.com/njhale))
- Remove ns annotator [\#563](https://github.com/operator-framework/operator-lifecycle-manager/pull/563) ([ecordell](https://github.com/ecordell))
- Create registry pods for ConfigMap CatalogSources [\#556](https://github.com/operator-framework/operator-lifecycle-manager/pull/556) ([ecordell](https://github.com/ecordell))
- Switch to go modules [\#554](https://github.com/operator-framework/operator-lifecycle-manager/pull/554) ([ecordell](https://github.com/ecordell))
- feat\(make\): add e2e command for running from ci-operator [\#552](https://github.com/operator-framework/operator-lifecycle-manager/pull/552) ([ecordell](https://github.com/ecordell))
- Add test case for supporting multi-version CRD [\#548](https://github.com/operator-framework/operator-lifecycle-manager/pull/548) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Verify Native APIs Present for ClusterServiceVersion [\#541](https://github.com/operator-framework/operator-lifecycle-manager/pull/541) ([alecmerdler](https://github.com/alecmerdler))
- feat\(csv\): detect req and dep change in succeeded/failed phases [\#536](https://github.com/operator-framework/operator-lifecycle-manager/pull/536) ([njhale](https://github.com/njhale))
- Add `assign` verb to csv crd [\#531](https://github.com/operator-framework/operator-lifecycle-manager/pull/531) ([eriknelson](https://github.com/eriknelson))
- Emit Kubernetes Events for ClusterServiceVersion [\#530](https://github.com/operator-framework/operator-lifecycle-manager/pull/530) ([alecmerdler](https://github.com/alecmerdler))
- feat\(csv\): add cert rotation for owned APIServices [\#525](https://github.com/operator-framework/operator-lifecycle-manager/pull/525) ([njhale](https://github.com/njhale))
- Pass Annotations to PackageManifests [\#521](https://github.com/operator-framework/operator-lifecycle-manager/pull/521) ([alecmerdler](https://github.com/alecmerdler))
- feat\(deploy\): add debug variable to all deployments [\#518](https://github.com/operator-framework/operator-lifecycle-manager/pull/518) ([jpeeler](https://github.com/jpeeler))
- feat\(build\): allow skipping minikube during local builds [\#516](https://github.com/operator-framework/operator-lifecycle-manager/pull/516) ([jpeeler](https://github.com/jpeeler))
- Add possible nonResourceURL verbs to validation [\#511](https://github.com/operator-framework/operator-lifecycle-manager/pull/511) ([eriknelson](https://github.com/eriknelson))
- Add CatalogSource-Specific Fields to PackageManifest [\#505](https://github.com/operator-framework/operator-lifecycle-manager/pull/505) ([alecmerdler](https://github.com/alecmerdler))
- Add Runlevels + docker labels [\#502](https://github.com/operator-framework/operator-lifecycle-manager/pull/502) ([ecordell](https://github.com/ecordell))
- Make use a valid clusterPermissions rule verb [\#499](https://github.com/operator-framework/operator-lifecycle-manager/pull/499) ([wongma7](https://github.com/wongma7))
- Always Return Global `PackageManifests` [\#494](https://github.com/operator-framework/operator-lifecycle-manager/pull/494) ([alecmerdler](https://github.com/alecmerdler))
- refine cluster-admin OLM workflow [\#482](https://github.com/operator-framework/operator-lifecycle-manager/pull/482) ([madorn](https://github.com/madorn))
- add OperatorGroup [\#480](https://github.com/operator-framework/operator-lifecycle-manager/pull/480) ([jpeeler](https://github.com/jpeeler))
- feat\(olm\): add RBAC requirements check for CSVs [\#479](https://github.com/operator-framework/operator-lifecycle-manager/pull/479) ([njhale](https://github.com/njhale))
- Allow resolving ClusterRoles [\#477](https://github.com/operator-framework/operator-lifecycle-manager/pull/477) ([ecordell](https://github.com/ecordell))
- Implement Watch for `PackageManifest` API [\#476](https://github.com/operator-framework/operator-lifecycle-manager/pull/476) ([alecmerdler](https://github.com/alecmerdler))

**Fixed bugs:**

- OLM Unable to Upgrade Through Multiple Versions [\#755](https://github.com/operator-framework/operator-lifecycle-manager/issues/755)
- Subscription steps through multiple upgrades [\#761](https://github.com/operator-framework/operator-lifecycle-manager/pull/761) ([ecordell](https://github.com/ecordell))
- Fix typo - k8s version format [\#760](https://github.com/operator-framework/operator-lifecycle-manager/pull/760) ([tlwu2013](https://github.com/tlwu2013))
- fix\(csv\): properly detect apiservice and crd conflicts [\#758](https://github.com/operator-framework/operator-lifecycle-manager/pull/758) ([njhale](https://github.com/njhale))
- Emit `InstallSucceeded` Event for CSV [\#749](https://github.com/operator-framework/operator-lifecycle-manager/pull/749) ([alecmerdler](https://github.com/alecmerdler))
- fix\(packageserver\): set packageserver to IfNotPresent [\#738](https://github.com/operator-framework/operator-lifecycle-manager/pull/738) ([ecordell](https://github.com/ecordell))
- fix\(installmodes\): update support logic to match expected behavior [\#733](https://github.com/operator-framework/operator-lifecycle-manager/pull/733) ([njhale](https://github.com/njhale))
- fix\(packagesever\): add missing name field to api definition [\#731](https://github.com/operator-framework/operator-lifecycle-manager/pull/731) ([ecordell](https://github.com/ecordell))
- fix\(owners\): remove cross-namespace and cluster-\>namespace ownerrefs [\#729](https://github.com/operator-framework/operator-lifecycle-manager/pull/729) ([ecordell](https://github.com/ecordell))
- fix\(csv\): remove regex on base64 image data [\#723](https://github.com/operator-framework/operator-lifecycle-manager/pull/723) ([ecordell](https://github.com/ecordell))
- fix\(ocp\): add csv and deployment for package server [\#722](https://github.com/operator-framework/operator-lifecycle-manager/pull/722) ([jpeeler](https://github.com/jpeeler))
- Fix API Validation for `OperatorGroup` Spec [\#716](https://github.com/operator-framework/operator-lifecycle-manager/pull/716) ([alecmerdler](https://github.com/alecmerdler))
- fix\(manifests\): start manifest file names with 0000\_50\_olm\_\* [\#712](https://github.com/operator-framework/operator-lifecycle-manager/pull/712) ([njhale](https://github.com/njhale))
- fix\(olm\): properly detect cluster operator API [\#710](https://github.com/operator-framework/operator-lifecycle-manager/pull/710) ([jpeeler](https://github.com/jpeeler))
- fix\(registry-pods\): add everything toleration to registry pods [\#708](https://github.com/operator-framework/operator-lifecycle-manager/pull/708) ([njhale](https://github.com/njhale))
- Make e2e more robust [\#703](https://github.com/operator-framework/operator-lifecycle-manager/pull/703) ([jpeeler](https://github.com/jpeeler))
- fix\(deploy\): Add a component prefix to manifests [\#702](https://github.com/operator-framework/operator-lifecycle-manager/pull/702) ([smarterclayton](https://github.com/smarterclayton))
- fix\(csv\): only allow one CSV per provided API across intersecting operatorgroups [\#701](https://github.com/operator-framework/operator-lifecycle-manager/pull/701) ([njhale](https://github.com/njhale))
- fix\(olm\): Remove the "v" prefix in minKubeVersion if presents [\#699](https://github.com/operator-framework/operator-lifecycle-manager/pull/699) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Fix README.md links for CRDs, Descriptor, and Package [\#695](https://github.com/operator-framework/operator-lifecycle-manager/pull/695) ([ron1](https://github.com/ron1))
- fix\(olm\): Fix CSVs api-servers battle for ownership of APIServices [\#690](https://github.com/operator-framework/operator-lifecycle-manager/pull/690) ([dinhxuanvu](https://github.com/dinhxuanvu))
- fix\(subscriptions\): fix race between subscription sync and cache [\#689](https://github.com/operator-framework/operator-lifecycle-manager/pull/689) ([njhale](https://github.com/njhale))
- fix\(reconciler\): set command in pod spec of registry images [\#688](https://github.com/operator-framework/operator-lifecycle-manager/pull/688) ([ecordell](https://github.com/ecordell))
- fix\(permissions\): Generate unique Names for permissions [\#687](https://github.com/operator-framework/operator-lifecycle-manager/pull/687) ([ecordell](https://github.com/ecordell))
- Correct URL for Package Server CSV Link [\#685](https://github.com/operator-framework/operator-lifecycle-manager/pull/685) ([alecmerdler](https://github.com/alecmerdler))
- Ensure Owner References on ConfigMaps for CatalogSources  [\#681](https://github.com/operator-framework/operator-lifecycle-manager/pull/681) ([alecmerdler](https://github.com/alecmerdler))
- fix\(cm-reconciler\): query for pods to overwrite by CatalogSource label [\#680](https://github.com/operator-framework/operator-lifecycle-manager/pull/680) ([njhale](https://github.com/njhale))
- fix\(installplan\): fix bug where too many installplans can be created [\#679](https://github.com/operator-framework/operator-lifecycle-manager/pull/679) ([ecordell](https://github.com/ecordell))
- fix\(subscriptions\): respect startingCSV [\#676](https://github.com/operator-framework/operator-lifecycle-manager/pull/676) ([njhale](https://github.com/njhale))
- Add view role verbs to admin/edit role aggregation.  [\#673](https://github.com/operator-framework/operator-lifecycle-manager/pull/673) ([cliles](https://github.com/cliles))
- add view rbac to 'admin' and 'edit' default roles [\#671](https://github.com/operator-framework/operator-lifecycle-manager/pull/671) ([aweiteka](https://github.com/aweiteka))
- fix\(packageserver\): don't error out when listing [\#667](https://github.com/operator-framework/operator-lifecycle-manager/pull/667) ([njhale](https://github.com/njhale))
- fix\(operatorgroups\): use copied csv for update status [\#665](https://github.com/operator-framework/operator-lifecycle-manager/pull/665) ([njhale](https://github.com/njhale))
- fix\(deploy\): add linux nodeselector [\#653](https://github.com/operator-framework/operator-lifecycle-manager/pull/653) ([ecordell](https://github.com/ecordell))
- fix\(metrics\): remove resources that aren't updated [\#637](https://github.com/operator-framework/operator-lifecycle-manager/pull/637) ([jpeeler](https://github.com/jpeeler))
- fix\(crds\): remove category all from CRDs [\#636](https://github.com/operator-framework/operator-lifecycle-manager/pull/636) ([ecordell](https://github.com/ecordell))
- fix\(charts\): add operator\_namespace to run-local values [\#634](https://github.com/operator-framework/operator-lifecycle-manager/pull/634) ([njhale](https://github.com/njhale))
- fix\(deploy\): add runlevel to openshift-operators [\#620](https://github.com/operator-framework/operator-lifecycle-manager/pull/620) ([ecordell](https://github.com/ecordell))
- fix\(olm\): don't annotate target namespace on copied CSVs [\#616](https://github.com/operator-framework/operator-lifecycle-manager/pull/616) ([jpeeler](https://github.com/jpeeler))
- fix\(e2e\): make operator group test more robust [\#603](https://github.com/operator-framework/operator-lifecycle-manager/pull/603) ([jpeeler](https://github.com/jpeeler))
- fix\(e2e\): fix CSV tests [\#599](https://github.com/operator-framework/operator-lifecycle-manager/pull/599) ([njhale](https://github.com/njhale))
- Fix a typo in documentation [\#596](https://github.com/operator-framework/operator-lifecycle-manager/pull/596) ([smanpathak](https://github.com/smanpathak))
- Fix `client-go` Dependency [\#592](https://github.com/operator-framework/operator-lifecycle-manager/pull/592) ([alecmerdler](https://github.com/alecmerdler))
- Fix Panic in PackageManifest Server [\#590](https://github.com/operator-framework/operator-lifecycle-manager/pull/590) ([alecmerdler](https://github.com/alecmerdler))
- fix\(annotations\): merge CSV and pod template annotations when installing deployments [\#585](https://github.com/operator-framework/operator-lifecycle-manager/pull/585) ([njhale](https://github.com/njhale))
- Add `packagemanifest:aggregated-apiserver-clusterrole` [\#583](https://github.com/operator-framework/operator-lifecycle-manager/pull/583) ([alecmerdler](https://github.com/alecmerdler))
- fix\(csv-requeue\): requeue on namespace all if all namespaces are watched [\#572](https://github.com/operator-framework/operator-lifecycle-manager/pull/572) ([njhale](https://github.com/njhale))
- Fix Go Modules  [\#561](https://github.com/operator-framework/operator-lifecycle-manager/pull/561) ([alecmerdler](https://github.com/alecmerdler))
- fix\(queueInformers\): use separate queue for each namespace [\#560](https://github.com/operator-framework/operator-lifecycle-manager/pull/560) ([njhale](https://github.com/njhale))
- fix\(olm\): set lister up for deployments [\#550](https://github.com/operator-framework/operator-lifecycle-manager/pull/550) ([jpeeler](https://github.com/jpeeler))
- Fix olm pod name so log to be written correctly to olm.log [\#549](https://github.com/operator-framework/operator-lifecycle-manager/pull/549) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Fix template values for 'olm' parameters [\#537](https://github.com/operator-framework/operator-lifecycle-manager/pull/537) ([rhuss](https://github.com/rhuss))
- fix\(e2e\): switch to port 5443 for owned apiservice test [\#527](https://github.com/operator-framework/operator-lifecycle-manager/pull/527) ([njhale](https://github.com/njhale))
- fix\(package-server\): make secure port configurable and default to 5443 [\#524](https://github.com/operator-framework/operator-lifecycle-manager/pull/524) ([ecordell](https://github.com/ecordell))
- fix\(olm\): don't annotate namespaces on operator creation [\#523](https://github.com/operator-framework/operator-lifecycle-manager/pull/523) ([ecordell](https://github.com/ecordell))
- fix\(build\): add cleanup for package release files [\#517](https://github.com/operator-framework/operator-lifecycle-manager/pull/517) ([jpeeler](https://github.com/jpeeler))
- fix\(metrics\): use CRD client instead of k8s [\#515](https://github.com/operator-framework/operator-lifecycle-manager/pull/515) ([jpeeler](https://github.com/jpeeler))
- fix\(requirements\): add support for non resource url rules [\#514](https://github.com/operator-framework/operator-lifecycle-manager/pull/514) ([njhale](https://github.com/njhale))
- Rewrite Namespace when Fetching Global PackageManifests [\#513](https://github.com/operator-framework/operator-lifecycle-manager/pull/513) ([alecmerdler](https://github.com/alecmerdler))
- Small log statement fix with olm requirements [\#508](https://github.com/operator-framework/operator-lifecycle-manager/pull/508) ([eriknelson](https://github.com/eriknelson))
- fix\(requirements\): remove extra empty permission requirement statuses [\#506](https://github.com/operator-framework/operator-lifecycle-manager/pull/506) ([njhale](https://github.com/njhale))
- fix\(ci\): use deployment namespace for catalog\_namespace [\#504](https://github.com/operator-framework/operator-lifecycle-manager/pull/504) ([njhale](https://github.com/njhale))
- fix 30\_14-imagestream.yaml formatting [\#500](https://github.com/operator-framework/operator-lifecycle-manager/pull/500) ([mrogers950](https://github.com/mrogers950))
- Add missing binary to fix run-local-shift [\#497](https://github.com/operator-framework/operator-lifecycle-manager/pull/497) ([font](https://github.com/font))
- feat\(csv\): install owned APIServices [\#492](https://github.com/operator-framework/operator-lifecycle-manager/pull/492) ([njhale](https://github.com/njhale))
- fix\(build\): don't vendor [\#490](https://github.com/operator-framework/operator-lifecycle-manager/pull/490) ([ecordell](https://github.com/ecordell))
- fix\(deploy\): yaml error in imagereferences [\#486](https://github.com/operator-framework/operator-lifecycle-manager/pull/486) ([ecordell](https://github.com/ecordell))
- fix\(deploy\): only use replace on configmaps [\#483](https://github.com/operator-framework/operator-lifecycle-manager/pull/483) ([ecordell](https://github.com/ecordell))

**Closed issues:**

- Continuous Delivery via OLM [\#742](https://github.com/operator-framework/operator-lifecycle-manager/issues/742)
- Operator install plans fail w/repeat count regexp parsing error with OLM 0.8.1+ on OCP 3.11 [\#735](https://github.com/operator-framework/operator-lifecycle-manager/issues/735)
- Generated aggregated cluster roles contains group id in resource name [\#730](https://github.com/operator-framework/operator-lifecycle-manager/issues/730)
- package server panic when deploying operator source from operator-marketplace [\#728](https://github.com/operator-framework/operator-lifecycle-manager/issues/728)
- Help needed with CR display name [\#725](https://github.com/operator-framework/operator-lifecycle-manager/issues/725)
- OLM complains with "Policy rule not satisfied for service account" [\#724](https://github.com/operator-framework/operator-lifecycle-manager/issues/724)
- operator does not upgrade packagserver [\#706](https://github.com/operator-framework/operator-lifecycle-manager/issues/706)
- Unable to deploy OLM on minishift [\#705](https://github.com/operator-framework/operator-lifecycle-manager/issues/705)
- How to enable all workspaces so that OLM watches them? [\#698](https://github.com/operator-framework/operator-lifecycle-manager/issues/698)
- README links to CRDs, Descriptors, and Packages are broken [\#694](https://github.com/operator-framework/operator-lifecycle-manager/issues/694)
- MountVolume.SetUp failed for volume "config-volume" : secrets "alertmanager-alertmanager-main" not found [\#648](https://github.com/operator-framework/operator-lifecycle-manager/issues/648)
- Use CR definitions instead of configmap data [\#644](https://github.com/operator-framework/operator-lifecycle-manager/issues/644)
- `make run-local` for Minikube fails with "packageserver" deployment failure [\#642](https://github.com/operator-framework/operator-lifecycle-manager/issues/642)
- Question: instalingl the OLM via the CVO [\#628](https://github.com/operator-framework/operator-lifecycle-manager/issues/628)
- change catalog operator default namespace [\#627](https://github.com/operator-framework/operator-lifecycle-manager/issues/627)
- manifests: OLM is creating a namespace without run-level [\#619](https://github.com/operator-framework/operator-lifecycle-manager/issues/619)
- Non operator-sdk operators [\#610](https://github.com/operator-framework/operator-lifecycle-manager/issues/610)
- Unable to retrieve pull secret openshift-operator-lifecycle-manager/coreos-pull-secret for openshift-operator-lifecycle-manager/olm-operator... [\#607](https://github.com/operator-framework/operator-lifecycle-manager/issues/607)
- package-server pod keeps crashing [\#598](https://github.com/operator-framework/operator-lifecycle-manager/issues/598)
- OLM GUI does not have permission to list its OLM CRDs [\#597](https://github.com/operator-framework/operator-lifecycle-manager/issues/597)
- OLM compatibility with cluster monitoring Operator  [\#581](https://github.com/operator-framework/operator-lifecycle-manager/issues/581)
- ClusterRoleBinding against aggregated-apiserver-clusterrole without role manifest [\#577](https://github.com/operator-framework/operator-lifecycle-manager/issues/577)
- Failed to update catalog source `rh-operators` status [\#544](https://github.com/operator-framework/operator-lifecycle-manager/issues/544)
- Latest console image is broken [\#540](https://github.com/operator-framework/operator-lifecycle-manager/issues/540)
- Question: How to "enable" the OLM in the console for Minishift ? [\#538](https://github.com/operator-framework/operator-lifecycle-manager/issues/538)
- olm-operator local run expects `master` image tag which is unavailable [\#529](https://github.com/operator-framework/operator-lifecycle-manager/issues/529)
- CSV waits for wrong CRD version to be available [\#507](https://github.com/operator-framework/operator-lifecycle-manager/issues/507)
- Add support for specifying multiple CRDs in one yaml file [\#495](https://github.com/operator-framework/operator-lifecycle-manager/issues/495)
- make run-local-shift fails on minishift due to the lack of helm [\#488](https://github.com/operator-framework/operator-lifecycle-manager/issues/488)
- CSV support for ClusterRoles [\#473](https://github.com/operator-framework/operator-lifecycle-manager/issues/473)

**Other changes:**

- docs\(git\): add changelog [\#765](https://github.com/operator-framework/operator-lifecycle-manager/pull/765) ([njhale](https://github.com/njhale))
- chore\(manifests\): regenerate manifests to include new anyOf validation [\#744](https://github.com/operator-framework/operator-lifecycle-manager/pull/744) ([njhale](https://github.com/njhale))
- docs: update CSV link [\#713](https://github.com/operator-framework/operator-lifecycle-manager/pull/713) ([robszumski](https://github.com/robszumski))
- chore\(deploy\): use downstream image for openshift builds [\#693](https://github.com/operator-framework/operator-lifecycle-manager/pull/693) ([ecordell](https://github.com/ecordell))
- chore\(modules\): update operator-registry module to v1.0.6 [\#691](https://github.com/operator-framework/operator-lifecycle-manager/pull/691) ([njhale](https://github.com/njhale))
- Add godoc for InstallModeTypes [\#683](https://github.com/operator-framework/operator-lifecycle-manager/pull/683) ([pmorie](https://github.com/pmorie))
- chore\(deploy\): change 30 prefix to 50 [\#678](https://github.com/operator-framework/operator-lifecycle-manager/pull/678) ([ecordell](https://github.com/ecordell))
- Cut 0.8.1 [\#662](https://github.com/operator-framework/operator-lifecycle-manager/pull/662) ([ecordell](https://github.com/ecordell))
- Update metering InstallModes to support SingleNamespace [\#658](https://github.com/operator-framework/operator-lifecycle-manager/pull/658) ([chancez](https://github.com/chancez))
- chore\(ci\): remove ci checks for PRs [\#654](https://github.com/operator-framework/operator-lifecycle-manager/pull/654) ([ecordell](https://github.com/ecordell))
- Remove operatorsource installation [\#651](https://github.com/operator-framework/operator-lifecycle-manager/pull/651) ([kevinrizza](https://github.com/kevinrizza))
- update Service Catalog memory & cpu limits [\#649](https://github.com/operator-framework/operator-lifecycle-manager/pull/649) ([jboyd01](https://github.com/jboyd01))
- Add Metering Operator to catalog [\#647](https://github.com/operator-framework/operator-lifecycle-manager/pull/647) ([EmilyM1](https://github.com/EmilyM1))
- fix 1663113. Add component image ENV vars to cluster-logging-operator [\#645](https://github.com/operator-framework/operator-lifecycle-manager/pull/645) ([jcantrill](https://github.com/jcantrill))
- Updated MongoDB Operator to 0.6 [\#641](https://github.com/operator-framework/operator-lifecycle-manager/pull/641) ([rodrigovalin](https://github.com/rodrigovalin))
- chore\(fake\): add fake for registry client [\#630](https://github.com/operator-framework/operator-lifecycle-manager/pull/630) ([ecordell](https://github.com/ecordell))
- increase memory limits on all service catalog pods [\#629](https://github.com/operator-framework/operator-lifecycle-manager/pull/629) ([jboyd01](https://github.com/jboyd01))
- Install operatorsource crd and default cr [\#622](https://github.com/operator-framework/operator-lifecycle-manager/pull/622) ([kevinrizza](https://github.com/kevinrizza))
- Updated CSV marketplace manifests [\#621](https://github.com/operator-framework/operator-lifecycle-manager/pull/621) ([ecordell](https://github.com/ecordell))
- add rbac for servicebindings/finalizers [\#615](https://github.com/operator-framework/operator-lifecycle-manager/pull/615) ([jboyd01](https://github.com/jboyd01))
- Regen manifests [\#611](https://github.com/operator-framework/operator-lifecycle-manager/pull/611) ([ecordell](https://github.com/ecordell))
- Descheduler operator CRD, CSV [\#584](https://github.com/operator-framework/operator-lifecycle-manager/pull/584) ([ravisantoshgudimetla](https://github.com/ravisantoshgudimetla))
- chore\(docs\): fix markdown lint warnings [\#574](https://github.com/operator-framework/operator-lifecycle-manager/pull/574) ([jpeeler](https://github.com/jpeeler))
- docs\(arch\): add operator groups [\#573](https://github.com/operator-framework/operator-lifecycle-manager/pull/573) ([jpeeler](https://github.com/jpeeler))
- Creating csv, crd, and packages for clusterlogging and elasticsearch … [\#570](https://github.com/operator-framework/operator-lifecycle-manager/pull/570) ([jcantrill](https://github.com/jcantrill))
- Cut 0.8.0 [\#567](https://github.com/operator-framework/operator-lifecycle-manager/pull/567) ([ecordell](https://github.com/ecordell))
- chore\(build\): remove vendor commands from base dockerfile [\#566](https://github.com/operator-framework/operator-lifecycle-manager/pull/566) ([ecordell](https://github.com/ecordell))
- chore\(release\): bump version to 0.8.0 [\#565](https://github.com/operator-framework/operator-lifecycle-manager/pull/565) ([ecordell](https://github.com/ecordell))
- Service Catalog CSV: update resource limitations [\#562](https://github.com/operator-framework/operator-lifecycle-manager/pull/562) ([jboyd01](https://github.com/jboyd01))
- Update AMQ logo to new brand standard [\#547](https://github.com/operator-framework/operator-lifecycle-manager/pull/547) ([rhamilto](https://github.com/rhamilto))
- use OpenShift's ServiceCatalog build, update rbac + more [\#545](https://github.com/operator-framework/operator-lifecycle-manager/pull/545) ([jboyd01](https://github.com/jboyd01))
- Add Service to Owned Resources for Prometheus Operator [\#539](https://github.com/operator-framework/operator-lifecycle-manager/pull/539) ([alecmerdler](https://github.com/alecmerdler))
- Add `ConfigMap` as an Owned Resource for Prometheus [\#535](https://github.com/operator-framework/operator-lifecycle-manager/pull/535) ([alecmerdler](https://github.com/alecmerdler))
- chore\(release\): cut release 0.7.4 [\#534](https://github.com/operator-framework/operator-lifecycle-manager/pull/534) ([njhale](https://github.com/njhale))
- chore\(release\): bump version number to 0.7.4 [\#533](https://github.com/operator-framework/operator-lifecycle-manager/pull/533) ([njhale](https://github.com/njhale))
- \[Doc\] Add note about helm binary requirement [\#528](https://github.com/operator-framework/operator-lifecycle-manager/pull/528) ([aditya-konarde](https://github.com/aditya-konarde))
- chore\(package-server\): enable auth by default [\#526](https://github.com/operator-framework/operator-lifecycle-manager/pull/526) ([njhale](https://github.com/njhale))
- More Descriptors for Dynatrace Operator [\#522](https://github.com/operator-framework/operator-lifecycle-manager/pull/522) ([alecmerdler](https://github.com/alecmerdler))
- More Descriptors for Couchbase Operator [\#520](https://github.com/operator-framework/operator-lifecycle-manager/pull/520) ([alecmerdler](https://github.com/alecmerdler))
- Update OKD install instructions [\#519](https://github.com/operator-framework/operator-lifecycle-manager/pull/519) ([font](https://github.com/font))
- bump 0.7.3 [\#512](https://github.com/operator-framework/operator-lifecycle-manager/pull/512) ([ecordell](https://github.com/ecordell))
- chore\(deploy\): update release scripts to not use 3 different images [\#510](https://github.com/operator-framework/operator-lifecycle-manager/pull/510) ([ecordell](https://github.com/ecordell))
- chore\(deploy\): put all binaries in the same image [\#509](https://github.com/operator-framework/operator-lifecycle-manager/pull/509) ([ecordell](https://github.com/ecordell))
- chore\(deploy\): use runlevel label on namespace [\#503](https://github.com/operator-framework/operator-lifecycle-manager/pull/503) ([smarterclayton](https://github.com/smarterclayton))
- add example and additional info about optional CSV metadata  \(replace… [\#501](https://github.com/operator-framework/operator-lifecycle-manager/pull/501) ([madorn](https://github.com/madorn))
- Fix for Federation CSV [\#498](https://github.com/operator-framework/operator-lifecycle-manager/pull/498) ([alecmerdler](https://github.com/alecmerdler))
- Dropping label for origin releasepayload [\#496](https://github.com/operator-framework/operator-lifecycle-manager/pull/496) ([abhinavdahiya](https://github.com/abhinavdahiya))
- fix\(deploy\): add base images for ci-operator [\#493](https://github.com/operator-framework/operator-lifecycle-manager/pull/493) ([ecordell](https://github.com/ecordell))
- rh-operators: add FederationV2 v0.0.2 [\#491](https://github.com/operator-framework/operator-lifecycle-manager/pull/491) ([font](https://github.com/font))
- change go build to use 1.10 [\#489](https://github.com/operator-framework/operator-lifecycle-manager/pull/489) ([jpeeler](https://github.com/jpeeler))
- Revert "fix\(deploy\): remove package-server until ci-operator is outpu… [\#487](https://github.com/operator-framework/operator-lifecycle-manager/pull/487) ([ecordell](https://github.com/ecordell))
- re-cut 0.7.1 [\#484](https://github.com/operator-framework/operator-lifecycle-manager/pull/484) ([ecordell](https://github.com/ecordell))
- certified-operators: rectify form of business for Dynatrace [\#478](https://github.com/operator-framework/operator-lifecycle-manager/pull/478) ([baichinger](https://github.com/baichinger))
- Cut 0.7.1 [\#475](https://github.com/operator-framework/operator-lifecycle-manager/pull/475) ([ecordell](https://github.com/ecordell))

## [0.7.1](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.7.1) (2018-09-19)
[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.7.0...0.7.1)

**Closed issues:**

- Tag "master" of quay.io/coreos/package-server does not exist [\#471](https://github.com/operator-framework/operator-lifecycle-manager/issues/471)

**Other changes:**

- feat\(ci\): push tags to quay [\#474](https://github.com/operator-framework/operator-lifecycle-manager/pull/474) ([ecordell](https://github.com/ecordell))

## [0.7.0](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.7.0) (2018-09-19)
[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/v3.11.0...0.7.0)

**Closed issues:**

- minishift steps need to be updated for service catalog [\#469](https://github.com/operator-framework/operator-lifecycle-manager/issues/469)
- The `--service-catalog` clusterup option is invalid for OS 3.10+ [\#468](https://github.com/operator-framework/operator-lifecycle-manager/issues/468)
- `The ConfigMap "rh-operators" is invalid` while installing on upstream k8s [\#467](https://github.com/operator-framework/operator-lifecycle-manager/issues/467)

**Other changes:**

- 0.7.0 packages api [\#472](https://github.com/operator-framework/operator-lifecycle-manager/pull/472) ([ecordell](https://github.com/ecordell))
- Issue \#469 update the service catalog instruction for minishift. [\#470](https://github.com/operator-framework/operator-lifecycle-manager/pull/470) ([praveenkumar](https://github.com/praveenkumar))
- Documentation: Change to full path [\#466](https://github.com/operator-framework/operator-lifecycle-manager/pull/466) ([LiliC](https://github.com/LiliC))
- All Namespaces Support for PackageManifest API  [\#465](https://github.com/operator-framework/operator-lifecycle-manager/pull/465) ([alecmerdler](https://github.com/alecmerdler))
- Create OWNERS [\#464](https://github.com/operator-framework/operator-lifecycle-manager/pull/464) ([ecordell](https://github.com/ecordell))
- test\(e2e\): add OwnerReference GC behavior test [\#463](https://github.com/operator-framework/operator-lifecycle-manager/pull/463) ([njhale](https://github.com/njhale))
- Cut 0.7.0 [\#462](https://github.com/operator-framework/operator-lifecycle-manager/pull/462) ([ecordell](https://github.com/ecordell))
- List out options for Descriptors [\#461](https://github.com/operator-framework/operator-lifecycle-manager/pull/461) ([madorn](https://github.com/madorn))
- cut 0.7.0 images [\#460](https://github.com/operator-framework/operator-lifecycle-manager/pull/460) ([ecordell](https://github.com/ecordell))
- feat\(olm\): support depending on APIservices [\#459](https://github.com/operator-framework/operator-lifecycle-manager/pull/459) ([ecordell](https://github.com/ecordell))
- Improvements on the MongoDB Enterprise Operator CSV. [\#458](https://github.com/operator-framework/operator-lifecycle-manager/pull/458) ([rodrigovalin](https://github.com/rodrigovalin))
- \[WIP\] feat\(catalog\): add RBAC step resolution [\#457](https://github.com/operator-framework/operator-lifecycle-manager/pull/457) ([njhale](https://github.com/njhale))
- add metrics [\#452](https://github.com/operator-framework/operator-lifecycle-manager/pull/452) ([jpeeler](https://github.com/jpeeler))

## [v3.11.0](https://github.com/operator-framework/operator-lifecycle-manager/tree/v3.11.0) (2018-09-13)
[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.6.0...v3.11.0)

**Implemented enhancements:**

- Instructions for Running OLM UI [\#431](https://github.com/operator-framework/operator-lifecycle-manager/pull/431) ([alecmerdler](https://github.com/alecmerdler))
- Action Descriptors [\#426](https://github.com/operator-framework/operator-lifecycle-manager/pull/426) ([alecmerdler](https://github.com/alecmerdler))

**Fixed bugs:**

- `./scripts/run\_console\_local.sh` doesn't provide a usable console with `make run-local` or `make run-local-shift` [\#437](https://github.com/operator-framework/operator-lifecycle-manager/issues/437)

**Closed issues:**

- Can't deploy OLM onto OpenShift [\#436](https://github.com/operator-framework/operator-lifecycle-manager/issues/436)
- Creation of CRD defined in 05-catalogsource.crd.yaml fails [\#416](https://github.com/operator-framework/operator-lifecycle-manager/issues/416)

**Other changes:**

- fix\(vendor\): revendor dependencies [\#456](https://github.com/operator-framework/operator-lifecycle-manager/pull/456) ([njhale](https://github.com/njhale))
- fix\(vendor\): revendor dependencies [\#455](https://github.com/operator-framework/operator-lifecycle-manager/pull/455) ([njhale](https://github.com/njhale))
- feat\(olm\): attempt to cleanup namespace annotations on shutdown [\#454](https://github.com/operator-framework/operator-lifecycle-manager/pull/454) ([ecordell](https://github.com/ecordell))
- feat\(olm\): attempt to cleanup namespace annotations on shutdown [\#453](https://github.com/operator-framework/operator-lifecycle-manager/pull/453) ([ecordell](https://github.com/ecordell))
- \[WIP\] fix\(ci\): add pipeline queueing [\#451](https://github.com/operator-framework/operator-lifecycle-manager/pull/451) ([njhale](https://github.com/njhale))
- fix\(prometheus\): add securityContext to alertmanager example [\#450](https://github.com/operator-framework/operator-lifecycle-manager/pull/450) ([ecordell](https://github.com/ecordell))
- docs: install OLM with 'kubectl create -f' instead of 'kubectl apply -f' [\#449](https://github.com/operator-framework/operator-lifecycle-manager/pull/449) ([djwhatle](https://github.com/djwhatle))
- feat\(cmd\): add version flags  [\#448](https://github.com/operator-framework/operator-lifecycle-manager/pull/448) ([njhale](https://github.com/njhale))
- feat\(catalog\): add aggregated roles for each resolved CRD [\#447](https://github.com/operator-framework/operator-lifecycle-manager/pull/447) ([ecordell](https://github.com/ecordell))
- docs: add CSV guide [\#446](https://github.com/operator-framework/operator-lifecycle-manager/pull/446) ([robszumski](https://github.com/robszumski))
- feat\(run\_console\_local\): add docker pull for console image [\#445](https://github.com/operator-framework/operator-lifecycle-manager/pull/445) ([njhale](https://github.com/njhale))
- chore\(rbac\): add olm-specific ClusterRole [\#444](https://github.com/operator-framework/operator-lifecycle-manager/pull/444) ([ecordell](https://github.com/ecordell))
- Remove outdated install instructions [\#443](https://github.com/operator-framework/operator-lifecycle-manager/pull/443) ([ecordell](https://github.com/ecordell))
- chore\(deploy\): remove ansible scripts for install [\#442](https://github.com/operator-framework/operator-lifecycle-manager/pull/442) ([ecordell](https://github.com/ecordell))
- Fix Local Console Script with Minikube [\#441](https://github.com/operator-framework/operator-lifecycle-manager/pull/441) ([alecmerdler](https://github.com/alecmerdler))
- Add/update CSVs for RH and partners [\#440](https://github.com/operator-framework/operator-lifecycle-manager/pull/440) ([robszumski](https://github.com/robszumski))
- feat\(osbs\): add non-multistage dockerfile [\#439](https://github.com/operator-framework/operator-lifecycle-manager/pull/439) ([njhale](https://github.com/njhale))
- Remove broker files for repo migration [\#438](https://github.com/operator-framework/operator-lifecycle-manager/pull/438) ([jpeeler](https://github.com/jpeeler))
- Allow use of existing KUBECONFIG env var for e2e [\#435](https://github.com/operator-framework/operator-lifecycle-manager/pull/435) ([jpeeler](https://github.com/jpeeler))
- \[WIP\] Package Extension API Server [\#433](https://github.com/operator-framework/operator-lifecycle-manager/pull/433) ([njhale](https://github.com/njhale))
- Separate internal API client wrappers from generated external clients [\#432](https://github.com/operator-framework/operator-lifecycle-manager/pull/432) ([ecordell](https://github.com/ecordell))
- Catalog renaming OCS -\> rh-operators [\#429](https://github.com/operator-framework/operator-lifecycle-manager/pull/429) ([ecordell](https://github.com/ecordell))
- Red Hat CD Readiness [\#428](https://github.com/operator-framework/operator-lifecycle-manager/pull/428) ([njhale](https://github.com/njhale))
- test\(e2e\): add catalog loading between operator restart test [\#427](https://github.com/operator-framework/operator-lifecycle-manager/pull/427) ([njhale](https://github.com/njhale))
- updated prometheus csv according to the integration into openshift [\#425](https://github.com/operator-framework/operator-lifecycle-manager/pull/425) ([sichvoge](https://github.com/sichvoge))
- fix\(catalog\): add check for loaded catalogs [\#424](https://github.com/operator-framework/operator-lifecycle-manager/pull/424) ([njhale](https://github.com/njhale))
- feat\(subscription\): add dedicated currentCSV field to subscription [\#423](https://github.com/operator-framework/operator-lifecycle-manager/pull/423) ([njhale](https://github.com/njhale))
- fix\(operatorclient\): remove wait for deployment rollout [\#422](https://github.com/operator-framework/operator-lifecycle-manager/pull/422) ([njhale](https://github.com/njhale))
- fix\(e2e\): remove deployment cleanup [\#421](https://github.com/operator-framework/operator-lifecycle-manager/pull/421) ([njhale](https://github.com/njhale))
- Set Status on Subscription with Invalid Catalog Source [\#420](https://github.com/operator-framework/operator-lifecycle-manager/pull/420) ([alecmerdler](https://github.com/alecmerdler))
- feat\(catalog\): add catalog status block updates [\#419](https://github.com/operator-framework/operator-lifecycle-manager/pull/419) ([njhale](https://github.com/njhale))
- Deployment fixes  [\#418](https://github.com/operator-framework/operator-lifecycle-manager/pull/418) ([ecordell](https://github.com/ecordell))
- Fixes \#416 [\#417](https://github.com/operator-framework/operator-lifecycle-manager/pull/417) ([mvazquezc](https://github.com/mvazquezc))
- \[WIP\] feat\(catalog\): add namespace awareness to plan execution [\#415](https://github.com/operator-framework/operator-lifecycle-manager/pull/415) ([njhale](https://github.com/njhale))
- Make key resources linkable in philosophy doc [\#414](https://github.com/operator-framework/operator-lifecycle-manager/pull/414) ([pmorie](https://github.com/pmorie))
- Cut 0.6.0 [\#413](https://github.com/operator-framework/operator-lifecycle-manager/pull/413) ([ecordell](https://github.com/ecordell))
- \[WIP\] feat\(resolver\): add namespace and channel awareness [\#402](https://github.com/operator-framework/operator-lifecycle-manager/pull/402) ([njhale](https://github.com/njhale))

## [0.6.0](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.6.0) (2018-08-07)
[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.5.0...0.6.0)

**Closed issues:**

- Attempting upstream installation against kube \>= 1.11 fails with validation errors [\#400](https://github.com/operator-framework/operator-lifecycle-manager/issues/400)
- make schema-check fails with missing vendored dependency [\#389](https://github.com/operator-framework/operator-lifecycle-manager/issues/389)

**Other changes:**

- chore\(vendor\): remove vendor directory [\#412](https://github.com/operator-framework/operator-lifecycle-manager/pull/412) ([ecordell](https://github.com/ecordell))
- fix\(e2e\) + fix\(csv upgrade\) + fix\(leak\) [\#411](https://github.com/operator-framework/operator-lifecycle-manager/pull/411) ([ecordell](https://github.com/ecordell))
- minor: broken link [\#408](https://github.com/operator-framework/operator-lifecycle-manager/pull/408) ([Jiri-Kremser](https://github.com/Jiri-Kremser))
- fix\(csv\): CSV update process optimization regression [\#407](https://github.com/operator-framework/operator-lifecycle-manager/pull/407) ([ecordell](https://github.com/ecordell))
- Use GroupVersionKind in Spec Descriptor for Selector [\#405](https://github.com/operator-framework/operator-lifecycle-manager/pull/405) ([alecmerdler](https://github.com/alecmerdler))
- Catalog Cleanup [\#404](https://github.com/operator-framework/operator-lifecycle-manager/pull/404) ([ecordell](https://github.com/ecordell))
- 1.11 updates [\#403](https://github.com/operator-framework/operator-lifecycle-manager/pull/403) ([ecordell](https://github.com/ecordell))
- test\(catalog\_versions\): add multi-catalogsource aware resolution tests [\#401](https://github.com/operator-framework/operator-lifecycle-manager/pull/401) ([njhale](https://github.com/njhale))
- Add CatalogSource Namespace To CRD Validation [\#399](https://github.com/operator-framework/operator-lifecycle-manager/pull/399) ([alecmerdler](https://github.com/alecmerdler))
- chore\(deps\): update k8s libs to 1.11 versions [\#398](https://github.com/operator-framework/operator-lifecycle-manager/pull/398) ([ecordell](https://github.com/ecordell))
- docs: add access control workflow [\#397](https://github.com/operator-framework/operator-lifecycle-manager/pull/397) ([robszumski](https://github.com/robszumski))
- test\(installplan\): multi source e2e [\#396](https://github.com/operator-framework/operator-lifecycle-manager/pull/396) ([njhale](https://github.com/njhale))
- chore\(ci\): update gitlab-ci.yml from jsonnet [\#395](https://github.com/operator-framework/operator-lifecycle-manager/pull/395) ([ecordell](https://github.com/ecordell))
- fix\(installplan\): type InstallPlan.Status.CatalogSources to \[\]string … [\#394](https://github.com/operator-framework/operator-lifecycle-manager/pull/394) ([njhale](https://github.com/njhale))
- Deploy CI to `operator-lifecycle-manager` Namespace [\#393](https://github.com/operator-framework/operator-lifecycle-manager/pull/393) ([alecmerdler](https://github.com/alecmerdler))
- Fix invalid `minishift start` option in build\_local\_shift.sh [\#392](https://github.com/operator-framework/operator-lifecycle-manager/pull/392) ([jsm84](https://github.com/jsm84))
- vendor: re-run `dep ensure` [\#390](https://github.com/operator-framework/operator-lifecycle-manager/pull/390) ([jzelinskie](https://github.com/jzelinskie))
- feat\(catalog\_resources\): add prometheus 0.22.1 [\#388](https://github.com/operator-framework/operator-lifecycle-manager/pull/388) ([ecordell](https://github.com/ecordell))
- feat\(catalog\): multiple CatalogSource resolution [\#386](https://github.com/operator-framework/operator-lifecycle-manager/pull/386) ([njhale](https://github.com/njhale))

## [0.5.0](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.5.0) (2018-07-23)
[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.4.0...0.5.0)

**Implemented enhancements:**

- Separate Manifest Validator [\#365](https://github.com/operator-framework/operator-lifecycle-manager/pull/365) ([alecmerdler](https://github.com/alecmerdler))
- Manual Approval of Install Plans [\#347](https://github.com/operator-framework/operator-lifecycle-manager/pull/347) ([alecmerdler](https://github.com/alecmerdler))
- GitLab CI Fix  [\#341](https://github.com/operator-framework/operator-lifecycle-manager/pull/341) ([alecmerdler](https://github.com/alecmerdler))

**Fixed bugs:**

- Prevent ownership conflicts for CRDs [\#375](https://github.com/operator-framework/operator-lifecycle-manager/pull/375) ([ecordell](https://github.com/ecordell))
- Fix InstallPlanReference in Subscription Status [\#359](https://github.com/operator-framework/operator-lifecycle-manager/pull/359) ([ecordell](https://github.com/ecordell))
- Fix Subscriptions being Updated Without Changes [\#357](https://github.com/operator-framework/operator-lifecycle-manager/pull/357) ([alecmerdler](https://github.com/alecmerdler))
- Slack Webhook Rename [\#337](https://github.com/operator-framework/operator-lifecycle-manager/pull/337) ([alecmerdler](https://github.com/alecmerdler))
- Clarify Status Condition when Catalog Source Not Found [\#335](https://github.com/operator-framework/operator-lifecycle-manager/pull/335) ([alecmerdler](https://github.com/alecmerdler))

**Closed issues:**

- Typos in architecture doc [\#376](https://github.com/operator-framework/operator-lifecycle-manager/issues/376)
- make manifests error when rendering templates with helm [\#369](https://github.com/operator-framework/operator-lifecycle-manager/issues/369)
- make run-local missing charts [\#368](https://github.com/operator-framework/operator-lifecycle-manager/issues/368)
- make run-local is broken [\#366](https://github.com/operator-framework/operator-lifecycle-manager/issues/366)
- make build fails [\#360](https://github.com/operator-framework/operator-lifecycle-manager/issues/360)
- vendoring fails when run `make vendor` [\#350](https://github.com/operator-framework/operator-lifecycle-manager/issues/350)

**Other changes:**

- fix SingleSourceResolver to use plan namespace for resolved CSVs [\#387](https://github.com/operator-framework/operator-lifecycle-manager/pull/387) ([njhale](https://github.com/njhale))
- Add CatalogSource Name to InstallPlan Steps [\#385](https://github.com/operator-framework/operator-lifecycle-manager/pull/385) ([njhale](https://github.com/njhale))
- Fix OpenShift Deploy CI [\#384](https://github.com/operator-framework/operator-lifecycle-manager/pull/384) ([alecmerdler](https://github.com/alecmerdler))
- Deploy to OpenShift Cluster [\#383](https://github.com/operator-framework/operator-lifecycle-manager/pull/383) ([alecmerdler](https://github.com/alecmerdler))
- fix\(docs\): correct spelling of philosopy.md [\#382](https://github.com/operator-framework/operator-lifecycle-manager/pull/382) ([aravindhp](https://github.com/aravindhp))
- Cut 0.5.0 [\#381](https://github.com/operator-framework/operator-lifecycle-manager/pull/381) ([ecordell](https://github.com/ecordell))
- Add CatalogSource Namespace to Subscription Objects [\#380](https://github.com/operator-framework/operator-lifecycle-manager/pull/380) ([alecmerdler](https://github.com/alecmerdler))
- fix\(docs\): typos in architecture.md [\#377](https://github.com/operator-framework/operator-lifecycle-manager/pull/377) ([ecordell](https://github.com/ecordell))
- Fix a small typo [\#374](https://github.com/operator-framework/operator-lifecycle-manager/pull/374) ([fabiand](https://github.com/fabiand))
- fix\(servicebroker\): add main\_test.go to servicebroker cmd [\#372](https://github.com/operator-framework/operator-lifecycle-manager/pull/372) ([ecordell](https://github.com/ecordell))
- fix\(make\): fixes run-local and run-local-shift [\#371](https://github.com/operator-framework/operator-lifecycle-manager/pull/371) ([ecordell](https://github.com/ecordell))
- Remove tectonic-operators [\#370](https://github.com/operator-framework/operator-lifecycle-manager/pull/370) ([ecordell](https://github.com/ecordell))
- fix\(make\): set version var for run-local [\#367](https://github.com/operator-framework/operator-lifecycle-manager/pull/367) ([ecordell](https://github.com/ecordell))
- Resolve Install Plan before Requiring Approval [\#364](https://github.com/operator-framework/operator-lifecycle-manager/pull/364) ([alecmerdler](https://github.com/alecmerdler))
- readme: fix broken link to CSV example [\#363](https://github.com/operator-framework/operator-lifecycle-manager/pull/363) ([robszumski](https://github.com/robszumski))
- Fix memory usage in catalog operator [\#362](https://github.com/operator-framework/operator-lifecycle-manager/pull/362) ([ecordell](https://github.com/ecordell))
- Tests for Runaway Control Loops [\#361](https://github.com/operator-framework/operator-lifecycle-manager/pull/361) ([alecmerdler](https://github.com/alecmerdler))
- Fix the deploy to kubernetes command in install.md [\#358](https://github.com/operator-framework/operator-lifecycle-manager/pull/358) ([aravindhp](https://github.com/aravindhp))
- Ansible playbook [\#356](https://github.com/operator-framework/operator-lifecycle-manager/pull/356) ([ecordell](https://github.com/ecordell))
- Add metering to a separate, upstream-only catalog [\#354](https://github.com/operator-framework/operator-lifecycle-manager/pull/354) ([ecordell](https://github.com/ecordell))
- chore\(deps\): commit vendored dependencies  [\#352](https://github.com/operator-framework/operator-lifecycle-manager/pull/352) ([ecordell](https://github.com/ecordell))
- feat\(servicebroker\): list one serviceclass per package [\#349](https://github.com/operator-framework/operator-lifecycle-manager/pull/349) ([ericavonb](https://github.com/ericavonb))
- Add installPlanApproval to Subscription-v1 [\#348](https://github.com/operator-framework/operator-lifecycle-manager/pull/348) ([ecordell](https://github.com/ecordell))
- Strip Markdown Descriptions from OSB [\#346](https://github.com/operator-framework/operator-lifecycle-manager/pull/346) ([alecmerdler](https://github.com/alecmerdler))
- test validate service broker api version function [\#345](https://github.com/operator-framework/operator-lifecycle-manager/pull/345) ([ericavonb](https://github.com/ericavonb))
- OSB Rebase \(part 2\) [\#344](https://github.com/operator-framework/operator-lifecycle-manager/pull/344) ([ecordell](https://github.com/ecordell))
- Rebased OSB backbone [\#342](https://github.com/operator-framework/operator-lifecycle-manager/pull/342) ([ecordell](https://github.com/ecordell))
- Update manifests for 0.4.0 release [\#340](https://github.com/operator-framework/operator-lifecycle-manager/pull/340) ([ecordell](https://github.com/ecordell))



\* *This Change Log was automatically generated by [github_changelog_generator](https://github.com/skywinder/Github-Changelog-Generator)*