#!/bin/sh
set -e

# Clone repository
git clone --branch master --depth 1 --single-branch --no-tags --config http.sslVerify=false https://code.engineering.redhat.com/gerrit/rhi-operator.git /workspace
cd /workspace

# Build the operator
CGO_ENABLED=0 GOOS=linux GOARCH=amd64 GO111MODULE=on go build -a -o manager main.go

# Creates a licenses directory and copies vendor licenses into it.
mkdir licenses
for lic in `find . \( -name "LICENSE*" -o -name "NOTICE*" \) | sed 's|^./||'`
do
    dir=licenses/`dirname $lic`
    mkdir -p $dir
    cp $lic $dir
done
