// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/keycloak/keycloak-operator/pkg/apis/keycloak/v1alpha1"
	scheme "github.com/keycloak/keycloak-operator/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// KeycloakRealmsGetter has a method to return a KeycloakRealmInterface.
// A group's client should implement this interface.
type KeycloakRealmsGetter interface {
	KeycloakRealms(namespace string) KeycloakRealmInterface
}

// KeycloakRealmInterface has methods to work with KeycloakRealm resources.
type KeycloakRealmInterface interface {
	Create(ctx context.Context, keycloakRealm *v1alpha1.KeycloakRealm, opts v1.CreateOptions) (*v1alpha1.KeycloakRealm, error)
	Update(ctx context.Context, keycloakRealm *v1alpha1.KeycloakRealm, opts v1.UpdateOptions) (*v1alpha1.KeycloakRealm, error)
	UpdateStatus(ctx context.Context, keycloakRealm *v1alpha1.KeycloakRealm, opts v1.UpdateOptions) (*v1alpha1.KeycloakRealm, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.KeycloakRealm, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.KeycloakRealmList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.KeycloakRealm, err error)
	KeycloakRealmExpansion
}

// keycloakRealms implements KeycloakRealmInterface
type keycloakRealms struct {
	client rest.Interface
	ns     string
}

// newKeycloakRealms returns a KeycloakRealms
func newKeycloakRealms(c *KeycloakV1alpha1Client, namespace string) *keycloakRealms {
	return &keycloakRealms{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the keycloakRealm, and returns the corresponding keycloakRealm object, and an error if there is any.
func (c *keycloakRealms) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.KeycloakRealm, err error) {
	result = &v1alpha1.KeycloakRealm{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("keycloakrealms").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of KeycloakRealms that match those selectors.
func (c *keycloakRealms) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.KeycloakRealmList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.KeycloakRealmList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("keycloakrealms").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested keycloakRealms.
func (c *keycloakRealms) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("keycloakrealms").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a keycloakRealm and creates it.  Returns the server's representation of the keycloakRealm, and an error, if there is any.
func (c *keycloakRealms) Create(ctx context.Context, keycloakRealm *v1alpha1.KeycloakRealm, opts v1.CreateOptions) (result *v1alpha1.KeycloakRealm, err error) {
	result = &v1alpha1.KeycloakRealm{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("keycloakrealms").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(keycloakRealm).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a keycloakRealm and updates it. Returns the server's representation of the keycloakRealm, and an error, if there is any.
func (c *keycloakRealms) Update(ctx context.Context, keycloakRealm *v1alpha1.KeycloakRealm, opts v1.UpdateOptions) (result *v1alpha1.KeycloakRealm, err error) {
	result = &v1alpha1.KeycloakRealm{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("keycloakrealms").
		Name(keycloakRealm.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(keycloakRealm).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *keycloakRealms) UpdateStatus(ctx context.Context, keycloakRealm *v1alpha1.KeycloakRealm, opts v1.UpdateOptions) (result *v1alpha1.KeycloakRealm, err error) {
	result = &v1alpha1.KeycloakRealm{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("keycloakrealms").
		Name(keycloakRealm.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(keycloakRealm).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the keycloakRealm and deletes it. Returns an error if one occurs.
func (c *keycloakRealms) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("keycloakrealms").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *keycloakRealms) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("keycloakrealms").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched keycloakRealm.
func (c *keycloakRealms) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.KeycloakRealm, err error) {
	result = &v1alpha1.KeycloakRealm{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("keycloakrealms").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
