# Strategic merge patch

When users need to apply a specific configuration to containers that we do not support or do not currently exist, merge patch can be used.
This document describes how to overwrite the container configuration generated by the operator by merging patches.

## How the "strategic merge patch" works

The operator supports `containers` field in `PrometheusSpec`, `AlertmanagerSpec` and `ThanosRulerSpec` configuration.
This field allows injecting additional containers, and the existing configuration can be overwritten by sharing the same container name.

### Merge patch example of Prometheus

The following manifest overwrites the `failureThreshold` value of the readiness probe for the Prometheus container.

```yaml
apiVersion: monitoring.coreos.com/v1
kind: Prometheus
metadata:
  labels:
    prometheus: self
  name: self
  namespace: default
spec:
  containers:
  - name: prometheus
    readinessProbe:
      failureThreshold: 500
```

### Merge patch example for Alertmanager

The following manifest overwrites the `failureThreshold` values of the readiness and liveness probes for the Alertmanager container.

```yaml
apiVersion: monitoring.coreos.com/v1
kind: Alertmanager
metadata:
  labels:
    alertmanager: main
  name: main
  namespace: monitoring
spec:
  containers:
  - name: alertmanager
    livenessProbe:
      failureThreshold: 5
    readinessProbe:
      failureThreshold: 5
```
