/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.prestosql.util;

import java.util.Optional;

public interface Mergeable<T>
{
    /**
     * Merges the current state with the state of the other instance, and returns the merged state.
     *
     * @throws NullPointerException if other is null
     */
    T mergeWith(T other);

    static <T extends Mergeable<T>> Optional<T> merge(Optional<T> first, Optional<T> second)
    {
        if (first.isPresent() && second.isPresent()) {
            return Optional.of(first.get().mergeWith(second.get()));
        }
        if (first.isPresent()) {
            return first;
        }

        return second;
    }
}
