/*
Copyright 2021 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1alpha1 "k8s.io/cloud-provider-vsphere/pkg/cloudprovider/vsphereparavirtual/apis/nsxnetworking/v1alpha1"
)

// RouteSetLister helps list RouteSets.
// All objects returned here must be treated as read-only.
type RouteSetLister interface {
	// List lists all RouteSets in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.RouteSet, err error)
	// RouteSets returns an object that can list and get RouteSets.
	RouteSets(namespace string) RouteSetNamespaceLister
	RouteSetListerExpansion
}

// routeSetLister implements the RouteSetLister interface.
type routeSetLister struct {
	indexer cache.Indexer
}

// NewRouteSetLister returns a new RouteSetLister.
func NewRouteSetLister(indexer cache.Indexer) RouteSetLister {
	return &routeSetLister{indexer: indexer}
}

// List lists all RouteSets in the indexer.
func (s *routeSetLister) List(selector labels.Selector) (ret []*v1alpha1.RouteSet, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.RouteSet))
	})
	return ret, err
}

// RouteSets returns an object that can list and get RouteSets.
func (s *routeSetLister) RouteSets(namespace string) RouteSetNamespaceLister {
	return routeSetNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// RouteSetNamespaceLister helps list and get RouteSets.
// All objects returned here must be treated as read-only.
type RouteSetNamespaceLister interface {
	// List lists all RouteSets in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.RouteSet, err error)
	// Get retrieves the RouteSet from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1alpha1.RouteSet, error)
	RouteSetNamespaceListerExpansion
}

// routeSetNamespaceLister implements the RouteSetNamespaceLister
// interface.
type routeSetNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all RouteSets in the indexer for a given namespace.
func (s routeSetNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.RouteSet, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.RouteSet))
	})
	return ret, err
}

// Get retrieves the RouteSet from the indexer for a given namespace and name.
func (s routeSetNamespaceLister) Get(name string) (*v1alpha1.RouteSet, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("routeset"), name)
	}
	return obj.(*v1alpha1.RouteSet), nil
}
