// Code generated by "go generate gonum.org/v1/gonum/unit”; DO NOT EDIT.

// Copyright ©2014 The Gonum Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package unit

import (
	"errors"
	"fmt"
	"math"
	"unicode/utf8"
)

// Pressure represents a pressure in Pascals.
type Pressure float64

const (
	Yottapascal Pressure = 1e24
	Zettapascal Pressure = 1e21
	Exapascal   Pressure = 1e18
	Petapascal  Pressure = 1e15
	Terapascal  Pressure = 1e12
	Gigapascal  Pressure = 1e9
	Megapascal  Pressure = 1e6
	Kilopascal  Pressure = 1e3
	Hectopascal Pressure = 1e2
	Decapascal  Pressure = 1e1
	Pascal      Pressure = 1.0
	Decipascal  Pressure = 1e-1
	Centipascal Pressure = 1e-2
	Millipascal Pressure = 1e-3
	Micropascal Pressure = 1e-6
	Nanopascal  Pressure = 1e-9
	Picopascal  Pressure = 1e-12
	Femtopascal Pressure = 1e-15
	Attopascal  Pressure = 1e-18
	Zeptopascal Pressure = 1e-21
	Yoctopascal Pressure = 1e-24
)

// Unit converts the Pressure to a *Unit
func (pr Pressure) Unit() *Unit {
	return New(float64(pr), Dimensions{
		LengthDim: -1,
		MassDim:   1,
		TimeDim:   -2,
	})
}

// Pressure allows Pressure to implement a Pressurer interface
func (pr Pressure) Pressure() Pressure {
	return pr
}

// From converts the unit into the receiver. From returns an
// error if there is a mismatch in dimension
func (pr *Pressure) From(u Uniter) error {
	if !DimensionsMatch(u, Pascal) {
		*pr = Pressure(math.NaN())
		return errors.New("Dimension mismatch")
	}
	*pr = Pressure(u.Unit().Value())
	return nil
}

func (pr Pressure) Format(fs fmt.State, c rune) {
	switch c {
	case 'v':
		if fs.Flag('#') {
			fmt.Fprintf(fs, "%T(%v)", pr, float64(pr))
			return
		}
		fallthrough
	case 'e', 'E', 'f', 'F', 'g', 'G':
		p, pOk := fs.Precision()
		w, wOk := fs.Width()
		const unit = " Pa"
		switch {
		case pOk && wOk:
			fmt.Fprintf(fs, "%*.*"+string(c), pos(w-utf8.RuneCount([]byte(unit))), p, float64(pr))
		case pOk:
			fmt.Fprintf(fs, "%.*"+string(c), p, float64(pr))
		case wOk:
			fmt.Fprintf(fs, "%*"+string(c), pos(w-utf8.RuneCount([]byte(unit))), float64(pr))
		default:
			fmt.Fprintf(fs, "%"+string(c), float64(pr))
		}
		fmt.Fprint(fs, unit)
	default:
		fmt.Fprintf(fs, "%%!%c(%T=%g Pa)", c, pr, float64(pr))
	}
}
