package backup

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/recoveryservices/mgmt/2019-06-15/backup"

// AzureFileShareType enumerates the values for azure file share type.
type AzureFileShareType string

const (
	// Invalid ...
	Invalid AzureFileShareType = "Invalid"
	// XSMB ...
	XSMB AzureFileShareType = "XSMB"
	// XSync ...
	XSync AzureFileShareType = "XSync"
)

// PossibleAzureFileShareTypeValues returns an array of possible values for the AzureFileShareType const type.
func PossibleAzureFileShareTypeValues() []AzureFileShareType {
	return []AzureFileShareType{Invalid, XSMB, XSync}
}

// ContainerType enumerates the values for container type.
type ContainerType string

const (
	// ContainerTypeAzureBackupServerContainer ...
	ContainerTypeAzureBackupServerContainer ContainerType = "AzureBackupServerContainer"
	// ContainerTypeAzureSQLContainer ...
	ContainerTypeAzureSQLContainer ContainerType = "AzureSqlContainer"
	// ContainerTypeCluster ...
	ContainerTypeCluster ContainerType = "Cluster"
	// ContainerTypeDPMContainer ...
	ContainerTypeDPMContainer ContainerType = "DPMContainer"
	// ContainerTypeGenericContainer ...
	ContainerTypeGenericContainer ContainerType = "GenericContainer"
	// ContainerTypeIaasVMContainer ...
	ContainerTypeIaasVMContainer ContainerType = "IaasVMContainer"
	// ContainerTypeIaasVMServiceContainer ...
	ContainerTypeIaasVMServiceContainer ContainerType = "IaasVMServiceContainer"
	// ContainerTypeInvalid ...
	ContainerTypeInvalid ContainerType = "Invalid"
	// ContainerTypeMABContainer ...
	ContainerTypeMABContainer ContainerType = "MABContainer"
	// ContainerTypeSQLAGWorkLoadContainer ...
	ContainerTypeSQLAGWorkLoadContainer ContainerType = "SQLAGWorkLoadContainer"
	// ContainerTypeStorageContainer ...
	ContainerTypeStorageContainer ContainerType = "StorageContainer"
	// ContainerTypeUnknown ...
	ContainerTypeUnknown ContainerType = "Unknown"
	// ContainerTypeVCenter ...
	ContainerTypeVCenter ContainerType = "VCenter"
	// ContainerTypeVMAppContainer ...
	ContainerTypeVMAppContainer ContainerType = "VMAppContainer"
	// ContainerTypeWindows ...
	ContainerTypeWindows ContainerType = "Windows"
)

// PossibleContainerTypeValues returns an array of possible values for the ContainerType const type.
func PossibleContainerTypeValues() []ContainerType {
	return []ContainerType{ContainerTypeAzureBackupServerContainer, ContainerTypeAzureSQLContainer, ContainerTypeCluster, ContainerTypeDPMContainer, ContainerTypeGenericContainer, ContainerTypeIaasVMContainer, ContainerTypeIaasVMServiceContainer, ContainerTypeInvalid, ContainerTypeMABContainer, ContainerTypeSQLAGWorkLoadContainer, ContainerTypeStorageContainer, ContainerTypeUnknown, ContainerTypeVCenter, ContainerTypeVMAppContainer, ContainerTypeWindows}
}

// ContainerTypeBasicProtectionContainer enumerates the values for container type basic protection container.
type ContainerTypeBasicProtectionContainer string

const (
	// ContainerTypeAzureBackupServerContainer1 ...
	ContainerTypeAzureBackupServerContainer1 ContainerTypeBasicProtectionContainer = "AzureBackupServerContainer"
	// ContainerTypeAzureSQLContainer1 ...
	ContainerTypeAzureSQLContainer1 ContainerTypeBasicProtectionContainer = "AzureSqlContainer"
	// ContainerTypeAzureWorkloadContainer ...
	ContainerTypeAzureWorkloadContainer ContainerTypeBasicProtectionContainer = "AzureWorkloadContainer"
	// ContainerTypeDPMContainer1 ...
	ContainerTypeDPMContainer1 ContainerTypeBasicProtectionContainer = "DPMContainer"
	// ContainerTypeGenericContainer1 ...
	ContainerTypeGenericContainer1 ContainerTypeBasicProtectionContainer = "GenericContainer"
	// ContainerTypeIaaSVMContainer ...
	ContainerTypeIaaSVMContainer ContainerTypeBasicProtectionContainer = "IaaSVMContainer"
	// ContainerTypeMicrosoftClassicComputevirtualMachines ...
	ContainerTypeMicrosoftClassicComputevirtualMachines ContainerTypeBasicProtectionContainer = "Microsoft.ClassicCompute/virtualMachines"
	// ContainerTypeMicrosoftComputevirtualMachines ...
	ContainerTypeMicrosoftComputevirtualMachines ContainerTypeBasicProtectionContainer = "Microsoft.Compute/virtualMachines"
	// ContainerTypeProtectionContainer ...
	ContainerTypeProtectionContainer ContainerTypeBasicProtectionContainer = "ProtectionContainer"
	// ContainerTypeSQLAGWorkLoadContainer1 ...
	ContainerTypeSQLAGWorkLoadContainer1 ContainerTypeBasicProtectionContainer = "SQLAGWorkLoadContainer"
	// ContainerTypeStorageContainer1 ...
	ContainerTypeStorageContainer1 ContainerTypeBasicProtectionContainer = "StorageContainer"
	// ContainerTypeVMAppContainer1 ...
	ContainerTypeVMAppContainer1 ContainerTypeBasicProtectionContainer = "VMAppContainer"
	// ContainerTypeWindows1 ...
	ContainerTypeWindows1 ContainerTypeBasicProtectionContainer = "Windows"
)

// PossibleContainerTypeBasicProtectionContainerValues returns an array of possible values for the ContainerTypeBasicProtectionContainer const type.
func PossibleContainerTypeBasicProtectionContainerValues() []ContainerTypeBasicProtectionContainer {
	return []ContainerTypeBasicProtectionContainer{ContainerTypeAzureBackupServerContainer1, ContainerTypeAzureSQLContainer1, ContainerTypeAzureWorkloadContainer, ContainerTypeDPMContainer1, ContainerTypeGenericContainer1, ContainerTypeIaaSVMContainer, ContainerTypeMicrosoftClassicComputevirtualMachines, ContainerTypeMicrosoftComputevirtualMachines, ContainerTypeProtectionContainer, ContainerTypeSQLAGWorkLoadContainer1, ContainerTypeStorageContainer1, ContainerTypeVMAppContainer1, ContainerTypeWindows1}
}

// CopyOptions enumerates the values for copy options.
type CopyOptions string

const (
	// CopyOptionsCreateCopy ...
	CopyOptionsCreateCopy CopyOptions = "CreateCopy"
	// CopyOptionsFailOnConflict ...
	CopyOptionsFailOnConflict CopyOptions = "FailOnConflict"
	// CopyOptionsInvalid ...
	CopyOptionsInvalid CopyOptions = "Invalid"
	// CopyOptionsOverwrite ...
	CopyOptionsOverwrite CopyOptions = "Overwrite"
	// CopyOptionsSkip ...
	CopyOptionsSkip CopyOptions = "Skip"
)

// PossibleCopyOptionsValues returns an array of possible values for the CopyOptions const type.
func PossibleCopyOptionsValues() []CopyOptions {
	return []CopyOptions{CopyOptionsCreateCopy, CopyOptionsFailOnConflict, CopyOptionsInvalid, CopyOptionsOverwrite, CopyOptionsSkip}
}

// CreateMode enumerates the values for create mode.
type CreateMode string

const (
	// CreateModeDefault ...
	CreateModeDefault CreateMode = "Default"
	// CreateModeInvalid ...
	CreateModeInvalid CreateMode = "Invalid"
	// CreateModeRecover ...
	CreateModeRecover CreateMode = "Recover"
)

// PossibleCreateModeValues returns an array of possible values for the CreateMode const type.
func PossibleCreateModeValues() []CreateMode {
	return []CreateMode{CreateModeDefault, CreateModeInvalid, CreateModeRecover}
}

// DataSourceType enumerates the values for data source type.
type DataSourceType string

const (
	// DataSourceTypeAzureFileShare ...
	DataSourceTypeAzureFileShare DataSourceType = "AzureFileShare"
	// DataSourceTypeAzureSQLDb ...
	DataSourceTypeAzureSQLDb DataSourceType = "AzureSqlDb"
	// DataSourceTypeClient ...
	DataSourceTypeClient DataSourceType = "Client"
	// DataSourceTypeExchange ...
	DataSourceTypeExchange DataSourceType = "Exchange"
	// DataSourceTypeFileFolder ...
	DataSourceTypeFileFolder DataSourceType = "FileFolder"
	// DataSourceTypeGenericDataSource ...
	DataSourceTypeGenericDataSource DataSourceType = "GenericDataSource"
	// DataSourceTypeInvalid ...
	DataSourceTypeInvalid DataSourceType = "Invalid"
	// DataSourceTypeSAPAseDatabase ...
	DataSourceTypeSAPAseDatabase DataSourceType = "SAPAseDatabase"
	// DataSourceTypeSAPHanaDatabase ...
	DataSourceTypeSAPHanaDatabase DataSourceType = "SAPHanaDatabase"
	// DataSourceTypeSharepoint ...
	DataSourceTypeSharepoint DataSourceType = "Sharepoint"
	// DataSourceTypeSQLDataBase ...
	DataSourceTypeSQLDataBase DataSourceType = "SQLDataBase"
	// DataSourceTypeSQLDB ...
	DataSourceTypeSQLDB DataSourceType = "SQLDB"
	// DataSourceTypeSystemState ...
	DataSourceTypeSystemState DataSourceType = "SystemState"
	// DataSourceTypeVM ...
	DataSourceTypeVM DataSourceType = "VM"
	// DataSourceTypeVMwareVM ...
	DataSourceTypeVMwareVM DataSourceType = "VMwareVM"
)

// PossibleDataSourceTypeValues returns an array of possible values for the DataSourceType const type.
func PossibleDataSourceTypeValues() []DataSourceType {
	return []DataSourceType{DataSourceTypeAzureFileShare, DataSourceTypeAzureSQLDb, DataSourceTypeClient, DataSourceTypeExchange, DataSourceTypeFileFolder, DataSourceTypeGenericDataSource, DataSourceTypeInvalid, DataSourceTypeSAPAseDatabase, DataSourceTypeSAPHanaDatabase, DataSourceTypeSharepoint, DataSourceTypeSQLDataBase, DataSourceTypeSQLDB, DataSourceTypeSystemState, DataSourceTypeVM, DataSourceTypeVMwareVM}
}

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// Friday ...
	Friday DayOfWeek = "Friday"
	// Monday ...
	Monday DayOfWeek = "Monday"
	// Saturday ...
	Saturday DayOfWeek = "Saturday"
	// Sunday ...
	Sunday DayOfWeek = "Sunday"
	// Thursday ...
	Thursday DayOfWeek = "Thursday"
	// Tuesday ...
	Tuesday DayOfWeek = "Tuesday"
	// Wednesday ...
	Wednesday DayOfWeek = "Wednesday"
)

// PossibleDayOfWeekValues returns an array of possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{Friday, Monday, Saturday, Sunday, Thursday, Tuesday, Wednesday}
}

// EngineType enumerates the values for engine type.
type EngineType string

const (
	// BackupEngineTypeAzureBackupServerEngine ...
	BackupEngineTypeAzureBackupServerEngine EngineType = "AzureBackupServerEngine"
	// BackupEngineTypeBackupEngineBase ...
	BackupEngineTypeBackupEngineBase EngineType = "BackupEngineBase"
	// BackupEngineTypeDpmBackupEngine ...
	BackupEngineTypeDpmBackupEngine EngineType = "DpmBackupEngine"
)

// PossibleEngineTypeValues returns an array of possible values for the EngineType const type.
func PossibleEngineTypeValues() []EngineType {
	return []EngineType{BackupEngineTypeAzureBackupServerEngine, BackupEngineTypeBackupEngineBase, BackupEngineTypeDpmBackupEngine}
}

// EnhancedSecurityState enumerates the values for enhanced security state.
type EnhancedSecurityState string

const (
	// EnhancedSecurityStateDisabled ...
	EnhancedSecurityStateDisabled EnhancedSecurityState = "Disabled"
	// EnhancedSecurityStateEnabled ...
	EnhancedSecurityStateEnabled EnhancedSecurityState = "Enabled"
	// EnhancedSecurityStateInvalid ...
	EnhancedSecurityStateInvalid EnhancedSecurityState = "Invalid"
)

// PossibleEnhancedSecurityStateValues returns an array of possible values for the EnhancedSecurityState const type.
func PossibleEnhancedSecurityStateValues() []EnhancedSecurityState {
	return []EnhancedSecurityState{EnhancedSecurityStateDisabled, EnhancedSecurityStateEnabled, EnhancedSecurityStateInvalid}
}

// FabricName enumerates the values for fabric name.
type FabricName string

const (
	// FabricNameAzure ...
	FabricNameAzure FabricName = "Azure"
	// FabricNameInvalid ...
	FabricNameInvalid FabricName = "Invalid"
)

// PossibleFabricNameValues returns an array of possible values for the FabricName const type.
func PossibleFabricNameValues() []FabricName {
	return []FabricName{FabricNameAzure, FabricNameInvalid}
}

// FeatureType enumerates the values for feature type.
type FeatureType string

const (
	// FeatureTypeAzureBackupGoals ...
	FeatureTypeAzureBackupGoals FeatureType = "AzureBackupGoals"
	// FeatureTypeAzureVMResourceBackup ...
	FeatureTypeAzureVMResourceBackup FeatureType = "AzureVMResourceBackup"
	// FeatureTypeFeatureSupportRequest ...
	FeatureTypeFeatureSupportRequest FeatureType = "FeatureSupportRequest"
)

// PossibleFeatureTypeValues returns an array of possible values for the FeatureType const type.
func PossibleFeatureTypeValues() []FeatureType {
	return []FeatureType{FeatureTypeAzureBackupGoals, FeatureTypeAzureVMResourceBackup, FeatureTypeFeatureSupportRequest}
}

// HealthState enumerates the values for health state.
type HealthState string

const (
	// HealthStateActionRequired ...
	HealthStateActionRequired HealthState = "ActionRequired"
	// HealthStateActionSuggested ...
	HealthStateActionSuggested HealthState = "ActionSuggested"
	// HealthStateInvalid ...
	HealthStateInvalid HealthState = "Invalid"
	// HealthStatePassed ...
	HealthStatePassed HealthState = "Passed"
)

// PossibleHealthStateValues returns an array of possible values for the HealthState const type.
func PossibleHealthStateValues() []HealthState {
	return []HealthState{HealthStateActionRequired, HealthStateActionSuggested, HealthStateInvalid, HealthStatePassed}
}

// HealthStatus enumerates the values for health status.
type HealthStatus string

const (
	// HealthStatusActionRequired ...
	HealthStatusActionRequired HealthStatus = "ActionRequired"
	// HealthStatusActionSuggested ...
	HealthStatusActionSuggested HealthStatus = "ActionSuggested"
	// HealthStatusInvalid ...
	HealthStatusInvalid HealthStatus = "Invalid"
	// HealthStatusPassed ...
	HealthStatusPassed HealthStatus = "Passed"
)

// PossibleHealthStatusValues returns an array of possible values for the HealthStatus const type.
func PossibleHealthStatusValues() []HealthStatus {
	return []HealthStatus{HealthStatusActionRequired, HealthStatusActionSuggested, HealthStatusInvalid, HealthStatusPassed}
}

// HTTPStatusCode enumerates the values for http status code.
type HTTPStatusCode string

const (
	// Accepted ...
	Accepted HTTPStatusCode = "Accepted"
	// Ambiguous ...
	Ambiguous HTTPStatusCode = "Ambiguous"
	// BadGateway ...
	BadGateway HTTPStatusCode = "BadGateway"
	// BadRequest ...
	BadRequest HTTPStatusCode = "BadRequest"
	// Conflict ...
	Conflict HTTPStatusCode = "Conflict"
	// Continue ...
	Continue HTTPStatusCode = "Continue"
	// Created ...
	Created HTTPStatusCode = "Created"
	// ExpectationFailed ...
	ExpectationFailed HTTPStatusCode = "ExpectationFailed"
	// Forbidden ...
	Forbidden HTTPStatusCode = "Forbidden"
	// Found ...
	Found HTTPStatusCode = "Found"
	// GatewayTimeout ...
	GatewayTimeout HTTPStatusCode = "GatewayTimeout"
	// Gone ...
	Gone HTTPStatusCode = "Gone"
	// HTTPVersionNotSupported ...
	HTTPVersionNotSupported HTTPStatusCode = "HttpVersionNotSupported"
	// InternalServerError ...
	InternalServerError HTTPStatusCode = "InternalServerError"
	// LengthRequired ...
	LengthRequired HTTPStatusCode = "LengthRequired"
	// MethodNotAllowed ...
	MethodNotAllowed HTTPStatusCode = "MethodNotAllowed"
	// Moved ...
	Moved HTTPStatusCode = "Moved"
	// MovedPermanently ...
	MovedPermanently HTTPStatusCode = "MovedPermanently"
	// MultipleChoices ...
	MultipleChoices HTTPStatusCode = "MultipleChoices"
	// NoContent ...
	NoContent HTTPStatusCode = "NoContent"
	// NonAuthoritativeInformation ...
	NonAuthoritativeInformation HTTPStatusCode = "NonAuthoritativeInformation"
	// NotAcceptable ...
	NotAcceptable HTTPStatusCode = "NotAcceptable"
	// NotFound ...
	NotFound HTTPStatusCode = "NotFound"
	// NotImplemented ...
	NotImplemented HTTPStatusCode = "NotImplemented"
	// NotModified ...
	NotModified HTTPStatusCode = "NotModified"
	// OK ...
	OK HTTPStatusCode = "OK"
	// PartialContent ...
	PartialContent HTTPStatusCode = "PartialContent"
	// PaymentRequired ...
	PaymentRequired HTTPStatusCode = "PaymentRequired"
	// PreconditionFailed ...
	PreconditionFailed HTTPStatusCode = "PreconditionFailed"
	// ProxyAuthenticationRequired ...
	ProxyAuthenticationRequired HTTPStatusCode = "ProxyAuthenticationRequired"
	// Redirect ...
	Redirect HTTPStatusCode = "Redirect"
	// RedirectKeepVerb ...
	RedirectKeepVerb HTTPStatusCode = "RedirectKeepVerb"
	// RedirectMethod ...
	RedirectMethod HTTPStatusCode = "RedirectMethod"
	// RequestedRangeNotSatisfiable ...
	RequestedRangeNotSatisfiable HTTPStatusCode = "RequestedRangeNotSatisfiable"
	// RequestEntityTooLarge ...
	RequestEntityTooLarge HTTPStatusCode = "RequestEntityTooLarge"
	// RequestTimeout ...
	RequestTimeout HTTPStatusCode = "RequestTimeout"
	// RequestURITooLong ...
	RequestURITooLong HTTPStatusCode = "RequestUriTooLong"
	// ResetContent ...
	ResetContent HTTPStatusCode = "ResetContent"
	// SeeOther ...
	SeeOther HTTPStatusCode = "SeeOther"
	// ServiceUnavailable ...
	ServiceUnavailable HTTPStatusCode = "ServiceUnavailable"
	// SwitchingProtocols ...
	SwitchingProtocols HTTPStatusCode = "SwitchingProtocols"
	// TemporaryRedirect ...
	TemporaryRedirect HTTPStatusCode = "TemporaryRedirect"
	// Unauthorized ...
	Unauthorized HTTPStatusCode = "Unauthorized"
	// UnsupportedMediaType ...
	UnsupportedMediaType HTTPStatusCode = "UnsupportedMediaType"
	// Unused ...
	Unused HTTPStatusCode = "Unused"
	// UpgradeRequired ...
	UpgradeRequired HTTPStatusCode = "UpgradeRequired"
	// UseProxy ...
	UseProxy HTTPStatusCode = "UseProxy"
)

// PossibleHTTPStatusCodeValues returns an array of possible values for the HTTPStatusCode const type.
func PossibleHTTPStatusCodeValues() []HTTPStatusCode {
	return []HTTPStatusCode{Accepted, Ambiguous, BadGateway, BadRequest, Conflict, Continue, Created, ExpectationFailed, Forbidden, Found, GatewayTimeout, Gone, HTTPVersionNotSupported, InternalServerError, LengthRequired, MethodNotAllowed, Moved, MovedPermanently, MultipleChoices, NoContent, NonAuthoritativeInformation, NotAcceptable, NotFound, NotImplemented, NotModified, OK, PartialContent, PaymentRequired, PreconditionFailed, ProxyAuthenticationRequired, Redirect, RedirectKeepVerb, RedirectMethod, RequestedRangeNotSatisfiable, RequestEntityTooLarge, RequestTimeout, RequestURITooLong, ResetContent, SeeOther, ServiceUnavailable, SwitchingProtocols, TemporaryRedirect, Unauthorized, UnsupportedMediaType, Unused, UpgradeRequired, UseProxy}
}

// InquiryStatus enumerates the values for inquiry status.
type InquiryStatus string

const (
	// InquiryStatusFailed ...
	InquiryStatusFailed InquiryStatus = "Failed"
	// InquiryStatusInvalid ...
	InquiryStatusInvalid InquiryStatus = "Invalid"
	// InquiryStatusSuccess ...
	InquiryStatusSuccess InquiryStatus = "Success"
)

// PossibleInquiryStatusValues returns an array of possible values for the InquiryStatus const type.
func PossibleInquiryStatusValues() []InquiryStatus {
	return []InquiryStatus{InquiryStatusFailed, InquiryStatusInvalid, InquiryStatusSuccess}
}

// IntentItemType enumerates the values for intent item type.
type IntentItemType string

const (
	// IntentItemTypeInvalid ...
	IntentItemTypeInvalid IntentItemType = "Invalid"
	// IntentItemTypeSQLAvailabilityGroupContainer ...
	IntentItemTypeSQLAvailabilityGroupContainer IntentItemType = "SQLAvailabilityGroupContainer"
	// IntentItemTypeSQLInstance ...
	IntentItemTypeSQLInstance IntentItemType = "SQLInstance"
)

// PossibleIntentItemTypeValues returns an array of possible values for the IntentItemType const type.
func PossibleIntentItemTypeValues() []IntentItemType {
	return []IntentItemType{IntentItemTypeInvalid, IntentItemTypeSQLAvailabilityGroupContainer, IntentItemTypeSQLInstance}
}

// ItemType enumerates the values for item type.
type ItemType string

const (
	// ItemTypeAzureFileShare ...
	ItemTypeAzureFileShare ItemType = "AzureFileShare"
	// ItemTypeAzureSQLDb ...
	ItemTypeAzureSQLDb ItemType = "AzureSqlDb"
	// ItemTypeClient ...
	ItemTypeClient ItemType = "Client"
	// ItemTypeExchange ...
	ItemTypeExchange ItemType = "Exchange"
	// ItemTypeFileFolder ...
	ItemTypeFileFolder ItemType = "FileFolder"
	// ItemTypeGenericDataSource ...
	ItemTypeGenericDataSource ItemType = "GenericDataSource"
	// ItemTypeInvalid ...
	ItemTypeInvalid ItemType = "Invalid"
	// ItemTypeSAPAseDatabase ...
	ItemTypeSAPAseDatabase ItemType = "SAPAseDatabase"
	// ItemTypeSAPHanaDatabase ...
	ItemTypeSAPHanaDatabase ItemType = "SAPHanaDatabase"
	// ItemTypeSharepoint ...
	ItemTypeSharepoint ItemType = "Sharepoint"
	// ItemTypeSQLDataBase ...
	ItemTypeSQLDataBase ItemType = "SQLDataBase"
	// ItemTypeSQLDB ...
	ItemTypeSQLDB ItemType = "SQLDB"
	// ItemTypeSystemState ...
	ItemTypeSystemState ItemType = "SystemState"
	// ItemTypeVM ...
	ItemTypeVM ItemType = "VM"
	// ItemTypeVMwareVM ...
	ItemTypeVMwareVM ItemType = "VMwareVM"
)

// PossibleItemTypeValues returns an array of possible values for the ItemType const type.
func PossibleItemTypeValues() []ItemType {
	return []ItemType{ItemTypeAzureFileShare, ItemTypeAzureSQLDb, ItemTypeClient, ItemTypeExchange, ItemTypeFileFolder, ItemTypeGenericDataSource, ItemTypeInvalid, ItemTypeSAPAseDatabase, ItemTypeSAPHanaDatabase, ItemTypeSharepoint, ItemTypeSQLDataBase, ItemTypeSQLDB, ItemTypeSystemState, ItemTypeVM, ItemTypeVMwareVM}
}

// JobOperationType enumerates the values for job operation type.
type JobOperationType string

const (
	// JobOperationTypeBackup ...
	JobOperationTypeBackup JobOperationType = "Backup"
	// JobOperationTypeConfigureBackup ...
	JobOperationTypeConfigureBackup JobOperationType = "ConfigureBackup"
	// JobOperationTypeCrossRegionRestore ...
	JobOperationTypeCrossRegionRestore JobOperationType = "CrossRegionRestore"
	// JobOperationTypeDeleteBackupData ...
	JobOperationTypeDeleteBackupData JobOperationType = "DeleteBackupData"
	// JobOperationTypeDisableBackup ...
	JobOperationTypeDisableBackup JobOperationType = "DisableBackup"
	// JobOperationTypeInvalid ...
	JobOperationTypeInvalid JobOperationType = "Invalid"
	// JobOperationTypeRegister ...
	JobOperationTypeRegister JobOperationType = "Register"
	// JobOperationTypeRestore ...
	JobOperationTypeRestore JobOperationType = "Restore"
	// JobOperationTypeUndelete ...
	JobOperationTypeUndelete JobOperationType = "Undelete"
	// JobOperationTypeUnRegister ...
	JobOperationTypeUnRegister JobOperationType = "UnRegister"
)

// PossibleJobOperationTypeValues returns an array of possible values for the JobOperationType const type.
func PossibleJobOperationTypeValues() []JobOperationType {
	return []JobOperationType{JobOperationTypeBackup, JobOperationTypeConfigureBackup, JobOperationTypeCrossRegionRestore, JobOperationTypeDeleteBackupData, JobOperationTypeDisableBackup, JobOperationTypeInvalid, JobOperationTypeRegister, JobOperationTypeRestore, JobOperationTypeUndelete, JobOperationTypeUnRegister}
}

// JobStatus enumerates the values for job status.
type JobStatus string

const (
	// JobStatusCancelled ...
	JobStatusCancelled JobStatus = "Cancelled"
	// JobStatusCancelling ...
	JobStatusCancelling JobStatus = "Cancelling"
	// JobStatusCompleted ...
	JobStatusCompleted JobStatus = "Completed"
	// JobStatusCompletedWithWarnings ...
	JobStatusCompletedWithWarnings JobStatus = "CompletedWithWarnings"
	// JobStatusFailed ...
	JobStatusFailed JobStatus = "Failed"
	// JobStatusInProgress ...
	JobStatusInProgress JobStatus = "InProgress"
	// JobStatusInvalid ...
	JobStatusInvalid JobStatus = "Invalid"
)

// PossibleJobStatusValues returns an array of possible values for the JobStatus const type.
func PossibleJobStatusValues() []JobStatus {
	return []JobStatus{JobStatusCancelled, JobStatusCancelling, JobStatusCompleted, JobStatusCompletedWithWarnings, JobStatusFailed, JobStatusInProgress, JobStatusInvalid}
}

// JobSupportedAction enumerates the values for job supported action.
type JobSupportedAction string

const (
	// JobSupportedActionCancellable ...
	JobSupportedActionCancellable JobSupportedAction = "Cancellable"
	// JobSupportedActionInvalid ...
	JobSupportedActionInvalid JobSupportedAction = "Invalid"
	// JobSupportedActionRetriable ...
	JobSupportedActionRetriable JobSupportedAction = "Retriable"
)

// PossibleJobSupportedActionValues returns an array of possible values for the JobSupportedAction const type.
func PossibleJobSupportedActionValues() []JobSupportedAction {
	return []JobSupportedAction{JobSupportedActionCancellable, JobSupportedActionInvalid, JobSupportedActionRetriable}
}

// JobType enumerates the values for job type.
type JobType string

const (
	// JobTypeAzureIaaSVMJob ...
	JobTypeAzureIaaSVMJob JobType = "AzureIaaSVMJob"
	// JobTypeAzureStorageJob ...
	JobTypeAzureStorageJob JobType = "AzureStorageJob"
	// JobTypeAzureWorkloadJob ...
	JobTypeAzureWorkloadJob JobType = "AzureWorkloadJob"
	// JobTypeDpmJob ...
	JobTypeDpmJob JobType = "DpmJob"
	// JobTypeJob ...
	JobTypeJob JobType = "Job"
	// JobTypeMabJob ...
	JobTypeMabJob JobType = "MabJob"
)

// PossibleJobTypeValues returns an array of possible values for the JobType const type.
func PossibleJobTypeValues() []JobType {
	return []JobType{JobTypeAzureIaaSVMJob, JobTypeAzureStorageJob, JobTypeAzureWorkloadJob, JobTypeDpmJob, JobTypeJob, JobTypeMabJob}
}

// LastBackupStatus enumerates the values for last backup status.
type LastBackupStatus string

const (
	// LastBackupStatusHealthy ...
	LastBackupStatusHealthy LastBackupStatus = "Healthy"
	// LastBackupStatusInvalid ...
	LastBackupStatusInvalid LastBackupStatus = "Invalid"
	// LastBackupStatusIRPending ...
	LastBackupStatusIRPending LastBackupStatus = "IRPending"
	// LastBackupStatusUnhealthy ...
	LastBackupStatusUnhealthy LastBackupStatus = "Unhealthy"
)

// PossibleLastBackupStatusValues returns an array of possible values for the LastBackupStatus const type.
func PossibleLastBackupStatusValues() []LastBackupStatus {
	return []LastBackupStatus{LastBackupStatusHealthy, LastBackupStatusInvalid, LastBackupStatusIRPending, LastBackupStatusUnhealthy}
}

// MabServerType enumerates the values for mab server type.
type MabServerType string

const (
	// MabServerTypeAzureBackupServerContainer ...
	MabServerTypeAzureBackupServerContainer MabServerType = "AzureBackupServerContainer"
	// MabServerTypeAzureSQLContainer ...
	MabServerTypeAzureSQLContainer MabServerType = "AzureSqlContainer"
	// MabServerTypeCluster ...
	MabServerTypeCluster MabServerType = "Cluster"
	// MabServerTypeDPMContainer ...
	MabServerTypeDPMContainer MabServerType = "DPMContainer"
	// MabServerTypeGenericContainer ...
	MabServerTypeGenericContainer MabServerType = "GenericContainer"
	// MabServerTypeIaasVMContainer ...
	MabServerTypeIaasVMContainer MabServerType = "IaasVMContainer"
	// MabServerTypeIaasVMServiceContainer ...
	MabServerTypeIaasVMServiceContainer MabServerType = "IaasVMServiceContainer"
	// MabServerTypeInvalid ...
	MabServerTypeInvalid MabServerType = "Invalid"
	// MabServerTypeMABContainer ...
	MabServerTypeMABContainer MabServerType = "MABContainer"
	// MabServerTypeSQLAGWorkLoadContainer ...
	MabServerTypeSQLAGWorkLoadContainer MabServerType = "SQLAGWorkLoadContainer"
	// MabServerTypeStorageContainer ...
	MabServerTypeStorageContainer MabServerType = "StorageContainer"
	// MabServerTypeUnknown ...
	MabServerTypeUnknown MabServerType = "Unknown"
	// MabServerTypeVCenter ...
	MabServerTypeVCenter MabServerType = "VCenter"
	// MabServerTypeVMAppContainer ...
	MabServerTypeVMAppContainer MabServerType = "VMAppContainer"
	// MabServerTypeWindows ...
	MabServerTypeWindows MabServerType = "Windows"
)

// PossibleMabServerTypeValues returns an array of possible values for the MabServerType const type.
func PossibleMabServerTypeValues() []MabServerType {
	return []MabServerType{MabServerTypeAzureBackupServerContainer, MabServerTypeAzureSQLContainer, MabServerTypeCluster, MabServerTypeDPMContainer, MabServerTypeGenericContainer, MabServerTypeIaasVMContainer, MabServerTypeIaasVMServiceContainer, MabServerTypeInvalid, MabServerTypeMABContainer, MabServerTypeSQLAGWorkLoadContainer, MabServerTypeStorageContainer, MabServerTypeUnknown, MabServerTypeVCenter, MabServerTypeVMAppContainer, MabServerTypeWindows}
}

// ManagementType enumerates the values for management type.
type ManagementType string

const (
	// ManagementTypeAzureBackupServer ...
	ManagementTypeAzureBackupServer ManagementType = "AzureBackupServer"
	// ManagementTypeAzureIaasVM ...
	ManagementTypeAzureIaasVM ManagementType = "AzureIaasVM"
	// ManagementTypeAzureSQL ...
	ManagementTypeAzureSQL ManagementType = "AzureSql"
	// ManagementTypeAzureStorage ...
	ManagementTypeAzureStorage ManagementType = "AzureStorage"
	// ManagementTypeAzureWorkload ...
	ManagementTypeAzureWorkload ManagementType = "AzureWorkload"
	// ManagementTypeDefaultBackup ...
	ManagementTypeDefaultBackup ManagementType = "DefaultBackup"
	// ManagementTypeDPM ...
	ManagementTypeDPM ManagementType = "DPM"
	// ManagementTypeInvalid ...
	ManagementTypeInvalid ManagementType = "Invalid"
	// ManagementTypeMAB ...
	ManagementTypeMAB ManagementType = "MAB"
)

// PossibleManagementTypeValues returns an array of possible values for the ManagementType const type.
func PossibleManagementTypeValues() []ManagementType {
	return []ManagementType{ManagementTypeAzureBackupServer, ManagementTypeAzureIaasVM, ManagementTypeAzureSQL, ManagementTypeAzureStorage, ManagementTypeAzureWorkload, ManagementTypeDefaultBackup, ManagementTypeDPM, ManagementTypeInvalid, ManagementTypeMAB}
}

// ManagementTypeBasicProtectionPolicy enumerates the values for management type basic protection policy.
type ManagementTypeBasicProtectionPolicy string

const (
	// BackupManagementTypeAzureIaasVM ...
	BackupManagementTypeAzureIaasVM ManagementTypeBasicProtectionPolicy = "AzureIaasVM"
	// BackupManagementTypeAzureSQL ...
	BackupManagementTypeAzureSQL ManagementTypeBasicProtectionPolicy = "AzureSql"
	// BackupManagementTypeAzureStorage ...
	BackupManagementTypeAzureStorage ManagementTypeBasicProtectionPolicy = "AzureStorage"
	// BackupManagementTypeAzureWorkload ...
	BackupManagementTypeAzureWorkload ManagementTypeBasicProtectionPolicy = "AzureWorkload"
	// BackupManagementTypeGenericProtectionPolicy ...
	BackupManagementTypeGenericProtectionPolicy ManagementTypeBasicProtectionPolicy = "GenericProtectionPolicy"
	// BackupManagementTypeMAB ...
	BackupManagementTypeMAB ManagementTypeBasicProtectionPolicy = "MAB"
	// BackupManagementTypeProtectionPolicy ...
	BackupManagementTypeProtectionPolicy ManagementTypeBasicProtectionPolicy = "ProtectionPolicy"
)

// PossibleManagementTypeBasicProtectionPolicyValues returns an array of possible values for the ManagementTypeBasicProtectionPolicy const type.
func PossibleManagementTypeBasicProtectionPolicyValues() []ManagementTypeBasicProtectionPolicy {
	return []ManagementTypeBasicProtectionPolicy{BackupManagementTypeAzureIaasVM, BackupManagementTypeAzureSQL, BackupManagementTypeAzureStorage, BackupManagementTypeAzureWorkload, BackupManagementTypeGenericProtectionPolicy, BackupManagementTypeMAB, BackupManagementTypeProtectionPolicy}
}

// MonthOfYear enumerates the values for month of year.
type MonthOfYear string

const (
	// MonthOfYearApril ...
	MonthOfYearApril MonthOfYear = "April"
	// MonthOfYearAugust ...
	MonthOfYearAugust MonthOfYear = "August"
	// MonthOfYearDecember ...
	MonthOfYearDecember MonthOfYear = "December"
	// MonthOfYearFebruary ...
	MonthOfYearFebruary MonthOfYear = "February"
	// MonthOfYearInvalid ...
	MonthOfYearInvalid MonthOfYear = "Invalid"
	// MonthOfYearJanuary ...
	MonthOfYearJanuary MonthOfYear = "January"
	// MonthOfYearJuly ...
	MonthOfYearJuly MonthOfYear = "July"
	// MonthOfYearJune ...
	MonthOfYearJune MonthOfYear = "June"
	// MonthOfYearMarch ...
	MonthOfYearMarch MonthOfYear = "March"
	// MonthOfYearMay ...
	MonthOfYearMay MonthOfYear = "May"
	// MonthOfYearNovember ...
	MonthOfYearNovember MonthOfYear = "November"
	// MonthOfYearOctober ...
	MonthOfYearOctober MonthOfYear = "October"
	// MonthOfYearSeptember ...
	MonthOfYearSeptember MonthOfYear = "September"
)

// PossibleMonthOfYearValues returns an array of possible values for the MonthOfYear const type.
func PossibleMonthOfYearValues() []MonthOfYear {
	return []MonthOfYear{MonthOfYearApril, MonthOfYearAugust, MonthOfYearDecember, MonthOfYearFebruary, MonthOfYearInvalid, MonthOfYearJanuary, MonthOfYearJuly, MonthOfYearJune, MonthOfYearMarch, MonthOfYearMay, MonthOfYearNovember, MonthOfYearOctober, MonthOfYearSeptember}
}

// ObjectType enumerates the values for object type.
type ObjectType string

const (
	// ObjectTypeExportJobsOperationResultInfo ...
	ObjectTypeExportJobsOperationResultInfo ObjectType = "ExportJobsOperationResultInfo"
	// ObjectTypeOperationResultInfo ...
	ObjectTypeOperationResultInfo ObjectType = "OperationResultInfo"
	// ObjectTypeOperationResultInfoBase ...
	ObjectTypeOperationResultInfoBase ObjectType = "OperationResultInfoBase"
)

// PossibleObjectTypeValues returns an array of possible values for the ObjectType const type.
func PossibleObjectTypeValues() []ObjectType {
	return []ObjectType{ObjectTypeExportJobsOperationResultInfo, ObjectTypeOperationResultInfo, ObjectTypeOperationResultInfoBase}
}

// ObjectTypeBasicILRRequest enumerates the values for object type basic ilr request.
type ObjectTypeBasicILRRequest string

const (
	// ObjectTypeAzureFileShareProvisionILRRequest ...
	ObjectTypeAzureFileShareProvisionILRRequest ObjectTypeBasicILRRequest = "AzureFileShareProvisionILRRequest"
	// ObjectTypeIaasVMILRRegistrationRequest ...
	ObjectTypeIaasVMILRRegistrationRequest ObjectTypeBasicILRRequest = "IaasVMILRRegistrationRequest"
	// ObjectTypeILRRequest ...
	ObjectTypeILRRequest ObjectTypeBasicILRRequest = "ILRRequest"
)

// PossibleObjectTypeBasicILRRequestValues returns an array of possible values for the ObjectTypeBasicILRRequest const type.
func PossibleObjectTypeBasicILRRequestValues() []ObjectTypeBasicILRRequest {
	return []ObjectTypeBasicILRRequest{ObjectTypeAzureFileShareProvisionILRRequest, ObjectTypeIaasVMILRRegistrationRequest, ObjectTypeILRRequest}
}

// ObjectTypeBasicOperationStatusExtendedInfo enumerates the values for object type basic operation status
// extended info.
type ObjectTypeBasicOperationStatusExtendedInfo string

const (
	// ObjectTypeOperationStatusExtendedInfo ...
	ObjectTypeOperationStatusExtendedInfo ObjectTypeBasicOperationStatusExtendedInfo = "OperationStatusExtendedInfo"
	// ObjectTypeOperationStatusJobExtendedInfo ...
	ObjectTypeOperationStatusJobExtendedInfo ObjectTypeBasicOperationStatusExtendedInfo = "OperationStatusJobExtendedInfo"
	// ObjectTypeOperationStatusJobsExtendedInfo ...
	ObjectTypeOperationStatusJobsExtendedInfo ObjectTypeBasicOperationStatusExtendedInfo = "OperationStatusJobsExtendedInfo"
	// ObjectTypeOperationStatusProvisionILRExtendedInfo ...
	ObjectTypeOperationStatusProvisionILRExtendedInfo ObjectTypeBasicOperationStatusExtendedInfo = "OperationStatusProvisionILRExtendedInfo"
)

// PossibleObjectTypeBasicOperationStatusExtendedInfoValues returns an array of possible values for the ObjectTypeBasicOperationStatusExtendedInfo const type.
func PossibleObjectTypeBasicOperationStatusExtendedInfoValues() []ObjectTypeBasicOperationStatusExtendedInfo {
	return []ObjectTypeBasicOperationStatusExtendedInfo{ObjectTypeOperationStatusExtendedInfo, ObjectTypeOperationStatusJobExtendedInfo, ObjectTypeOperationStatusJobsExtendedInfo, ObjectTypeOperationStatusProvisionILRExtendedInfo}
}

// ObjectTypeBasicRecoveryPoint enumerates the values for object type basic recovery point.
type ObjectTypeBasicRecoveryPoint string

const (
	// ObjectTypeAzureFileShareRecoveryPoint ...
	ObjectTypeAzureFileShareRecoveryPoint ObjectTypeBasicRecoveryPoint = "AzureFileShareRecoveryPoint"
	// ObjectTypeAzureWorkloadPointInTimeRecoveryPoint ...
	ObjectTypeAzureWorkloadPointInTimeRecoveryPoint ObjectTypeBasicRecoveryPoint = "AzureWorkloadPointInTimeRecoveryPoint"
	// ObjectTypeAzureWorkloadRecoveryPoint ...
	ObjectTypeAzureWorkloadRecoveryPoint ObjectTypeBasicRecoveryPoint = "AzureWorkloadRecoveryPoint"
	// ObjectTypeAzureWorkloadSAPHanaPointInTimeRecoveryPoint ...
	ObjectTypeAzureWorkloadSAPHanaPointInTimeRecoveryPoint ObjectTypeBasicRecoveryPoint = "AzureWorkloadSAPHanaPointInTimeRecoveryPoint"
	// ObjectTypeAzureWorkloadSAPHanaRecoveryPoint ...
	ObjectTypeAzureWorkloadSAPHanaRecoveryPoint ObjectTypeBasicRecoveryPoint = "AzureWorkloadSAPHanaRecoveryPoint"
	// ObjectTypeAzureWorkloadSQLPointInTimeRecoveryPoint ...
	ObjectTypeAzureWorkloadSQLPointInTimeRecoveryPoint ObjectTypeBasicRecoveryPoint = "AzureWorkloadSQLPointInTimeRecoveryPoint"
	// ObjectTypeAzureWorkloadSQLRecoveryPoint ...
	ObjectTypeAzureWorkloadSQLRecoveryPoint ObjectTypeBasicRecoveryPoint = "AzureWorkloadSQLRecoveryPoint"
	// ObjectTypeGenericRecoveryPoint ...
	ObjectTypeGenericRecoveryPoint ObjectTypeBasicRecoveryPoint = "GenericRecoveryPoint"
	// ObjectTypeIaasVMRecoveryPoint ...
	ObjectTypeIaasVMRecoveryPoint ObjectTypeBasicRecoveryPoint = "IaasVMRecoveryPoint"
	// ObjectTypeRecoveryPoint ...
	ObjectTypeRecoveryPoint ObjectTypeBasicRecoveryPoint = "RecoveryPoint"
)

// PossibleObjectTypeBasicRecoveryPointValues returns an array of possible values for the ObjectTypeBasicRecoveryPoint const type.
func PossibleObjectTypeBasicRecoveryPointValues() []ObjectTypeBasicRecoveryPoint {
	return []ObjectTypeBasicRecoveryPoint{ObjectTypeAzureFileShareRecoveryPoint, ObjectTypeAzureWorkloadPointInTimeRecoveryPoint, ObjectTypeAzureWorkloadRecoveryPoint, ObjectTypeAzureWorkloadSAPHanaPointInTimeRecoveryPoint, ObjectTypeAzureWorkloadSAPHanaRecoveryPoint, ObjectTypeAzureWorkloadSQLPointInTimeRecoveryPoint, ObjectTypeAzureWorkloadSQLRecoveryPoint, ObjectTypeGenericRecoveryPoint, ObjectTypeIaasVMRecoveryPoint, ObjectTypeRecoveryPoint}
}

// ObjectTypeBasicRequest enumerates the values for object type basic request.
type ObjectTypeBasicRequest string

const (
	// ObjectTypeAzureFileShareBackupRequest ...
	ObjectTypeAzureFileShareBackupRequest ObjectTypeBasicRequest = "AzureFileShareBackupRequest"
	// ObjectTypeAzureWorkloadBackupRequest ...
	ObjectTypeAzureWorkloadBackupRequest ObjectTypeBasicRequest = "AzureWorkloadBackupRequest"
	// ObjectTypeBackupRequest ...
	ObjectTypeBackupRequest ObjectTypeBasicRequest = "BackupRequest"
	// ObjectTypeIaasVMBackupRequest ...
	ObjectTypeIaasVMBackupRequest ObjectTypeBasicRequest = "IaasVMBackupRequest"
)

// PossibleObjectTypeBasicRequestValues returns an array of possible values for the ObjectTypeBasicRequest const type.
func PossibleObjectTypeBasicRequestValues() []ObjectTypeBasicRequest {
	return []ObjectTypeBasicRequest{ObjectTypeAzureFileShareBackupRequest, ObjectTypeAzureWorkloadBackupRequest, ObjectTypeBackupRequest, ObjectTypeIaasVMBackupRequest}
}

// ObjectTypeBasicRestoreRequest enumerates the values for object type basic restore request.
type ObjectTypeBasicRestoreRequest string

const (
	// ObjectTypeAzureFileShareRestoreRequest ...
	ObjectTypeAzureFileShareRestoreRequest ObjectTypeBasicRestoreRequest = "AzureFileShareRestoreRequest"
	// ObjectTypeAzureWorkloadPointInTimeRestoreRequest ...
	ObjectTypeAzureWorkloadPointInTimeRestoreRequest ObjectTypeBasicRestoreRequest = "AzureWorkloadPointInTimeRestoreRequest"
	// ObjectTypeAzureWorkloadRestoreRequest ...
	ObjectTypeAzureWorkloadRestoreRequest ObjectTypeBasicRestoreRequest = "AzureWorkloadRestoreRequest"
	// ObjectTypeAzureWorkloadSAPHanaPointInTimeRestoreRequest ...
	ObjectTypeAzureWorkloadSAPHanaPointInTimeRestoreRequest ObjectTypeBasicRestoreRequest = "AzureWorkloadSAPHanaPointInTimeRestoreRequest"
	// ObjectTypeAzureWorkloadSAPHanaRestoreRequest ...
	ObjectTypeAzureWorkloadSAPHanaRestoreRequest ObjectTypeBasicRestoreRequest = "AzureWorkloadSAPHanaRestoreRequest"
	// ObjectTypeAzureWorkloadSQLPointInTimeRestoreRequest ...
	ObjectTypeAzureWorkloadSQLPointInTimeRestoreRequest ObjectTypeBasicRestoreRequest = "AzureWorkloadSQLPointInTimeRestoreRequest"
	// ObjectTypeAzureWorkloadSQLRestoreRequest ...
	ObjectTypeAzureWorkloadSQLRestoreRequest ObjectTypeBasicRestoreRequest = "AzureWorkloadSQLRestoreRequest"
	// ObjectTypeIaasVMRestoreRequest ...
	ObjectTypeIaasVMRestoreRequest ObjectTypeBasicRestoreRequest = "IaasVMRestoreRequest"
	// ObjectTypeRestoreRequest ...
	ObjectTypeRestoreRequest ObjectTypeBasicRestoreRequest = "RestoreRequest"
)

// PossibleObjectTypeBasicRestoreRequestValues returns an array of possible values for the ObjectTypeBasicRestoreRequest const type.
func PossibleObjectTypeBasicRestoreRequestValues() []ObjectTypeBasicRestoreRequest {
	return []ObjectTypeBasicRestoreRequest{ObjectTypeAzureFileShareRestoreRequest, ObjectTypeAzureWorkloadPointInTimeRestoreRequest, ObjectTypeAzureWorkloadRestoreRequest, ObjectTypeAzureWorkloadSAPHanaPointInTimeRestoreRequest, ObjectTypeAzureWorkloadSAPHanaRestoreRequest, ObjectTypeAzureWorkloadSQLPointInTimeRestoreRequest, ObjectTypeAzureWorkloadSQLRestoreRequest, ObjectTypeIaasVMRestoreRequest, ObjectTypeRestoreRequest}
}

// ObjectTypeBasicValidateOperationRequest enumerates the values for object type basic validate operation
// request.
type ObjectTypeBasicValidateOperationRequest string

const (
	// ObjectTypeValidateIaasVMRestoreOperationRequest ...
	ObjectTypeValidateIaasVMRestoreOperationRequest ObjectTypeBasicValidateOperationRequest = "ValidateIaasVMRestoreOperationRequest"
	// ObjectTypeValidateOperationRequest ...
	ObjectTypeValidateOperationRequest ObjectTypeBasicValidateOperationRequest = "ValidateOperationRequest"
	// ObjectTypeValidateRestoreOperationRequest ...
	ObjectTypeValidateRestoreOperationRequest ObjectTypeBasicValidateOperationRequest = "ValidateRestoreOperationRequest"
)

// PossibleObjectTypeBasicValidateOperationRequestValues returns an array of possible values for the ObjectTypeBasicValidateOperationRequest const type.
func PossibleObjectTypeBasicValidateOperationRequestValues() []ObjectTypeBasicValidateOperationRequest {
	return []ObjectTypeBasicValidateOperationRequest{ObjectTypeValidateIaasVMRestoreOperationRequest, ObjectTypeValidateOperationRequest, ObjectTypeValidateRestoreOperationRequest}
}

// OperationStatusValues enumerates the values for operation status values.
type OperationStatusValues string

const (
	// OperationStatusValuesCanceled ...
	OperationStatusValuesCanceled OperationStatusValues = "Canceled"
	// OperationStatusValuesFailed ...
	OperationStatusValuesFailed OperationStatusValues = "Failed"
	// OperationStatusValuesInProgress ...
	OperationStatusValuesInProgress OperationStatusValues = "InProgress"
	// OperationStatusValuesInvalid ...
	OperationStatusValuesInvalid OperationStatusValues = "Invalid"
	// OperationStatusValuesSucceeded ...
	OperationStatusValuesSucceeded OperationStatusValues = "Succeeded"
)

// PossibleOperationStatusValuesValues returns an array of possible values for the OperationStatusValues const type.
func PossibleOperationStatusValuesValues() []OperationStatusValues {
	return []OperationStatusValues{OperationStatusValuesCanceled, OperationStatusValuesFailed, OperationStatusValuesInProgress, OperationStatusValuesInvalid, OperationStatusValuesSucceeded}
}

// OperationType enumerates the values for operation type.
type OperationType string

const (
	// OperationTypeInvalid ...
	OperationTypeInvalid OperationType = "Invalid"
	// OperationTypeRegister ...
	OperationTypeRegister OperationType = "Register"
	// OperationTypeReregister ...
	OperationTypeReregister OperationType = "Reregister"
)

// PossibleOperationTypeValues returns an array of possible values for the OperationType const type.
func PossibleOperationTypeValues() []OperationType {
	return []OperationType{OperationTypeInvalid, OperationTypeRegister, OperationTypeReregister}
}

// OverwriteOptions enumerates the values for overwrite options.
type OverwriteOptions string

const (
	// OverwriteOptionsFailOnConflict ...
	OverwriteOptionsFailOnConflict OverwriteOptions = "FailOnConflict"
	// OverwriteOptionsInvalid ...
	OverwriteOptionsInvalid OverwriteOptions = "Invalid"
	// OverwriteOptionsOverwrite ...
	OverwriteOptionsOverwrite OverwriteOptions = "Overwrite"
)

// PossibleOverwriteOptionsValues returns an array of possible values for the OverwriteOptions const type.
func PossibleOverwriteOptionsValues() []OverwriteOptions {
	return []OverwriteOptions{OverwriteOptionsFailOnConflict, OverwriteOptionsInvalid, OverwriteOptionsOverwrite}
}

// PolicyType enumerates the values for policy type.
type PolicyType string

const (
	// PolicyTypeCopyOnlyFull ...
	PolicyTypeCopyOnlyFull PolicyType = "CopyOnlyFull"
	// PolicyTypeDifferential ...
	PolicyTypeDifferential PolicyType = "Differential"
	// PolicyTypeFull ...
	PolicyTypeFull PolicyType = "Full"
	// PolicyTypeInvalid ...
	PolicyTypeInvalid PolicyType = "Invalid"
	// PolicyTypeLog ...
	PolicyTypeLog PolicyType = "Log"
)

// PossiblePolicyTypeValues returns an array of possible values for the PolicyType const type.
func PossiblePolicyTypeValues() []PolicyType {
	return []PolicyType{PolicyTypeCopyOnlyFull, PolicyTypeDifferential, PolicyTypeFull, PolicyTypeInvalid, PolicyTypeLog}
}

// ProtectableContainerType enumerates the values for protectable container type.
type ProtectableContainerType string

const (
	// ProtectableContainerTypeProtectableContainer ...
	ProtectableContainerTypeProtectableContainer ProtectableContainerType = "ProtectableContainer"
	// ProtectableContainerTypeStorageContainer ...
	ProtectableContainerTypeStorageContainer ProtectableContainerType = "StorageContainer"
	// ProtectableContainerTypeVMAppContainer ...
	ProtectableContainerTypeVMAppContainer ProtectableContainerType = "VMAppContainer"
)

// PossibleProtectableContainerTypeValues returns an array of possible values for the ProtectableContainerType const type.
func PossibleProtectableContainerTypeValues() []ProtectableContainerType {
	return []ProtectableContainerType{ProtectableContainerTypeProtectableContainer, ProtectableContainerTypeStorageContainer, ProtectableContainerTypeVMAppContainer}
}

// ProtectableItemType enumerates the values for protectable item type.
type ProtectableItemType string

const (
	// ProtectableItemTypeAzureFileShare ...
	ProtectableItemTypeAzureFileShare ProtectableItemType = "AzureFileShare"
	// ProtectableItemTypeAzureVMWorkloadProtectableItem ...
	ProtectableItemTypeAzureVMWorkloadProtectableItem ProtectableItemType = "AzureVmWorkloadProtectableItem"
	// ProtectableItemTypeIaaSVMProtectableItem ...
	ProtectableItemTypeIaaSVMProtectableItem ProtectableItemType = "IaaSVMProtectableItem"
	// ProtectableItemTypeMicrosoftClassicComputevirtualMachines ...
	ProtectableItemTypeMicrosoftClassicComputevirtualMachines ProtectableItemType = "Microsoft.ClassicCompute/virtualMachines"
	// ProtectableItemTypeMicrosoftComputevirtualMachines ...
	ProtectableItemTypeMicrosoftComputevirtualMachines ProtectableItemType = "Microsoft.Compute/virtualMachines"
	// ProtectableItemTypeSAPAseSystem ...
	ProtectableItemTypeSAPAseSystem ProtectableItemType = "SAPAseSystem"
	// ProtectableItemTypeSAPHanaDatabase ...
	ProtectableItemTypeSAPHanaDatabase ProtectableItemType = "SAPHanaDatabase"
	// ProtectableItemTypeSAPHanaSystem ...
	ProtectableItemTypeSAPHanaSystem ProtectableItemType = "SAPHanaSystem"
	// ProtectableItemTypeSQLAvailabilityGroupContainer ...
	ProtectableItemTypeSQLAvailabilityGroupContainer ProtectableItemType = "SQLAvailabilityGroupContainer"
	// ProtectableItemTypeSQLDataBase ...
	ProtectableItemTypeSQLDataBase ProtectableItemType = "SQLDataBase"
	// ProtectableItemTypeSQLInstance ...
	ProtectableItemTypeSQLInstance ProtectableItemType = "SQLInstance"
	// ProtectableItemTypeWorkloadProtectableItem ...
	ProtectableItemTypeWorkloadProtectableItem ProtectableItemType = "WorkloadProtectableItem"
)

// PossibleProtectableItemTypeValues returns an array of possible values for the ProtectableItemType const type.
func PossibleProtectableItemTypeValues() []ProtectableItemType {
	return []ProtectableItemType{ProtectableItemTypeAzureFileShare, ProtectableItemTypeAzureVMWorkloadProtectableItem, ProtectableItemTypeIaaSVMProtectableItem, ProtectableItemTypeMicrosoftClassicComputevirtualMachines, ProtectableItemTypeMicrosoftComputevirtualMachines, ProtectableItemTypeSAPAseSystem, ProtectableItemTypeSAPHanaDatabase, ProtectableItemTypeSAPHanaSystem, ProtectableItemTypeSQLAvailabilityGroupContainer, ProtectableItemTypeSQLDataBase, ProtectableItemTypeSQLInstance, ProtectableItemTypeWorkloadProtectableItem}
}

// ProtectedItemHealthStatus enumerates the values for protected item health status.
type ProtectedItemHealthStatus string

const (
	// ProtectedItemHealthStatusHealthy ...
	ProtectedItemHealthStatusHealthy ProtectedItemHealthStatus = "Healthy"
	// ProtectedItemHealthStatusInvalid ...
	ProtectedItemHealthStatusInvalid ProtectedItemHealthStatus = "Invalid"
	// ProtectedItemHealthStatusIRPending ...
	ProtectedItemHealthStatusIRPending ProtectedItemHealthStatus = "IRPending"
	// ProtectedItemHealthStatusNotReachable ...
	ProtectedItemHealthStatusNotReachable ProtectedItemHealthStatus = "NotReachable"
	// ProtectedItemHealthStatusUnhealthy ...
	ProtectedItemHealthStatusUnhealthy ProtectedItemHealthStatus = "Unhealthy"
)

// PossibleProtectedItemHealthStatusValues returns an array of possible values for the ProtectedItemHealthStatus const type.
func PossibleProtectedItemHealthStatusValues() []ProtectedItemHealthStatus {
	return []ProtectedItemHealthStatus{ProtectedItemHealthStatusHealthy, ProtectedItemHealthStatusInvalid, ProtectedItemHealthStatusIRPending, ProtectedItemHealthStatusNotReachable, ProtectedItemHealthStatusUnhealthy}
}

// ProtectedItemState enumerates the values for protected item state.
type ProtectedItemState string

const (
	// ProtectedItemStateInvalid ...
	ProtectedItemStateInvalid ProtectedItemState = "Invalid"
	// ProtectedItemStateIRPending ...
	ProtectedItemStateIRPending ProtectedItemState = "IRPending"
	// ProtectedItemStateProtected ...
	ProtectedItemStateProtected ProtectedItemState = "Protected"
	// ProtectedItemStateProtectionError ...
	ProtectedItemStateProtectionError ProtectedItemState = "ProtectionError"
	// ProtectedItemStateProtectionPaused ...
	ProtectedItemStateProtectionPaused ProtectedItemState = "ProtectionPaused"
	// ProtectedItemStateProtectionStopped ...
	ProtectedItemStateProtectionStopped ProtectedItemState = "ProtectionStopped"
)

// PossibleProtectedItemStateValues returns an array of possible values for the ProtectedItemState const type.
func PossibleProtectedItemStateValues() []ProtectedItemState {
	return []ProtectedItemState{ProtectedItemStateInvalid, ProtectedItemStateIRPending, ProtectedItemStateProtected, ProtectedItemStateProtectionError, ProtectedItemStateProtectionPaused, ProtectedItemStateProtectionStopped}
}

// ProtectedItemType enumerates the values for protected item type.
type ProtectedItemType string

const (
	// ProtectedItemTypeAzureFileShareProtectedItem ...
	ProtectedItemTypeAzureFileShareProtectedItem ProtectedItemType = "AzureFileShareProtectedItem"
	// ProtectedItemTypeAzureIaaSVMProtectedItem ...
	ProtectedItemTypeAzureIaaSVMProtectedItem ProtectedItemType = "AzureIaaSVMProtectedItem"
	// ProtectedItemTypeAzureVMWorkloadProtectedItem ...
	ProtectedItemTypeAzureVMWorkloadProtectedItem ProtectedItemType = "AzureVmWorkloadProtectedItem"
	// ProtectedItemTypeAzureVMWorkloadSAPAseDatabase ...
	ProtectedItemTypeAzureVMWorkloadSAPAseDatabase ProtectedItemType = "AzureVmWorkloadSAPAseDatabase"
	// ProtectedItemTypeAzureVMWorkloadSAPHanaDatabase ...
	ProtectedItemTypeAzureVMWorkloadSAPHanaDatabase ProtectedItemType = "AzureVmWorkloadSAPHanaDatabase"
	// ProtectedItemTypeAzureVMWorkloadSQLDatabase ...
	ProtectedItemTypeAzureVMWorkloadSQLDatabase ProtectedItemType = "AzureVmWorkloadSQLDatabase"
	// ProtectedItemTypeDPMProtectedItem ...
	ProtectedItemTypeDPMProtectedItem ProtectedItemType = "DPMProtectedItem"
	// ProtectedItemTypeGenericProtectedItem ...
	ProtectedItemTypeGenericProtectedItem ProtectedItemType = "GenericProtectedItem"
	// ProtectedItemTypeMabFileFolderProtectedItem ...
	ProtectedItemTypeMabFileFolderProtectedItem ProtectedItemType = "MabFileFolderProtectedItem"
	// ProtectedItemTypeMicrosoftClassicComputevirtualMachines ...
	ProtectedItemTypeMicrosoftClassicComputevirtualMachines ProtectedItemType = "Microsoft.ClassicCompute/virtualMachines"
	// ProtectedItemTypeMicrosoftComputevirtualMachines ...
	ProtectedItemTypeMicrosoftComputevirtualMachines ProtectedItemType = "Microsoft.Compute/virtualMachines"
	// ProtectedItemTypeMicrosoftSqlserversdatabases ...
	ProtectedItemTypeMicrosoftSqlserversdatabases ProtectedItemType = "Microsoft.Sql/servers/databases"
	// ProtectedItemTypeProtectedItem ...
	ProtectedItemTypeProtectedItem ProtectedItemType = "ProtectedItem"
)

// PossibleProtectedItemTypeValues returns an array of possible values for the ProtectedItemType const type.
func PossibleProtectedItemTypeValues() []ProtectedItemType {
	return []ProtectedItemType{ProtectedItemTypeAzureFileShareProtectedItem, ProtectedItemTypeAzureIaaSVMProtectedItem, ProtectedItemTypeAzureVMWorkloadProtectedItem, ProtectedItemTypeAzureVMWorkloadSAPAseDatabase, ProtectedItemTypeAzureVMWorkloadSAPHanaDatabase, ProtectedItemTypeAzureVMWorkloadSQLDatabase, ProtectedItemTypeDPMProtectedItem, ProtectedItemTypeGenericProtectedItem, ProtectedItemTypeMabFileFolderProtectedItem, ProtectedItemTypeMicrosoftClassicComputevirtualMachines, ProtectedItemTypeMicrosoftComputevirtualMachines, ProtectedItemTypeMicrosoftSqlserversdatabases, ProtectedItemTypeProtectedItem}
}

// ProtectionIntentItemType enumerates the values for protection intent item type.
type ProtectionIntentItemType string

const (
	// ProtectionIntentItemTypeAzureResourceItem ...
	ProtectionIntentItemTypeAzureResourceItem ProtectionIntentItemType = "AzureResourceItem"
	// ProtectionIntentItemTypeAzureWorkloadAutoProtectionIntent ...
	ProtectionIntentItemTypeAzureWorkloadAutoProtectionIntent ProtectionIntentItemType = "AzureWorkloadAutoProtectionIntent"
	// ProtectionIntentItemTypeAzureWorkloadSQLAutoProtectionIntent ...
	ProtectionIntentItemTypeAzureWorkloadSQLAutoProtectionIntent ProtectionIntentItemType = "AzureWorkloadSQLAutoProtectionIntent"
	// ProtectionIntentItemTypeProtectionIntent ...
	ProtectionIntentItemTypeProtectionIntent ProtectionIntentItemType = "ProtectionIntent"
	// ProtectionIntentItemTypeRecoveryServiceVaultItem ...
	ProtectionIntentItemTypeRecoveryServiceVaultItem ProtectionIntentItemType = "RecoveryServiceVaultItem"
)

// PossibleProtectionIntentItemTypeValues returns an array of possible values for the ProtectionIntentItemType const type.
func PossibleProtectionIntentItemTypeValues() []ProtectionIntentItemType {
	return []ProtectionIntentItemType{ProtectionIntentItemTypeAzureResourceItem, ProtectionIntentItemTypeAzureWorkloadAutoProtectionIntent, ProtectionIntentItemTypeAzureWorkloadSQLAutoProtectionIntent, ProtectionIntentItemTypeProtectionIntent, ProtectionIntentItemTypeRecoveryServiceVaultItem}
}

// ProtectionState enumerates the values for protection state.
type ProtectionState string

const (
	// ProtectionStateInvalid ...
	ProtectionStateInvalid ProtectionState = "Invalid"
	// ProtectionStateIRPending ...
	ProtectionStateIRPending ProtectionState = "IRPending"
	// ProtectionStateProtected ...
	ProtectionStateProtected ProtectionState = "Protected"
	// ProtectionStateProtectionError ...
	ProtectionStateProtectionError ProtectionState = "ProtectionError"
	// ProtectionStateProtectionPaused ...
	ProtectionStateProtectionPaused ProtectionState = "ProtectionPaused"
	// ProtectionStateProtectionStopped ...
	ProtectionStateProtectionStopped ProtectionState = "ProtectionStopped"
)

// PossibleProtectionStateValues returns an array of possible values for the ProtectionState const type.
func PossibleProtectionStateValues() []ProtectionState {
	return []ProtectionState{ProtectionStateInvalid, ProtectionStateIRPending, ProtectionStateProtected, ProtectionStateProtectionError, ProtectionStateProtectionPaused, ProtectionStateProtectionStopped}
}

// ProtectionStatus enumerates the values for protection status.
type ProtectionStatus string

const (
	// ProtectionStatusInvalid ...
	ProtectionStatusInvalid ProtectionStatus = "Invalid"
	// ProtectionStatusNotProtected ...
	ProtectionStatusNotProtected ProtectionStatus = "NotProtected"
	// ProtectionStatusProtected ...
	ProtectionStatusProtected ProtectionStatus = "Protected"
	// ProtectionStatusProtecting ...
	ProtectionStatusProtecting ProtectionStatus = "Protecting"
	// ProtectionStatusProtectionFailed ...
	ProtectionStatusProtectionFailed ProtectionStatus = "ProtectionFailed"
)

// PossibleProtectionStatusValues returns an array of possible values for the ProtectionStatus const type.
func PossibleProtectionStatusValues() []ProtectionStatus {
	return []ProtectionStatus{ProtectionStatusInvalid, ProtectionStatusNotProtected, ProtectionStatusProtected, ProtectionStatusProtecting, ProtectionStatusProtectionFailed}
}

// RecoveryMode enumerates the values for recovery mode.
type RecoveryMode string

const (
	// RecoveryModeFileRecovery ...
	RecoveryModeFileRecovery RecoveryMode = "FileRecovery"
	// RecoveryModeInvalid ...
	RecoveryModeInvalid RecoveryMode = "Invalid"
	// RecoveryModeWorkloadRecovery ...
	RecoveryModeWorkloadRecovery RecoveryMode = "WorkloadRecovery"
)

// PossibleRecoveryModeValues returns an array of possible values for the RecoveryMode const type.
func PossibleRecoveryModeValues() []RecoveryMode {
	return []RecoveryMode{RecoveryModeFileRecovery, RecoveryModeInvalid, RecoveryModeWorkloadRecovery}
}

// RecoveryPointTierStatus enumerates the values for recovery point tier status.
type RecoveryPointTierStatus string

const (
	// RecoveryPointTierStatusDeleted ...
	RecoveryPointTierStatusDeleted RecoveryPointTierStatus = "Deleted"
	// RecoveryPointTierStatusDisabled ...
	RecoveryPointTierStatusDisabled RecoveryPointTierStatus = "Disabled"
	// RecoveryPointTierStatusInvalid ...
	RecoveryPointTierStatusInvalid RecoveryPointTierStatus = "Invalid"
	// RecoveryPointTierStatusValid ...
	RecoveryPointTierStatusValid RecoveryPointTierStatus = "Valid"
)

// PossibleRecoveryPointTierStatusValues returns an array of possible values for the RecoveryPointTierStatus const type.
func PossibleRecoveryPointTierStatusValues() []RecoveryPointTierStatus {
	return []RecoveryPointTierStatus{RecoveryPointTierStatusDeleted, RecoveryPointTierStatusDisabled, RecoveryPointTierStatusInvalid, RecoveryPointTierStatusValid}
}

// RecoveryPointTierType enumerates the values for recovery point tier type.
type RecoveryPointTierType string

const (
	// RecoveryPointTierTypeHardenedRP ...
	RecoveryPointTierTypeHardenedRP RecoveryPointTierType = "HardenedRP"
	// RecoveryPointTierTypeInstantRP ...
	RecoveryPointTierTypeInstantRP RecoveryPointTierType = "InstantRP"
	// RecoveryPointTierTypeInvalid ...
	RecoveryPointTierTypeInvalid RecoveryPointTierType = "Invalid"
)

// PossibleRecoveryPointTierTypeValues returns an array of possible values for the RecoveryPointTierType const type.
func PossibleRecoveryPointTierTypeValues() []RecoveryPointTierType {
	return []RecoveryPointTierType{RecoveryPointTierTypeHardenedRP, RecoveryPointTierTypeInstantRP, RecoveryPointTierTypeInvalid}
}

// RecoveryType enumerates the values for recovery type.
type RecoveryType string

const (
	// RecoveryTypeAlternateLocation ...
	RecoveryTypeAlternateLocation RecoveryType = "AlternateLocation"
	// RecoveryTypeInvalid ...
	RecoveryTypeInvalid RecoveryType = "Invalid"
	// RecoveryTypeOffline ...
	RecoveryTypeOffline RecoveryType = "Offline"
	// RecoveryTypeOriginalLocation ...
	RecoveryTypeOriginalLocation RecoveryType = "OriginalLocation"
	// RecoveryTypeRestoreDisks ...
	RecoveryTypeRestoreDisks RecoveryType = "RestoreDisks"
)

// PossibleRecoveryTypeValues returns an array of possible values for the RecoveryType const type.
func PossibleRecoveryTypeValues() []RecoveryType {
	return []RecoveryType{RecoveryTypeAlternateLocation, RecoveryTypeInvalid, RecoveryTypeOffline, RecoveryTypeOriginalLocation, RecoveryTypeRestoreDisks}
}

// RestorePointQueryType enumerates the values for restore point query type.
type RestorePointQueryType string

const (
	// RestorePointQueryTypeAll ...
	RestorePointQueryTypeAll RestorePointQueryType = "All"
	// RestorePointQueryTypeDifferential ...
	RestorePointQueryTypeDifferential RestorePointQueryType = "Differential"
	// RestorePointQueryTypeFull ...
	RestorePointQueryTypeFull RestorePointQueryType = "Full"
	// RestorePointQueryTypeFullAndDifferential ...
	RestorePointQueryTypeFullAndDifferential RestorePointQueryType = "FullAndDifferential"
	// RestorePointQueryTypeInvalid ...
	RestorePointQueryTypeInvalid RestorePointQueryType = "Invalid"
	// RestorePointQueryTypeLog ...
	RestorePointQueryTypeLog RestorePointQueryType = "Log"
)

// PossibleRestorePointQueryTypeValues returns an array of possible values for the RestorePointQueryType const type.
func PossibleRestorePointQueryTypeValues() []RestorePointQueryType {
	return []RestorePointQueryType{RestorePointQueryTypeAll, RestorePointQueryTypeDifferential, RestorePointQueryTypeFull, RestorePointQueryTypeFullAndDifferential, RestorePointQueryTypeInvalid, RestorePointQueryTypeLog}
}

// RestorePointType enumerates the values for restore point type.
type RestorePointType string

const (
	// RestorePointTypeDifferential ...
	RestorePointTypeDifferential RestorePointType = "Differential"
	// RestorePointTypeFull ...
	RestorePointTypeFull RestorePointType = "Full"
	// RestorePointTypeInvalid ...
	RestorePointTypeInvalid RestorePointType = "Invalid"
	// RestorePointTypeLog ...
	RestorePointTypeLog RestorePointType = "Log"
)

// PossibleRestorePointTypeValues returns an array of possible values for the RestorePointType const type.
func PossibleRestorePointTypeValues() []RestorePointType {
	return []RestorePointType{RestorePointTypeDifferential, RestorePointTypeFull, RestorePointTypeInvalid, RestorePointTypeLog}
}

// RestoreRequestType enumerates the values for restore request type.
type RestoreRequestType string

const (
	// RestoreRequestTypeFullShareRestore ...
	RestoreRequestTypeFullShareRestore RestoreRequestType = "FullShareRestore"
	// RestoreRequestTypeInvalid ...
	RestoreRequestTypeInvalid RestoreRequestType = "Invalid"
	// RestoreRequestTypeItemLevelRestore ...
	RestoreRequestTypeItemLevelRestore RestoreRequestType = "ItemLevelRestore"
)

// PossibleRestoreRequestTypeValues returns an array of possible values for the RestoreRequestType const type.
func PossibleRestoreRequestTypeValues() []RestoreRequestType {
	return []RestoreRequestType{RestoreRequestTypeFullShareRestore, RestoreRequestTypeInvalid, RestoreRequestTypeItemLevelRestore}
}

// RetentionDurationType enumerates the values for retention duration type.
type RetentionDurationType string

const (
	// RetentionDurationTypeDays ...
	RetentionDurationTypeDays RetentionDurationType = "Days"
	// RetentionDurationTypeInvalid ...
	RetentionDurationTypeInvalid RetentionDurationType = "Invalid"
	// RetentionDurationTypeMonths ...
	RetentionDurationTypeMonths RetentionDurationType = "Months"
	// RetentionDurationTypeWeeks ...
	RetentionDurationTypeWeeks RetentionDurationType = "Weeks"
	// RetentionDurationTypeYears ...
	RetentionDurationTypeYears RetentionDurationType = "Years"
)

// PossibleRetentionDurationTypeValues returns an array of possible values for the RetentionDurationType const type.
func PossibleRetentionDurationTypeValues() []RetentionDurationType {
	return []RetentionDurationType{RetentionDurationTypeDays, RetentionDurationTypeInvalid, RetentionDurationTypeMonths, RetentionDurationTypeWeeks, RetentionDurationTypeYears}
}

// RetentionPolicyType enumerates the values for retention policy type.
type RetentionPolicyType string

const (
	// RetentionPolicyTypeLongTermRetentionPolicy ...
	RetentionPolicyTypeLongTermRetentionPolicy RetentionPolicyType = "LongTermRetentionPolicy"
	// RetentionPolicyTypeRetentionPolicy ...
	RetentionPolicyTypeRetentionPolicy RetentionPolicyType = "RetentionPolicy"
	// RetentionPolicyTypeSimpleRetentionPolicy ...
	RetentionPolicyTypeSimpleRetentionPolicy RetentionPolicyType = "SimpleRetentionPolicy"
)

// PossibleRetentionPolicyTypeValues returns an array of possible values for the RetentionPolicyType const type.
func PossibleRetentionPolicyTypeValues() []RetentionPolicyType {
	return []RetentionPolicyType{RetentionPolicyTypeLongTermRetentionPolicy, RetentionPolicyTypeRetentionPolicy, RetentionPolicyTypeSimpleRetentionPolicy}
}

// RetentionScheduleFormat enumerates the values for retention schedule format.
type RetentionScheduleFormat string

const (
	// RetentionScheduleFormatDaily ...
	RetentionScheduleFormatDaily RetentionScheduleFormat = "Daily"
	// RetentionScheduleFormatInvalid ...
	RetentionScheduleFormatInvalid RetentionScheduleFormat = "Invalid"
	// RetentionScheduleFormatWeekly ...
	RetentionScheduleFormatWeekly RetentionScheduleFormat = "Weekly"
)

// PossibleRetentionScheduleFormatValues returns an array of possible values for the RetentionScheduleFormat const type.
func PossibleRetentionScheduleFormatValues() []RetentionScheduleFormat {
	return []RetentionScheduleFormat{RetentionScheduleFormatDaily, RetentionScheduleFormatInvalid, RetentionScheduleFormatWeekly}
}

// SchedulePolicyType enumerates the values for schedule policy type.
type SchedulePolicyType string

const (
	// SchedulePolicyTypeLogSchedulePolicy ...
	SchedulePolicyTypeLogSchedulePolicy SchedulePolicyType = "LogSchedulePolicy"
	// SchedulePolicyTypeLongTermSchedulePolicy ...
	SchedulePolicyTypeLongTermSchedulePolicy SchedulePolicyType = "LongTermSchedulePolicy"
	// SchedulePolicyTypeSchedulePolicy ...
	SchedulePolicyTypeSchedulePolicy SchedulePolicyType = "SchedulePolicy"
	// SchedulePolicyTypeSimpleSchedulePolicy ...
	SchedulePolicyTypeSimpleSchedulePolicy SchedulePolicyType = "SimpleSchedulePolicy"
)

// PossibleSchedulePolicyTypeValues returns an array of possible values for the SchedulePolicyType const type.
func PossibleSchedulePolicyTypeValues() []SchedulePolicyType {
	return []SchedulePolicyType{SchedulePolicyTypeLogSchedulePolicy, SchedulePolicyTypeLongTermSchedulePolicy, SchedulePolicyTypeSchedulePolicy, SchedulePolicyTypeSimpleSchedulePolicy}
}

// ScheduleRunType enumerates the values for schedule run type.
type ScheduleRunType string

const (
	// ScheduleRunTypeDaily ...
	ScheduleRunTypeDaily ScheduleRunType = "Daily"
	// ScheduleRunTypeInvalid ...
	ScheduleRunTypeInvalid ScheduleRunType = "Invalid"
	// ScheduleRunTypeWeekly ...
	ScheduleRunTypeWeekly ScheduleRunType = "Weekly"
)

// PossibleScheduleRunTypeValues returns an array of possible values for the ScheduleRunType const type.
func PossibleScheduleRunTypeValues() []ScheduleRunType {
	return []ScheduleRunType{ScheduleRunTypeDaily, ScheduleRunTypeInvalid, ScheduleRunTypeWeekly}
}

// SoftDeleteFeatureState enumerates the values for soft delete feature state.
type SoftDeleteFeatureState string

const (
	// SoftDeleteFeatureStateDisabled ...
	SoftDeleteFeatureStateDisabled SoftDeleteFeatureState = "Disabled"
	// SoftDeleteFeatureStateEnabled ...
	SoftDeleteFeatureStateEnabled SoftDeleteFeatureState = "Enabled"
	// SoftDeleteFeatureStateInvalid ...
	SoftDeleteFeatureStateInvalid SoftDeleteFeatureState = "Invalid"
)

// PossibleSoftDeleteFeatureStateValues returns an array of possible values for the SoftDeleteFeatureState const type.
func PossibleSoftDeleteFeatureStateValues() []SoftDeleteFeatureState {
	return []SoftDeleteFeatureState{SoftDeleteFeatureStateDisabled, SoftDeleteFeatureStateEnabled, SoftDeleteFeatureStateInvalid}
}

// SQLDataDirectoryType enumerates the values for sql data directory type.
type SQLDataDirectoryType string

const (
	// SQLDataDirectoryTypeData ...
	SQLDataDirectoryTypeData SQLDataDirectoryType = "Data"
	// SQLDataDirectoryTypeInvalid ...
	SQLDataDirectoryTypeInvalid SQLDataDirectoryType = "Invalid"
	// SQLDataDirectoryTypeLog ...
	SQLDataDirectoryTypeLog SQLDataDirectoryType = "Log"
)

// PossibleSQLDataDirectoryTypeValues returns an array of possible values for the SQLDataDirectoryType const type.
func PossibleSQLDataDirectoryTypeValues() []SQLDataDirectoryType {
	return []SQLDataDirectoryType{SQLDataDirectoryTypeData, SQLDataDirectoryTypeInvalid, SQLDataDirectoryTypeLog}
}

// StorageType enumerates the values for storage type.
type StorageType string

const (
	// StorageTypeGeoRedundant ...
	StorageTypeGeoRedundant StorageType = "GeoRedundant"
	// StorageTypeInvalid ...
	StorageTypeInvalid StorageType = "Invalid"
	// StorageTypeLocallyRedundant ...
	StorageTypeLocallyRedundant StorageType = "LocallyRedundant"
)

// PossibleStorageTypeValues returns an array of possible values for the StorageType const type.
func PossibleStorageTypeValues() []StorageType {
	return []StorageType{StorageTypeGeoRedundant, StorageTypeInvalid, StorageTypeLocallyRedundant}
}

// StorageTypeState enumerates the values for storage type state.
type StorageTypeState string

const (
	// StorageTypeStateInvalid ...
	StorageTypeStateInvalid StorageTypeState = "Invalid"
	// StorageTypeStateLocked ...
	StorageTypeStateLocked StorageTypeState = "Locked"
	// StorageTypeStateUnlocked ...
	StorageTypeStateUnlocked StorageTypeState = "Unlocked"
)

// PossibleStorageTypeStateValues returns an array of possible values for the StorageTypeState const type.
func PossibleStorageTypeStateValues() []StorageTypeState {
	return []StorageTypeState{StorageTypeStateInvalid, StorageTypeStateLocked, StorageTypeStateUnlocked}
}

// SupportStatus enumerates the values for support status.
type SupportStatus string

const (
	// SupportStatusDefaultOFF ...
	SupportStatusDefaultOFF SupportStatus = "DefaultOFF"
	// SupportStatusDefaultON ...
	SupportStatusDefaultON SupportStatus = "DefaultON"
	// SupportStatusInvalid ...
	SupportStatusInvalid SupportStatus = "Invalid"
	// SupportStatusNotSupported ...
	SupportStatusNotSupported SupportStatus = "NotSupported"
	// SupportStatusSupported ...
	SupportStatusSupported SupportStatus = "Supported"
)

// PossibleSupportStatusValues returns an array of possible values for the SupportStatus const type.
func PossibleSupportStatusValues() []SupportStatus {
	return []SupportStatus{SupportStatusDefaultOFF, SupportStatusDefaultON, SupportStatusInvalid, SupportStatusNotSupported, SupportStatusSupported}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeBackupProtectedItemCountSummary ...
	TypeBackupProtectedItemCountSummary Type = "BackupProtectedItemCountSummary"
	// TypeBackupProtectionContainerCountSummary ...
	TypeBackupProtectionContainerCountSummary Type = "BackupProtectionContainerCountSummary"
	// TypeInvalid ...
	TypeInvalid Type = "Invalid"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeBackupProtectedItemCountSummary, TypeBackupProtectionContainerCountSummary, TypeInvalid}
}

// TypeEnum enumerates the values for type enum.
type TypeEnum string

const (
	// TypeEnumCopyOnlyFull ...
	TypeEnumCopyOnlyFull TypeEnum = "CopyOnlyFull"
	// TypeEnumDifferential ...
	TypeEnumDifferential TypeEnum = "Differential"
	// TypeEnumFull ...
	TypeEnumFull TypeEnum = "Full"
	// TypeEnumInvalid ...
	TypeEnumInvalid TypeEnum = "Invalid"
	// TypeEnumLog ...
	TypeEnumLog TypeEnum = "Log"
)

// PossibleTypeEnumValues returns an array of possible values for the TypeEnum const type.
func PossibleTypeEnumValues() []TypeEnum {
	return []TypeEnum{TypeEnumCopyOnlyFull, TypeEnumDifferential, TypeEnumFull, TypeEnumInvalid, TypeEnumLog}
}

// UsagesUnit enumerates the values for usages unit.
type UsagesUnit string

const (
	// Bytes ...
	Bytes UsagesUnit = "Bytes"
	// BytesPerSecond ...
	BytesPerSecond UsagesUnit = "BytesPerSecond"
	// Count ...
	Count UsagesUnit = "Count"
	// CountPerSecond ...
	CountPerSecond UsagesUnit = "CountPerSecond"
	// Percent ...
	Percent UsagesUnit = "Percent"
	// Seconds ...
	Seconds UsagesUnit = "Seconds"
)

// PossibleUsagesUnitValues returns an array of possible values for the UsagesUnit const type.
func PossibleUsagesUnitValues() []UsagesUnit {
	return []UsagesUnit{Bytes, BytesPerSecond, Count, CountPerSecond, Percent, Seconds}
}

// ValidationStatus enumerates the values for validation status.
type ValidationStatus string

const (
	// ValidationStatusFailed ...
	ValidationStatusFailed ValidationStatus = "Failed"
	// ValidationStatusInvalid ...
	ValidationStatusInvalid ValidationStatus = "Invalid"
	// ValidationStatusSucceeded ...
	ValidationStatusSucceeded ValidationStatus = "Succeeded"
)

// PossibleValidationStatusValues returns an array of possible values for the ValidationStatus const type.
func PossibleValidationStatusValues() []ValidationStatus {
	return []ValidationStatus{ValidationStatusFailed, ValidationStatusInvalid, ValidationStatusSucceeded}
}

// WeekOfMonth enumerates the values for week of month.
type WeekOfMonth string

const (
	// WeekOfMonthFirst ...
	WeekOfMonthFirst WeekOfMonth = "First"
	// WeekOfMonthFourth ...
	WeekOfMonthFourth WeekOfMonth = "Fourth"
	// WeekOfMonthInvalid ...
	WeekOfMonthInvalid WeekOfMonth = "Invalid"
	// WeekOfMonthLast ...
	WeekOfMonthLast WeekOfMonth = "Last"
	// WeekOfMonthSecond ...
	WeekOfMonthSecond WeekOfMonth = "Second"
	// WeekOfMonthThird ...
	WeekOfMonthThird WeekOfMonth = "Third"
)

// PossibleWeekOfMonthValues returns an array of possible values for the WeekOfMonth const type.
func PossibleWeekOfMonthValues() []WeekOfMonth {
	return []WeekOfMonth{WeekOfMonthFirst, WeekOfMonthFourth, WeekOfMonthInvalid, WeekOfMonthLast, WeekOfMonthSecond, WeekOfMonthThird}
}

// WorkloadItemType enumerates the values for workload item type.
type WorkloadItemType string

const (
	// WorkloadItemTypeInvalid ...
	WorkloadItemTypeInvalid WorkloadItemType = "Invalid"
	// WorkloadItemTypeSAPAseDatabase ...
	WorkloadItemTypeSAPAseDatabase WorkloadItemType = "SAPAseDatabase"
	// WorkloadItemTypeSAPAseSystem ...
	WorkloadItemTypeSAPAseSystem WorkloadItemType = "SAPAseSystem"
	// WorkloadItemTypeSAPHanaDatabase ...
	WorkloadItemTypeSAPHanaDatabase WorkloadItemType = "SAPHanaDatabase"
	// WorkloadItemTypeSAPHanaSystem ...
	WorkloadItemTypeSAPHanaSystem WorkloadItemType = "SAPHanaSystem"
	// WorkloadItemTypeSQLDataBase ...
	WorkloadItemTypeSQLDataBase WorkloadItemType = "SQLDataBase"
	// WorkloadItemTypeSQLInstance ...
	WorkloadItemTypeSQLInstance WorkloadItemType = "SQLInstance"
)

// PossibleWorkloadItemTypeValues returns an array of possible values for the WorkloadItemType const type.
func PossibleWorkloadItemTypeValues() []WorkloadItemType {
	return []WorkloadItemType{WorkloadItemTypeInvalid, WorkloadItemTypeSAPAseDatabase, WorkloadItemTypeSAPAseSystem, WorkloadItemTypeSAPHanaDatabase, WorkloadItemTypeSAPHanaSystem, WorkloadItemTypeSQLDataBase, WorkloadItemTypeSQLInstance}
}

// WorkloadItemTypeBasicWorkloadItem enumerates the values for workload item type basic workload item.
type WorkloadItemTypeBasicWorkloadItem string

const (
	// WorkloadItemTypeAzureVMWorkloadItem ...
	WorkloadItemTypeAzureVMWorkloadItem WorkloadItemTypeBasicWorkloadItem = "AzureVmWorkloadItem"
	// WorkloadItemTypeSAPAseDatabase1 ...
	WorkloadItemTypeSAPAseDatabase1 WorkloadItemTypeBasicWorkloadItem = "SAPAseDatabase"
	// WorkloadItemTypeSAPAseSystem1 ...
	WorkloadItemTypeSAPAseSystem1 WorkloadItemTypeBasicWorkloadItem = "SAPAseSystem"
	// WorkloadItemTypeSAPHanaDatabase1 ...
	WorkloadItemTypeSAPHanaDatabase1 WorkloadItemTypeBasicWorkloadItem = "SAPHanaDatabase"
	// WorkloadItemTypeSAPHanaSystem1 ...
	WorkloadItemTypeSAPHanaSystem1 WorkloadItemTypeBasicWorkloadItem = "SAPHanaSystem"
	// WorkloadItemTypeSQLDataBase1 ...
	WorkloadItemTypeSQLDataBase1 WorkloadItemTypeBasicWorkloadItem = "SQLDataBase"
	// WorkloadItemTypeSQLInstance1 ...
	WorkloadItemTypeSQLInstance1 WorkloadItemTypeBasicWorkloadItem = "SQLInstance"
	// WorkloadItemTypeWorkloadItem ...
	WorkloadItemTypeWorkloadItem WorkloadItemTypeBasicWorkloadItem = "WorkloadItem"
)

// PossibleWorkloadItemTypeBasicWorkloadItemValues returns an array of possible values for the WorkloadItemTypeBasicWorkloadItem const type.
func PossibleWorkloadItemTypeBasicWorkloadItemValues() []WorkloadItemTypeBasicWorkloadItem {
	return []WorkloadItemTypeBasicWorkloadItem{WorkloadItemTypeAzureVMWorkloadItem, WorkloadItemTypeSAPAseDatabase1, WorkloadItemTypeSAPAseSystem1, WorkloadItemTypeSAPHanaDatabase1, WorkloadItemTypeSAPHanaSystem1, WorkloadItemTypeSQLDataBase1, WorkloadItemTypeSQLInstance1, WorkloadItemTypeWorkloadItem}
}

// WorkloadType enumerates the values for workload type.
type WorkloadType string

const (
	// WorkloadTypeAzureFileShare ...
	WorkloadTypeAzureFileShare WorkloadType = "AzureFileShare"
	// WorkloadTypeAzureSQLDb ...
	WorkloadTypeAzureSQLDb WorkloadType = "AzureSqlDb"
	// WorkloadTypeClient ...
	WorkloadTypeClient WorkloadType = "Client"
	// WorkloadTypeExchange ...
	WorkloadTypeExchange WorkloadType = "Exchange"
	// WorkloadTypeFileFolder ...
	WorkloadTypeFileFolder WorkloadType = "FileFolder"
	// WorkloadTypeGenericDataSource ...
	WorkloadTypeGenericDataSource WorkloadType = "GenericDataSource"
	// WorkloadTypeInvalid ...
	WorkloadTypeInvalid WorkloadType = "Invalid"
	// WorkloadTypeSAPAseDatabase ...
	WorkloadTypeSAPAseDatabase WorkloadType = "SAPAseDatabase"
	// WorkloadTypeSAPHanaDatabase ...
	WorkloadTypeSAPHanaDatabase WorkloadType = "SAPHanaDatabase"
	// WorkloadTypeSharepoint ...
	WorkloadTypeSharepoint WorkloadType = "Sharepoint"
	// WorkloadTypeSQLDataBase ...
	WorkloadTypeSQLDataBase WorkloadType = "SQLDataBase"
	// WorkloadTypeSQLDB ...
	WorkloadTypeSQLDB WorkloadType = "SQLDB"
	// WorkloadTypeSystemState ...
	WorkloadTypeSystemState WorkloadType = "SystemState"
	// WorkloadTypeVM ...
	WorkloadTypeVM WorkloadType = "VM"
	// WorkloadTypeVMwareVM ...
	WorkloadTypeVMwareVM WorkloadType = "VMwareVM"
)

// PossibleWorkloadTypeValues returns an array of possible values for the WorkloadType const type.
func PossibleWorkloadTypeValues() []WorkloadType {
	return []WorkloadType{WorkloadTypeAzureFileShare, WorkloadTypeAzureSQLDb, WorkloadTypeClient, WorkloadTypeExchange, WorkloadTypeFileFolder, WorkloadTypeGenericDataSource, WorkloadTypeInvalid, WorkloadTypeSAPAseDatabase, WorkloadTypeSAPHanaDatabase, WorkloadTypeSharepoint, WorkloadTypeSQLDataBase, WorkloadTypeSQLDB, WorkloadTypeSystemState, WorkloadTypeVM, WorkloadTypeVMwareVM}
}

// AzureBackupGoalFeatureSupportRequest azure backup goal feature specific request.
type AzureBackupGoalFeatureSupportRequest struct {
	// FeatureType - Possible values include: 'FeatureTypeFeatureSupportRequest', 'FeatureTypeAzureBackupGoals', 'FeatureTypeAzureVMResourceBackup'
	FeatureType FeatureType `json:"featureType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBackupGoalFeatureSupportRequest.
func (abgfsr AzureBackupGoalFeatureSupportRequest) MarshalJSON() ([]byte, error) {
	abgfsr.FeatureType = FeatureTypeAzureBackupGoals
	objectMap := make(map[string]interface{})
	if abgfsr.FeatureType != "" {
		objectMap["featureType"] = abgfsr.FeatureType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupGoalFeatureSupportRequest is the BasicFeatureSupportRequest implementation for AzureBackupGoalFeatureSupportRequest.
func (abgfsr AzureBackupGoalFeatureSupportRequest) AsAzureBackupGoalFeatureSupportRequest() (*AzureBackupGoalFeatureSupportRequest, bool) {
	return &abgfsr, true
}

// AsAzureVMResourceFeatureSupportRequest is the BasicFeatureSupportRequest implementation for AzureBackupGoalFeatureSupportRequest.
func (abgfsr AzureBackupGoalFeatureSupportRequest) AsAzureVMResourceFeatureSupportRequest() (*AzureVMResourceFeatureSupportRequest, bool) {
	return nil, false
}

// AsFeatureSupportRequest is the BasicFeatureSupportRequest implementation for AzureBackupGoalFeatureSupportRequest.
func (abgfsr AzureBackupGoalFeatureSupportRequest) AsFeatureSupportRequest() (*FeatureSupportRequest, bool) {
	return nil, false
}

// AsBasicFeatureSupportRequest is the BasicFeatureSupportRequest implementation for AzureBackupGoalFeatureSupportRequest.
func (abgfsr AzureBackupGoalFeatureSupportRequest) AsBasicFeatureSupportRequest() (BasicFeatureSupportRequest, bool) {
	return &abgfsr, true
}

// AzureBackupServerContainer azureBackupServer (DPMVenus) workload-specific protection container.
type AzureBackupServerContainer struct {
	// CanReRegister - Specifies whether the container is re-registrable.
	CanReRegister *bool `json:"canReRegister,omitempty"`
	// ContainerID - ID of container.
	ContainerID *string `json:"containerId,omitempty"`
	// ProtectedItemCount - Number of protected items in the BackupEngine
	ProtectedItemCount *int64 `json:"protectedItemCount,omitempty"`
	// DpmAgentVersion - Backup engine Agent version
	DpmAgentVersion *string `json:"dpmAgentVersion,omitempty"`
	// DpmServers - List of BackupEngines protecting the container
	DpmServers *[]string `json:"dpmServers,omitempty"`
	// UpgradeAvailable - To check if upgrade available
	UpgradeAvailable *bool `json:"upgradeAvailable,omitempty"`
	// ProtectionStatus - Protection status of the container.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`
	// ExtendedInfo - Extended Info of the container.
	ExtendedInfo *DPMContainerExtendedInfo `json:"extendedInfo,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) MarshalJSON() ([]byte, error) {
	absc.ContainerType = ContainerTypeAzureBackupServerContainer1
	objectMap := make(map[string]interface{})
	if absc.CanReRegister != nil {
		objectMap["canReRegister"] = absc.CanReRegister
	}
	if absc.ContainerID != nil {
		objectMap["containerId"] = absc.ContainerID
	}
	if absc.ProtectedItemCount != nil {
		objectMap["protectedItemCount"] = absc.ProtectedItemCount
	}
	if absc.DpmAgentVersion != nil {
		objectMap["dpmAgentVersion"] = absc.DpmAgentVersion
	}
	if absc.DpmServers != nil {
		objectMap["dpmServers"] = absc.DpmServers
	}
	if absc.UpgradeAvailable != nil {
		objectMap["upgradeAvailable"] = absc.UpgradeAvailable
	}
	if absc.ProtectionStatus != nil {
		objectMap["protectionStatus"] = absc.ProtectionStatus
	}
	if absc.ExtendedInfo != nil {
		objectMap["extendedInfo"] = absc.ExtendedInfo
	}
	if absc.FriendlyName != nil {
		objectMap["friendlyName"] = absc.FriendlyName
	}
	if absc.BackupManagementType != "" {
		objectMap["backupManagementType"] = absc.BackupManagementType
	}
	if absc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = absc.RegistrationStatus
	}
	if absc.HealthStatus != nil {
		objectMap["healthStatus"] = absc.HealthStatus
	}
	if absc.ContainerType != "" {
		objectMap["containerType"] = absc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return &absc, true
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return nil, false
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return nil, false
}

// AsDpmContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsDpmContainer() (*DpmContainer, bool) {
	return nil, false
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return &absc, true
}

// AsGenericContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsGenericContainer() (*GenericContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return nil, false
}

// AsMabContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for AzureBackupServerContainer.
func (absc AzureBackupServerContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &absc, true
}

// AzureBackupServerEngine backup engine type when Azure Backup Server is used to manage the backups.
type AzureBackupServerEngine struct {
	// FriendlyName - Friendly name of the backup engine.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the backup engine. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Registration status of the backup engine with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// BackupEngineState - Status of the backup engine with the Recovery Services Vault. = {Active/Deleting/DeleteFailed}
	BackupEngineState *string `json:"backupEngineState,omitempty"`
	// HealthStatus - Backup status of the backup engine.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// CanReRegister - Flag indicating if the backup engine be registered, once already registered.
	CanReRegister *bool `json:"canReRegister,omitempty"`
	// BackupEngineID - ID of the backup engine.
	BackupEngineID *string `json:"backupEngineId,omitempty"`
	// DpmVersion - Backup engine version
	DpmVersion *string `json:"dpmVersion,omitempty"`
	// AzureBackupAgentVersion - Backup agent version
	AzureBackupAgentVersion *string `json:"azureBackupAgentVersion,omitempty"`
	// IsAzureBackupAgentUpgradeAvailable - To check if backup agent upgrade available
	IsAzureBackupAgentUpgradeAvailable *bool `json:"isAzureBackupAgentUpgradeAvailable,omitempty"`
	// IsDpmUpgradeAvailable - To check if backup engine upgrade available
	IsDpmUpgradeAvailable *bool `json:"isDpmUpgradeAvailable,omitempty"`
	// ExtendedInfo - Extended info of the backupengine
	ExtendedInfo *EngineExtendedInfo `json:"extendedInfo,omitempty"`
	// BackupEngineType - Possible values include: 'BackupEngineTypeBackupEngineBase', 'BackupEngineTypeAzureBackupServerEngine', 'BackupEngineTypeDpmBackupEngine'
	BackupEngineType EngineType `json:"backupEngineType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBackupServerEngine.
func (abse AzureBackupServerEngine) MarshalJSON() ([]byte, error) {
	abse.BackupEngineType = BackupEngineTypeAzureBackupServerEngine
	objectMap := make(map[string]interface{})
	if abse.FriendlyName != nil {
		objectMap["friendlyName"] = abse.FriendlyName
	}
	if abse.BackupManagementType != "" {
		objectMap["backupManagementType"] = abse.BackupManagementType
	}
	if abse.RegistrationStatus != nil {
		objectMap["registrationStatus"] = abse.RegistrationStatus
	}
	if abse.BackupEngineState != nil {
		objectMap["backupEngineState"] = abse.BackupEngineState
	}
	if abse.HealthStatus != nil {
		objectMap["healthStatus"] = abse.HealthStatus
	}
	if abse.CanReRegister != nil {
		objectMap["canReRegister"] = abse.CanReRegister
	}
	if abse.BackupEngineID != nil {
		objectMap["backupEngineId"] = abse.BackupEngineID
	}
	if abse.DpmVersion != nil {
		objectMap["dpmVersion"] = abse.DpmVersion
	}
	if abse.AzureBackupAgentVersion != nil {
		objectMap["azureBackupAgentVersion"] = abse.AzureBackupAgentVersion
	}
	if abse.IsAzureBackupAgentUpgradeAvailable != nil {
		objectMap["isAzureBackupAgentUpgradeAvailable"] = abse.IsAzureBackupAgentUpgradeAvailable
	}
	if abse.IsDpmUpgradeAvailable != nil {
		objectMap["isDpmUpgradeAvailable"] = abse.IsDpmUpgradeAvailable
	}
	if abse.ExtendedInfo != nil {
		objectMap["extendedInfo"] = abse.ExtendedInfo
	}
	if abse.BackupEngineType != "" {
		objectMap["backupEngineType"] = abse.BackupEngineType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerEngine is the BasicEngineBase implementation for AzureBackupServerEngine.
func (abse AzureBackupServerEngine) AsAzureBackupServerEngine() (*AzureBackupServerEngine, bool) {
	return &abse, true
}

// AsDpmBackupEngine is the BasicEngineBase implementation for AzureBackupServerEngine.
func (abse AzureBackupServerEngine) AsDpmBackupEngine() (*DpmBackupEngine, bool) {
	return nil, false
}

// AsEngineBase is the BasicEngineBase implementation for AzureBackupServerEngine.
func (abse AzureBackupServerEngine) AsEngineBase() (*EngineBase, bool) {
	return nil, false
}

// AsBasicEngineBase is the BasicEngineBase implementation for AzureBackupServerEngine.
func (abse AzureBackupServerEngine) AsBasicEngineBase() (BasicEngineBase, bool) {
	return &abse, true
}

// AzureFileShareBackupRequest azureFileShare workload-specific backup request.
type AzureFileShareBackupRequest struct {
	// RecoveryPointExpiryTimeInUTC - Backup copy will expire after the time specified (UTC).
	RecoveryPointExpiryTimeInUTC *date.Time `json:"recoveryPointExpiryTimeInUTC,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeBackupRequest', 'ObjectTypeAzureFileShareBackupRequest', 'ObjectTypeAzureWorkloadBackupRequest', 'ObjectTypeIaasVMBackupRequest'
	ObjectType ObjectTypeBasicRequest `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFileShareBackupRequest.
func (afsbr AzureFileShareBackupRequest) MarshalJSON() ([]byte, error) {
	afsbr.ObjectType = ObjectTypeAzureFileShareBackupRequest
	objectMap := make(map[string]interface{})
	if afsbr.RecoveryPointExpiryTimeInUTC != nil {
		objectMap["recoveryPointExpiryTimeInUTC"] = afsbr.RecoveryPointExpiryTimeInUTC
	}
	if afsbr.ObjectType != "" {
		objectMap["objectType"] = afsbr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareBackupRequest is the BasicRequest implementation for AzureFileShareBackupRequest.
func (afsbr AzureFileShareBackupRequest) AsAzureFileShareBackupRequest() (*AzureFileShareBackupRequest, bool) {
	return &afsbr, true
}

// AsAzureWorkloadBackupRequest is the BasicRequest implementation for AzureFileShareBackupRequest.
func (afsbr AzureFileShareBackupRequest) AsAzureWorkloadBackupRequest() (*AzureWorkloadBackupRequest, bool) {
	return nil, false
}

// AsIaasVMBackupRequest is the BasicRequest implementation for AzureFileShareBackupRequest.
func (afsbr AzureFileShareBackupRequest) AsIaasVMBackupRequest() (*IaasVMBackupRequest, bool) {
	return nil, false
}

// AsRequest is the BasicRequest implementation for AzureFileShareBackupRequest.
func (afsbr AzureFileShareBackupRequest) AsRequest() (*Request, bool) {
	return nil, false
}

// AsBasicRequest is the BasicRequest implementation for AzureFileShareBackupRequest.
func (afsbr AzureFileShareBackupRequest) AsBasicRequest() (BasicRequest, bool) {
	return &afsbr, true
}

// AzureFileShareProtectableItem protectable item for Azure Fileshare workloads.
type AzureFileShareProtectableItem struct {
	// ParentContainerFabricID - Full Fabric ID of container to which this protectable item belongs. For example, ARM ID.
	ParentContainerFabricID *string `json:"parentContainerFabricId,omitempty"`
	// ParentContainerFriendlyName - Friendly name of container to which this protectable item belongs.
	ParentContainerFriendlyName *string `json:"parentContainerFriendlyName,omitempty"`
	// AzureFileShareType - File Share type XSync or XSMB. Possible values include: 'Invalid', 'XSMB', 'XSync'
	AzureFileShareType AzureFileShareType `json:"azureFileShareType,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeAzureFileShare', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeAzureVMWorkloadProtectableItem', 'ProtectableItemTypeSAPAseSystem', 'ProtectableItemTypeSAPHanaDatabase', 'ProtectableItemTypeSAPHanaSystem', 'ProtectableItemTypeSQLAvailabilityGroupContainer', 'ProtectableItemTypeSQLDataBase', 'ProtectableItemTypeSQLInstance', 'ProtectableItemTypeIaaSVMProtectableItem'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) MarshalJSON() ([]byte, error) {
	afspi.ProtectableItemType = ProtectableItemTypeAzureFileShare
	objectMap := make(map[string]interface{})
	if afspi.ParentContainerFabricID != nil {
		objectMap["parentContainerFabricId"] = afspi.ParentContainerFabricID
	}
	if afspi.ParentContainerFriendlyName != nil {
		objectMap["parentContainerFriendlyName"] = afspi.ParentContainerFriendlyName
	}
	if afspi.AzureFileShareType != "" {
		objectMap["azureFileShareType"] = afspi.AzureFileShareType
	}
	if afspi.BackupManagementType != nil {
		objectMap["backupManagementType"] = afspi.BackupManagementType
	}
	if afspi.WorkloadType != nil {
		objectMap["workloadType"] = afspi.WorkloadType
	}
	if afspi.FriendlyName != nil {
		objectMap["friendlyName"] = afspi.FriendlyName
	}
	if afspi.ProtectionState != "" {
		objectMap["protectionState"] = afspi.ProtectionState
	}
	if afspi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = afspi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool) {
	return &afspi, true
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool) {
	return nil, false
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return nil, false
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return nil, false
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureFileShareProtectableItem.
func (afspi AzureFileShareProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &afspi, true
}

// AzureFileshareProtectedItem azure File Share workload-specific backup item.
type AzureFileshareProtectedItem struct {
	// FriendlyName - Friendly name of the fileshare represented by this backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionStatus - Backup status of this backup item.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`
	// ProtectionState - Backup state of this backup item. Possible values include: 'ProtectionStateInvalid', 'ProtectionStateIRPending', 'ProtectionStateProtected', 'ProtectionStateProtectionError', 'ProtectionStateProtectionStopped', 'ProtectionStateProtectionPaused'
	ProtectionState ProtectionState `json:"protectionState,omitempty"`
	// HealthStatus - backups running status for this backup item. Possible values include: 'HealthStatusPassed', 'HealthStatusActionRequired', 'HealthStatusActionSuggested', 'HealthStatusInvalid'
	HealthStatus HealthStatus `json:"healthStatus,omitempty"`
	// LastBackupStatus - Last backup operation status. Possible values: Healthy, Unhealthy.
	LastBackupStatus *string `json:"lastBackupStatus,omitempty"`
	// LastBackupTime - Timestamp of the last backup operation on this backup item.
	LastBackupTime *date.Time `json:"lastBackupTime,omitempty"`
	// ExtendedInfo - Additional information with this backup item.
	ExtendedInfo *AzureFileshareProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`
	// BackupManagementType - Type of backup management for the backed up item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload this item represents. Possible values include: 'DataSourceTypeInvalid', 'DataSourceTypeVM', 'DataSourceTypeFileFolder', 'DataSourceTypeAzureSQLDb', 'DataSourceTypeSQLDB', 'DataSourceTypeExchange', 'DataSourceTypeSharepoint', 'DataSourceTypeVMwareVM', 'DataSourceTypeSystemState', 'DataSourceTypeClient', 'DataSourceTypeGenericDataSource', 'DataSourceTypeSQLDataBase', 'DataSourceTypeAzureFileShare', 'DataSourceTypeSAPHanaDatabase', 'DataSourceTypeSAPAseDatabase'
	WorkloadType DataSourceType `json:"workloadType,omitempty"`
	// ContainerName - Unique name of container
	ContainerName *string `json:"containerName,omitempty"`
	// SourceResourceID - ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// PolicyID - ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`
	// LastRecoveryPoint - Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *date.Time `json:"lastRecoveryPoint,omitempty"`
	// BackupSetName - Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`
	// CreateMode - Create mode to indicate recovery of existing soft deleted data source or creation of new data source. Possible values include: 'CreateModeInvalid', 'CreateModeDefault', 'CreateModeRecover'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// DeferredDeleteTimeInUTC - Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *date.Time `json:"deferredDeleteTimeInUTC,omitempty"`
	// IsScheduledForDeferredDelete - Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`
	// DeferredDeleteTimeRemaining - Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`
	// IsDeferredDeleteScheduleUpcoming - Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`
	// IsRehydrate - Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`
	// ProtectedItemType - Possible values include: 'ProtectedItemTypeProtectedItem', 'ProtectedItemTypeAzureFileShareProtectedItem', 'ProtectedItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectedItemTypeMicrosoftComputevirtualMachines', 'ProtectedItemTypeAzureIaaSVMProtectedItem', 'ProtectedItemTypeMicrosoftSqlserversdatabases', 'ProtectedItemTypeAzureVMWorkloadProtectedItem', 'ProtectedItemTypeAzureVMWorkloadSAPAseDatabase', 'ProtectedItemTypeAzureVMWorkloadSAPHanaDatabase', 'ProtectedItemTypeAzureVMWorkloadSQLDatabase', 'ProtectedItemTypeDPMProtectedItem', 'ProtectedItemTypeGenericProtectedItem', 'ProtectedItemTypeMabFileFolderProtectedItem'
	ProtectedItemType ProtectedItemType `json:"protectedItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFileshareProtectedItem.
func (afpi AzureFileshareProtectedItem) MarshalJSON() ([]byte, error) {
	afpi.ProtectedItemType = ProtectedItemTypeAzureFileShareProtectedItem
	objectMap := make(map[string]interface{})
	if afpi.FriendlyName != nil {
		objectMap["friendlyName"] = afpi.FriendlyName
	}
	if afpi.ProtectionStatus != nil {
		objectMap["protectionStatus"] = afpi.ProtectionStatus
	}
	if afpi.ProtectionState != "" {
		objectMap["protectionState"] = afpi.ProtectionState
	}
	if afpi.HealthStatus != "" {
		objectMap["healthStatus"] = afpi.HealthStatus
	}
	if afpi.LastBackupStatus != nil {
		objectMap["lastBackupStatus"] = afpi.LastBackupStatus
	}
	if afpi.LastBackupTime != nil {
		objectMap["lastBackupTime"] = afpi.LastBackupTime
	}
	if afpi.ExtendedInfo != nil {
		objectMap["extendedInfo"] = afpi.ExtendedInfo
	}
	if afpi.BackupManagementType != "" {
		objectMap["backupManagementType"] = afpi.BackupManagementType
	}
	if afpi.WorkloadType != "" {
		objectMap["workloadType"] = afpi.WorkloadType
	}
	if afpi.ContainerName != nil {
		objectMap["containerName"] = afpi.ContainerName
	}
	if afpi.SourceResourceID != nil {
		objectMap["sourceResourceId"] = afpi.SourceResourceID
	}
	if afpi.PolicyID != nil {
		objectMap["policyId"] = afpi.PolicyID
	}
	if afpi.LastRecoveryPoint != nil {
		objectMap["lastRecoveryPoint"] = afpi.LastRecoveryPoint
	}
	if afpi.BackupSetName != nil {
		objectMap["backupSetName"] = afpi.BackupSetName
	}
	if afpi.CreateMode != "" {
		objectMap["createMode"] = afpi.CreateMode
	}
	if afpi.DeferredDeleteTimeInUTC != nil {
		objectMap["deferredDeleteTimeInUTC"] = afpi.DeferredDeleteTimeInUTC
	}
	if afpi.IsScheduledForDeferredDelete != nil {
		objectMap["isScheduledForDeferredDelete"] = afpi.IsScheduledForDeferredDelete
	}
	if afpi.DeferredDeleteTimeRemaining != nil {
		objectMap["deferredDeleteTimeRemaining"] = afpi.DeferredDeleteTimeRemaining
	}
	if afpi.IsDeferredDeleteScheduleUpcoming != nil {
		objectMap["isDeferredDeleteScheduleUpcoming"] = afpi.IsDeferredDeleteScheduleUpcoming
	}
	if afpi.IsRehydrate != nil {
		objectMap["isRehydrate"] = afpi.IsRehydrate
	}
	if afpi.ProtectedItemType != "" {
		objectMap["protectedItemType"] = afpi.ProtectedItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileshareProtectedItem is the BasicProtectedItem implementation for AzureFileshareProtectedItem.
func (afpi AzureFileshareProtectedItem) AsAzureFileshareProtectedItem() (*AzureFileshareProtectedItem, bool) {
	return &afpi, true
}

// AsAzureIaaSClassicComputeVMProtectedItem is the BasicProtectedItem implementation for AzureFileshareProtectedItem.
func (afpi AzureFileshareProtectedItem) AsAzureIaaSClassicComputeVMProtectedItem() (*AzureIaaSClassicComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectedItem is the BasicProtectedItem implementation for AzureFileshareProtectedItem.
func (afpi AzureFileshareProtectedItem) AsAzureIaaSComputeVMProtectedItem() (*AzureIaaSComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureFileshareProtectedItem.
func (afpi AzureFileshareProtectedItem) AsAzureIaaSVMProtectedItem() (*AzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureFileshareProtectedItem.
func (afpi AzureFileshareProtectedItem) AsBasicAzureIaaSVMProtectedItem() (BasicAzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsAzureSQLProtectedItem is the BasicProtectedItem implementation for AzureFileshareProtectedItem.
func (afpi AzureFileshareProtectedItem) AsAzureSQLProtectedItem() (*AzureSQLProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for AzureFileshareProtectedItem.
func (afpi AzureFileshareProtectedItem) AsAzureVMWorkloadProtectedItem() (*AzureVMWorkloadProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for AzureFileshareProtectedItem.
func (afpi AzureFileshareProtectedItem) AsBasicAzureVMWorkloadProtectedItem() (BasicAzureVMWorkloadProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseDatabaseProtectedItem is the BasicProtectedItem implementation for AzureFileshareProtectedItem.
func (afpi AzureFileshareProtectedItem) AsAzureVMWorkloadSAPAseDatabaseProtectedItem() (*AzureVMWorkloadSAPAseDatabaseProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectedItem is the BasicProtectedItem implementation for AzureFileshareProtectedItem.
func (afpi AzureFileshareProtectedItem) AsAzureVMWorkloadSAPHanaDatabaseProtectedItem() (*AzureVMWorkloadSAPHanaDatabaseProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectedItem is the BasicProtectedItem implementation for AzureFileshareProtectedItem.
func (afpi AzureFileshareProtectedItem) AsAzureVMWorkloadSQLDatabaseProtectedItem() (*AzureVMWorkloadSQLDatabaseProtectedItem, bool) {
	return nil, false
}

// AsDPMProtectedItem is the BasicProtectedItem implementation for AzureFileshareProtectedItem.
func (afpi AzureFileshareProtectedItem) AsDPMProtectedItem() (*DPMProtectedItem, bool) {
	return nil, false
}

// AsGenericProtectedItem is the BasicProtectedItem implementation for AzureFileshareProtectedItem.
func (afpi AzureFileshareProtectedItem) AsGenericProtectedItem() (*GenericProtectedItem, bool) {
	return nil, false
}

// AsMabFileFolderProtectedItem is the BasicProtectedItem implementation for AzureFileshareProtectedItem.
func (afpi AzureFileshareProtectedItem) AsMabFileFolderProtectedItem() (*MabFileFolderProtectedItem, bool) {
	return nil, false
}

// AsProtectedItem is the BasicProtectedItem implementation for AzureFileshareProtectedItem.
func (afpi AzureFileshareProtectedItem) AsProtectedItem() (*ProtectedItem, bool) {
	return nil, false
}

// AsBasicProtectedItem is the BasicProtectedItem implementation for AzureFileshareProtectedItem.
func (afpi AzureFileshareProtectedItem) AsBasicProtectedItem() (BasicProtectedItem, bool) {
	return &afpi, true
}

// AzureFileshareProtectedItemExtendedInfo additional information about Azure File Share backup item.
type AzureFileshareProtectedItemExtendedInfo struct {
	// OldestRecoveryPoint - The oldest backup copy available for this item in the service.
	OldestRecoveryPoint *date.Time `json:"oldestRecoveryPoint,omitempty"`
	// RecoveryPointCount - Number of available backup copies associated with this backup item.
	RecoveryPointCount *int32 `json:"recoveryPointCount,omitempty"`
	// PolicyState - Indicates consistency of policy object and policy applied to this backup item.
	PolicyState *string `json:"policyState,omitempty"`
	// ResourceState - READ-ONLY; Indicates the state of this resource. Possible values are from enum ResourceState {Invalid, Active, SoftDeleted, Deleted}
	ResourceState *string `json:"resourceState,omitempty"`
	// ResourceStateSyncTime - READ-ONLY; The resource state sync time for this backup item.
	ResourceStateSyncTime *date.Time `json:"resourceStateSyncTime,omitempty"`
}

// AzureFileShareProtectionPolicy azureStorage backup policy.
type AzureFileShareProtectionPolicy struct {
	// WorkLoadType - Type of workload for the backup management. Possible values include: 'WorkloadTypeInvalid', 'WorkloadTypeVM', 'WorkloadTypeFileFolder', 'WorkloadTypeAzureSQLDb', 'WorkloadTypeSQLDB', 'WorkloadTypeExchange', 'WorkloadTypeSharepoint', 'WorkloadTypeVMwareVM', 'WorkloadTypeSystemState', 'WorkloadTypeClient', 'WorkloadTypeGenericDataSource', 'WorkloadTypeSQLDataBase', 'WorkloadTypeAzureFileShare', 'WorkloadTypeSAPHanaDatabase', 'WorkloadTypeSAPAseDatabase'
	WorkLoadType WorkloadType `json:"workLoadType,omitempty"`
	// SchedulePolicy - Backup schedule specified as part of backup policy.
	SchedulePolicy BasicSchedulePolicy `json:"schedulePolicy,omitempty"`
	// RetentionPolicy - Retention policy with the details on backup copy retention ranges.
	RetentionPolicy BasicRetentionPolicy `json:"retentionPolicy,omitempty"`
	// TimeZone - TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
	TimeZone *string `json:"timeZone,omitempty"`
	// ProtectedItemsCount - Number of items associated with this policy.
	ProtectedItemsCount *int32 `json:"protectedItemsCount,omitempty"`
	// BackupManagementType - Possible values include: 'BackupManagementTypeProtectionPolicy', 'BackupManagementTypeAzureWorkload', 'BackupManagementTypeAzureStorage', 'BackupManagementTypeAzureIaasVM', 'BackupManagementTypeAzureSQL', 'BackupManagementTypeGenericProtectionPolicy', 'BackupManagementTypeMAB'
	BackupManagementType ManagementTypeBasicProtectionPolicy `json:"backupManagementType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFileShareProtectionPolicy.
func (afspp AzureFileShareProtectionPolicy) MarshalJSON() ([]byte, error) {
	afspp.BackupManagementType = BackupManagementTypeAzureStorage
	objectMap := make(map[string]interface{})
	if afspp.WorkLoadType != "" {
		objectMap["workLoadType"] = afspp.WorkLoadType
	}
	objectMap["schedulePolicy"] = afspp.SchedulePolicy
	objectMap["retentionPolicy"] = afspp.RetentionPolicy
	if afspp.TimeZone != nil {
		objectMap["timeZone"] = afspp.TimeZone
	}
	if afspp.ProtectedItemsCount != nil {
		objectMap["protectedItemsCount"] = afspp.ProtectedItemsCount
	}
	if afspp.BackupManagementType != "" {
		objectMap["backupManagementType"] = afspp.BackupManagementType
	}
	return json.Marshal(objectMap)
}

// AsAzureVMWorkloadProtectionPolicy is the BasicProtectionPolicy implementation for AzureFileShareProtectionPolicy.
func (afspp AzureFileShareProtectionPolicy) AsAzureVMWorkloadProtectionPolicy() (*AzureVMWorkloadProtectionPolicy, bool) {
	return nil, false
}

// AsAzureFileShareProtectionPolicy is the BasicProtectionPolicy implementation for AzureFileShareProtectionPolicy.
func (afspp AzureFileShareProtectionPolicy) AsAzureFileShareProtectionPolicy() (*AzureFileShareProtectionPolicy, bool) {
	return &afspp, true
}

// AsAzureIaaSVMProtectionPolicy is the BasicProtectionPolicy implementation for AzureFileShareProtectionPolicy.
func (afspp AzureFileShareProtectionPolicy) AsAzureIaaSVMProtectionPolicy() (*AzureIaaSVMProtectionPolicy, bool) {
	return nil, false
}

// AsAzureSQLProtectionPolicy is the BasicProtectionPolicy implementation for AzureFileShareProtectionPolicy.
func (afspp AzureFileShareProtectionPolicy) AsAzureSQLProtectionPolicy() (*AzureSQLProtectionPolicy, bool) {
	return nil, false
}

// AsGenericProtectionPolicy is the BasicProtectionPolicy implementation for AzureFileShareProtectionPolicy.
func (afspp AzureFileShareProtectionPolicy) AsGenericProtectionPolicy() (*GenericProtectionPolicy, bool) {
	return nil, false
}

// AsMabProtectionPolicy is the BasicProtectionPolicy implementation for AzureFileShareProtectionPolicy.
func (afspp AzureFileShareProtectionPolicy) AsMabProtectionPolicy() (*MabProtectionPolicy, bool) {
	return nil, false
}

// AsProtectionPolicy is the BasicProtectionPolicy implementation for AzureFileShareProtectionPolicy.
func (afspp AzureFileShareProtectionPolicy) AsProtectionPolicy() (*ProtectionPolicy, bool) {
	return nil, false
}

// AsBasicProtectionPolicy is the BasicProtectionPolicy implementation for AzureFileShareProtectionPolicy.
func (afspp AzureFileShareProtectionPolicy) AsBasicProtectionPolicy() (BasicProtectionPolicy, bool) {
	return &afspp, true
}

// UnmarshalJSON is the custom unmarshaler for AzureFileShareProtectionPolicy struct.
func (afspp *AzureFileShareProtectionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "workLoadType":
			if v != nil {
				var workLoadType WorkloadType
				err = json.Unmarshal(*v, &workLoadType)
				if err != nil {
					return err
				}
				afspp.WorkLoadType = workLoadType
			}
		case "schedulePolicy":
			if v != nil {
				schedulePolicy, err := unmarshalBasicSchedulePolicy(*v)
				if err != nil {
					return err
				}
				afspp.SchedulePolicy = schedulePolicy
			}
		case "retentionPolicy":
			if v != nil {
				retentionPolicy, err := unmarshalBasicRetentionPolicy(*v)
				if err != nil {
					return err
				}
				afspp.RetentionPolicy = retentionPolicy
			}
		case "timeZone":
			if v != nil {
				var timeZone string
				err = json.Unmarshal(*v, &timeZone)
				if err != nil {
					return err
				}
				afspp.TimeZone = &timeZone
			}
		case "protectedItemsCount":
			if v != nil {
				var protectedItemsCount int32
				err = json.Unmarshal(*v, &protectedItemsCount)
				if err != nil {
					return err
				}
				afspp.ProtectedItemsCount = &protectedItemsCount
			}
		case "backupManagementType":
			if v != nil {
				var backupManagementType ManagementTypeBasicProtectionPolicy
				err = json.Unmarshal(*v, &backupManagementType)
				if err != nil {
					return err
				}
				afspp.BackupManagementType = backupManagementType
			}
		}
	}

	return nil
}

// AzureFileShareProvisionILRRequest update snapshot Uri with the correct friendly Name of the source Azure
// file share.
type AzureFileShareProvisionILRRequest struct {
	// RecoveryPointID - Recovery point ID.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// SourceResourceID - Source Storage account ARM Id
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeILRRequest', 'ObjectTypeAzureFileShareProvisionILRRequest', 'ObjectTypeIaasVMILRRegistrationRequest'
	ObjectType ObjectTypeBasicILRRequest `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFileShareProvisionILRRequest.
func (afspir AzureFileShareProvisionILRRequest) MarshalJSON() ([]byte, error) {
	afspir.ObjectType = ObjectTypeAzureFileShareProvisionILRRequest
	objectMap := make(map[string]interface{})
	if afspir.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = afspir.RecoveryPointID
	}
	if afspir.SourceResourceID != nil {
		objectMap["sourceResourceId"] = afspir.SourceResourceID
	}
	if afspir.ObjectType != "" {
		objectMap["objectType"] = afspir.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProvisionILRRequest is the BasicILRRequest implementation for AzureFileShareProvisionILRRequest.
func (afspir AzureFileShareProvisionILRRequest) AsAzureFileShareProvisionILRRequest() (*AzureFileShareProvisionILRRequest, bool) {
	return &afspir, true
}

// AsIaasVMILRRegistrationRequest is the BasicILRRequest implementation for AzureFileShareProvisionILRRequest.
func (afspir AzureFileShareProvisionILRRequest) AsIaasVMILRRegistrationRequest() (*IaasVMILRRegistrationRequest, bool) {
	return nil, false
}

// AsILRRequest is the BasicILRRequest implementation for AzureFileShareProvisionILRRequest.
func (afspir AzureFileShareProvisionILRRequest) AsILRRequest() (*ILRRequest, bool) {
	return nil, false
}

// AsBasicILRRequest is the BasicILRRequest implementation for AzureFileShareProvisionILRRequest.
func (afspir AzureFileShareProvisionILRRequest) AsBasicILRRequest() (BasicILRRequest, bool) {
	return &afspir, true
}

// AzureFileShareRecoveryPoint azure File Share workload specific backup copy.
type AzureFileShareRecoveryPoint struct {
	// RecoveryPointType - READ-ONLY; Type of the backup copy. Specifies whether it is a crash consistent backup or app consistent.
	RecoveryPointType *string `json:"recoveryPointType,omitempty"`
	// RecoveryPointTime - READ-ONLY; Time at which this backup copy was created.
	RecoveryPointTime *date.Time `json:"recoveryPointTime,omitempty"`
	// FileShareSnapshotURI - READ-ONLY; Contains Url to the snapshot of fileshare, if applicable
	FileShareSnapshotURI *string `json:"fileShareSnapshotUri,omitempty"`
	// RecoveryPointSizeInGB - READ-ONLY; Contains recovery point size
	RecoveryPointSizeInGB *int32 `json:"recoveryPointSizeInGB,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeRecoveryPoint', 'ObjectTypeAzureFileShareRecoveryPoint', 'ObjectTypeAzureWorkloadPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadRecoveryPoint', 'ObjectTypeAzureWorkloadSAPHanaPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadSAPHanaRecoveryPoint', 'ObjectTypeAzureWorkloadSQLPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadSQLRecoveryPoint', 'ObjectTypeGenericRecoveryPoint', 'ObjectTypeIaasVMRecoveryPoint'
	ObjectType ObjectTypeBasicRecoveryPoint `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFileShareRecoveryPoint.
func (afsrp AzureFileShareRecoveryPoint) MarshalJSON() ([]byte, error) {
	afsrp.ObjectType = ObjectTypeAzureFileShareRecoveryPoint
	objectMap := make(map[string]interface{})
	if afsrp.ObjectType != "" {
		objectMap["objectType"] = afsrp.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareRecoveryPoint is the BasicRecoveryPoint implementation for AzureFileShareRecoveryPoint.
func (afsrp AzureFileShareRecoveryPoint) AsAzureFileShareRecoveryPoint() (*AzureFileShareRecoveryPoint, bool) {
	return &afsrp, true
}

// AsAzureWorkloadPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureFileShareRecoveryPoint.
func (afsrp AzureFileShareRecoveryPoint) AsAzureWorkloadPointInTimeRecoveryPoint() (*AzureWorkloadPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureFileShareRecoveryPoint.
func (afsrp AzureFileShareRecoveryPoint) AsBasicAzureWorkloadPointInTimeRecoveryPoint() (BasicAzureWorkloadPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadRecoveryPoint is the BasicRecoveryPoint implementation for AzureFileShareRecoveryPoint.
func (afsrp AzureFileShareRecoveryPoint) AsAzureWorkloadRecoveryPoint() (*AzureWorkloadRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadRecoveryPoint is the BasicRecoveryPoint implementation for AzureFileShareRecoveryPoint.
func (afsrp AzureFileShareRecoveryPoint) AsBasicAzureWorkloadRecoveryPoint() (BasicAzureWorkloadRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSAPHanaPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureFileShareRecoveryPoint.
func (afsrp AzureFileShareRecoveryPoint) AsAzureWorkloadSAPHanaPointInTimeRecoveryPoint() (*AzureWorkloadSAPHanaPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSAPHanaRecoveryPoint is the BasicRecoveryPoint implementation for AzureFileShareRecoveryPoint.
func (afsrp AzureFileShareRecoveryPoint) AsAzureWorkloadSAPHanaRecoveryPoint() (*AzureWorkloadSAPHanaRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSQLPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureFileShareRecoveryPoint.
func (afsrp AzureFileShareRecoveryPoint) AsAzureWorkloadSQLPointInTimeRecoveryPoint() (*AzureWorkloadSQLPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSQLRecoveryPoint is the BasicRecoveryPoint implementation for AzureFileShareRecoveryPoint.
func (afsrp AzureFileShareRecoveryPoint) AsAzureWorkloadSQLRecoveryPoint() (*AzureWorkloadSQLRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadSQLRecoveryPoint is the BasicRecoveryPoint implementation for AzureFileShareRecoveryPoint.
func (afsrp AzureFileShareRecoveryPoint) AsBasicAzureWorkloadSQLRecoveryPoint() (BasicAzureWorkloadSQLRecoveryPoint, bool) {
	return nil, false
}

// AsGenericRecoveryPoint is the BasicRecoveryPoint implementation for AzureFileShareRecoveryPoint.
func (afsrp AzureFileShareRecoveryPoint) AsGenericRecoveryPoint() (*GenericRecoveryPoint, bool) {
	return nil, false
}

// AsIaasVMRecoveryPoint is the BasicRecoveryPoint implementation for AzureFileShareRecoveryPoint.
func (afsrp AzureFileShareRecoveryPoint) AsIaasVMRecoveryPoint() (*IaasVMRecoveryPoint, bool) {
	return nil, false
}

// AsRecoveryPoint is the BasicRecoveryPoint implementation for AzureFileShareRecoveryPoint.
func (afsrp AzureFileShareRecoveryPoint) AsRecoveryPoint() (*RecoveryPoint, bool) {
	return nil, false
}

// AsBasicRecoveryPoint is the BasicRecoveryPoint implementation for AzureFileShareRecoveryPoint.
func (afsrp AzureFileShareRecoveryPoint) AsBasicRecoveryPoint() (BasicRecoveryPoint, bool) {
	return &afsrp, true
}

// AzureFileShareRestoreRequest azureFileShare Restore Request
type AzureFileShareRestoreRequest struct {
	// RecoveryType - Type of this recovery. Possible values include: 'RecoveryTypeInvalid', 'RecoveryTypeOriginalLocation', 'RecoveryTypeAlternateLocation', 'RecoveryTypeRestoreDisks', 'RecoveryTypeOffline'
	RecoveryType RecoveryType `json:"recoveryType,omitempty"`
	// SourceResourceID - Source storage account ARM Id
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// CopyOptions - Options to resolve copy conflicts. Possible values include: 'CopyOptionsInvalid', 'CopyOptionsCreateCopy', 'CopyOptionsSkip', 'CopyOptionsOverwrite', 'CopyOptionsFailOnConflict'
	CopyOptions CopyOptions `json:"copyOptions,omitempty"`
	// RestoreRequestType - Restore Type (FullShareRestore or ItemLevelRestore). Possible values include: 'RestoreRequestTypeInvalid', 'RestoreRequestTypeFullShareRestore', 'RestoreRequestTypeItemLevelRestore'
	RestoreRequestType RestoreRequestType `json:"restoreRequestType,omitempty"`
	// RestoreFileSpecs - List of Source Files/Folders(which need to recover) and TargetFolderPath details
	RestoreFileSpecs *[]RestoreFileSpecs `json:"restoreFileSpecs,omitempty"`
	// TargetDetails - Target File Share Details
	TargetDetails *TargetAFSRestoreInfo `json:"targetDetails,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeRestoreRequest', 'ObjectTypeAzureFileShareRestoreRequest', 'ObjectTypeAzureWorkloadPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadRestoreRequest', 'ObjectTypeAzureWorkloadSAPHanaPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadSAPHanaRestoreRequest', 'ObjectTypeAzureWorkloadSQLPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadSQLRestoreRequest', 'ObjectTypeIaasVMRestoreRequest'
	ObjectType ObjectTypeBasicRestoreRequest `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFileShareRestoreRequest.
func (afsrr AzureFileShareRestoreRequest) MarshalJSON() ([]byte, error) {
	afsrr.ObjectType = ObjectTypeAzureFileShareRestoreRequest
	objectMap := make(map[string]interface{})
	if afsrr.RecoveryType != "" {
		objectMap["recoveryType"] = afsrr.RecoveryType
	}
	if afsrr.SourceResourceID != nil {
		objectMap["sourceResourceId"] = afsrr.SourceResourceID
	}
	if afsrr.CopyOptions != "" {
		objectMap["copyOptions"] = afsrr.CopyOptions
	}
	if afsrr.RestoreRequestType != "" {
		objectMap["restoreRequestType"] = afsrr.RestoreRequestType
	}
	if afsrr.RestoreFileSpecs != nil {
		objectMap["restoreFileSpecs"] = afsrr.RestoreFileSpecs
	}
	if afsrr.TargetDetails != nil {
		objectMap["targetDetails"] = afsrr.TargetDetails
	}
	if afsrr.ObjectType != "" {
		objectMap["objectType"] = afsrr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareRestoreRequest is the BasicRestoreRequest implementation for AzureFileShareRestoreRequest.
func (afsrr AzureFileShareRestoreRequest) AsAzureFileShareRestoreRequest() (*AzureFileShareRestoreRequest, bool) {
	return &afsrr, true
}

// AsAzureWorkloadPointInTimeRestoreRequest is the BasicRestoreRequest implementation for AzureFileShareRestoreRequest.
func (afsrr AzureFileShareRestoreRequest) AsAzureWorkloadPointInTimeRestoreRequest() (*AzureWorkloadPointInTimeRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadRestoreRequest is the BasicRestoreRequest implementation for AzureFileShareRestoreRequest.
func (afsrr AzureFileShareRestoreRequest) AsAzureWorkloadRestoreRequest() (*AzureWorkloadRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureWorkloadRestoreRequest is the BasicRestoreRequest implementation for AzureFileShareRestoreRequest.
func (afsrr AzureFileShareRestoreRequest) AsBasicAzureWorkloadRestoreRequest() (BasicAzureWorkloadRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSAPHanaPointInTimeRestoreRequest is the BasicRestoreRequest implementation for AzureFileShareRestoreRequest.
func (afsrr AzureFileShareRestoreRequest) AsAzureWorkloadSAPHanaPointInTimeRestoreRequest() (*AzureWorkloadSAPHanaPointInTimeRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSAPHanaRestoreRequest is the BasicRestoreRequest implementation for AzureFileShareRestoreRequest.
func (afsrr AzureFileShareRestoreRequest) AsAzureWorkloadSAPHanaRestoreRequest() (*AzureWorkloadSAPHanaRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureWorkloadSAPHanaRestoreRequest is the BasicRestoreRequest implementation for AzureFileShareRestoreRequest.
func (afsrr AzureFileShareRestoreRequest) AsBasicAzureWorkloadSAPHanaRestoreRequest() (BasicAzureWorkloadSAPHanaRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSQLPointInTimeRestoreRequest is the BasicRestoreRequest implementation for AzureFileShareRestoreRequest.
func (afsrr AzureFileShareRestoreRequest) AsAzureWorkloadSQLPointInTimeRestoreRequest() (*AzureWorkloadSQLPointInTimeRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSQLRestoreRequest is the BasicRestoreRequest implementation for AzureFileShareRestoreRequest.
func (afsrr AzureFileShareRestoreRequest) AsAzureWorkloadSQLRestoreRequest() (*AzureWorkloadSQLRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureWorkloadSQLRestoreRequest is the BasicRestoreRequest implementation for AzureFileShareRestoreRequest.
func (afsrr AzureFileShareRestoreRequest) AsBasicAzureWorkloadSQLRestoreRequest() (BasicAzureWorkloadSQLRestoreRequest, bool) {
	return nil, false
}

// AsIaasVMRestoreRequest is the BasicRestoreRequest implementation for AzureFileShareRestoreRequest.
func (afsrr AzureFileShareRestoreRequest) AsIaasVMRestoreRequest() (*IaasVMRestoreRequest, bool) {
	return nil, false
}

// AsRestoreRequest is the BasicRestoreRequest implementation for AzureFileShareRestoreRequest.
func (afsrr AzureFileShareRestoreRequest) AsRestoreRequest() (*RestoreRequest, bool) {
	return nil, false
}

// AsBasicRestoreRequest is the BasicRestoreRequest implementation for AzureFileShareRestoreRequest.
func (afsrr AzureFileShareRestoreRequest) AsBasicRestoreRequest() (BasicRestoreRequest, bool) {
	return &afsrr, true
}

// AzureIaaSClassicComputeVMContainer iaaS VM workload-specific backup item representing a classic virtual
// machine.
type AzureIaaSClassicComputeVMContainer struct {
	// VirtualMachineID - Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// VirtualMachineVersion - Specifies whether the container represents a Classic or an Azure Resource Manager VM.
	VirtualMachineVersion *string `json:"virtualMachineVersion,omitempty"`
	// ResourceGroup - Resource group name of Recovery Services Vault.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) MarshalJSON() ([]byte, error) {
	aisccvc.ContainerType = ContainerTypeMicrosoftClassicComputevirtualMachines
	objectMap := make(map[string]interface{})
	if aisccvc.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = aisccvc.VirtualMachineID
	}
	if aisccvc.VirtualMachineVersion != nil {
		objectMap["virtualMachineVersion"] = aisccvc.VirtualMachineVersion
	}
	if aisccvc.ResourceGroup != nil {
		objectMap["resourceGroup"] = aisccvc.ResourceGroup
	}
	if aisccvc.FriendlyName != nil {
		objectMap["friendlyName"] = aisccvc.FriendlyName
	}
	if aisccvc.BackupManagementType != "" {
		objectMap["backupManagementType"] = aisccvc.BackupManagementType
	}
	if aisccvc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = aisccvc.RegistrationStatus
	}
	if aisccvc.HealthStatus != nil {
		objectMap["healthStatus"] = aisccvc.HealthStatus
	}
	if aisccvc.ContainerType != "" {
		objectMap["containerType"] = aisccvc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return &aisccvc, true
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return nil, false
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return nil, false
}

// AsDpmContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsDpmContainer() (*DpmContainer, bool) {
	return nil, false
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return nil, false
}

// AsGenericContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsGenericContainer() (*GenericContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return &aisccvc, true
}

// AsMabContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &aisccvc, true
}

// AzureIaaSClassicComputeVMProtectableItem iaaS VM workload-specific backup item representing the Classic
// Compute VM.
type AzureIaaSClassicComputeVMProtectableItem struct {
	// VirtualMachineID - Fully qualified ARM ID of the virtual machine.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeAzureFileShare', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeAzureVMWorkloadProtectableItem', 'ProtectableItemTypeSAPAseSystem', 'ProtectableItemTypeSAPHanaDatabase', 'ProtectableItemTypeSAPHanaSystem', 'ProtectableItemTypeSQLAvailabilityGroupContainer', 'ProtectableItemTypeSQLDataBase', 'ProtectableItemTypeSQLInstance', 'ProtectableItemTypeIaaSVMProtectableItem'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) MarshalJSON() ([]byte, error) {
	aisccvpi.ProtectableItemType = ProtectableItemTypeMicrosoftClassicComputevirtualMachines
	objectMap := make(map[string]interface{})
	if aisccvpi.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = aisccvpi.VirtualMachineID
	}
	if aisccvpi.BackupManagementType != nil {
		objectMap["backupManagementType"] = aisccvpi.BackupManagementType
	}
	if aisccvpi.WorkloadType != nil {
		objectMap["workloadType"] = aisccvpi.WorkloadType
	}
	if aisccvpi.FriendlyName != nil {
		objectMap["friendlyName"] = aisccvpi.FriendlyName
	}
	if aisccvpi.ProtectionState != "" {
		objectMap["protectionState"] = aisccvpi.ProtectionState
	}
	if aisccvpi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = aisccvpi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return &aisccvpi, true
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool) {
	return nil, false
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return nil, false
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return &aisccvpi, true
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &aisccvpi, true
}

// AzureIaaSClassicComputeVMProtectedItem iaaS VM workload-specific backup item representing the Classic
// Compute VM.
type AzureIaaSClassicComputeVMProtectedItem struct {
	// FriendlyName - Friendly name of the VM represented by this backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// VirtualMachineID - Fully qualified ARM ID of the virtual machine represented by this item.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// ProtectionStatus - Backup status of this backup item.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`
	// ProtectionState - Backup state of this backup item. Possible values include: 'ProtectionStateInvalid', 'ProtectionStateIRPending', 'ProtectionStateProtected', 'ProtectionStateProtectionError', 'ProtectionStateProtectionStopped', 'ProtectionStateProtectionPaused'
	ProtectionState ProtectionState `json:"protectionState,omitempty"`
	// HealthStatus - Health status of protected item. Possible values include: 'HealthStatusPassed', 'HealthStatusActionRequired', 'HealthStatusActionSuggested', 'HealthStatusInvalid'
	HealthStatus HealthStatus `json:"healthStatus,omitempty"`
	// HealthDetails - Health details on this backup item.
	HealthDetails *[]AzureIaaSVMHealthDetails `json:"healthDetails,omitempty"`
	// LastBackupStatus - Last backup operation status.
	LastBackupStatus *string `json:"lastBackupStatus,omitempty"`
	// LastBackupTime - Timestamp of the last backup operation on this backup item.
	LastBackupTime *date.Time `json:"lastBackupTime,omitempty"`
	// ProtectedItemDataID - Data ID of the protected item.
	ProtectedItemDataID *string `json:"protectedItemDataId,omitempty"`
	// ExtendedInfo - Additional information for this backup item.
	ExtendedInfo       *AzureIaaSVMProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`
	ExtendedProperties *ExtendedProperties                   `json:"extendedProperties,omitempty"`
	// BackupManagementType - Type of backup management for the backed up item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload this item represents. Possible values include: 'DataSourceTypeInvalid', 'DataSourceTypeVM', 'DataSourceTypeFileFolder', 'DataSourceTypeAzureSQLDb', 'DataSourceTypeSQLDB', 'DataSourceTypeExchange', 'DataSourceTypeSharepoint', 'DataSourceTypeVMwareVM', 'DataSourceTypeSystemState', 'DataSourceTypeClient', 'DataSourceTypeGenericDataSource', 'DataSourceTypeSQLDataBase', 'DataSourceTypeAzureFileShare', 'DataSourceTypeSAPHanaDatabase', 'DataSourceTypeSAPAseDatabase'
	WorkloadType DataSourceType `json:"workloadType,omitempty"`
	// ContainerName - Unique name of container
	ContainerName *string `json:"containerName,omitempty"`
	// SourceResourceID - ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// PolicyID - ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`
	// LastRecoveryPoint - Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *date.Time `json:"lastRecoveryPoint,omitempty"`
	// BackupSetName - Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`
	// CreateMode - Create mode to indicate recovery of existing soft deleted data source or creation of new data source. Possible values include: 'CreateModeInvalid', 'CreateModeDefault', 'CreateModeRecover'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// DeferredDeleteTimeInUTC - Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *date.Time `json:"deferredDeleteTimeInUTC,omitempty"`
	// IsScheduledForDeferredDelete - Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`
	// DeferredDeleteTimeRemaining - Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`
	// IsDeferredDeleteScheduleUpcoming - Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`
	// IsRehydrate - Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`
	// ProtectedItemType - Possible values include: 'ProtectedItemTypeProtectedItem', 'ProtectedItemTypeAzureFileShareProtectedItem', 'ProtectedItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectedItemTypeMicrosoftComputevirtualMachines', 'ProtectedItemTypeAzureIaaSVMProtectedItem', 'ProtectedItemTypeMicrosoftSqlserversdatabases', 'ProtectedItemTypeAzureVMWorkloadProtectedItem', 'ProtectedItemTypeAzureVMWorkloadSAPAseDatabase', 'ProtectedItemTypeAzureVMWorkloadSAPHanaDatabase', 'ProtectedItemTypeAzureVMWorkloadSQLDatabase', 'ProtectedItemTypeDPMProtectedItem', 'ProtectedItemTypeGenericProtectedItem', 'ProtectedItemTypeMabFileFolderProtectedItem'
	ProtectedItemType ProtectedItemType `json:"protectedItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) MarshalJSON() ([]byte, error) {
	aisccvpi.ProtectedItemType = ProtectedItemTypeMicrosoftClassicComputevirtualMachines
	objectMap := make(map[string]interface{})
	if aisccvpi.FriendlyName != nil {
		objectMap["friendlyName"] = aisccvpi.FriendlyName
	}
	if aisccvpi.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = aisccvpi.VirtualMachineID
	}
	if aisccvpi.ProtectionStatus != nil {
		objectMap["protectionStatus"] = aisccvpi.ProtectionStatus
	}
	if aisccvpi.ProtectionState != "" {
		objectMap["protectionState"] = aisccvpi.ProtectionState
	}
	if aisccvpi.HealthStatus != "" {
		objectMap["healthStatus"] = aisccvpi.HealthStatus
	}
	if aisccvpi.HealthDetails != nil {
		objectMap["healthDetails"] = aisccvpi.HealthDetails
	}
	if aisccvpi.LastBackupStatus != nil {
		objectMap["lastBackupStatus"] = aisccvpi.LastBackupStatus
	}
	if aisccvpi.LastBackupTime != nil {
		objectMap["lastBackupTime"] = aisccvpi.LastBackupTime
	}
	if aisccvpi.ProtectedItemDataID != nil {
		objectMap["protectedItemDataId"] = aisccvpi.ProtectedItemDataID
	}
	if aisccvpi.ExtendedInfo != nil {
		objectMap["extendedInfo"] = aisccvpi.ExtendedInfo
	}
	if aisccvpi.ExtendedProperties != nil {
		objectMap["extendedProperties"] = aisccvpi.ExtendedProperties
	}
	if aisccvpi.BackupManagementType != "" {
		objectMap["backupManagementType"] = aisccvpi.BackupManagementType
	}
	if aisccvpi.WorkloadType != "" {
		objectMap["workloadType"] = aisccvpi.WorkloadType
	}
	if aisccvpi.ContainerName != nil {
		objectMap["containerName"] = aisccvpi.ContainerName
	}
	if aisccvpi.SourceResourceID != nil {
		objectMap["sourceResourceId"] = aisccvpi.SourceResourceID
	}
	if aisccvpi.PolicyID != nil {
		objectMap["policyId"] = aisccvpi.PolicyID
	}
	if aisccvpi.LastRecoveryPoint != nil {
		objectMap["lastRecoveryPoint"] = aisccvpi.LastRecoveryPoint
	}
	if aisccvpi.BackupSetName != nil {
		objectMap["backupSetName"] = aisccvpi.BackupSetName
	}
	if aisccvpi.CreateMode != "" {
		objectMap["createMode"] = aisccvpi.CreateMode
	}
	if aisccvpi.DeferredDeleteTimeInUTC != nil {
		objectMap["deferredDeleteTimeInUTC"] = aisccvpi.DeferredDeleteTimeInUTC
	}
	if aisccvpi.IsScheduledForDeferredDelete != nil {
		objectMap["isScheduledForDeferredDelete"] = aisccvpi.IsScheduledForDeferredDelete
	}
	if aisccvpi.DeferredDeleteTimeRemaining != nil {
		objectMap["deferredDeleteTimeRemaining"] = aisccvpi.DeferredDeleteTimeRemaining
	}
	if aisccvpi.IsDeferredDeleteScheduleUpcoming != nil {
		objectMap["isDeferredDeleteScheduleUpcoming"] = aisccvpi.IsDeferredDeleteScheduleUpcoming
	}
	if aisccvpi.IsRehydrate != nil {
		objectMap["isRehydrate"] = aisccvpi.IsRehydrate
	}
	if aisccvpi.ProtectedItemType != "" {
		objectMap["protectedItemType"] = aisccvpi.ProtectedItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileshareProtectedItem is the BasicProtectedItem implementation for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) AsAzureFileshareProtectedItem() (*AzureFileshareProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectedItem is the BasicProtectedItem implementation for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) AsAzureIaaSClassicComputeVMProtectedItem() (*AzureIaaSClassicComputeVMProtectedItem, bool) {
	return &aisccvpi, true
}

// AsAzureIaaSComputeVMProtectedItem is the BasicProtectedItem implementation for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) AsAzureIaaSComputeVMProtectedItem() (*AzureIaaSComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) AsAzureIaaSVMProtectedItem() (*AzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) AsBasicAzureIaaSVMProtectedItem() (BasicAzureIaaSVMProtectedItem, bool) {
	return &aisccvpi, true
}

// AsAzureSQLProtectedItem is the BasicProtectedItem implementation for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) AsAzureSQLProtectedItem() (*AzureSQLProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) AsAzureVMWorkloadProtectedItem() (*AzureVMWorkloadProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) AsBasicAzureVMWorkloadProtectedItem() (BasicAzureVMWorkloadProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseDatabaseProtectedItem is the BasicProtectedItem implementation for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) AsAzureVMWorkloadSAPAseDatabaseProtectedItem() (*AzureVMWorkloadSAPAseDatabaseProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectedItem is the BasicProtectedItem implementation for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) AsAzureVMWorkloadSAPHanaDatabaseProtectedItem() (*AzureVMWorkloadSAPHanaDatabaseProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectedItem is the BasicProtectedItem implementation for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) AsAzureVMWorkloadSQLDatabaseProtectedItem() (*AzureVMWorkloadSQLDatabaseProtectedItem, bool) {
	return nil, false
}

// AsDPMProtectedItem is the BasicProtectedItem implementation for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) AsDPMProtectedItem() (*DPMProtectedItem, bool) {
	return nil, false
}

// AsGenericProtectedItem is the BasicProtectedItem implementation for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) AsGenericProtectedItem() (*GenericProtectedItem, bool) {
	return nil, false
}

// AsMabFileFolderProtectedItem is the BasicProtectedItem implementation for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) AsMabFileFolderProtectedItem() (*MabFileFolderProtectedItem, bool) {
	return nil, false
}

// AsProtectedItem is the BasicProtectedItem implementation for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) AsProtectedItem() (*ProtectedItem, bool) {
	return nil, false
}

// AsBasicProtectedItem is the BasicProtectedItem implementation for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) AsBasicProtectedItem() (BasicProtectedItem, bool) {
	return &aisccvpi, true
}

// AzureIaaSComputeVMContainer iaaS VM workload-specific backup item representing an Azure Resource Manager
// virtual machine.
type AzureIaaSComputeVMContainer struct {
	// VirtualMachineID - Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// VirtualMachineVersion - Specifies whether the container represents a Classic or an Azure Resource Manager VM.
	VirtualMachineVersion *string `json:"virtualMachineVersion,omitempty"`
	// ResourceGroup - Resource group name of Recovery Services Vault.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) MarshalJSON() ([]byte, error) {
	aiscvc.ContainerType = ContainerTypeMicrosoftComputevirtualMachines
	objectMap := make(map[string]interface{})
	if aiscvc.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = aiscvc.VirtualMachineID
	}
	if aiscvc.VirtualMachineVersion != nil {
		objectMap["virtualMachineVersion"] = aiscvc.VirtualMachineVersion
	}
	if aiscvc.ResourceGroup != nil {
		objectMap["resourceGroup"] = aiscvc.ResourceGroup
	}
	if aiscvc.FriendlyName != nil {
		objectMap["friendlyName"] = aiscvc.FriendlyName
	}
	if aiscvc.BackupManagementType != "" {
		objectMap["backupManagementType"] = aiscvc.BackupManagementType
	}
	if aiscvc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = aiscvc.RegistrationStatus
	}
	if aiscvc.HealthStatus != nil {
		objectMap["healthStatus"] = aiscvc.HealthStatus
	}
	if aiscvc.ContainerType != "" {
		objectMap["containerType"] = aiscvc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return &aiscvc, true
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return nil, false
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return nil, false
}

// AsDpmContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsDpmContainer() (*DpmContainer, bool) {
	return nil, false
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return nil, false
}

// AsGenericContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsGenericContainer() (*GenericContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return &aiscvc, true
}

// AsMabContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &aiscvc, true
}

// AzureIaaSComputeVMProtectableItem iaaS VM workload-specific backup item representing the Azure Resource
// Manager VM.
type AzureIaaSComputeVMProtectableItem struct {
	// VirtualMachineID - Fully qualified ARM ID of the virtual machine.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeAzureFileShare', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeAzureVMWorkloadProtectableItem', 'ProtectableItemTypeSAPAseSystem', 'ProtectableItemTypeSAPHanaDatabase', 'ProtectableItemTypeSAPHanaSystem', 'ProtectableItemTypeSQLAvailabilityGroupContainer', 'ProtectableItemTypeSQLDataBase', 'ProtectableItemTypeSQLInstance', 'ProtectableItemTypeIaaSVMProtectableItem'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) MarshalJSON() ([]byte, error) {
	aiscvpi.ProtectableItemType = ProtectableItemTypeMicrosoftComputevirtualMachines
	objectMap := make(map[string]interface{})
	if aiscvpi.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = aiscvpi.VirtualMachineID
	}
	if aiscvpi.BackupManagementType != nil {
		objectMap["backupManagementType"] = aiscvpi.BackupManagementType
	}
	if aiscvpi.WorkloadType != nil {
		objectMap["workloadType"] = aiscvpi.WorkloadType
	}
	if aiscvpi.FriendlyName != nil {
		objectMap["friendlyName"] = aiscvpi.FriendlyName
	}
	if aiscvpi.ProtectionState != "" {
		objectMap["protectionState"] = aiscvpi.ProtectionState
	}
	if aiscvpi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = aiscvpi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return &aiscvpi, true
}

// AsAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool) {
	return nil, false
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return nil, false
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return &aiscvpi, true
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &aiscvpi, true
}

// AzureIaaSComputeVMProtectedItem iaaS VM workload-specific backup item representing the Azure Resource
// Manager VM.
type AzureIaaSComputeVMProtectedItem struct {
	// FriendlyName - Friendly name of the VM represented by this backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// VirtualMachineID - Fully qualified ARM ID of the virtual machine represented by this item.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// ProtectionStatus - Backup status of this backup item.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`
	// ProtectionState - Backup state of this backup item. Possible values include: 'ProtectionStateInvalid', 'ProtectionStateIRPending', 'ProtectionStateProtected', 'ProtectionStateProtectionError', 'ProtectionStateProtectionStopped', 'ProtectionStateProtectionPaused'
	ProtectionState ProtectionState `json:"protectionState,omitempty"`
	// HealthStatus - Health status of protected item. Possible values include: 'HealthStatusPassed', 'HealthStatusActionRequired', 'HealthStatusActionSuggested', 'HealthStatusInvalid'
	HealthStatus HealthStatus `json:"healthStatus,omitempty"`
	// HealthDetails - Health details on this backup item.
	HealthDetails *[]AzureIaaSVMHealthDetails `json:"healthDetails,omitempty"`
	// LastBackupStatus - Last backup operation status.
	LastBackupStatus *string `json:"lastBackupStatus,omitempty"`
	// LastBackupTime - Timestamp of the last backup operation on this backup item.
	LastBackupTime *date.Time `json:"lastBackupTime,omitempty"`
	// ProtectedItemDataID - Data ID of the protected item.
	ProtectedItemDataID *string `json:"protectedItemDataId,omitempty"`
	// ExtendedInfo - Additional information for this backup item.
	ExtendedInfo       *AzureIaaSVMProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`
	ExtendedProperties *ExtendedProperties                   `json:"extendedProperties,omitempty"`
	// BackupManagementType - Type of backup management for the backed up item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload this item represents. Possible values include: 'DataSourceTypeInvalid', 'DataSourceTypeVM', 'DataSourceTypeFileFolder', 'DataSourceTypeAzureSQLDb', 'DataSourceTypeSQLDB', 'DataSourceTypeExchange', 'DataSourceTypeSharepoint', 'DataSourceTypeVMwareVM', 'DataSourceTypeSystemState', 'DataSourceTypeClient', 'DataSourceTypeGenericDataSource', 'DataSourceTypeSQLDataBase', 'DataSourceTypeAzureFileShare', 'DataSourceTypeSAPHanaDatabase', 'DataSourceTypeSAPAseDatabase'
	WorkloadType DataSourceType `json:"workloadType,omitempty"`
	// ContainerName - Unique name of container
	ContainerName *string `json:"containerName,omitempty"`
	// SourceResourceID - ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// PolicyID - ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`
	// LastRecoveryPoint - Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *date.Time `json:"lastRecoveryPoint,omitempty"`
	// BackupSetName - Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`
	// CreateMode - Create mode to indicate recovery of existing soft deleted data source or creation of new data source. Possible values include: 'CreateModeInvalid', 'CreateModeDefault', 'CreateModeRecover'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// DeferredDeleteTimeInUTC - Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *date.Time `json:"deferredDeleteTimeInUTC,omitempty"`
	// IsScheduledForDeferredDelete - Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`
	// DeferredDeleteTimeRemaining - Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`
	// IsDeferredDeleteScheduleUpcoming - Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`
	// IsRehydrate - Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`
	// ProtectedItemType - Possible values include: 'ProtectedItemTypeProtectedItem', 'ProtectedItemTypeAzureFileShareProtectedItem', 'ProtectedItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectedItemTypeMicrosoftComputevirtualMachines', 'ProtectedItemTypeAzureIaaSVMProtectedItem', 'ProtectedItemTypeMicrosoftSqlserversdatabases', 'ProtectedItemTypeAzureVMWorkloadProtectedItem', 'ProtectedItemTypeAzureVMWorkloadSAPAseDatabase', 'ProtectedItemTypeAzureVMWorkloadSAPHanaDatabase', 'ProtectedItemTypeAzureVMWorkloadSQLDatabase', 'ProtectedItemTypeDPMProtectedItem', 'ProtectedItemTypeGenericProtectedItem', 'ProtectedItemTypeMabFileFolderProtectedItem'
	ProtectedItemType ProtectedItemType `json:"protectedItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) MarshalJSON() ([]byte, error) {
	aiscvpi.ProtectedItemType = ProtectedItemTypeMicrosoftComputevirtualMachines
	objectMap := make(map[string]interface{})
	if aiscvpi.FriendlyName != nil {
		objectMap["friendlyName"] = aiscvpi.FriendlyName
	}
	if aiscvpi.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = aiscvpi.VirtualMachineID
	}
	if aiscvpi.ProtectionStatus != nil {
		objectMap["protectionStatus"] = aiscvpi.ProtectionStatus
	}
	if aiscvpi.ProtectionState != "" {
		objectMap["protectionState"] = aiscvpi.ProtectionState
	}
	if aiscvpi.HealthStatus != "" {
		objectMap["healthStatus"] = aiscvpi.HealthStatus
	}
	if aiscvpi.HealthDetails != nil {
		objectMap["healthDetails"] = aiscvpi.HealthDetails
	}
	if aiscvpi.LastBackupStatus != nil {
		objectMap["lastBackupStatus"] = aiscvpi.LastBackupStatus
	}
	if aiscvpi.LastBackupTime != nil {
		objectMap["lastBackupTime"] = aiscvpi.LastBackupTime
	}
	if aiscvpi.ProtectedItemDataID != nil {
		objectMap["protectedItemDataId"] = aiscvpi.ProtectedItemDataID
	}
	if aiscvpi.ExtendedInfo != nil {
		objectMap["extendedInfo"] = aiscvpi.ExtendedInfo
	}
	if aiscvpi.ExtendedProperties != nil {
		objectMap["extendedProperties"] = aiscvpi.ExtendedProperties
	}
	if aiscvpi.BackupManagementType != "" {
		objectMap["backupManagementType"] = aiscvpi.BackupManagementType
	}
	if aiscvpi.WorkloadType != "" {
		objectMap["workloadType"] = aiscvpi.WorkloadType
	}
	if aiscvpi.ContainerName != nil {
		objectMap["containerName"] = aiscvpi.ContainerName
	}
	if aiscvpi.SourceResourceID != nil {
		objectMap["sourceResourceId"] = aiscvpi.SourceResourceID
	}
	if aiscvpi.PolicyID != nil {
		objectMap["policyId"] = aiscvpi.PolicyID
	}
	if aiscvpi.LastRecoveryPoint != nil {
		objectMap["lastRecoveryPoint"] = aiscvpi.LastRecoveryPoint
	}
	if aiscvpi.BackupSetName != nil {
		objectMap["backupSetName"] = aiscvpi.BackupSetName
	}
	if aiscvpi.CreateMode != "" {
		objectMap["createMode"] = aiscvpi.CreateMode
	}
	if aiscvpi.DeferredDeleteTimeInUTC != nil {
		objectMap["deferredDeleteTimeInUTC"] = aiscvpi.DeferredDeleteTimeInUTC
	}
	if aiscvpi.IsScheduledForDeferredDelete != nil {
		objectMap["isScheduledForDeferredDelete"] = aiscvpi.IsScheduledForDeferredDelete
	}
	if aiscvpi.DeferredDeleteTimeRemaining != nil {
		objectMap["deferredDeleteTimeRemaining"] = aiscvpi.DeferredDeleteTimeRemaining
	}
	if aiscvpi.IsDeferredDeleteScheduleUpcoming != nil {
		objectMap["isDeferredDeleteScheduleUpcoming"] = aiscvpi.IsDeferredDeleteScheduleUpcoming
	}
	if aiscvpi.IsRehydrate != nil {
		objectMap["isRehydrate"] = aiscvpi.IsRehydrate
	}
	if aiscvpi.ProtectedItemType != "" {
		objectMap["protectedItemType"] = aiscvpi.ProtectedItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileshareProtectedItem is the BasicProtectedItem implementation for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) AsAzureFileshareProtectedItem() (*AzureFileshareProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectedItem is the BasicProtectedItem implementation for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) AsAzureIaaSClassicComputeVMProtectedItem() (*AzureIaaSClassicComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectedItem is the BasicProtectedItem implementation for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) AsAzureIaaSComputeVMProtectedItem() (*AzureIaaSComputeVMProtectedItem, bool) {
	return &aiscvpi, true
}

// AsAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) AsAzureIaaSVMProtectedItem() (*AzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) AsBasicAzureIaaSVMProtectedItem() (BasicAzureIaaSVMProtectedItem, bool) {
	return &aiscvpi, true
}

// AsAzureSQLProtectedItem is the BasicProtectedItem implementation for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) AsAzureSQLProtectedItem() (*AzureSQLProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) AsAzureVMWorkloadProtectedItem() (*AzureVMWorkloadProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) AsBasicAzureVMWorkloadProtectedItem() (BasicAzureVMWorkloadProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseDatabaseProtectedItem is the BasicProtectedItem implementation for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) AsAzureVMWorkloadSAPAseDatabaseProtectedItem() (*AzureVMWorkloadSAPAseDatabaseProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectedItem is the BasicProtectedItem implementation for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) AsAzureVMWorkloadSAPHanaDatabaseProtectedItem() (*AzureVMWorkloadSAPHanaDatabaseProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectedItem is the BasicProtectedItem implementation for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) AsAzureVMWorkloadSQLDatabaseProtectedItem() (*AzureVMWorkloadSQLDatabaseProtectedItem, bool) {
	return nil, false
}

// AsDPMProtectedItem is the BasicProtectedItem implementation for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) AsDPMProtectedItem() (*DPMProtectedItem, bool) {
	return nil, false
}

// AsGenericProtectedItem is the BasicProtectedItem implementation for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) AsGenericProtectedItem() (*GenericProtectedItem, bool) {
	return nil, false
}

// AsMabFileFolderProtectedItem is the BasicProtectedItem implementation for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) AsMabFileFolderProtectedItem() (*MabFileFolderProtectedItem, bool) {
	return nil, false
}

// AsProtectedItem is the BasicProtectedItem implementation for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) AsProtectedItem() (*ProtectedItem, bool) {
	return nil, false
}

// AsBasicProtectedItem is the BasicProtectedItem implementation for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) AsBasicProtectedItem() (BasicProtectedItem, bool) {
	return &aiscvpi, true
}

// AzureIaaSVMErrorInfo azure IaaS VM workload-specific error information.
type AzureIaaSVMErrorInfo struct {
	// ErrorCode - READ-ONLY; Error code.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorTitle - READ-ONLY; Title: Typically, the entity that the error pertains to.
	ErrorTitle *string `json:"errorTitle,omitempty"`
	// ErrorString - READ-ONLY; Localized error string.
	ErrorString *string `json:"errorString,omitempty"`
	// Recommendations - READ-ONLY; List of localized recommendations for above error code.
	Recommendations *[]string `json:"recommendations,omitempty"`
}

// AzureIaaSVMHealthDetails azure IaaS VM workload-specific Health Details.
type AzureIaaSVMHealthDetails struct {
	// Code - READ-ONLY; Health Code
	Code *int32 `json:"code,omitempty"`
	// Title - READ-ONLY; Health Title
	Title *string `json:"title,omitempty"`
	// Message - READ-ONLY; Health Message
	Message *string `json:"message,omitempty"`
	// Recommendations - READ-ONLY; Health Recommended Actions
	Recommendations *[]string `json:"recommendations,omitempty"`
}

// AzureIaaSVMJob azure IaaS VM workload-specific job object.
type AzureIaaSVMJob struct {
	// Duration - Time elapsed during the execution of this job.
	Duration *string `json:"duration,omitempty"`
	// ActionsInfo - Gets or sets the state/actions applicable on this job like cancel/retry.
	ActionsInfo *[]JobSupportedAction `json:"actionsInfo,omitempty"`
	// ErrorDetails - Error details on execution of this job.
	ErrorDetails *[]AzureIaaSVMErrorInfo `json:"errorDetails,omitempty"`
	// VirtualMachineVersion - Specifies whether the backup item is a Classic or an Azure Resource Manager VM.
	VirtualMachineVersion *string `json:"virtualMachineVersion,omitempty"`
	// ExtendedInfo - Additional information for this job.
	ExtendedInfo *AzureIaaSVMJobExtendedInfo `json:"extendedInfo,omitempty"`
	// EntityFriendlyName - Friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string `json:"entityFriendlyName,omitempty"`
	// BackupManagementType - Backup management type to execute the current job. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// Operation - The operation name.
	Operation *string `json:"operation,omitempty"`
	// Status - Job status.
	Status *string `json:"status,omitempty"`
	// StartTime - The start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ActivityID - ActivityId of job.
	ActivityID *string `json:"activityId,omitempty"`
	// JobType - Possible values include: 'JobTypeJob', 'JobTypeAzureIaaSVMJob', 'JobTypeAzureStorageJob', 'JobTypeAzureWorkloadJob', 'JobTypeDpmJob', 'JobTypeMabJob'
	JobType JobType `json:"jobType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureIaaSVMJob.
func (aisj AzureIaaSVMJob) MarshalJSON() ([]byte, error) {
	aisj.JobType = JobTypeAzureIaaSVMJob
	objectMap := make(map[string]interface{})
	if aisj.Duration != nil {
		objectMap["duration"] = aisj.Duration
	}
	if aisj.ActionsInfo != nil {
		objectMap["actionsInfo"] = aisj.ActionsInfo
	}
	if aisj.ErrorDetails != nil {
		objectMap["errorDetails"] = aisj.ErrorDetails
	}
	if aisj.VirtualMachineVersion != nil {
		objectMap["virtualMachineVersion"] = aisj.VirtualMachineVersion
	}
	if aisj.ExtendedInfo != nil {
		objectMap["extendedInfo"] = aisj.ExtendedInfo
	}
	if aisj.EntityFriendlyName != nil {
		objectMap["entityFriendlyName"] = aisj.EntityFriendlyName
	}
	if aisj.BackupManagementType != "" {
		objectMap["backupManagementType"] = aisj.BackupManagementType
	}
	if aisj.Operation != nil {
		objectMap["operation"] = aisj.Operation
	}
	if aisj.Status != nil {
		objectMap["status"] = aisj.Status
	}
	if aisj.StartTime != nil {
		objectMap["startTime"] = aisj.StartTime
	}
	if aisj.EndTime != nil {
		objectMap["endTime"] = aisj.EndTime
	}
	if aisj.ActivityID != nil {
		objectMap["activityId"] = aisj.ActivityID
	}
	if aisj.JobType != "" {
		objectMap["jobType"] = aisj.JobType
	}
	return json.Marshal(objectMap)
}

// AsAzureIaaSVMJob is the BasicJob implementation for AzureIaaSVMJob.
func (aisj AzureIaaSVMJob) AsAzureIaaSVMJob() (*AzureIaaSVMJob, bool) {
	return &aisj, true
}

// AsAzureStorageJob is the BasicJob implementation for AzureIaaSVMJob.
func (aisj AzureIaaSVMJob) AsAzureStorageJob() (*AzureStorageJob, bool) {
	return nil, false
}

// AsAzureWorkloadJob is the BasicJob implementation for AzureIaaSVMJob.
func (aisj AzureIaaSVMJob) AsAzureWorkloadJob() (*AzureWorkloadJob, bool) {
	return nil, false
}

// AsDpmJob is the BasicJob implementation for AzureIaaSVMJob.
func (aisj AzureIaaSVMJob) AsDpmJob() (*DpmJob, bool) {
	return nil, false
}

// AsMabJob is the BasicJob implementation for AzureIaaSVMJob.
func (aisj AzureIaaSVMJob) AsMabJob() (*MabJob, bool) {
	return nil, false
}

// AsJob is the BasicJob implementation for AzureIaaSVMJob.
func (aisj AzureIaaSVMJob) AsJob() (*Job, bool) {
	return nil, false
}

// AsBasicJob is the BasicJob implementation for AzureIaaSVMJob.
func (aisj AzureIaaSVMJob) AsBasicJob() (BasicJob, bool) {
	return &aisj, true
}

// AzureIaaSVMJobExtendedInfo azure IaaS VM workload-specific additional information for job.
type AzureIaaSVMJobExtendedInfo struct {
	// TasksList - List of tasks associated with this job.
	TasksList *[]AzureIaaSVMJobTaskDetails `json:"tasksList,omitempty"`
	// PropertyBag - Job properties.
	PropertyBag map[string]*string `json:"propertyBag"`
	// InternalPropertyBag - Job internal properties.
	InternalPropertyBag map[string]*string `json:"internalPropertyBag"`
	// ProgressPercentage - Indicates progress of the job. Null if it has not started or completed.
	ProgressPercentage *float64 `json:"progressPercentage,omitempty"`
	// EstimatedRemainingDuration - Time remaining for execution of this job.
	EstimatedRemainingDuration *string `json:"estimatedRemainingDuration,omitempty"`
	// DynamicErrorMessage - Non localized error message on job execution.
	DynamicErrorMessage *string `json:"dynamicErrorMessage,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureIaaSVMJobExtendedInfo.
func (aisjei AzureIaaSVMJobExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aisjei.TasksList != nil {
		objectMap["tasksList"] = aisjei.TasksList
	}
	if aisjei.PropertyBag != nil {
		objectMap["propertyBag"] = aisjei.PropertyBag
	}
	if aisjei.InternalPropertyBag != nil {
		objectMap["internalPropertyBag"] = aisjei.InternalPropertyBag
	}
	if aisjei.ProgressPercentage != nil {
		objectMap["progressPercentage"] = aisjei.ProgressPercentage
	}
	if aisjei.EstimatedRemainingDuration != nil {
		objectMap["estimatedRemainingDuration"] = aisjei.EstimatedRemainingDuration
	}
	if aisjei.DynamicErrorMessage != nil {
		objectMap["dynamicErrorMessage"] = aisjei.DynamicErrorMessage
	}
	return json.Marshal(objectMap)
}

// AzureIaaSVMJobTaskDetails azure IaaS VM workload-specific job task details.
type AzureIaaSVMJobTaskDetails struct {
	// TaskID - The task display name.
	TaskID *string `json:"taskId,omitempty"`
	// StartTime - The start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// InstanceID - The instanceId.
	InstanceID *string `json:"instanceId,omitempty"`
	// Duration - Time elapsed for task.
	Duration *string `json:"duration,omitempty"`
	// Status - The status.
	Status *string `json:"status,omitempty"`
	// ProgressPercentage - Progress of the task.
	ProgressPercentage *float64 `json:"progressPercentage,omitempty"`
	// TaskExecutionDetails - Details about execution of the task.
	// eg: number of bytes transferred etc
	TaskExecutionDetails *string `json:"taskExecutionDetails,omitempty"`
}

// BasicAzureIaaSVMProtectedItem iaaS VM workload-specific backup item.
type BasicAzureIaaSVMProtectedItem interface {
	AsAzureIaaSClassicComputeVMProtectedItem() (*AzureIaaSClassicComputeVMProtectedItem, bool)
	AsAzureIaaSComputeVMProtectedItem() (*AzureIaaSComputeVMProtectedItem, bool)
	AsAzureIaaSVMProtectedItem() (*AzureIaaSVMProtectedItem, bool)
}

// AzureIaaSVMProtectedItem iaaS VM workload-specific backup item.
type AzureIaaSVMProtectedItem struct {
	// FriendlyName - Friendly name of the VM represented by this backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// VirtualMachineID - Fully qualified ARM ID of the virtual machine represented by this item.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// ProtectionStatus - Backup status of this backup item.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`
	// ProtectionState - Backup state of this backup item. Possible values include: 'ProtectionStateInvalid', 'ProtectionStateIRPending', 'ProtectionStateProtected', 'ProtectionStateProtectionError', 'ProtectionStateProtectionStopped', 'ProtectionStateProtectionPaused'
	ProtectionState ProtectionState `json:"protectionState,omitempty"`
	// HealthStatus - Health status of protected item. Possible values include: 'HealthStatusPassed', 'HealthStatusActionRequired', 'HealthStatusActionSuggested', 'HealthStatusInvalid'
	HealthStatus HealthStatus `json:"healthStatus,omitempty"`
	// HealthDetails - Health details on this backup item.
	HealthDetails *[]AzureIaaSVMHealthDetails `json:"healthDetails,omitempty"`
	// LastBackupStatus - Last backup operation status.
	LastBackupStatus *string `json:"lastBackupStatus,omitempty"`
	// LastBackupTime - Timestamp of the last backup operation on this backup item.
	LastBackupTime *date.Time `json:"lastBackupTime,omitempty"`
	// ProtectedItemDataID - Data ID of the protected item.
	ProtectedItemDataID *string `json:"protectedItemDataId,omitempty"`
	// ExtendedInfo - Additional information for this backup item.
	ExtendedInfo       *AzureIaaSVMProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`
	ExtendedProperties *ExtendedProperties                   `json:"extendedProperties,omitempty"`
	// BackupManagementType - Type of backup management for the backed up item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload this item represents. Possible values include: 'DataSourceTypeInvalid', 'DataSourceTypeVM', 'DataSourceTypeFileFolder', 'DataSourceTypeAzureSQLDb', 'DataSourceTypeSQLDB', 'DataSourceTypeExchange', 'DataSourceTypeSharepoint', 'DataSourceTypeVMwareVM', 'DataSourceTypeSystemState', 'DataSourceTypeClient', 'DataSourceTypeGenericDataSource', 'DataSourceTypeSQLDataBase', 'DataSourceTypeAzureFileShare', 'DataSourceTypeSAPHanaDatabase', 'DataSourceTypeSAPAseDatabase'
	WorkloadType DataSourceType `json:"workloadType,omitempty"`
	// ContainerName - Unique name of container
	ContainerName *string `json:"containerName,omitempty"`
	// SourceResourceID - ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// PolicyID - ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`
	// LastRecoveryPoint - Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *date.Time `json:"lastRecoveryPoint,omitempty"`
	// BackupSetName - Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`
	// CreateMode - Create mode to indicate recovery of existing soft deleted data source or creation of new data source. Possible values include: 'CreateModeInvalid', 'CreateModeDefault', 'CreateModeRecover'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// DeferredDeleteTimeInUTC - Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *date.Time `json:"deferredDeleteTimeInUTC,omitempty"`
	// IsScheduledForDeferredDelete - Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`
	// DeferredDeleteTimeRemaining - Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`
	// IsDeferredDeleteScheduleUpcoming - Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`
	// IsRehydrate - Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`
	// ProtectedItemType - Possible values include: 'ProtectedItemTypeProtectedItem', 'ProtectedItemTypeAzureFileShareProtectedItem', 'ProtectedItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectedItemTypeMicrosoftComputevirtualMachines', 'ProtectedItemTypeAzureIaaSVMProtectedItem', 'ProtectedItemTypeMicrosoftSqlserversdatabases', 'ProtectedItemTypeAzureVMWorkloadProtectedItem', 'ProtectedItemTypeAzureVMWorkloadSAPAseDatabase', 'ProtectedItemTypeAzureVMWorkloadSAPHanaDatabase', 'ProtectedItemTypeAzureVMWorkloadSQLDatabase', 'ProtectedItemTypeDPMProtectedItem', 'ProtectedItemTypeGenericProtectedItem', 'ProtectedItemTypeMabFileFolderProtectedItem'
	ProtectedItemType ProtectedItemType `json:"protectedItemType,omitempty"`
}

func unmarshalBasicAzureIaaSVMProtectedItem(body []byte) (BasicAzureIaaSVMProtectedItem, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["protectedItemType"] {
	case string(ProtectedItemTypeMicrosoftClassicComputevirtualMachines):
		var aisccvpi AzureIaaSClassicComputeVMProtectedItem
		err := json.Unmarshal(body, &aisccvpi)
		return aisccvpi, err
	case string(ProtectedItemTypeMicrosoftComputevirtualMachines):
		var aiscvpi AzureIaaSComputeVMProtectedItem
		err := json.Unmarshal(body, &aiscvpi)
		return aiscvpi, err
	default:
		var aispi AzureIaaSVMProtectedItem
		err := json.Unmarshal(body, &aispi)
		return aispi, err
	}
}
func unmarshalBasicAzureIaaSVMProtectedItemArray(body []byte) ([]BasicAzureIaaSVMProtectedItem, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aispiArray := make([]BasicAzureIaaSVMProtectedItem, len(rawMessages))

	for index, rawMessage := range rawMessages {
		aispi, err := unmarshalBasicAzureIaaSVMProtectedItem(*rawMessage)
		if err != nil {
			return nil, err
		}
		aispiArray[index] = aispi
	}
	return aispiArray, nil
}

// MarshalJSON is the custom marshaler for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) MarshalJSON() ([]byte, error) {
	aispi.ProtectedItemType = ProtectedItemTypeAzureIaaSVMProtectedItem
	objectMap := make(map[string]interface{})
	if aispi.FriendlyName != nil {
		objectMap["friendlyName"] = aispi.FriendlyName
	}
	if aispi.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = aispi.VirtualMachineID
	}
	if aispi.ProtectionStatus != nil {
		objectMap["protectionStatus"] = aispi.ProtectionStatus
	}
	if aispi.ProtectionState != "" {
		objectMap["protectionState"] = aispi.ProtectionState
	}
	if aispi.HealthStatus != "" {
		objectMap["healthStatus"] = aispi.HealthStatus
	}
	if aispi.HealthDetails != nil {
		objectMap["healthDetails"] = aispi.HealthDetails
	}
	if aispi.LastBackupStatus != nil {
		objectMap["lastBackupStatus"] = aispi.LastBackupStatus
	}
	if aispi.LastBackupTime != nil {
		objectMap["lastBackupTime"] = aispi.LastBackupTime
	}
	if aispi.ProtectedItemDataID != nil {
		objectMap["protectedItemDataId"] = aispi.ProtectedItemDataID
	}
	if aispi.ExtendedInfo != nil {
		objectMap["extendedInfo"] = aispi.ExtendedInfo
	}
	if aispi.ExtendedProperties != nil {
		objectMap["extendedProperties"] = aispi.ExtendedProperties
	}
	if aispi.BackupManagementType != "" {
		objectMap["backupManagementType"] = aispi.BackupManagementType
	}
	if aispi.WorkloadType != "" {
		objectMap["workloadType"] = aispi.WorkloadType
	}
	if aispi.ContainerName != nil {
		objectMap["containerName"] = aispi.ContainerName
	}
	if aispi.SourceResourceID != nil {
		objectMap["sourceResourceId"] = aispi.SourceResourceID
	}
	if aispi.PolicyID != nil {
		objectMap["policyId"] = aispi.PolicyID
	}
	if aispi.LastRecoveryPoint != nil {
		objectMap["lastRecoveryPoint"] = aispi.LastRecoveryPoint
	}
	if aispi.BackupSetName != nil {
		objectMap["backupSetName"] = aispi.BackupSetName
	}
	if aispi.CreateMode != "" {
		objectMap["createMode"] = aispi.CreateMode
	}
	if aispi.DeferredDeleteTimeInUTC != nil {
		objectMap["deferredDeleteTimeInUTC"] = aispi.DeferredDeleteTimeInUTC
	}
	if aispi.IsScheduledForDeferredDelete != nil {
		objectMap["isScheduledForDeferredDelete"] = aispi.IsScheduledForDeferredDelete
	}
	if aispi.DeferredDeleteTimeRemaining != nil {
		objectMap["deferredDeleteTimeRemaining"] = aispi.DeferredDeleteTimeRemaining
	}
	if aispi.IsDeferredDeleteScheduleUpcoming != nil {
		objectMap["isDeferredDeleteScheduleUpcoming"] = aispi.IsDeferredDeleteScheduleUpcoming
	}
	if aispi.IsRehydrate != nil {
		objectMap["isRehydrate"] = aispi.IsRehydrate
	}
	if aispi.ProtectedItemType != "" {
		objectMap["protectedItemType"] = aispi.ProtectedItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileshareProtectedItem is the BasicProtectedItem implementation for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) AsAzureFileshareProtectedItem() (*AzureFileshareProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectedItem is the BasicProtectedItem implementation for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) AsAzureIaaSClassicComputeVMProtectedItem() (*AzureIaaSClassicComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectedItem is the BasicProtectedItem implementation for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) AsAzureIaaSComputeVMProtectedItem() (*AzureIaaSComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) AsAzureIaaSVMProtectedItem() (*AzureIaaSVMProtectedItem, bool) {
	return &aispi, true
}

// AsBasicAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) AsBasicAzureIaaSVMProtectedItem() (BasicAzureIaaSVMProtectedItem, bool) {
	return &aispi, true
}

// AsAzureSQLProtectedItem is the BasicProtectedItem implementation for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) AsAzureSQLProtectedItem() (*AzureSQLProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) AsAzureVMWorkloadProtectedItem() (*AzureVMWorkloadProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) AsBasicAzureVMWorkloadProtectedItem() (BasicAzureVMWorkloadProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseDatabaseProtectedItem is the BasicProtectedItem implementation for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) AsAzureVMWorkloadSAPAseDatabaseProtectedItem() (*AzureVMWorkloadSAPAseDatabaseProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectedItem is the BasicProtectedItem implementation for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) AsAzureVMWorkloadSAPHanaDatabaseProtectedItem() (*AzureVMWorkloadSAPHanaDatabaseProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectedItem is the BasicProtectedItem implementation for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) AsAzureVMWorkloadSQLDatabaseProtectedItem() (*AzureVMWorkloadSQLDatabaseProtectedItem, bool) {
	return nil, false
}

// AsDPMProtectedItem is the BasicProtectedItem implementation for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) AsDPMProtectedItem() (*DPMProtectedItem, bool) {
	return nil, false
}

// AsGenericProtectedItem is the BasicProtectedItem implementation for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) AsGenericProtectedItem() (*GenericProtectedItem, bool) {
	return nil, false
}

// AsMabFileFolderProtectedItem is the BasicProtectedItem implementation for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) AsMabFileFolderProtectedItem() (*MabFileFolderProtectedItem, bool) {
	return nil, false
}

// AsProtectedItem is the BasicProtectedItem implementation for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) AsProtectedItem() (*ProtectedItem, bool) {
	return nil, false
}

// AsBasicProtectedItem is the BasicProtectedItem implementation for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) AsBasicProtectedItem() (BasicProtectedItem, bool) {
	return &aispi, true
}

// AzureIaaSVMProtectedItemExtendedInfo additional information on Azure IaaS VM specific backup item.
type AzureIaaSVMProtectedItemExtendedInfo struct {
	// OldestRecoveryPoint - The oldest backup copy available for this backup item.
	OldestRecoveryPoint *date.Time `json:"oldestRecoveryPoint,omitempty"`
	// RecoveryPointCount - Number of backup copies available for this backup item.
	RecoveryPointCount *int32 `json:"recoveryPointCount,omitempty"`
	// PolicyInconsistent - Specifies if backup policy associated with the backup item is inconsistent.
	PolicyInconsistent *bool `json:"policyInconsistent,omitempty"`
}

// AzureIaaSVMProtectionPolicy iaaS VM workload-specific backup policy.
type AzureIaaSVMProtectionPolicy struct {
	InstantRPDetails *InstantRPAdditionalDetails `json:"instantRPDetails,omitempty"`
	// SchedulePolicy - Backup schedule specified as part of backup policy.
	SchedulePolicy BasicSchedulePolicy `json:"schedulePolicy,omitempty"`
	// RetentionPolicy - Retention policy with the details on backup copy retention ranges.
	RetentionPolicy BasicRetentionPolicy `json:"retentionPolicy,omitempty"`
	// InstantRpRetentionRangeInDays - Instant RP retention policy range in days
	InstantRpRetentionRangeInDays *int32 `json:"instantRpRetentionRangeInDays,omitempty"`
	// TimeZone - TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
	TimeZone *string `json:"timeZone,omitempty"`
	// ProtectedItemsCount - Number of items associated with this policy.
	ProtectedItemsCount *int32 `json:"protectedItemsCount,omitempty"`
	// BackupManagementType - Possible values include: 'BackupManagementTypeProtectionPolicy', 'BackupManagementTypeAzureWorkload', 'BackupManagementTypeAzureStorage', 'BackupManagementTypeAzureIaasVM', 'BackupManagementTypeAzureSQL', 'BackupManagementTypeGenericProtectionPolicy', 'BackupManagementTypeMAB'
	BackupManagementType ManagementTypeBasicProtectionPolicy `json:"backupManagementType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureIaaSVMProtectionPolicy.
func (aispp AzureIaaSVMProtectionPolicy) MarshalJSON() ([]byte, error) {
	aispp.BackupManagementType = BackupManagementTypeAzureIaasVM
	objectMap := make(map[string]interface{})
	if aispp.InstantRPDetails != nil {
		objectMap["instantRPDetails"] = aispp.InstantRPDetails
	}
	objectMap["schedulePolicy"] = aispp.SchedulePolicy
	objectMap["retentionPolicy"] = aispp.RetentionPolicy
	if aispp.InstantRpRetentionRangeInDays != nil {
		objectMap["instantRpRetentionRangeInDays"] = aispp.InstantRpRetentionRangeInDays
	}
	if aispp.TimeZone != nil {
		objectMap["timeZone"] = aispp.TimeZone
	}
	if aispp.ProtectedItemsCount != nil {
		objectMap["protectedItemsCount"] = aispp.ProtectedItemsCount
	}
	if aispp.BackupManagementType != "" {
		objectMap["backupManagementType"] = aispp.BackupManagementType
	}
	return json.Marshal(objectMap)
}

// AsAzureVMWorkloadProtectionPolicy is the BasicProtectionPolicy implementation for AzureIaaSVMProtectionPolicy.
func (aispp AzureIaaSVMProtectionPolicy) AsAzureVMWorkloadProtectionPolicy() (*AzureVMWorkloadProtectionPolicy, bool) {
	return nil, false
}

// AsAzureFileShareProtectionPolicy is the BasicProtectionPolicy implementation for AzureIaaSVMProtectionPolicy.
func (aispp AzureIaaSVMProtectionPolicy) AsAzureFileShareProtectionPolicy() (*AzureFileShareProtectionPolicy, bool) {
	return nil, false
}

// AsAzureIaaSVMProtectionPolicy is the BasicProtectionPolicy implementation for AzureIaaSVMProtectionPolicy.
func (aispp AzureIaaSVMProtectionPolicy) AsAzureIaaSVMProtectionPolicy() (*AzureIaaSVMProtectionPolicy, bool) {
	return &aispp, true
}

// AsAzureSQLProtectionPolicy is the BasicProtectionPolicy implementation for AzureIaaSVMProtectionPolicy.
func (aispp AzureIaaSVMProtectionPolicy) AsAzureSQLProtectionPolicy() (*AzureSQLProtectionPolicy, bool) {
	return nil, false
}

// AsGenericProtectionPolicy is the BasicProtectionPolicy implementation for AzureIaaSVMProtectionPolicy.
func (aispp AzureIaaSVMProtectionPolicy) AsGenericProtectionPolicy() (*GenericProtectionPolicy, bool) {
	return nil, false
}

// AsMabProtectionPolicy is the BasicProtectionPolicy implementation for AzureIaaSVMProtectionPolicy.
func (aispp AzureIaaSVMProtectionPolicy) AsMabProtectionPolicy() (*MabProtectionPolicy, bool) {
	return nil, false
}

// AsProtectionPolicy is the BasicProtectionPolicy implementation for AzureIaaSVMProtectionPolicy.
func (aispp AzureIaaSVMProtectionPolicy) AsProtectionPolicy() (*ProtectionPolicy, bool) {
	return nil, false
}

// AsBasicProtectionPolicy is the BasicProtectionPolicy implementation for AzureIaaSVMProtectionPolicy.
func (aispp AzureIaaSVMProtectionPolicy) AsBasicProtectionPolicy() (BasicProtectionPolicy, bool) {
	return &aispp, true
}

// UnmarshalJSON is the custom unmarshaler for AzureIaaSVMProtectionPolicy struct.
func (aispp *AzureIaaSVMProtectionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "instantRPDetails":
			if v != nil {
				var instantRPDetails InstantRPAdditionalDetails
				err = json.Unmarshal(*v, &instantRPDetails)
				if err != nil {
					return err
				}
				aispp.InstantRPDetails = &instantRPDetails
			}
		case "schedulePolicy":
			if v != nil {
				schedulePolicy, err := unmarshalBasicSchedulePolicy(*v)
				if err != nil {
					return err
				}
				aispp.SchedulePolicy = schedulePolicy
			}
		case "retentionPolicy":
			if v != nil {
				retentionPolicy, err := unmarshalBasicRetentionPolicy(*v)
				if err != nil {
					return err
				}
				aispp.RetentionPolicy = retentionPolicy
			}
		case "instantRpRetentionRangeInDays":
			if v != nil {
				var instantRpRetentionRangeInDays int32
				err = json.Unmarshal(*v, &instantRpRetentionRangeInDays)
				if err != nil {
					return err
				}
				aispp.InstantRpRetentionRangeInDays = &instantRpRetentionRangeInDays
			}
		case "timeZone":
			if v != nil {
				var timeZone string
				err = json.Unmarshal(*v, &timeZone)
				if err != nil {
					return err
				}
				aispp.TimeZone = &timeZone
			}
		case "protectedItemsCount":
			if v != nil {
				var protectedItemsCount int32
				err = json.Unmarshal(*v, &protectedItemsCount)
				if err != nil {
					return err
				}
				aispp.ProtectedItemsCount = &protectedItemsCount
			}
		case "backupManagementType":
			if v != nil {
				var backupManagementType ManagementTypeBasicProtectionPolicy
				err = json.Unmarshal(*v, &backupManagementType)
				if err != nil {
					return err
				}
				aispp.BackupManagementType = backupManagementType
			}
		}
	}

	return nil
}

// BasicAzureRecoveryServiceVaultProtectionIntent azure Recovery Services Vault specific protection intent item.
type BasicAzureRecoveryServiceVaultProtectionIntent interface {
	AsAzureWorkloadAutoProtectionIntent() (*AzureWorkloadAutoProtectionIntent, bool)
	AsBasicAzureWorkloadAutoProtectionIntent() (BasicAzureWorkloadAutoProtectionIntent, bool)
	AsAzureWorkloadSQLAutoProtectionIntent() (*AzureWorkloadSQLAutoProtectionIntent, bool)
	AsAzureRecoveryServiceVaultProtectionIntent() (*AzureRecoveryServiceVaultProtectionIntent, bool)
}

// AzureRecoveryServiceVaultProtectionIntent azure Recovery Services Vault specific protection intent item.
type AzureRecoveryServiceVaultProtectionIntent struct {
	// BackupManagementType - Type of backup management for the backed up item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// SourceResourceID - ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// ItemID - ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
	ItemID *string `json:"itemId,omitempty"`
	// PolicyID - ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`
	// ProtectionState - Backup state of this backup item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectionIntentItemType - Possible values include: 'ProtectionIntentItemTypeProtectionIntent', 'ProtectionIntentItemTypeRecoveryServiceVaultItem', 'ProtectionIntentItemTypeAzureResourceItem', 'ProtectionIntentItemTypeAzureWorkloadAutoProtectionIntent', 'ProtectionIntentItemTypeAzureWorkloadSQLAutoProtectionIntent'
	ProtectionIntentItemType ProtectionIntentItemType `json:"protectionIntentItemType,omitempty"`
}

func unmarshalBasicAzureRecoveryServiceVaultProtectionIntent(body []byte) (BasicAzureRecoveryServiceVaultProtectionIntent, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["protectionIntentItemType"] {
	case string(ProtectionIntentItemTypeAzureWorkloadAutoProtectionIntent):
		var awapi AzureWorkloadAutoProtectionIntent
		err := json.Unmarshal(body, &awapi)
		return awapi, err
	case string(ProtectionIntentItemTypeAzureWorkloadSQLAutoProtectionIntent):
		var awsapi AzureWorkloadSQLAutoProtectionIntent
		err := json.Unmarshal(body, &awsapi)
		return awsapi, err
	default:
		var arsvpi AzureRecoveryServiceVaultProtectionIntent
		err := json.Unmarshal(body, &arsvpi)
		return arsvpi, err
	}
}
func unmarshalBasicAzureRecoveryServiceVaultProtectionIntentArray(body []byte) ([]BasicAzureRecoveryServiceVaultProtectionIntent, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	arsvpiArray := make([]BasicAzureRecoveryServiceVaultProtectionIntent, len(rawMessages))

	for index, rawMessage := range rawMessages {
		arsvpi, err := unmarshalBasicAzureRecoveryServiceVaultProtectionIntent(*rawMessage)
		if err != nil {
			return nil, err
		}
		arsvpiArray[index] = arsvpi
	}
	return arsvpiArray, nil
}

// MarshalJSON is the custom marshaler for AzureRecoveryServiceVaultProtectionIntent.
func (arsvpi AzureRecoveryServiceVaultProtectionIntent) MarshalJSON() ([]byte, error) {
	arsvpi.ProtectionIntentItemType = ProtectionIntentItemTypeRecoveryServiceVaultItem
	objectMap := make(map[string]interface{})
	if arsvpi.BackupManagementType != "" {
		objectMap["backupManagementType"] = arsvpi.BackupManagementType
	}
	if arsvpi.SourceResourceID != nil {
		objectMap["sourceResourceId"] = arsvpi.SourceResourceID
	}
	if arsvpi.ItemID != nil {
		objectMap["itemId"] = arsvpi.ItemID
	}
	if arsvpi.PolicyID != nil {
		objectMap["policyId"] = arsvpi.PolicyID
	}
	if arsvpi.ProtectionState != "" {
		objectMap["protectionState"] = arsvpi.ProtectionState
	}
	if arsvpi.ProtectionIntentItemType != "" {
		objectMap["protectionIntentItemType"] = arsvpi.ProtectionIntentItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureRecoveryServiceVaultProtectionIntent is the BasicProtectionIntent implementation for AzureRecoveryServiceVaultProtectionIntent.
func (arsvpi AzureRecoveryServiceVaultProtectionIntent) AsAzureRecoveryServiceVaultProtectionIntent() (*AzureRecoveryServiceVaultProtectionIntent, bool) {
	return &arsvpi, true
}

// AsBasicAzureRecoveryServiceVaultProtectionIntent is the BasicProtectionIntent implementation for AzureRecoveryServiceVaultProtectionIntent.
func (arsvpi AzureRecoveryServiceVaultProtectionIntent) AsBasicAzureRecoveryServiceVaultProtectionIntent() (BasicAzureRecoveryServiceVaultProtectionIntent, bool) {
	return &arsvpi, true
}

// AsAzureResourceProtectionIntent is the BasicProtectionIntent implementation for AzureRecoveryServiceVaultProtectionIntent.
func (arsvpi AzureRecoveryServiceVaultProtectionIntent) AsAzureResourceProtectionIntent() (*AzureResourceProtectionIntent, bool) {
	return nil, false
}

// AsAzureWorkloadAutoProtectionIntent is the BasicProtectionIntent implementation for AzureRecoveryServiceVaultProtectionIntent.
func (arsvpi AzureRecoveryServiceVaultProtectionIntent) AsAzureWorkloadAutoProtectionIntent() (*AzureWorkloadAutoProtectionIntent, bool) {
	return nil, false
}

// AsBasicAzureWorkloadAutoProtectionIntent is the BasicProtectionIntent implementation for AzureRecoveryServiceVaultProtectionIntent.
func (arsvpi AzureRecoveryServiceVaultProtectionIntent) AsBasicAzureWorkloadAutoProtectionIntent() (BasicAzureWorkloadAutoProtectionIntent, bool) {
	return nil, false
}

// AsAzureWorkloadSQLAutoProtectionIntent is the BasicProtectionIntent implementation for AzureRecoveryServiceVaultProtectionIntent.
func (arsvpi AzureRecoveryServiceVaultProtectionIntent) AsAzureWorkloadSQLAutoProtectionIntent() (*AzureWorkloadSQLAutoProtectionIntent, bool) {
	return nil, false
}

// AsProtectionIntent is the BasicProtectionIntent implementation for AzureRecoveryServiceVaultProtectionIntent.
func (arsvpi AzureRecoveryServiceVaultProtectionIntent) AsProtectionIntent() (*ProtectionIntent, bool) {
	return nil, false
}

// AsBasicProtectionIntent is the BasicProtectionIntent implementation for AzureRecoveryServiceVaultProtectionIntent.
func (arsvpi AzureRecoveryServiceVaultProtectionIntent) AsBasicProtectionIntent() (BasicProtectionIntent, bool) {
	return &arsvpi, true
}

// AzureResourceProtectionIntent iaaS VM specific backup protection intent item.
type AzureResourceProtectionIntent struct {
	// FriendlyName - Friendly name of the VM represented by this backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the backed up item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// SourceResourceID - ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// ItemID - ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
	ItemID *string `json:"itemId,omitempty"`
	// PolicyID - ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`
	// ProtectionState - Backup state of this backup item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectionIntentItemType - Possible values include: 'ProtectionIntentItemTypeProtectionIntent', 'ProtectionIntentItemTypeRecoveryServiceVaultItem', 'ProtectionIntentItemTypeAzureResourceItem', 'ProtectionIntentItemTypeAzureWorkloadAutoProtectionIntent', 'ProtectionIntentItemTypeAzureWorkloadSQLAutoProtectionIntent'
	ProtectionIntentItemType ProtectionIntentItemType `json:"protectionIntentItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureResourceProtectionIntent.
func (arpi AzureResourceProtectionIntent) MarshalJSON() ([]byte, error) {
	arpi.ProtectionIntentItemType = ProtectionIntentItemTypeAzureResourceItem
	objectMap := make(map[string]interface{})
	if arpi.FriendlyName != nil {
		objectMap["friendlyName"] = arpi.FriendlyName
	}
	if arpi.BackupManagementType != "" {
		objectMap["backupManagementType"] = arpi.BackupManagementType
	}
	if arpi.SourceResourceID != nil {
		objectMap["sourceResourceId"] = arpi.SourceResourceID
	}
	if arpi.ItemID != nil {
		objectMap["itemId"] = arpi.ItemID
	}
	if arpi.PolicyID != nil {
		objectMap["policyId"] = arpi.PolicyID
	}
	if arpi.ProtectionState != "" {
		objectMap["protectionState"] = arpi.ProtectionState
	}
	if arpi.ProtectionIntentItemType != "" {
		objectMap["protectionIntentItemType"] = arpi.ProtectionIntentItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureRecoveryServiceVaultProtectionIntent is the BasicProtectionIntent implementation for AzureResourceProtectionIntent.
func (arpi AzureResourceProtectionIntent) AsAzureRecoveryServiceVaultProtectionIntent() (*AzureRecoveryServiceVaultProtectionIntent, bool) {
	return nil, false
}

// AsBasicAzureRecoveryServiceVaultProtectionIntent is the BasicProtectionIntent implementation for AzureResourceProtectionIntent.
func (arpi AzureResourceProtectionIntent) AsBasicAzureRecoveryServiceVaultProtectionIntent() (BasicAzureRecoveryServiceVaultProtectionIntent, bool) {
	return nil, false
}

// AsAzureResourceProtectionIntent is the BasicProtectionIntent implementation for AzureResourceProtectionIntent.
func (arpi AzureResourceProtectionIntent) AsAzureResourceProtectionIntent() (*AzureResourceProtectionIntent, bool) {
	return &arpi, true
}

// AsAzureWorkloadAutoProtectionIntent is the BasicProtectionIntent implementation for AzureResourceProtectionIntent.
func (arpi AzureResourceProtectionIntent) AsAzureWorkloadAutoProtectionIntent() (*AzureWorkloadAutoProtectionIntent, bool) {
	return nil, false
}

// AsBasicAzureWorkloadAutoProtectionIntent is the BasicProtectionIntent implementation for AzureResourceProtectionIntent.
func (arpi AzureResourceProtectionIntent) AsBasicAzureWorkloadAutoProtectionIntent() (BasicAzureWorkloadAutoProtectionIntent, bool) {
	return nil, false
}

// AsAzureWorkloadSQLAutoProtectionIntent is the BasicProtectionIntent implementation for AzureResourceProtectionIntent.
func (arpi AzureResourceProtectionIntent) AsAzureWorkloadSQLAutoProtectionIntent() (*AzureWorkloadSQLAutoProtectionIntent, bool) {
	return nil, false
}

// AsProtectionIntent is the BasicProtectionIntent implementation for AzureResourceProtectionIntent.
func (arpi AzureResourceProtectionIntent) AsProtectionIntent() (*ProtectionIntent, bool) {
	return nil, false
}

// AsBasicProtectionIntent is the BasicProtectionIntent implementation for AzureResourceProtectionIntent.
func (arpi AzureResourceProtectionIntent) AsBasicProtectionIntent() (BasicProtectionIntent, bool) {
	return &arpi, true
}

// AzureSQLAGWorkloadContainerProtectionContainer container for SQL workloads under SQL Availability Group.
type AzureSQLAGWorkloadContainerProtectionContainer struct {
	// SourceResourceID - ARM ID of the virtual machine represented by this Azure Workload Container
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// LastUpdatedTime - Time stamp when this container was updated.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
	// ExtendedInfo - Additional details of a workload container.
	ExtendedInfo *AzureWorkloadContainerExtendedInfo `json:"extendedInfo,omitempty"`
	// WorkloadType - Workload type for which registration was sent. Possible values include: 'WorkloadTypeInvalid', 'WorkloadTypeVM', 'WorkloadTypeFileFolder', 'WorkloadTypeAzureSQLDb', 'WorkloadTypeSQLDB', 'WorkloadTypeExchange', 'WorkloadTypeSharepoint', 'WorkloadTypeVMwareVM', 'WorkloadTypeSystemState', 'WorkloadTypeClient', 'WorkloadTypeGenericDataSource', 'WorkloadTypeSQLDataBase', 'WorkloadTypeAzureFileShare', 'WorkloadTypeSAPHanaDatabase', 'WorkloadTypeSAPAseDatabase'
	WorkloadType WorkloadType `json:"workloadType,omitempty"`
	// OperationType - Re-Do Operation. Possible values include: 'OperationTypeInvalid', 'OperationTypeRegister', 'OperationTypeReregister'
	OperationType OperationType `json:"operationType,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) MarshalJSON() ([]byte, error) {
	aswcpc.ContainerType = ContainerTypeSQLAGWorkLoadContainer1
	objectMap := make(map[string]interface{})
	if aswcpc.SourceResourceID != nil {
		objectMap["sourceResourceId"] = aswcpc.SourceResourceID
	}
	if aswcpc.LastUpdatedTime != nil {
		objectMap["lastUpdatedTime"] = aswcpc.LastUpdatedTime
	}
	if aswcpc.ExtendedInfo != nil {
		objectMap["extendedInfo"] = aswcpc.ExtendedInfo
	}
	if aswcpc.WorkloadType != "" {
		objectMap["workloadType"] = aswcpc.WorkloadType
	}
	if aswcpc.OperationType != "" {
		objectMap["operationType"] = aswcpc.OperationType
	}
	if aswcpc.FriendlyName != nil {
		objectMap["friendlyName"] = aswcpc.FriendlyName
	}
	if aswcpc.BackupManagementType != "" {
		objectMap["backupManagementType"] = aswcpc.BackupManagementType
	}
	if aswcpc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = aswcpc.RegistrationStatus
	}
	if aswcpc.HealthStatus != nil {
		objectMap["healthStatus"] = aswcpc.HealthStatus
	}
	if aswcpc.ContainerType != "" {
		objectMap["containerType"] = aswcpc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return &aswcpc, true
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return nil, false
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return &aswcpc, true
}

// AsDpmContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsDpmContainer() (*DpmContainer, bool) {
	return nil, false
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return nil, false
}

// AsGenericContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsGenericContainer() (*GenericContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return nil, false
}

// AsMabContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for AzureSQLAGWorkloadContainerProtectionContainer.
func (aswcpc AzureSQLAGWorkloadContainerProtectionContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &aswcpc, true
}

// AzureSQLContainer azure Sql workload-specific container.
type AzureSQLContainer struct {
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSQLContainer.
func (asc AzureSQLContainer) MarshalJSON() ([]byte, error) {
	asc.ContainerType = ContainerTypeAzureSQLContainer1
	objectMap := make(map[string]interface{})
	if asc.FriendlyName != nil {
		objectMap["friendlyName"] = asc.FriendlyName
	}
	if asc.BackupManagementType != "" {
		objectMap["backupManagementType"] = asc.BackupManagementType
	}
	if asc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = asc.RegistrationStatus
	}
	if asc.HealthStatus != nil {
		objectMap["healthStatus"] = asc.HealthStatus
	}
	if asc.ContainerType != "" {
		objectMap["containerType"] = asc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return &asc, true
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return nil, false
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return nil, false
}

// AsDpmContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsDpmContainer() (*DpmContainer, bool) {
	return nil, false
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return nil, false
}

// AsGenericContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsGenericContainer() (*GenericContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return nil, false
}

// AsMabContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &asc, true
}

// AzureSQLProtectedItem azure SQL workload-specific backup item.
type AzureSQLProtectedItem struct {
	// ProtectedItemDataID - Internal ID of a backup item. Used by Azure SQL Backup engine to contact Recovery Services.
	ProtectedItemDataID *string `json:"protectedItemDataId,omitempty"`
	// ProtectionState - Backup state of the backed up item. Possible values include: 'ProtectedItemStateInvalid', 'ProtectedItemStateIRPending', 'ProtectedItemStateProtected', 'ProtectedItemStateProtectionError', 'ProtectedItemStateProtectionStopped', 'ProtectedItemStateProtectionPaused'
	ProtectionState ProtectedItemState `json:"protectionState,omitempty"`
	// ExtendedInfo - Additional information for this backup item.
	ExtendedInfo *AzureSQLProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`
	// BackupManagementType - Type of backup management for the backed up item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload this item represents. Possible values include: 'DataSourceTypeInvalid', 'DataSourceTypeVM', 'DataSourceTypeFileFolder', 'DataSourceTypeAzureSQLDb', 'DataSourceTypeSQLDB', 'DataSourceTypeExchange', 'DataSourceTypeSharepoint', 'DataSourceTypeVMwareVM', 'DataSourceTypeSystemState', 'DataSourceTypeClient', 'DataSourceTypeGenericDataSource', 'DataSourceTypeSQLDataBase', 'DataSourceTypeAzureFileShare', 'DataSourceTypeSAPHanaDatabase', 'DataSourceTypeSAPAseDatabase'
	WorkloadType DataSourceType `json:"workloadType,omitempty"`
	// ContainerName - Unique name of container
	ContainerName *string `json:"containerName,omitempty"`
	// SourceResourceID - ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// PolicyID - ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`
	// LastRecoveryPoint - Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *date.Time `json:"lastRecoveryPoint,omitempty"`
	// BackupSetName - Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`
	// CreateMode - Create mode to indicate recovery of existing soft deleted data source or creation of new data source. Possible values include: 'CreateModeInvalid', 'CreateModeDefault', 'CreateModeRecover'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// DeferredDeleteTimeInUTC - Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *date.Time `json:"deferredDeleteTimeInUTC,omitempty"`
	// IsScheduledForDeferredDelete - Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`
	// DeferredDeleteTimeRemaining - Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`
	// IsDeferredDeleteScheduleUpcoming - Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`
	// IsRehydrate - Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`
	// ProtectedItemType - Possible values include: 'ProtectedItemTypeProtectedItem', 'ProtectedItemTypeAzureFileShareProtectedItem', 'ProtectedItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectedItemTypeMicrosoftComputevirtualMachines', 'ProtectedItemTypeAzureIaaSVMProtectedItem', 'ProtectedItemTypeMicrosoftSqlserversdatabases', 'ProtectedItemTypeAzureVMWorkloadProtectedItem', 'ProtectedItemTypeAzureVMWorkloadSAPAseDatabase', 'ProtectedItemTypeAzureVMWorkloadSAPHanaDatabase', 'ProtectedItemTypeAzureVMWorkloadSQLDatabase', 'ProtectedItemTypeDPMProtectedItem', 'ProtectedItemTypeGenericProtectedItem', 'ProtectedItemTypeMabFileFolderProtectedItem'
	ProtectedItemType ProtectedItemType `json:"protectedItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) MarshalJSON() ([]byte, error) {
	aspi.ProtectedItemType = ProtectedItemTypeMicrosoftSqlserversdatabases
	objectMap := make(map[string]interface{})
	if aspi.ProtectedItemDataID != nil {
		objectMap["protectedItemDataId"] = aspi.ProtectedItemDataID
	}
	if aspi.ProtectionState != "" {
		objectMap["protectionState"] = aspi.ProtectionState
	}
	if aspi.ExtendedInfo != nil {
		objectMap["extendedInfo"] = aspi.ExtendedInfo
	}
	if aspi.BackupManagementType != "" {
		objectMap["backupManagementType"] = aspi.BackupManagementType
	}
	if aspi.WorkloadType != "" {
		objectMap["workloadType"] = aspi.WorkloadType
	}
	if aspi.ContainerName != nil {
		objectMap["containerName"] = aspi.ContainerName
	}
	if aspi.SourceResourceID != nil {
		objectMap["sourceResourceId"] = aspi.SourceResourceID
	}
	if aspi.PolicyID != nil {
		objectMap["policyId"] = aspi.PolicyID
	}
	if aspi.LastRecoveryPoint != nil {
		objectMap["lastRecoveryPoint"] = aspi.LastRecoveryPoint
	}
	if aspi.BackupSetName != nil {
		objectMap["backupSetName"] = aspi.BackupSetName
	}
	if aspi.CreateMode != "" {
		objectMap["createMode"] = aspi.CreateMode
	}
	if aspi.DeferredDeleteTimeInUTC != nil {
		objectMap["deferredDeleteTimeInUTC"] = aspi.DeferredDeleteTimeInUTC
	}
	if aspi.IsScheduledForDeferredDelete != nil {
		objectMap["isScheduledForDeferredDelete"] = aspi.IsScheduledForDeferredDelete
	}
	if aspi.DeferredDeleteTimeRemaining != nil {
		objectMap["deferredDeleteTimeRemaining"] = aspi.DeferredDeleteTimeRemaining
	}
	if aspi.IsDeferredDeleteScheduleUpcoming != nil {
		objectMap["isDeferredDeleteScheduleUpcoming"] = aspi.IsDeferredDeleteScheduleUpcoming
	}
	if aspi.IsRehydrate != nil {
		objectMap["isRehydrate"] = aspi.IsRehydrate
	}
	if aspi.ProtectedItemType != "" {
		objectMap["protectedItemType"] = aspi.ProtectedItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileshareProtectedItem is the BasicProtectedItem implementation for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) AsAzureFileshareProtectedItem() (*AzureFileshareProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectedItem is the BasicProtectedItem implementation for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) AsAzureIaaSClassicComputeVMProtectedItem() (*AzureIaaSClassicComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectedItem is the BasicProtectedItem implementation for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) AsAzureIaaSComputeVMProtectedItem() (*AzureIaaSComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) AsAzureIaaSVMProtectedItem() (*AzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) AsBasicAzureIaaSVMProtectedItem() (BasicAzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsAzureSQLProtectedItem is the BasicProtectedItem implementation for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) AsAzureSQLProtectedItem() (*AzureSQLProtectedItem, bool) {
	return &aspi, true
}

// AsAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) AsAzureVMWorkloadProtectedItem() (*AzureVMWorkloadProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) AsBasicAzureVMWorkloadProtectedItem() (BasicAzureVMWorkloadProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseDatabaseProtectedItem is the BasicProtectedItem implementation for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) AsAzureVMWorkloadSAPAseDatabaseProtectedItem() (*AzureVMWorkloadSAPAseDatabaseProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectedItem is the BasicProtectedItem implementation for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) AsAzureVMWorkloadSAPHanaDatabaseProtectedItem() (*AzureVMWorkloadSAPHanaDatabaseProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectedItem is the BasicProtectedItem implementation for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) AsAzureVMWorkloadSQLDatabaseProtectedItem() (*AzureVMWorkloadSQLDatabaseProtectedItem, bool) {
	return nil, false
}

// AsDPMProtectedItem is the BasicProtectedItem implementation for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) AsDPMProtectedItem() (*DPMProtectedItem, bool) {
	return nil, false
}

// AsGenericProtectedItem is the BasicProtectedItem implementation for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) AsGenericProtectedItem() (*GenericProtectedItem, bool) {
	return nil, false
}

// AsMabFileFolderProtectedItem is the BasicProtectedItem implementation for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) AsMabFileFolderProtectedItem() (*MabFileFolderProtectedItem, bool) {
	return nil, false
}

// AsProtectedItem is the BasicProtectedItem implementation for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) AsProtectedItem() (*ProtectedItem, bool) {
	return nil, false
}

// AsBasicProtectedItem is the BasicProtectedItem implementation for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) AsBasicProtectedItem() (BasicProtectedItem, bool) {
	return &aspi, true
}

// AzureSQLProtectedItemExtendedInfo additional information on Azure Sql specific protected item.
type AzureSQLProtectedItemExtendedInfo struct {
	// OldestRecoveryPoint - The oldest backup copy available for this item in the service.
	OldestRecoveryPoint *date.Time `json:"oldestRecoveryPoint,omitempty"`
	// RecoveryPointCount - Number of available backup copies associated with this backup item.
	RecoveryPointCount *int32 `json:"recoveryPointCount,omitempty"`
	// PolicyState - State of the backup policy associated with this backup item.
	PolicyState *string `json:"policyState,omitempty"`
}

// AzureSQLProtectionPolicy azure SQL workload-specific backup policy.
type AzureSQLProtectionPolicy struct {
	// RetentionPolicy - Retention policy details.
	RetentionPolicy BasicRetentionPolicy `json:"retentionPolicy,omitempty"`
	// ProtectedItemsCount - Number of items associated with this policy.
	ProtectedItemsCount *int32 `json:"protectedItemsCount,omitempty"`
	// BackupManagementType - Possible values include: 'BackupManagementTypeProtectionPolicy', 'BackupManagementTypeAzureWorkload', 'BackupManagementTypeAzureStorage', 'BackupManagementTypeAzureIaasVM', 'BackupManagementTypeAzureSQL', 'BackupManagementTypeGenericProtectionPolicy', 'BackupManagementTypeMAB'
	BackupManagementType ManagementTypeBasicProtectionPolicy `json:"backupManagementType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSQLProtectionPolicy.
func (aspp AzureSQLProtectionPolicy) MarshalJSON() ([]byte, error) {
	aspp.BackupManagementType = BackupManagementTypeAzureSQL
	objectMap := make(map[string]interface{})
	objectMap["retentionPolicy"] = aspp.RetentionPolicy
	if aspp.ProtectedItemsCount != nil {
		objectMap["protectedItemsCount"] = aspp.ProtectedItemsCount
	}
	if aspp.BackupManagementType != "" {
		objectMap["backupManagementType"] = aspp.BackupManagementType
	}
	return json.Marshal(objectMap)
}

// AsAzureVMWorkloadProtectionPolicy is the BasicProtectionPolicy implementation for AzureSQLProtectionPolicy.
func (aspp AzureSQLProtectionPolicy) AsAzureVMWorkloadProtectionPolicy() (*AzureVMWorkloadProtectionPolicy, bool) {
	return nil, false
}

// AsAzureFileShareProtectionPolicy is the BasicProtectionPolicy implementation for AzureSQLProtectionPolicy.
func (aspp AzureSQLProtectionPolicy) AsAzureFileShareProtectionPolicy() (*AzureFileShareProtectionPolicy, bool) {
	return nil, false
}

// AsAzureIaaSVMProtectionPolicy is the BasicProtectionPolicy implementation for AzureSQLProtectionPolicy.
func (aspp AzureSQLProtectionPolicy) AsAzureIaaSVMProtectionPolicy() (*AzureIaaSVMProtectionPolicy, bool) {
	return nil, false
}

// AsAzureSQLProtectionPolicy is the BasicProtectionPolicy implementation for AzureSQLProtectionPolicy.
func (aspp AzureSQLProtectionPolicy) AsAzureSQLProtectionPolicy() (*AzureSQLProtectionPolicy, bool) {
	return &aspp, true
}

// AsGenericProtectionPolicy is the BasicProtectionPolicy implementation for AzureSQLProtectionPolicy.
func (aspp AzureSQLProtectionPolicy) AsGenericProtectionPolicy() (*GenericProtectionPolicy, bool) {
	return nil, false
}

// AsMabProtectionPolicy is the BasicProtectionPolicy implementation for AzureSQLProtectionPolicy.
func (aspp AzureSQLProtectionPolicy) AsMabProtectionPolicy() (*MabProtectionPolicy, bool) {
	return nil, false
}

// AsProtectionPolicy is the BasicProtectionPolicy implementation for AzureSQLProtectionPolicy.
func (aspp AzureSQLProtectionPolicy) AsProtectionPolicy() (*ProtectionPolicy, bool) {
	return nil, false
}

// AsBasicProtectionPolicy is the BasicProtectionPolicy implementation for AzureSQLProtectionPolicy.
func (aspp AzureSQLProtectionPolicy) AsBasicProtectionPolicy() (BasicProtectionPolicy, bool) {
	return &aspp, true
}

// UnmarshalJSON is the custom unmarshaler for AzureSQLProtectionPolicy struct.
func (aspp *AzureSQLProtectionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "retentionPolicy":
			if v != nil {
				retentionPolicy, err := unmarshalBasicRetentionPolicy(*v)
				if err != nil {
					return err
				}
				aspp.RetentionPolicy = retentionPolicy
			}
		case "protectedItemsCount":
			if v != nil {
				var protectedItemsCount int32
				err = json.Unmarshal(*v, &protectedItemsCount)
				if err != nil {
					return err
				}
				aspp.ProtectedItemsCount = &protectedItemsCount
			}
		case "backupManagementType":
			if v != nil {
				var backupManagementType ManagementTypeBasicProtectionPolicy
				err = json.Unmarshal(*v, &backupManagementType)
				if err != nil {
					return err
				}
				aspp.BackupManagementType = backupManagementType
			}
		}
	}

	return nil
}

// AzureStorageContainer azure Storage Account workload-specific container.
type AzureStorageContainer struct {
	// SourceResourceID - Fully qualified ARM url.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// StorageAccountVersion - Storage account version.
	StorageAccountVersion *string `json:"storageAccountVersion,omitempty"`
	// ResourceGroup - Resource group name of Recovery Services Vault.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// ProtectedItemCount - Number of items backed up in this container.
	ProtectedItemCount *int64 `json:"protectedItemCount,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureStorageContainer.
func (asc AzureStorageContainer) MarshalJSON() ([]byte, error) {
	asc.ContainerType = ContainerTypeStorageContainer1
	objectMap := make(map[string]interface{})
	if asc.SourceResourceID != nil {
		objectMap["sourceResourceId"] = asc.SourceResourceID
	}
	if asc.StorageAccountVersion != nil {
		objectMap["storageAccountVersion"] = asc.StorageAccountVersion
	}
	if asc.ResourceGroup != nil {
		objectMap["resourceGroup"] = asc.ResourceGroup
	}
	if asc.ProtectedItemCount != nil {
		objectMap["protectedItemCount"] = asc.ProtectedItemCount
	}
	if asc.FriendlyName != nil {
		objectMap["friendlyName"] = asc.FriendlyName
	}
	if asc.BackupManagementType != "" {
		objectMap["backupManagementType"] = asc.BackupManagementType
	}
	if asc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = asc.RegistrationStatus
	}
	if asc.HealthStatus != nil {
		objectMap["healthStatus"] = asc.HealthStatus
	}
	if asc.ContainerType != "" {
		objectMap["containerType"] = asc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return &asc, true
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return nil, false
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return nil, false
}

// AsDpmContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsDpmContainer() (*DpmContainer, bool) {
	return nil, false
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return nil, false
}

// AsGenericContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsGenericContainer() (*GenericContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return nil, false
}

// AsMabContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for AzureStorageContainer.
func (asc AzureStorageContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &asc, true
}

// AzureStorageErrorInfo azure storage specific error information
type AzureStorageErrorInfo struct {
	// ErrorCode - Error code.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorString - Localized error string.
	ErrorString *string `json:"errorString,omitempty"`
	// Recommendations - List of localized recommendations for above error code.
	Recommendations *[]string `json:"recommendations,omitempty"`
}

// AzureStorageJob azure storage specific job.
type AzureStorageJob struct {
	// Duration - Time elapsed during the execution of this job.
	Duration *string `json:"duration,omitempty"`
	// ActionsInfo - Gets or sets the state/actions applicable on this job like cancel/retry.
	ActionsInfo *[]JobSupportedAction `json:"actionsInfo,omitempty"`
	// ErrorDetails - Error details on execution of this job.
	ErrorDetails *[]AzureStorageErrorInfo `json:"errorDetails,omitempty"`
	// StorageAccountName - Specifies friendly name of the storage account.
	StorageAccountName *string `json:"storageAccountName,omitempty"`
	// StorageAccountVersion - Specifies whether the Storage account is a Classic or an Azure Resource Manager Storage account.
	StorageAccountVersion *string `json:"storageAccountVersion,omitempty"`
	// ExtendedInfo - Additional information about the job.
	ExtendedInfo *AzureStorageJobExtendedInfo `json:"extendedInfo,omitempty"`
	// EntityFriendlyName - Friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string `json:"entityFriendlyName,omitempty"`
	// BackupManagementType - Backup management type to execute the current job. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// Operation - The operation name.
	Operation *string `json:"operation,omitempty"`
	// Status - Job status.
	Status *string `json:"status,omitempty"`
	// StartTime - The start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ActivityID - ActivityId of job.
	ActivityID *string `json:"activityId,omitempty"`
	// JobType - Possible values include: 'JobTypeJob', 'JobTypeAzureIaaSVMJob', 'JobTypeAzureStorageJob', 'JobTypeAzureWorkloadJob', 'JobTypeDpmJob', 'JobTypeMabJob'
	JobType JobType `json:"jobType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureStorageJob.
func (asj AzureStorageJob) MarshalJSON() ([]byte, error) {
	asj.JobType = JobTypeAzureStorageJob
	objectMap := make(map[string]interface{})
	if asj.Duration != nil {
		objectMap["duration"] = asj.Duration
	}
	if asj.ActionsInfo != nil {
		objectMap["actionsInfo"] = asj.ActionsInfo
	}
	if asj.ErrorDetails != nil {
		objectMap["errorDetails"] = asj.ErrorDetails
	}
	if asj.StorageAccountName != nil {
		objectMap["storageAccountName"] = asj.StorageAccountName
	}
	if asj.StorageAccountVersion != nil {
		objectMap["storageAccountVersion"] = asj.StorageAccountVersion
	}
	if asj.ExtendedInfo != nil {
		objectMap["extendedInfo"] = asj.ExtendedInfo
	}
	if asj.EntityFriendlyName != nil {
		objectMap["entityFriendlyName"] = asj.EntityFriendlyName
	}
	if asj.BackupManagementType != "" {
		objectMap["backupManagementType"] = asj.BackupManagementType
	}
	if asj.Operation != nil {
		objectMap["operation"] = asj.Operation
	}
	if asj.Status != nil {
		objectMap["status"] = asj.Status
	}
	if asj.StartTime != nil {
		objectMap["startTime"] = asj.StartTime
	}
	if asj.EndTime != nil {
		objectMap["endTime"] = asj.EndTime
	}
	if asj.ActivityID != nil {
		objectMap["activityId"] = asj.ActivityID
	}
	if asj.JobType != "" {
		objectMap["jobType"] = asj.JobType
	}
	return json.Marshal(objectMap)
}

// AsAzureIaaSVMJob is the BasicJob implementation for AzureStorageJob.
func (asj AzureStorageJob) AsAzureIaaSVMJob() (*AzureIaaSVMJob, bool) {
	return nil, false
}

// AsAzureStorageJob is the BasicJob implementation for AzureStorageJob.
func (asj AzureStorageJob) AsAzureStorageJob() (*AzureStorageJob, bool) {
	return &asj, true
}

// AsAzureWorkloadJob is the BasicJob implementation for AzureStorageJob.
func (asj AzureStorageJob) AsAzureWorkloadJob() (*AzureWorkloadJob, bool) {
	return nil, false
}

// AsDpmJob is the BasicJob implementation for AzureStorageJob.
func (asj AzureStorageJob) AsDpmJob() (*DpmJob, bool) {
	return nil, false
}

// AsMabJob is the BasicJob implementation for AzureStorageJob.
func (asj AzureStorageJob) AsMabJob() (*MabJob, bool) {
	return nil, false
}

// AsJob is the BasicJob implementation for AzureStorageJob.
func (asj AzureStorageJob) AsJob() (*Job, bool) {
	return nil, false
}

// AsBasicJob is the BasicJob implementation for AzureStorageJob.
func (asj AzureStorageJob) AsBasicJob() (BasicJob, bool) {
	return &asj, true
}

// AzureStorageJobExtendedInfo azure Storage workload-specific additional information for job.
type AzureStorageJobExtendedInfo struct {
	// TasksList - List of tasks for this job
	TasksList *[]AzureStorageJobTaskDetails `json:"tasksList,omitempty"`
	// PropertyBag - Job properties.
	PropertyBag map[string]*string `json:"propertyBag"`
	// DynamicErrorMessage - Non localized error message on job execution.
	DynamicErrorMessage *string `json:"dynamicErrorMessage,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureStorageJobExtendedInfo.
func (asjei AzureStorageJobExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asjei.TasksList != nil {
		objectMap["tasksList"] = asjei.TasksList
	}
	if asjei.PropertyBag != nil {
		objectMap["propertyBag"] = asjei.PropertyBag
	}
	if asjei.DynamicErrorMessage != nil {
		objectMap["dynamicErrorMessage"] = asjei.DynamicErrorMessage
	}
	return json.Marshal(objectMap)
}

// AzureStorageJobTaskDetails azure storage workload specific job task details.
type AzureStorageJobTaskDetails struct {
	// TaskID - The task display name.
	TaskID *string `json:"taskId,omitempty"`
	// Status - The status.
	Status *string `json:"status,omitempty"`
}

// AzureStorageProtectableContainer azure Storage-specific protectable containers
type AzureStorageProtectableContainer struct {
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerID - Fabric Id of the container such as ARM Id.
	ContainerID *string `json:"containerId,omitempty"`
	// ProtectableContainerType - Possible values include: 'ProtectableContainerTypeProtectableContainer', 'ProtectableContainerTypeStorageContainer', 'ProtectableContainerTypeVMAppContainer'
	ProtectableContainerType ProtectableContainerType `json:"protectableContainerType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureStorageProtectableContainer.
func (aspc AzureStorageProtectableContainer) MarshalJSON() ([]byte, error) {
	aspc.ProtectableContainerType = ProtectableContainerTypeStorageContainer
	objectMap := make(map[string]interface{})
	if aspc.FriendlyName != nil {
		objectMap["friendlyName"] = aspc.FriendlyName
	}
	if aspc.BackupManagementType != "" {
		objectMap["backupManagementType"] = aspc.BackupManagementType
	}
	if aspc.HealthStatus != nil {
		objectMap["healthStatus"] = aspc.HealthStatus
	}
	if aspc.ContainerID != nil {
		objectMap["containerId"] = aspc.ContainerID
	}
	if aspc.ProtectableContainerType != "" {
		objectMap["protectableContainerType"] = aspc.ProtectableContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureStorageProtectableContainer is the BasicProtectableContainer implementation for AzureStorageProtectableContainer.
func (aspc AzureStorageProtectableContainer) AsAzureStorageProtectableContainer() (*AzureStorageProtectableContainer, bool) {
	return &aspc, true
}

// AsAzureVMAppContainerProtectableContainer is the BasicProtectableContainer implementation for AzureStorageProtectableContainer.
func (aspc AzureStorageProtectableContainer) AsAzureVMAppContainerProtectableContainer() (*AzureVMAppContainerProtectableContainer, bool) {
	return nil, false
}

// AsProtectableContainer is the BasicProtectableContainer implementation for AzureStorageProtectableContainer.
func (aspc AzureStorageProtectableContainer) AsProtectableContainer() (*ProtectableContainer, bool) {
	return nil, false
}

// AsBasicProtectableContainer is the BasicProtectableContainer implementation for AzureStorageProtectableContainer.
func (aspc AzureStorageProtectableContainer) AsBasicProtectableContainer() (BasicProtectableContainer, bool) {
	return &aspc, true
}

// AzureVMAppContainerProtectableContainer azure workload-specific container
type AzureVMAppContainerProtectableContainer struct {
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerID - Fabric Id of the container such as ARM Id.
	ContainerID *string `json:"containerId,omitempty"`
	// ProtectableContainerType - Possible values include: 'ProtectableContainerTypeProtectableContainer', 'ProtectableContainerTypeStorageContainer', 'ProtectableContainerTypeVMAppContainer'
	ProtectableContainerType ProtectableContainerType `json:"protectableContainerType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMAppContainerProtectableContainer.
func (avacpc AzureVMAppContainerProtectableContainer) MarshalJSON() ([]byte, error) {
	avacpc.ProtectableContainerType = ProtectableContainerTypeVMAppContainer
	objectMap := make(map[string]interface{})
	if avacpc.FriendlyName != nil {
		objectMap["friendlyName"] = avacpc.FriendlyName
	}
	if avacpc.BackupManagementType != "" {
		objectMap["backupManagementType"] = avacpc.BackupManagementType
	}
	if avacpc.HealthStatus != nil {
		objectMap["healthStatus"] = avacpc.HealthStatus
	}
	if avacpc.ContainerID != nil {
		objectMap["containerId"] = avacpc.ContainerID
	}
	if avacpc.ProtectableContainerType != "" {
		objectMap["protectableContainerType"] = avacpc.ProtectableContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureStorageProtectableContainer is the BasicProtectableContainer implementation for AzureVMAppContainerProtectableContainer.
func (avacpc AzureVMAppContainerProtectableContainer) AsAzureStorageProtectableContainer() (*AzureStorageProtectableContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectableContainer is the BasicProtectableContainer implementation for AzureVMAppContainerProtectableContainer.
func (avacpc AzureVMAppContainerProtectableContainer) AsAzureVMAppContainerProtectableContainer() (*AzureVMAppContainerProtectableContainer, bool) {
	return &avacpc, true
}

// AsProtectableContainer is the BasicProtectableContainer implementation for AzureVMAppContainerProtectableContainer.
func (avacpc AzureVMAppContainerProtectableContainer) AsProtectableContainer() (*ProtectableContainer, bool) {
	return nil, false
}

// AsBasicProtectableContainer is the BasicProtectableContainer implementation for AzureVMAppContainerProtectableContainer.
func (avacpc AzureVMAppContainerProtectableContainer) AsBasicProtectableContainer() (BasicProtectableContainer, bool) {
	return &avacpc, true
}

// AzureVMAppContainerProtectionContainer container for SQL workloads under Azure Virtual Machines.
type AzureVMAppContainerProtectionContainer struct {
	// SourceResourceID - ARM ID of the virtual machine represented by this Azure Workload Container
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// LastUpdatedTime - Time stamp when this container was updated.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
	// ExtendedInfo - Additional details of a workload container.
	ExtendedInfo *AzureWorkloadContainerExtendedInfo `json:"extendedInfo,omitempty"`
	// WorkloadType - Workload type for which registration was sent. Possible values include: 'WorkloadTypeInvalid', 'WorkloadTypeVM', 'WorkloadTypeFileFolder', 'WorkloadTypeAzureSQLDb', 'WorkloadTypeSQLDB', 'WorkloadTypeExchange', 'WorkloadTypeSharepoint', 'WorkloadTypeVMwareVM', 'WorkloadTypeSystemState', 'WorkloadTypeClient', 'WorkloadTypeGenericDataSource', 'WorkloadTypeSQLDataBase', 'WorkloadTypeAzureFileShare', 'WorkloadTypeSAPHanaDatabase', 'WorkloadTypeSAPAseDatabase'
	WorkloadType WorkloadType `json:"workloadType,omitempty"`
	// OperationType - Re-Do Operation. Possible values include: 'OperationTypeInvalid', 'OperationTypeRegister', 'OperationTypeReregister'
	OperationType OperationType `json:"operationType,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) MarshalJSON() ([]byte, error) {
	avacpc.ContainerType = ContainerTypeVMAppContainer1
	objectMap := make(map[string]interface{})
	if avacpc.SourceResourceID != nil {
		objectMap["sourceResourceId"] = avacpc.SourceResourceID
	}
	if avacpc.LastUpdatedTime != nil {
		objectMap["lastUpdatedTime"] = avacpc.LastUpdatedTime
	}
	if avacpc.ExtendedInfo != nil {
		objectMap["extendedInfo"] = avacpc.ExtendedInfo
	}
	if avacpc.WorkloadType != "" {
		objectMap["workloadType"] = avacpc.WorkloadType
	}
	if avacpc.OperationType != "" {
		objectMap["operationType"] = avacpc.OperationType
	}
	if avacpc.FriendlyName != nil {
		objectMap["friendlyName"] = avacpc.FriendlyName
	}
	if avacpc.BackupManagementType != "" {
		objectMap["backupManagementType"] = avacpc.BackupManagementType
	}
	if avacpc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = avacpc.RegistrationStatus
	}
	if avacpc.HealthStatus != nil {
		objectMap["healthStatus"] = avacpc.HealthStatus
	}
	if avacpc.ContainerType != "" {
		objectMap["containerType"] = avacpc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return &avacpc, true
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return nil, false
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return &avacpc, true
}

// AsDpmContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsDpmContainer() (*DpmContainer, bool) {
	return nil, false
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return nil, false
}

// AsGenericContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsGenericContainer() (*GenericContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return nil, false
}

// AsMabContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for AzureVMAppContainerProtectionContainer.
func (avacpc AzureVMAppContainerProtectionContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &avacpc, true
}

// AzureVMResourceFeatureSupportRequest azureResource(IaaS VM) Specific feature support request
type AzureVMResourceFeatureSupportRequest struct {
	// VMSize - Size of the resource: VM size(A/D series etc) in case of IaasVM
	VMSize *string `json:"vmSize,omitempty"`
	// VMSku - SKUs (Premium/Managed etc) in case of IaasVM
	VMSku *string `json:"vmSku,omitempty"`
	// FeatureType - Possible values include: 'FeatureTypeFeatureSupportRequest', 'FeatureTypeAzureBackupGoals', 'FeatureTypeAzureVMResourceBackup'
	FeatureType FeatureType `json:"featureType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMResourceFeatureSupportRequest.
func (avrfsr AzureVMResourceFeatureSupportRequest) MarshalJSON() ([]byte, error) {
	avrfsr.FeatureType = FeatureTypeAzureVMResourceBackup
	objectMap := make(map[string]interface{})
	if avrfsr.VMSize != nil {
		objectMap["vmSize"] = avrfsr.VMSize
	}
	if avrfsr.VMSku != nil {
		objectMap["vmSku"] = avrfsr.VMSku
	}
	if avrfsr.FeatureType != "" {
		objectMap["featureType"] = avrfsr.FeatureType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupGoalFeatureSupportRequest is the BasicFeatureSupportRequest implementation for AzureVMResourceFeatureSupportRequest.
func (avrfsr AzureVMResourceFeatureSupportRequest) AsAzureBackupGoalFeatureSupportRequest() (*AzureBackupGoalFeatureSupportRequest, bool) {
	return nil, false
}

// AsAzureVMResourceFeatureSupportRequest is the BasicFeatureSupportRequest implementation for AzureVMResourceFeatureSupportRequest.
func (avrfsr AzureVMResourceFeatureSupportRequest) AsAzureVMResourceFeatureSupportRequest() (*AzureVMResourceFeatureSupportRequest, bool) {
	return &avrfsr, true
}

// AsFeatureSupportRequest is the BasicFeatureSupportRequest implementation for AzureVMResourceFeatureSupportRequest.
func (avrfsr AzureVMResourceFeatureSupportRequest) AsFeatureSupportRequest() (*FeatureSupportRequest, bool) {
	return nil, false
}

// AsBasicFeatureSupportRequest is the BasicFeatureSupportRequest implementation for AzureVMResourceFeatureSupportRequest.
func (avrfsr AzureVMResourceFeatureSupportRequest) AsBasicFeatureSupportRequest() (BasicFeatureSupportRequest, bool) {
	return &avrfsr, true
}

// AzureVMResourceFeatureSupportResponse response for feature support requests for Azure IaasVm
type AzureVMResourceFeatureSupportResponse struct {
	autorest.Response `json:"-"`
	// SupportStatus - Support status of feature. Possible values include: 'SupportStatusInvalid', 'SupportStatusSupported', 'SupportStatusDefaultOFF', 'SupportStatusDefaultON', 'SupportStatusNotSupported'
	SupportStatus SupportStatus `json:"supportStatus,omitempty"`
}

// BasicAzureVMWorkloadItem azure VM workload-specific workload item.
type BasicAzureVMWorkloadItem interface {
	AsAzureVMWorkloadSAPAseDatabaseWorkloadItem() (*AzureVMWorkloadSAPAseDatabaseWorkloadItem, bool)
	AsAzureVMWorkloadSAPAseSystemWorkloadItem() (*AzureVMWorkloadSAPAseSystemWorkloadItem, bool)
	AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem() (*AzureVMWorkloadSAPHanaDatabaseWorkloadItem, bool)
	AsAzureVMWorkloadSAPHanaSystemWorkloadItem() (*AzureVMWorkloadSAPHanaSystemWorkloadItem, bool)
	AsAzureVMWorkloadSQLDatabaseWorkloadItem() (*AzureVMWorkloadSQLDatabaseWorkloadItem, bool)
	AsAzureVMWorkloadSQLInstanceWorkloadItem() (*AzureVMWorkloadSQLInstanceWorkloadItem, bool)
	AsAzureVMWorkloadItem() (*AzureVMWorkloadItem, bool)
}

// AzureVMWorkloadItem azure VM workload-specific workload item.
type AzureVMWorkloadItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if workload item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// SubWorkloadItemCount - For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32 `json:"subWorkloadItemCount,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// WorkloadItemType - Possible values include: 'WorkloadItemTypeWorkloadItem', 'WorkloadItemTypeAzureVMWorkloadItem', 'WorkloadItemTypeSAPAseDatabase1', 'WorkloadItemTypeSAPAseSystem1', 'WorkloadItemTypeSAPHanaDatabase1', 'WorkloadItemTypeSAPHanaSystem1', 'WorkloadItemTypeSQLDataBase1', 'WorkloadItemTypeSQLInstance1'
	WorkloadItemType WorkloadItemTypeBasicWorkloadItem `json:"workloadItemType,omitempty"`
}

func unmarshalBasicAzureVMWorkloadItem(body []byte) (BasicAzureVMWorkloadItem, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["workloadItemType"] {
	case string(WorkloadItemTypeSAPAseDatabase1):
		var avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem
		err := json.Unmarshal(body, &avwsadwi)
		return avwsadwi, err
	case string(WorkloadItemTypeSAPAseSystem1):
		var avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem
		err := json.Unmarshal(body, &avwsaswi)
		return avwsaswi, err
	case string(WorkloadItemTypeSAPHanaDatabase1):
		var avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem
		err := json.Unmarshal(body, &avwshdwi)
		return avwshdwi, err
	case string(WorkloadItemTypeSAPHanaSystem1):
		var avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem
		err := json.Unmarshal(body, &avwshswi)
		return avwshswi, err
	case string(WorkloadItemTypeSQLDataBase1):
		var avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem
		err := json.Unmarshal(body, &avwsdwi)
		return avwsdwi, err
	case string(WorkloadItemTypeSQLInstance1):
		var avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem
		err := json.Unmarshal(body, &avwsiwi)
		return avwsiwi, err
	default:
		var avwi AzureVMWorkloadItem
		err := json.Unmarshal(body, &avwi)
		return avwi, err
	}
}
func unmarshalBasicAzureVMWorkloadItemArray(body []byte) ([]BasicAzureVMWorkloadItem, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	avwiArray := make([]BasicAzureVMWorkloadItem, len(rawMessages))

	for index, rawMessage := range rawMessages {
		avwi, err := unmarshalBasicAzureVMWorkloadItem(*rawMessage)
		if err != nil {
			return nil, err
		}
		avwiArray[index] = avwi
	}
	return avwiArray, nil
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadItem.
func (avwi AzureVMWorkloadItem) MarshalJSON() ([]byte, error) {
	avwi.WorkloadItemType = WorkloadItemTypeAzureVMWorkloadItem
	objectMap := make(map[string]interface{})
	if avwi.ParentName != nil {
		objectMap["parentName"] = avwi.ParentName
	}
	if avwi.ServerName != nil {
		objectMap["serverName"] = avwi.ServerName
	}
	if avwi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwi.IsAutoProtectable
	}
	if avwi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwi.Subinquireditemcount
	}
	if avwi.SubWorkloadItemCount != nil {
		objectMap["subWorkloadItemCount"] = avwi.SubWorkloadItemCount
	}
	if avwi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwi.BackupManagementType
	}
	if avwi.WorkloadType != nil {
		objectMap["workloadType"] = avwi.WorkloadType
	}
	if avwi.FriendlyName != nil {
		objectMap["friendlyName"] = avwi.FriendlyName
	}
	if avwi.ProtectionState != "" {
		objectMap["protectionState"] = avwi.ProtectionState
	}
	if avwi.WorkloadItemType != "" {
		objectMap["workloadItemType"] = avwi.WorkloadItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadItem.
func (avwi AzureVMWorkloadItem) AsAzureVMWorkloadItem() (*AzureVMWorkloadItem, bool) {
	return &avwi, true
}

// AsBasicAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadItem.
func (avwi AzureVMWorkloadItem) AsBasicAzureVMWorkloadItem() (BasicAzureVMWorkloadItem, bool) {
	return &avwi, true
}

// AsAzureVMWorkloadSAPAseDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadItem.
func (avwi AzureVMWorkloadItem) AsAzureVMWorkloadSAPAseDatabaseWorkloadItem() (*AzureVMWorkloadSAPAseDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadItem.
func (avwi AzureVMWorkloadItem) AsAzureVMWorkloadSAPAseSystemWorkloadItem() (*AzureVMWorkloadSAPAseSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadItem.
func (avwi AzureVMWorkloadItem) AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem() (*AzureVMWorkloadSAPHanaDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadItem.
func (avwi AzureVMWorkloadItem) AsAzureVMWorkloadSAPHanaSystemWorkloadItem() (*AzureVMWorkloadSAPHanaSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadItem.
func (avwi AzureVMWorkloadItem) AsAzureVMWorkloadSQLDatabaseWorkloadItem() (*AzureVMWorkloadSQLDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadItem.
func (avwi AzureVMWorkloadItem) AsAzureVMWorkloadSQLInstanceWorkloadItem() (*AzureVMWorkloadSQLInstanceWorkloadItem, bool) {
	return nil, false
}

// AsWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadItem.
func (avwi AzureVMWorkloadItem) AsWorkloadItem() (*WorkloadItem, bool) {
	return nil, false
}

// AsBasicWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadItem.
func (avwi AzureVMWorkloadItem) AsBasicWorkloadItem() (BasicWorkloadItem, bool) {
	return &avwi, true
}

// BasicAzureVMWorkloadProtectableItem azure VM workload-specific protectable item.
type BasicAzureVMWorkloadProtectableItem interface {
	AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool)
	AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool)
	AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool)
	AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool)
	AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool)
	AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool)
	AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool)
}

// AzureVMWorkloadProtectableItem azure VM workload-specific protectable item.
type AzureVMWorkloadProtectableItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ParentUniqueName - Parent Unique Name is added to provide the service formatted URI Name of the Parent
	// Only Applicable for data bases where the parent would be either Instance or a SQL AG.
	ParentUniqueName *string `json:"parentUniqueName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// IsAutoProtected - Indicates if protectable item is auto-protected
	IsAutoProtected *bool `json:"isAutoProtected,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// Subprotectableitemcount - For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32 `json:"subprotectableitemcount,omitempty"`
	// Prebackupvalidation - Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation `json:"prebackupvalidation,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeAzureFileShare', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeAzureVMWorkloadProtectableItem', 'ProtectableItemTypeSAPAseSystem', 'ProtectableItemTypeSAPHanaDatabase', 'ProtectableItemTypeSAPHanaSystem', 'ProtectableItemTypeSQLAvailabilityGroupContainer', 'ProtectableItemTypeSQLDataBase', 'ProtectableItemTypeSQLInstance', 'ProtectableItemTypeIaaSVMProtectableItem'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

func unmarshalBasicAzureVMWorkloadProtectableItem(body []byte) (BasicAzureVMWorkloadProtectableItem, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["protectableItemType"] {
	case string(ProtectableItemTypeSAPAseSystem):
		var avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem
		err := json.Unmarshal(body, &avwsaspi)
		return avwsaspi, err
	case string(ProtectableItemTypeSAPHanaDatabase):
		var avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem
		err := json.Unmarshal(body, &avwshdpi)
		return avwshdpi, err
	case string(ProtectableItemTypeSAPHanaSystem):
		var avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem
		err := json.Unmarshal(body, &avwshspi)
		return avwshspi, err
	case string(ProtectableItemTypeSQLAvailabilityGroupContainer):
		var avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem
		err := json.Unmarshal(body, &avwsagpi)
		return avwsagpi, err
	case string(ProtectableItemTypeSQLDataBase):
		var avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem
		err := json.Unmarshal(body, &avwsdpi)
		return avwsdpi, err
	case string(ProtectableItemTypeSQLInstance):
		var avwsipi AzureVMWorkloadSQLInstanceProtectableItem
		err := json.Unmarshal(body, &avwsipi)
		return avwsipi, err
	default:
		var avwpi AzureVMWorkloadProtectableItem
		err := json.Unmarshal(body, &avwpi)
		return avwpi, err
	}
}
func unmarshalBasicAzureVMWorkloadProtectableItemArray(body []byte) ([]BasicAzureVMWorkloadProtectableItem, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	avwpiArray := make([]BasicAzureVMWorkloadProtectableItem, len(rawMessages))

	for index, rawMessage := range rawMessages {
		avwpi, err := unmarshalBasicAzureVMWorkloadProtectableItem(*rawMessage)
		if err != nil {
			return nil, err
		}
		avwpiArray[index] = avwpi
	}
	return avwpiArray, nil
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) MarshalJSON() ([]byte, error) {
	avwpi.ProtectableItemType = ProtectableItemTypeAzureVMWorkloadProtectableItem
	objectMap := make(map[string]interface{})
	if avwpi.ParentName != nil {
		objectMap["parentName"] = avwpi.ParentName
	}
	if avwpi.ParentUniqueName != nil {
		objectMap["parentUniqueName"] = avwpi.ParentUniqueName
	}
	if avwpi.ServerName != nil {
		objectMap["serverName"] = avwpi.ServerName
	}
	if avwpi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwpi.IsAutoProtectable
	}
	if avwpi.IsAutoProtected != nil {
		objectMap["isAutoProtected"] = avwpi.IsAutoProtected
	}
	if avwpi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwpi.Subinquireditemcount
	}
	if avwpi.Subprotectableitemcount != nil {
		objectMap["subprotectableitemcount"] = avwpi.Subprotectableitemcount
	}
	if avwpi.Prebackupvalidation != nil {
		objectMap["prebackupvalidation"] = avwpi.Prebackupvalidation
	}
	if avwpi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwpi.BackupManagementType
	}
	if avwpi.WorkloadType != nil {
		objectMap["workloadType"] = avwpi.WorkloadType
	}
	if avwpi.FriendlyName != nil {
		objectMap["friendlyName"] = avwpi.FriendlyName
	}
	if avwpi.ProtectionState != "" {
		objectMap["protectionState"] = avwpi.ProtectionState
	}
	if avwpi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = avwpi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool) {
	return &avwpi, true
}

// AsBasicAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool) {
	return &avwpi, true
}

// AsAzureVMWorkloadSAPAseSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool) {
	return nil, false
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return nil, false
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return nil, false
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadProtectableItem.
func (avwpi AzureVMWorkloadProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &avwpi, true
}

// BasicAzureVMWorkloadProtectedItem azure VM workload-specific protected item.
type BasicAzureVMWorkloadProtectedItem interface {
	AsAzureVMWorkloadSAPAseDatabaseProtectedItem() (*AzureVMWorkloadSAPAseDatabaseProtectedItem, bool)
	AsAzureVMWorkloadSAPHanaDatabaseProtectedItem() (*AzureVMWorkloadSAPHanaDatabaseProtectedItem, bool)
	AsAzureVMWorkloadSQLDatabaseProtectedItem() (*AzureVMWorkloadSQLDatabaseProtectedItem, bool)
	AsAzureVMWorkloadProtectedItem() (*AzureVMWorkloadProtectedItem, bool)
}

// AzureVMWorkloadProtectedItem azure VM workload-specific protected item.
type AzureVMWorkloadProtectedItem struct {
	// FriendlyName - Friendly name of the DB represented by this backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// ParentName - Parent name of the DB such as Instance or Availability Group.
	ParentName *string `json:"parentName,omitempty"`
	// ParentType - Parent type of protected item, example: for a DB, standalone server or distributed
	ParentType *string `json:"parentType,omitempty"`
	// ProtectionStatus - Backup status of this backup item.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`
	// ProtectionState - Backup state of this backup item. Possible values include: 'ProtectionStateInvalid', 'ProtectionStateIRPending', 'ProtectionStateProtected', 'ProtectionStateProtectionError', 'ProtectionStateProtectionStopped', 'ProtectionStateProtectionPaused'
	ProtectionState ProtectionState `json:"protectionState,omitempty"`
	// LastBackupStatus - Last backup operation status. Possible values: Healthy, Unhealthy. Possible values include: 'LastBackupStatusInvalid', 'LastBackupStatusHealthy', 'LastBackupStatusUnhealthy', 'LastBackupStatusIRPending'
	LastBackupStatus LastBackupStatus `json:"lastBackupStatus,omitempty"`
	// LastBackupTime - Timestamp of the last backup operation on this backup item.
	LastBackupTime *date.Time `json:"lastBackupTime,omitempty"`
	// LastBackupErrorDetail - Error details in last backup
	LastBackupErrorDetail *ErrorDetail `json:"lastBackupErrorDetail,omitempty"`
	// ProtectedItemDataSourceID - Data ID of the protected item.
	ProtectedItemDataSourceID *string `json:"protectedItemDataSourceId,omitempty"`
	// ProtectedItemHealthStatus - Health status of the backup item, evaluated based on last heartbeat received. Possible values include: 'ProtectedItemHealthStatusInvalid', 'ProtectedItemHealthStatusHealthy', 'ProtectedItemHealthStatusUnhealthy', 'ProtectedItemHealthStatusNotReachable', 'ProtectedItemHealthStatusIRPending'
	ProtectedItemHealthStatus ProtectedItemHealthStatus `json:"protectedItemHealthStatus,omitempty"`
	// ExtendedInfo - Additional information for this backup item.
	ExtendedInfo *AzureVMWorkloadProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`
	// BackupManagementType - Type of backup management for the backed up item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload this item represents. Possible values include: 'DataSourceTypeInvalid', 'DataSourceTypeVM', 'DataSourceTypeFileFolder', 'DataSourceTypeAzureSQLDb', 'DataSourceTypeSQLDB', 'DataSourceTypeExchange', 'DataSourceTypeSharepoint', 'DataSourceTypeVMwareVM', 'DataSourceTypeSystemState', 'DataSourceTypeClient', 'DataSourceTypeGenericDataSource', 'DataSourceTypeSQLDataBase', 'DataSourceTypeAzureFileShare', 'DataSourceTypeSAPHanaDatabase', 'DataSourceTypeSAPAseDatabase'
	WorkloadType DataSourceType `json:"workloadType,omitempty"`
	// ContainerName - Unique name of container
	ContainerName *string `json:"containerName,omitempty"`
	// SourceResourceID - ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// PolicyID - ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`
	// LastRecoveryPoint - Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *date.Time `json:"lastRecoveryPoint,omitempty"`
	// BackupSetName - Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`
	// CreateMode - Create mode to indicate recovery of existing soft deleted data source or creation of new data source. Possible values include: 'CreateModeInvalid', 'CreateModeDefault', 'CreateModeRecover'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// DeferredDeleteTimeInUTC - Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *date.Time `json:"deferredDeleteTimeInUTC,omitempty"`
	// IsScheduledForDeferredDelete - Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`
	// DeferredDeleteTimeRemaining - Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`
	// IsDeferredDeleteScheduleUpcoming - Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`
	// IsRehydrate - Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`
	// ProtectedItemType - Possible values include: 'ProtectedItemTypeProtectedItem', 'ProtectedItemTypeAzureFileShareProtectedItem', 'ProtectedItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectedItemTypeMicrosoftComputevirtualMachines', 'ProtectedItemTypeAzureIaaSVMProtectedItem', 'ProtectedItemTypeMicrosoftSqlserversdatabases', 'ProtectedItemTypeAzureVMWorkloadProtectedItem', 'ProtectedItemTypeAzureVMWorkloadSAPAseDatabase', 'ProtectedItemTypeAzureVMWorkloadSAPHanaDatabase', 'ProtectedItemTypeAzureVMWorkloadSQLDatabase', 'ProtectedItemTypeDPMProtectedItem', 'ProtectedItemTypeGenericProtectedItem', 'ProtectedItemTypeMabFileFolderProtectedItem'
	ProtectedItemType ProtectedItemType `json:"protectedItemType,omitempty"`
}

func unmarshalBasicAzureVMWorkloadProtectedItem(body []byte) (BasicAzureVMWorkloadProtectedItem, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["protectedItemType"] {
	case string(ProtectedItemTypeAzureVMWorkloadSAPAseDatabase):
		var avwsadpi AzureVMWorkloadSAPAseDatabaseProtectedItem
		err := json.Unmarshal(body, &avwsadpi)
		return avwsadpi, err
	case string(ProtectedItemTypeAzureVMWorkloadSAPHanaDatabase):
		var avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectedItem
		err := json.Unmarshal(body, &avwshdpi)
		return avwshdpi, err
	case string(ProtectedItemTypeAzureVMWorkloadSQLDatabase):
		var avwsdpi AzureVMWorkloadSQLDatabaseProtectedItem
		err := json.Unmarshal(body, &avwsdpi)
		return avwsdpi, err
	default:
		var avwpi AzureVMWorkloadProtectedItem
		err := json.Unmarshal(body, &avwpi)
		return avwpi, err
	}
}
func unmarshalBasicAzureVMWorkloadProtectedItemArray(body []byte) ([]BasicAzureVMWorkloadProtectedItem, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	avwpiArray := make([]BasicAzureVMWorkloadProtectedItem, len(rawMessages))

	for index, rawMessage := range rawMessages {
		avwpi, err := unmarshalBasicAzureVMWorkloadProtectedItem(*rawMessage)
		if err != nil {
			return nil, err
		}
		avwpiArray[index] = avwpi
	}
	return avwpiArray, nil
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadProtectedItem.
func (avwpi AzureVMWorkloadProtectedItem) MarshalJSON() ([]byte, error) {
	avwpi.ProtectedItemType = ProtectedItemTypeAzureVMWorkloadProtectedItem
	objectMap := make(map[string]interface{})
	if avwpi.FriendlyName != nil {
		objectMap["friendlyName"] = avwpi.FriendlyName
	}
	if avwpi.ServerName != nil {
		objectMap["serverName"] = avwpi.ServerName
	}
	if avwpi.ParentName != nil {
		objectMap["parentName"] = avwpi.ParentName
	}
	if avwpi.ParentType != nil {
		objectMap["parentType"] = avwpi.ParentType
	}
	if avwpi.ProtectionStatus != nil {
		objectMap["protectionStatus"] = avwpi.ProtectionStatus
	}
	if avwpi.ProtectionState != "" {
		objectMap["protectionState"] = avwpi.ProtectionState
	}
	if avwpi.LastBackupStatus != "" {
		objectMap["lastBackupStatus"] = avwpi.LastBackupStatus
	}
	if avwpi.LastBackupTime != nil {
		objectMap["lastBackupTime"] = avwpi.LastBackupTime
	}
	if avwpi.LastBackupErrorDetail != nil {
		objectMap["lastBackupErrorDetail"] = avwpi.LastBackupErrorDetail
	}
	if avwpi.ProtectedItemDataSourceID != nil {
		objectMap["protectedItemDataSourceId"] = avwpi.ProtectedItemDataSourceID
	}
	if avwpi.ProtectedItemHealthStatus != "" {
		objectMap["protectedItemHealthStatus"] = avwpi.ProtectedItemHealthStatus
	}
	if avwpi.ExtendedInfo != nil {
		objectMap["extendedInfo"] = avwpi.ExtendedInfo
	}
	if avwpi.BackupManagementType != "" {
		objectMap["backupManagementType"] = avwpi.BackupManagementType
	}
	if avwpi.WorkloadType != "" {
		objectMap["workloadType"] = avwpi.WorkloadType
	}
	if avwpi.ContainerName != nil {
		objectMap["containerName"] = avwpi.ContainerName
	}
	if avwpi.SourceResourceID != nil {
		objectMap["sourceResourceId"] = avwpi.SourceResourceID
	}
	if avwpi.PolicyID != nil {
		objectMap["policyId"] = avwpi.PolicyID
	}
	if avwpi.LastRecoveryPoint != nil {
		objectMap["lastRecoveryPoint"] = avwpi.LastRecoveryPoint
	}
	if avwpi.BackupSetName != nil {
		objectMap["backupSetName"] = avwpi.BackupSetName
	}
	if avwpi.CreateMode != "" {
		objectMap["createMode"] = avwpi.CreateMode
	}
	if avwpi.DeferredDeleteTimeInUTC != nil {
		objectMap["deferredDeleteTimeInUTC"] = avwpi.DeferredDeleteTimeInUTC
	}
	if avwpi.IsScheduledForDeferredDelete != nil {
		objectMap["isScheduledForDeferredDelete"] = avwpi.IsScheduledForDeferredDelete
	}
	if avwpi.DeferredDeleteTimeRemaining != nil {
		objectMap["deferredDeleteTimeRemaining"] = avwpi.DeferredDeleteTimeRemaining
	}
	if avwpi.IsDeferredDeleteScheduleUpcoming != nil {
		objectMap["isDeferredDeleteScheduleUpcoming"] = avwpi.IsDeferredDeleteScheduleUpcoming
	}
	if avwpi.IsRehydrate != nil {
		objectMap["isRehydrate"] = avwpi.IsRehydrate
	}
	if avwpi.ProtectedItemType != "" {
		objectMap["protectedItemType"] = avwpi.ProtectedItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileshareProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadProtectedItem.
func (avwpi AzureVMWorkloadProtectedItem) AsAzureFileshareProtectedItem() (*AzureFileshareProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadProtectedItem.
func (avwpi AzureVMWorkloadProtectedItem) AsAzureIaaSClassicComputeVMProtectedItem() (*AzureIaaSClassicComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadProtectedItem.
func (avwpi AzureVMWorkloadProtectedItem) AsAzureIaaSComputeVMProtectedItem() (*AzureIaaSComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadProtectedItem.
func (avwpi AzureVMWorkloadProtectedItem) AsAzureIaaSVMProtectedItem() (*AzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadProtectedItem.
func (avwpi AzureVMWorkloadProtectedItem) AsBasicAzureIaaSVMProtectedItem() (BasicAzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsAzureSQLProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadProtectedItem.
func (avwpi AzureVMWorkloadProtectedItem) AsAzureSQLProtectedItem() (*AzureSQLProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadProtectedItem.
func (avwpi AzureVMWorkloadProtectedItem) AsAzureVMWorkloadProtectedItem() (*AzureVMWorkloadProtectedItem, bool) {
	return &avwpi, true
}

// AsBasicAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadProtectedItem.
func (avwpi AzureVMWorkloadProtectedItem) AsBasicAzureVMWorkloadProtectedItem() (BasicAzureVMWorkloadProtectedItem, bool) {
	return &avwpi, true
}

// AsAzureVMWorkloadSAPAseDatabaseProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadProtectedItem.
func (avwpi AzureVMWorkloadProtectedItem) AsAzureVMWorkloadSAPAseDatabaseProtectedItem() (*AzureVMWorkloadSAPAseDatabaseProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadProtectedItem.
func (avwpi AzureVMWorkloadProtectedItem) AsAzureVMWorkloadSAPHanaDatabaseProtectedItem() (*AzureVMWorkloadSAPHanaDatabaseProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadProtectedItem.
func (avwpi AzureVMWorkloadProtectedItem) AsAzureVMWorkloadSQLDatabaseProtectedItem() (*AzureVMWorkloadSQLDatabaseProtectedItem, bool) {
	return nil, false
}

// AsDPMProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadProtectedItem.
func (avwpi AzureVMWorkloadProtectedItem) AsDPMProtectedItem() (*DPMProtectedItem, bool) {
	return nil, false
}

// AsGenericProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadProtectedItem.
func (avwpi AzureVMWorkloadProtectedItem) AsGenericProtectedItem() (*GenericProtectedItem, bool) {
	return nil, false
}

// AsMabFileFolderProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadProtectedItem.
func (avwpi AzureVMWorkloadProtectedItem) AsMabFileFolderProtectedItem() (*MabFileFolderProtectedItem, bool) {
	return nil, false
}

// AsProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadProtectedItem.
func (avwpi AzureVMWorkloadProtectedItem) AsProtectedItem() (*ProtectedItem, bool) {
	return nil, false
}

// AsBasicProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadProtectedItem.
func (avwpi AzureVMWorkloadProtectedItem) AsBasicProtectedItem() (BasicProtectedItem, bool) {
	return &avwpi, true
}

// AzureVMWorkloadProtectedItemExtendedInfo additional information on Azure Workload for SQL specific
// backup item.
type AzureVMWorkloadProtectedItemExtendedInfo struct {
	// OldestRecoveryPoint - The oldest backup copy available for this backup item.
	OldestRecoveryPoint *date.Time `json:"oldestRecoveryPoint,omitempty"`
	// RecoveryPointCount - Number of backup copies available for this backup item.
	RecoveryPointCount *int32 `json:"recoveryPointCount,omitempty"`
	// PolicyState - Indicates consistency of policy object and policy applied to this backup item.
	PolicyState *string `json:"policyState,omitempty"`
}

// AzureVMWorkloadProtectionPolicy azure VM (Mercury) workload-specific backup policy.
type AzureVMWorkloadProtectionPolicy struct {
	// WorkLoadType - Type of workload for the backup management. Possible values include: 'WorkloadTypeInvalid', 'WorkloadTypeVM', 'WorkloadTypeFileFolder', 'WorkloadTypeAzureSQLDb', 'WorkloadTypeSQLDB', 'WorkloadTypeExchange', 'WorkloadTypeSharepoint', 'WorkloadTypeVMwareVM', 'WorkloadTypeSystemState', 'WorkloadTypeClient', 'WorkloadTypeGenericDataSource', 'WorkloadTypeSQLDataBase', 'WorkloadTypeAzureFileShare', 'WorkloadTypeSAPHanaDatabase', 'WorkloadTypeSAPAseDatabase'
	WorkLoadType WorkloadType `json:"workLoadType,omitempty"`
	// Settings - Common settings for the backup management
	Settings *Settings `json:"settings,omitempty"`
	// SubProtectionPolicy - List of sub-protection policies which includes schedule and retention
	SubProtectionPolicy *[]SubProtectionPolicy `json:"subProtectionPolicy,omitempty"`
	// MakePolicyConsistent - Fix the policy inconsistency
	MakePolicyConsistent *bool `json:"makePolicyConsistent,omitempty"`
	// ProtectedItemsCount - Number of items associated with this policy.
	ProtectedItemsCount *int32 `json:"protectedItemsCount,omitempty"`
	// BackupManagementType - Possible values include: 'BackupManagementTypeProtectionPolicy', 'BackupManagementTypeAzureWorkload', 'BackupManagementTypeAzureStorage', 'BackupManagementTypeAzureIaasVM', 'BackupManagementTypeAzureSQL', 'BackupManagementTypeGenericProtectionPolicy', 'BackupManagementTypeMAB'
	BackupManagementType ManagementTypeBasicProtectionPolicy `json:"backupManagementType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadProtectionPolicy.
func (avwpp AzureVMWorkloadProtectionPolicy) MarshalJSON() ([]byte, error) {
	avwpp.BackupManagementType = BackupManagementTypeAzureWorkload
	objectMap := make(map[string]interface{})
	if avwpp.WorkLoadType != "" {
		objectMap["workLoadType"] = avwpp.WorkLoadType
	}
	if avwpp.Settings != nil {
		objectMap["settings"] = avwpp.Settings
	}
	if avwpp.SubProtectionPolicy != nil {
		objectMap["subProtectionPolicy"] = avwpp.SubProtectionPolicy
	}
	if avwpp.MakePolicyConsistent != nil {
		objectMap["makePolicyConsistent"] = avwpp.MakePolicyConsistent
	}
	if avwpp.ProtectedItemsCount != nil {
		objectMap["protectedItemsCount"] = avwpp.ProtectedItemsCount
	}
	if avwpp.BackupManagementType != "" {
		objectMap["backupManagementType"] = avwpp.BackupManagementType
	}
	return json.Marshal(objectMap)
}

// AsAzureVMWorkloadProtectionPolicy is the BasicProtectionPolicy implementation for AzureVMWorkloadProtectionPolicy.
func (avwpp AzureVMWorkloadProtectionPolicy) AsAzureVMWorkloadProtectionPolicy() (*AzureVMWorkloadProtectionPolicy, bool) {
	return &avwpp, true
}

// AsAzureFileShareProtectionPolicy is the BasicProtectionPolicy implementation for AzureVMWorkloadProtectionPolicy.
func (avwpp AzureVMWorkloadProtectionPolicy) AsAzureFileShareProtectionPolicy() (*AzureFileShareProtectionPolicy, bool) {
	return nil, false
}

// AsAzureIaaSVMProtectionPolicy is the BasicProtectionPolicy implementation for AzureVMWorkloadProtectionPolicy.
func (avwpp AzureVMWorkloadProtectionPolicy) AsAzureIaaSVMProtectionPolicy() (*AzureIaaSVMProtectionPolicy, bool) {
	return nil, false
}

// AsAzureSQLProtectionPolicy is the BasicProtectionPolicy implementation for AzureVMWorkloadProtectionPolicy.
func (avwpp AzureVMWorkloadProtectionPolicy) AsAzureSQLProtectionPolicy() (*AzureSQLProtectionPolicy, bool) {
	return nil, false
}

// AsGenericProtectionPolicy is the BasicProtectionPolicy implementation for AzureVMWorkloadProtectionPolicy.
func (avwpp AzureVMWorkloadProtectionPolicy) AsGenericProtectionPolicy() (*GenericProtectionPolicy, bool) {
	return nil, false
}

// AsMabProtectionPolicy is the BasicProtectionPolicy implementation for AzureVMWorkloadProtectionPolicy.
func (avwpp AzureVMWorkloadProtectionPolicy) AsMabProtectionPolicy() (*MabProtectionPolicy, bool) {
	return nil, false
}

// AsProtectionPolicy is the BasicProtectionPolicy implementation for AzureVMWorkloadProtectionPolicy.
func (avwpp AzureVMWorkloadProtectionPolicy) AsProtectionPolicy() (*ProtectionPolicy, bool) {
	return nil, false
}

// AsBasicProtectionPolicy is the BasicProtectionPolicy implementation for AzureVMWorkloadProtectionPolicy.
func (avwpp AzureVMWorkloadProtectionPolicy) AsBasicProtectionPolicy() (BasicProtectionPolicy, bool) {
	return &avwpp, true
}

// AzureVMWorkloadSAPAseDatabaseProtectedItem azure VM workload-specific protected item representing SAP
// ASE Database.
type AzureVMWorkloadSAPAseDatabaseProtectedItem struct {
	// FriendlyName - Friendly name of the DB represented by this backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// ParentName - Parent name of the DB such as Instance or Availability Group.
	ParentName *string `json:"parentName,omitempty"`
	// ParentType - Parent type of protected item, example: for a DB, standalone server or distributed
	ParentType *string `json:"parentType,omitempty"`
	// ProtectionStatus - Backup status of this backup item.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`
	// ProtectionState - Backup state of this backup item. Possible values include: 'ProtectionStateInvalid', 'ProtectionStateIRPending', 'ProtectionStateProtected', 'ProtectionStateProtectionError', 'ProtectionStateProtectionStopped', 'ProtectionStateProtectionPaused'
	ProtectionState ProtectionState `json:"protectionState,omitempty"`
	// LastBackupStatus - Last backup operation status. Possible values: Healthy, Unhealthy. Possible values include: 'LastBackupStatusInvalid', 'LastBackupStatusHealthy', 'LastBackupStatusUnhealthy', 'LastBackupStatusIRPending'
	LastBackupStatus LastBackupStatus `json:"lastBackupStatus,omitempty"`
	// LastBackupTime - Timestamp of the last backup operation on this backup item.
	LastBackupTime *date.Time `json:"lastBackupTime,omitempty"`
	// LastBackupErrorDetail - Error details in last backup
	LastBackupErrorDetail *ErrorDetail `json:"lastBackupErrorDetail,omitempty"`
	// ProtectedItemDataSourceID - Data ID of the protected item.
	ProtectedItemDataSourceID *string `json:"protectedItemDataSourceId,omitempty"`
	// ProtectedItemHealthStatus - Health status of the backup item, evaluated based on last heartbeat received. Possible values include: 'ProtectedItemHealthStatusInvalid', 'ProtectedItemHealthStatusHealthy', 'ProtectedItemHealthStatusUnhealthy', 'ProtectedItemHealthStatusNotReachable', 'ProtectedItemHealthStatusIRPending'
	ProtectedItemHealthStatus ProtectedItemHealthStatus `json:"protectedItemHealthStatus,omitempty"`
	// ExtendedInfo - Additional information for this backup item.
	ExtendedInfo *AzureVMWorkloadProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`
	// BackupManagementType - Type of backup management for the backed up item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload this item represents. Possible values include: 'DataSourceTypeInvalid', 'DataSourceTypeVM', 'DataSourceTypeFileFolder', 'DataSourceTypeAzureSQLDb', 'DataSourceTypeSQLDB', 'DataSourceTypeExchange', 'DataSourceTypeSharepoint', 'DataSourceTypeVMwareVM', 'DataSourceTypeSystemState', 'DataSourceTypeClient', 'DataSourceTypeGenericDataSource', 'DataSourceTypeSQLDataBase', 'DataSourceTypeAzureFileShare', 'DataSourceTypeSAPHanaDatabase', 'DataSourceTypeSAPAseDatabase'
	WorkloadType DataSourceType `json:"workloadType,omitempty"`
	// ContainerName - Unique name of container
	ContainerName *string `json:"containerName,omitempty"`
	// SourceResourceID - ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// PolicyID - ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`
	// LastRecoveryPoint - Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *date.Time `json:"lastRecoveryPoint,omitempty"`
	// BackupSetName - Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`
	// CreateMode - Create mode to indicate recovery of existing soft deleted data source or creation of new data source. Possible values include: 'CreateModeInvalid', 'CreateModeDefault', 'CreateModeRecover'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// DeferredDeleteTimeInUTC - Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *date.Time `json:"deferredDeleteTimeInUTC,omitempty"`
	// IsScheduledForDeferredDelete - Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`
	// DeferredDeleteTimeRemaining - Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`
	// IsDeferredDeleteScheduleUpcoming - Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`
	// IsRehydrate - Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`
	// ProtectedItemType - Possible values include: 'ProtectedItemTypeProtectedItem', 'ProtectedItemTypeAzureFileShareProtectedItem', 'ProtectedItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectedItemTypeMicrosoftComputevirtualMachines', 'ProtectedItemTypeAzureIaaSVMProtectedItem', 'ProtectedItemTypeMicrosoftSqlserversdatabases', 'ProtectedItemTypeAzureVMWorkloadProtectedItem', 'ProtectedItemTypeAzureVMWorkloadSAPAseDatabase', 'ProtectedItemTypeAzureVMWorkloadSAPHanaDatabase', 'ProtectedItemTypeAzureVMWorkloadSQLDatabase', 'ProtectedItemTypeDPMProtectedItem', 'ProtectedItemTypeGenericProtectedItem', 'ProtectedItemTypeMabFileFolderProtectedItem'
	ProtectedItemType ProtectedItemType `json:"protectedItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSAPAseDatabaseProtectedItem.
func (avwsadpi AzureVMWorkloadSAPAseDatabaseProtectedItem) MarshalJSON() ([]byte, error) {
	avwsadpi.ProtectedItemType = ProtectedItemTypeAzureVMWorkloadSAPAseDatabase
	objectMap := make(map[string]interface{})
	if avwsadpi.FriendlyName != nil {
		objectMap["friendlyName"] = avwsadpi.FriendlyName
	}
	if avwsadpi.ServerName != nil {
		objectMap["serverName"] = avwsadpi.ServerName
	}
	if avwsadpi.ParentName != nil {
		objectMap["parentName"] = avwsadpi.ParentName
	}
	if avwsadpi.ParentType != nil {
		objectMap["parentType"] = avwsadpi.ParentType
	}
	if avwsadpi.ProtectionStatus != nil {
		objectMap["protectionStatus"] = avwsadpi.ProtectionStatus
	}
	if avwsadpi.ProtectionState != "" {
		objectMap["protectionState"] = avwsadpi.ProtectionState
	}
	if avwsadpi.LastBackupStatus != "" {
		objectMap["lastBackupStatus"] = avwsadpi.LastBackupStatus
	}
	if avwsadpi.LastBackupTime != nil {
		objectMap["lastBackupTime"] = avwsadpi.LastBackupTime
	}
	if avwsadpi.LastBackupErrorDetail != nil {
		objectMap["lastBackupErrorDetail"] = avwsadpi.LastBackupErrorDetail
	}
	if avwsadpi.ProtectedItemDataSourceID != nil {
		objectMap["protectedItemDataSourceId"] = avwsadpi.ProtectedItemDataSourceID
	}
	if avwsadpi.ProtectedItemHealthStatus != "" {
		objectMap["protectedItemHealthStatus"] = avwsadpi.ProtectedItemHealthStatus
	}
	if avwsadpi.ExtendedInfo != nil {
		objectMap["extendedInfo"] = avwsadpi.ExtendedInfo
	}
	if avwsadpi.BackupManagementType != "" {
		objectMap["backupManagementType"] = avwsadpi.BackupManagementType
	}
	if avwsadpi.WorkloadType != "" {
		objectMap["workloadType"] = avwsadpi.WorkloadType
	}
	if avwsadpi.ContainerName != nil {
		objectMap["containerName"] = avwsadpi.ContainerName
	}
	if avwsadpi.SourceResourceID != nil {
		objectMap["sourceResourceId"] = avwsadpi.SourceResourceID
	}
	if avwsadpi.PolicyID != nil {
		objectMap["policyId"] = avwsadpi.PolicyID
	}
	if avwsadpi.LastRecoveryPoint != nil {
		objectMap["lastRecoveryPoint"] = avwsadpi.LastRecoveryPoint
	}
	if avwsadpi.BackupSetName != nil {
		objectMap["backupSetName"] = avwsadpi.BackupSetName
	}
	if avwsadpi.CreateMode != "" {
		objectMap["createMode"] = avwsadpi.CreateMode
	}
	if avwsadpi.DeferredDeleteTimeInUTC != nil {
		objectMap["deferredDeleteTimeInUTC"] = avwsadpi.DeferredDeleteTimeInUTC
	}
	if avwsadpi.IsScheduledForDeferredDelete != nil {
		objectMap["isScheduledForDeferredDelete"] = avwsadpi.IsScheduledForDeferredDelete
	}
	if avwsadpi.DeferredDeleteTimeRemaining != nil {
		objectMap["deferredDeleteTimeRemaining"] = avwsadpi.DeferredDeleteTimeRemaining
	}
	if avwsadpi.IsDeferredDeleteScheduleUpcoming != nil {
		objectMap["isDeferredDeleteScheduleUpcoming"] = avwsadpi.IsDeferredDeleteScheduleUpcoming
	}
	if avwsadpi.IsRehydrate != nil {
		objectMap["isRehydrate"] = avwsadpi.IsRehydrate
	}
	if avwsadpi.ProtectedItemType != "" {
		objectMap["protectedItemType"] = avwsadpi.ProtectedItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileshareProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPAseDatabaseProtectedItem.
func (avwsadpi AzureVMWorkloadSAPAseDatabaseProtectedItem) AsAzureFileshareProtectedItem() (*AzureFileshareProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPAseDatabaseProtectedItem.
func (avwsadpi AzureVMWorkloadSAPAseDatabaseProtectedItem) AsAzureIaaSClassicComputeVMProtectedItem() (*AzureIaaSClassicComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPAseDatabaseProtectedItem.
func (avwsadpi AzureVMWorkloadSAPAseDatabaseProtectedItem) AsAzureIaaSComputeVMProtectedItem() (*AzureIaaSComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPAseDatabaseProtectedItem.
func (avwsadpi AzureVMWorkloadSAPAseDatabaseProtectedItem) AsAzureIaaSVMProtectedItem() (*AzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPAseDatabaseProtectedItem.
func (avwsadpi AzureVMWorkloadSAPAseDatabaseProtectedItem) AsBasicAzureIaaSVMProtectedItem() (BasicAzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsAzureSQLProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPAseDatabaseProtectedItem.
func (avwsadpi AzureVMWorkloadSAPAseDatabaseProtectedItem) AsAzureSQLProtectedItem() (*AzureSQLProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPAseDatabaseProtectedItem.
func (avwsadpi AzureVMWorkloadSAPAseDatabaseProtectedItem) AsAzureVMWorkloadProtectedItem() (*AzureVMWorkloadProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPAseDatabaseProtectedItem.
func (avwsadpi AzureVMWorkloadSAPAseDatabaseProtectedItem) AsBasicAzureVMWorkloadProtectedItem() (BasicAzureVMWorkloadProtectedItem, bool) {
	return &avwsadpi, true
}

// AsAzureVMWorkloadSAPAseDatabaseProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPAseDatabaseProtectedItem.
func (avwsadpi AzureVMWorkloadSAPAseDatabaseProtectedItem) AsAzureVMWorkloadSAPAseDatabaseProtectedItem() (*AzureVMWorkloadSAPAseDatabaseProtectedItem, bool) {
	return &avwsadpi, true
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPAseDatabaseProtectedItem.
func (avwsadpi AzureVMWorkloadSAPAseDatabaseProtectedItem) AsAzureVMWorkloadSAPHanaDatabaseProtectedItem() (*AzureVMWorkloadSAPHanaDatabaseProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPAseDatabaseProtectedItem.
func (avwsadpi AzureVMWorkloadSAPAseDatabaseProtectedItem) AsAzureVMWorkloadSQLDatabaseProtectedItem() (*AzureVMWorkloadSQLDatabaseProtectedItem, bool) {
	return nil, false
}

// AsDPMProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPAseDatabaseProtectedItem.
func (avwsadpi AzureVMWorkloadSAPAseDatabaseProtectedItem) AsDPMProtectedItem() (*DPMProtectedItem, bool) {
	return nil, false
}

// AsGenericProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPAseDatabaseProtectedItem.
func (avwsadpi AzureVMWorkloadSAPAseDatabaseProtectedItem) AsGenericProtectedItem() (*GenericProtectedItem, bool) {
	return nil, false
}

// AsMabFileFolderProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPAseDatabaseProtectedItem.
func (avwsadpi AzureVMWorkloadSAPAseDatabaseProtectedItem) AsMabFileFolderProtectedItem() (*MabFileFolderProtectedItem, bool) {
	return nil, false
}

// AsProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPAseDatabaseProtectedItem.
func (avwsadpi AzureVMWorkloadSAPAseDatabaseProtectedItem) AsProtectedItem() (*ProtectedItem, bool) {
	return nil, false
}

// AsBasicProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPAseDatabaseProtectedItem.
func (avwsadpi AzureVMWorkloadSAPAseDatabaseProtectedItem) AsBasicProtectedItem() (BasicProtectedItem, bool) {
	return &avwsadpi, true
}

// AzureVMWorkloadSAPAseDatabaseWorkloadItem azure VM workload-specific workload item representing SAP ASE
// Database.
type AzureVMWorkloadSAPAseDatabaseWorkloadItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if workload item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// SubWorkloadItemCount - For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32 `json:"subWorkloadItemCount,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// WorkloadItemType - Possible values include: 'WorkloadItemTypeWorkloadItem', 'WorkloadItemTypeAzureVMWorkloadItem', 'WorkloadItemTypeSAPAseDatabase1', 'WorkloadItemTypeSAPAseSystem1', 'WorkloadItemTypeSAPHanaDatabase1', 'WorkloadItemTypeSAPHanaSystem1', 'WorkloadItemTypeSQLDataBase1', 'WorkloadItemTypeSQLInstance1'
	WorkloadItemType WorkloadItemTypeBasicWorkloadItem `json:"workloadItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem) MarshalJSON() ([]byte, error) {
	avwsadwi.WorkloadItemType = WorkloadItemTypeSAPAseDatabase1
	objectMap := make(map[string]interface{})
	if avwsadwi.ParentName != nil {
		objectMap["parentName"] = avwsadwi.ParentName
	}
	if avwsadwi.ServerName != nil {
		objectMap["serverName"] = avwsadwi.ServerName
	}
	if avwsadwi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwsadwi.IsAutoProtectable
	}
	if avwsadwi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwsadwi.Subinquireditemcount
	}
	if avwsadwi.SubWorkloadItemCount != nil {
		objectMap["subWorkloadItemCount"] = avwsadwi.SubWorkloadItemCount
	}
	if avwsadwi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwsadwi.BackupManagementType
	}
	if avwsadwi.WorkloadType != nil {
		objectMap["workloadType"] = avwsadwi.WorkloadType
	}
	if avwsadwi.FriendlyName != nil {
		objectMap["friendlyName"] = avwsadwi.FriendlyName
	}
	if avwsadwi.ProtectionState != "" {
		objectMap["protectionState"] = avwsadwi.ProtectionState
	}
	if avwsadwi.WorkloadItemType != "" {
		objectMap["workloadItemType"] = avwsadwi.WorkloadItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem) AsAzureVMWorkloadItem() (*AzureVMWorkloadItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem) AsBasicAzureVMWorkloadItem() (BasicAzureVMWorkloadItem, bool) {
	return &avwsadwi, true
}

// AsAzureVMWorkloadSAPAseDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem) AsAzureVMWorkloadSAPAseDatabaseWorkloadItem() (*AzureVMWorkloadSAPAseDatabaseWorkloadItem, bool) {
	return &avwsadwi, true
}

// AsAzureVMWorkloadSAPAseSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem) AsAzureVMWorkloadSAPAseSystemWorkloadItem() (*AzureVMWorkloadSAPAseSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem) AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem() (*AzureVMWorkloadSAPHanaDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem) AsAzureVMWorkloadSAPHanaSystemWorkloadItem() (*AzureVMWorkloadSAPHanaSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem) AsAzureVMWorkloadSQLDatabaseWorkloadItem() (*AzureVMWorkloadSQLDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem) AsAzureVMWorkloadSQLInstanceWorkloadItem() (*AzureVMWorkloadSQLInstanceWorkloadItem, bool) {
	return nil, false
}

// AsWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem) AsWorkloadItem() (*WorkloadItem, bool) {
	return nil, false
}

// AsBasicWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem) AsBasicWorkloadItem() (BasicWorkloadItem, bool) {
	return &avwsadwi, true
}

// AzureVMWorkloadSAPAseSystemProtectableItem azure VM workload-specific protectable item representing SAP
// ASE System.
type AzureVMWorkloadSAPAseSystemProtectableItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ParentUniqueName - Parent Unique Name is added to provide the service formatted URI Name of the Parent
	// Only Applicable for data bases where the parent would be either Instance or a SQL AG.
	ParentUniqueName *string `json:"parentUniqueName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// IsAutoProtected - Indicates if protectable item is auto-protected
	IsAutoProtected *bool `json:"isAutoProtected,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// Subprotectableitemcount - For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32 `json:"subprotectableitemcount,omitempty"`
	// Prebackupvalidation - Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation `json:"prebackupvalidation,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeAzureFileShare', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeAzureVMWorkloadProtectableItem', 'ProtectableItemTypeSAPAseSystem', 'ProtectableItemTypeSAPHanaDatabase', 'ProtectableItemTypeSAPHanaSystem', 'ProtectableItemTypeSQLAvailabilityGroupContainer', 'ProtectableItemTypeSQLDataBase', 'ProtectableItemTypeSQLInstance', 'ProtectableItemTypeIaaSVMProtectableItem'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) MarshalJSON() ([]byte, error) {
	avwsaspi.ProtectableItemType = ProtectableItemTypeSAPAseSystem
	objectMap := make(map[string]interface{})
	if avwsaspi.ParentName != nil {
		objectMap["parentName"] = avwsaspi.ParentName
	}
	if avwsaspi.ParentUniqueName != nil {
		objectMap["parentUniqueName"] = avwsaspi.ParentUniqueName
	}
	if avwsaspi.ServerName != nil {
		objectMap["serverName"] = avwsaspi.ServerName
	}
	if avwsaspi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwsaspi.IsAutoProtectable
	}
	if avwsaspi.IsAutoProtected != nil {
		objectMap["isAutoProtected"] = avwsaspi.IsAutoProtected
	}
	if avwsaspi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwsaspi.Subinquireditemcount
	}
	if avwsaspi.Subprotectableitemcount != nil {
		objectMap["subprotectableitemcount"] = avwsaspi.Subprotectableitemcount
	}
	if avwsaspi.Prebackupvalidation != nil {
		objectMap["prebackupvalidation"] = avwsaspi.Prebackupvalidation
	}
	if avwsaspi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwsaspi.BackupManagementType
	}
	if avwsaspi.WorkloadType != nil {
		objectMap["workloadType"] = avwsaspi.WorkloadType
	}
	if avwsaspi.FriendlyName != nil {
		objectMap["friendlyName"] = avwsaspi.FriendlyName
	}
	if avwsaspi.ProtectionState != "" {
		objectMap["protectionState"] = avwsaspi.ProtectionState
	}
	if avwsaspi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = avwsaspi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool) {
	return &avwsaspi, true
}

// AsAzureVMWorkloadSAPAseSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool) {
	return &avwsaspi, true
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool) {
	return nil, false
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return nil, false
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return nil, false
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPAseSystemProtectableItem.
func (avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &avwsaspi, true
}

// AzureVMWorkloadSAPAseSystemWorkloadItem azure VM workload-specific workload item representing SAP ASE
// System.
type AzureVMWorkloadSAPAseSystemWorkloadItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if workload item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// SubWorkloadItemCount - For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32 `json:"subWorkloadItemCount,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// WorkloadItemType - Possible values include: 'WorkloadItemTypeWorkloadItem', 'WorkloadItemTypeAzureVMWorkloadItem', 'WorkloadItemTypeSAPAseDatabase1', 'WorkloadItemTypeSAPAseSystem1', 'WorkloadItemTypeSAPHanaDatabase1', 'WorkloadItemTypeSAPHanaSystem1', 'WorkloadItemTypeSQLDataBase1', 'WorkloadItemTypeSQLInstance1'
	WorkloadItemType WorkloadItemTypeBasicWorkloadItem `json:"workloadItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSAPAseSystemWorkloadItem.
func (avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem) MarshalJSON() ([]byte, error) {
	avwsaswi.WorkloadItemType = WorkloadItemTypeSAPAseSystem1
	objectMap := make(map[string]interface{})
	if avwsaswi.ParentName != nil {
		objectMap["parentName"] = avwsaswi.ParentName
	}
	if avwsaswi.ServerName != nil {
		objectMap["serverName"] = avwsaswi.ServerName
	}
	if avwsaswi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwsaswi.IsAutoProtectable
	}
	if avwsaswi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwsaswi.Subinquireditemcount
	}
	if avwsaswi.SubWorkloadItemCount != nil {
		objectMap["subWorkloadItemCount"] = avwsaswi.SubWorkloadItemCount
	}
	if avwsaswi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwsaswi.BackupManagementType
	}
	if avwsaswi.WorkloadType != nil {
		objectMap["workloadType"] = avwsaswi.WorkloadType
	}
	if avwsaswi.FriendlyName != nil {
		objectMap["friendlyName"] = avwsaswi.FriendlyName
	}
	if avwsaswi.ProtectionState != "" {
		objectMap["protectionState"] = avwsaswi.ProtectionState
	}
	if avwsaswi.WorkloadItemType != "" {
		objectMap["workloadItemType"] = avwsaswi.WorkloadItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseSystemWorkloadItem.
func (avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem) AsAzureVMWorkloadItem() (*AzureVMWorkloadItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseSystemWorkloadItem.
func (avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem) AsBasicAzureVMWorkloadItem() (BasicAzureVMWorkloadItem, bool) {
	return &avwsaswi, true
}

// AsAzureVMWorkloadSAPAseDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseSystemWorkloadItem.
func (avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem) AsAzureVMWorkloadSAPAseDatabaseWorkloadItem() (*AzureVMWorkloadSAPAseDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseSystemWorkloadItem.
func (avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem) AsAzureVMWorkloadSAPAseSystemWorkloadItem() (*AzureVMWorkloadSAPAseSystemWorkloadItem, bool) {
	return &avwsaswi, true
}

// AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseSystemWorkloadItem.
func (avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem) AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem() (*AzureVMWorkloadSAPHanaDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseSystemWorkloadItem.
func (avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem) AsAzureVMWorkloadSAPHanaSystemWorkloadItem() (*AzureVMWorkloadSAPHanaSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseSystemWorkloadItem.
func (avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem) AsAzureVMWorkloadSQLDatabaseWorkloadItem() (*AzureVMWorkloadSQLDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseSystemWorkloadItem.
func (avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem) AsAzureVMWorkloadSQLInstanceWorkloadItem() (*AzureVMWorkloadSQLInstanceWorkloadItem, bool) {
	return nil, false
}

// AsWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseSystemWorkloadItem.
func (avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem) AsWorkloadItem() (*WorkloadItem, bool) {
	return nil, false
}

// AsBasicWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPAseSystemWorkloadItem.
func (avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem) AsBasicWorkloadItem() (BasicWorkloadItem, bool) {
	return &avwsaswi, true
}

// AzureVMWorkloadSAPHanaDatabaseProtectableItem azure VM workload-specific protectable item representing
// SAP HANA Database.
type AzureVMWorkloadSAPHanaDatabaseProtectableItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ParentUniqueName - Parent Unique Name is added to provide the service formatted URI Name of the Parent
	// Only Applicable for data bases where the parent would be either Instance or a SQL AG.
	ParentUniqueName *string `json:"parentUniqueName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// IsAutoProtected - Indicates if protectable item is auto-protected
	IsAutoProtected *bool `json:"isAutoProtected,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// Subprotectableitemcount - For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32 `json:"subprotectableitemcount,omitempty"`
	// Prebackupvalidation - Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation `json:"prebackupvalidation,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeAzureFileShare', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeAzureVMWorkloadProtectableItem', 'ProtectableItemTypeSAPAseSystem', 'ProtectableItemTypeSAPHanaDatabase', 'ProtectableItemTypeSAPHanaSystem', 'ProtectableItemTypeSQLAvailabilityGroupContainer', 'ProtectableItemTypeSQLDataBase', 'ProtectableItemTypeSQLInstance', 'ProtectableItemTypeIaaSVMProtectableItem'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) MarshalJSON() ([]byte, error) {
	avwshdpi.ProtectableItemType = ProtectableItemTypeSAPHanaDatabase
	objectMap := make(map[string]interface{})
	if avwshdpi.ParentName != nil {
		objectMap["parentName"] = avwshdpi.ParentName
	}
	if avwshdpi.ParentUniqueName != nil {
		objectMap["parentUniqueName"] = avwshdpi.ParentUniqueName
	}
	if avwshdpi.ServerName != nil {
		objectMap["serverName"] = avwshdpi.ServerName
	}
	if avwshdpi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwshdpi.IsAutoProtectable
	}
	if avwshdpi.IsAutoProtected != nil {
		objectMap["isAutoProtected"] = avwshdpi.IsAutoProtected
	}
	if avwshdpi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwshdpi.Subinquireditemcount
	}
	if avwshdpi.Subprotectableitemcount != nil {
		objectMap["subprotectableitemcount"] = avwshdpi.Subprotectableitemcount
	}
	if avwshdpi.Prebackupvalidation != nil {
		objectMap["prebackupvalidation"] = avwshdpi.Prebackupvalidation
	}
	if avwshdpi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwshdpi.BackupManagementType
	}
	if avwshdpi.WorkloadType != nil {
		objectMap["workloadType"] = avwshdpi.WorkloadType
	}
	if avwshdpi.FriendlyName != nil {
		objectMap["friendlyName"] = avwshdpi.FriendlyName
	}
	if avwshdpi.ProtectionState != "" {
		objectMap["protectionState"] = avwshdpi.ProtectionState
	}
	if avwshdpi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = avwshdpi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool) {
	return &avwshdpi, true
}

// AsAzureVMWorkloadSAPAseSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool) {
	return &avwshdpi, true
}

// AsAzureVMWorkloadSAPHanaSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool) {
	return nil, false
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return nil, false
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return nil, false
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &avwshdpi, true
}

// AzureVMWorkloadSAPHanaDatabaseProtectedItem azure VM workload-specific protected item representing SAP
// HANA Database.
type AzureVMWorkloadSAPHanaDatabaseProtectedItem struct {
	// FriendlyName - Friendly name of the DB represented by this backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// ParentName - Parent name of the DB such as Instance or Availability Group.
	ParentName *string `json:"parentName,omitempty"`
	// ParentType - Parent type of protected item, example: for a DB, standalone server or distributed
	ParentType *string `json:"parentType,omitempty"`
	// ProtectionStatus - Backup status of this backup item.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`
	// ProtectionState - Backup state of this backup item. Possible values include: 'ProtectionStateInvalid', 'ProtectionStateIRPending', 'ProtectionStateProtected', 'ProtectionStateProtectionError', 'ProtectionStateProtectionStopped', 'ProtectionStateProtectionPaused'
	ProtectionState ProtectionState `json:"protectionState,omitempty"`
	// LastBackupStatus - Last backup operation status. Possible values: Healthy, Unhealthy. Possible values include: 'LastBackupStatusInvalid', 'LastBackupStatusHealthy', 'LastBackupStatusUnhealthy', 'LastBackupStatusIRPending'
	LastBackupStatus LastBackupStatus `json:"lastBackupStatus,omitempty"`
	// LastBackupTime - Timestamp of the last backup operation on this backup item.
	LastBackupTime *date.Time `json:"lastBackupTime,omitempty"`
	// LastBackupErrorDetail - Error details in last backup
	LastBackupErrorDetail *ErrorDetail `json:"lastBackupErrorDetail,omitempty"`
	// ProtectedItemDataSourceID - Data ID of the protected item.
	ProtectedItemDataSourceID *string `json:"protectedItemDataSourceId,omitempty"`
	// ProtectedItemHealthStatus - Health status of the backup item, evaluated based on last heartbeat received. Possible values include: 'ProtectedItemHealthStatusInvalid', 'ProtectedItemHealthStatusHealthy', 'ProtectedItemHealthStatusUnhealthy', 'ProtectedItemHealthStatusNotReachable', 'ProtectedItemHealthStatusIRPending'
	ProtectedItemHealthStatus ProtectedItemHealthStatus `json:"protectedItemHealthStatus,omitempty"`
	// ExtendedInfo - Additional information for this backup item.
	ExtendedInfo *AzureVMWorkloadProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`
	// BackupManagementType - Type of backup management for the backed up item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload this item represents. Possible values include: 'DataSourceTypeInvalid', 'DataSourceTypeVM', 'DataSourceTypeFileFolder', 'DataSourceTypeAzureSQLDb', 'DataSourceTypeSQLDB', 'DataSourceTypeExchange', 'DataSourceTypeSharepoint', 'DataSourceTypeVMwareVM', 'DataSourceTypeSystemState', 'DataSourceTypeClient', 'DataSourceTypeGenericDataSource', 'DataSourceTypeSQLDataBase', 'DataSourceTypeAzureFileShare', 'DataSourceTypeSAPHanaDatabase', 'DataSourceTypeSAPAseDatabase'
	WorkloadType DataSourceType `json:"workloadType,omitempty"`
	// ContainerName - Unique name of container
	ContainerName *string `json:"containerName,omitempty"`
	// SourceResourceID - ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// PolicyID - ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`
	// LastRecoveryPoint - Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *date.Time `json:"lastRecoveryPoint,omitempty"`
	// BackupSetName - Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`
	// CreateMode - Create mode to indicate recovery of existing soft deleted data source or creation of new data source. Possible values include: 'CreateModeInvalid', 'CreateModeDefault', 'CreateModeRecover'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// DeferredDeleteTimeInUTC - Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *date.Time `json:"deferredDeleteTimeInUTC,omitempty"`
	// IsScheduledForDeferredDelete - Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`
	// DeferredDeleteTimeRemaining - Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`
	// IsDeferredDeleteScheduleUpcoming - Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`
	// IsRehydrate - Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`
	// ProtectedItemType - Possible values include: 'ProtectedItemTypeProtectedItem', 'ProtectedItemTypeAzureFileShareProtectedItem', 'ProtectedItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectedItemTypeMicrosoftComputevirtualMachines', 'ProtectedItemTypeAzureIaaSVMProtectedItem', 'ProtectedItemTypeMicrosoftSqlserversdatabases', 'ProtectedItemTypeAzureVMWorkloadProtectedItem', 'ProtectedItemTypeAzureVMWorkloadSAPAseDatabase', 'ProtectedItemTypeAzureVMWorkloadSAPHanaDatabase', 'ProtectedItemTypeAzureVMWorkloadSQLDatabase', 'ProtectedItemTypeDPMProtectedItem', 'ProtectedItemTypeGenericProtectedItem', 'ProtectedItemTypeMabFileFolderProtectedItem'
	ProtectedItemType ProtectedItemType `json:"protectedItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSAPHanaDatabaseProtectedItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectedItem) MarshalJSON() ([]byte, error) {
	avwshdpi.ProtectedItemType = ProtectedItemTypeAzureVMWorkloadSAPHanaDatabase
	objectMap := make(map[string]interface{})
	if avwshdpi.FriendlyName != nil {
		objectMap["friendlyName"] = avwshdpi.FriendlyName
	}
	if avwshdpi.ServerName != nil {
		objectMap["serverName"] = avwshdpi.ServerName
	}
	if avwshdpi.ParentName != nil {
		objectMap["parentName"] = avwshdpi.ParentName
	}
	if avwshdpi.ParentType != nil {
		objectMap["parentType"] = avwshdpi.ParentType
	}
	if avwshdpi.ProtectionStatus != nil {
		objectMap["protectionStatus"] = avwshdpi.ProtectionStatus
	}
	if avwshdpi.ProtectionState != "" {
		objectMap["protectionState"] = avwshdpi.ProtectionState
	}
	if avwshdpi.LastBackupStatus != "" {
		objectMap["lastBackupStatus"] = avwshdpi.LastBackupStatus
	}
	if avwshdpi.LastBackupTime != nil {
		objectMap["lastBackupTime"] = avwshdpi.LastBackupTime
	}
	if avwshdpi.LastBackupErrorDetail != nil {
		objectMap["lastBackupErrorDetail"] = avwshdpi.LastBackupErrorDetail
	}
	if avwshdpi.ProtectedItemDataSourceID != nil {
		objectMap["protectedItemDataSourceId"] = avwshdpi.ProtectedItemDataSourceID
	}
	if avwshdpi.ProtectedItemHealthStatus != "" {
		objectMap["protectedItemHealthStatus"] = avwshdpi.ProtectedItemHealthStatus
	}
	if avwshdpi.ExtendedInfo != nil {
		objectMap["extendedInfo"] = avwshdpi.ExtendedInfo
	}
	if avwshdpi.BackupManagementType != "" {
		objectMap["backupManagementType"] = avwshdpi.BackupManagementType
	}
	if avwshdpi.WorkloadType != "" {
		objectMap["workloadType"] = avwshdpi.WorkloadType
	}
	if avwshdpi.ContainerName != nil {
		objectMap["containerName"] = avwshdpi.ContainerName
	}
	if avwshdpi.SourceResourceID != nil {
		objectMap["sourceResourceId"] = avwshdpi.SourceResourceID
	}
	if avwshdpi.PolicyID != nil {
		objectMap["policyId"] = avwshdpi.PolicyID
	}
	if avwshdpi.LastRecoveryPoint != nil {
		objectMap["lastRecoveryPoint"] = avwshdpi.LastRecoveryPoint
	}
	if avwshdpi.BackupSetName != nil {
		objectMap["backupSetName"] = avwshdpi.BackupSetName
	}
	if avwshdpi.CreateMode != "" {
		objectMap["createMode"] = avwshdpi.CreateMode
	}
	if avwshdpi.DeferredDeleteTimeInUTC != nil {
		objectMap["deferredDeleteTimeInUTC"] = avwshdpi.DeferredDeleteTimeInUTC
	}
	if avwshdpi.IsScheduledForDeferredDelete != nil {
		objectMap["isScheduledForDeferredDelete"] = avwshdpi.IsScheduledForDeferredDelete
	}
	if avwshdpi.DeferredDeleteTimeRemaining != nil {
		objectMap["deferredDeleteTimeRemaining"] = avwshdpi.DeferredDeleteTimeRemaining
	}
	if avwshdpi.IsDeferredDeleteScheduleUpcoming != nil {
		objectMap["isDeferredDeleteScheduleUpcoming"] = avwshdpi.IsDeferredDeleteScheduleUpcoming
	}
	if avwshdpi.IsRehydrate != nil {
		objectMap["isRehydrate"] = avwshdpi.IsRehydrate
	}
	if avwshdpi.ProtectedItemType != "" {
		objectMap["protectedItemType"] = avwshdpi.ProtectedItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileshareProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectedItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectedItem) AsAzureFileshareProtectedItem() (*AzureFileshareProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectedItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectedItem) AsAzureIaaSClassicComputeVMProtectedItem() (*AzureIaaSClassicComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectedItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectedItem) AsAzureIaaSComputeVMProtectedItem() (*AzureIaaSComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectedItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectedItem) AsAzureIaaSVMProtectedItem() (*AzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectedItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectedItem) AsBasicAzureIaaSVMProtectedItem() (BasicAzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsAzureSQLProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectedItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectedItem) AsAzureSQLProtectedItem() (*AzureSQLProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectedItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectedItem) AsAzureVMWorkloadProtectedItem() (*AzureVMWorkloadProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectedItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectedItem) AsBasicAzureVMWorkloadProtectedItem() (BasicAzureVMWorkloadProtectedItem, bool) {
	return &avwshdpi, true
}

// AsAzureVMWorkloadSAPAseDatabaseProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectedItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectedItem) AsAzureVMWorkloadSAPAseDatabaseProtectedItem() (*AzureVMWorkloadSAPAseDatabaseProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectedItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectedItem) AsAzureVMWorkloadSAPHanaDatabaseProtectedItem() (*AzureVMWorkloadSAPHanaDatabaseProtectedItem, bool) {
	return &avwshdpi, true
}

// AsAzureVMWorkloadSQLDatabaseProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectedItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectedItem) AsAzureVMWorkloadSQLDatabaseProtectedItem() (*AzureVMWorkloadSQLDatabaseProtectedItem, bool) {
	return nil, false
}

// AsDPMProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectedItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectedItem) AsDPMProtectedItem() (*DPMProtectedItem, bool) {
	return nil, false
}

// AsGenericProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectedItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectedItem) AsGenericProtectedItem() (*GenericProtectedItem, bool) {
	return nil, false
}

// AsMabFileFolderProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectedItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectedItem) AsMabFileFolderProtectedItem() (*MabFileFolderProtectedItem, bool) {
	return nil, false
}

// AsProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectedItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectedItem) AsProtectedItem() (*ProtectedItem, bool) {
	return nil, false
}

// AsBasicProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSAPHanaDatabaseProtectedItem.
func (avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectedItem) AsBasicProtectedItem() (BasicProtectedItem, bool) {
	return &avwshdpi, true
}

// AzureVMWorkloadSAPHanaDatabaseWorkloadItem azure VM workload-specific workload item representing SAP
// HANA Database.
type AzureVMWorkloadSAPHanaDatabaseWorkloadItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if workload item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// SubWorkloadItemCount - For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32 `json:"subWorkloadItemCount,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// WorkloadItemType - Possible values include: 'WorkloadItemTypeWorkloadItem', 'WorkloadItemTypeAzureVMWorkloadItem', 'WorkloadItemTypeSAPAseDatabase1', 'WorkloadItemTypeSAPAseSystem1', 'WorkloadItemTypeSAPHanaDatabase1', 'WorkloadItemTypeSAPHanaSystem1', 'WorkloadItemTypeSQLDataBase1', 'WorkloadItemTypeSQLInstance1'
	WorkloadItemType WorkloadItemTypeBasicWorkloadItem `json:"workloadItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem) MarshalJSON() ([]byte, error) {
	avwshdwi.WorkloadItemType = WorkloadItemTypeSAPHanaDatabase1
	objectMap := make(map[string]interface{})
	if avwshdwi.ParentName != nil {
		objectMap["parentName"] = avwshdwi.ParentName
	}
	if avwshdwi.ServerName != nil {
		objectMap["serverName"] = avwshdwi.ServerName
	}
	if avwshdwi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwshdwi.IsAutoProtectable
	}
	if avwshdwi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwshdwi.Subinquireditemcount
	}
	if avwshdwi.SubWorkloadItemCount != nil {
		objectMap["subWorkloadItemCount"] = avwshdwi.SubWorkloadItemCount
	}
	if avwshdwi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwshdwi.BackupManagementType
	}
	if avwshdwi.WorkloadType != nil {
		objectMap["workloadType"] = avwshdwi.WorkloadType
	}
	if avwshdwi.FriendlyName != nil {
		objectMap["friendlyName"] = avwshdwi.FriendlyName
	}
	if avwshdwi.ProtectionState != "" {
		objectMap["protectionState"] = avwshdwi.ProtectionState
	}
	if avwshdwi.WorkloadItemType != "" {
		objectMap["workloadItemType"] = avwshdwi.WorkloadItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem) AsAzureVMWorkloadItem() (*AzureVMWorkloadItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem) AsBasicAzureVMWorkloadItem() (BasicAzureVMWorkloadItem, bool) {
	return &avwshdwi, true
}

// AsAzureVMWorkloadSAPAseDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem) AsAzureVMWorkloadSAPAseDatabaseWorkloadItem() (*AzureVMWorkloadSAPAseDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem) AsAzureVMWorkloadSAPAseSystemWorkloadItem() (*AzureVMWorkloadSAPAseSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem) AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem() (*AzureVMWorkloadSAPHanaDatabaseWorkloadItem, bool) {
	return &avwshdwi, true
}

// AsAzureVMWorkloadSAPHanaSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem) AsAzureVMWorkloadSAPHanaSystemWorkloadItem() (*AzureVMWorkloadSAPHanaSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem) AsAzureVMWorkloadSQLDatabaseWorkloadItem() (*AzureVMWorkloadSQLDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem) AsAzureVMWorkloadSQLInstanceWorkloadItem() (*AzureVMWorkloadSQLInstanceWorkloadItem, bool) {
	return nil, false
}

// AsWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem) AsWorkloadItem() (*WorkloadItem, bool) {
	return nil, false
}

// AsBasicWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem) AsBasicWorkloadItem() (BasicWorkloadItem, bool) {
	return &avwshdwi, true
}

// AzureVMWorkloadSAPHanaSystemProtectableItem azure VM workload-specific protectable item representing SAP
// HANA System.
type AzureVMWorkloadSAPHanaSystemProtectableItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ParentUniqueName - Parent Unique Name is added to provide the service formatted URI Name of the Parent
	// Only Applicable for data bases where the parent would be either Instance or a SQL AG.
	ParentUniqueName *string `json:"parentUniqueName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// IsAutoProtected - Indicates if protectable item is auto-protected
	IsAutoProtected *bool `json:"isAutoProtected,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// Subprotectableitemcount - For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32 `json:"subprotectableitemcount,omitempty"`
	// Prebackupvalidation - Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation `json:"prebackupvalidation,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeAzureFileShare', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeAzureVMWorkloadProtectableItem', 'ProtectableItemTypeSAPAseSystem', 'ProtectableItemTypeSAPHanaDatabase', 'ProtectableItemTypeSAPHanaSystem', 'ProtectableItemTypeSQLAvailabilityGroupContainer', 'ProtectableItemTypeSQLDataBase', 'ProtectableItemTypeSQLInstance', 'ProtectableItemTypeIaaSVMProtectableItem'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) MarshalJSON() ([]byte, error) {
	avwshspi.ProtectableItemType = ProtectableItemTypeSAPHanaSystem
	objectMap := make(map[string]interface{})
	if avwshspi.ParentName != nil {
		objectMap["parentName"] = avwshspi.ParentName
	}
	if avwshspi.ParentUniqueName != nil {
		objectMap["parentUniqueName"] = avwshspi.ParentUniqueName
	}
	if avwshspi.ServerName != nil {
		objectMap["serverName"] = avwshspi.ServerName
	}
	if avwshspi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwshspi.IsAutoProtectable
	}
	if avwshspi.IsAutoProtected != nil {
		objectMap["isAutoProtected"] = avwshspi.IsAutoProtected
	}
	if avwshspi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwshspi.Subinquireditemcount
	}
	if avwshspi.Subprotectableitemcount != nil {
		objectMap["subprotectableitemcount"] = avwshspi.Subprotectableitemcount
	}
	if avwshspi.Prebackupvalidation != nil {
		objectMap["prebackupvalidation"] = avwshspi.Prebackupvalidation
	}
	if avwshspi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwshspi.BackupManagementType
	}
	if avwshspi.WorkloadType != nil {
		objectMap["workloadType"] = avwshspi.WorkloadType
	}
	if avwshspi.FriendlyName != nil {
		objectMap["friendlyName"] = avwshspi.FriendlyName
	}
	if avwshspi.ProtectionState != "" {
		objectMap["protectionState"] = avwshspi.ProtectionState
	}
	if avwshspi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = avwshspi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool) {
	return &avwshspi, true
}

// AsAzureVMWorkloadSAPAseSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool) {
	return &avwshspi, true
}

// AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool) {
	return nil, false
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return nil, false
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return nil, false
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSAPHanaSystemProtectableItem.
func (avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &avwshspi, true
}

// AzureVMWorkloadSAPHanaSystemWorkloadItem azure VM workload-specific workload item representing SAP HANA
// System.
type AzureVMWorkloadSAPHanaSystemWorkloadItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if workload item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// SubWorkloadItemCount - For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32 `json:"subWorkloadItemCount,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// WorkloadItemType - Possible values include: 'WorkloadItemTypeWorkloadItem', 'WorkloadItemTypeAzureVMWorkloadItem', 'WorkloadItemTypeSAPAseDatabase1', 'WorkloadItemTypeSAPAseSystem1', 'WorkloadItemTypeSAPHanaDatabase1', 'WorkloadItemTypeSAPHanaSystem1', 'WorkloadItemTypeSQLDataBase1', 'WorkloadItemTypeSQLInstance1'
	WorkloadItemType WorkloadItemTypeBasicWorkloadItem `json:"workloadItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem) MarshalJSON() ([]byte, error) {
	avwshswi.WorkloadItemType = WorkloadItemTypeSAPHanaSystem1
	objectMap := make(map[string]interface{})
	if avwshswi.ParentName != nil {
		objectMap["parentName"] = avwshswi.ParentName
	}
	if avwshswi.ServerName != nil {
		objectMap["serverName"] = avwshswi.ServerName
	}
	if avwshswi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwshswi.IsAutoProtectable
	}
	if avwshswi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwshswi.Subinquireditemcount
	}
	if avwshswi.SubWorkloadItemCount != nil {
		objectMap["subWorkloadItemCount"] = avwshswi.SubWorkloadItemCount
	}
	if avwshswi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwshswi.BackupManagementType
	}
	if avwshswi.WorkloadType != nil {
		objectMap["workloadType"] = avwshswi.WorkloadType
	}
	if avwshswi.FriendlyName != nil {
		objectMap["friendlyName"] = avwshswi.FriendlyName
	}
	if avwshswi.ProtectionState != "" {
		objectMap["protectionState"] = avwshswi.ProtectionState
	}
	if avwshswi.WorkloadItemType != "" {
		objectMap["workloadItemType"] = avwshswi.WorkloadItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem) AsAzureVMWorkloadItem() (*AzureVMWorkloadItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem) AsBasicAzureVMWorkloadItem() (BasicAzureVMWorkloadItem, bool) {
	return &avwshswi, true
}

// AsAzureVMWorkloadSAPAseDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem) AsAzureVMWorkloadSAPAseDatabaseWorkloadItem() (*AzureVMWorkloadSAPAseDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem) AsAzureVMWorkloadSAPAseSystemWorkloadItem() (*AzureVMWorkloadSAPAseSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem) AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem() (*AzureVMWorkloadSAPHanaDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem) AsAzureVMWorkloadSAPHanaSystemWorkloadItem() (*AzureVMWorkloadSAPHanaSystemWorkloadItem, bool) {
	return &avwshswi, true
}

// AsAzureVMWorkloadSQLDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem) AsAzureVMWorkloadSQLDatabaseWorkloadItem() (*AzureVMWorkloadSQLDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem) AsAzureVMWorkloadSQLInstanceWorkloadItem() (*AzureVMWorkloadSQLInstanceWorkloadItem, bool) {
	return nil, false
}

// AsWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem) AsWorkloadItem() (*WorkloadItem, bool) {
	return nil, false
}

// AsBasicWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem) AsBasicWorkloadItem() (BasicWorkloadItem, bool) {
	return &avwshswi, true
}

// AzureVMWorkloadSQLAvailabilityGroupProtectableItem azure VM workload-specific protectable item
// representing SQL Availability Group.
type AzureVMWorkloadSQLAvailabilityGroupProtectableItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ParentUniqueName - Parent Unique Name is added to provide the service formatted URI Name of the Parent
	// Only Applicable for data bases where the parent would be either Instance or a SQL AG.
	ParentUniqueName *string `json:"parentUniqueName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// IsAutoProtected - Indicates if protectable item is auto-protected
	IsAutoProtected *bool `json:"isAutoProtected,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// Subprotectableitemcount - For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32 `json:"subprotectableitemcount,omitempty"`
	// Prebackupvalidation - Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation `json:"prebackupvalidation,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeAzureFileShare', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeAzureVMWorkloadProtectableItem', 'ProtectableItemTypeSAPAseSystem', 'ProtectableItemTypeSAPHanaDatabase', 'ProtectableItemTypeSAPHanaSystem', 'ProtectableItemTypeSQLAvailabilityGroupContainer', 'ProtectableItemTypeSQLDataBase', 'ProtectableItemTypeSQLInstance', 'ProtectableItemTypeIaaSVMProtectableItem'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) MarshalJSON() ([]byte, error) {
	avwsagpi.ProtectableItemType = ProtectableItemTypeSQLAvailabilityGroupContainer
	objectMap := make(map[string]interface{})
	if avwsagpi.ParentName != nil {
		objectMap["parentName"] = avwsagpi.ParentName
	}
	if avwsagpi.ParentUniqueName != nil {
		objectMap["parentUniqueName"] = avwsagpi.ParentUniqueName
	}
	if avwsagpi.ServerName != nil {
		objectMap["serverName"] = avwsagpi.ServerName
	}
	if avwsagpi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwsagpi.IsAutoProtectable
	}
	if avwsagpi.IsAutoProtected != nil {
		objectMap["isAutoProtected"] = avwsagpi.IsAutoProtected
	}
	if avwsagpi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwsagpi.Subinquireditemcount
	}
	if avwsagpi.Subprotectableitemcount != nil {
		objectMap["subprotectableitemcount"] = avwsagpi.Subprotectableitemcount
	}
	if avwsagpi.Prebackupvalidation != nil {
		objectMap["prebackupvalidation"] = avwsagpi.Prebackupvalidation
	}
	if avwsagpi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwsagpi.BackupManagementType
	}
	if avwsagpi.WorkloadType != nil {
		objectMap["workloadType"] = avwsagpi.WorkloadType
	}
	if avwsagpi.FriendlyName != nil {
		objectMap["friendlyName"] = avwsagpi.FriendlyName
	}
	if avwsagpi.ProtectionState != "" {
		objectMap["protectionState"] = avwsagpi.ProtectionState
	}
	if avwsagpi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = avwsagpi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool) {
	return &avwsagpi, true
}

// AsAzureVMWorkloadSAPAseSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool) {
	return &avwsagpi, true
}

// AsAzureVMWorkloadSQLDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool) {
	return nil, false
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return nil, false
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return nil, false
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &avwsagpi, true
}

// AzureVMWorkloadSQLDatabaseProtectableItem azure VM workload-specific protectable item representing SQL
// Database.
type AzureVMWorkloadSQLDatabaseProtectableItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ParentUniqueName - Parent Unique Name is added to provide the service formatted URI Name of the Parent
	// Only Applicable for data bases where the parent would be either Instance or a SQL AG.
	ParentUniqueName *string `json:"parentUniqueName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// IsAutoProtected - Indicates if protectable item is auto-protected
	IsAutoProtected *bool `json:"isAutoProtected,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// Subprotectableitemcount - For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32 `json:"subprotectableitemcount,omitempty"`
	// Prebackupvalidation - Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation `json:"prebackupvalidation,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeAzureFileShare', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeAzureVMWorkloadProtectableItem', 'ProtectableItemTypeSAPAseSystem', 'ProtectableItemTypeSAPHanaDatabase', 'ProtectableItemTypeSAPHanaSystem', 'ProtectableItemTypeSQLAvailabilityGroupContainer', 'ProtectableItemTypeSQLDataBase', 'ProtectableItemTypeSQLInstance', 'ProtectableItemTypeIaaSVMProtectableItem'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) MarshalJSON() ([]byte, error) {
	avwsdpi.ProtectableItemType = ProtectableItemTypeSQLDataBase
	objectMap := make(map[string]interface{})
	if avwsdpi.ParentName != nil {
		objectMap["parentName"] = avwsdpi.ParentName
	}
	if avwsdpi.ParentUniqueName != nil {
		objectMap["parentUniqueName"] = avwsdpi.ParentUniqueName
	}
	if avwsdpi.ServerName != nil {
		objectMap["serverName"] = avwsdpi.ServerName
	}
	if avwsdpi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwsdpi.IsAutoProtectable
	}
	if avwsdpi.IsAutoProtected != nil {
		objectMap["isAutoProtected"] = avwsdpi.IsAutoProtected
	}
	if avwsdpi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwsdpi.Subinquireditemcount
	}
	if avwsdpi.Subprotectableitemcount != nil {
		objectMap["subprotectableitemcount"] = avwsdpi.Subprotectableitemcount
	}
	if avwsdpi.Prebackupvalidation != nil {
		objectMap["prebackupvalidation"] = avwsdpi.Prebackupvalidation
	}
	if avwsdpi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwsdpi.BackupManagementType
	}
	if avwsdpi.WorkloadType != nil {
		objectMap["workloadType"] = avwsdpi.WorkloadType
	}
	if avwsdpi.FriendlyName != nil {
		objectMap["friendlyName"] = avwsdpi.FriendlyName
	}
	if avwsdpi.ProtectionState != "" {
		objectMap["protectionState"] = avwsdpi.ProtectionState
	}
	if avwsdpi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = avwsdpi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool) {
	return &avwsdpi, true
}

// AsAzureVMWorkloadSAPAseSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool) {
	return &avwsdpi, true
}

// AsAzureVMWorkloadSQLInstanceProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool) {
	return nil, false
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return nil, false
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return nil, false
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLDatabaseProtectableItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &avwsdpi, true
}

// AzureVMWorkloadSQLDatabaseProtectedItem azure VM workload-specific protected item representing SQL
// Database.
type AzureVMWorkloadSQLDatabaseProtectedItem struct {
	// FriendlyName - Friendly name of the DB represented by this backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// ParentName - Parent name of the DB such as Instance or Availability Group.
	ParentName *string `json:"parentName,omitempty"`
	// ParentType - Parent type of protected item, example: for a DB, standalone server or distributed
	ParentType *string `json:"parentType,omitempty"`
	// ProtectionStatus - Backup status of this backup item.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`
	// ProtectionState - Backup state of this backup item. Possible values include: 'ProtectionStateInvalid', 'ProtectionStateIRPending', 'ProtectionStateProtected', 'ProtectionStateProtectionError', 'ProtectionStateProtectionStopped', 'ProtectionStateProtectionPaused'
	ProtectionState ProtectionState `json:"protectionState,omitempty"`
	// LastBackupStatus - Last backup operation status. Possible values: Healthy, Unhealthy. Possible values include: 'LastBackupStatusInvalid', 'LastBackupStatusHealthy', 'LastBackupStatusUnhealthy', 'LastBackupStatusIRPending'
	LastBackupStatus LastBackupStatus `json:"lastBackupStatus,omitempty"`
	// LastBackupTime - Timestamp of the last backup operation on this backup item.
	LastBackupTime *date.Time `json:"lastBackupTime,omitempty"`
	// LastBackupErrorDetail - Error details in last backup
	LastBackupErrorDetail *ErrorDetail `json:"lastBackupErrorDetail,omitempty"`
	// ProtectedItemDataSourceID - Data ID of the protected item.
	ProtectedItemDataSourceID *string `json:"protectedItemDataSourceId,omitempty"`
	// ProtectedItemHealthStatus - Health status of the backup item, evaluated based on last heartbeat received. Possible values include: 'ProtectedItemHealthStatusInvalid', 'ProtectedItemHealthStatusHealthy', 'ProtectedItemHealthStatusUnhealthy', 'ProtectedItemHealthStatusNotReachable', 'ProtectedItemHealthStatusIRPending'
	ProtectedItemHealthStatus ProtectedItemHealthStatus `json:"protectedItemHealthStatus,omitempty"`
	// ExtendedInfo - Additional information for this backup item.
	ExtendedInfo *AzureVMWorkloadProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`
	// BackupManagementType - Type of backup management for the backed up item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload this item represents. Possible values include: 'DataSourceTypeInvalid', 'DataSourceTypeVM', 'DataSourceTypeFileFolder', 'DataSourceTypeAzureSQLDb', 'DataSourceTypeSQLDB', 'DataSourceTypeExchange', 'DataSourceTypeSharepoint', 'DataSourceTypeVMwareVM', 'DataSourceTypeSystemState', 'DataSourceTypeClient', 'DataSourceTypeGenericDataSource', 'DataSourceTypeSQLDataBase', 'DataSourceTypeAzureFileShare', 'DataSourceTypeSAPHanaDatabase', 'DataSourceTypeSAPAseDatabase'
	WorkloadType DataSourceType `json:"workloadType,omitempty"`
	// ContainerName - Unique name of container
	ContainerName *string `json:"containerName,omitempty"`
	// SourceResourceID - ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// PolicyID - ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`
	// LastRecoveryPoint - Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *date.Time `json:"lastRecoveryPoint,omitempty"`
	// BackupSetName - Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`
	// CreateMode - Create mode to indicate recovery of existing soft deleted data source or creation of new data source. Possible values include: 'CreateModeInvalid', 'CreateModeDefault', 'CreateModeRecover'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// DeferredDeleteTimeInUTC - Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *date.Time `json:"deferredDeleteTimeInUTC,omitempty"`
	// IsScheduledForDeferredDelete - Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`
	// DeferredDeleteTimeRemaining - Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`
	// IsDeferredDeleteScheduleUpcoming - Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`
	// IsRehydrate - Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`
	// ProtectedItemType - Possible values include: 'ProtectedItemTypeProtectedItem', 'ProtectedItemTypeAzureFileShareProtectedItem', 'ProtectedItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectedItemTypeMicrosoftComputevirtualMachines', 'ProtectedItemTypeAzureIaaSVMProtectedItem', 'ProtectedItemTypeMicrosoftSqlserversdatabases', 'ProtectedItemTypeAzureVMWorkloadProtectedItem', 'ProtectedItemTypeAzureVMWorkloadSAPAseDatabase', 'ProtectedItemTypeAzureVMWorkloadSAPHanaDatabase', 'ProtectedItemTypeAzureVMWorkloadSQLDatabase', 'ProtectedItemTypeDPMProtectedItem', 'ProtectedItemTypeGenericProtectedItem', 'ProtectedItemTypeMabFileFolderProtectedItem'
	ProtectedItemType ProtectedItemType `json:"protectedItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSQLDatabaseProtectedItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectedItem) MarshalJSON() ([]byte, error) {
	avwsdpi.ProtectedItemType = ProtectedItemTypeAzureVMWorkloadSQLDatabase
	objectMap := make(map[string]interface{})
	if avwsdpi.FriendlyName != nil {
		objectMap["friendlyName"] = avwsdpi.FriendlyName
	}
	if avwsdpi.ServerName != nil {
		objectMap["serverName"] = avwsdpi.ServerName
	}
	if avwsdpi.ParentName != nil {
		objectMap["parentName"] = avwsdpi.ParentName
	}
	if avwsdpi.ParentType != nil {
		objectMap["parentType"] = avwsdpi.ParentType
	}
	if avwsdpi.ProtectionStatus != nil {
		objectMap["protectionStatus"] = avwsdpi.ProtectionStatus
	}
	if avwsdpi.ProtectionState != "" {
		objectMap["protectionState"] = avwsdpi.ProtectionState
	}
	if avwsdpi.LastBackupStatus != "" {
		objectMap["lastBackupStatus"] = avwsdpi.LastBackupStatus
	}
	if avwsdpi.LastBackupTime != nil {
		objectMap["lastBackupTime"] = avwsdpi.LastBackupTime
	}
	if avwsdpi.LastBackupErrorDetail != nil {
		objectMap["lastBackupErrorDetail"] = avwsdpi.LastBackupErrorDetail
	}
	if avwsdpi.ProtectedItemDataSourceID != nil {
		objectMap["protectedItemDataSourceId"] = avwsdpi.ProtectedItemDataSourceID
	}
	if avwsdpi.ProtectedItemHealthStatus != "" {
		objectMap["protectedItemHealthStatus"] = avwsdpi.ProtectedItemHealthStatus
	}
	if avwsdpi.ExtendedInfo != nil {
		objectMap["extendedInfo"] = avwsdpi.ExtendedInfo
	}
	if avwsdpi.BackupManagementType != "" {
		objectMap["backupManagementType"] = avwsdpi.BackupManagementType
	}
	if avwsdpi.WorkloadType != "" {
		objectMap["workloadType"] = avwsdpi.WorkloadType
	}
	if avwsdpi.ContainerName != nil {
		objectMap["containerName"] = avwsdpi.ContainerName
	}
	if avwsdpi.SourceResourceID != nil {
		objectMap["sourceResourceId"] = avwsdpi.SourceResourceID
	}
	if avwsdpi.PolicyID != nil {
		objectMap["policyId"] = avwsdpi.PolicyID
	}
	if avwsdpi.LastRecoveryPoint != nil {
		objectMap["lastRecoveryPoint"] = avwsdpi.LastRecoveryPoint
	}
	if avwsdpi.BackupSetName != nil {
		objectMap["backupSetName"] = avwsdpi.BackupSetName
	}
	if avwsdpi.CreateMode != "" {
		objectMap["createMode"] = avwsdpi.CreateMode
	}
	if avwsdpi.DeferredDeleteTimeInUTC != nil {
		objectMap["deferredDeleteTimeInUTC"] = avwsdpi.DeferredDeleteTimeInUTC
	}
	if avwsdpi.IsScheduledForDeferredDelete != nil {
		objectMap["isScheduledForDeferredDelete"] = avwsdpi.IsScheduledForDeferredDelete
	}
	if avwsdpi.DeferredDeleteTimeRemaining != nil {
		objectMap["deferredDeleteTimeRemaining"] = avwsdpi.DeferredDeleteTimeRemaining
	}
	if avwsdpi.IsDeferredDeleteScheduleUpcoming != nil {
		objectMap["isDeferredDeleteScheduleUpcoming"] = avwsdpi.IsDeferredDeleteScheduleUpcoming
	}
	if avwsdpi.IsRehydrate != nil {
		objectMap["isRehydrate"] = avwsdpi.IsRehydrate
	}
	if avwsdpi.ProtectedItemType != "" {
		objectMap["protectedItemType"] = avwsdpi.ProtectedItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileshareProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSQLDatabaseProtectedItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectedItem) AsAzureFileshareProtectedItem() (*AzureFileshareProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSQLDatabaseProtectedItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectedItem) AsAzureIaaSClassicComputeVMProtectedItem() (*AzureIaaSClassicComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSQLDatabaseProtectedItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectedItem) AsAzureIaaSComputeVMProtectedItem() (*AzureIaaSComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSQLDatabaseProtectedItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectedItem) AsAzureIaaSVMProtectedItem() (*AzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSQLDatabaseProtectedItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectedItem) AsBasicAzureIaaSVMProtectedItem() (BasicAzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsAzureSQLProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSQLDatabaseProtectedItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectedItem) AsAzureSQLProtectedItem() (*AzureSQLProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSQLDatabaseProtectedItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectedItem) AsAzureVMWorkloadProtectedItem() (*AzureVMWorkloadProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSQLDatabaseProtectedItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectedItem) AsBasicAzureVMWorkloadProtectedItem() (BasicAzureVMWorkloadProtectedItem, bool) {
	return &avwsdpi, true
}

// AsAzureVMWorkloadSAPAseDatabaseProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSQLDatabaseProtectedItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectedItem) AsAzureVMWorkloadSAPAseDatabaseProtectedItem() (*AzureVMWorkloadSAPAseDatabaseProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSQLDatabaseProtectedItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectedItem) AsAzureVMWorkloadSAPHanaDatabaseProtectedItem() (*AzureVMWorkloadSAPHanaDatabaseProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSQLDatabaseProtectedItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectedItem) AsAzureVMWorkloadSQLDatabaseProtectedItem() (*AzureVMWorkloadSQLDatabaseProtectedItem, bool) {
	return &avwsdpi, true
}

// AsDPMProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSQLDatabaseProtectedItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectedItem) AsDPMProtectedItem() (*DPMProtectedItem, bool) {
	return nil, false
}

// AsGenericProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSQLDatabaseProtectedItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectedItem) AsGenericProtectedItem() (*GenericProtectedItem, bool) {
	return nil, false
}

// AsMabFileFolderProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSQLDatabaseProtectedItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectedItem) AsMabFileFolderProtectedItem() (*MabFileFolderProtectedItem, bool) {
	return nil, false
}

// AsProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSQLDatabaseProtectedItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectedItem) AsProtectedItem() (*ProtectedItem, bool) {
	return nil, false
}

// AsBasicProtectedItem is the BasicProtectedItem implementation for AzureVMWorkloadSQLDatabaseProtectedItem.
func (avwsdpi AzureVMWorkloadSQLDatabaseProtectedItem) AsBasicProtectedItem() (BasicProtectedItem, bool) {
	return &avwsdpi, true
}

// AzureVMWorkloadSQLDatabaseWorkloadItem azure VM workload-specific workload item representing SQL
// Database.
type AzureVMWorkloadSQLDatabaseWorkloadItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if workload item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// SubWorkloadItemCount - For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32 `json:"subWorkloadItemCount,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// WorkloadItemType - Possible values include: 'WorkloadItemTypeWorkloadItem', 'WorkloadItemTypeAzureVMWorkloadItem', 'WorkloadItemTypeSAPAseDatabase1', 'WorkloadItemTypeSAPAseSystem1', 'WorkloadItemTypeSAPHanaDatabase1', 'WorkloadItemTypeSAPHanaSystem1', 'WorkloadItemTypeSQLDataBase1', 'WorkloadItemTypeSQLInstance1'
	WorkloadItemType WorkloadItemTypeBasicWorkloadItem `json:"workloadItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSQLDatabaseWorkloadItem.
func (avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem) MarshalJSON() ([]byte, error) {
	avwsdwi.WorkloadItemType = WorkloadItemTypeSQLDataBase1
	objectMap := make(map[string]interface{})
	if avwsdwi.ParentName != nil {
		objectMap["parentName"] = avwsdwi.ParentName
	}
	if avwsdwi.ServerName != nil {
		objectMap["serverName"] = avwsdwi.ServerName
	}
	if avwsdwi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwsdwi.IsAutoProtectable
	}
	if avwsdwi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwsdwi.Subinquireditemcount
	}
	if avwsdwi.SubWorkloadItemCount != nil {
		objectMap["subWorkloadItemCount"] = avwsdwi.SubWorkloadItemCount
	}
	if avwsdwi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwsdwi.BackupManagementType
	}
	if avwsdwi.WorkloadType != nil {
		objectMap["workloadType"] = avwsdwi.WorkloadType
	}
	if avwsdwi.FriendlyName != nil {
		objectMap["friendlyName"] = avwsdwi.FriendlyName
	}
	if avwsdwi.ProtectionState != "" {
		objectMap["protectionState"] = avwsdwi.ProtectionState
	}
	if avwsdwi.WorkloadItemType != "" {
		objectMap["workloadItemType"] = avwsdwi.WorkloadItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLDatabaseWorkloadItem.
func (avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem) AsAzureVMWorkloadItem() (*AzureVMWorkloadItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLDatabaseWorkloadItem.
func (avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem) AsBasicAzureVMWorkloadItem() (BasicAzureVMWorkloadItem, bool) {
	return &avwsdwi, true
}

// AsAzureVMWorkloadSAPAseDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLDatabaseWorkloadItem.
func (avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem) AsAzureVMWorkloadSAPAseDatabaseWorkloadItem() (*AzureVMWorkloadSAPAseDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLDatabaseWorkloadItem.
func (avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem) AsAzureVMWorkloadSAPAseSystemWorkloadItem() (*AzureVMWorkloadSAPAseSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLDatabaseWorkloadItem.
func (avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem) AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem() (*AzureVMWorkloadSAPHanaDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLDatabaseWorkloadItem.
func (avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem) AsAzureVMWorkloadSAPHanaSystemWorkloadItem() (*AzureVMWorkloadSAPHanaSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLDatabaseWorkloadItem.
func (avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem) AsAzureVMWorkloadSQLDatabaseWorkloadItem() (*AzureVMWorkloadSQLDatabaseWorkloadItem, bool) {
	return &avwsdwi, true
}

// AsAzureVMWorkloadSQLInstanceWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLDatabaseWorkloadItem.
func (avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem) AsAzureVMWorkloadSQLInstanceWorkloadItem() (*AzureVMWorkloadSQLInstanceWorkloadItem, bool) {
	return nil, false
}

// AsWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLDatabaseWorkloadItem.
func (avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem) AsWorkloadItem() (*WorkloadItem, bool) {
	return nil, false
}

// AsBasicWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLDatabaseWorkloadItem.
func (avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem) AsBasicWorkloadItem() (BasicWorkloadItem, bool) {
	return &avwsdwi, true
}

// AzureVMWorkloadSQLInstanceProtectableItem azure VM workload-specific protectable item representing SQL
// Instance.
type AzureVMWorkloadSQLInstanceProtectableItem struct {
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ParentUniqueName - Parent Unique Name is added to provide the service formatted URI Name of the Parent
	// Only Applicable for data bases where the parent would be either Instance or a SQL AG.
	ParentUniqueName *string `json:"parentUniqueName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// IsAutoProtected - Indicates if protectable item is auto-protected
	IsAutoProtected *bool `json:"isAutoProtected,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// Subprotectableitemcount - For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32 `json:"subprotectableitemcount,omitempty"`
	// Prebackupvalidation - Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation `json:"prebackupvalidation,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeAzureFileShare', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeAzureVMWorkloadProtectableItem', 'ProtectableItemTypeSAPAseSystem', 'ProtectableItemTypeSAPHanaDatabase', 'ProtectableItemTypeSAPHanaSystem', 'ProtectableItemTypeSQLAvailabilityGroupContainer', 'ProtectableItemTypeSQLDataBase', 'ProtectableItemTypeSQLInstance', 'ProtectableItemTypeIaaSVMProtectableItem'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) MarshalJSON() ([]byte, error) {
	avwsipi.ProtectableItemType = ProtectableItemTypeSQLInstance
	objectMap := make(map[string]interface{})
	if avwsipi.ParentName != nil {
		objectMap["parentName"] = avwsipi.ParentName
	}
	if avwsipi.ParentUniqueName != nil {
		objectMap["parentUniqueName"] = avwsipi.ParentUniqueName
	}
	if avwsipi.ServerName != nil {
		objectMap["serverName"] = avwsipi.ServerName
	}
	if avwsipi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwsipi.IsAutoProtectable
	}
	if avwsipi.IsAutoProtected != nil {
		objectMap["isAutoProtected"] = avwsipi.IsAutoProtected
	}
	if avwsipi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwsipi.Subinquireditemcount
	}
	if avwsipi.Subprotectableitemcount != nil {
		objectMap["subprotectableitemcount"] = avwsipi.Subprotectableitemcount
	}
	if avwsipi.Prebackupvalidation != nil {
		objectMap["prebackupvalidation"] = avwsipi.Prebackupvalidation
	}
	if avwsipi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwsipi.BackupManagementType
	}
	if avwsipi.WorkloadType != nil {
		objectMap["workloadType"] = avwsipi.WorkloadType
	}
	if avwsipi.FriendlyName != nil {
		objectMap["friendlyName"] = avwsipi.FriendlyName
	}
	if avwsipi.ProtectionState != "" {
		objectMap["protectionState"] = avwsipi.ProtectionState
	}
	if avwsipi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = avwsipi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool) {
	return &avwsipi, true
}

// AsAzureVMWorkloadSAPAseSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool) {
	return &avwsipi, true
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return nil, false
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return nil, false
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureVMWorkloadSQLInstanceProtectableItem.
func (avwsipi AzureVMWorkloadSQLInstanceProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &avwsipi, true
}

// AzureVMWorkloadSQLInstanceWorkloadItem azure VM workload-specific workload item representing SQL
// Instance.
type AzureVMWorkloadSQLInstanceWorkloadItem struct {
	// DataDirectoryPaths - Data Directory Paths for default directories
	DataDirectoryPaths *[]SQLDataDirectory `json:"dataDirectoryPaths,omitempty"`
	// ParentName - Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`
	// ServerName - Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`
	// IsAutoProtectable - Indicates if workload item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`
	// Subinquireditemcount - For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`
	// SubWorkloadItemCount - For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32 `json:"subWorkloadItemCount,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// WorkloadItemType - Possible values include: 'WorkloadItemTypeWorkloadItem', 'WorkloadItemTypeAzureVMWorkloadItem', 'WorkloadItemTypeSAPAseDatabase1', 'WorkloadItemTypeSAPAseSystem1', 'WorkloadItemTypeSAPHanaDatabase1', 'WorkloadItemTypeSAPHanaSystem1', 'WorkloadItemTypeSQLDataBase1', 'WorkloadItemTypeSQLInstance1'
	WorkloadItemType WorkloadItemTypeBasicWorkloadItem `json:"workloadItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureVMWorkloadSQLInstanceWorkloadItem.
func (avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem) MarshalJSON() ([]byte, error) {
	avwsiwi.WorkloadItemType = WorkloadItemTypeSQLInstance1
	objectMap := make(map[string]interface{})
	if avwsiwi.DataDirectoryPaths != nil {
		objectMap["dataDirectoryPaths"] = avwsiwi.DataDirectoryPaths
	}
	if avwsiwi.ParentName != nil {
		objectMap["parentName"] = avwsiwi.ParentName
	}
	if avwsiwi.ServerName != nil {
		objectMap["serverName"] = avwsiwi.ServerName
	}
	if avwsiwi.IsAutoProtectable != nil {
		objectMap["isAutoProtectable"] = avwsiwi.IsAutoProtectable
	}
	if avwsiwi.Subinquireditemcount != nil {
		objectMap["subinquireditemcount"] = avwsiwi.Subinquireditemcount
	}
	if avwsiwi.SubWorkloadItemCount != nil {
		objectMap["subWorkloadItemCount"] = avwsiwi.SubWorkloadItemCount
	}
	if avwsiwi.BackupManagementType != nil {
		objectMap["backupManagementType"] = avwsiwi.BackupManagementType
	}
	if avwsiwi.WorkloadType != nil {
		objectMap["workloadType"] = avwsiwi.WorkloadType
	}
	if avwsiwi.FriendlyName != nil {
		objectMap["friendlyName"] = avwsiwi.FriendlyName
	}
	if avwsiwi.ProtectionState != "" {
		objectMap["protectionState"] = avwsiwi.ProtectionState
	}
	if avwsiwi.WorkloadItemType != "" {
		objectMap["workloadItemType"] = avwsiwi.WorkloadItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLInstanceWorkloadItem.
func (avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem) AsAzureVMWorkloadItem() (*AzureVMWorkloadItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLInstanceWorkloadItem.
func (avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem) AsBasicAzureVMWorkloadItem() (BasicAzureVMWorkloadItem, bool) {
	return &avwsiwi, true
}

// AsAzureVMWorkloadSAPAseDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLInstanceWorkloadItem.
func (avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem) AsAzureVMWorkloadSAPAseDatabaseWorkloadItem() (*AzureVMWorkloadSAPAseDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLInstanceWorkloadItem.
func (avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem) AsAzureVMWorkloadSAPAseSystemWorkloadItem() (*AzureVMWorkloadSAPAseSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLInstanceWorkloadItem.
func (avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem) AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem() (*AzureVMWorkloadSAPHanaDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLInstanceWorkloadItem.
func (avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem) AsAzureVMWorkloadSAPHanaSystemWorkloadItem() (*AzureVMWorkloadSAPHanaSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLInstanceWorkloadItem.
func (avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem) AsAzureVMWorkloadSQLDatabaseWorkloadItem() (*AzureVMWorkloadSQLDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLInstanceWorkloadItem.
func (avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem) AsAzureVMWorkloadSQLInstanceWorkloadItem() (*AzureVMWorkloadSQLInstanceWorkloadItem, bool) {
	return &avwsiwi, true
}

// AsWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLInstanceWorkloadItem.
func (avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem) AsWorkloadItem() (*WorkloadItem, bool) {
	return nil, false
}

// AsBasicWorkloadItem is the BasicWorkloadItem implementation for AzureVMWorkloadSQLInstanceWorkloadItem.
func (avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem) AsBasicWorkloadItem() (BasicWorkloadItem, bool) {
	return &avwsiwi, true
}

// BasicAzureWorkloadAutoProtectionIntent azure Recovery Services Vault specific protection intent item.
type BasicAzureWorkloadAutoProtectionIntent interface {
	AsAzureWorkloadSQLAutoProtectionIntent() (*AzureWorkloadSQLAutoProtectionIntent, bool)
	AsAzureWorkloadAutoProtectionIntent() (*AzureWorkloadAutoProtectionIntent, bool)
}

// AzureWorkloadAutoProtectionIntent azure Recovery Services Vault specific protection intent item.
type AzureWorkloadAutoProtectionIntent struct {
	// BackupManagementType - Type of backup management for the backed up item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// SourceResourceID - ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// ItemID - ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
	ItemID *string `json:"itemId,omitempty"`
	// PolicyID - ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`
	// ProtectionState - Backup state of this backup item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectionIntentItemType - Possible values include: 'ProtectionIntentItemTypeProtectionIntent', 'ProtectionIntentItemTypeRecoveryServiceVaultItem', 'ProtectionIntentItemTypeAzureResourceItem', 'ProtectionIntentItemTypeAzureWorkloadAutoProtectionIntent', 'ProtectionIntentItemTypeAzureWorkloadSQLAutoProtectionIntent'
	ProtectionIntentItemType ProtectionIntentItemType `json:"protectionIntentItemType,omitempty"`
}

func unmarshalBasicAzureWorkloadAutoProtectionIntent(body []byte) (BasicAzureWorkloadAutoProtectionIntent, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["protectionIntentItemType"] {
	case string(ProtectionIntentItemTypeAzureWorkloadSQLAutoProtectionIntent):
		var awsapi AzureWorkloadSQLAutoProtectionIntent
		err := json.Unmarshal(body, &awsapi)
		return awsapi, err
	default:
		var awapi AzureWorkloadAutoProtectionIntent
		err := json.Unmarshal(body, &awapi)
		return awapi, err
	}
}
func unmarshalBasicAzureWorkloadAutoProtectionIntentArray(body []byte) ([]BasicAzureWorkloadAutoProtectionIntent, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	awapiArray := make([]BasicAzureWorkloadAutoProtectionIntent, len(rawMessages))

	for index, rawMessage := range rawMessages {
		awapi, err := unmarshalBasicAzureWorkloadAutoProtectionIntent(*rawMessage)
		if err != nil {
			return nil, err
		}
		awapiArray[index] = awapi
	}
	return awapiArray, nil
}

// MarshalJSON is the custom marshaler for AzureWorkloadAutoProtectionIntent.
func (awapi AzureWorkloadAutoProtectionIntent) MarshalJSON() ([]byte, error) {
	awapi.ProtectionIntentItemType = ProtectionIntentItemTypeAzureWorkloadAutoProtectionIntent
	objectMap := make(map[string]interface{})
	if awapi.BackupManagementType != "" {
		objectMap["backupManagementType"] = awapi.BackupManagementType
	}
	if awapi.SourceResourceID != nil {
		objectMap["sourceResourceId"] = awapi.SourceResourceID
	}
	if awapi.ItemID != nil {
		objectMap["itemId"] = awapi.ItemID
	}
	if awapi.PolicyID != nil {
		objectMap["policyId"] = awapi.PolicyID
	}
	if awapi.ProtectionState != "" {
		objectMap["protectionState"] = awapi.ProtectionState
	}
	if awapi.ProtectionIntentItemType != "" {
		objectMap["protectionIntentItemType"] = awapi.ProtectionIntentItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureRecoveryServiceVaultProtectionIntent is the BasicProtectionIntent implementation for AzureWorkloadAutoProtectionIntent.
func (awapi AzureWorkloadAutoProtectionIntent) AsAzureRecoveryServiceVaultProtectionIntent() (*AzureRecoveryServiceVaultProtectionIntent, bool) {
	return nil, false
}

// AsBasicAzureRecoveryServiceVaultProtectionIntent is the BasicProtectionIntent implementation for AzureWorkloadAutoProtectionIntent.
func (awapi AzureWorkloadAutoProtectionIntent) AsBasicAzureRecoveryServiceVaultProtectionIntent() (BasicAzureRecoveryServiceVaultProtectionIntent, bool) {
	return &awapi, true
}

// AsAzureResourceProtectionIntent is the BasicProtectionIntent implementation for AzureWorkloadAutoProtectionIntent.
func (awapi AzureWorkloadAutoProtectionIntent) AsAzureResourceProtectionIntent() (*AzureResourceProtectionIntent, bool) {
	return nil, false
}

// AsAzureWorkloadAutoProtectionIntent is the BasicProtectionIntent implementation for AzureWorkloadAutoProtectionIntent.
func (awapi AzureWorkloadAutoProtectionIntent) AsAzureWorkloadAutoProtectionIntent() (*AzureWorkloadAutoProtectionIntent, bool) {
	return &awapi, true
}

// AsBasicAzureWorkloadAutoProtectionIntent is the BasicProtectionIntent implementation for AzureWorkloadAutoProtectionIntent.
func (awapi AzureWorkloadAutoProtectionIntent) AsBasicAzureWorkloadAutoProtectionIntent() (BasicAzureWorkloadAutoProtectionIntent, bool) {
	return &awapi, true
}

// AsAzureWorkloadSQLAutoProtectionIntent is the BasicProtectionIntent implementation for AzureWorkloadAutoProtectionIntent.
func (awapi AzureWorkloadAutoProtectionIntent) AsAzureWorkloadSQLAutoProtectionIntent() (*AzureWorkloadSQLAutoProtectionIntent, bool) {
	return nil, false
}

// AsProtectionIntent is the BasicProtectionIntent implementation for AzureWorkloadAutoProtectionIntent.
func (awapi AzureWorkloadAutoProtectionIntent) AsProtectionIntent() (*ProtectionIntent, bool) {
	return nil, false
}

// AsBasicProtectionIntent is the BasicProtectionIntent implementation for AzureWorkloadAutoProtectionIntent.
func (awapi AzureWorkloadAutoProtectionIntent) AsBasicProtectionIntent() (BasicProtectionIntent, bool) {
	return &awapi, true
}

// AzureWorkloadBackupRequest azureWorkload workload-specific backup request.
type AzureWorkloadBackupRequest struct {
	// BackupType - Type of backup, viz. Full, Differential, Log or CopyOnlyFull. Possible values include: 'TypeEnumInvalid', 'TypeEnumFull', 'TypeEnumDifferential', 'TypeEnumLog', 'TypeEnumCopyOnlyFull'
	BackupType TypeEnum `json:"backupType,omitempty"`
	// EnableCompression - Bool for Compression setting
	EnableCompression *bool `json:"enableCompression,omitempty"`
	// RecoveryPointExpiryTimeInUTC - Backup copy will expire after the time specified (UTC).
	RecoveryPointExpiryTimeInUTC *date.Time `json:"recoveryPointExpiryTimeInUTC,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeBackupRequest', 'ObjectTypeAzureFileShareBackupRequest', 'ObjectTypeAzureWorkloadBackupRequest', 'ObjectTypeIaasVMBackupRequest'
	ObjectType ObjectTypeBasicRequest `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureWorkloadBackupRequest.
func (awbr AzureWorkloadBackupRequest) MarshalJSON() ([]byte, error) {
	awbr.ObjectType = ObjectTypeAzureWorkloadBackupRequest
	objectMap := make(map[string]interface{})
	if awbr.BackupType != "" {
		objectMap["backupType"] = awbr.BackupType
	}
	if awbr.EnableCompression != nil {
		objectMap["enableCompression"] = awbr.EnableCompression
	}
	if awbr.RecoveryPointExpiryTimeInUTC != nil {
		objectMap["recoveryPointExpiryTimeInUTC"] = awbr.RecoveryPointExpiryTimeInUTC
	}
	if awbr.ObjectType != "" {
		objectMap["objectType"] = awbr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareBackupRequest is the BasicRequest implementation for AzureWorkloadBackupRequest.
func (awbr AzureWorkloadBackupRequest) AsAzureFileShareBackupRequest() (*AzureFileShareBackupRequest, bool) {
	return nil, false
}

// AsAzureWorkloadBackupRequest is the BasicRequest implementation for AzureWorkloadBackupRequest.
func (awbr AzureWorkloadBackupRequest) AsAzureWorkloadBackupRequest() (*AzureWorkloadBackupRequest, bool) {
	return &awbr, true
}

// AsIaasVMBackupRequest is the BasicRequest implementation for AzureWorkloadBackupRequest.
func (awbr AzureWorkloadBackupRequest) AsIaasVMBackupRequest() (*IaasVMBackupRequest, bool) {
	return nil, false
}

// AsRequest is the BasicRequest implementation for AzureWorkloadBackupRequest.
func (awbr AzureWorkloadBackupRequest) AsRequest() (*Request, bool) {
	return nil, false
}

// AsBasicRequest is the BasicRequest implementation for AzureWorkloadBackupRequest.
func (awbr AzureWorkloadBackupRequest) AsBasicRequest() (BasicRequest, bool) {
	return &awbr, true
}

// BasicAzureWorkloadContainer container for the workloads running inside Azure Compute or Classic Compute.
type BasicAzureWorkloadContainer interface {
	AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool)
	AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool)
	AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool)
}

// AzureWorkloadContainer container for the workloads running inside Azure Compute or Classic Compute.
type AzureWorkloadContainer struct {
	// SourceResourceID - ARM ID of the virtual machine represented by this Azure Workload Container
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// LastUpdatedTime - Time stamp when this container was updated.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
	// ExtendedInfo - Additional details of a workload container.
	ExtendedInfo *AzureWorkloadContainerExtendedInfo `json:"extendedInfo,omitempty"`
	// WorkloadType - Workload type for which registration was sent. Possible values include: 'WorkloadTypeInvalid', 'WorkloadTypeVM', 'WorkloadTypeFileFolder', 'WorkloadTypeAzureSQLDb', 'WorkloadTypeSQLDB', 'WorkloadTypeExchange', 'WorkloadTypeSharepoint', 'WorkloadTypeVMwareVM', 'WorkloadTypeSystemState', 'WorkloadTypeClient', 'WorkloadTypeGenericDataSource', 'WorkloadTypeSQLDataBase', 'WorkloadTypeAzureFileShare', 'WorkloadTypeSAPHanaDatabase', 'WorkloadTypeSAPAseDatabase'
	WorkloadType WorkloadType `json:"workloadType,omitempty"`
	// OperationType - Re-Do Operation. Possible values include: 'OperationTypeInvalid', 'OperationTypeRegister', 'OperationTypeReregister'
	OperationType OperationType `json:"operationType,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

func unmarshalBasicAzureWorkloadContainer(body []byte) (BasicAzureWorkloadContainer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["containerType"] {
	case string(ContainerTypeSQLAGWorkLoadContainer1):
		var aswcpc AzureSQLAGWorkloadContainerProtectionContainer
		err := json.Unmarshal(body, &aswcpc)
		return aswcpc, err
	case string(ContainerTypeVMAppContainer1):
		var avacpc AzureVMAppContainerProtectionContainer
		err := json.Unmarshal(body, &avacpc)
		return avacpc, err
	default:
		var awc AzureWorkloadContainer
		err := json.Unmarshal(body, &awc)
		return awc, err
	}
}
func unmarshalBasicAzureWorkloadContainerArray(body []byte) ([]BasicAzureWorkloadContainer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	awcArray := make([]BasicAzureWorkloadContainer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		awc, err := unmarshalBasicAzureWorkloadContainer(*rawMessage)
		if err != nil {
			return nil, err
		}
		awcArray[index] = awc
	}
	return awcArray, nil
}

// MarshalJSON is the custom marshaler for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) MarshalJSON() ([]byte, error) {
	awc.ContainerType = ContainerTypeAzureWorkloadContainer
	objectMap := make(map[string]interface{})
	if awc.SourceResourceID != nil {
		objectMap["sourceResourceId"] = awc.SourceResourceID
	}
	if awc.LastUpdatedTime != nil {
		objectMap["lastUpdatedTime"] = awc.LastUpdatedTime
	}
	if awc.ExtendedInfo != nil {
		objectMap["extendedInfo"] = awc.ExtendedInfo
	}
	if awc.WorkloadType != "" {
		objectMap["workloadType"] = awc.WorkloadType
	}
	if awc.OperationType != "" {
		objectMap["operationType"] = awc.OperationType
	}
	if awc.FriendlyName != nil {
		objectMap["friendlyName"] = awc.FriendlyName
	}
	if awc.BackupManagementType != "" {
		objectMap["backupManagementType"] = awc.BackupManagementType
	}
	if awc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = awc.RegistrationStatus
	}
	if awc.HealthStatus != nil {
		objectMap["healthStatus"] = awc.HealthStatus
	}
	if awc.ContainerType != "" {
		objectMap["containerType"] = awc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return &awc, true
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return &awc, true
}

// AsDpmContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsDpmContainer() (*DpmContainer, bool) {
	return nil, false
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return nil, false
}

// AsGenericContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsGenericContainer() (*GenericContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return nil, false
}

// AsMabContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for AzureWorkloadContainer.
func (awc AzureWorkloadContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &awc, true
}

// AzureWorkloadContainerExtendedInfo extended information of the container.
type AzureWorkloadContainerExtendedInfo struct {
	// HostServerName - Host Os Name in case of Stand Alone and Cluster Name in case of distributed container.
	HostServerName *string `json:"hostServerName,omitempty"`
	// InquiryInfo - Inquiry Status for the container.
	InquiryInfo *InquiryInfo `json:"inquiryInfo,omitempty"`
	// NodesList - List of the nodes in case of distributed container.
	NodesList *[]DistributedNodesInfo `json:"nodesList,omitempty"`
}

// AzureWorkloadErrorInfo azure storage specific error information
type AzureWorkloadErrorInfo struct {
	// ErrorCode - Error code.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorString - Localized error string.
	ErrorString *string `json:"errorString,omitempty"`
	// ErrorTitle - Title: Typically, the entity that the error pertains to.
	ErrorTitle *string `json:"errorTitle,omitempty"`
	// Recommendations - List of localized recommendations for above error code.
	Recommendations *[]string `json:"recommendations,omitempty"`
	// AdditionalDetails - Additional details for above error code.
	AdditionalDetails *string `json:"additionalDetails,omitempty"`
}

// AzureWorkloadJob azure storage specific job.
type AzureWorkloadJob struct {
	// WorkloadType - Workload type of the job
	WorkloadType *string `json:"workloadType,omitempty"`
	// Duration - Time elapsed during the execution of this job.
	Duration *string `json:"duration,omitempty"`
	// ActionsInfo - Gets or sets the state/actions applicable on this job like cancel/retry.
	ActionsInfo *[]JobSupportedAction `json:"actionsInfo,omitempty"`
	// ErrorDetails - Error details on execution of this job.
	ErrorDetails *[]AzureWorkloadErrorInfo `json:"errorDetails,omitempty"`
	// ExtendedInfo - Additional information about the job.
	ExtendedInfo *AzureWorkloadJobExtendedInfo `json:"extendedInfo,omitempty"`
	// EntityFriendlyName - Friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string `json:"entityFriendlyName,omitempty"`
	// BackupManagementType - Backup management type to execute the current job. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// Operation - The operation name.
	Operation *string `json:"operation,omitempty"`
	// Status - Job status.
	Status *string `json:"status,omitempty"`
	// StartTime - The start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ActivityID - ActivityId of job.
	ActivityID *string `json:"activityId,omitempty"`
	// JobType - Possible values include: 'JobTypeJob', 'JobTypeAzureIaaSVMJob', 'JobTypeAzureStorageJob', 'JobTypeAzureWorkloadJob', 'JobTypeDpmJob', 'JobTypeMabJob'
	JobType JobType `json:"jobType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureWorkloadJob.
func (awj AzureWorkloadJob) MarshalJSON() ([]byte, error) {
	awj.JobType = JobTypeAzureWorkloadJob
	objectMap := make(map[string]interface{})
	if awj.WorkloadType != nil {
		objectMap["workloadType"] = awj.WorkloadType
	}
	if awj.Duration != nil {
		objectMap["duration"] = awj.Duration
	}
	if awj.ActionsInfo != nil {
		objectMap["actionsInfo"] = awj.ActionsInfo
	}
	if awj.ErrorDetails != nil {
		objectMap["errorDetails"] = awj.ErrorDetails
	}
	if awj.ExtendedInfo != nil {
		objectMap["extendedInfo"] = awj.ExtendedInfo
	}
	if awj.EntityFriendlyName != nil {
		objectMap["entityFriendlyName"] = awj.EntityFriendlyName
	}
	if awj.BackupManagementType != "" {
		objectMap["backupManagementType"] = awj.BackupManagementType
	}
	if awj.Operation != nil {
		objectMap["operation"] = awj.Operation
	}
	if awj.Status != nil {
		objectMap["status"] = awj.Status
	}
	if awj.StartTime != nil {
		objectMap["startTime"] = awj.StartTime
	}
	if awj.EndTime != nil {
		objectMap["endTime"] = awj.EndTime
	}
	if awj.ActivityID != nil {
		objectMap["activityId"] = awj.ActivityID
	}
	if awj.JobType != "" {
		objectMap["jobType"] = awj.JobType
	}
	return json.Marshal(objectMap)
}

// AsAzureIaaSVMJob is the BasicJob implementation for AzureWorkloadJob.
func (awj AzureWorkloadJob) AsAzureIaaSVMJob() (*AzureIaaSVMJob, bool) {
	return nil, false
}

// AsAzureStorageJob is the BasicJob implementation for AzureWorkloadJob.
func (awj AzureWorkloadJob) AsAzureStorageJob() (*AzureStorageJob, bool) {
	return nil, false
}

// AsAzureWorkloadJob is the BasicJob implementation for AzureWorkloadJob.
func (awj AzureWorkloadJob) AsAzureWorkloadJob() (*AzureWorkloadJob, bool) {
	return &awj, true
}

// AsDpmJob is the BasicJob implementation for AzureWorkloadJob.
func (awj AzureWorkloadJob) AsDpmJob() (*DpmJob, bool) {
	return nil, false
}

// AsMabJob is the BasicJob implementation for AzureWorkloadJob.
func (awj AzureWorkloadJob) AsMabJob() (*MabJob, bool) {
	return nil, false
}

// AsJob is the BasicJob implementation for AzureWorkloadJob.
func (awj AzureWorkloadJob) AsJob() (*Job, bool) {
	return nil, false
}

// AsBasicJob is the BasicJob implementation for AzureWorkloadJob.
func (awj AzureWorkloadJob) AsBasicJob() (BasicJob, bool) {
	return &awj, true
}

// AzureWorkloadJobExtendedInfo azure VM workload-specific additional information for job.
type AzureWorkloadJobExtendedInfo struct {
	// TasksList - List of tasks for this job
	TasksList *[]AzureWorkloadJobTaskDetails `json:"tasksList,omitempty"`
	// PropertyBag - Job properties.
	PropertyBag map[string]*string `json:"propertyBag"`
	// DynamicErrorMessage - Non localized error message on job execution.
	DynamicErrorMessage *string `json:"dynamicErrorMessage,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureWorkloadJobExtendedInfo.
func (awjei AzureWorkloadJobExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if awjei.TasksList != nil {
		objectMap["tasksList"] = awjei.TasksList
	}
	if awjei.PropertyBag != nil {
		objectMap["propertyBag"] = awjei.PropertyBag
	}
	if awjei.DynamicErrorMessage != nil {
		objectMap["dynamicErrorMessage"] = awjei.DynamicErrorMessage
	}
	return json.Marshal(objectMap)
}

// AzureWorkloadJobTaskDetails azure VM workload specific job task details.
type AzureWorkloadJobTaskDetails struct {
	// TaskID - The task display name.
	TaskID *string `json:"taskId,omitempty"`
	// Status - The status.
	Status *string `json:"status,omitempty"`
}

// BasicAzureWorkloadPointInTimeRecoveryPoint recovery point specific to PointInTime
type BasicAzureWorkloadPointInTimeRecoveryPoint interface {
	AsAzureWorkloadSAPHanaPointInTimeRecoveryPoint() (*AzureWorkloadSAPHanaPointInTimeRecoveryPoint, bool)
	AsAzureWorkloadPointInTimeRecoveryPoint() (*AzureWorkloadPointInTimeRecoveryPoint, bool)
}

// AzureWorkloadPointInTimeRecoveryPoint recovery point specific to PointInTime
type AzureWorkloadPointInTimeRecoveryPoint struct {
	// TimeRanges - List of log ranges
	TimeRanges *[]PointInTimeRange `json:"timeRanges,omitempty"`
	// RecoveryPointTimeInUTC - READ-ONLY; UTC time at which recovery point was created
	RecoveryPointTimeInUTC *date.Time `json:"recoveryPointTimeInUTC,omitempty"`
	// Type - READ-ONLY; Type of restore point. Possible values include: 'RestorePointTypeInvalid', 'RestorePointTypeFull', 'RestorePointTypeLog', 'RestorePointTypeDifferential'
	Type RestorePointType `json:"type,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeRecoveryPoint', 'ObjectTypeAzureFileShareRecoveryPoint', 'ObjectTypeAzureWorkloadPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadRecoveryPoint', 'ObjectTypeAzureWorkloadSAPHanaPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadSAPHanaRecoveryPoint', 'ObjectTypeAzureWorkloadSQLPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadSQLRecoveryPoint', 'ObjectTypeGenericRecoveryPoint', 'ObjectTypeIaasVMRecoveryPoint'
	ObjectType ObjectTypeBasicRecoveryPoint `json:"objectType,omitempty"`
}

func unmarshalBasicAzureWorkloadPointInTimeRecoveryPoint(body []byte) (BasicAzureWorkloadPointInTimeRecoveryPoint, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeAzureWorkloadSAPHanaPointInTimeRecoveryPoint):
		var awshpitrp AzureWorkloadSAPHanaPointInTimeRecoveryPoint
		err := json.Unmarshal(body, &awshpitrp)
		return awshpitrp, err
	default:
		var awpitrp AzureWorkloadPointInTimeRecoveryPoint
		err := json.Unmarshal(body, &awpitrp)
		return awpitrp, err
	}
}
func unmarshalBasicAzureWorkloadPointInTimeRecoveryPointArray(body []byte) ([]BasicAzureWorkloadPointInTimeRecoveryPoint, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	awpitrpArray := make([]BasicAzureWorkloadPointInTimeRecoveryPoint, len(rawMessages))

	for index, rawMessage := range rawMessages {
		awpitrp, err := unmarshalBasicAzureWorkloadPointInTimeRecoveryPoint(*rawMessage)
		if err != nil {
			return nil, err
		}
		awpitrpArray[index] = awpitrp
	}
	return awpitrpArray, nil
}

// MarshalJSON is the custom marshaler for AzureWorkloadPointInTimeRecoveryPoint.
func (awpitrp AzureWorkloadPointInTimeRecoveryPoint) MarshalJSON() ([]byte, error) {
	awpitrp.ObjectType = ObjectTypeAzureWorkloadPointInTimeRecoveryPoint
	objectMap := make(map[string]interface{})
	if awpitrp.TimeRanges != nil {
		objectMap["timeRanges"] = awpitrp.TimeRanges
	}
	if awpitrp.ObjectType != "" {
		objectMap["objectType"] = awpitrp.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadPointInTimeRecoveryPoint.
func (awpitrp AzureWorkloadPointInTimeRecoveryPoint) AsAzureFileShareRecoveryPoint() (*AzureFileShareRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadPointInTimeRecoveryPoint.
func (awpitrp AzureWorkloadPointInTimeRecoveryPoint) AsAzureWorkloadPointInTimeRecoveryPoint() (*AzureWorkloadPointInTimeRecoveryPoint, bool) {
	return &awpitrp, true
}

// AsBasicAzureWorkloadPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadPointInTimeRecoveryPoint.
func (awpitrp AzureWorkloadPointInTimeRecoveryPoint) AsBasicAzureWorkloadPointInTimeRecoveryPoint() (BasicAzureWorkloadPointInTimeRecoveryPoint, bool) {
	return &awpitrp, true
}

// AsAzureWorkloadRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadPointInTimeRecoveryPoint.
func (awpitrp AzureWorkloadPointInTimeRecoveryPoint) AsAzureWorkloadRecoveryPoint() (*AzureWorkloadRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadPointInTimeRecoveryPoint.
func (awpitrp AzureWorkloadPointInTimeRecoveryPoint) AsBasicAzureWorkloadRecoveryPoint() (BasicAzureWorkloadRecoveryPoint, bool) {
	return &awpitrp, true
}

// AsAzureWorkloadSAPHanaPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadPointInTimeRecoveryPoint.
func (awpitrp AzureWorkloadPointInTimeRecoveryPoint) AsAzureWorkloadSAPHanaPointInTimeRecoveryPoint() (*AzureWorkloadSAPHanaPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSAPHanaRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadPointInTimeRecoveryPoint.
func (awpitrp AzureWorkloadPointInTimeRecoveryPoint) AsAzureWorkloadSAPHanaRecoveryPoint() (*AzureWorkloadSAPHanaRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSQLPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadPointInTimeRecoveryPoint.
func (awpitrp AzureWorkloadPointInTimeRecoveryPoint) AsAzureWorkloadSQLPointInTimeRecoveryPoint() (*AzureWorkloadSQLPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSQLRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadPointInTimeRecoveryPoint.
func (awpitrp AzureWorkloadPointInTimeRecoveryPoint) AsAzureWorkloadSQLRecoveryPoint() (*AzureWorkloadSQLRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadSQLRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadPointInTimeRecoveryPoint.
func (awpitrp AzureWorkloadPointInTimeRecoveryPoint) AsBasicAzureWorkloadSQLRecoveryPoint() (BasicAzureWorkloadSQLRecoveryPoint, bool) {
	return nil, false
}

// AsGenericRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadPointInTimeRecoveryPoint.
func (awpitrp AzureWorkloadPointInTimeRecoveryPoint) AsGenericRecoveryPoint() (*GenericRecoveryPoint, bool) {
	return nil, false
}

// AsIaasVMRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadPointInTimeRecoveryPoint.
func (awpitrp AzureWorkloadPointInTimeRecoveryPoint) AsIaasVMRecoveryPoint() (*IaasVMRecoveryPoint, bool) {
	return nil, false
}

// AsRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadPointInTimeRecoveryPoint.
func (awpitrp AzureWorkloadPointInTimeRecoveryPoint) AsRecoveryPoint() (*RecoveryPoint, bool) {
	return nil, false
}

// AsBasicRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadPointInTimeRecoveryPoint.
func (awpitrp AzureWorkloadPointInTimeRecoveryPoint) AsBasicRecoveryPoint() (BasicRecoveryPoint, bool) {
	return &awpitrp, true
}

// AzureWorkloadPointInTimeRestoreRequest azureWorkload SAP Hana -specific restore. Specifically for
// PointInTime/Log restore
type AzureWorkloadPointInTimeRestoreRequest struct {
	// PointInTime - PointInTime value
	PointInTime *date.Time `json:"pointInTime,omitempty"`
	// RecoveryType - Type of this recovery. Possible values include: 'RecoveryTypeInvalid', 'RecoveryTypeOriginalLocation', 'RecoveryTypeAlternateLocation', 'RecoveryTypeRestoreDisks', 'RecoveryTypeOffline'
	RecoveryType RecoveryType `json:"recoveryType,omitempty"`
	// SourceResourceID - Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// PropertyBag - Workload specific property bag.
	PropertyBag map[string]*string `json:"propertyBag"`
	// TargetInfo - Details of target database
	TargetInfo *TargetRestoreInfo `json:"targetInfo,omitempty"`
	// RecoveryMode - Defines whether the current recovery mode is file restore or database restore. Possible values include: 'RecoveryModeInvalid', 'RecoveryModeFileRecovery', 'RecoveryModeWorkloadRecovery'
	RecoveryMode RecoveryMode `json:"recoveryMode,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeRestoreRequest', 'ObjectTypeAzureFileShareRestoreRequest', 'ObjectTypeAzureWorkloadPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadRestoreRequest', 'ObjectTypeAzureWorkloadSAPHanaPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadSAPHanaRestoreRequest', 'ObjectTypeAzureWorkloadSQLPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadSQLRestoreRequest', 'ObjectTypeIaasVMRestoreRequest'
	ObjectType ObjectTypeBasicRestoreRequest `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureWorkloadPointInTimeRestoreRequest.
func (awpitrr AzureWorkloadPointInTimeRestoreRequest) MarshalJSON() ([]byte, error) {
	awpitrr.ObjectType = ObjectTypeAzureWorkloadPointInTimeRestoreRequest
	objectMap := make(map[string]interface{})
	if awpitrr.PointInTime != nil {
		objectMap["pointInTime"] = awpitrr.PointInTime
	}
	if awpitrr.RecoveryType != "" {
		objectMap["recoveryType"] = awpitrr.RecoveryType
	}
	if awpitrr.SourceResourceID != nil {
		objectMap["sourceResourceId"] = awpitrr.SourceResourceID
	}
	if awpitrr.PropertyBag != nil {
		objectMap["propertyBag"] = awpitrr.PropertyBag
	}
	if awpitrr.TargetInfo != nil {
		objectMap["targetInfo"] = awpitrr.TargetInfo
	}
	if awpitrr.RecoveryMode != "" {
		objectMap["recoveryMode"] = awpitrr.RecoveryMode
	}
	if awpitrr.ObjectType != "" {
		objectMap["objectType"] = awpitrr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadPointInTimeRestoreRequest.
func (awpitrr AzureWorkloadPointInTimeRestoreRequest) AsAzureFileShareRestoreRequest() (*AzureFileShareRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadPointInTimeRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadPointInTimeRestoreRequest.
func (awpitrr AzureWorkloadPointInTimeRestoreRequest) AsAzureWorkloadPointInTimeRestoreRequest() (*AzureWorkloadPointInTimeRestoreRequest, bool) {
	return &awpitrr, true
}

// AsAzureWorkloadRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadPointInTimeRestoreRequest.
func (awpitrr AzureWorkloadPointInTimeRestoreRequest) AsAzureWorkloadRestoreRequest() (*AzureWorkloadRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureWorkloadRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadPointInTimeRestoreRequest.
func (awpitrr AzureWorkloadPointInTimeRestoreRequest) AsBasicAzureWorkloadRestoreRequest() (BasicAzureWorkloadRestoreRequest, bool) {
	return &awpitrr, true
}

// AsAzureWorkloadSAPHanaPointInTimeRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadPointInTimeRestoreRequest.
func (awpitrr AzureWorkloadPointInTimeRestoreRequest) AsAzureWorkloadSAPHanaPointInTimeRestoreRequest() (*AzureWorkloadSAPHanaPointInTimeRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSAPHanaRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadPointInTimeRestoreRequest.
func (awpitrr AzureWorkloadPointInTimeRestoreRequest) AsAzureWorkloadSAPHanaRestoreRequest() (*AzureWorkloadSAPHanaRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureWorkloadSAPHanaRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadPointInTimeRestoreRequest.
func (awpitrr AzureWorkloadPointInTimeRestoreRequest) AsBasicAzureWorkloadSAPHanaRestoreRequest() (BasicAzureWorkloadSAPHanaRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSQLPointInTimeRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadPointInTimeRestoreRequest.
func (awpitrr AzureWorkloadPointInTimeRestoreRequest) AsAzureWorkloadSQLPointInTimeRestoreRequest() (*AzureWorkloadSQLPointInTimeRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSQLRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadPointInTimeRestoreRequest.
func (awpitrr AzureWorkloadPointInTimeRestoreRequest) AsAzureWorkloadSQLRestoreRequest() (*AzureWorkloadSQLRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureWorkloadSQLRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadPointInTimeRestoreRequest.
func (awpitrr AzureWorkloadPointInTimeRestoreRequest) AsBasicAzureWorkloadSQLRestoreRequest() (BasicAzureWorkloadSQLRestoreRequest, bool) {
	return nil, false
}

// AsIaasVMRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadPointInTimeRestoreRequest.
func (awpitrr AzureWorkloadPointInTimeRestoreRequest) AsIaasVMRestoreRequest() (*IaasVMRestoreRequest, bool) {
	return nil, false
}

// AsRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadPointInTimeRestoreRequest.
func (awpitrr AzureWorkloadPointInTimeRestoreRequest) AsRestoreRequest() (*RestoreRequest, bool) {
	return nil, false
}

// AsBasicRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadPointInTimeRestoreRequest.
func (awpitrr AzureWorkloadPointInTimeRestoreRequest) AsBasicRestoreRequest() (BasicRestoreRequest, bool) {
	return &awpitrr, true
}

// BasicAzureWorkloadRecoveryPoint workload specific recovery point, specifically encapsulates full/diff recovery point
type BasicAzureWorkloadRecoveryPoint interface {
	AsAzureWorkloadPointInTimeRecoveryPoint() (*AzureWorkloadPointInTimeRecoveryPoint, bool)
	AsBasicAzureWorkloadPointInTimeRecoveryPoint() (BasicAzureWorkloadPointInTimeRecoveryPoint, bool)
	AsAzureWorkloadSAPHanaPointInTimeRecoveryPoint() (*AzureWorkloadSAPHanaPointInTimeRecoveryPoint, bool)
	AsAzureWorkloadSAPHanaRecoveryPoint() (*AzureWorkloadSAPHanaRecoveryPoint, bool)
	AsAzureWorkloadSQLPointInTimeRecoveryPoint() (*AzureWorkloadSQLPointInTimeRecoveryPoint, bool)
	AsAzureWorkloadSQLRecoveryPoint() (*AzureWorkloadSQLRecoveryPoint, bool)
	AsBasicAzureWorkloadSQLRecoveryPoint() (BasicAzureWorkloadSQLRecoveryPoint, bool)
	AsAzureWorkloadRecoveryPoint() (*AzureWorkloadRecoveryPoint, bool)
}

// AzureWorkloadRecoveryPoint workload specific recovery point, specifically encapsulates full/diff recovery
// point
type AzureWorkloadRecoveryPoint struct {
	// RecoveryPointTimeInUTC - READ-ONLY; UTC time at which recovery point was created
	RecoveryPointTimeInUTC *date.Time `json:"recoveryPointTimeInUTC,omitempty"`
	// Type - READ-ONLY; Type of restore point. Possible values include: 'RestorePointTypeInvalid', 'RestorePointTypeFull', 'RestorePointTypeLog', 'RestorePointTypeDifferential'
	Type RestorePointType `json:"type,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeRecoveryPoint', 'ObjectTypeAzureFileShareRecoveryPoint', 'ObjectTypeAzureWorkloadPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadRecoveryPoint', 'ObjectTypeAzureWorkloadSAPHanaPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadSAPHanaRecoveryPoint', 'ObjectTypeAzureWorkloadSQLPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadSQLRecoveryPoint', 'ObjectTypeGenericRecoveryPoint', 'ObjectTypeIaasVMRecoveryPoint'
	ObjectType ObjectTypeBasicRecoveryPoint `json:"objectType,omitempty"`
}

func unmarshalBasicAzureWorkloadRecoveryPoint(body []byte) (BasicAzureWorkloadRecoveryPoint, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeAzureWorkloadPointInTimeRecoveryPoint):
		var awpitrp AzureWorkloadPointInTimeRecoveryPoint
		err := json.Unmarshal(body, &awpitrp)
		return awpitrp, err
	case string(ObjectTypeAzureWorkloadSAPHanaPointInTimeRecoveryPoint):
		var awshpitrp AzureWorkloadSAPHanaPointInTimeRecoveryPoint
		err := json.Unmarshal(body, &awshpitrp)
		return awshpitrp, err
	case string(ObjectTypeAzureWorkloadSAPHanaRecoveryPoint):
		var awshrp AzureWorkloadSAPHanaRecoveryPoint
		err := json.Unmarshal(body, &awshrp)
		return awshrp, err
	case string(ObjectTypeAzureWorkloadSQLPointInTimeRecoveryPoint):
		var awspitrp AzureWorkloadSQLPointInTimeRecoveryPoint
		err := json.Unmarshal(body, &awspitrp)
		return awspitrp, err
	case string(ObjectTypeAzureWorkloadSQLRecoveryPoint):
		var awsrp AzureWorkloadSQLRecoveryPoint
		err := json.Unmarshal(body, &awsrp)
		return awsrp, err
	default:
		var awrp AzureWorkloadRecoveryPoint
		err := json.Unmarshal(body, &awrp)
		return awrp, err
	}
}
func unmarshalBasicAzureWorkloadRecoveryPointArray(body []byte) ([]BasicAzureWorkloadRecoveryPoint, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	awrpArray := make([]BasicAzureWorkloadRecoveryPoint, len(rawMessages))

	for index, rawMessage := range rawMessages {
		awrp, err := unmarshalBasicAzureWorkloadRecoveryPoint(*rawMessage)
		if err != nil {
			return nil, err
		}
		awrpArray[index] = awrp
	}
	return awrpArray, nil
}

// MarshalJSON is the custom marshaler for AzureWorkloadRecoveryPoint.
func (awrp AzureWorkloadRecoveryPoint) MarshalJSON() ([]byte, error) {
	awrp.ObjectType = ObjectTypeAzureWorkloadRecoveryPoint
	objectMap := make(map[string]interface{})
	if awrp.ObjectType != "" {
		objectMap["objectType"] = awrp.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadRecoveryPoint.
func (awrp AzureWorkloadRecoveryPoint) AsAzureFileShareRecoveryPoint() (*AzureFileShareRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadRecoveryPoint.
func (awrp AzureWorkloadRecoveryPoint) AsAzureWorkloadPointInTimeRecoveryPoint() (*AzureWorkloadPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadRecoveryPoint.
func (awrp AzureWorkloadRecoveryPoint) AsBasicAzureWorkloadPointInTimeRecoveryPoint() (BasicAzureWorkloadPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadRecoveryPoint.
func (awrp AzureWorkloadRecoveryPoint) AsAzureWorkloadRecoveryPoint() (*AzureWorkloadRecoveryPoint, bool) {
	return &awrp, true
}

// AsBasicAzureWorkloadRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadRecoveryPoint.
func (awrp AzureWorkloadRecoveryPoint) AsBasicAzureWorkloadRecoveryPoint() (BasicAzureWorkloadRecoveryPoint, bool) {
	return &awrp, true
}

// AsAzureWorkloadSAPHanaPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadRecoveryPoint.
func (awrp AzureWorkloadRecoveryPoint) AsAzureWorkloadSAPHanaPointInTimeRecoveryPoint() (*AzureWorkloadSAPHanaPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSAPHanaRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadRecoveryPoint.
func (awrp AzureWorkloadRecoveryPoint) AsAzureWorkloadSAPHanaRecoveryPoint() (*AzureWorkloadSAPHanaRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSQLPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadRecoveryPoint.
func (awrp AzureWorkloadRecoveryPoint) AsAzureWorkloadSQLPointInTimeRecoveryPoint() (*AzureWorkloadSQLPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSQLRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadRecoveryPoint.
func (awrp AzureWorkloadRecoveryPoint) AsAzureWorkloadSQLRecoveryPoint() (*AzureWorkloadSQLRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadSQLRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadRecoveryPoint.
func (awrp AzureWorkloadRecoveryPoint) AsBasicAzureWorkloadSQLRecoveryPoint() (BasicAzureWorkloadSQLRecoveryPoint, bool) {
	return nil, false
}

// AsGenericRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadRecoveryPoint.
func (awrp AzureWorkloadRecoveryPoint) AsGenericRecoveryPoint() (*GenericRecoveryPoint, bool) {
	return nil, false
}

// AsIaasVMRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadRecoveryPoint.
func (awrp AzureWorkloadRecoveryPoint) AsIaasVMRecoveryPoint() (*IaasVMRecoveryPoint, bool) {
	return nil, false
}

// AsRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadRecoveryPoint.
func (awrp AzureWorkloadRecoveryPoint) AsRecoveryPoint() (*RecoveryPoint, bool) {
	return nil, false
}

// AsBasicRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadRecoveryPoint.
func (awrp AzureWorkloadRecoveryPoint) AsBasicRecoveryPoint() (BasicRecoveryPoint, bool) {
	return &awrp, true
}

// BasicAzureWorkloadRestoreRequest azureWorkload-specific restore.
type BasicAzureWorkloadRestoreRequest interface {
	AsAzureWorkloadPointInTimeRestoreRequest() (*AzureWorkloadPointInTimeRestoreRequest, bool)
	AsAzureWorkloadSAPHanaPointInTimeRestoreRequest() (*AzureWorkloadSAPHanaPointInTimeRestoreRequest, bool)
	AsAzureWorkloadSAPHanaRestoreRequest() (*AzureWorkloadSAPHanaRestoreRequest, bool)
	AsBasicAzureWorkloadSAPHanaRestoreRequest() (BasicAzureWorkloadSAPHanaRestoreRequest, bool)
	AsAzureWorkloadSQLPointInTimeRestoreRequest() (*AzureWorkloadSQLPointInTimeRestoreRequest, bool)
	AsAzureWorkloadSQLRestoreRequest() (*AzureWorkloadSQLRestoreRequest, bool)
	AsBasicAzureWorkloadSQLRestoreRequest() (BasicAzureWorkloadSQLRestoreRequest, bool)
	AsAzureWorkloadRestoreRequest() (*AzureWorkloadRestoreRequest, bool)
}

// AzureWorkloadRestoreRequest azureWorkload-specific restore.
type AzureWorkloadRestoreRequest struct {
	// RecoveryType - Type of this recovery. Possible values include: 'RecoveryTypeInvalid', 'RecoveryTypeOriginalLocation', 'RecoveryTypeAlternateLocation', 'RecoveryTypeRestoreDisks', 'RecoveryTypeOffline'
	RecoveryType RecoveryType `json:"recoveryType,omitempty"`
	// SourceResourceID - Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// PropertyBag - Workload specific property bag.
	PropertyBag map[string]*string `json:"propertyBag"`
	// TargetInfo - Details of target database
	TargetInfo *TargetRestoreInfo `json:"targetInfo,omitempty"`
	// RecoveryMode - Defines whether the current recovery mode is file restore or database restore. Possible values include: 'RecoveryModeInvalid', 'RecoveryModeFileRecovery', 'RecoveryModeWorkloadRecovery'
	RecoveryMode RecoveryMode `json:"recoveryMode,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeRestoreRequest', 'ObjectTypeAzureFileShareRestoreRequest', 'ObjectTypeAzureWorkloadPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadRestoreRequest', 'ObjectTypeAzureWorkloadSAPHanaPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadSAPHanaRestoreRequest', 'ObjectTypeAzureWorkloadSQLPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadSQLRestoreRequest', 'ObjectTypeIaasVMRestoreRequest'
	ObjectType ObjectTypeBasicRestoreRequest `json:"objectType,omitempty"`
}

func unmarshalBasicAzureWorkloadRestoreRequest(body []byte) (BasicAzureWorkloadRestoreRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeAzureWorkloadPointInTimeRestoreRequest):
		var awpitrr AzureWorkloadPointInTimeRestoreRequest
		err := json.Unmarshal(body, &awpitrr)
		return awpitrr, err
	case string(ObjectTypeAzureWorkloadSAPHanaPointInTimeRestoreRequest):
		var awshpitrr AzureWorkloadSAPHanaPointInTimeRestoreRequest
		err := json.Unmarshal(body, &awshpitrr)
		return awshpitrr, err
	case string(ObjectTypeAzureWorkloadSAPHanaRestoreRequest):
		var awshrr AzureWorkloadSAPHanaRestoreRequest
		err := json.Unmarshal(body, &awshrr)
		return awshrr, err
	case string(ObjectTypeAzureWorkloadSQLPointInTimeRestoreRequest):
		var awspitrr AzureWorkloadSQLPointInTimeRestoreRequest
		err := json.Unmarshal(body, &awspitrr)
		return awspitrr, err
	case string(ObjectTypeAzureWorkloadSQLRestoreRequest):
		var awsrr AzureWorkloadSQLRestoreRequest
		err := json.Unmarshal(body, &awsrr)
		return awsrr, err
	default:
		var awrr AzureWorkloadRestoreRequest
		err := json.Unmarshal(body, &awrr)
		return awrr, err
	}
}
func unmarshalBasicAzureWorkloadRestoreRequestArray(body []byte) ([]BasicAzureWorkloadRestoreRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	awrrArray := make([]BasicAzureWorkloadRestoreRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		awrr, err := unmarshalBasicAzureWorkloadRestoreRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		awrrArray[index] = awrr
	}
	return awrrArray, nil
}

// MarshalJSON is the custom marshaler for AzureWorkloadRestoreRequest.
func (awrr AzureWorkloadRestoreRequest) MarshalJSON() ([]byte, error) {
	awrr.ObjectType = ObjectTypeAzureWorkloadRestoreRequest
	objectMap := make(map[string]interface{})
	if awrr.RecoveryType != "" {
		objectMap["recoveryType"] = awrr.RecoveryType
	}
	if awrr.SourceResourceID != nil {
		objectMap["sourceResourceId"] = awrr.SourceResourceID
	}
	if awrr.PropertyBag != nil {
		objectMap["propertyBag"] = awrr.PropertyBag
	}
	if awrr.TargetInfo != nil {
		objectMap["targetInfo"] = awrr.TargetInfo
	}
	if awrr.RecoveryMode != "" {
		objectMap["recoveryMode"] = awrr.RecoveryMode
	}
	if awrr.ObjectType != "" {
		objectMap["objectType"] = awrr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadRestoreRequest.
func (awrr AzureWorkloadRestoreRequest) AsAzureFileShareRestoreRequest() (*AzureFileShareRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadPointInTimeRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadRestoreRequest.
func (awrr AzureWorkloadRestoreRequest) AsAzureWorkloadPointInTimeRestoreRequest() (*AzureWorkloadPointInTimeRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadRestoreRequest.
func (awrr AzureWorkloadRestoreRequest) AsAzureWorkloadRestoreRequest() (*AzureWorkloadRestoreRequest, bool) {
	return &awrr, true
}

// AsBasicAzureWorkloadRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadRestoreRequest.
func (awrr AzureWorkloadRestoreRequest) AsBasicAzureWorkloadRestoreRequest() (BasicAzureWorkloadRestoreRequest, bool) {
	return &awrr, true
}

// AsAzureWorkloadSAPHanaPointInTimeRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadRestoreRequest.
func (awrr AzureWorkloadRestoreRequest) AsAzureWorkloadSAPHanaPointInTimeRestoreRequest() (*AzureWorkloadSAPHanaPointInTimeRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSAPHanaRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadRestoreRequest.
func (awrr AzureWorkloadRestoreRequest) AsAzureWorkloadSAPHanaRestoreRequest() (*AzureWorkloadSAPHanaRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureWorkloadSAPHanaRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadRestoreRequest.
func (awrr AzureWorkloadRestoreRequest) AsBasicAzureWorkloadSAPHanaRestoreRequest() (BasicAzureWorkloadSAPHanaRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSQLPointInTimeRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadRestoreRequest.
func (awrr AzureWorkloadRestoreRequest) AsAzureWorkloadSQLPointInTimeRestoreRequest() (*AzureWorkloadSQLPointInTimeRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSQLRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadRestoreRequest.
func (awrr AzureWorkloadRestoreRequest) AsAzureWorkloadSQLRestoreRequest() (*AzureWorkloadSQLRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureWorkloadSQLRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadRestoreRequest.
func (awrr AzureWorkloadRestoreRequest) AsBasicAzureWorkloadSQLRestoreRequest() (BasicAzureWorkloadSQLRestoreRequest, bool) {
	return nil, false
}

// AsIaasVMRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadRestoreRequest.
func (awrr AzureWorkloadRestoreRequest) AsIaasVMRestoreRequest() (*IaasVMRestoreRequest, bool) {
	return nil, false
}

// AsRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadRestoreRequest.
func (awrr AzureWorkloadRestoreRequest) AsRestoreRequest() (*RestoreRequest, bool) {
	return nil, false
}

// AsBasicRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadRestoreRequest.
func (awrr AzureWorkloadRestoreRequest) AsBasicRestoreRequest() (BasicRestoreRequest, bool) {
	return &awrr, true
}

// AzureWorkloadSAPHanaPointInTimeRecoveryPoint recovery point specific to PointInTime in SAPHana
type AzureWorkloadSAPHanaPointInTimeRecoveryPoint struct {
	// TimeRanges - List of log ranges
	TimeRanges *[]PointInTimeRange `json:"timeRanges,omitempty"`
	// RecoveryPointTimeInUTC - READ-ONLY; UTC time at which recovery point was created
	RecoveryPointTimeInUTC *date.Time `json:"recoveryPointTimeInUTC,omitempty"`
	// Type - READ-ONLY; Type of restore point. Possible values include: 'RestorePointTypeInvalid', 'RestorePointTypeFull', 'RestorePointTypeLog', 'RestorePointTypeDifferential'
	Type RestorePointType `json:"type,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeRecoveryPoint', 'ObjectTypeAzureFileShareRecoveryPoint', 'ObjectTypeAzureWorkloadPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadRecoveryPoint', 'ObjectTypeAzureWorkloadSAPHanaPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadSAPHanaRecoveryPoint', 'ObjectTypeAzureWorkloadSQLPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadSQLRecoveryPoint', 'ObjectTypeGenericRecoveryPoint', 'ObjectTypeIaasVMRecoveryPoint'
	ObjectType ObjectTypeBasicRecoveryPoint `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureWorkloadSAPHanaPointInTimeRecoveryPoint.
func (awshpitrp AzureWorkloadSAPHanaPointInTimeRecoveryPoint) MarshalJSON() ([]byte, error) {
	awshpitrp.ObjectType = ObjectTypeAzureWorkloadSAPHanaPointInTimeRecoveryPoint
	objectMap := make(map[string]interface{})
	if awshpitrp.TimeRanges != nil {
		objectMap["timeRanges"] = awshpitrp.TimeRanges
	}
	if awshpitrp.ObjectType != "" {
		objectMap["objectType"] = awshpitrp.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaPointInTimeRecoveryPoint.
func (awshpitrp AzureWorkloadSAPHanaPointInTimeRecoveryPoint) AsAzureFileShareRecoveryPoint() (*AzureFileShareRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaPointInTimeRecoveryPoint.
func (awshpitrp AzureWorkloadSAPHanaPointInTimeRecoveryPoint) AsAzureWorkloadPointInTimeRecoveryPoint() (*AzureWorkloadPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaPointInTimeRecoveryPoint.
func (awshpitrp AzureWorkloadSAPHanaPointInTimeRecoveryPoint) AsBasicAzureWorkloadPointInTimeRecoveryPoint() (BasicAzureWorkloadPointInTimeRecoveryPoint, bool) {
	return &awshpitrp, true
}

// AsAzureWorkloadRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaPointInTimeRecoveryPoint.
func (awshpitrp AzureWorkloadSAPHanaPointInTimeRecoveryPoint) AsAzureWorkloadRecoveryPoint() (*AzureWorkloadRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaPointInTimeRecoveryPoint.
func (awshpitrp AzureWorkloadSAPHanaPointInTimeRecoveryPoint) AsBasicAzureWorkloadRecoveryPoint() (BasicAzureWorkloadRecoveryPoint, bool) {
	return &awshpitrp, true
}

// AsAzureWorkloadSAPHanaPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaPointInTimeRecoveryPoint.
func (awshpitrp AzureWorkloadSAPHanaPointInTimeRecoveryPoint) AsAzureWorkloadSAPHanaPointInTimeRecoveryPoint() (*AzureWorkloadSAPHanaPointInTimeRecoveryPoint, bool) {
	return &awshpitrp, true
}

// AsAzureWorkloadSAPHanaRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaPointInTimeRecoveryPoint.
func (awshpitrp AzureWorkloadSAPHanaPointInTimeRecoveryPoint) AsAzureWorkloadSAPHanaRecoveryPoint() (*AzureWorkloadSAPHanaRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSQLPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaPointInTimeRecoveryPoint.
func (awshpitrp AzureWorkloadSAPHanaPointInTimeRecoveryPoint) AsAzureWorkloadSQLPointInTimeRecoveryPoint() (*AzureWorkloadSQLPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSQLRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaPointInTimeRecoveryPoint.
func (awshpitrp AzureWorkloadSAPHanaPointInTimeRecoveryPoint) AsAzureWorkloadSQLRecoveryPoint() (*AzureWorkloadSQLRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadSQLRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaPointInTimeRecoveryPoint.
func (awshpitrp AzureWorkloadSAPHanaPointInTimeRecoveryPoint) AsBasicAzureWorkloadSQLRecoveryPoint() (BasicAzureWorkloadSQLRecoveryPoint, bool) {
	return nil, false
}

// AsGenericRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaPointInTimeRecoveryPoint.
func (awshpitrp AzureWorkloadSAPHanaPointInTimeRecoveryPoint) AsGenericRecoveryPoint() (*GenericRecoveryPoint, bool) {
	return nil, false
}

// AsIaasVMRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaPointInTimeRecoveryPoint.
func (awshpitrp AzureWorkloadSAPHanaPointInTimeRecoveryPoint) AsIaasVMRecoveryPoint() (*IaasVMRecoveryPoint, bool) {
	return nil, false
}

// AsRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaPointInTimeRecoveryPoint.
func (awshpitrp AzureWorkloadSAPHanaPointInTimeRecoveryPoint) AsRecoveryPoint() (*RecoveryPoint, bool) {
	return nil, false
}

// AsBasicRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaPointInTimeRecoveryPoint.
func (awshpitrp AzureWorkloadSAPHanaPointInTimeRecoveryPoint) AsBasicRecoveryPoint() (BasicRecoveryPoint, bool) {
	return &awshpitrp, true
}

// AzureWorkloadSAPHanaPointInTimeRestoreRequest azureWorkload SAP Hana -specific restore. Specifically for
// PointInTime/Log restore
type AzureWorkloadSAPHanaPointInTimeRestoreRequest struct {
	// PointInTime - PointInTime value
	PointInTime *date.Time `json:"pointInTime,omitempty"`
	// RecoveryType - Type of this recovery. Possible values include: 'RecoveryTypeInvalid', 'RecoveryTypeOriginalLocation', 'RecoveryTypeAlternateLocation', 'RecoveryTypeRestoreDisks', 'RecoveryTypeOffline'
	RecoveryType RecoveryType `json:"recoveryType,omitempty"`
	// SourceResourceID - Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// PropertyBag - Workload specific property bag.
	PropertyBag map[string]*string `json:"propertyBag"`
	// TargetInfo - Details of target database
	TargetInfo *TargetRestoreInfo `json:"targetInfo,omitempty"`
	// RecoveryMode - Defines whether the current recovery mode is file restore or database restore. Possible values include: 'RecoveryModeInvalid', 'RecoveryModeFileRecovery', 'RecoveryModeWorkloadRecovery'
	RecoveryMode RecoveryMode `json:"recoveryMode,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeRestoreRequest', 'ObjectTypeAzureFileShareRestoreRequest', 'ObjectTypeAzureWorkloadPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadRestoreRequest', 'ObjectTypeAzureWorkloadSAPHanaPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadSAPHanaRestoreRequest', 'ObjectTypeAzureWorkloadSQLPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadSQLRestoreRequest', 'ObjectTypeIaasVMRestoreRequest'
	ObjectType ObjectTypeBasicRestoreRequest `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureWorkloadSAPHanaPointInTimeRestoreRequest.
func (awshpitrr AzureWorkloadSAPHanaPointInTimeRestoreRequest) MarshalJSON() ([]byte, error) {
	awshpitrr.ObjectType = ObjectTypeAzureWorkloadSAPHanaPointInTimeRestoreRequest
	objectMap := make(map[string]interface{})
	if awshpitrr.PointInTime != nil {
		objectMap["pointInTime"] = awshpitrr.PointInTime
	}
	if awshpitrr.RecoveryType != "" {
		objectMap["recoveryType"] = awshpitrr.RecoveryType
	}
	if awshpitrr.SourceResourceID != nil {
		objectMap["sourceResourceId"] = awshpitrr.SourceResourceID
	}
	if awshpitrr.PropertyBag != nil {
		objectMap["propertyBag"] = awshpitrr.PropertyBag
	}
	if awshpitrr.TargetInfo != nil {
		objectMap["targetInfo"] = awshpitrr.TargetInfo
	}
	if awshpitrr.RecoveryMode != "" {
		objectMap["recoveryMode"] = awshpitrr.RecoveryMode
	}
	if awshpitrr.ObjectType != "" {
		objectMap["objectType"] = awshpitrr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaPointInTimeRestoreRequest.
func (awshpitrr AzureWorkloadSAPHanaPointInTimeRestoreRequest) AsAzureFileShareRestoreRequest() (*AzureFileShareRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadPointInTimeRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaPointInTimeRestoreRequest.
func (awshpitrr AzureWorkloadSAPHanaPointInTimeRestoreRequest) AsAzureWorkloadPointInTimeRestoreRequest() (*AzureWorkloadPointInTimeRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaPointInTimeRestoreRequest.
func (awshpitrr AzureWorkloadSAPHanaPointInTimeRestoreRequest) AsAzureWorkloadRestoreRequest() (*AzureWorkloadRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureWorkloadRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaPointInTimeRestoreRequest.
func (awshpitrr AzureWorkloadSAPHanaPointInTimeRestoreRequest) AsBasicAzureWorkloadRestoreRequest() (BasicAzureWorkloadRestoreRequest, bool) {
	return &awshpitrr, true
}

// AsAzureWorkloadSAPHanaPointInTimeRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaPointInTimeRestoreRequest.
func (awshpitrr AzureWorkloadSAPHanaPointInTimeRestoreRequest) AsAzureWorkloadSAPHanaPointInTimeRestoreRequest() (*AzureWorkloadSAPHanaPointInTimeRestoreRequest, bool) {
	return &awshpitrr, true
}

// AsAzureWorkloadSAPHanaRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaPointInTimeRestoreRequest.
func (awshpitrr AzureWorkloadSAPHanaPointInTimeRestoreRequest) AsAzureWorkloadSAPHanaRestoreRequest() (*AzureWorkloadSAPHanaRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureWorkloadSAPHanaRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaPointInTimeRestoreRequest.
func (awshpitrr AzureWorkloadSAPHanaPointInTimeRestoreRequest) AsBasicAzureWorkloadSAPHanaRestoreRequest() (BasicAzureWorkloadSAPHanaRestoreRequest, bool) {
	return &awshpitrr, true
}

// AsAzureWorkloadSQLPointInTimeRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaPointInTimeRestoreRequest.
func (awshpitrr AzureWorkloadSAPHanaPointInTimeRestoreRequest) AsAzureWorkloadSQLPointInTimeRestoreRequest() (*AzureWorkloadSQLPointInTimeRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSQLRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaPointInTimeRestoreRequest.
func (awshpitrr AzureWorkloadSAPHanaPointInTimeRestoreRequest) AsAzureWorkloadSQLRestoreRequest() (*AzureWorkloadSQLRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureWorkloadSQLRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaPointInTimeRestoreRequest.
func (awshpitrr AzureWorkloadSAPHanaPointInTimeRestoreRequest) AsBasicAzureWorkloadSQLRestoreRequest() (BasicAzureWorkloadSQLRestoreRequest, bool) {
	return nil, false
}

// AsIaasVMRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaPointInTimeRestoreRequest.
func (awshpitrr AzureWorkloadSAPHanaPointInTimeRestoreRequest) AsIaasVMRestoreRequest() (*IaasVMRestoreRequest, bool) {
	return nil, false
}

// AsRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaPointInTimeRestoreRequest.
func (awshpitrr AzureWorkloadSAPHanaPointInTimeRestoreRequest) AsRestoreRequest() (*RestoreRequest, bool) {
	return nil, false
}

// AsBasicRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaPointInTimeRestoreRequest.
func (awshpitrr AzureWorkloadSAPHanaPointInTimeRestoreRequest) AsBasicRestoreRequest() (BasicRestoreRequest, bool) {
	return &awshpitrr, true
}

// AzureWorkloadSAPHanaRecoveryPoint sAPHana specific recoverypoint, specifically encapsulates full/diff
// recoverypoints
type AzureWorkloadSAPHanaRecoveryPoint struct {
	// RecoveryPointTimeInUTC - READ-ONLY; UTC time at which recovery point was created
	RecoveryPointTimeInUTC *date.Time `json:"recoveryPointTimeInUTC,omitempty"`
	// Type - READ-ONLY; Type of restore point. Possible values include: 'RestorePointTypeInvalid', 'RestorePointTypeFull', 'RestorePointTypeLog', 'RestorePointTypeDifferential'
	Type RestorePointType `json:"type,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeRecoveryPoint', 'ObjectTypeAzureFileShareRecoveryPoint', 'ObjectTypeAzureWorkloadPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadRecoveryPoint', 'ObjectTypeAzureWorkloadSAPHanaPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadSAPHanaRecoveryPoint', 'ObjectTypeAzureWorkloadSQLPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadSQLRecoveryPoint', 'ObjectTypeGenericRecoveryPoint', 'ObjectTypeIaasVMRecoveryPoint'
	ObjectType ObjectTypeBasicRecoveryPoint `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureWorkloadSAPHanaRecoveryPoint.
func (awshrp AzureWorkloadSAPHanaRecoveryPoint) MarshalJSON() ([]byte, error) {
	awshrp.ObjectType = ObjectTypeAzureWorkloadSAPHanaRecoveryPoint
	objectMap := make(map[string]interface{})
	if awshrp.ObjectType != "" {
		objectMap["objectType"] = awshrp.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaRecoveryPoint.
func (awshrp AzureWorkloadSAPHanaRecoveryPoint) AsAzureFileShareRecoveryPoint() (*AzureFileShareRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaRecoveryPoint.
func (awshrp AzureWorkloadSAPHanaRecoveryPoint) AsAzureWorkloadPointInTimeRecoveryPoint() (*AzureWorkloadPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaRecoveryPoint.
func (awshrp AzureWorkloadSAPHanaRecoveryPoint) AsBasicAzureWorkloadPointInTimeRecoveryPoint() (BasicAzureWorkloadPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaRecoveryPoint.
func (awshrp AzureWorkloadSAPHanaRecoveryPoint) AsAzureWorkloadRecoveryPoint() (*AzureWorkloadRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaRecoveryPoint.
func (awshrp AzureWorkloadSAPHanaRecoveryPoint) AsBasicAzureWorkloadRecoveryPoint() (BasicAzureWorkloadRecoveryPoint, bool) {
	return &awshrp, true
}

// AsAzureWorkloadSAPHanaPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaRecoveryPoint.
func (awshrp AzureWorkloadSAPHanaRecoveryPoint) AsAzureWorkloadSAPHanaPointInTimeRecoveryPoint() (*AzureWorkloadSAPHanaPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSAPHanaRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaRecoveryPoint.
func (awshrp AzureWorkloadSAPHanaRecoveryPoint) AsAzureWorkloadSAPHanaRecoveryPoint() (*AzureWorkloadSAPHanaRecoveryPoint, bool) {
	return &awshrp, true
}

// AsAzureWorkloadSQLPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaRecoveryPoint.
func (awshrp AzureWorkloadSAPHanaRecoveryPoint) AsAzureWorkloadSQLPointInTimeRecoveryPoint() (*AzureWorkloadSQLPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSQLRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaRecoveryPoint.
func (awshrp AzureWorkloadSAPHanaRecoveryPoint) AsAzureWorkloadSQLRecoveryPoint() (*AzureWorkloadSQLRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadSQLRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaRecoveryPoint.
func (awshrp AzureWorkloadSAPHanaRecoveryPoint) AsBasicAzureWorkloadSQLRecoveryPoint() (BasicAzureWorkloadSQLRecoveryPoint, bool) {
	return nil, false
}

// AsGenericRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaRecoveryPoint.
func (awshrp AzureWorkloadSAPHanaRecoveryPoint) AsGenericRecoveryPoint() (*GenericRecoveryPoint, bool) {
	return nil, false
}

// AsIaasVMRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaRecoveryPoint.
func (awshrp AzureWorkloadSAPHanaRecoveryPoint) AsIaasVMRecoveryPoint() (*IaasVMRecoveryPoint, bool) {
	return nil, false
}

// AsRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaRecoveryPoint.
func (awshrp AzureWorkloadSAPHanaRecoveryPoint) AsRecoveryPoint() (*RecoveryPoint, bool) {
	return nil, false
}

// AsBasicRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSAPHanaRecoveryPoint.
func (awshrp AzureWorkloadSAPHanaRecoveryPoint) AsBasicRecoveryPoint() (BasicRecoveryPoint, bool) {
	return &awshrp, true
}

// BasicAzureWorkloadSAPHanaRestoreRequest azureWorkload SAP Hana-specific restore.
type BasicAzureWorkloadSAPHanaRestoreRequest interface {
	AsAzureWorkloadSAPHanaPointInTimeRestoreRequest() (*AzureWorkloadSAPHanaPointInTimeRestoreRequest, bool)
	AsAzureWorkloadSAPHanaRestoreRequest() (*AzureWorkloadSAPHanaRestoreRequest, bool)
}

// AzureWorkloadSAPHanaRestoreRequest azureWorkload SAP Hana-specific restore.
type AzureWorkloadSAPHanaRestoreRequest struct {
	// RecoveryType - Type of this recovery. Possible values include: 'RecoveryTypeInvalid', 'RecoveryTypeOriginalLocation', 'RecoveryTypeAlternateLocation', 'RecoveryTypeRestoreDisks', 'RecoveryTypeOffline'
	RecoveryType RecoveryType `json:"recoveryType,omitempty"`
	// SourceResourceID - Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// PropertyBag - Workload specific property bag.
	PropertyBag map[string]*string `json:"propertyBag"`
	// TargetInfo - Details of target database
	TargetInfo *TargetRestoreInfo `json:"targetInfo,omitempty"`
	// RecoveryMode - Defines whether the current recovery mode is file restore or database restore. Possible values include: 'RecoveryModeInvalid', 'RecoveryModeFileRecovery', 'RecoveryModeWorkloadRecovery'
	RecoveryMode RecoveryMode `json:"recoveryMode,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeRestoreRequest', 'ObjectTypeAzureFileShareRestoreRequest', 'ObjectTypeAzureWorkloadPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadRestoreRequest', 'ObjectTypeAzureWorkloadSAPHanaPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadSAPHanaRestoreRequest', 'ObjectTypeAzureWorkloadSQLPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadSQLRestoreRequest', 'ObjectTypeIaasVMRestoreRequest'
	ObjectType ObjectTypeBasicRestoreRequest `json:"objectType,omitempty"`
}

func unmarshalBasicAzureWorkloadSAPHanaRestoreRequest(body []byte) (BasicAzureWorkloadSAPHanaRestoreRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeAzureWorkloadSAPHanaPointInTimeRestoreRequest):
		var awshpitrr AzureWorkloadSAPHanaPointInTimeRestoreRequest
		err := json.Unmarshal(body, &awshpitrr)
		return awshpitrr, err
	default:
		var awshrr AzureWorkloadSAPHanaRestoreRequest
		err := json.Unmarshal(body, &awshrr)
		return awshrr, err
	}
}
func unmarshalBasicAzureWorkloadSAPHanaRestoreRequestArray(body []byte) ([]BasicAzureWorkloadSAPHanaRestoreRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	awshrrArray := make([]BasicAzureWorkloadSAPHanaRestoreRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		awshrr, err := unmarshalBasicAzureWorkloadSAPHanaRestoreRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		awshrrArray[index] = awshrr
	}
	return awshrrArray, nil
}

// MarshalJSON is the custom marshaler for AzureWorkloadSAPHanaRestoreRequest.
func (awshrr AzureWorkloadSAPHanaRestoreRequest) MarshalJSON() ([]byte, error) {
	awshrr.ObjectType = ObjectTypeAzureWorkloadSAPHanaRestoreRequest
	objectMap := make(map[string]interface{})
	if awshrr.RecoveryType != "" {
		objectMap["recoveryType"] = awshrr.RecoveryType
	}
	if awshrr.SourceResourceID != nil {
		objectMap["sourceResourceId"] = awshrr.SourceResourceID
	}
	if awshrr.PropertyBag != nil {
		objectMap["propertyBag"] = awshrr.PropertyBag
	}
	if awshrr.TargetInfo != nil {
		objectMap["targetInfo"] = awshrr.TargetInfo
	}
	if awshrr.RecoveryMode != "" {
		objectMap["recoveryMode"] = awshrr.RecoveryMode
	}
	if awshrr.ObjectType != "" {
		objectMap["objectType"] = awshrr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaRestoreRequest.
func (awshrr AzureWorkloadSAPHanaRestoreRequest) AsAzureFileShareRestoreRequest() (*AzureFileShareRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadPointInTimeRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaRestoreRequest.
func (awshrr AzureWorkloadSAPHanaRestoreRequest) AsAzureWorkloadPointInTimeRestoreRequest() (*AzureWorkloadPointInTimeRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaRestoreRequest.
func (awshrr AzureWorkloadSAPHanaRestoreRequest) AsAzureWorkloadRestoreRequest() (*AzureWorkloadRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureWorkloadRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaRestoreRequest.
func (awshrr AzureWorkloadSAPHanaRestoreRequest) AsBasicAzureWorkloadRestoreRequest() (BasicAzureWorkloadRestoreRequest, bool) {
	return &awshrr, true
}

// AsAzureWorkloadSAPHanaPointInTimeRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaRestoreRequest.
func (awshrr AzureWorkloadSAPHanaRestoreRequest) AsAzureWorkloadSAPHanaPointInTimeRestoreRequest() (*AzureWorkloadSAPHanaPointInTimeRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSAPHanaRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaRestoreRequest.
func (awshrr AzureWorkloadSAPHanaRestoreRequest) AsAzureWorkloadSAPHanaRestoreRequest() (*AzureWorkloadSAPHanaRestoreRequest, bool) {
	return &awshrr, true
}

// AsBasicAzureWorkloadSAPHanaRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaRestoreRequest.
func (awshrr AzureWorkloadSAPHanaRestoreRequest) AsBasicAzureWorkloadSAPHanaRestoreRequest() (BasicAzureWorkloadSAPHanaRestoreRequest, bool) {
	return &awshrr, true
}

// AsAzureWorkloadSQLPointInTimeRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaRestoreRequest.
func (awshrr AzureWorkloadSAPHanaRestoreRequest) AsAzureWorkloadSQLPointInTimeRestoreRequest() (*AzureWorkloadSQLPointInTimeRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSQLRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaRestoreRequest.
func (awshrr AzureWorkloadSAPHanaRestoreRequest) AsAzureWorkloadSQLRestoreRequest() (*AzureWorkloadSQLRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureWorkloadSQLRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaRestoreRequest.
func (awshrr AzureWorkloadSAPHanaRestoreRequest) AsBasicAzureWorkloadSQLRestoreRequest() (BasicAzureWorkloadSQLRestoreRequest, bool) {
	return nil, false
}

// AsIaasVMRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaRestoreRequest.
func (awshrr AzureWorkloadSAPHanaRestoreRequest) AsIaasVMRestoreRequest() (*IaasVMRestoreRequest, bool) {
	return nil, false
}

// AsRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaRestoreRequest.
func (awshrr AzureWorkloadSAPHanaRestoreRequest) AsRestoreRequest() (*RestoreRequest, bool) {
	return nil, false
}

// AsBasicRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSAPHanaRestoreRequest.
func (awshrr AzureWorkloadSAPHanaRestoreRequest) AsBasicRestoreRequest() (BasicRestoreRequest, bool) {
	return &awshrr, true
}

// AzureWorkloadSQLAutoProtectionIntent azure Workload SQL Auto Protection intent item.
type AzureWorkloadSQLAutoProtectionIntent struct {
	// WorkloadItemType - Workload item type of the item for which intent is to be set. Possible values include: 'WorkloadItemTypeInvalid', 'WorkloadItemTypeSQLInstance', 'WorkloadItemTypeSQLDataBase', 'WorkloadItemTypeSAPHanaSystem', 'WorkloadItemTypeSAPHanaDatabase', 'WorkloadItemTypeSAPAseSystem', 'WorkloadItemTypeSAPAseDatabase'
	WorkloadItemType WorkloadItemType `json:"workloadItemType,omitempty"`
	// BackupManagementType - Type of backup management for the backed up item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// SourceResourceID - ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// ItemID - ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
	ItemID *string `json:"itemId,omitempty"`
	// PolicyID - ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`
	// ProtectionState - Backup state of this backup item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectionIntentItemType - Possible values include: 'ProtectionIntentItemTypeProtectionIntent', 'ProtectionIntentItemTypeRecoveryServiceVaultItem', 'ProtectionIntentItemTypeAzureResourceItem', 'ProtectionIntentItemTypeAzureWorkloadAutoProtectionIntent', 'ProtectionIntentItemTypeAzureWorkloadSQLAutoProtectionIntent'
	ProtectionIntentItemType ProtectionIntentItemType `json:"protectionIntentItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureWorkloadSQLAutoProtectionIntent.
func (awsapi AzureWorkloadSQLAutoProtectionIntent) MarshalJSON() ([]byte, error) {
	awsapi.ProtectionIntentItemType = ProtectionIntentItemTypeAzureWorkloadSQLAutoProtectionIntent
	objectMap := make(map[string]interface{})
	if awsapi.WorkloadItemType != "" {
		objectMap["workloadItemType"] = awsapi.WorkloadItemType
	}
	if awsapi.BackupManagementType != "" {
		objectMap["backupManagementType"] = awsapi.BackupManagementType
	}
	if awsapi.SourceResourceID != nil {
		objectMap["sourceResourceId"] = awsapi.SourceResourceID
	}
	if awsapi.ItemID != nil {
		objectMap["itemId"] = awsapi.ItemID
	}
	if awsapi.PolicyID != nil {
		objectMap["policyId"] = awsapi.PolicyID
	}
	if awsapi.ProtectionState != "" {
		objectMap["protectionState"] = awsapi.ProtectionState
	}
	if awsapi.ProtectionIntentItemType != "" {
		objectMap["protectionIntentItemType"] = awsapi.ProtectionIntentItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureRecoveryServiceVaultProtectionIntent is the BasicProtectionIntent implementation for AzureWorkloadSQLAutoProtectionIntent.
func (awsapi AzureWorkloadSQLAutoProtectionIntent) AsAzureRecoveryServiceVaultProtectionIntent() (*AzureRecoveryServiceVaultProtectionIntent, bool) {
	return nil, false
}

// AsBasicAzureRecoveryServiceVaultProtectionIntent is the BasicProtectionIntent implementation for AzureWorkloadSQLAutoProtectionIntent.
func (awsapi AzureWorkloadSQLAutoProtectionIntent) AsBasicAzureRecoveryServiceVaultProtectionIntent() (BasicAzureRecoveryServiceVaultProtectionIntent, bool) {
	return &awsapi, true
}

// AsAzureResourceProtectionIntent is the BasicProtectionIntent implementation for AzureWorkloadSQLAutoProtectionIntent.
func (awsapi AzureWorkloadSQLAutoProtectionIntent) AsAzureResourceProtectionIntent() (*AzureResourceProtectionIntent, bool) {
	return nil, false
}

// AsAzureWorkloadAutoProtectionIntent is the BasicProtectionIntent implementation for AzureWorkloadSQLAutoProtectionIntent.
func (awsapi AzureWorkloadSQLAutoProtectionIntent) AsAzureWorkloadAutoProtectionIntent() (*AzureWorkloadAutoProtectionIntent, bool) {
	return nil, false
}

// AsBasicAzureWorkloadAutoProtectionIntent is the BasicProtectionIntent implementation for AzureWorkloadSQLAutoProtectionIntent.
func (awsapi AzureWorkloadSQLAutoProtectionIntent) AsBasicAzureWorkloadAutoProtectionIntent() (BasicAzureWorkloadAutoProtectionIntent, bool) {
	return &awsapi, true
}

// AsAzureWorkloadSQLAutoProtectionIntent is the BasicProtectionIntent implementation for AzureWorkloadSQLAutoProtectionIntent.
func (awsapi AzureWorkloadSQLAutoProtectionIntent) AsAzureWorkloadSQLAutoProtectionIntent() (*AzureWorkloadSQLAutoProtectionIntent, bool) {
	return &awsapi, true
}

// AsProtectionIntent is the BasicProtectionIntent implementation for AzureWorkloadSQLAutoProtectionIntent.
func (awsapi AzureWorkloadSQLAutoProtectionIntent) AsProtectionIntent() (*ProtectionIntent, bool) {
	return nil, false
}

// AsBasicProtectionIntent is the BasicProtectionIntent implementation for AzureWorkloadSQLAutoProtectionIntent.
func (awsapi AzureWorkloadSQLAutoProtectionIntent) AsBasicProtectionIntent() (BasicProtectionIntent, bool) {
	return &awsapi, true
}

// AzureWorkloadSQLPointInTimeRecoveryPoint recovery point specific to PointInTime
type AzureWorkloadSQLPointInTimeRecoveryPoint struct {
	// TimeRanges - List of log ranges
	TimeRanges *[]PointInTimeRange `json:"timeRanges,omitempty"`
	// ExtendedInfo - Extended Info that provides data directory details. Will be populated in two cases:
	// When a specific recovery point is accessed using GetRecoveryPoint
	// Or when ListRecoveryPoints is called for Log RP only with ExtendedInfo query filter
	ExtendedInfo *AzureWorkloadSQLRecoveryPointExtendedInfo `json:"extendedInfo,omitempty"`
	// RecoveryPointTimeInUTC - READ-ONLY; UTC time at which recovery point was created
	RecoveryPointTimeInUTC *date.Time `json:"recoveryPointTimeInUTC,omitempty"`
	// Type - READ-ONLY; Type of restore point. Possible values include: 'RestorePointTypeInvalid', 'RestorePointTypeFull', 'RestorePointTypeLog', 'RestorePointTypeDifferential'
	Type RestorePointType `json:"type,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeRecoveryPoint', 'ObjectTypeAzureFileShareRecoveryPoint', 'ObjectTypeAzureWorkloadPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadRecoveryPoint', 'ObjectTypeAzureWorkloadSAPHanaPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadSAPHanaRecoveryPoint', 'ObjectTypeAzureWorkloadSQLPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadSQLRecoveryPoint', 'ObjectTypeGenericRecoveryPoint', 'ObjectTypeIaasVMRecoveryPoint'
	ObjectType ObjectTypeBasicRecoveryPoint `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureWorkloadSQLPointInTimeRecoveryPoint.
func (awspitrp AzureWorkloadSQLPointInTimeRecoveryPoint) MarshalJSON() ([]byte, error) {
	awspitrp.ObjectType = ObjectTypeAzureWorkloadSQLPointInTimeRecoveryPoint
	objectMap := make(map[string]interface{})
	if awspitrp.TimeRanges != nil {
		objectMap["timeRanges"] = awspitrp.TimeRanges
	}
	if awspitrp.ExtendedInfo != nil {
		objectMap["extendedInfo"] = awspitrp.ExtendedInfo
	}
	if awspitrp.ObjectType != "" {
		objectMap["objectType"] = awspitrp.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLPointInTimeRecoveryPoint.
func (awspitrp AzureWorkloadSQLPointInTimeRecoveryPoint) AsAzureFileShareRecoveryPoint() (*AzureFileShareRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLPointInTimeRecoveryPoint.
func (awspitrp AzureWorkloadSQLPointInTimeRecoveryPoint) AsAzureWorkloadPointInTimeRecoveryPoint() (*AzureWorkloadPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLPointInTimeRecoveryPoint.
func (awspitrp AzureWorkloadSQLPointInTimeRecoveryPoint) AsBasicAzureWorkloadPointInTimeRecoveryPoint() (BasicAzureWorkloadPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLPointInTimeRecoveryPoint.
func (awspitrp AzureWorkloadSQLPointInTimeRecoveryPoint) AsAzureWorkloadRecoveryPoint() (*AzureWorkloadRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLPointInTimeRecoveryPoint.
func (awspitrp AzureWorkloadSQLPointInTimeRecoveryPoint) AsBasicAzureWorkloadRecoveryPoint() (BasicAzureWorkloadRecoveryPoint, bool) {
	return &awspitrp, true
}

// AsAzureWorkloadSAPHanaPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLPointInTimeRecoveryPoint.
func (awspitrp AzureWorkloadSQLPointInTimeRecoveryPoint) AsAzureWorkloadSAPHanaPointInTimeRecoveryPoint() (*AzureWorkloadSAPHanaPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSAPHanaRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLPointInTimeRecoveryPoint.
func (awspitrp AzureWorkloadSQLPointInTimeRecoveryPoint) AsAzureWorkloadSAPHanaRecoveryPoint() (*AzureWorkloadSAPHanaRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSQLPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLPointInTimeRecoveryPoint.
func (awspitrp AzureWorkloadSQLPointInTimeRecoveryPoint) AsAzureWorkloadSQLPointInTimeRecoveryPoint() (*AzureWorkloadSQLPointInTimeRecoveryPoint, bool) {
	return &awspitrp, true
}

// AsAzureWorkloadSQLRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLPointInTimeRecoveryPoint.
func (awspitrp AzureWorkloadSQLPointInTimeRecoveryPoint) AsAzureWorkloadSQLRecoveryPoint() (*AzureWorkloadSQLRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadSQLRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLPointInTimeRecoveryPoint.
func (awspitrp AzureWorkloadSQLPointInTimeRecoveryPoint) AsBasicAzureWorkloadSQLRecoveryPoint() (BasicAzureWorkloadSQLRecoveryPoint, bool) {
	return &awspitrp, true
}

// AsGenericRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLPointInTimeRecoveryPoint.
func (awspitrp AzureWorkloadSQLPointInTimeRecoveryPoint) AsGenericRecoveryPoint() (*GenericRecoveryPoint, bool) {
	return nil, false
}

// AsIaasVMRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLPointInTimeRecoveryPoint.
func (awspitrp AzureWorkloadSQLPointInTimeRecoveryPoint) AsIaasVMRecoveryPoint() (*IaasVMRecoveryPoint, bool) {
	return nil, false
}

// AsRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLPointInTimeRecoveryPoint.
func (awspitrp AzureWorkloadSQLPointInTimeRecoveryPoint) AsRecoveryPoint() (*RecoveryPoint, bool) {
	return nil, false
}

// AsBasicRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLPointInTimeRecoveryPoint.
func (awspitrp AzureWorkloadSQLPointInTimeRecoveryPoint) AsBasicRecoveryPoint() (BasicRecoveryPoint, bool) {
	return &awspitrp, true
}

// AzureWorkloadSQLPointInTimeRestoreRequest azureWorkload SQL -specific restore. Specifically for
// PointInTime/Log restore
type AzureWorkloadSQLPointInTimeRestoreRequest struct {
	// PointInTime - PointInTime value
	PointInTime *date.Time `json:"pointInTime,omitempty"`
	// ShouldUseAlternateTargetLocation - Default option set to true. If this is set to false, alternate data directory must be provided
	ShouldUseAlternateTargetLocation *bool `json:"shouldUseAlternateTargetLocation,omitempty"`
	// IsNonRecoverable - SQL specific property where user can chose to set no-recovery when restore operation is tried
	IsNonRecoverable *bool `json:"isNonRecoverable,omitempty"`
	// AlternateDirectoryPaths - Data directory details
	AlternateDirectoryPaths *[]SQLDataDirectoryMapping `json:"alternateDirectoryPaths,omitempty"`
	// RecoveryType - Type of this recovery. Possible values include: 'RecoveryTypeInvalid', 'RecoveryTypeOriginalLocation', 'RecoveryTypeAlternateLocation', 'RecoveryTypeRestoreDisks', 'RecoveryTypeOffline'
	RecoveryType RecoveryType `json:"recoveryType,omitempty"`
	// SourceResourceID - Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// PropertyBag - Workload specific property bag.
	PropertyBag map[string]*string `json:"propertyBag"`
	// TargetInfo - Details of target database
	TargetInfo *TargetRestoreInfo `json:"targetInfo,omitempty"`
	// RecoveryMode - Defines whether the current recovery mode is file restore or database restore. Possible values include: 'RecoveryModeInvalid', 'RecoveryModeFileRecovery', 'RecoveryModeWorkloadRecovery'
	RecoveryMode RecoveryMode `json:"recoveryMode,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeRestoreRequest', 'ObjectTypeAzureFileShareRestoreRequest', 'ObjectTypeAzureWorkloadPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadRestoreRequest', 'ObjectTypeAzureWorkloadSAPHanaPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadSAPHanaRestoreRequest', 'ObjectTypeAzureWorkloadSQLPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadSQLRestoreRequest', 'ObjectTypeIaasVMRestoreRequest'
	ObjectType ObjectTypeBasicRestoreRequest `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureWorkloadSQLPointInTimeRestoreRequest.
func (awspitrr AzureWorkloadSQLPointInTimeRestoreRequest) MarshalJSON() ([]byte, error) {
	awspitrr.ObjectType = ObjectTypeAzureWorkloadSQLPointInTimeRestoreRequest
	objectMap := make(map[string]interface{})
	if awspitrr.PointInTime != nil {
		objectMap["pointInTime"] = awspitrr.PointInTime
	}
	if awspitrr.ShouldUseAlternateTargetLocation != nil {
		objectMap["shouldUseAlternateTargetLocation"] = awspitrr.ShouldUseAlternateTargetLocation
	}
	if awspitrr.IsNonRecoverable != nil {
		objectMap["isNonRecoverable"] = awspitrr.IsNonRecoverable
	}
	if awspitrr.AlternateDirectoryPaths != nil {
		objectMap["alternateDirectoryPaths"] = awspitrr.AlternateDirectoryPaths
	}
	if awspitrr.RecoveryType != "" {
		objectMap["recoveryType"] = awspitrr.RecoveryType
	}
	if awspitrr.SourceResourceID != nil {
		objectMap["sourceResourceId"] = awspitrr.SourceResourceID
	}
	if awspitrr.PropertyBag != nil {
		objectMap["propertyBag"] = awspitrr.PropertyBag
	}
	if awspitrr.TargetInfo != nil {
		objectMap["targetInfo"] = awspitrr.TargetInfo
	}
	if awspitrr.RecoveryMode != "" {
		objectMap["recoveryMode"] = awspitrr.RecoveryMode
	}
	if awspitrr.ObjectType != "" {
		objectMap["objectType"] = awspitrr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLPointInTimeRestoreRequest.
func (awspitrr AzureWorkloadSQLPointInTimeRestoreRequest) AsAzureFileShareRestoreRequest() (*AzureFileShareRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadPointInTimeRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLPointInTimeRestoreRequest.
func (awspitrr AzureWorkloadSQLPointInTimeRestoreRequest) AsAzureWorkloadPointInTimeRestoreRequest() (*AzureWorkloadPointInTimeRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLPointInTimeRestoreRequest.
func (awspitrr AzureWorkloadSQLPointInTimeRestoreRequest) AsAzureWorkloadRestoreRequest() (*AzureWorkloadRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureWorkloadRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLPointInTimeRestoreRequest.
func (awspitrr AzureWorkloadSQLPointInTimeRestoreRequest) AsBasicAzureWorkloadRestoreRequest() (BasicAzureWorkloadRestoreRequest, bool) {
	return &awspitrr, true
}

// AsAzureWorkloadSAPHanaPointInTimeRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLPointInTimeRestoreRequest.
func (awspitrr AzureWorkloadSQLPointInTimeRestoreRequest) AsAzureWorkloadSAPHanaPointInTimeRestoreRequest() (*AzureWorkloadSAPHanaPointInTimeRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSAPHanaRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLPointInTimeRestoreRequest.
func (awspitrr AzureWorkloadSQLPointInTimeRestoreRequest) AsAzureWorkloadSAPHanaRestoreRequest() (*AzureWorkloadSAPHanaRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureWorkloadSAPHanaRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLPointInTimeRestoreRequest.
func (awspitrr AzureWorkloadSQLPointInTimeRestoreRequest) AsBasicAzureWorkloadSAPHanaRestoreRequest() (BasicAzureWorkloadSAPHanaRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSQLPointInTimeRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLPointInTimeRestoreRequest.
func (awspitrr AzureWorkloadSQLPointInTimeRestoreRequest) AsAzureWorkloadSQLPointInTimeRestoreRequest() (*AzureWorkloadSQLPointInTimeRestoreRequest, bool) {
	return &awspitrr, true
}

// AsAzureWorkloadSQLRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLPointInTimeRestoreRequest.
func (awspitrr AzureWorkloadSQLPointInTimeRestoreRequest) AsAzureWorkloadSQLRestoreRequest() (*AzureWorkloadSQLRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureWorkloadSQLRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLPointInTimeRestoreRequest.
func (awspitrr AzureWorkloadSQLPointInTimeRestoreRequest) AsBasicAzureWorkloadSQLRestoreRequest() (BasicAzureWorkloadSQLRestoreRequest, bool) {
	return &awspitrr, true
}

// AsIaasVMRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLPointInTimeRestoreRequest.
func (awspitrr AzureWorkloadSQLPointInTimeRestoreRequest) AsIaasVMRestoreRequest() (*IaasVMRestoreRequest, bool) {
	return nil, false
}

// AsRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLPointInTimeRestoreRequest.
func (awspitrr AzureWorkloadSQLPointInTimeRestoreRequest) AsRestoreRequest() (*RestoreRequest, bool) {
	return nil, false
}

// AsBasicRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLPointInTimeRestoreRequest.
func (awspitrr AzureWorkloadSQLPointInTimeRestoreRequest) AsBasicRestoreRequest() (BasicRestoreRequest, bool) {
	return &awspitrr, true
}

// BasicAzureWorkloadSQLRecoveryPoint SQL specific recoverypoint, specifically encapsulates full/diff recoverypoint
// along with extended info
type BasicAzureWorkloadSQLRecoveryPoint interface {
	AsAzureWorkloadSQLPointInTimeRecoveryPoint() (*AzureWorkloadSQLPointInTimeRecoveryPoint, bool)
	AsAzureWorkloadSQLRecoveryPoint() (*AzureWorkloadSQLRecoveryPoint, bool)
}

// AzureWorkloadSQLRecoveryPoint SQL specific recoverypoint, specifically encapsulates full/diff recoverypoint
// along with extended info
type AzureWorkloadSQLRecoveryPoint struct {
	// ExtendedInfo - Extended Info that provides data directory details. Will be populated in two cases:
	// When a specific recovery point is accessed using GetRecoveryPoint
	// Or when ListRecoveryPoints is called for Log RP only with ExtendedInfo query filter
	ExtendedInfo *AzureWorkloadSQLRecoveryPointExtendedInfo `json:"extendedInfo,omitempty"`
	// RecoveryPointTimeInUTC - READ-ONLY; UTC time at which recovery point was created
	RecoveryPointTimeInUTC *date.Time `json:"recoveryPointTimeInUTC,omitempty"`
	// Type - READ-ONLY; Type of restore point. Possible values include: 'RestorePointTypeInvalid', 'RestorePointTypeFull', 'RestorePointTypeLog', 'RestorePointTypeDifferential'
	Type RestorePointType `json:"type,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeRecoveryPoint', 'ObjectTypeAzureFileShareRecoveryPoint', 'ObjectTypeAzureWorkloadPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadRecoveryPoint', 'ObjectTypeAzureWorkloadSAPHanaPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadSAPHanaRecoveryPoint', 'ObjectTypeAzureWorkloadSQLPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadSQLRecoveryPoint', 'ObjectTypeGenericRecoveryPoint', 'ObjectTypeIaasVMRecoveryPoint'
	ObjectType ObjectTypeBasicRecoveryPoint `json:"objectType,omitempty"`
}

func unmarshalBasicAzureWorkloadSQLRecoveryPoint(body []byte) (BasicAzureWorkloadSQLRecoveryPoint, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeAzureWorkloadSQLPointInTimeRecoveryPoint):
		var awspitrp AzureWorkloadSQLPointInTimeRecoveryPoint
		err := json.Unmarshal(body, &awspitrp)
		return awspitrp, err
	default:
		var awsrp AzureWorkloadSQLRecoveryPoint
		err := json.Unmarshal(body, &awsrp)
		return awsrp, err
	}
}
func unmarshalBasicAzureWorkloadSQLRecoveryPointArray(body []byte) ([]BasicAzureWorkloadSQLRecoveryPoint, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	awsrpArray := make([]BasicAzureWorkloadSQLRecoveryPoint, len(rawMessages))

	for index, rawMessage := range rawMessages {
		awsrp, err := unmarshalBasicAzureWorkloadSQLRecoveryPoint(*rawMessage)
		if err != nil {
			return nil, err
		}
		awsrpArray[index] = awsrp
	}
	return awsrpArray, nil
}

// MarshalJSON is the custom marshaler for AzureWorkloadSQLRecoveryPoint.
func (awsrp AzureWorkloadSQLRecoveryPoint) MarshalJSON() ([]byte, error) {
	awsrp.ObjectType = ObjectTypeAzureWorkloadSQLRecoveryPoint
	objectMap := make(map[string]interface{})
	if awsrp.ExtendedInfo != nil {
		objectMap["extendedInfo"] = awsrp.ExtendedInfo
	}
	if awsrp.ObjectType != "" {
		objectMap["objectType"] = awsrp.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLRecoveryPoint.
func (awsrp AzureWorkloadSQLRecoveryPoint) AsAzureFileShareRecoveryPoint() (*AzureFileShareRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLRecoveryPoint.
func (awsrp AzureWorkloadSQLRecoveryPoint) AsAzureWorkloadPointInTimeRecoveryPoint() (*AzureWorkloadPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLRecoveryPoint.
func (awsrp AzureWorkloadSQLRecoveryPoint) AsBasicAzureWorkloadPointInTimeRecoveryPoint() (BasicAzureWorkloadPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLRecoveryPoint.
func (awsrp AzureWorkloadSQLRecoveryPoint) AsAzureWorkloadRecoveryPoint() (*AzureWorkloadRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLRecoveryPoint.
func (awsrp AzureWorkloadSQLRecoveryPoint) AsBasicAzureWorkloadRecoveryPoint() (BasicAzureWorkloadRecoveryPoint, bool) {
	return &awsrp, true
}

// AsAzureWorkloadSAPHanaPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLRecoveryPoint.
func (awsrp AzureWorkloadSQLRecoveryPoint) AsAzureWorkloadSAPHanaPointInTimeRecoveryPoint() (*AzureWorkloadSAPHanaPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSAPHanaRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLRecoveryPoint.
func (awsrp AzureWorkloadSQLRecoveryPoint) AsAzureWorkloadSAPHanaRecoveryPoint() (*AzureWorkloadSAPHanaRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSQLPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLRecoveryPoint.
func (awsrp AzureWorkloadSQLRecoveryPoint) AsAzureWorkloadSQLPointInTimeRecoveryPoint() (*AzureWorkloadSQLPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSQLRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLRecoveryPoint.
func (awsrp AzureWorkloadSQLRecoveryPoint) AsAzureWorkloadSQLRecoveryPoint() (*AzureWorkloadSQLRecoveryPoint, bool) {
	return &awsrp, true
}

// AsBasicAzureWorkloadSQLRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLRecoveryPoint.
func (awsrp AzureWorkloadSQLRecoveryPoint) AsBasicAzureWorkloadSQLRecoveryPoint() (BasicAzureWorkloadSQLRecoveryPoint, bool) {
	return &awsrp, true
}

// AsGenericRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLRecoveryPoint.
func (awsrp AzureWorkloadSQLRecoveryPoint) AsGenericRecoveryPoint() (*GenericRecoveryPoint, bool) {
	return nil, false
}

// AsIaasVMRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLRecoveryPoint.
func (awsrp AzureWorkloadSQLRecoveryPoint) AsIaasVMRecoveryPoint() (*IaasVMRecoveryPoint, bool) {
	return nil, false
}

// AsRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLRecoveryPoint.
func (awsrp AzureWorkloadSQLRecoveryPoint) AsRecoveryPoint() (*RecoveryPoint, bool) {
	return nil, false
}

// AsBasicRecoveryPoint is the BasicRecoveryPoint implementation for AzureWorkloadSQLRecoveryPoint.
func (awsrp AzureWorkloadSQLRecoveryPoint) AsBasicRecoveryPoint() (BasicRecoveryPoint, bool) {
	return &awsrp, true
}

// AzureWorkloadSQLRecoveryPointExtendedInfo extended info class details
type AzureWorkloadSQLRecoveryPointExtendedInfo struct {
	// DataDirectoryTimeInUTC - READ-ONLY; UTC time at which data directory info was captured
	DataDirectoryTimeInUTC *date.Time `json:"dataDirectoryTimeInUTC,omitempty"`
	// DataDirectoryPaths - READ-ONLY; List of data directory paths during restore operation.
	DataDirectoryPaths *[]SQLDataDirectory `json:"dataDirectoryPaths,omitempty"`
}

// BasicAzureWorkloadSQLRestoreRequest azureWorkload SQL -specific restore. Specifically for full/diff restore
type BasicAzureWorkloadSQLRestoreRequest interface {
	AsAzureWorkloadSQLPointInTimeRestoreRequest() (*AzureWorkloadSQLPointInTimeRestoreRequest, bool)
	AsAzureWorkloadSQLRestoreRequest() (*AzureWorkloadSQLRestoreRequest, bool)
}

// AzureWorkloadSQLRestoreRequest azureWorkload SQL -specific restore. Specifically for full/diff restore
type AzureWorkloadSQLRestoreRequest struct {
	// ShouldUseAlternateTargetLocation - Default option set to true. If this is set to false, alternate data directory must be provided
	ShouldUseAlternateTargetLocation *bool `json:"shouldUseAlternateTargetLocation,omitempty"`
	// IsNonRecoverable - SQL specific property where user can chose to set no-recovery when restore operation is tried
	IsNonRecoverable *bool `json:"isNonRecoverable,omitempty"`
	// AlternateDirectoryPaths - Data directory details
	AlternateDirectoryPaths *[]SQLDataDirectoryMapping `json:"alternateDirectoryPaths,omitempty"`
	// RecoveryType - Type of this recovery. Possible values include: 'RecoveryTypeInvalid', 'RecoveryTypeOriginalLocation', 'RecoveryTypeAlternateLocation', 'RecoveryTypeRestoreDisks', 'RecoveryTypeOffline'
	RecoveryType RecoveryType `json:"recoveryType,omitempty"`
	// SourceResourceID - Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// PropertyBag - Workload specific property bag.
	PropertyBag map[string]*string `json:"propertyBag"`
	// TargetInfo - Details of target database
	TargetInfo *TargetRestoreInfo `json:"targetInfo,omitempty"`
	// RecoveryMode - Defines whether the current recovery mode is file restore or database restore. Possible values include: 'RecoveryModeInvalid', 'RecoveryModeFileRecovery', 'RecoveryModeWorkloadRecovery'
	RecoveryMode RecoveryMode `json:"recoveryMode,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeRestoreRequest', 'ObjectTypeAzureFileShareRestoreRequest', 'ObjectTypeAzureWorkloadPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadRestoreRequest', 'ObjectTypeAzureWorkloadSAPHanaPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadSAPHanaRestoreRequest', 'ObjectTypeAzureWorkloadSQLPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadSQLRestoreRequest', 'ObjectTypeIaasVMRestoreRequest'
	ObjectType ObjectTypeBasicRestoreRequest `json:"objectType,omitempty"`
}

func unmarshalBasicAzureWorkloadSQLRestoreRequest(body []byte) (BasicAzureWorkloadSQLRestoreRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeAzureWorkloadSQLPointInTimeRestoreRequest):
		var awspitrr AzureWorkloadSQLPointInTimeRestoreRequest
		err := json.Unmarshal(body, &awspitrr)
		return awspitrr, err
	default:
		var awsrr AzureWorkloadSQLRestoreRequest
		err := json.Unmarshal(body, &awsrr)
		return awsrr, err
	}
}
func unmarshalBasicAzureWorkloadSQLRestoreRequestArray(body []byte) ([]BasicAzureWorkloadSQLRestoreRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	awsrrArray := make([]BasicAzureWorkloadSQLRestoreRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		awsrr, err := unmarshalBasicAzureWorkloadSQLRestoreRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		awsrrArray[index] = awsrr
	}
	return awsrrArray, nil
}

// MarshalJSON is the custom marshaler for AzureWorkloadSQLRestoreRequest.
func (awsrr AzureWorkloadSQLRestoreRequest) MarshalJSON() ([]byte, error) {
	awsrr.ObjectType = ObjectTypeAzureWorkloadSQLRestoreRequest
	objectMap := make(map[string]interface{})
	if awsrr.ShouldUseAlternateTargetLocation != nil {
		objectMap["shouldUseAlternateTargetLocation"] = awsrr.ShouldUseAlternateTargetLocation
	}
	if awsrr.IsNonRecoverable != nil {
		objectMap["isNonRecoverable"] = awsrr.IsNonRecoverable
	}
	if awsrr.AlternateDirectoryPaths != nil {
		objectMap["alternateDirectoryPaths"] = awsrr.AlternateDirectoryPaths
	}
	if awsrr.RecoveryType != "" {
		objectMap["recoveryType"] = awsrr.RecoveryType
	}
	if awsrr.SourceResourceID != nil {
		objectMap["sourceResourceId"] = awsrr.SourceResourceID
	}
	if awsrr.PropertyBag != nil {
		objectMap["propertyBag"] = awsrr.PropertyBag
	}
	if awsrr.TargetInfo != nil {
		objectMap["targetInfo"] = awsrr.TargetInfo
	}
	if awsrr.RecoveryMode != "" {
		objectMap["recoveryMode"] = awsrr.RecoveryMode
	}
	if awsrr.ObjectType != "" {
		objectMap["objectType"] = awsrr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLRestoreRequest.
func (awsrr AzureWorkloadSQLRestoreRequest) AsAzureFileShareRestoreRequest() (*AzureFileShareRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadPointInTimeRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLRestoreRequest.
func (awsrr AzureWorkloadSQLRestoreRequest) AsAzureWorkloadPointInTimeRestoreRequest() (*AzureWorkloadPointInTimeRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLRestoreRequest.
func (awsrr AzureWorkloadSQLRestoreRequest) AsAzureWorkloadRestoreRequest() (*AzureWorkloadRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureWorkloadRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLRestoreRequest.
func (awsrr AzureWorkloadSQLRestoreRequest) AsBasicAzureWorkloadRestoreRequest() (BasicAzureWorkloadRestoreRequest, bool) {
	return &awsrr, true
}

// AsAzureWorkloadSAPHanaPointInTimeRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLRestoreRequest.
func (awsrr AzureWorkloadSQLRestoreRequest) AsAzureWorkloadSAPHanaPointInTimeRestoreRequest() (*AzureWorkloadSAPHanaPointInTimeRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSAPHanaRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLRestoreRequest.
func (awsrr AzureWorkloadSQLRestoreRequest) AsAzureWorkloadSAPHanaRestoreRequest() (*AzureWorkloadSAPHanaRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureWorkloadSAPHanaRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLRestoreRequest.
func (awsrr AzureWorkloadSQLRestoreRequest) AsBasicAzureWorkloadSAPHanaRestoreRequest() (BasicAzureWorkloadSAPHanaRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSQLPointInTimeRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLRestoreRequest.
func (awsrr AzureWorkloadSQLRestoreRequest) AsAzureWorkloadSQLPointInTimeRestoreRequest() (*AzureWorkloadSQLPointInTimeRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSQLRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLRestoreRequest.
func (awsrr AzureWorkloadSQLRestoreRequest) AsAzureWorkloadSQLRestoreRequest() (*AzureWorkloadSQLRestoreRequest, bool) {
	return &awsrr, true
}

// AsBasicAzureWorkloadSQLRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLRestoreRequest.
func (awsrr AzureWorkloadSQLRestoreRequest) AsBasicAzureWorkloadSQLRestoreRequest() (BasicAzureWorkloadSQLRestoreRequest, bool) {
	return &awsrr, true
}

// AsIaasVMRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLRestoreRequest.
func (awsrr AzureWorkloadSQLRestoreRequest) AsIaasVMRestoreRequest() (*IaasVMRestoreRequest, bool) {
	return nil, false
}

// AsRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLRestoreRequest.
func (awsrr AzureWorkloadSQLRestoreRequest) AsRestoreRequest() (*RestoreRequest, bool) {
	return nil, false
}

// AsBasicRestoreRequest is the BasicRestoreRequest implementation for AzureWorkloadSQLRestoreRequest.
func (awsrr AzureWorkloadSQLRestoreRequest) AsBasicRestoreRequest() (BasicRestoreRequest, bool) {
	return &awsrr, true
}

// BEKDetails BEK is bitlocker encryption key.
type BEKDetails struct {
	// SecretURL - Secret is BEK.
	SecretURL *string `json:"secretUrl,omitempty"`
	// SecretVaultID - ID of the Key Vault where this Secret is stored.
	SecretVaultID *string `json:"secretVaultId,omitempty"`
	// SecretData - BEK data.
	SecretData *string `json:"secretData,omitempty"`
}

// BMSBackupEngineQueryObject query parameters to fetch list of backup engines.
type BMSBackupEngineQueryObject struct {
	// Expand - attribute to add extended info
	Expand *string `json:"expand,omitempty"`
}

// BMSBackupEnginesQueryObject query parameters to fetch list of backup engines.
type BMSBackupEnginesQueryObject struct {
	// BackupManagementType - Backup management type for the backup engine. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// FriendlyName - Friendly name of the backup engine.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// Expand - Attribute to add extended info.
	Expand *string `json:"expand,omitempty"`
}

// BMSBackupSummariesQueryObject query parameters to fetch backup summaries.
type BMSBackupSummariesQueryObject struct {
	// Type - Backup management type for this container. Possible values include: 'TypeInvalid', 'TypeBackupProtectedItemCountSummary', 'TypeBackupProtectionContainerCountSummary'
	Type Type `json:"type,omitempty"`
}

// BMSContainerQueryObject the query filters that can be used with the list containers API.
type BMSContainerQueryObject struct {
	// BackupManagementType - Backup management type for this container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// ContainerType - Type of container for filter. Possible values include: 'ContainerTypeInvalid', 'ContainerTypeUnknown', 'ContainerTypeIaasVMContainer', 'ContainerTypeIaasVMServiceContainer', 'ContainerTypeDPMContainer', 'ContainerTypeAzureBackupServerContainer', 'ContainerTypeMABContainer', 'ContainerTypeCluster', 'ContainerTypeAzureSQLContainer', 'ContainerTypeWindows', 'ContainerTypeVCenter', 'ContainerTypeVMAppContainer', 'ContainerTypeSQLAGWorkLoadContainer', 'ContainerTypeStorageContainer', 'ContainerTypeGenericContainer'
	ContainerType ContainerType `json:"containerType,omitempty"`
	// BackupEngineName - Backup engine name
	BackupEngineName *string `json:"backupEngineName,omitempty"`
	// FabricName - Fabric name for filter
	FabricName *string `json:"fabricName,omitempty"`
	// Status - Status of registration of this container with the Recovery Services Vault.
	Status *string `json:"status,omitempty"`
	// FriendlyName - Friendly name of this container.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// BMSContainersInquiryQueryObject the query filters that can be used with the inquire container API.
type BMSContainersInquiryQueryObject struct {
	// BackupManagementType - Backup management type for this container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// WorkloadType - Workload type for this container. Possible values include: 'WorkloadTypeInvalid', 'WorkloadTypeVM', 'WorkloadTypeFileFolder', 'WorkloadTypeAzureSQLDb', 'WorkloadTypeSQLDB', 'WorkloadTypeExchange', 'WorkloadTypeSharepoint', 'WorkloadTypeVMwareVM', 'WorkloadTypeSystemState', 'WorkloadTypeClient', 'WorkloadTypeGenericDataSource', 'WorkloadTypeSQLDataBase', 'WorkloadTypeAzureFileShare', 'WorkloadTypeSAPHanaDatabase', 'WorkloadTypeSAPAseDatabase'
	WorkloadType WorkloadType `json:"workloadType,omitempty"`
}

// BMSPOQueryObject filters to list items that can be backed up.
type BMSPOQueryObject struct {
	// BackupManagementType - Backup management type. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// WorkloadType - Workload type. Possible values include: 'WorkloadTypeInvalid', 'WorkloadTypeVM', 'WorkloadTypeFileFolder', 'WorkloadTypeAzureSQLDb', 'WorkloadTypeSQLDB', 'WorkloadTypeExchange', 'WorkloadTypeSharepoint', 'WorkloadTypeVMwareVM', 'WorkloadTypeSystemState', 'WorkloadTypeClient', 'WorkloadTypeGenericDataSource', 'WorkloadTypeSQLDataBase', 'WorkloadTypeAzureFileShare', 'WorkloadTypeSAPHanaDatabase', 'WorkloadTypeSAPAseDatabase'
	WorkloadType WorkloadType `json:"workloadType,omitempty"`
	// ContainerName - Full name of the container whose Protectable Objects should be returned.
	ContainerName *string `json:"containerName,omitempty"`
	// Status - Backup status query parameter.
	Status *string `json:"status,omitempty"`
	// FriendlyName - Friendly name.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// BMSRefreshContainersQueryObject the query filters that can be used with the refresh container API.
type BMSRefreshContainersQueryObject struct {
	// BackupManagementType - Backup management type for this container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
}

// BMSRPQueryObject filters to list backup copies.
type BMSRPQueryObject struct {
	// StartDate - Backup copies created after this time.
	StartDate *date.Time `json:"startDate,omitempty"`
	// EndDate - Backup copies created before this time.
	EndDate *date.Time `json:"endDate,omitempty"`
	// RestorePointQueryType - RestorePoint type. Possible values include: 'RestorePointQueryTypeInvalid', 'RestorePointQueryTypeFull', 'RestorePointQueryTypeLog', 'RestorePointQueryTypeDifferential', 'RestorePointQueryTypeFullAndDifferential', 'RestorePointQueryTypeAll'
	RestorePointQueryType RestorePointQueryType `json:"restorePointQueryType,omitempty"`
	// ExtendedInfo - In Get Recovery Point, it tells whether extended information about recovery point is asked.
	ExtendedInfo *bool `json:"extendedInfo,omitempty"`
}

// BMSWorkloadItemQueryObject filters to list items that can be backed up.
type BMSWorkloadItemQueryObject struct {
	// BackupManagementType - Backup management type. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// WorkloadItemType - Workload Item type. Possible values include: 'WorkloadItemTypeInvalid', 'WorkloadItemTypeSQLInstance', 'WorkloadItemTypeSQLDataBase', 'WorkloadItemTypeSAPHanaSystem', 'WorkloadItemTypeSAPHanaDatabase', 'WorkloadItemTypeSAPAseSystem', 'WorkloadItemTypeSAPAseDatabase'
	WorkloadItemType WorkloadItemType `json:"workloadItemType,omitempty"`
	// WorkloadType - Workload type. Possible values include: 'WorkloadTypeInvalid', 'WorkloadTypeVM', 'WorkloadTypeFileFolder', 'WorkloadTypeAzureSQLDb', 'WorkloadTypeSQLDB', 'WorkloadTypeExchange', 'WorkloadTypeSharepoint', 'WorkloadTypeVMwareVM', 'WorkloadTypeSystemState', 'WorkloadTypeClient', 'WorkloadTypeGenericDataSource', 'WorkloadTypeSQLDataBase', 'WorkloadTypeAzureFileShare', 'WorkloadTypeSAPHanaDatabase', 'WorkloadTypeSAPAseDatabase'
	WorkloadType WorkloadType `json:"workloadType,omitempty"`
	// ProtectionStatus - Backup status query parameter. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionStatus ProtectionStatus `json:"protectionStatus,omitempty"`
}

// ClientDiscoveryDisplay localized display information of an operation.
type ClientDiscoveryDisplay struct {
	// Provider - Name of the provider for display purposes
	Provider *string `json:"provider,omitempty"`
	// Resource - ResourceType for which this Operation can be performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operations Name itself.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of the operation having details of what operation is about.
	Description *string `json:"description,omitempty"`
}

// ClientDiscoveryForLogSpecification class to represent shoebox log specification in json client
// discovery.
type ClientDiscoveryForLogSpecification struct {
	// Name - Name for shoebox log specification.
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized display name
	DisplayName *string `json:"displayName,omitempty"`
	// BlobDuration - blob duration of shoebox log specification
	BlobDuration *string `json:"blobDuration,omitempty"`
}

// ClientDiscoveryForProperties class to represent shoebox properties in json client discovery.
type ClientDiscoveryForProperties struct {
	// ServiceSpecification - Operation properties.
	ServiceSpecification *ClientDiscoveryForServiceSpecification `json:"serviceSpecification,omitempty"`
}

// ClientDiscoveryForServiceSpecification class to represent shoebox service specification in json client
// discovery.
type ClientDiscoveryForServiceSpecification struct {
	// LogSpecifications - List of log specifications of this operation.
	LogSpecifications *[]ClientDiscoveryForLogSpecification `json:"logSpecifications,omitempty"`
}

// ClientDiscoveryResponse operations List response which contains list of available APIs.
type ClientDiscoveryResponse struct {
	autorest.Response `json:"-"`
	// Value - List of available operations.
	Value *[]ClientDiscoveryValueForSingleAPI `json:"value,omitempty"`
	// NextLink - Link to the next chunk of Response.
	NextLink *string `json:"nextLink,omitempty"`
}

// ClientDiscoveryResponseIterator provides access to a complete listing of
// ClientDiscoveryValueForSingleAPI values.
type ClientDiscoveryResponseIterator struct {
	i    int
	page ClientDiscoveryResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ClientDiscoveryResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClientDiscoveryResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ClientDiscoveryResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ClientDiscoveryResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ClientDiscoveryResponseIterator) Response() ClientDiscoveryResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ClientDiscoveryResponseIterator) Value() ClientDiscoveryValueForSingleAPI {
	if !iter.page.NotDone() {
		return ClientDiscoveryValueForSingleAPI{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ClientDiscoveryResponseIterator type.
func NewClientDiscoveryResponseIterator(page ClientDiscoveryResponsePage) ClientDiscoveryResponseIterator {
	return ClientDiscoveryResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cdr ClientDiscoveryResponse) IsEmpty() bool {
	return cdr.Value == nil || len(*cdr.Value) == 0
}

// clientDiscoveryResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cdr ClientDiscoveryResponse) clientDiscoveryResponsePreparer(ctx context.Context) (*http.Request, error) {
	if cdr.NextLink == nil || len(to.String(cdr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cdr.NextLink)))
}

// ClientDiscoveryResponsePage contains a page of ClientDiscoveryValueForSingleAPI values.
type ClientDiscoveryResponsePage struct {
	fn  func(context.Context, ClientDiscoveryResponse) (ClientDiscoveryResponse, error)
	cdr ClientDiscoveryResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ClientDiscoveryResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClientDiscoveryResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.cdr)
	if err != nil {
		return err
	}
	page.cdr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ClientDiscoveryResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ClientDiscoveryResponsePage) NotDone() bool {
	return !page.cdr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ClientDiscoveryResponsePage) Response() ClientDiscoveryResponse {
	return page.cdr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ClientDiscoveryResponsePage) Values() []ClientDiscoveryValueForSingleAPI {
	if page.cdr.IsEmpty() {
		return nil
	}
	return *page.cdr.Value
}

// Creates a new instance of the ClientDiscoveryResponsePage type.
func NewClientDiscoveryResponsePage(getNextPage func(context.Context, ClientDiscoveryResponse) (ClientDiscoveryResponse, error)) ClientDiscoveryResponsePage {
	return ClientDiscoveryResponsePage{fn: getNextPage}
}

// ClientDiscoveryValueForSingleAPI available operation details.
type ClientDiscoveryValueForSingleAPI struct {
	// Name - Name of the Operation.
	Name *string `json:"name,omitempty"`
	// Display - Contains the localized display information for this particular operation
	Display *ClientDiscoveryDisplay `json:"display,omitempty"`
	// Origin - The intended executor of the operation;governs the display of the operation in the RBAC UX and the audit logs UX
	Origin *string `json:"origin,omitempty"`
	// Properties - ShoeBox properties for the given operation.
	Properties *ClientDiscoveryForProperties `json:"properties,omitempty"`
}

// ClientScriptForConnect client script details for file / folder restore.
type ClientScriptForConnect struct {
	// ScriptContent - File content of the client script for file / folder restore.
	ScriptContent *string `json:"scriptContent,omitempty"`
	// ScriptExtension - File extension of the client script for file / folder restore - .ps1 , .sh , etc.
	ScriptExtension *string `json:"scriptExtension,omitempty"`
	// OsType - OS type - Windows, Linux etc. for which this file / folder restore client script works.
	OsType *string `json:"osType,omitempty"`
	// URL - URL of Executable from where to source the content. If this is not null then ScriptContent should not be used
	URL *string `json:"url,omitempty"`
	// ScriptNameSuffix - Mandatory suffix that should be added to the name of script that is given for download to user.
	// If its null or empty then , ignore it.
	ScriptNameSuffix *string `json:"scriptNameSuffix,omitempty"`
}

// ContainerIdentityInfo container identity information
type ContainerIdentityInfo struct {
	// UniqueName - Unique name of the container
	UniqueName *string `json:"uniqueName,omitempty"`
	// AadTenantID - Protection container identity - AAD Tenant
	AadTenantID *string `json:"aadTenantId,omitempty"`
	// ServicePrincipalClientID - Protection container identity - AAD Service Principal
	ServicePrincipalClientID *string `json:"servicePrincipalClientId,omitempty"`
	// Audience - Protection container identity - Audience
	Audience *string `json:"audience,omitempty"`
}

// DailyRetentionFormat daily retention format.
type DailyRetentionFormat struct {
	// DaysOfTheMonth - List of days of the month.
	DaysOfTheMonth *[]Day `json:"daysOfTheMonth,omitempty"`
}

// DailyRetentionSchedule daily retention schedule.
type DailyRetentionSchedule struct {
	// RetentionTimes - Retention times of retention policy.
	RetentionTimes *[]date.Time `json:"retentionTimes,omitempty"`
	// RetentionDuration - Retention duration of retention Policy.
	RetentionDuration *RetentionDuration `json:"retentionDuration,omitempty"`
}

// Day day of the week.
type Day struct {
	// Date - Date of the month
	Date *int32 `json:"date,omitempty"`
	// IsLast - Whether Date is last date of month
	IsLast *bool `json:"isLast,omitempty"`
}

// DiskExclusionProperties ...
type DiskExclusionProperties struct {
	// DiskLunList - List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
	DiskLunList *[]int32 `json:"diskLunList,omitempty"`
	// IsInclusionList - Flag to indicate whether DiskLunList is to be included/ excluded from backup.
	IsInclusionList *bool `json:"isInclusionList,omitempty"`
}

// DiskInformation disk information
type DiskInformation struct {
	Lun  *int32  `json:"lun,omitempty"`
	Name *string `json:"name,omitempty"`
}

// DistributedNodesInfo this is used to represent the various nodes of the distributed container.
type DistributedNodesInfo struct {
	// NodeName - Name of the node under a distributed container.
	NodeName *string `json:"nodeName,omitempty"`
	// Status - Status of this Node.
	// Failed | Succeeded
	Status *string `json:"status,omitempty"`
	// ErrorDetail - Error Details if the Status is non-success.
	ErrorDetail *ErrorDetail `json:"errorDetail,omitempty"`
}

// DpmBackupEngine data Protection Manager (DPM) specific backup engine.
type DpmBackupEngine struct {
	// FriendlyName - Friendly name of the backup engine.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the backup engine. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Registration status of the backup engine with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// BackupEngineState - Status of the backup engine with the Recovery Services Vault. = {Active/Deleting/DeleteFailed}
	BackupEngineState *string `json:"backupEngineState,omitempty"`
	// HealthStatus - Backup status of the backup engine.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// CanReRegister - Flag indicating if the backup engine be registered, once already registered.
	CanReRegister *bool `json:"canReRegister,omitempty"`
	// BackupEngineID - ID of the backup engine.
	BackupEngineID *string `json:"backupEngineId,omitempty"`
	// DpmVersion - Backup engine version
	DpmVersion *string `json:"dpmVersion,omitempty"`
	// AzureBackupAgentVersion - Backup agent version
	AzureBackupAgentVersion *string `json:"azureBackupAgentVersion,omitempty"`
	// IsAzureBackupAgentUpgradeAvailable - To check if backup agent upgrade available
	IsAzureBackupAgentUpgradeAvailable *bool `json:"isAzureBackupAgentUpgradeAvailable,omitempty"`
	// IsDpmUpgradeAvailable - To check if backup engine upgrade available
	IsDpmUpgradeAvailable *bool `json:"isDpmUpgradeAvailable,omitempty"`
	// ExtendedInfo - Extended info of the backupengine
	ExtendedInfo *EngineExtendedInfo `json:"extendedInfo,omitempty"`
	// BackupEngineType - Possible values include: 'BackupEngineTypeBackupEngineBase', 'BackupEngineTypeAzureBackupServerEngine', 'BackupEngineTypeDpmBackupEngine'
	BackupEngineType EngineType `json:"backupEngineType,omitempty"`
}

// MarshalJSON is the custom marshaler for DpmBackupEngine.
func (dbe DpmBackupEngine) MarshalJSON() ([]byte, error) {
	dbe.BackupEngineType = BackupEngineTypeDpmBackupEngine
	objectMap := make(map[string]interface{})
	if dbe.FriendlyName != nil {
		objectMap["friendlyName"] = dbe.FriendlyName
	}
	if dbe.BackupManagementType != "" {
		objectMap["backupManagementType"] = dbe.BackupManagementType
	}
	if dbe.RegistrationStatus != nil {
		objectMap["registrationStatus"] = dbe.RegistrationStatus
	}
	if dbe.BackupEngineState != nil {
		objectMap["backupEngineState"] = dbe.BackupEngineState
	}
	if dbe.HealthStatus != nil {
		objectMap["healthStatus"] = dbe.HealthStatus
	}
	if dbe.CanReRegister != nil {
		objectMap["canReRegister"] = dbe.CanReRegister
	}
	if dbe.BackupEngineID != nil {
		objectMap["backupEngineId"] = dbe.BackupEngineID
	}
	if dbe.DpmVersion != nil {
		objectMap["dpmVersion"] = dbe.DpmVersion
	}
	if dbe.AzureBackupAgentVersion != nil {
		objectMap["azureBackupAgentVersion"] = dbe.AzureBackupAgentVersion
	}
	if dbe.IsAzureBackupAgentUpgradeAvailable != nil {
		objectMap["isAzureBackupAgentUpgradeAvailable"] = dbe.IsAzureBackupAgentUpgradeAvailable
	}
	if dbe.IsDpmUpgradeAvailable != nil {
		objectMap["isDpmUpgradeAvailable"] = dbe.IsDpmUpgradeAvailable
	}
	if dbe.ExtendedInfo != nil {
		objectMap["extendedInfo"] = dbe.ExtendedInfo
	}
	if dbe.BackupEngineType != "" {
		objectMap["backupEngineType"] = dbe.BackupEngineType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerEngine is the BasicEngineBase implementation for DpmBackupEngine.
func (dbe DpmBackupEngine) AsAzureBackupServerEngine() (*AzureBackupServerEngine, bool) {
	return nil, false
}

// AsDpmBackupEngine is the BasicEngineBase implementation for DpmBackupEngine.
func (dbe DpmBackupEngine) AsDpmBackupEngine() (*DpmBackupEngine, bool) {
	return &dbe, true
}

// AsEngineBase is the BasicEngineBase implementation for DpmBackupEngine.
func (dbe DpmBackupEngine) AsEngineBase() (*EngineBase, bool) {
	return nil, false
}

// AsBasicEngineBase is the BasicEngineBase implementation for DpmBackupEngine.
func (dbe DpmBackupEngine) AsBasicEngineBase() (BasicEngineBase, bool) {
	return &dbe, true
}

// BasicDpmContainer DPM workload-specific protection container.
type BasicDpmContainer interface {
	AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool)
	AsDpmContainer() (*DpmContainer, bool)
}

// DpmContainer DPM workload-specific protection container.
type DpmContainer struct {
	// CanReRegister - Specifies whether the container is re-registrable.
	CanReRegister *bool `json:"canReRegister,omitempty"`
	// ContainerID - ID of container.
	ContainerID *string `json:"containerId,omitempty"`
	// ProtectedItemCount - Number of protected items in the BackupEngine
	ProtectedItemCount *int64 `json:"protectedItemCount,omitempty"`
	// DpmAgentVersion - Backup engine Agent version
	DpmAgentVersion *string `json:"dpmAgentVersion,omitempty"`
	// DpmServers - List of BackupEngines protecting the container
	DpmServers *[]string `json:"dpmServers,omitempty"`
	// UpgradeAvailable - To check if upgrade available
	UpgradeAvailable *bool `json:"upgradeAvailable,omitempty"`
	// ProtectionStatus - Protection status of the container.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`
	// ExtendedInfo - Extended Info of the container.
	ExtendedInfo *DPMContainerExtendedInfo `json:"extendedInfo,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

func unmarshalBasicDpmContainer(body []byte) (BasicDpmContainer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["containerType"] {
	case string(ContainerTypeAzureBackupServerContainer1):
		var absc AzureBackupServerContainer
		err := json.Unmarshal(body, &absc)
		return absc, err
	default:
		var dc DpmContainer
		err := json.Unmarshal(body, &dc)
		return dc, err
	}
}
func unmarshalBasicDpmContainerArray(body []byte) ([]BasicDpmContainer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dcArray := make([]BasicDpmContainer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dc, err := unmarshalBasicDpmContainer(*rawMessage)
		if err != nil {
			return nil, err
		}
		dcArray[index] = dc
	}
	return dcArray, nil
}

// MarshalJSON is the custom marshaler for DpmContainer.
func (dc DpmContainer) MarshalJSON() ([]byte, error) {
	dc.ContainerType = ContainerTypeDPMContainer1
	objectMap := make(map[string]interface{})
	if dc.CanReRegister != nil {
		objectMap["canReRegister"] = dc.CanReRegister
	}
	if dc.ContainerID != nil {
		objectMap["containerId"] = dc.ContainerID
	}
	if dc.ProtectedItemCount != nil {
		objectMap["protectedItemCount"] = dc.ProtectedItemCount
	}
	if dc.DpmAgentVersion != nil {
		objectMap["dpmAgentVersion"] = dc.DpmAgentVersion
	}
	if dc.DpmServers != nil {
		objectMap["dpmServers"] = dc.DpmServers
	}
	if dc.UpgradeAvailable != nil {
		objectMap["upgradeAvailable"] = dc.UpgradeAvailable
	}
	if dc.ProtectionStatus != nil {
		objectMap["protectionStatus"] = dc.ProtectionStatus
	}
	if dc.ExtendedInfo != nil {
		objectMap["extendedInfo"] = dc.ExtendedInfo
	}
	if dc.FriendlyName != nil {
		objectMap["friendlyName"] = dc.FriendlyName
	}
	if dc.BackupManagementType != "" {
		objectMap["backupManagementType"] = dc.BackupManagementType
	}
	if dc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = dc.RegistrationStatus
	}
	if dc.HealthStatus != nil {
		objectMap["healthStatus"] = dc.HealthStatus
	}
	if dc.ContainerType != "" {
		objectMap["containerType"] = dc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return nil, false
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return nil, false
}

// AsDpmContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsDpmContainer() (*DpmContainer, bool) {
	return &dc, true
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return &dc, true
}

// AsGenericContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsGenericContainer() (*GenericContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return nil, false
}

// AsMabContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for DpmContainer.
func (dc DpmContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &dc, true
}

// DPMContainerExtendedInfo additional information of the DPMContainer.
type DPMContainerExtendedInfo struct {
	// LastRefreshedAt - Last refresh time of the DPMContainer.
	LastRefreshedAt *date.Time `json:"lastRefreshedAt,omitempty"`
}

// DpmErrorInfo DPM workload-specific error information.
type DpmErrorInfo struct {
	// ErrorString - Localized error string.
	ErrorString *string `json:"errorString,omitempty"`
	// Recommendations - List of localized recommendations for above error code.
	Recommendations *[]string `json:"recommendations,omitempty"`
}

// DpmJob DPM workload-specific job object.
type DpmJob struct {
	// Duration - Time elapsed for job.
	Duration *string `json:"duration,omitempty"`
	// DpmServerName - DPM server name managing the backup item or backup job.
	DpmServerName *string `json:"dpmServerName,omitempty"`
	// ContainerName - Name of cluster/server protecting current backup item, if any.
	ContainerName *string `json:"containerName,omitempty"`
	// ContainerType - Type of container.
	ContainerType *string `json:"containerType,omitempty"`
	// WorkloadType - Type of backup item.
	WorkloadType *string `json:"workloadType,omitempty"`
	// ActionsInfo - The state/actions applicable on this job like cancel/retry.
	ActionsInfo *[]JobSupportedAction `json:"actionsInfo,omitempty"`
	// ErrorDetails - The errors.
	ErrorDetails *[]DpmErrorInfo `json:"errorDetails,omitempty"`
	// ExtendedInfo - Additional information for this job.
	ExtendedInfo *DpmJobExtendedInfo `json:"extendedInfo,omitempty"`
	// EntityFriendlyName - Friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string `json:"entityFriendlyName,omitempty"`
	// BackupManagementType - Backup management type to execute the current job. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// Operation - The operation name.
	Operation *string `json:"operation,omitempty"`
	// Status - Job status.
	Status *string `json:"status,omitempty"`
	// StartTime - The start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ActivityID - ActivityId of job.
	ActivityID *string `json:"activityId,omitempty"`
	// JobType - Possible values include: 'JobTypeJob', 'JobTypeAzureIaaSVMJob', 'JobTypeAzureStorageJob', 'JobTypeAzureWorkloadJob', 'JobTypeDpmJob', 'JobTypeMabJob'
	JobType JobType `json:"jobType,omitempty"`
}

// MarshalJSON is the custom marshaler for DpmJob.
func (dj DpmJob) MarshalJSON() ([]byte, error) {
	dj.JobType = JobTypeDpmJob
	objectMap := make(map[string]interface{})
	if dj.Duration != nil {
		objectMap["duration"] = dj.Duration
	}
	if dj.DpmServerName != nil {
		objectMap["dpmServerName"] = dj.DpmServerName
	}
	if dj.ContainerName != nil {
		objectMap["containerName"] = dj.ContainerName
	}
	if dj.ContainerType != nil {
		objectMap["containerType"] = dj.ContainerType
	}
	if dj.WorkloadType != nil {
		objectMap["workloadType"] = dj.WorkloadType
	}
	if dj.ActionsInfo != nil {
		objectMap["actionsInfo"] = dj.ActionsInfo
	}
	if dj.ErrorDetails != nil {
		objectMap["errorDetails"] = dj.ErrorDetails
	}
	if dj.ExtendedInfo != nil {
		objectMap["extendedInfo"] = dj.ExtendedInfo
	}
	if dj.EntityFriendlyName != nil {
		objectMap["entityFriendlyName"] = dj.EntityFriendlyName
	}
	if dj.BackupManagementType != "" {
		objectMap["backupManagementType"] = dj.BackupManagementType
	}
	if dj.Operation != nil {
		objectMap["operation"] = dj.Operation
	}
	if dj.Status != nil {
		objectMap["status"] = dj.Status
	}
	if dj.StartTime != nil {
		objectMap["startTime"] = dj.StartTime
	}
	if dj.EndTime != nil {
		objectMap["endTime"] = dj.EndTime
	}
	if dj.ActivityID != nil {
		objectMap["activityId"] = dj.ActivityID
	}
	if dj.JobType != "" {
		objectMap["jobType"] = dj.JobType
	}
	return json.Marshal(objectMap)
}

// AsAzureIaaSVMJob is the BasicJob implementation for DpmJob.
func (dj DpmJob) AsAzureIaaSVMJob() (*AzureIaaSVMJob, bool) {
	return nil, false
}

// AsAzureStorageJob is the BasicJob implementation for DpmJob.
func (dj DpmJob) AsAzureStorageJob() (*AzureStorageJob, bool) {
	return nil, false
}

// AsAzureWorkloadJob is the BasicJob implementation for DpmJob.
func (dj DpmJob) AsAzureWorkloadJob() (*AzureWorkloadJob, bool) {
	return nil, false
}

// AsDpmJob is the BasicJob implementation for DpmJob.
func (dj DpmJob) AsDpmJob() (*DpmJob, bool) {
	return &dj, true
}

// AsMabJob is the BasicJob implementation for DpmJob.
func (dj DpmJob) AsMabJob() (*MabJob, bool) {
	return nil, false
}

// AsJob is the BasicJob implementation for DpmJob.
func (dj DpmJob) AsJob() (*Job, bool) {
	return nil, false
}

// AsBasicJob is the BasicJob implementation for DpmJob.
func (dj DpmJob) AsBasicJob() (BasicJob, bool) {
	return &dj, true
}

// DpmJobExtendedInfo additional information on the DPM workload-specific job.
type DpmJobExtendedInfo struct {
	// TasksList - List of tasks associated with this job.
	TasksList *[]DpmJobTaskDetails `json:"tasksList,omitempty"`
	// PropertyBag - The job properties.
	PropertyBag map[string]*string `json:"propertyBag"`
	// DynamicErrorMessage - Non localized error message on job execution.
	DynamicErrorMessage *string `json:"dynamicErrorMessage,omitempty"`
}

// MarshalJSON is the custom marshaler for DpmJobExtendedInfo.
func (djei DpmJobExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if djei.TasksList != nil {
		objectMap["tasksList"] = djei.TasksList
	}
	if djei.PropertyBag != nil {
		objectMap["propertyBag"] = djei.PropertyBag
	}
	if djei.DynamicErrorMessage != nil {
		objectMap["dynamicErrorMessage"] = djei.DynamicErrorMessage
	}
	return json.Marshal(objectMap)
}

// DpmJobTaskDetails DPM workload-specific job task details.
type DpmJobTaskDetails struct {
	// TaskID - The task display name.
	TaskID *string `json:"taskId,omitempty"`
	// StartTime - The start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Duration - Time elapsed for task.
	Duration *string `json:"duration,omitempty"`
	// Status - The status.
	Status *string `json:"status,omitempty"`
}

// DPMProtectedItem additional information on Backup engine specific backup item.
type DPMProtectedItem struct {
	// FriendlyName - Friendly name of the managed item
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupEngineName - Backup Management server protecting this backup item
	BackupEngineName *string `json:"backupEngineName,omitempty"`
	// ProtectionState - Protection state of the backup engine. Possible values include: 'ProtectedItemStateInvalid', 'ProtectedItemStateIRPending', 'ProtectedItemStateProtected', 'ProtectedItemStateProtectionError', 'ProtectedItemStateProtectionStopped', 'ProtectedItemStateProtectionPaused'
	ProtectionState ProtectedItemState `json:"protectionState,omitempty"`
	// ExtendedInfo - Extended info of the backup item.
	ExtendedInfo *DPMProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`
	// BackupManagementType - Type of backup management for the backed up item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload this item represents. Possible values include: 'DataSourceTypeInvalid', 'DataSourceTypeVM', 'DataSourceTypeFileFolder', 'DataSourceTypeAzureSQLDb', 'DataSourceTypeSQLDB', 'DataSourceTypeExchange', 'DataSourceTypeSharepoint', 'DataSourceTypeVMwareVM', 'DataSourceTypeSystemState', 'DataSourceTypeClient', 'DataSourceTypeGenericDataSource', 'DataSourceTypeSQLDataBase', 'DataSourceTypeAzureFileShare', 'DataSourceTypeSAPHanaDatabase', 'DataSourceTypeSAPAseDatabase'
	WorkloadType DataSourceType `json:"workloadType,omitempty"`
	// ContainerName - Unique name of container
	ContainerName *string `json:"containerName,omitempty"`
	// SourceResourceID - ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// PolicyID - ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`
	// LastRecoveryPoint - Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *date.Time `json:"lastRecoveryPoint,omitempty"`
	// BackupSetName - Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`
	// CreateMode - Create mode to indicate recovery of existing soft deleted data source or creation of new data source. Possible values include: 'CreateModeInvalid', 'CreateModeDefault', 'CreateModeRecover'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// DeferredDeleteTimeInUTC - Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *date.Time `json:"deferredDeleteTimeInUTC,omitempty"`
	// IsScheduledForDeferredDelete - Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`
	// DeferredDeleteTimeRemaining - Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`
	// IsDeferredDeleteScheduleUpcoming - Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`
	// IsRehydrate - Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`
	// ProtectedItemType - Possible values include: 'ProtectedItemTypeProtectedItem', 'ProtectedItemTypeAzureFileShareProtectedItem', 'ProtectedItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectedItemTypeMicrosoftComputevirtualMachines', 'ProtectedItemTypeAzureIaaSVMProtectedItem', 'ProtectedItemTypeMicrosoftSqlserversdatabases', 'ProtectedItemTypeAzureVMWorkloadProtectedItem', 'ProtectedItemTypeAzureVMWorkloadSAPAseDatabase', 'ProtectedItemTypeAzureVMWorkloadSAPHanaDatabase', 'ProtectedItemTypeAzureVMWorkloadSQLDatabase', 'ProtectedItemTypeDPMProtectedItem', 'ProtectedItemTypeGenericProtectedItem', 'ProtectedItemTypeMabFileFolderProtectedItem'
	ProtectedItemType ProtectedItemType `json:"protectedItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for DPMProtectedItem.
func (dpi DPMProtectedItem) MarshalJSON() ([]byte, error) {
	dpi.ProtectedItemType = ProtectedItemTypeDPMProtectedItem
	objectMap := make(map[string]interface{})
	if dpi.FriendlyName != nil {
		objectMap["friendlyName"] = dpi.FriendlyName
	}
	if dpi.BackupEngineName != nil {
		objectMap["backupEngineName"] = dpi.BackupEngineName
	}
	if dpi.ProtectionState != "" {
		objectMap["protectionState"] = dpi.ProtectionState
	}
	if dpi.ExtendedInfo != nil {
		objectMap["extendedInfo"] = dpi.ExtendedInfo
	}
	if dpi.BackupManagementType != "" {
		objectMap["backupManagementType"] = dpi.BackupManagementType
	}
	if dpi.WorkloadType != "" {
		objectMap["workloadType"] = dpi.WorkloadType
	}
	if dpi.ContainerName != nil {
		objectMap["containerName"] = dpi.ContainerName
	}
	if dpi.SourceResourceID != nil {
		objectMap["sourceResourceId"] = dpi.SourceResourceID
	}
	if dpi.PolicyID != nil {
		objectMap["policyId"] = dpi.PolicyID
	}
	if dpi.LastRecoveryPoint != nil {
		objectMap["lastRecoveryPoint"] = dpi.LastRecoveryPoint
	}
	if dpi.BackupSetName != nil {
		objectMap["backupSetName"] = dpi.BackupSetName
	}
	if dpi.CreateMode != "" {
		objectMap["createMode"] = dpi.CreateMode
	}
	if dpi.DeferredDeleteTimeInUTC != nil {
		objectMap["deferredDeleteTimeInUTC"] = dpi.DeferredDeleteTimeInUTC
	}
	if dpi.IsScheduledForDeferredDelete != nil {
		objectMap["isScheduledForDeferredDelete"] = dpi.IsScheduledForDeferredDelete
	}
	if dpi.DeferredDeleteTimeRemaining != nil {
		objectMap["deferredDeleteTimeRemaining"] = dpi.DeferredDeleteTimeRemaining
	}
	if dpi.IsDeferredDeleteScheduleUpcoming != nil {
		objectMap["isDeferredDeleteScheduleUpcoming"] = dpi.IsDeferredDeleteScheduleUpcoming
	}
	if dpi.IsRehydrate != nil {
		objectMap["isRehydrate"] = dpi.IsRehydrate
	}
	if dpi.ProtectedItemType != "" {
		objectMap["protectedItemType"] = dpi.ProtectedItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileshareProtectedItem is the BasicProtectedItem implementation for DPMProtectedItem.
func (dpi DPMProtectedItem) AsAzureFileshareProtectedItem() (*AzureFileshareProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectedItem is the BasicProtectedItem implementation for DPMProtectedItem.
func (dpi DPMProtectedItem) AsAzureIaaSClassicComputeVMProtectedItem() (*AzureIaaSClassicComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectedItem is the BasicProtectedItem implementation for DPMProtectedItem.
func (dpi DPMProtectedItem) AsAzureIaaSComputeVMProtectedItem() (*AzureIaaSComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for DPMProtectedItem.
func (dpi DPMProtectedItem) AsAzureIaaSVMProtectedItem() (*AzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for DPMProtectedItem.
func (dpi DPMProtectedItem) AsBasicAzureIaaSVMProtectedItem() (BasicAzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsAzureSQLProtectedItem is the BasicProtectedItem implementation for DPMProtectedItem.
func (dpi DPMProtectedItem) AsAzureSQLProtectedItem() (*AzureSQLProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for DPMProtectedItem.
func (dpi DPMProtectedItem) AsAzureVMWorkloadProtectedItem() (*AzureVMWorkloadProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for DPMProtectedItem.
func (dpi DPMProtectedItem) AsBasicAzureVMWorkloadProtectedItem() (BasicAzureVMWorkloadProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseDatabaseProtectedItem is the BasicProtectedItem implementation for DPMProtectedItem.
func (dpi DPMProtectedItem) AsAzureVMWorkloadSAPAseDatabaseProtectedItem() (*AzureVMWorkloadSAPAseDatabaseProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectedItem is the BasicProtectedItem implementation for DPMProtectedItem.
func (dpi DPMProtectedItem) AsAzureVMWorkloadSAPHanaDatabaseProtectedItem() (*AzureVMWorkloadSAPHanaDatabaseProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectedItem is the BasicProtectedItem implementation for DPMProtectedItem.
func (dpi DPMProtectedItem) AsAzureVMWorkloadSQLDatabaseProtectedItem() (*AzureVMWorkloadSQLDatabaseProtectedItem, bool) {
	return nil, false
}

// AsDPMProtectedItem is the BasicProtectedItem implementation for DPMProtectedItem.
func (dpi DPMProtectedItem) AsDPMProtectedItem() (*DPMProtectedItem, bool) {
	return &dpi, true
}

// AsGenericProtectedItem is the BasicProtectedItem implementation for DPMProtectedItem.
func (dpi DPMProtectedItem) AsGenericProtectedItem() (*GenericProtectedItem, bool) {
	return nil, false
}

// AsMabFileFolderProtectedItem is the BasicProtectedItem implementation for DPMProtectedItem.
func (dpi DPMProtectedItem) AsMabFileFolderProtectedItem() (*MabFileFolderProtectedItem, bool) {
	return nil, false
}

// AsProtectedItem is the BasicProtectedItem implementation for DPMProtectedItem.
func (dpi DPMProtectedItem) AsProtectedItem() (*ProtectedItem, bool) {
	return nil, false
}

// AsBasicProtectedItem is the BasicProtectedItem implementation for DPMProtectedItem.
func (dpi DPMProtectedItem) AsBasicProtectedItem() (BasicProtectedItem, bool) {
	return &dpi, true
}

// DPMProtectedItemExtendedInfo additional information of DPM Protected item.
type DPMProtectedItemExtendedInfo struct {
	// ProtectableObjectLoadPath - Attribute to provide information on various DBs.
	ProtectableObjectLoadPath map[string]*string `json:"protectableObjectLoadPath"`
	// Protected - To check if backup item is disk protected.
	Protected *bool `json:"protected,omitempty"`
	// IsPresentOnCloud - To check if backup item is cloud protected.
	IsPresentOnCloud *bool `json:"isPresentOnCloud,omitempty"`
	// LastBackupStatus - Last backup status information on backup item.
	LastBackupStatus *string `json:"lastBackupStatus,omitempty"`
	// LastRefreshedAt - Last refresh time on backup item.
	LastRefreshedAt *date.Time `json:"lastRefreshedAt,omitempty"`
	// OldestRecoveryPoint - Oldest cloud recovery point time.
	OldestRecoveryPoint *date.Time `json:"oldestRecoveryPoint,omitempty"`
	// RecoveryPointCount - cloud recovery point count.
	RecoveryPointCount *int32 `json:"recoveryPointCount,omitempty"`
	// OnPremiseOldestRecoveryPoint - Oldest disk recovery point time.
	OnPremiseOldestRecoveryPoint *date.Time `json:"onPremiseOldestRecoveryPoint,omitempty"`
	// OnPremiseLatestRecoveryPoint - latest disk recovery point time.
	OnPremiseLatestRecoveryPoint *date.Time `json:"onPremiseLatestRecoveryPoint,omitempty"`
	// OnPremiseRecoveryPointCount - disk recovery point count.
	OnPremiseRecoveryPointCount *int32 `json:"onPremiseRecoveryPointCount,omitempty"`
	// IsCollocated - To check if backup item is collocated.
	IsCollocated *bool `json:"isCollocated,omitempty"`
	// ProtectionGroupName - Protection group name of the backup item.
	ProtectionGroupName *string `json:"protectionGroupName,omitempty"`
	// DiskStorageUsedInBytes - Used Disk storage in bytes.
	DiskStorageUsedInBytes *string `json:"diskStorageUsedInBytes,omitempty"`
	// TotalDiskStorageSizeInBytes - total Disk storage in bytes.
	TotalDiskStorageSizeInBytes *string `json:"totalDiskStorageSizeInBytes,omitempty"`
}

// MarshalJSON is the custom marshaler for DPMProtectedItemExtendedInfo.
func (dpiei DPMProtectedItemExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dpiei.ProtectableObjectLoadPath != nil {
		objectMap["protectableObjectLoadPath"] = dpiei.ProtectableObjectLoadPath
	}
	if dpiei.Protected != nil {
		objectMap["protected"] = dpiei.Protected
	}
	if dpiei.IsPresentOnCloud != nil {
		objectMap["isPresentOnCloud"] = dpiei.IsPresentOnCloud
	}
	if dpiei.LastBackupStatus != nil {
		objectMap["lastBackupStatus"] = dpiei.LastBackupStatus
	}
	if dpiei.LastRefreshedAt != nil {
		objectMap["lastRefreshedAt"] = dpiei.LastRefreshedAt
	}
	if dpiei.OldestRecoveryPoint != nil {
		objectMap["oldestRecoveryPoint"] = dpiei.OldestRecoveryPoint
	}
	if dpiei.RecoveryPointCount != nil {
		objectMap["recoveryPointCount"] = dpiei.RecoveryPointCount
	}
	if dpiei.OnPremiseOldestRecoveryPoint != nil {
		objectMap["onPremiseOldestRecoveryPoint"] = dpiei.OnPremiseOldestRecoveryPoint
	}
	if dpiei.OnPremiseLatestRecoveryPoint != nil {
		objectMap["onPremiseLatestRecoveryPoint"] = dpiei.OnPremiseLatestRecoveryPoint
	}
	if dpiei.OnPremiseRecoveryPointCount != nil {
		objectMap["onPremiseRecoveryPointCount"] = dpiei.OnPremiseRecoveryPointCount
	}
	if dpiei.IsCollocated != nil {
		objectMap["isCollocated"] = dpiei.IsCollocated
	}
	if dpiei.ProtectionGroupName != nil {
		objectMap["protectionGroupName"] = dpiei.ProtectionGroupName
	}
	if dpiei.DiskStorageUsedInBytes != nil {
		objectMap["diskStorageUsedInBytes"] = dpiei.DiskStorageUsedInBytes
	}
	if dpiei.TotalDiskStorageSizeInBytes != nil {
		objectMap["totalDiskStorageSizeInBytes"] = dpiei.TotalDiskStorageSizeInBytes
	}
	return json.Marshal(objectMap)
}

// EncryptionDetails details needed if the VM was encrypted at the time of backup.
type EncryptionDetails struct {
	// EncryptionEnabled - Identifies whether this backup copy represents an encrypted VM at the time of backup.
	EncryptionEnabled *bool `json:"encryptionEnabled,omitempty"`
	// KekURL - Key Url.
	KekURL *string `json:"kekUrl,omitempty"`
	// SecretKeyURL - Secret Url.
	SecretKeyURL *string `json:"secretKeyUrl,omitempty"`
	// KekVaultID - ID of Key Vault where KEK is stored.
	KekVaultID *string `json:"kekVaultId,omitempty"`
	// SecretKeyVaultID - ID of Key Vault where Secret is stored.
	SecretKeyVaultID *string `json:"secretKeyVaultId,omitempty"`
}

// BasicEngineBase the base backup engine class. All workload specific backup engines derive from this class.
type BasicEngineBase interface {
	AsAzureBackupServerEngine() (*AzureBackupServerEngine, bool)
	AsDpmBackupEngine() (*DpmBackupEngine, bool)
	AsEngineBase() (*EngineBase, bool)
}

// EngineBase the base backup engine class. All workload specific backup engines derive from this class.
type EngineBase struct {
	// FriendlyName - Friendly name of the backup engine.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the backup engine. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Registration status of the backup engine with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// BackupEngineState - Status of the backup engine with the Recovery Services Vault. = {Active/Deleting/DeleteFailed}
	BackupEngineState *string `json:"backupEngineState,omitempty"`
	// HealthStatus - Backup status of the backup engine.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// CanReRegister - Flag indicating if the backup engine be registered, once already registered.
	CanReRegister *bool `json:"canReRegister,omitempty"`
	// BackupEngineID - ID of the backup engine.
	BackupEngineID *string `json:"backupEngineId,omitempty"`
	// DpmVersion - Backup engine version
	DpmVersion *string `json:"dpmVersion,omitempty"`
	// AzureBackupAgentVersion - Backup agent version
	AzureBackupAgentVersion *string `json:"azureBackupAgentVersion,omitempty"`
	// IsAzureBackupAgentUpgradeAvailable - To check if backup agent upgrade available
	IsAzureBackupAgentUpgradeAvailable *bool `json:"isAzureBackupAgentUpgradeAvailable,omitempty"`
	// IsDpmUpgradeAvailable - To check if backup engine upgrade available
	IsDpmUpgradeAvailable *bool `json:"isDpmUpgradeAvailable,omitempty"`
	// ExtendedInfo - Extended info of the backupengine
	ExtendedInfo *EngineExtendedInfo `json:"extendedInfo,omitempty"`
	// BackupEngineType - Possible values include: 'BackupEngineTypeBackupEngineBase', 'BackupEngineTypeAzureBackupServerEngine', 'BackupEngineTypeDpmBackupEngine'
	BackupEngineType EngineType `json:"backupEngineType,omitempty"`
}

func unmarshalBasicEngineBase(body []byte) (BasicEngineBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["backupEngineType"] {
	case string(BackupEngineTypeAzureBackupServerEngine):
		var abse AzureBackupServerEngine
		err := json.Unmarshal(body, &abse)
		return abse, err
	case string(BackupEngineTypeDpmBackupEngine):
		var dbe DpmBackupEngine
		err := json.Unmarshal(body, &dbe)
		return dbe, err
	default:
		var eb EngineBase
		err := json.Unmarshal(body, &eb)
		return eb, err
	}
}
func unmarshalBasicEngineBaseArray(body []byte) ([]BasicEngineBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ebArray := make([]BasicEngineBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		eb, err := unmarshalBasicEngineBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		ebArray[index] = eb
	}
	return ebArray, nil
}

// MarshalJSON is the custom marshaler for EngineBase.
func (eb EngineBase) MarshalJSON() ([]byte, error) {
	eb.BackupEngineType = BackupEngineTypeBackupEngineBase
	objectMap := make(map[string]interface{})
	if eb.FriendlyName != nil {
		objectMap["friendlyName"] = eb.FriendlyName
	}
	if eb.BackupManagementType != "" {
		objectMap["backupManagementType"] = eb.BackupManagementType
	}
	if eb.RegistrationStatus != nil {
		objectMap["registrationStatus"] = eb.RegistrationStatus
	}
	if eb.BackupEngineState != nil {
		objectMap["backupEngineState"] = eb.BackupEngineState
	}
	if eb.HealthStatus != nil {
		objectMap["healthStatus"] = eb.HealthStatus
	}
	if eb.CanReRegister != nil {
		objectMap["canReRegister"] = eb.CanReRegister
	}
	if eb.BackupEngineID != nil {
		objectMap["backupEngineId"] = eb.BackupEngineID
	}
	if eb.DpmVersion != nil {
		objectMap["dpmVersion"] = eb.DpmVersion
	}
	if eb.AzureBackupAgentVersion != nil {
		objectMap["azureBackupAgentVersion"] = eb.AzureBackupAgentVersion
	}
	if eb.IsAzureBackupAgentUpgradeAvailable != nil {
		objectMap["isAzureBackupAgentUpgradeAvailable"] = eb.IsAzureBackupAgentUpgradeAvailable
	}
	if eb.IsDpmUpgradeAvailable != nil {
		objectMap["isDpmUpgradeAvailable"] = eb.IsDpmUpgradeAvailable
	}
	if eb.ExtendedInfo != nil {
		objectMap["extendedInfo"] = eb.ExtendedInfo
	}
	if eb.BackupEngineType != "" {
		objectMap["backupEngineType"] = eb.BackupEngineType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerEngine is the BasicEngineBase implementation for EngineBase.
func (eb EngineBase) AsAzureBackupServerEngine() (*AzureBackupServerEngine, bool) {
	return nil, false
}

// AsDpmBackupEngine is the BasicEngineBase implementation for EngineBase.
func (eb EngineBase) AsDpmBackupEngine() (*DpmBackupEngine, bool) {
	return nil, false
}

// AsEngineBase is the BasicEngineBase implementation for EngineBase.
func (eb EngineBase) AsEngineBase() (*EngineBase, bool) {
	return &eb, true
}

// AsBasicEngineBase is the BasicEngineBase implementation for EngineBase.
func (eb EngineBase) AsBasicEngineBase() (BasicEngineBase, bool) {
	return &eb, true
}

// EngineBaseResource the base backup engine class. All workload specific backup engines derive from this
// class.
type EngineBaseResource struct {
	autorest.Response `json:"-"`
	// Properties - BackupEngineBaseResource properties
	Properties BasicEngineBase `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for EngineBaseResource.
func (ebr EngineBaseResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = ebr.Properties
	if ebr.Location != nil {
		objectMap["location"] = ebr.Location
	}
	if ebr.Tags != nil {
		objectMap["tags"] = ebr.Tags
	}
	if ebr.ETag != nil {
		objectMap["eTag"] = ebr.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EngineBaseResource struct.
func (ebr *EngineBaseResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicEngineBase(*v)
				if err != nil {
					return err
				}
				ebr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ebr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ebr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ebr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ebr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ebr.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				ebr.ETag = &eTag
			}
		}
	}

	return nil
}

// EngineBaseResourceList list of BackupEngineBase resources
type EngineBaseResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of resources.
	Value *[]EngineBaseResource `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// EngineBaseResourceListIterator provides access to a complete listing of EngineBaseResource values.
type EngineBaseResourceListIterator struct {
	i    int
	page EngineBaseResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EngineBaseResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EngineBaseResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EngineBaseResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EngineBaseResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EngineBaseResourceListIterator) Response() EngineBaseResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EngineBaseResourceListIterator) Value() EngineBaseResource {
	if !iter.page.NotDone() {
		return EngineBaseResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EngineBaseResourceListIterator type.
func NewEngineBaseResourceListIterator(page EngineBaseResourceListPage) EngineBaseResourceListIterator {
	return EngineBaseResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ebrl EngineBaseResourceList) IsEmpty() bool {
	return ebrl.Value == nil || len(*ebrl.Value) == 0
}

// engineBaseResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ebrl EngineBaseResourceList) engineBaseResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if ebrl.NextLink == nil || len(to.String(ebrl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ebrl.NextLink)))
}

// EngineBaseResourceListPage contains a page of EngineBaseResource values.
type EngineBaseResourceListPage struct {
	fn   func(context.Context, EngineBaseResourceList) (EngineBaseResourceList, error)
	ebrl EngineBaseResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EngineBaseResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EngineBaseResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ebrl)
	if err != nil {
		return err
	}
	page.ebrl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EngineBaseResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EngineBaseResourceListPage) NotDone() bool {
	return !page.ebrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EngineBaseResourceListPage) Response() EngineBaseResourceList {
	return page.ebrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EngineBaseResourceListPage) Values() []EngineBaseResource {
	if page.ebrl.IsEmpty() {
		return nil
	}
	return *page.ebrl.Value
}

// Creates a new instance of the EngineBaseResourceListPage type.
func NewEngineBaseResourceListPage(getNextPage func(context.Context, EngineBaseResourceList) (EngineBaseResourceList, error)) EngineBaseResourceListPage {
	return EngineBaseResourceListPage{fn: getNextPage}
}

// EngineExtendedInfo additional information on backup engine.
type EngineExtendedInfo struct {
	// DatabaseName - Database name of backup engine.
	DatabaseName *string `json:"databaseName,omitempty"`
	// ProtectedItemsCount - Number of protected items in the backup engine.
	ProtectedItemsCount *int32 `json:"protectedItemsCount,omitempty"`
	// ProtectedServersCount - Number of protected servers in the backup engine.
	ProtectedServersCount *int32 `json:"protectedServersCount,omitempty"`
	// DiskCount - Number of disks in the backup engine.
	DiskCount *int32 `json:"diskCount,omitempty"`
	// UsedDiskSpace - Disk space used in the backup engine.
	UsedDiskSpace *float64 `json:"usedDiskSpace,omitempty"`
	// AvailableDiskSpace - Disk space currently available in the backup engine.
	AvailableDiskSpace *float64 `json:"availableDiskSpace,omitempty"`
	// RefreshedAt - Last refresh time in the backup engine.
	RefreshedAt *date.Time `json:"refreshedAt,omitempty"`
	// AzureProtectedInstances - Protected instances in the backup engine.
	AzureProtectedInstances *int32 `json:"azureProtectedInstances,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// ErrorDetail error Detail class which encapsulates Code, Message and Recommendations.
type ErrorDetail struct {
	// Code - READ-ONLY; Error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Error Message related to the Code.
	Message *string `json:"message,omitempty"`
	// Recommendations - READ-ONLY; List of recommendation strings.
	Recommendations *[]string `json:"recommendations,omitempty"`
}

// ErrorResponse the resource management error response.
type ErrorResponse struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorResponse `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// ExportJobsOperationResultInfo this class is used to send blob details after exporting jobs.
type ExportJobsOperationResultInfo struct {
	// BlobURL - URL of the blob into which the serialized string of list of jobs is exported.
	BlobURL *string `json:"blobUrl,omitempty"`
	// BlobSasKey - SAS key to access the blob. It expires in 15 mins.
	BlobSasKey *string `json:"blobSasKey,omitempty"`
	// ExcelFileBlobURL - URL of the blob into which the ExcelFile is uploaded.
	ExcelFileBlobURL *string `json:"excelFileBlobUrl,omitempty"`
	// ExcelFileBlobSasKey - SAS key to access the blob. It expires in 15 mins.
	ExcelFileBlobSasKey *string `json:"excelFileBlobSasKey,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeOperationResultInfoBase', 'ObjectTypeExportJobsOperationResultInfo', 'ObjectTypeOperationResultInfo'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for ExportJobsOperationResultInfo.
func (ejori ExportJobsOperationResultInfo) MarshalJSON() ([]byte, error) {
	ejori.ObjectType = ObjectTypeExportJobsOperationResultInfo
	objectMap := make(map[string]interface{})
	if ejori.BlobURL != nil {
		objectMap["blobUrl"] = ejori.BlobURL
	}
	if ejori.BlobSasKey != nil {
		objectMap["blobSasKey"] = ejori.BlobSasKey
	}
	if ejori.ExcelFileBlobURL != nil {
		objectMap["excelFileBlobUrl"] = ejori.ExcelFileBlobURL
	}
	if ejori.ExcelFileBlobSasKey != nil {
		objectMap["excelFileBlobSasKey"] = ejori.ExcelFileBlobSasKey
	}
	if ejori.ObjectType != "" {
		objectMap["objectType"] = ejori.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsExportJobsOperationResultInfo is the BasicOperationResultInfoBase implementation for ExportJobsOperationResultInfo.
func (ejori ExportJobsOperationResultInfo) AsExportJobsOperationResultInfo() (*ExportJobsOperationResultInfo, bool) {
	return &ejori, true
}

// AsOperationResultInfo is the BasicOperationResultInfoBase implementation for ExportJobsOperationResultInfo.
func (ejori ExportJobsOperationResultInfo) AsOperationResultInfo() (*OperationResultInfo, bool) {
	return nil, false
}

// AsOperationResultInfoBase is the BasicOperationResultInfoBase implementation for ExportJobsOperationResultInfo.
func (ejori ExportJobsOperationResultInfo) AsOperationResultInfoBase() (*OperationResultInfoBase, bool) {
	return nil, false
}

// AsBasicOperationResultInfoBase is the BasicOperationResultInfoBase implementation for ExportJobsOperationResultInfo.
func (ejori ExportJobsOperationResultInfo) AsBasicOperationResultInfoBase() (BasicOperationResultInfoBase, bool) {
	return &ejori, true
}

// ExtendedProperties extended Properties for Azure IaasVM Backup.
type ExtendedProperties struct {
	// DiskExclusionProperties - Extended Properties for Disk Exclusion.
	DiskExclusionProperties *DiskExclusionProperties `json:"diskExclusionProperties,omitempty"`
}

// BasicFeatureSupportRequest base class for feature request
type BasicFeatureSupportRequest interface {
	AsAzureBackupGoalFeatureSupportRequest() (*AzureBackupGoalFeatureSupportRequest, bool)
	AsAzureVMResourceFeatureSupportRequest() (*AzureVMResourceFeatureSupportRequest, bool)
	AsFeatureSupportRequest() (*FeatureSupportRequest, bool)
}

// FeatureSupportRequest base class for feature request
type FeatureSupportRequest struct {
	// FeatureType - Possible values include: 'FeatureTypeFeatureSupportRequest', 'FeatureTypeAzureBackupGoals', 'FeatureTypeAzureVMResourceBackup'
	FeatureType FeatureType `json:"featureType,omitempty"`
}

func unmarshalBasicFeatureSupportRequest(body []byte) (BasicFeatureSupportRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["featureType"] {
	case string(FeatureTypeAzureBackupGoals):
		var abgfsr AzureBackupGoalFeatureSupportRequest
		err := json.Unmarshal(body, &abgfsr)
		return abgfsr, err
	case string(FeatureTypeAzureVMResourceBackup):
		var avrfsr AzureVMResourceFeatureSupportRequest
		err := json.Unmarshal(body, &avrfsr)
		return avrfsr, err
	default:
		var fsr FeatureSupportRequest
		err := json.Unmarshal(body, &fsr)
		return fsr, err
	}
}
func unmarshalBasicFeatureSupportRequestArray(body []byte) ([]BasicFeatureSupportRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fsrArray := make([]BasicFeatureSupportRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fsr, err := unmarshalBasicFeatureSupportRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		fsrArray[index] = fsr
	}
	return fsrArray, nil
}

// MarshalJSON is the custom marshaler for FeatureSupportRequest.
func (fsr FeatureSupportRequest) MarshalJSON() ([]byte, error) {
	fsr.FeatureType = FeatureTypeFeatureSupportRequest
	objectMap := make(map[string]interface{})
	if fsr.FeatureType != "" {
		objectMap["featureType"] = fsr.FeatureType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupGoalFeatureSupportRequest is the BasicFeatureSupportRequest implementation for FeatureSupportRequest.
func (fsr FeatureSupportRequest) AsAzureBackupGoalFeatureSupportRequest() (*AzureBackupGoalFeatureSupportRequest, bool) {
	return nil, false
}

// AsAzureVMResourceFeatureSupportRequest is the BasicFeatureSupportRequest implementation for FeatureSupportRequest.
func (fsr FeatureSupportRequest) AsAzureVMResourceFeatureSupportRequest() (*AzureVMResourceFeatureSupportRequest, bool) {
	return nil, false
}

// AsFeatureSupportRequest is the BasicFeatureSupportRequest implementation for FeatureSupportRequest.
func (fsr FeatureSupportRequest) AsFeatureSupportRequest() (*FeatureSupportRequest, bool) {
	return &fsr, true
}

// AsBasicFeatureSupportRequest is the BasicFeatureSupportRequest implementation for FeatureSupportRequest.
func (fsr FeatureSupportRequest) AsBasicFeatureSupportRequest() (BasicFeatureSupportRequest, bool) {
	return &fsr, true
}

// GenericContainer base class for generic container of backup items
type GenericContainer struct {
	// FabricName - Name of the container's fabric
	FabricName *string `json:"fabricName,omitempty"`
	// ExtendedInformation - Extended information (not returned in List container API calls)
	ExtendedInformation *GenericContainerExtendedInfo `json:"extendedInformation,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

// MarshalJSON is the custom marshaler for GenericContainer.
func (gc GenericContainer) MarshalJSON() ([]byte, error) {
	gc.ContainerType = ContainerTypeGenericContainer1
	objectMap := make(map[string]interface{})
	if gc.FabricName != nil {
		objectMap["fabricName"] = gc.FabricName
	}
	if gc.ExtendedInformation != nil {
		objectMap["extendedInformation"] = gc.ExtendedInformation
	}
	if gc.FriendlyName != nil {
		objectMap["friendlyName"] = gc.FriendlyName
	}
	if gc.BackupManagementType != "" {
		objectMap["backupManagementType"] = gc.BackupManagementType
	}
	if gc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = gc.RegistrationStatus
	}
	if gc.HealthStatus != nil {
		objectMap["healthStatus"] = gc.HealthStatus
	}
	if gc.ContainerType != "" {
		objectMap["containerType"] = gc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return nil, false
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return nil, false
}

// AsDpmContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsDpmContainer() (*DpmContainer, bool) {
	return nil, false
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return nil, false
}

// AsGenericContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsGenericContainer() (*GenericContainer, bool) {
	return &gc, true
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return nil, false
}

// AsMabContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for GenericContainer.
func (gc GenericContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &gc, true
}

// GenericContainerExtendedInfo container extended information
type GenericContainerExtendedInfo struct {
	// RawCertData - Public key of container cert
	RawCertData *string `json:"rawCertData,omitempty"`
	// ContainerIdentityInfo - Container identity information
	ContainerIdentityInfo *ContainerIdentityInfo `json:"containerIdentityInfo,omitempty"`
	// ServiceEndpoints - Azure Backup Service Endpoints for the container
	ServiceEndpoints map[string]*string `json:"serviceEndpoints"`
}

// MarshalJSON is the custom marshaler for GenericContainerExtendedInfo.
func (gcei GenericContainerExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gcei.RawCertData != nil {
		objectMap["rawCertData"] = gcei.RawCertData
	}
	if gcei.ContainerIdentityInfo != nil {
		objectMap["containerIdentityInfo"] = gcei.ContainerIdentityInfo
	}
	if gcei.ServiceEndpoints != nil {
		objectMap["serviceEndpoints"] = gcei.ServiceEndpoints
	}
	return json.Marshal(objectMap)
}

// GenericProtectedItem base class for backup items.
type GenericProtectedItem struct {
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// PolicyState - Indicates consistency of policy object and policy applied to this backup item.
	PolicyState *string `json:"policyState,omitempty"`
	// ProtectionState - Backup state of this backup item. Possible values include: 'ProtectionStateInvalid', 'ProtectionStateIRPending', 'ProtectionStateProtected', 'ProtectionStateProtectionError', 'ProtectionStateProtectionStopped', 'ProtectionStateProtectionPaused'
	ProtectionState ProtectionState `json:"protectionState,omitempty"`
	// ProtectedItemID - Data Plane Service ID of the protected item.
	ProtectedItemID *int64 `json:"protectedItemId,omitempty"`
	// SourceAssociations - Loosely coupled (type, value) associations (example - parent of a protected item)
	SourceAssociations map[string]*string `json:"sourceAssociations"`
	// FabricName - Name of this backup item's fabric.
	FabricName *string `json:"fabricName,omitempty"`
	// BackupManagementType - Type of backup management for the backed up item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload this item represents. Possible values include: 'DataSourceTypeInvalid', 'DataSourceTypeVM', 'DataSourceTypeFileFolder', 'DataSourceTypeAzureSQLDb', 'DataSourceTypeSQLDB', 'DataSourceTypeExchange', 'DataSourceTypeSharepoint', 'DataSourceTypeVMwareVM', 'DataSourceTypeSystemState', 'DataSourceTypeClient', 'DataSourceTypeGenericDataSource', 'DataSourceTypeSQLDataBase', 'DataSourceTypeAzureFileShare', 'DataSourceTypeSAPHanaDatabase', 'DataSourceTypeSAPAseDatabase'
	WorkloadType DataSourceType `json:"workloadType,omitempty"`
	// ContainerName - Unique name of container
	ContainerName *string `json:"containerName,omitempty"`
	// SourceResourceID - ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// PolicyID - ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`
	// LastRecoveryPoint - Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *date.Time `json:"lastRecoveryPoint,omitempty"`
	// BackupSetName - Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`
	// CreateMode - Create mode to indicate recovery of existing soft deleted data source or creation of new data source. Possible values include: 'CreateModeInvalid', 'CreateModeDefault', 'CreateModeRecover'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// DeferredDeleteTimeInUTC - Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *date.Time `json:"deferredDeleteTimeInUTC,omitempty"`
	// IsScheduledForDeferredDelete - Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`
	// DeferredDeleteTimeRemaining - Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`
	// IsDeferredDeleteScheduleUpcoming - Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`
	// IsRehydrate - Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`
	// ProtectedItemType - Possible values include: 'ProtectedItemTypeProtectedItem', 'ProtectedItemTypeAzureFileShareProtectedItem', 'ProtectedItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectedItemTypeMicrosoftComputevirtualMachines', 'ProtectedItemTypeAzureIaaSVMProtectedItem', 'ProtectedItemTypeMicrosoftSqlserversdatabases', 'ProtectedItemTypeAzureVMWorkloadProtectedItem', 'ProtectedItemTypeAzureVMWorkloadSAPAseDatabase', 'ProtectedItemTypeAzureVMWorkloadSAPHanaDatabase', 'ProtectedItemTypeAzureVMWorkloadSQLDatabase', 'ProtectedItemTypeDPMProtectedItem', 'ProtectedItemTypeGenericProtectedItem', 'ProtectedItemTypeMabFileFolderProtectedItem'
	ProtectedItemType ProtectedItemType `json:"protectedItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for GenericProtectedItem.
func (gpi GenericProtectedItem) MarshalJSON() ([]byte, error) {
	gpi.ProtectedItemType = ProtectedItemTypeGenericProtectedItem
	objectMap := make(map[string]interface{})
	if gpi.FriendlyName != nil {
		objectMap["friendlyName"] = gpi.FriendlyName
	}
	if gpi.PolicyState != nil {
		objectMap["policyState"] = gpi.PolicyState
	}
	if gpi.ProtectionState != "" {
		objectMap["protectionState"] = gpi.ProtectionState
	}
	if gpi.ProtectedItemID != nil {
		objectMap["protectedItemId"] = gpi.ProtectedItemID
	}
	if gpi.SourceAssociations != nil {
		objectMap["sourceAssociations"] = gpi.SourceAssociations
	}
	if gpi.FabricName != nil {
		objectMap["fabricName"] = gpi.FabricName
	}
	if gpi.BackupManagementType != "" {
		objectMap["backupManagementType"] = gpi.BackupManagementType
	}
	if gpi.WorkloadType != "" {
		objectMap["workloadType"] = gpi.WorkloadType
	}
	if gpi.ContainerName != nil {
		objectMap["containerName"] = gpi.ContainerName
	}
	if gpi.SourceResourceID != nil {
		objectMap["sourceResourceId"] = gpi.SourceResourceID
	}
	if gpi.PolicyID != nil {
		objectMap["policyId"] = gpi.PolicyID
	}
	if gpi.LastRecoveryPoint != nil {
		objectMap["lastRecoveryPoint"] = gpi.LastRecoveryPoint
	}
	if gpi.BackupSetName != nil {
		objectMap["backupSetName"] = gpi.BackupSetName
	}
	if gpi.CreateMode != "" {
		objectMap["createMode"] = gpi.CreateMode
	}
	if gpi.DeferredDeleteTimeInUTC != nil {
		objectMap["deferredDeleteTimeInUTC"] = gpi.DeferredDeleteTimeInUTC
	}
	if gpi.IsScheduledForDeferredDelete != nil {
		objectMap["isScheduledForDeferredDelete"] = gpi.IsScheduledForDeferredDelete
	}
	if gpi.DeferredDeleteTimeRemaining != nil {
		objectMap["deferredDeleteTimeRemaining"] = gpi.DeferredDeleteTimeRemaining
	}
	if gpi.IsDeferredDeleteScheduleUpcoming != nil {
		objectMap["isDeferredDeleteScheduleUpcoming"] = gpi.IsDeferredDeleteScheduleUpcoming
	}
	if gpi.IsRehydrate != nil {
		objectMap["isRehydrate"] = gpi.IsRehydrate
	}
	if gpi.ProtectedItemType != "" {
		objectMap["protectedItemType"] = gpi.ProtectedItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileshareProtectedItem is the BasicProtectedItem implementation for GenericProtectedItem.
func (gpi GenericProtectedItem) AsAzureFileshareProtectedItem() (*AzureFileshareProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectedItem is the BasicProtectedItem implementation for GenericProtectedItem.
func (gpi GenericProtectedItem) AsAzureIaaSClassicComputeVMProtectedItem() (*AzureIaaSClassicComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectedItem is the BasicProtectedItem implementation for GenericProtectedItem.
func (gpi GenericProtectedItem) AsAzureIaaSComputeVMProtectedItem() (*AzureIaaSComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for GenericProtectedItem.
func (gpi GenericProtectedItem) AsAzureIaaSVMProtectedItem() (*AzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for GenericProtectedItem.
func (gpi GenericProtectedItem) AsBasicAzureIaaSVMProtectedItem() (BasicAzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsAzureSQLProtectedItem is the BasicProtectedItem implementation for GenericProtectedItem.
func (gpi GenericProtectedItem) AsAzureSQLProtectedItem() (*AzureSQLProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for GenericProtectedItem.
func (gpi GenericProtectedItem) AsAzureVMWorkloadProtectedItem() (*AzureVMWorkloadProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for GenericProtectedItem.
func (gpi GenericProtectedItem) AsBasicAzureVMWorkloadProtectedItem() (BasicAzureVMWorkloadProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseDatabaseProtectedItem is the BasicProtectedItem implementation for GenericProtectedItem.
func (gpi GenericProtectedItem) AsAzureVMWorkloadSAPAseDatabaseProtectedItem() (*AzureVMWorkloadSAPAseDatabaseProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectedItem is the BasicProtectedItem implementation for GenericProtectedItem.
func (gpi GenericProtectedItem) AsAzureVMWorkloadSAPHanaDatabaseProtectedItem() (*AzureVMWorkloadSAPHanaDatabaseProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectedItem is the BasicProtectedItem implementation for GenericProtectedItem.
func (gpi GenericProtectedItem) AsAzureVMWorkloadSQLDatabaseProtectedItem() (*AzureVMWorkloadSQLDatabaseProtectedItem, bool) {
	return nil, false
}

// AsDPMProtectedItem is the BasicProtectedItem implementation for GenericProtectedItem.
func (gpi GenericProtectedItem) AsDPMProtectedItem() (*DPMProtectedItem, bool) {
	return nil, false
}

// AsGenericProtectedItem is the BasicProtectedItem implementation for GenericProtectedItem.
func (gpi GenericProtectedItem) AsGenericProtectedItem() (*GenericProtectedItem, bool) {
	return &gpi, true
}

// AsMabFileFolderProtectedItem is the BasicProtectedItem implementation for GenericProtectedItem.
func (gpi GenericProtectedItem) AsMabFileFolderProtectedItem() (*MabFileFolderProtectedItem, bool) {
	return nil, false
}

// AsProtectedItem is the BasicProtectedItem implementation for GenericProtectedItem.
func (gpi GenericProtectedItem) AsProtectedItem() (*ProtectedItem, bool) {
	return nil, false
}

// AsBasicProtectedItem is the BasicProtectedItem implementation for GenericProtectedItem.
func (gpi GenericProtectedItem) AsBasicProtectedItem() (BasicProtectedItem, bool) {
	return &gpi, true
}

// GenericProtectionPolicy azure VM (Mercury) workload-specific backup policy.
type GenericProtectionPolicy struct {
	// SubProtectionPolicy - List of sub-protection policies which includes schedule and retention
	SubProtectionPolicy *[]SubProtectionPolicy `json:"subProtectionPolicy,omitempty"`
	// TimeZone - TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
	TimeZone *string `json:"timeZone,omitempty"`
	// FabricName - Name of this policy's fabric.
	FabricName *string `json:"fabricName,omitempty"`
	// ProtectedItemsCount - Number of items associated with this policy.
	ProtectedItemsCount *int32 `json:"protectedItemsCount,omitempty"`
	// BackupManagementType - Possible values include: 'BackupManagementTypeProtectionPolicy', 'BackupManagementTypeAzureWorkload', 'BackupManagementTypeAzureStorage', 'BackupManagementTypeAzureIaasVM', 'BackupManagementTypeAzureSQL', 'BackupManagementTypeGenericProtectionPolicy', 'BackupManagementTypeMAB'
	BackupManagementType ManagementTypeBasicProtectionPolicy `json:"backupManagementType,omitempty"`
}

// MarshalJSON is the custom marshaler for GenericProtectionPolicy.
func (gpp GenericProtectionPolicy) MarshalJSON() ([]byte, error) {
	gpp.BackupManagementType = BackupManagementTypeGenericProtectionPolicy
	objectMap := make(map[string]interface{})
	if gpp.SubProtectionPolicy != nil {
		objectMap["subProtectionPolicy"] = gpp.SubProtectionPolicy
	}
	if gpp.TimeZone != nil {
		objectMap["timeZone"] = gpp.TimeZone
	}
	if gpp.FabricName != nil {
		objectMap["fabricName"] = gpp.FabricName
	}
	if gpp.ProtectedItemsCount != nil {
		objectMap["protectedItemsCount"] = gpp.ProtectedItemsCount
	}
	if gpp.BackupManagementType != "" {
		objectMap["backupManagementType"] = gpp.BackupManagementType
	}
	return json.Marshal(objectMap)
}

// AsAzureVMWorkloadProtectionPolicy is the BasicProtectionPolicy implementation for GenericProtectionPolicy.
func (gpp GenericProtectionPolicy) AsAzureVMWorkloadProtectionPolicy() (*AzureVMWorkloadProtectionPolicy, bool) {
	return nil, false
}

// AsAzureFileShareProtectionPolicy is the BasicProtectionPolicy implementation for GenericProtectionPolicy.
func (gpp GenericProtectionPolicy) AsAzureFileShareProtectionPolicy() (*AzureFileShareProtectionPolicy, bool) {
	return nil, false
}

// AsAzureIaaSVMProtectionPolicy is the BasicProtectionPolicy implementation for GenericProtectionPolicy.
func (gpp GenericProtectionPolicy) AsAzureIaaSVMProtectionPolicy() (*AzureIaaSVMProtectionPolicy, bool) {
	return nil, false
}

// AsAzureSQLProtectionPolicy is the BasicProtectionPolicy implementation for GenericProtectionPolicy.
func (gpp GenericProtectionPolicy) AsAzureSQLProtectionPolicy() (*AzureSQLProtectionPolicy, bool) {
	return nil, false
}

// AsGenericProtectionPolicy is the BasicProtectionPolicy implementation for GenericProtectionPolicy.
func (gpp GenericProtectionPolicy) AsGenericProtectionPolicy() (*GenericProtectionPolicy, bool) {
	return &gpp, true
}

// AsMabProtectionPolicy is the BasicProtectionPolicy implementation for GenericProtectionPolicy.
func (gpp GenericProtectionPolicy) AsMabProtectionPolicy() (*MabProtectionPolicy, bool) {
	return nil, false
}

// AsProtectionPolicy is the BasicProtectionPolicy implementation for GenericProtectionPolicy.
func (gpp GenericProtectionPolicy) AsProtectionPolicy() (*ProtectionPolicy, bool) {
	return nil, false
}

// AsBasicProtectionPolicy is the BasicProtectionPolicy implementation for GenericProtectionPolicy.
func (gpp GenericProtectionPolicy) AsBasicProtectionPolicy() (BasicProtectionPolicy, bool) {
	return &gpp, true
}

// GenericRecoveryPoint generic backup copy.
type GenericRecoveryPoint struct {
	// FriendlyName - Friendly name of the backup copy.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// RecoveryPointType - Type of the backup copy.
	RecoveryPointType *string `json:"recoveryPointType,omitempty"`
	// RecoveryPointTime - Time at which this backup copy was created.
	RecoveryPointTime *date.Time `json:"recoveryPointTime,omitempty"`
	// RecoveryPointAdditionalInfo - Additional information associated with this backup copy.
	RecoveryPointAdditionalInfo *string `json:"recoveryPointAdditionalInfo,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeRecoveryPoint', 'ObjectTypeAzureFileShareRecoveryPoint', 'ObjectTypeAzureWorkloadPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadRecoveryPoint', 'ObjectTypeAzureWorkloadSAPHanaPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadSAPHanaRecoveryPoint', 'ObjectTypeAzureWorkloadSQLPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadSQLRecoveryPoint', 'ObjectTypeGenericRecoveryPoint', 'ObjectTypeIaasVMRecoveryPoint'
	ObjectType ObjectTypeBasicRecoveryPoint `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for GenericRecoveryPoint.
func (grp GenericRecoveryPoint) MarshalJSON() ([]byte, error) {
	grp.ObjectType = ObjectTypeGenericRecoveryPoint
	objectMap := make(map[string]interface{})
	if grp.FriendlyName != nil {
		objectMap["friendlyName"] = grp.FriendlyName
	}
	if grp.RecoveryPointType != nil {
		objectMap["recoveryPointType"] = grp.RecoveryPointType
	}
	if grp.RecoveryPointTime != nil {
		objectMap["recoveryPointTime"] = grp.RecoveryPointTime
	}
	if grp.RecoveryPointAdditionalInfo != nil {
		objectMap["recoveryPointAdditionalInfo"] = grp.RecoveryPointAdditionalInfo
	}
	if grp.ObjectType != "" {
		objectMap["objectType"] = grp.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareRecoveryPoint is the BasicRecoveryPoint implementation for GenericRecoveryPoint.
func (grp GenericRecoveryPoint) AsAzureFileShareRecoveryPoint() (*AzureFileShareRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for GenericRecoveryPoint.
func (grp GenericRecoveryPoint) AsAzureWorkloadPointInTimeRecoveryPoint() (*AzureWorkloadPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for GenericRecoveryPoint.
func (grp GenericRecoveryPoint) AsBasicAzureWorkloadPointInTimeRecoveryPoint() (BasicAzureWorkloadPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadRecoveryPoint is the BasicRecoveryPoint implementation for GenericRecoveryPoint.
func (grp GenericRecoveryPoint) AsAzureWorkloadRecoveryPoint() (*AzureWorkloadRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadRecoveryPoint is the BasicRecoveryPoint implementation for GenericRecoveryPoint.
func (grp GenericRecoveryPoint) AsBasicAzureWorkloadRecoveryPoint() (BasicAzureWorkloadRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSAPHanaPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for GenericRecoveryPoint.
func (grp GenericRecoveryPoint) AsAzureWorkloadSAPHanaPointInTimeRecoveryPoint() (*AzureWorkloadSAPHanaPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSAPHanaRecoveryPoint is the BasicRecoveryPoint implementation for GenericRecoveryPoint.
func (grp GenericRecoveryPoint) AsAzureWorkloadSAPHanaRecoveryPoint() (*AzureWorkloadSAPHanaRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSQLPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for GenericRecoveryPoint.
func (grp GenericRecoveryPoint) AsAzureWorkloadSQLPointInTimeRecoveryPoint() (*AzureWorkloadSQLPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSQLRecoveryPoint is the BasicRecoveryPoint implementation for GenericRecoveryPoint.
func (grp GenericRecoveryPoint) AsAzureWorkloadSQLRecoveryPoint() (*AzureWorkloadSQLRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadSQLRecoveryPoint is the BasicRecoveryPoint implementation for GenericRecoveryPoint.
func (grp GenericRecoveryPoint) AsBasicAzureWorkloadSQLRecoveryPoint() (BasicAzureWorkloadSQLRecoveryPoint, bool) {
	return nil, false
}

// AsGenericRecoveryPoint is the BasicRecoveryPoint implementation for GenericRecoveryPoint.
func (grp GenericRecoveryPoint) AsGenericRecoveryPoint() (*GenericRecoveryPoint, bool) {
	return &grp, true
}

// AsIaasVMRecoveryPoint is the BasicRecoveryPoint implementation for GenericRecoveryPoint.
func (grp GenericRecoveryPoint) AsIaasVMRecoveryPoint() (*IaasVMRecoveryPoint, bool) {
	return nil, false
}

// AsRecoveryPoint is the BasicRecoveryPoint implementation for GenericRecoveryPoint.
func (grp GenericRecoveryPoint) AsRecoveryPoint() (*RecoveryPoint, bool) {
	return nil, false
}

// AsBasicRecoveryPoint is the BasicRecoveryPoint implementation for GenericRecoveryPoint.
func (grp GenericRecoveryPoint) AsBasicRecoveryPoint() (BasicRecoveryPoint, bool) {
	return &grp, true
}

// GetProtectedItemQueryObject filters to list backup items.
type GetProtectedItemQueryObject struct {
	// Expand - Specifies if the additional information should be provided for this item.
	Expand *string `json:"expand,omitempty"`
}

// IaasVMBackupRequest iaaS VM workload-specific backup request.
type IaasVMBackupRequest struct {
	// RecoveryPointExpiryTimeInUTC - Backup copy will expire after the time specified (UTC).
	RecoveryPointExpiryTimeInUTC *date.Time `json:"recoveryPointExpiryTimeInUTC,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeBackupRequest', 'ObjectTypeAzureFileShareBackupRequest', 'ObjectTypeAzureWorkloadBackupRequest', 'ObjectTypeIaasVMBackupRequest'
	ObjectType ObjectTypeBasicRequest `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for IaasVMBackupRequest.
func (ivbr IaasVMBackupRequest) MarshalJSON() ([]byte, error) {
	ivbr.ObjectType = ObjectTypeIaasVMBackupRequest
	objectMap := make(map[string]interface{})
	if ivbr.RecoveryPointExpiryTimeInUTC != nil {
		objectMap["recoveryPointExpiryTimeInUTC"] = ivbr.RecoveryPointExpiryTimeInUTC
	}
	if ivbr.ObjectType != "" {
		objectMap["objectType"] = ivbr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareBackupRequest is the BasicRequest implementation for IaasVMBackupRequest.
func (ivbr IaasVMBackupRequest) AsAzureFileShareBackupRequest() (*AzureFileShareBackupRequest, bool) {
	return nil, false
}

// AsAzureWorkloadBackupRequest is the BasicRequest implementation for IaasVMBackupRequest.
func (ivbr IaasVMBackupRequest) AsAzureWorkloadBackupRequest() (*AzureWorkloadBackupRequest, bool) {
	return nil, false
}

// AsIaasVMBackupRequest is the BasicRequest implementation for IaasVMBackupRequest.
func (ivbr IaasVMBackupRequest) AsIaasVMBackupRequest() (*IaasVMBackupRequest, bool) {
	return &ivbr, true
}

// AsRequest is the BasicRequest implementation for IaasVMBackupRequest.
func (ivbr IaasVMBackupRequest) AsRequest() (*Request, bool) {
	return nil, false
}

// AsBasicRequest is the BasicRequest implementation for IaasVMBackupRequest.
func (ivbr IaasVMBackupRequest) AsBasicRequest() (BasicRequest, bool) {
	return &ivbr, true
}

// BasicIaaSVMContainer iaaS VM workload-specific container.
type BasicIaaSVMContainer interface {
	AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool)
	AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool)
	AsIaaSVMContainer() (*IaaSVMContainer, bool)
}

// IaaSVMContainer iaaS VM workload-specific container.
type IaaSVMContainer struct {
	// VirtualMachineID - Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// VirtualMachineVersion - Specifies whether the container represents a Classic or an Azure Resource Manager VM.
	VirtualMachineVersion *string `json:"virtualMachineVersion,omitempty"`
	// ResourceGroup - Resource group name of Recovery Services Vault.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

func unmarshalBasicIaaSVMContainer(body []byte) (BasicIaaSVMContainer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["containerType"] {
	case string(ContainerTypeMicrosoftClassicComputevirtualMachines):
		var aisccvc AzureIaaSClassicComputeVMContainer
		err := json.Unmarshal(body, &aisccvc)
		return aisccvc, err
	case string(ContainerTypeMicrosoftComputevirtualMachines):
		var aiscvc AzureIaaSComputeVMContainer
		err := json.Unmarshal(body, &aiscvc)
		return aiscvc, err
	default:
		var isc IaaSVMContainer
		err := json.Unmarshal(body, &isc)
		return isc, err
	}
}
func unmarshalBasicIaaSVMContainerArray(body []byte) ([]BasicIaaSVMContainer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	iscArray := make([]BasicIaaSVMContainer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		isc, err := unmarshalBasicIaaSVMContainer(*rawMessage)
		if err != nil {
			return nil, err
		}
		iscArray[index] = isc
	}
	return iscArray, nil
}

// MarshalJSON is the custom marshaler for IaaSVMContainer.
func (isc IaaSVMContainer) MarshalJSON() ([]byte, error) {
	isc.ContainerType = ContainerTypeIaaSVMContainer
	objectMap := make(map[string]interface{})
	if isc.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = isc.VirtualMachineID
	}
	if isc.VirtualMachineVersion != nil {
		objectMap["virtualMachineVersion"] = isc.VirtualMachineVersion
	}
	if isc.ResourceGroup != nil {
		objectMap["resourceGroup"] = isc.ResourceGroup
	}
	if isc.FriendlyName != nil {
		objectMap["friendlyName"] = isc.FriendlyName
	}
	if isc.BackupManagementType != "" {
		objectMap["backupManagementType"] = isc.BackupManagementType
	}
	if isc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = isc.RegistrationStatus
	}
	if isc.HealthStatus != nil {
		objectMap["healthStatus"] = isc.HealthStatus
	}
	if isc.ContainerType != "" {
		objectMap["containerType"] = isc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return nil, false
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return nil, false
}

// AsDpmContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsDpmContainer() (*DpmContainer, bool) {
	return nil, false
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return nil, false
}

// AsGenericContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsGenericContainer() (*GenericContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return &isc, true
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return &isc, true
}

// AsMabContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &isc, true
}

// IaasVMILRRegistrationRequest restore files/folders from a backup copy of IaaS VM.
type IaasVMILRRegistrationRequest struct {
	// RecoveryPointID - ID of the IaaS VM backup copy from where the files/folders have to be restored.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// VirtualMachineID - Fully qualified ARM ID of the virtual machine whose the files / folders have to be restored.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// InitiatorName - iSCSI initiator name.
	InitiatorName *string `json:"initiatorName,omitempty"`
	// RenewExistingRegistration - Whether to renew existing registration with the iSCSI server.
	RenewExistingRegistration *bool `json:"renewExistingRegistration,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeILRRequest', 'ObjectTypeAzureFileShareProvisionILRRequest', 'ObjectTypeIaasVMILRRegistrationRequest'
	ObjectType ObjectTypeBasicILRRequest `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for IaasVMILRRegistrationRequest.
func (ivrr IaasVMILRRegistrationRequest) MarshalJSON() ([]byte, error) {
	ivrr.ObjectType = ObjectTypeIaasVMILRRegistrationRequest
	objectMap := make(map[string]interface{})
	if ivrr.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = ivrr.RecoveryPointID
	}
	if ivrr.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = ivrr.VirtualMachineID
	}
	if ivrr.InitiatorName != nil {
		objectMap["initiatorName"] = ivrr.InitiatorName
	}
	if ivrr.RenewExistingRegistration != nil {
		objectMap["renewExistingRegistration"] = ivrr.RenewExistingRegistration
	}
	if ivrr.ObjectType != "" {
		objectMap["objectType"] = ivrr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProvisionILRRequest is the BasicILRRequest implementation for IaasVMILRRegistrationRequest.
func (ivrr IaasVMILRRegistrationRequest) AsAzureFileShareProvisionILRRequest() (*AzureFileShareProvisionILRRequest, bool) {
	return nil, false
}

// AsIaasVMILRRegistrationRequest is the BasicILRRequest implementation for IaasVMILRRegistrationRequest.
func (ivrr IaasVMILRRegistrationRequest) AsIaasVMILRRegistrationRequest() (*IaasVMILRRegistrationRequest, bool) {
	return &ivrr, true
}

// AsILRRequest is the BasicILRRequest implementation for IaasVMILRRegistrationRequest.
func (ivrr IaasVMILRRegistrationRequest) AsILRRequest() (*ILRRequest, bool) {
	return nil, false
}

// AsBasicILRRequest is the BasicILRRequest implementation for IaasVMILRRegistrationRequest.
func (ivrr IaasVMILRRegistrationRequest) AsBasicILRRequest() (BasicILRRequest, bool) {
	return &ivrr, true
}

// BasicIaaSVMProtectableItem iaaS VM workload-specific backup item.
type BasicIaaSVMProtectableItem interface {
	AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool)
	AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool)
	AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool)
}

// IaaSVMProtectableItem iaaS VM workload-specific backup item.
type IaaSVMProtectableItem struct {
	// VirtualMachineID - Fully qualified ARM ID of the virtual machine.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeAzureFileShare', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeAzureVMWorkloadProtectableItem', 'ProtectableItemTypeSAPAseSystem', 'ProtectableItemTypeSAPHanaDatabase', 'ProtectableItemTypeSAPHanaSystem', 'ProtectableItemTypeSQLAvailabilityGroupContainer', 'ProtectableItemTypeSQLDataBase', 'ProtectableItemTypeSQLInstance', 'ProtectableItemTypeIaaSVMProtectableItem'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

func unmarshalBasicIaaSVMProtectableItem(body []byte) (BasicIaaSVMProtectableItem, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["protectableItemType"] {
	case string(ProtectableItemTypeMicrosoftClassicComputevirtualMachines):
		var aisccvpi AzureIaaSClassicComputeVMProtectableItem
		err := json.Unmarshal(body, &aisccvpi)
		return aisccvpi, err
	case string(ProtectableItemTypeMicrosoftComputevirtualMachines):
		var aiscvpi AzureIaaSComputeVMProtectableItem
		err := json.Unmarshal(body, &aiscvpi)
		return aiscvpi, err
	default:
		var ispi IaaSVMProtectableItem
		err := json.Unmarshal(body, &ispi)
		return ispi, err
	}
}
func unmarshalBasicIaaSVMProtectableItemArray(body []byte) ([]BasicIaaSVMProtectableItem, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ispiArray := make([]BasicIaaSVMProtectableItem, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ispi, err := unmarshalBasicIaaSVMProtectableItem(*rawMessage)
		if err != nil {
			return nil, err
		}
		ispiArray[index] = ispi
	}
	return ispiArray, nil
}

// MarshalJSON is the custom marshaler for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) MarshalJSON() ([]byte, error) {
	ispi.ProtectableItemType = ProtectableItemTypeIaaSVMProtectableItem
	objectMap := make(map[string]interface{})
	if ispi.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = ispi.VirtualMachineID
	}
	if ispi.BackupManagementType != nil {
		objectMap["backupManagementType"] = ispi.BackupManagementType
	}
	if ispi.WorkloadType != nil {
		objectMap["workloadType"] = ispi.WorkloadType
	}
	if ispi.FriendlyName != nil {
		objectMap["friendlyName"] = ispi.FriendlyName
	}
	if ispi.ProtectionState != "" {
		objectMap["protectionState"] = ispi.ProtectionState
	}
	if ispi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = ispi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseSystemProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool) {
	return nil, false
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return &ispi, true
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return &ispi, true
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &ispi, true
}

// IaasVMRecoveryPoint iaaS VM workload specific backup copy.
type IaasVMRecoveryPoint struct {
	// RecoveryPointType - READ-ONLY; Type of the backup copy.
	RecoveryPointType *string `json:"recoveryPointType,omitempty"`
	// RecoveryPointTime - READ-ONLY; Time at which this backup copy was created.
	RecoveryPointTime *date.Time `json:"recoveryPointTime,omitempty"`
	// RecoveryPointAdditionalInfo - READ-ONLY; Additional information associated with this backup copy.
	RecoveryPointAdditionalInfo *string `json:"recoveryPointAdditionalInfo,omitempty"`
	// SourceVMStorageType - READ-ONLY; Storage type of the VM whose backup copy is created.
	SourceVMStorageType *string `json:"sourceVMStorageType,omitempty"`
	// IsSourceVMEncrypted - READ-ONLY; Identifies whether the VM was encrypted when the backup copy is created.
	IsSourceVMEncrypted *bool `json:"isSourceVMEncrypted,omitempty"`
	// KeyAndSecret - Required details for recovering an encrypted VM. Applicable only when IsSourceVMEncrypted is true.
	KeyAndSecret *KeyAndSecretDetails `json:"keyAndSecret,omitempty"`
	// IsInstantIlrSessionActive - Is the session to recover items from this backup copy still active.
	IsInstantIlrSessionActive *bool `json:"isInstantIlrSessionActive,omitempty"`
	// RecoveryPointTierDetails - Recovery point tier information.
	RecoveryPointTierDetails *[]RecoveryPointTierInformation `json:"recoveryPointTierDetails,omitempty"`
	// IsManagedVirtualMachine - Whether VM is with Managed Disks
	IsManagedVirtualMachine *bool `json:"isManagedVirtualMachine,omitempty"`
	// VirtualMachineSize - Virtual Machine Size
	VirtualMachineSize *string `json:"virtualMachineSize,omitempty"`
	// OriginalStorageAccountOption - Original Storage Account Option
	OriginalStorageAccountOption *bool `json:"originalStorageAccountOption,omitempty"`
	// OsType - OS type
	OsType *string `json:"osType,omitempty"`
	// RecoveryPointDiskConfiguration - Disk configuration
	RecoveryPointDiskConfiguration *RecoveryPointDiskConfiguration `json:"recoveryPointDiskConfiguration,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeRecoveryPoint', 'ObjectTypeAzureFileShareRecoveryPoint', 'ObjectTypeAzureWorkloadPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadRecoveryPoint', 'ObjectTypeAzureWorkloadSAPHanaPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadSAPHanaRecoveryPoint', 'ObjectTypeAzureWorkloadSQLPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadSQLRecoveryPoint', 'ObjectTypeGenericRecoveryPoint', 'ObjectTypeIaasVMRecoveryPoint'
	ObjectType ObjectTypeBasicRecoveryPoint `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for IaasVMRecoveryPoint.
func (ivrp IaasVMRecoveryPoint) MarshalJSON() ([]byte, error) {
	ivrp.ObjectType = ObjectTypeIaasVMRecoveryPoint
	objectMap := make(map[string]interface{})
	if ivrp.KeyAndSecret != nil {
		objectMap["keyAndSecret"] = ivrp.KeyAndSecret
	}
	if ivrp.IsInstantIlrSessionActive != nil {
		objectMap["isInstantIlrSessionActive"] = ivrp.IsInstantIlrSessionActive
	}
	if ivrp.RecoveryPointTierDetails != nil {
		objectMap["recoveryPointTierDetails"] = ivrp.RecoveryPointTierDetails
	}
	if ivrp.IsManagedVirtualMachine != nil {
		objectMap["isManagedVirtualMachine"] = ivrp.IsManagedVirtualMachine
	}
	if ivrp.VirtualMachineSize != nil {
		objectMap["virtualMachineSize"] = ivrp.VirtualMachineSize
	}
	if ivrp.OriginalStorageAccountOption != nil {
		objectMap["originalStorageAccountOption"] = ivrp.OriginalStorageAccountOption
	}
	if ivrp.OsType != nil {
		objectMap["osType"] = ivrp.OsType
	}
	if ivrp.RecoveryPointDiskConfiguration != nil {
		objectMap["recoveryPointDiskConfiguration"] = ivrp.RecoveryPointDiskConfiguration
	}
	if ivrp.ObjectType != "" {
		objectMap["objectType"] = ivrp.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareRecoveryPoint is the BasicRecoveryPoint implementation for IaasVMRecoveryPoint.
func (ivrp IaasVMRecoveryPoint) AsAzureFileShareRecoveryPoint() (*AzureFileShareRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for IaasVMRecoveryPoint.
func (ivrp IaasVMRecoveryPoint) AsAzureWorkloadPointInTimeRecoveryPoint() (*AzureWorkloadPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for IaasVMRecoveryPoint.
func (ivrp IaasVMRecoveryPoint) AsBasicAzureWorkloadPointInTimeRecoveryPoint() (BasicAzureWorkloadPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadRecoveryPoint is the BasicRecoveryPoint implementation for IaasVMRecoveryPoint.
func (ivrp IaasVMRecoveryPoint) AsAzureWorkloadRecoveryPoint() (*AzureWorkloadRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadRecoveryPoint is the BasicRecoveryPoint implementation for IaasVMRecoveryPoint.
func (ivrp IaasVMRecoveryPoint) AsBasicAzureWorkloadRecoveryPoint() (BasicAzureWorkloadRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSAPHanaPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for IaasVMRecoveryPoint.
func (ivrp IaasVMRecoveryPoint) AsAzureWorkloadSAPHanaPointInTimeRecoveryPoint() (*AzureWorkloadSAPHanaPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSAPHanaRecoveryPoint is the BasicRecoveryPoint implementation for IaasVMRecoveryPoint.
func (ivrp IaasVMRecoveryPoint) AsAzureWorkloadSAPHanaRecoveryPoint() (*AzureWorkloadSAPHanaRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSQLPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for IaasVMRecoveryPoint.
func (ivrp IaasVMRecoveryPoint) AsAzureWorkloadSQLPointInTimeRecoveryPoint() (*AzureWorkloadSQLPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSQLRecoveryPoint is the BasicRecoveryPoint implementation for IaasVMRecoveryPoint.
func (ivrp IaasVMRecoveryPoint) AsAzureWorkloadSQLRecoveryPoint() (*AzureWorkloadSQLRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadSQLRecoveryPoint is the BasicRecoveryPoint implementation for IaasVMRecoveryPoint.
func (ivrp IaasVMRecoveryPoint) AsBasicAzureWorkloadSQLRecoveryPoint() (BasicAzureWorkloadSQLRecoveryPoint, bool) {
	return nil, false
}

// AsGenericRecoveryPoint is the BasicRecoveryPoint implementation for IaasVMRecoveryPoint.
func (ivrp IaasVMRecoveryPoint) AsGenericRecoveryPoint() (*GenericRecoveryPoint, bool) {
	return nil, false
}

// AsIaasVMRecoveryPoint is the BasicRecoveryPoint implementation for IaasVMRecoveryPoint.
func (ivrp IaasVMRecoveryPoint) AsIaasVMRecoveryPoint() (*IaasVMRecoveryPoint, bool) {
	return &ivrp, true
}

// AsRecoveryPoint is the BasicRecoveryPoint implementation for IaasVMRecoveryPoint.
func (ivrp IaasVMRecoveryPoint) AsRecoveryPoint() (*RecoveryPoint, bool) {
	return nil, false
}

// AsBasicRecoveryPoint is the BasicRecoveryPoint implementation for IaasVMRecoveryPoint.
func (ivrp IaasVMRecoveryPoint) AsBasicRecoveryPoint() (BasicRecoveryPoint, bool) {
	return &ivrp, true
}

// IaasVMRestoreRequest iaaS VM workload-specific restore.
type IaasVMRestoreRequest struct {
	// RecoveryPointID - ID of the backup copy to be recovered.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// RecoveryType - Type of this recovery. Possible values include: 'RecoveryTypeInvalid', 'RecoveryTypeOriginalLocation', 'RecoveryTypeAlternateLocation', 'RecoveryTypeRestoreDisks', 'RecoveryTypeOffline'
	RecoveryType RecoveryType `json:"recoveryType,omitempty"`
	// SourceResourceID - Fully qualified ARM ID of the VM which is being recovered.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// TargetVirtualMachineID - This is the complete ARM Id of the VM that will be created.
	// For e.g. /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string `json:"targetVirtualMachineId,omitempty"`
	// TargetResourceGroupID - This is the ARM Id of the resource group that you want to create for this Virtual machine and other artifacts.
	// For e.g. /subscriptions/{subId}/resourcegroups/{rg}
	TargetResourceGroupID *string `json:"targetResourceGroupId,omitempty"`
	// StorageAccountID - Fully qualified ARM ID of the storage account to which the VM has to be restored.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
	// VirtualNetworkID - This is the virtual network Id of the vnet that will be attached to the virtual machine.
	// User will be validated for join action permissions in the linked access.
	VirtualNetworkID *string `json:"virtualNetworkId,omitempty"`
	// SubnetID - Subnet ID, is the subnet ID associated with the to be restored VM. For Classic VMs it would be
	// {VnetID}/Subnet/{SubnetName} and, for the Azure Resource Manager VMs it would be ARM resource ID used to represent
	// the subnet.
	SubnetID *string `json:"subnetId,omitempty"`
	// TargetDomainNameID - Fully qualified ARM ID of the domain name to be associated to the VM being restored. This applies only to Classic
	// Virtual Machines.
	TargetDomainNameID *string `json:"targetDomainNameId,omitempty"`
	// Region - Region in which the virtual machine is restored.
	Region *string `json:"region,omitempty"`
	// AffinityGroup - Affinity group associated to VM to be restored. Used only for Classic Compute Virtual Machines.
	AffinityGroup *string `json:"affinityGroup,omitempty"`
	// CreateNewCloudService - Should a new cloud service be created while restoring the VM. If this is false, VM will be restored to the same
	// cloud service as it was at the time of backup.
	CreateNewCloudService *bool `json:"createNewCloudService,omitempty"`
	// OriginalStorageAccountOption - Original Storage Account Option
	OriginalStorageAccountOption *bool `json:"originalStorageAccountOption,omitempty"`
	// EncryptionDetails - Details needed if the VM was encrypted at the time of backup.
	EncryptionDetails *EncryptionDetails `json:"encryptionDetails,omitempty"`
	// RestoreDiskLunList - List of Disk LUNs for partial restore
	RestoreDiskLunList *[]int32 `json:"restoreDiskLunList,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeRestoreRequest', 'ObjectTypeAzureFileShareRestoreRequest', 'ObjectTypeAzureWorkloadPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadRestoreRequest', 'ObjectTypeAzureWorkloadSAPHanaPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadSAPHanaRestoreRequest', 'ObjectTypeAzureWorkloadSQLPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadSQLRestoreRequest', 'ObjectTypeIaasVMRestoreRequest'
	ObjectType ObjectTypeBasicRestoreRequest `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for IaasVMRestoreRequest.
func (ivrr IaasVMRestoreRequest) MarshalJSON() ([]byte, error) {
	ivrr.ObjectType = ObjectTypeIaasVMRestoreRequest
	objectMap := make(map[string]interface{})
	if ivrr.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = ivrr.RecoveryPointID
	}
	if ivrr.RecoveryType != "" {
		objectMap["recoveryType"] = ivrr.RecoveryType
	}
	if ivrr.SourceResourceID != nil {
		objectMap["sourceResourceId"] = ivrr.SourceResourceID
	}
	if ivrr.TargetVirtualMachineID != nil {
		objectMap["targetVirtualMachineId"] = ivrr.TargetVirtualMachineID
	}
	if ivrr.TargetResourceGroupID != nil {
		objectMap["targetResourceGroupId"] = ivrr.TargetResourceGroupID
	}
	if ivrr.StorageAccountID != nil {
		objectMap["storageAccountId"] = ivrr.StorageAccountID
	}
	if ivrr.VirtualNetworkID != nil {
		objectMap["virtualNetworkId"] = ivrr.VirtualNetworkID
	}
	if ivrr.SubnetID != nil {
		objectMap["subnetId"] = ivrr.SubnetID
	}
	if ivrr.TargetDomainNameID != nil {
		objectMap["targetDomainNameId"] = ivrr.TargetDomainNameID
	}
	if ivrr.Region != nil {
		objectMap["region"] = ivrr.Region
	}
	if ivrr.AffinityGroup != nil {
		objectMap["affinityGroup"] = ivrr.AffinityGroup
	}
	if ivrr.CreateNewCloudService != nil {
		objectMap["createNewCloudService"] = ivrr.CreateNewCloudService
	}
	if ivrr.OriginalStorageAccountOption != nil {
		objectMap["originalStorageAccountOption"] = ivrr.OriginalStorageAccountOption
	}
	if ivrr.EncryptionDetails != nil {
		objectMap["encryptionDetails"] = ivrr.EncryptionDetails
	}
	if ivrr.RestoreDiskLunList != nil {
		objectMap["restoreDiskLunList"] = ivrr.RestoreDiskLunList
	}
	if ivrr.ObjectType != "" {
		objectMap["objectType"] = ivrr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareRestoreRequest is the BasicRestoreRequest implementation for IaasVMRestoreRequest.
func (ivrr IaasVMRestoreRequest) AsAzureFileShareRestoreRequest() (*AzureFileShareRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadPointInTimeRestoreRequest is the BasicRestoreRequest implementation for IaasVMRestoreRequest.
func (ivrr IaasVMRestoreRequest) AsAzureWorkloadPointInTimeRestoreRequest() (*AzureWorkloadPointInTimeRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadRestoreRequest is the BasicRestoreRequest implementation for IaasVMRestoreRequest.
func (ivrr IaasVMRestoreRequest) AsAzureWorkloadRestoreRequest() (*AzureWorkloadRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureWorkloadRestoreRequest is the BasicRestoreRequest implementation for IaasVMRestoreRequest.
func (ivrr IaasVMRestoreRequest) AsBasicAzureWorkloadRestoreRequest() (BasicAzureWorkloadRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSAPHanaPointInTimeRestoreRequest is the BasicRestoreRequest implementation for IaasVMRestoreRequest.
func (ivrr IaasVMRestoreRequest) AsAzureWorkloadSAPHanaPointInTimeRestoreRequest() (*AzureWorkloadSAPHanaPointInTimeRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSAPHanaRestoreRequest is the BasicRestoreRequest implementation for IaasVMRestoreRequest.
func (ivrr IaasVMRestoreRequest) AsAzureWorkloadSAPHanaRestoreRequest() (*AzureWorkloadSAPHanaRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureWorkloadSAPHanaRestoreRequest is the BasicRestoreRequest implementation for IaasVMRestoreRequest.
func (ivrr IaasVMRestoreRequest) AsBasicAzureWorkloadSAPHanaRestoreRequest() (BasicAzureWorkloadSAPHanaRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSQLPointInTimeRestoreRequest is the BasicRestoreRequest implementation for IaasVMRestoreRequest.
func (ivrr IaasVMRestoreRequest) AsAzureWorkloadSQLPointInTimeRestoreRequest() (*AzureWorkloadSQLPointInTimeRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSQLRestoreRequest is the BasicRestoreRequest implementation for IaasVMRestoreRequest.
func (ivrr IaasVMRestoreRequest) AsAzureWorkloadSQLRestoreRequest() (*AzureWorkloadSQLRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureWorkloadSQLRestoreRequest is the BasicRestoreRequest implementation for IaasVMRestoreRequest.
func (ivrr IaasVMRestoreRequest) AsBasicAzureWorkloadSQLRestoreRequest() (BasicAzureWorkloadSQLRestoreRequest, bool) {
	return nil, false
}

// AsIaasVMRestoreRequest is the BasicRestoreRequest implementation for IaasVMRestoreRequest.
func (ivrr IaasVMRestoreRequest) AsIaasVMRestoreRequest() (*IaasVMRestoreRequest, bool) {
	return &ivrr, true
}

// AsRestoreRequest is the BasicRestoreRequest implementation for IaasVMRestoreRequest.
func (ivrr IaasVMRestoreRequest) AsRestoreRequest() (*RestoreRequest, bool) {
	return nil, false
}

// AsBasicRestoreRequest is the BasicRestoreRequest implementation for IaasVMRestoreRequest.
func (ivrr IaasVMRestoreRequest) AsBasicRestoreRequest() (BasicRestoreRequest, bool) {
	return &ivrr, true
}

// BasicILRRequest parameters to Provision ILR API.
type BasicILRRequest interface {
	AsAzureFileShareProvisionILRRequest() (*AzureFileShareProvisionILRRequest, bool)
	AsIaasVMILRRegistrationRequest() (*IaasVMILRRegistrationRequest, bool)
	AsILRRequest() (*ILRRequest, bool)
}

// ILRRequest parameters to Provision ILR API.
type ILRRequest struct {
	// ObjectType - Possible values include: 'ObjectTypeILRRequest', 'ObjectTypeAzureFileShareProvisionILRRequest', 'ObjectTypeIaasVMILRRegistrationRequest'
	ObjectType ObjectTypeBasicILRRequest `json:"objectType,omitempty"`
}

func unmarshalBasicILRRequest(body []byte) (BasicILRRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeAzureFileShareProvisionILRRequest):
		var afspir AzureFileShareProvisionILRRequest
		err := json.Unmarshal(body, &afspir)
		return afspir, err
	case string(ObjectTypeIaasVMILRRegistrationRequest):
		var ivrr IaasVMILRRegistrationRequest
		err := json.Unmarshal(body, &ivrr)
		return ivrr, err
	default:
		var ir ILRRequest
		err := json.Unmarshal(body, &ir)
		return ir, err
	}
}
func unmarshalBasicILRRequestArray(body []byte) ([]BasicILRRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	irArray := make([]BasicILRRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ir, err := unmarshalBasicILRRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		irArray[index] = ir
	}
	return irArray, nil
}

// MarshalJSON is the custom marshaler for ILRRequest.
func (ir ILRRequest) MarshalJSON() ([]byte, error) {
	ir.ObjectType = ObjectTypeILRRequest
	objectMap := make(map[string]interface{})
	if ir.ObjectType != "" {
		objectMap["objectType"] = ir.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProvisionILRRequest is the BasicILRRequest implementation for ILRRequest.
func (ir ILRRequest) AsAzureFileShareProvisionILRRequest() (*AzureFileShareProvisionILRRequest, bool) {
	return nil, false
}

// AsIaasVMILRRegistrationRequest is the BasicILRRequest implementation for ILRRequest.
func (ir ILRRequest) AsIaasVMILRRegistrationRequest() (*IaasVMILRRegistrationRequest, bool) {
	return nil, false
}

// AsILRRequest is the BasicILRRequest implementation for ILRRequest.
func (ir ILRRequest) AsILRRequest() (*ILRRequest, bool) {
	return &ir, true
}

// AsBasicILRRequest is the BasicILRRequest implementation for ILRRequest.
func (ir ILRRequest) AsBasicILRRequest() (BasicILRRequest, bool) {
	return &ir, true
}

// ILRRequestResource parameters to Provision ILR API.
type ILRRequestResource struct {
	// Properties - ILRRequestResource properties
	Properties BasicILRRequest `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for ILRRequestResource.
func (irr ILRRequestResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = irr.Properties
	if irr.Location != nil {
		objectMap["location"] = irr.Location
	}
	if irr.Tags != nil {
		objectMap["tags"] = irr.Tags
	}
	if irr.ETag != nil {
		objectMap["eTag"] = irr.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ILRRequestResource struct.
func (irr *ILRRequestResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicILRRequest(*v)
				if err != nil {
					return err
				}
				irr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				irr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				irr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				irr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				irr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				irr.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				irr.ETag = &eTag
			}
		}
	}

	return nil
}

// InquiryInfo details about inquired protectable items under a given container.
type InquiryInfo struct {
	// Status - Inquiry Status for this container such as
	// InProgress | Failed | Succeeded
	Status *string `json:"status,omitempty"`
	// ErrorDetail - Error Details if the Status is non-success.
	ErrorDetail *ErrorDetail `json:"errorDetail,omitempty"`
	// InquiryDetails - Inquiry Details which will have workload specific details.
	// For e.g. - For SQL and oracle this will contain different details.
	InquiryDetails *[]WorkloadInquiryDetails `json:"inquiryDetails,omitempty"`
}

// InquiryValidation validation for inquired protectable items under a given container.
type InquiryValidation struct {
	// Status - Status for the Inquiry Validation.
	Status *string `json:"status,omitempty"`
	// ErrorDetail - Error Detail in case the status is non-success.
	ErrorDetail *ErrorDetail `json:"errorDetail,omitempty"`
	// AdditionalDetail - READ-ONLY; Error Additional Detail in case the status is non-success.
	AdditionalDetail *string `json:"additionalDetail,omitempty"`
}

// InstantItemRecoveryTarget target details for file / folder restore.
type InstantItemRecoveryTarget struct {
	// ClientScripts - List of client scripts.
	ClientScripts *[]ClientScriptForConnect `json:"clientScripts,omitempty"`
}

// InstantRPAdditionalDetails ...
type InstantRPAdditionalDetails struct {
	AzureBackupRGNamePrefix *string `json:"azureBackupRGNamePrefix,omitempty"`
	AzureBackupRGNameSuffix *string `json:"azureBackupRGNameSuffix,omitempty"`
}

// BasicJob defines workload agnostic properties for a job.
type BasicJob interface {
	AsAzureIaaSVMJob() (*AzureIaaSVMJob, bool)
	AsAzureStorageJob() (*AzureStorageJob, bool)
	AsAzureWorkloadJob() (*AzureWorkloadJob, bool)
	AsDpmJob() (*DpmJob, bool)
	AsMabJob() (*MabJob, bool)
	AsJob() (*Job, bool)
}

// Job defines workload agnostic properties for a job.
type Job struct {
	// EntityFriendlyName - Friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string `json:"entityFriendlyName,omitempty"`
	// BackupManagementType - Backup management type to execute the current job. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// Operation - The operation name.
	Operation *string `json:"operation,omitempty"`
	// Status - Job status.
	Status *string `json:"status,omitempty"`
	// StartTime - The start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ActivityID - ActivityId of job.
	ActivityID *string `json:"activityId,omitempty"`
	// JobType - Possible values include: 'JobTypeJob', 'JobTypeAzureIaaSVMJob', 'JobTypeAzureStorageJob', 'JobTypeAzureWorkloadJob', 'JobTypeDpmJob', 'JobTypeMabJob'
	JobType JobType `json:"jobType,omitempty"`
}

func unmarshalBasicJob(body []byte) (BasicJob, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["jobType"] {
	case string(JobTypeAzureIaaSVMJob):
		var aisj AzureIaaSVMJob
		err := json.Unmarshal(body, &aisj)
		return aisj, err
	case string(JobTypeAzureStorageJob):
		var asj AzureStorageJob
		err := json.Unmarshal(body, &asj)
		return asj, err
	case string(JobTypeAzureWorkloadJob):
		var awj AzureWorkloadJob
		err := json.Unmarshal(body, &awj)
		return awj, err
	case string(JobTypeDpmJob):
		var dj DpmJob
		err := json.Unmarshal(body, &dj)
		return dj, err
	case string(JobTypeMabJob):
		var mj MabJob
		err := json.Unmarshal(body, &mj)
		return mj, err
	default:
		var j Job
		err := json.Unmarshal(body, &j)
		return j, err
	}
}
func unmarshalBasicJobArray(body []byte) ([]BasicJob, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	jArray := make([]BasicJob, len(rawMessages))

	for index, rawMessage := range rawMessages {
		j, err := unmarshalBasicJob(*rawMessage)
		if err != nil {
			return nil, err
		}
		jArray[index] = j
	}
	return jArray, nil
}

// MarshalJSON is the custom marshaler for Job.
func (j Job) MarshalJSON() ([]byte, error) {
	j.JobType = JobTypeJob
	objectMap := make(map[string]interface{})
	if j.EntityFriendlyName != nil {
		objectMap["entityFriendlyName"] = j.EntityFriendlyName
	}
	if j.BackupManagementType != "" {
		objectMap["backupManagementType"] = j.BackupManagementType
	}
	if j.Operation != nil {
		objectMap["operation"] = j.Operation
	}
	if j.Status != nil {
		objectMap["status"] = j.Status
	}
	if j.StartTime != nil {
		objectMap["startTime"] = j.StartTime
	}
	if j.EndTime != nil {
		objectMap["endTime"] = j.EndTime
	}
	if j.ActivityID != nil {
		objectMap["activityId"] = j.ActivityID
	}
	if j.JobType != "" {
		objectMap["jobType"] = j.JobType
	}
	return json.Marshal(objectMap)
}

// AsAzureIaaSVMJob is the BasicJob implementation for Job.
func (j Job) AsAzureIaaSVMJob() (*AzureIaaSVMJob, bool) {
	return nil, false
}

// AsAzureStorageJob is the BasicJob implementation for Job.
func (j Job) AsAzureStorageJob() (*AzureStorageJob, bool) {
	return nil, false
}

// AsAzureWorkloadJob is the BasicJob implementation for Job.
func (j Job) AsAzureWorkloadJob() (*AzureWorkloadJob, bool) {
	return nil, false
}

// AsDpmJob is the BasicJob implementation for Job.
func (j Job) AsDpmJob() (*DpmJob, bool) {
	return nil, false
}

// AsMabJob is the BasicJob implementation for Job.
func (j Job) AsMabJob() (*MabJob, bool) {
	return nil, false
}

// AsJob is the BasicJob implementation for Job.
func (j Job) AsJob() (*Job, bool) {
	return &j, true
}

// AsBasicJob is the BasicJob implementation for Job.
func (j Job) AsBasicJob() (BasicJob, bool) {
	return &j, true
}

// JobQueryObject filters to list the jobs.
type JobQueryObject struct {
	// Status - Status of the job. Possible values include: 'JobStatusInvalid', 'JobStatusInProgress', 'JobStatusCompleted', 'JobStatusFailed', 'JobStatusCompletedWithWarnings', 'JobStatusCancelled', 'JobStatusCancelling'
	Status JobStatus `json:"status,omitempty"`
	// BackupManagementType - Type of backup management for the job. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// Operation - Type of operation. Possible values include: 'JobOperationTypeInvalid', 'JobOperationTypeRegister', 'JobOperationTypeUnRegister', 'JobOperationTypeConfigureBackup', 'JobOperationTypeBackup', 'JobOperationTypeRestore', 'JobOperationTypeDisableBackup', 'JobOperationTypeDeleteBackupData', 'JobOperationTypeCrossRegionRestore', 'JobOperationTypeUndelete'
	Operation JobOperationType `json:"operation,omitempty"`
	// JobID - JobID represents the job uniquely.
	JobID *string `json:"jobId,omitempty"`
	// StartTime - Job has started at this time. Value is in UTC.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Job has ended at this time. Value is in UTC.
	EndTime *date.Time `json:"endTime,omitempty"`
}

// JobResource defines workload agnostic properties for a job.
type JobResource struct {
	autorest.Response `json:"-"`
	// Properties - JobResource properties
	Properties BasicJob `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for JobResource.
func (jr JobResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = jr.Properties
	if jr.Location != nil {
		objectMap["location"] = jr.Location
	}
	if jr.Tags != nil {
		objectMap["tags"] = jr.Tags
	}
	if jr.ETag != nil {
		objectMap["eTag"] = jr.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobResource struct.
func (jr *JobResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicJob(*v)
				if err != nil {
					return err
				}
				jr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				jr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				jr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				jr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				jr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				jr.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				jr.ETag = &eTag
			}
		}
	}

	return nil
}

// JobResourceList list of Job resources
type JobResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of resources.
	Value *[]JobResource `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobResourceListIterator provides access to a complete listing of JobResource values.
type JobResourceListIterator struct {
	i    int
	page JobResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobResourceListIterator) Response() JobResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobResourceListIterator) Value() JobResource {
	if !iter.page.NotDone() {
		return JobResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobResourceListIterator type.
func NewJobResourceListIterator(page JobResourceListPage) JobResourceListIterator {
	return JobResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jrl JobResourceList) IsEmpty() bool {
	return jrl.Value == nil || len(*jrl.Value) == 0
}

// jobResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jrl JobResourceList) jobResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if jrl.NextLink == nil || len(to.String(jrl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jrl.NextLink)))
}

// JobResourceListPage contains a page of JobResource values.
type JobResourceListPage struct {
	fn  func(context.Context, JobResourceList) (JobResourceList, error)
	jrl JobResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.jrl)
	if err != nil {
		return err
	}
	page.jrl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobResourceListPage) NotDone() bool {
	return !page.jrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobResourceListPage) Response() JobResourceList {
	return page.jrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobResourceListPage) Values() []JobResource {
	if page.jrl.IsEmpty() {
		return nil
	}
	return *page.jrl.Value
}

// Creates a new instance of the JobResourceListPage type.
func NewJobResourceListPage(getNextPage func(context.Context, JobResourceList) (JobResourceList, error)) JobResourceListPage {
	return JobResourceListPage{fn: getNextPage}
}

// KEKDetails KEK is encryption key for BEK.
type KEKDetails struct {
	// KeyURL - Key is KEK.
	KeyURL *string `json:"keyUrl,omitempty"`
	// KeyVaultID - Key Vault ID where this Key is stored.
	KeyVaultID *string `json:"keyVaultId,omitempty"`
	// KeyBackupData - KEK data.
	KeyBackupData *string `json:"keyBackupData,omitempty"`
}

// KeyAndSecretDetails BEK is bitlocker key.
// KEK is encryption key for BEK
// If the VM was encrypted then we will store following details :
// 1. Secret(BEK) - Url + Backup Data + vaultId.
// 2. Key(KEK) - Url + Backup Data + vaultId.
// 3. EncryptionMechanism
// BEK and KEK can potentially have different vault ids.
type KeyAndSecretDetails struct {
	// KekDetails - KEK is encryption key for BEK.
	KekDetails *KEKDetails `json:"kekDetails,omitempty"`
	// BekDetails - BEK is bitlocker encryption key.
	BekDetails *BEKDetails `json:"bekDetails,omitempty"`
	// EncryptionMechanism - Encryption mechanism: None/ SinglePass/ DoublePass
	EncryptionMechanism *string `json:"encryptionMechanism,omitempty"`
}

// LogSchedulePolicy log policy schedule.
type LogSchedulePolicy struct {
	// ScheduleFrequencyInMins - Frequency of the log schedule operation of this policy in minutes.
	ScheduleFrequencyInMins *int32 `json:"scheduleFrequencyInMins,omitempty"`
	// SchedulePolicyType - Possible values include: 'SchedulePolicyTypeSchedulePolicy', 'SchedulePolicyTypeLogSchedulePolicy', 'SchedulePolicyTypeLongTermSchedulePolicy', 'SchedulePolicyTypeSimpleSchedulePolicy'
	SchedulePolicyType SchedulePolicyType `json:"schedulePolicyType,omitempty"`
}

// MarshalJSON is the custom marshaler for LogSchedulePolicy.
func (lsp LogSchedulePolicy) MarshalJSON() ([]byte, error) {
	lsp.SchedulePolicyType = SchedulePolicyTypeLogSchedulePolicy
	objectMap := make(map[string]interface{})
	if lsp.ScheduleFrequencyInMins != nil {
		objectMap["scheduleFrequencyInMins"] = lsp.ScheduleFrequencyInMins
	}
	if lsp.SchedulePolicyType != "" {
		objectMap["schedulePolicyType"] = lsp.SchedulePolicyType
	}
	return json.Marshal(objectMap)
}

// AsLogSchedulePolicy is the BasicSchedulePolicy implementation for LogSchedulePolicy.
func (lsp LogSchedulePolicy) AsLogSchedulePolicy() (*LogSchedulePolicy, bool) {
	return &lsp, true
}

// AsLongTermSchedulePolicy is the BasicSchedulePolicy implementation for LogSchedulePolicy.
func (lsp LogSchedulePolicy) AsLongTermSchedulePolicy() (*LongTermSchedulePolicy, bool) {
	return nil, false
}

// AsSimpleSchedulePolicy is the BasicSchedulePolicy implementation for LogSchedulePolicy.
func (lsp LogSchedulePolicy) AsSimpleSchedulePolicy() (*SimpleSchedulePolicy, bool) {
	return nil, false
}

// AsSchedulePolicy is the BasicSchedulePolicy implementation for LogSchedulePolicy.
func (lsp LogSchedulePolicy) AsSchedulePolicy() (*SchedulePolicy, bool) {
	return nil, false
}

// AsBasicSchedulePolicy is the BasicSchedulePolicy implementation for LogSchedulePolicy.
func (lsp LogSchedulePolicy) AsBasicSchedulePolicy() (BasicSchedulePolicy, bool) {
	return &lsp, true
}

// LongTermRetentionPolicy long term retention policy.
type LongTermRetentionPolicy struct {
	// DailySchedule - Daily retention schedule of the protection policy.
	DailySchedule *DailyRetentionSchedule `json:"dailySchedule,omitempty"`
	// WeeklySchedule - Weekly retention schedule of the protection policy.
	WeeklySchedule *WeeklyRetentionSchedule `json:"weeklySchedule,omitempty"`
	// MonthlySchedule - Monthly retention schedule of the protection policy.
	MonthlySchedule *MonthlyRetentionSchedule `json:"monthlySchedule,omitempty"`
	// YearlySchedule - Yearly retention schedule of the protection policy.
	YearlySchedule *YearlyRetentionSchedule `json:"yearlySchedule,omitempty"`
	// RetentionPolicyType - Possible values include: 'RetentionPolicyTypeRetentionPolicy', 'RetentionPolicyTypeLongTermRetentionPolicy', 'RetentionPolicyTypeSimpleRetentionPolicy'
	RetentionPolicyType RetentionPolicyType `json:"retentionPolicyType,omitempty"`
}

// MarshalJSON is the custom marshaler for LongTermRetentionPolicy.
func (ltrp LongTermRetentionPolicy) MarshalJSON() ([]byte, error) {
	ltrp.RetentionPolicyType = RetentionPolicyTypeLongTermRetentionPolicy
	objectMap := make(map[string]interface{})
	if ltrp.DailySchedule != nil {
		objectMap["dailySchedule"] = ltrp.DailySchedule
	}
	if ltrp.WeeklySchedule != nil {
		objectMap["weeklySchedule"] = ltrp.WeeklySchedule
	}
	if ltrp.MonthlySchedule != nil {
		objectMap["monthlySchedule"] = ltrp.MonthlySchedule
	}
	if ltrp.YearlySchedule != nil {
		objectMap["yearlySchedule"] = ltrp.YearlySchedule
	}
	if ltrp.RetentionPolicyType != "" {
		objectMap["retentionPolicyType"] = ltrp.RetentionPolicyType
	}
	return json.Marshal(objectMap)
}

// AsLongTermRetentionPolicy is the BasicRetentionPolicy implementation for LongTermRetentionPolicy.
func (ltrp LongTermRetentionPolicy) AsLongTermRetentionPolicy() (*LongTermRetentionPolicy, bool) {
	return &ltrp, true
}

// AsSimpleRetentionPolicy is the BasicRetentionPolicy implementation for LongTermRetentionPolicy.
func (ltrp LongTermRetentionPolicy) AsSimpleRetentionPolicy() (*SimpleRetentionPolicy, bool) {
	return nil, false
}

// AsRetentionPolicy is the BasicRetentionPolicy implementation for LongTermRetentionPolicy.
func (ltrp LongTermRetentionPolicy) AsRetentionPolicy() (*RetentionPolicy, bool) {
	return nil, false
}

// AsBasicRetentionPolicy is the BasicRetentionPolicy implementation for LongTermRetentionPolicy.
func (ltrp LongTermRetentionPolicy) AsBasicRetentionPolicy() (BasicRetentionPolicy, bool) {
	return &ltrp, true
}

// LongTermSchedulePolicy long term policy schedule.
type LongTermSchedulePolicy struct {
	// SchedulePolicyType - Possible values include: 'SchedulePolicyTypeSchedulePolicy', 'SchedulePolicyTypeLogSchedulePolicy', 'SchedulePolicyTypeLongTermSchedulePolicy', 'SchedulePolicyTypeSimpleSchedulePolicy'
	SchedulePolicyType SchedulePolicyType `json:"schedulePolicyType,omitempty"`
}

// MarshalJSON is the custom marshaler for LongTermSchedulePolicy.
func (ltsp LongTermSchedulePolicy) MarshalJSON() ([]byte, error) {
	ltsp.SchedulePolicyType = SchedulePolicyTypeLongTermSchedulePolicy
	objectMap := make(map[string]interface{})
	if ltsp.SchedulePolicyType != "" {
		objectMap["schedulePolicyType"] = ltsp.SchedulePolicyType
	}
	return json.Marshal(objectMap)
}

// AsLogSchedulePolicy is the BasicSchedulePolicy implementation for LongTermSchedulePolicy.
func (ltsp LongTermSchedulePolicy) AsLogSchedulePolicy() (*LogSchedulePolicy, bool) {
	return nil, false
}

// AsLongTermSchedulePolicy is the BasicSchedulePolicy implementation for LongTermSchedulePolicy.
func (ltsp LongTermSchedulePolicy) AsLongTermSchedulePolicy() (*LongTermSchedulePolicy, bool) {
	return &ltsp, true
}

// AsSimpleSchedulePolicy is the BasicSchedulePolicy implementation for LongTermSchedulePolicy.
func (ltsp LongTermSchedulePolicy) AsSimpleSchedulePolicy() (*SimpleSchedulePolicy, bool) {
	return nil, false
}

// AsSchedulePolicy is the BasicSchedulePolicy implementation for LongTermSchedulePolicy.
func (ltsp LongTermSchedulePolicy) AsSchedulePolicy() (*SchedulePolicy, bool) {
	return nil, false
}

// AsBasicSchedulePolicy is the BasicSchedulePolicy implementation for LongTermSchedulePolicy.
func (ltsp LongTermSchedulePolicy) AsBasicSchedulePolicy() (BasicSchedulePolicy, bool) {
	return &ltsp, true
}

// MabContainer container with items backed up using MAB backup engine.
type MabContainer struct {
	// CanReRegister - Can the container be registered one more time.
	CanReRegister *bool `json:"canReRegister,omitempty"`
	// ContainerID - ContainerID represents the container.
	ContainerID *int64 `json:"containerId,omitempty"`
	// ProtectedItemCount - Number of items backed up in this container.
	ProtectedItemCount *int64 `json:"protectedItemCount,omitempty"`
	// AgentVersion - Agent version of this container.
	AgentVersion *string `json:"agentVersion,omitempty"`
	// ExtendedInfo - Additional information for this container
	ExtendedInfo *MabContainerExtendedInfo `json:"extendedInfo,omitempty"`
	// MabContainerHealthDetails - Health details on this mab container.
	MabContainerHealthDetails *[]MABContainerHealthDetails `json:"mabContainerHealthDetails,omitempty"`
	// ContainerHealthState - Health state of mab container.
	ContainerHealthState *string `json:"containerHealthState,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

// MarshalJSON is the custom marshaler for MabContainer.
func (mc MabContainer) MarshalJSON() ([]byte, error) {
	mc.ContainerType = ContainerTypeWindows1
	objectMap := make(map[string]interface{})
	if mc.CanReRegister != nil {
		objectMap["canReRegister"] = mc.CanReRegister
	}
	if mc.ContainerID != nil {
		objectMap["containerId"] = mc.ContainerID
	}
	if mc.ProtectedItemCount != nil {
		objectMap["protectedItemCount"] = mc.ProtectedItemCount
	}
	if mc.AgentVersion != nil {
		objectMap["agentVersion"] = mc.AgentVersion
	}
	if mc.ExtendedInfo != nil {
		objectMap["extendedInfo"] = mc.ExtendedInfo
	}
	if mc.MabContainerHealthDetails != nil {
		objectMap["mabContainerHealthDetails"] = mc.MabContainerHealthDetails
	}
	if mc.ContainerHealthState != nil {
		objectMap["containerHealthState"] = mc.ContainerHealthState
	}
	if mc.FriendlyName != nil {
		objectMap["friendlyName"] = mc.FriendlyName
	}
	if mc.BackupManagementType != "" {
		objectMap["backupManagementType"] = mc.BackupManagementType
	}
	if mc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = mc.RegistrationStatus
	}
	if mc.HealthStatus != nil {
		objectMap["healthStatus"] = mc.HealthStatus
	}
	if mc.ContainerType != "" {
		objectMap["containerType"] = mc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return nil, false
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return nil, false
}

// AsDpmContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsDpmContainer() (*DpmContainer, bool) {
	return nil, false
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return nil, false
}

// AsGenericContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsGenericContainer() (*GenericContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return nil, false
}

// AsMabContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsMabContainer() (*MabContainer, bool) {
	return &mc, true
}

// AsProtectionContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &mc, true
}

// MabContainerExtendedInfo additional information of the container.
type MabContainerExtendedInfo struct {
	// LastRefreshedAt - Time stamp when this container was refreshed.
	LastRefreshedAt *date.Time `json:"lastRefreshedAt,omitempty"`
	// BackupItemType - Type of backup items associated with this container. Possible values include: 'ItemTypeInvalid', 'ItemTypeVM', 'ItemTypeFileFolder', 'ItemTypeAzureSQLDb', 'ItemTypeSQLDB', 'ItemTypeExchange', 'ItemTypeSharepoint', 'ItemTypeVMwareVM', 'ItemTypeSystemState', 'ItemTypeClient', 'ItemTypeGenericDataSource', 'ItemTypeSQLDataBase', 'ItemTypeAzureFileShare', 'ItemTypeSAPHanaDatabase', 'ItemTypeSAPAseDatabase'
	BackupItemType ItemType `json:"backupItemType,omitempty"`
	// BackupItems - List of backup items associated with this container.
	BackupItems *[]string `json:"backupItems,omitempty"`
	// PolicyName - Backup policy associated with this container.
	PolicyName *string `json:"policyName,omitempty"`
	// LastBackupStatus - Latest backup status of this container.
	LastBackupStatus *string `json:"lastBackupStatus,omitempty"`
}

// MABContainerHealthDetails MAB workload-specific Health Details.
type MABContainerHealthDetails struct {
	// Code - Health Code
	Code *int32 `json:"code,omitempty"`
	// Title - Health Title
	Title *string `json:"title,omitempty"`
	// Message - Health Message
	Message *string `json:"message,omitempty"`
	// Recommendations - Health Recommended Actions
	Recommendations *[]string `json:"recommendations,omitempty"`
}

// MabErrorInfo MAB workload-specific error information.
type MabErrorInfo struct {
	// ErrorString - READ-ONLY; Localized error string.
	ErrorString *string `json:"errorString,omitempty"`
	// Recommendations - READ-ONLY; List of localized recommendations.
	Recommendations *[]string `json:"recommendations,omitempty"`
}

// MabFileFolderProtectedItem MAB workload-specific backup item.
type MabFileFolderProtectedItem struct {
	// FriendlyName - Friendly name of this backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ComputerName - Name of the computer associated with this backup item.
	ComputerName *string `json:"computerName,omitempty"`
	// LastBackupStatus - Status of last backup operation.
	LastBackupStatus *string `json:"lastBackupStatus,omitempty"`
	// LastBackupTime - Timestamp of the last backup operation on this backup item.
	LastBackupTime *date.Time `json:"lastBackupTime,omitempty"`
	// ProtectionState - Protected, ProtectionStopped, IRPending or ProtectionError
	ProtectionState *string `json:"protectionState,omitempty"`
	// DeferredDeleteSyncTimeInUTC - Sync time for deferred deletion in UTC
	DeferredDeleteSyncTimeInUTC *int64 `json:"deferredDeleteSyncTimeInUTC,omitempty"`
	// ExtendedInfo - Additional information with this backup item.
	ExtendedInfo *MabFileFolderProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`
	// BackupManagementType - Type of backup management for the backed up item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload this item represents. Possible values include: 'DataSourceTypeInvalid', 'DataSourceTypeVM', 'DataSourceTypeFileFolder', 'DataSourceTypeAzureSQLDb', 'DataSourceTypeSQLDB', 'DataSourceTypeExchange', 'DataSourceTypeSharepoint', 'DataSourceTypeVMwareVM', 'DataSourceTypeSystemState', 'DataSourceTypeClient', 'DataSourceTypeGenericDataSource', 'DataSourceTypeSQLDataBase', 'DataSourceTypeAzureFileShare', 'DataSourceTypeSAPHanaDatabase', 'DataSourceTypeSAPAseDatabase'
	WorkloadType DataSourceType `json:"workloadType,omitempty"`
	// ContainerName - Unique name of container
	ContainerName *string `json:"containerName,omitempty"`
	// SourceResourceID - ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// PolicyID - ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`
	// LastRecoveryPoint - Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *date.Time `json:"lastRecoveryPoint,omitempty"`
	// BackupSetName - Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`
	// CreateMode - Create mode to indicate recovery of existing soft deleted data source or creation of new data source. Possible values include: 'CreateModeInvalid', 'CreateModeDefault', 'CreateModeRecover'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// DeferredDeleteTimeInUTC - Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *date.Time `json:"deferredDeleteTimeInUTC,omitempty"`
	// IsScheduledForDeferredDelete - Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`
	// DeferredDeleteTimeRemaining - Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`
	// IsDeferredDeleteScheduleUpcoming - Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`
	// IsRehydrate - Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`
	// ProtectedItemType - Possible values include: 'ProtectedItemTypeProtectedItem', 'ProtectedItemTypeAzureFileShareProtectedItem', 'ProtectedItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectedItemTypeMicrosoftComputevirtualMachines', 'ProtectedItemTypeAzureIaaSVMProtectedItem', 'ProtectedItemTypeMicrosoftSqlserversdatabases', 'ProtectedItemTypeAzureVMWorkloadProtectedItem', 'ProtectedItemTypeAzureVMWorkloadSAPAseDatabase', 'ProtectedItemTypeAzureVMWorkloadSAPHanaDatabase', 'ProtectedItemTypeAzureVMWorkloadSQLDatabase', 'ProtectedItemTypeDPMProtectedItem', 'ProtectedItemTypeGenericProtectedItem', 'ProtectedItemTypeMabFileFolderProtectedItem'
	ProtectedItemType ProtectedItemType `json:"protectedItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) MarshalJSON() ([]byte, error) {
	mffpi.ProtectedItemType = ProtectedItemTypeMabFileFolderProtectedItem
	objectMap := make(map[string]interface{})
	if mffpi.FriendlyName != nil {
		objectMap["friendlyName"] = mffpi.FriendlyName
	}
	if mffpi.ComputerName != nil {
		objectMap["computerName"] = mffpi.ComputerName
	}
	if mffpi.LastBackupStatus != nil {
		objectMap["lastBackupStatus"] = mffpi.LastBackupStatus
	}
	if mffpi.LastBackupTime != nil {
		objectMap["lastBackupTime"] = mffpi.LastBackupTime
	}
	if mffpi.ProtectionState != nil {
		objectMap["protectionState"] = mffpi.ProtectionState
	}
	if mffpi.DeferredDeleteSyncTimeInUTC != nil {
		objectMap["deferredDeleteSyncTimeInUTC"] = mffpi.DeferredDeleteSyncTimeInUTC
	}
	if mffpi.ExtendedInfo != nil {
		objectMap["extendedInfo"] = mffpi.ExtendedInfo
	}
	if mffpi.BackupManagementType != "" {
		objectMap["backupManagementType"] = mffpi.BackupManagementType
	}
	if mffpi.WorkloadType != "" {
		objectMap["workloadType"] = mffpi.WorkloadType
	}
	if mffpi.ContainerName != nil {
		objectMap["containerName"] = mffpi.ContainerName
	}
	if mffpi.SourceResourceID != nil {
		objectMap["sourceResourceId"] = mffpi.SourceResourceID
	}
	if mffpi.PolicyID != nil {
		objectMap["policyId"] = mffpi.PolicyID
	}
	if mffpi.LastRecoveryPoint != nil {
		objectMap["lastRecoveryPoint"] = mffpi.LastRecoveryPoint
	}
	if mffpi.BackupSetName != nil {
		objectMap["backupSetName"] = mffpi.BackupSetName
	}
	if mffpi.CreateMode != "" {
		objectMap["createMode"] = mffpi.CreateMode
	}
	if mffpi.DeferredDeleteTimeInUTC != nil {
		objectMap["deferredDeleteTimeInUTC"] = mffpi.DeferredDeleteTimeInUTC
	}
	if mffpi.IsScheduledForDeferredDelete != nil {
		objectMap["isScheduledForDeferredDelete"] = mffpi.IsScheduledForDeferredDelete
	}
	if mffpi.DeferredDeleteTimeRemaining != nil {
		objectMap["deferredDeleteTimeRemaining"] = mffpi.DeferredDeleteTimeRemaining
	}
	if mffpi.IsDeferredDeleteScheduleUpcoming != nil {
		objectMap["isDeferredDeleteScheduleUpcoming"] = mffpi.IsDeferredDeleteScheduleUpcoming
	}
	if mffpi.IsRehydrate != nil {
		objectMap["isRehydrate"] = mffpi.IsRehydrate
	}
	if mffpi.ProtectedItemType != "" {
		objectMap["protectedItemType"] = mffpi.ProtectedItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileshareProtectedItem is the BasicProtectedItem implementation for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) AsAzureFileshareProtectedItem() (*AzureFileshareProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectedItem is the BasicProtectedItem implementation for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) AsAzureIaaSClassicComputeVMProtectedItem() (*AzureIaaSClassicComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectedItem is the BasicProtectedItem implementation for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) AsAzureIaaSComputeVMProtectedItem() (*AzureIaaSComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) AsAzureIaaSVMProtectedItem() (*AzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) AsBasicAzureIaaSVMProtectedItem() (BasicAzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsAzureSQLProtectedItem is the BasicProtectedItem implementation for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) AsAzureSQLProtectedItem() (*AzureSQLProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) AsAzureVMWorkloadProtectedItem() (*AzureVMWorkloadProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) AsBasicAzureVMWorkloadProtectedItem() (BasicAzureVMWorkloadProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseDatabaseProtectedItem is the BasicProtectedItem implementation for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) AsAzureVMWorkloadSAPAseDatabaseProtectedItem() (*AzureVMWorkloadSAPAseDatabaseProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectedItem is the BasicProtectedItem implementation for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) AsAzureVMWorkloadSAPHanaDatabaseProtectedItem() (*AzureVMWorkloadSAPHanaDatabaseProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectedItem is the BasicProtectedItem implementation for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) AsAzureVMWorkloadSQLDatabaseProtectedItem() (*AzureVMWorkloadSQLDatabaseProtectedItem, bool) {
	return nil, false
}

// AsDPMProtectedItem is the BasicProtectedItem implementation for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) AsDPMProtectedItem() (*DPMProtectedItem, bool) {
	return nil, false
}

// AsGenericProtectedItem is the BasicProtectedItem implementation for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) AsGenericProtectedItem() (*GenericProtectedItem, bool) {
	return nil, false
}

// AsMabFileFolderProtectedItem is the BasicProtectedItem implementation for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) AsMabFileFolderProtectedItem() (*MabFileFolderProtectedItem, bool) {
	return &mffpi, true
}

// AsProtectedItem is the BasicProtectedItem implementation for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) AsProtectedItem() (*ProtectedItem, bool) {
	return nil, false
}

// AsBasicProtectedItem is the BasicProtectedItem implementation for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) AsBasicProtectedItem() (BasicProtectedItem, bool) {
	return &mffpi, true
}

// MabFileFolderProtectedItemExtendedInfo additional information on the backed up item.
type MabFileFolderProtectedItemExtendedInfo struct {
	// LastRefreshedAt - Last time when the agent data synced to service.
	LastRefreshedAt *date.Time `json:"lastRefreshedAt,omitempty"`
	// OldestRecoveryPoint - The oldest backup copy available.
	OldestRecoveryPoint *date.Time `json:"oldestRecoveryPoint,omitempty"`
	// RecoveryPointCount - Number of backup copies associated with the backup item.
	RecoveryPointCount *int32 `json:"recoveryPointCount,omitempty"`
}

// MabJob MAB workload-specific job.
type MabJob struct {
	// Duration - Time taken by job to run.
	Duration *string `json:"duration,omitempty"`
	// ActionsInfo - The state/actions applicable on jobs like cancel/retry.
	ActionsInfo *[]JobSupportedAction `json:"actionsInfo,omitempty"`
	// MabServerName - Name of server protecting the DS.
	MabServerName *string `json:"mabServerName,omitempty"`
	// MabServerType - Server type of MAB container. Possible values include: 'MabServerTypeInvalid', 'MabServerTypeUnknown', 'MabServerTypeIaasVMContainer', 'MabServerTypeIaasVMServiceContainer', 'MabServerTypeDPMContainer', 'MabServerTypeAzureBackupServerContainer', 'MabServerTypeMABContainer', 'MabServerTypeCluster', 'MabServerTypeAzureSQLContainer', 'MabServerTypeWindows', 'MabServerTypeVCenter', 'MabServerTypeVMAppContainer', 'MabServerTypeSQLAGWorkLoadContainer', 'MabServerTypeStorageContainer', 'MabServerTypeGenericContainer'
	MabServerType MabServerType `json:"mabServerType,omitempty"`
	// WorkloadType - Workload type of backup item. Possible values include: 'WorkloadTypeInvalid', 'WorkloadTypeVM', 'WorkloadTypeFileFolder', 'WorkloadTypeAzureSQLDb', 'WorkloadTypeSQLDB', 'WorkloadTypeExchange', 'WorkloadTypeSharepoint', 'WorkloadTypeVMwareVM', 'WorkloadTypeSystemState', 'WorkloadTypeClient', 'WorkloadTypeGenericDataSource', 'WorkloadTypeSQLDataBase', 'WorkloadTypeAzureFileShare', 'WorkloadTypeSAPHanaDatabase', 'WorkloadTypeSAPAseDatabase'
	WorkloadType WorkloadType `json:"workloadType,omitempty"`
	// ErrorDetails - The errors.
	ErrorDetails *[]MabErrorInfo `json:"errorDetails,omitempty"`
	// ExtendedInfo - Additional information on the job.
	ExtendedInfo *MabJobExtendedInfo `json:"extendedInfo,omitempty"`
	// EntityFriendlyName - Friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string `json:"entityFriendlyName,omitempty"`
	// BackupManagementType - Backup management type to execute the current job. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// Operation - The operation name.
	Operation *string `json:"operation,omitempty"`
	// Status - Job status.
	Status *string `json:"status,omitempty"`
	// StartTime - The start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ActivityID - ActivityId of job.
	ActivityID *string `json:"activityId,omitempty"`
	// JobType - Possible values include: 'JobTypeJob', 'JobTypeAzureIaaSVMJob', 'JobTypeAzureStorageJob', 'JobTypeAzureWorkloadJob', 'JobTypeDpmJob', 'JobTypeMabJob'
	JobType JobType `json:"jobType,omitempty"`
}

// MarshalJSON is the custom marshaler for MabJob.
func (mj MabJob) MarshalJSON() ([]byte, error) {
	mj.JobType = JobTypeMabJob
	objectMap := make(map[string]interface{})
	if mj.Duration != nil {
		objectMap["duration"] = mj.Duration
	}
	if mj.ActionsInfo != nil {
		objectMap["actionsInfo"] = mj.ActionsInfo
	}
	if mj.MabServerName != nil {
		objectMap["mabServerName"] = mj.MabServerName
	}
	if mj.MabServerType != "" {
		objectMap["mabServerType"] = mj.MabServerType
	}
	if mj.WorkloadType != "" {
		objectMap["workloadType"] = mj.WorkloadType
	}
	if mj.ErrorDetails != nil {
		objectMap["errorDetails"] = mj.ErrorDetails
	}
	if mj.ExtendedInfo != nil {
		objectMap["extendedInfo"] = mj.ExtendedInfo
	}
	if mj.EntityFriendlyName != nil {
		objectMap["entityFriendlyName"] = mj.EntityFriendlyName
	}
	if mj.BackupManagementType != "" {
		objectMap["backupManagementType"] = mj.BackupManagementType
	}
	if mj.Operation != nil {
		objectMap["operation"] = mj.Operation
	}
	if mj.Status != nil {
		objectMap["status"] = mj.Status
	}
	if mj.StartTime != nil {
		objectMap["startTime"] = mj.StartTime
	}
	if mj.EndTime != nil {
		objectMap["endTime"] = mj.EndTime
	}
	if mj.ActivityID != nil {
		objectMap["activityId"] = mj.ActivityID
	}
	if mj.JobType != "" {
		objectMap["jobType"] = mj.JobType
	}
	return json.Marshal(objectMap)
}

// AsAzureIaaSVMJob is the BasicJob implementation for MabJob.
func (mj MabJob) AsAzureIaaSVMJob() (*AzureIaaSVMJob, bool) {
	return nil, false
}

// AsAzureStorageJob is the BasicJob implementation for MabJob.
func (mj MabJob) AsAzureStorageJob() (*AzureStorageJob, bool) {
	return nil, false
}

// AsAzureWorkloadJob is the BasicJob implementation for MabJob.
func (mj MabJob) AsAzureWorkloadJob() (*AzureWorkloadJob, bool) {
	return nil, false
}

// AsDpmJob is the BasicJob implementation for MabJob.
func (mj MabJob) AsDpmJob() (*DpmJob, bool) {
	return nil, false
}

// AsMabJob is the BasicJob implementation for MabJob.
func (mj MabJob) AsMabJob() (*MabJob, bool) {
	return &mj, true
}

// AsJob is the BasicJob implementation for MabJob.
func (mj MabJob) AsJob() (*Job, bool) {
	return nil, false
}

// AsBasicJob is the BasicJob implementation for MabJob.
func (mj MabJob) AsBasicJob() (BasicJob, bool) {
	return &mj, true
}

// MabJobExtendedInfo additional information for the MAB workload-specific job.
type MabJobExtendedInfo struct {
	// TasksList - List of tasks for this job.
	TasksList *[]MabJobTaskDetails `json:"tasksList,omitempty"`
	// PropertyBag - The job properties.
	PropertyBag map[string]*string `json:"propertyBag"`
	// DynamicErrorMessage - Non localized error message specific to this job.
	DynamicErrorMessage *string `json:"dynamicErrorMessage,omitempty"`
}

// MarshalJSON is the custom marshaler for MabJobExtendedInfo.
func (mjei MabJobExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mjei.TasksList != nil {
		objectMap["tasksList"] = mjei.TasksList
	}
	if mjei.PropertyBag != nil {
		objectMap["propertyBag"] = mjei.PropertyBag
	}
	if mjei.DynamicErrorMessage != nil {
		objectMap["dynamicErrorMessage"] = mjei.DynamicErrorMessage
	}
	return json.Marshal(objectMap)
}

// MabJobTaskDetails MAB workload-specific job task details.
type MabJobTaskDetails struct {
	// TaskID - The task display name.
	TaskID *string `json:"taskId,omitempty"`
	// StartTime - The start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Duration - Time elapsed for task.
	Duration *string `json:"duration,omitempty"`
	// Status - The status.
	Status *string `json:"status,omitempty"`
}

// MabProtectionPolicy mab container-specific backup policy.
type MabProtectionPolicy struct {
	// SchedulePolicy - Backup schedule of backup policy.
	SchedulePolicy BasicSchedulePolicy `json:"schedulePolicy,omitempty"`
	// RetentionPolicy - Retention policy details.
	RetentionPolicy BasicRetentionPolicy `json:"retentionPolicy,omitempty"`
	// ProtectedItemsCount - Number of items associated with this policy.
	ProtectedItemsCount *int32 `json:"protectedItemsCount,omitempty"`
	// BackupManagementType - Possible values include: 'BackupManagementTypeProtectionPolicy', 'BackupManagementTypeAzureWorkload', 'BackupManagementTypeAzureStorage', 'BackupManagementTypeAzureIaasVM', 'BackupManagementTypeAzureSQL', 'BackupManagementTypeGenericProtectionPolicy', 'BackupManagementTypeMAB'
	BackupManagementType ManagementTypeBasicProtectionPolicy `json:"backupManagementType,omitempty"`
}

// MarshalJSON is the custom marshaler for MabProtectionPolicy.
func (mpp MabProtectionPolicy) MarshalJSON() ([]byte, error) {
	mpp.BackupManagementType = BackupManagementTypeMAB
	objectMap := make(map[string]interface{})
	objectMap["schedulePolicy"] = mpp.SchedulePolicy
	objectMap["retentionPolicy"] = mpp.RetentionPolicy
	if mpp.ProtectedItemsCount != nil {
		objectMap["protectedItemsCount"] = mpp.ProtectedItemsCount
	}
	if mpp.BackupManagementType != "" {
		objectMap["backupManagementType"] = mpp.BackupManagementType
	}
	return json.Marshal(objectMap)
}

// AsAzureVMWorkloadProtectionPolicy is the BasicProtectionPolicy implementation for MabProtectionPolicy.
func (mpp MabProtectionPolicy) AsAzureVMWorkloadProtectionPolicy() (*AzureVMWorkloadProtectionPolicy, bool) {
	return nil, false
}

// AsAzureFileShareProtectionPolicy is the BasicProtectionPolicy implementation for MabProtectionPolicy.
func (mpp MabProtectionPolicy) AsAzureFileShareProtectionPolicy() (*AzureFileShareProtectionPolicy, bool) {
	return nil, false
}

// AsAzureIaaSVMProtectionPolicy is the BasicProtectionPolicy implementation for MabProtectionPolicy.
func (mpp MabProtectionPolicy) AsAzureIaaSVMProtectionPolicy() (*AzureIaaSVMProtectionPolicy, bool) {
	return nil, false
}

// AsAzureSQLProtectionPolicy is the BasicProtectionPolicy implementation for MabProtectionPolicy.
func (mpp MabProtectionPolicy) AsAzureSQLProtectionPolicy() (*AzureSQLProtectionPolicy, bool) {
	return nil, false
}

// AsGenericProtectionPolicy is the BasicProtectionPolicy implementation for MabProtectionPolicy.
func (mpp MabProtectionPolicy) AsGenericProtectionPolicy() (*GenericProtectionPolicy, bool) {
	return nil, false
}

// AsMabProtectionPolicy is the BasicProtectionPolicy implementation for MabProtectionPolicy.
func (mpp MabProtectionPolicy) AsMabProtectionPolicy() (*MabProtectionPolicy, bool) {
	return &mpp, true
}

// AsProtectionPolicy is the BasicProtectionPolicy implementation for MabProtectionPolicy.
func (mpp MabProtectionPolicy) AsProtectionPolicy() (*ProtectionPolicy, bool) {
	return nil, false
}

// AsBasicProtectionPolicy is the BasicProtectionPolicy implementation for MabProtectionPolicy.
func (mpp MabProtectionPolicy) AsBasicProtectionPolicy() (BasicProtectionPolicy, bool) {
	return &mpp, true
}

// UnmarshalJSON is the custom unmarshaler for MabProtectionPolicy struct.
func (mpp *MabProtectionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "schedulePolicy":
			if v != nil {
				schedulePolicy, err := unmarshalBasicSchedulePolicy(*v)
				if err != nil {
					return err
				}
				mpp.SchedulePolicy = schedulePolicy
			}
		case "retentionPolicy":
			if v != nil {
				retentionPolicy, err := unmarshalBasicRetentionPolicy(*v)
				if err != nil {
					return err
				}
				mpp.RetentionPolicy = retentionPolicy
			}
		case "protectedItemsCount":
			if v != nil {
				var protectedItemsCount int32
				err = json.Unmarshal(*v, &protectedItemsCount)
				if err != nil {
					return err
				}
				mpp.ProtectedItemsCount = &protectedItemsCount
			}
		case "backupManagementType":
			if v != nil {
				var backupManagementType ManagementTypeBasicProtectionPolicy
				err = json.Unmarshal(*v, &backupManagementType)
				if err != nil {
					return err
				}
				mpp.BackupManagementType = backupManagementType
			}
		}
	}

	return nil
}

// ManagementUsage backup management usages of a vault.
type ManagementUsage struct {
	// Unit - Unit of the usage. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond'
	Unit UsagesUnit `json:"unit,omitempty"`
	// QuotaPeriod - Quota period of usage.
	QuotaPeriod *string `json:"quotaPeriod,omitempty"`
	// NextResetTime - Next reset time of usage.
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
	// CurrentValue - Current value of usage.
	CurrentValue *int64 `json:"currentValue,omitempty"`
	// Limit - Limit of usage.
	Limit *int64 `json:"limit,omitempty"`
	// Name - Name of usage.
	Name *NameInfo `json:"name,omitempty"`
}

// ManagementUsageList backup management usage for vault.
type ManagementUsageList struct {
	autorest.Response `json:"-"`
	// Value - The list of backup management usages for the given vault.
	Value *[]ManagementUsage `json:"value,omitempty"`
}

// MonthlyRetentionSchedule monthly retention schedule.
type MonthlyRetentionSchedule struct {
	// RetentionScheduleFormatType - Retention schedule format type for monthly retention policy. Possible values include: 'RetentionScheduleFormatInvalid', 'RetentionScheduleFormatDaily', 'RetentionScheduleFormatWeekly'
	RetentionScheduleFormatType RetentionScheduleFormat `json:"retentionScheduleFormatType,omitempty"`
	// RetentionScheduleDaily - Daily retention format for monthly retention policy.
	RetentionScheduleDaily *DailyRetentionFormat `json:"retentionScheduleDaily,omitempty"`
	// RetentionScheduleWeekly - Weekly retention format for monthly retention policy.
	RetentionScheduleWeekly *WeeklyRetentionFormat `json:"retentionScheduleWeekly,omitempty"`
	// RetentionTimes - Retention times of retention policy.
	RetentionTimes *[]date.Time `json:"retentionTimes,omitempty"`
	// RetentionDuration - Retention duration of retention Policy.
	RetentionDuration *RetentionDuration `json:"retentionDuration,omitempty"`
}

// NameInfo the name of usage.
type NameInfo struct {
	// Value - Value of usage.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - Localized value of usage.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// OperationResultInfo operation result info.
type OperationResultInfo struct {
	// JobList - List of jobs created by this operation.
	JobList *[]string `json:"jobList,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeOperationResultInfoBase', 'ObjectTypeExportJobsOperationResultInfo', 'ObjectTypeOperationResultInfo'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationResultInfo.
func (ori OperationResultInfo) MarshalJSON() ([]byte, error) {
	ori.ObjectType = ObjectTypeOperationResultInfo
	objectMap := make(map[string]interface{})
	if ori.JobList != nil {
		objectMap["jobList"] = ori.JobList
	}
	if ori.ObjectType != "" {
		objectMap["objectType"] = ori.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsExportJobsOperationResultInfo is the BasicOperationResultInfoBase implementation for OperationResultInfo.
func (ori OperationResultInfo) AsExportJobsOperationResultInfo() (*ExportJobsOperationResultInfo, bool) {
	return nil, false
}

// AsOperationResultInfo is the BasicOperationResultInfoBase implementation for OperationResultInfo.
func (ori OperationResultInfo) AsOperationResultInfo() (*OperationResultInfo, bool) {
	return &ori, true
}

// AsOperationResultInfoBase is the BasicOperationResultInfoBase implementation for OperationResultInfo.
func (ori OperationResultInfo) AsOperationResultInfoBase() (*OperationResultInfoBase, bool) {
	return nil, false
}

// AsBasicOperationResultInfoBase is the BasicOperationResultInfoBase implementation for OperationResultInfo.
func (ori OperationResultInfo) AsBasicOperationResultInfoBase() (BasicOperationResultInfoBase, bool) {
	return &ori, true
}

// BasicOperationResultInfoBase base class for operation result info.
type BasicOperationResultInfoBase interface {
	AsExportJobsOperationResultInfo() (*ExportJobsOperationResultInfo, bool)
	AsOperationResultInfo() (*OperationResultInfo, bool)
	AsOperationResultInfoBase() (*OperationResultInfoBase, bool)
}

// OperationResultInfoBase base class for operation result info.
type OperationResultInfoBase struct {
	// ObjectType - Possible values include: 'ObjectTypeOperationResultInfoBase', 'ObjectTypeExportJobsOperationResultInfo', 'ObjectTypeOperationResultInfo'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

func unmarshalBasicOperationResultInfoBase(body []byte) (BasicOperationResultInfoBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeExportJobsOperationResultInfo):
		var ejori ExportJobsOperationResultInfo
		err := json.Unmarshal(body, &ejori)
		return ejori, err
	case string(ObjectTypeOperationResultInfo):
		var ori OperationResultInfo
		err := json.Unmarshal(body, &ori)
		return ori, err
	default:
		var orib OperationResultInfoBase
		err := json.Unmarshal(body, &orib)
		return orib, err
	}
}
func unmarshalBasicOperationResultInfoBaseArray(body []byte) ([]BasicOperationResultInfoBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	oribArray := make([]BasicOperationResultInfoBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		orib, err := unmarshalBasicOperationResultInfoBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		oribArray[index] = orib
	}
	return oribArray, nil
}

// MarshalJSON is the custom marshaler for OperationResultInfoBase.
func (orib OperationResultInfoBase) MarshalJSON() ([]byte, error) {
	orib.ObjectType = ObjectTypeOperationResultInfoBase
	objectMap := make(map[string]interface{})
	if orib.ObjectType != "" {
		objectMap["objectType"] = orib.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsExportJobsOperationResultInfo is the BasicOperationResultInfoBase implementation for OperationResultInfoBase.
func (orib OperationResultInfoBase) AsExportJobsOperationResultInfo() (*ExportJobsOperationResultInfo, bool) {
	return nil, false
}

// AsOperationResultInfo is the BasicOperationResultInfoBase implementation for OperationResultInfoBase.
func (orib OperationResultInfoBase) AsOperationResultInfo() (*OperationResultInfo, bool) {
	return nil, false
}

// AsOperationResultInfoBase is the BasicOperationResultInfoBase implementation for OperationResultInfoBase.
func (orib OperationResultInfoBase) AsOperationResultInfoBase() (*OperationResultInfoBase, bool) {
	return &orib, true
}

// AsBasicOperationResultInfoBase is the BasicOperationResultInfoBase implementation for OperationResultInfoBase.
func (orib OperationResultInfoBase) AsBasicOperationResultInfoBase() (BasicOperationResultInfoBase, bool) {
	return &orib, true
}

// OperationResultInfoBaseResource base class for operation result info.
type OperationResultInfoBaseResource struct {
	autorest.Response `json:"-"`
	// Operation - OperationResultInfoBaseResource operation
	Operation BasicOperationResultInfoBase `json:"operation,omitempty"`
	// StatusCode - HTTP Status Code of the operation. Possible values include: 'Continue', 'SwitchingProtocols', 'OK', 'Created', 'Accepted', 'NonAuthoritativeInformation', 'NoContent', 'ResetContent', 'PartialContent', 'MultipleChoices', 'Ambiguous', 'MovedPermanently', 'Moved', 'Found', 'Redirect', 'SeeOther', 'RedirectMethod', 'NotModified', 'UseProxy', 'Unused', 'TemporaryRedirect', 'RedirectKeepVerb', 'BadRequest', 'Unauthorized', 'PaymentRequired', 'Forbidden', 'NotFound', 'MethodNotAllowed', 'NotAcceptable', 'ProxyAuthenticationRequired', 'RequestTimeout', 'Conflict', 'Gone', 'LengthRequired', 'PreconditionFailed', 'RequestEntityTooLarge', 'RequestURITooLong', 'UnsupportedMediaType', 'RequestedRangeNotSatisfiable', 'ExpectationFailed', 'UpgradeRequired', 'InternalServerError', 'NotImplemented', 'BadGateway', 'ServiceUnavailable', 'GatewayTimeout', 'HTTPVersionNotSupported'
	StatusCode HTTPStatusCode `json:"statusCode,omitempty"`
	// Headers - HTTP headers associated with this operation.
	Headers map[string][]string `json:"headers"`
}

// MarshalJSON is the custom marshaler for OperationResultInfoBaseResource.
func (oribr OperationResultInfoBaseResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["operation"] = oribr.Operation
	if oribr.StatusCode != "" {
		objectMap["statusCode"] = oribr.StatusCode
	}
	if oribr.Headers != nil {
		objectMap["headers"] = oribr.Headers
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OperationResultInfoBaseResource struct.
func (oribr *OperationResultInfoBaseResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "operation":
			if v != nil {
				operation, err := unmarshalBasicOperationResultInfoBase(*v)
				if err != nil {
					return err
				}
				oribr.Operation = operation
			}
		case "statusCode":
			if v != nil {
				var statusCode HTTPStatusCode
				err = json.Unmarshal(*v, &statusCode)
				if err != nil {
					return err
				}
				oribr.StatusCode = statusCode
			}
		case "headers":
			if v != nil {
				var headers map[string][]string
				err = json.Unmarshal(*v, &headers)
				if err != nil {
					return err
				}
				oribr.Headers = headers
			}
		}
	}

	return nil
}

// OperationStatus operation status.
type OperationStatus struct {
	autorest.Response `json:"-"`
	// ID - ID of the operation.
	ID *string `json:"id,omitempty"`
	// Name - Name of the operation.
	Name *string `json:"name,omitempty"`
	// Status - Operation status. Possible values include: 'OperationStatusValuesInvalid', 'OperationStatusValuesInProgress', 'OperationStatusValuesSucceeded', 'OperationStatusValuesFailed', 'OperationStatusValuesCanceled'
	Status OperationStatusValues `json:"status,omitempty"`
	// StartTime - Operation start time. Format: ISO-8601.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Operation end time. Format: ISO-8601.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Error - Error information related to this operation.
	Error *OperationStatusError `json:"error,omitempty"`
	// Properties - Additional information associated with this operation.
	Properties BasicOperationStatusExtendedInfo `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for OperationStatus struct.
func (osVar *OperationStatus) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				osVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				osVar.Name = &name
			}
		case "status":
			if v != nil {
				var status OperationStatusValues
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				osVar.Status = status
			}
		case "startTime":
			if v != nil {
				var startTime date.Time
				err = json.Unmarshal(*v, &startTime)
				if err != nil {
					return err
				}
				osVar.StartTime = &startTime
			}
		case "endTime":
			if v != nil {
				var endTime date.Time
				err = json.Unmarshal(*v, &endTime)
				if err != nil {
					return err
				}
				osVar.EndTime = &endTime
			}
		case "error":
			if v != nil {
				var errorVar OperationStatusError
				err = json.Unmarshal(*v, &errorVar)
				if err != nil {
					return err
				}
				osVar.Error = &errorVar
			}
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicOperationStatusExtendedInfo(*v)
				if err != nil {
					return err
				}
				osVar.Properties = properties
			}
		}
	}

	return nil
}

// OperationStatusError error information associated with operation status call.
type OperationStatusError struct {
	// Code - Error code of the operation failure.
	Code *string `json:"code,omitempty"`
	// Message - Error message displayed if the operation failure.
	Message *string `json:"message,omitempty"`
}

// BasicOperationStatusExtendedInfo base class for additional information of operation status.
type BasicOperationStatusExtendedInfo interface {
	AsOperationStatusJobExtendedInfo() (*OperationStatusJobExtendedInfo, bool)
	AsOperationStatusJobsExtendedInfo() (*OperationStatusJobsExtendedInfo, bool)
	AsOperationStatusProvisionILRExtendedInfo() (*OperationStatusProvisionILRExtendedInfo, bool)
	AsOperationStatusExtendedInfo() (*OperationStatusExtendedInfo, bool)
}

// OperationStatusExtendedInfo base class for additional information of operation status.
type OperationStatusExtendedInfo struct {
	// ObjectType - Possible values include: 'ObjectTypeOperationStatusExtendedInfo', 'ObjectTypeOperationStatusJobExtendedInfo', 'ObjectTypeOperationStatusJobsExtendedInfo', 'ObjectTypeOperationStatusProvisionILRExtendedInfo'
	ObjectType ObjectTypeBasicOperationStatusExtendedInfo `json:"objectType,omitempty"`
}

func unmarshalBasicOperationStatusExtendedInfo(body []byte) (BasicOperationStatusExtendedInfo, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeOperationStatusJobExtendedInfo):
		var osjei OperationStatusJobExtendedInfo
		err := json.Unmarshal(body, &osjei)
		return osjei, err
	case string(ObjectTypeOperationStatusJobsExtendedInfo):
		var osjei OperationStatusJobsExtendedInfo
		err := json.Unmarshal(body, &osjei)
		return osjei, err
	case string(ObjectTypeOperationStatusProvisionILRExtendedInfo):
		var ospiei OperationStatusProvisionILRExtendedInfo
		err := json.Unmarshal(body, &ospiei)
		return ospiei, err
	default:
		var osei OperationStatusExtendedInfo
		err := json.Unmarshal(body, &osei)
		return osei, err
	}
}
func unmarshalBasicOperationStatusExtendedInfoArray(body []byte) ([]BasicOperationStatusExtendedInfo, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	oseiArray := make([]BasicOperationStatusExtendedInfo, len(rawMessages))

	for index, rawMessage := range rawMessages {
		osei, err := unmarshalBasicOperationStatusExtendedInfo(*rawMessage)
		if err != nil {
			return nil, err
		}
		oseiArray[index] = osei
	}
	return oseiArray, nil
}

// MarshalJSON is the custom marshaler for OperationStatusExtendedInfo.
func (osei OperationStatusExtendedInfo) MarshalJSON() ([]byte, error) {
	osei.ObjectType = ObjectTypeOperationStatusExtendedInfo
	objectMap := make(map[string]interface{})
	if osei.ObjectType != "" {
		objectMap["objectType"] = osei.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsOperationStatusJobExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusExtendedInfo.
func (osei OperationStatusExtendedInfo) AsOperationStatusJobExtendedInfo() (*OperationStatusJobExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusJobsExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusExtendedInfo.
func (osei OperationStatusExtendedInfo) AsOperationStatusJobsExtendedInfo() (*OperationStatusJobsExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusProvisionILRExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusExtendedInfo.
func (osei OperationStatusExtendedInfo) AsOperationStatusProvisionILRExtendedInfo() (*OperationStatusProvisionILRExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusExtendedInfo.
func (osei OperationStatusExtendedInfo) AsOperationStatusExtendedInfo() (*OperationStatusExtendedInfo, bool) {
	return &osei, true
}

// AsBasicOperationStatusExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusExtendedInfo.
func (osei OperationStatusExtendedInfo) AsBasicOperationStatusExtendedInfo() (BasicOperationStatusExtendedInfo, bool) {
	return &osei, true
}

// OperationStatusJobExtendedInfo operation status job extended info.
type OperationStatusJobExtendedInfo struct {
	// JobID - ID of the job created for this protected item.
	JobID *string `json:"jobId,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeOperationStatusExtendedInfo', 'ObjectTypeOperationStatusJobExtendedInfo', 'ObjectTypeOperationStatusJobsExtendedInfo', 'ObjectTypeOperationStatusProvisionILRExtendedInfo'
	ObjectType ObjectTypeBasicOperationStatusExtendedInfo `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationStatusJobExtendedInfo.
func (osjei OperationStatusJobExtendedInfo) MarshalJSON() ([]byte, error) {
	osjei.ObjectType = ObjectTypeOperationStatusJobExtendedInfo
	objectMap := make(map[string]interface{})
	if osjei.JobID != nil {
		objectMap["jobId"] = osjei.JobID
	}
	if osjei.ObjectType != "" {
		objectMap["objectType"] = osjei.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsOperationStatusJobExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobExtendedInfo.
func (osjei OperationStatusJobExtendedInfo) AsOperationStatusJobExtendedInfo() (*OperationStatusJobExtendedInfo, bool) {
	return &osjei, true
}

// AsOperationStatusJobsExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobExtendedInfo.
func (osjei OperationStatusJobExtendedInfo) AsOperationStatusJobsExtendedInfo() (*OperationStatusJobsExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusProvisionILRExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobExtendedInfo.
func (osjei OperationStatusJobExtendedInfo) AsOperationStatusProvisionILRExtendedInfo() (*OperationStatusProvisionILRExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobExtendedInfo.
func (osjei OperationStatusJobExtendedInfo) AsOperationStatusExtendedInfo() (*OperationStatusExtendedInfo, bool) {
	return nil, false
}

// AsBasicOperationStatusExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobExtendedInfo.
func (osjei OperationStatusJobExtendedInfo) AsBasicOperationStatusExtendedInfo() (BasicOperationStatusExtendedInfo, bool) {
	return &osjei, true
}

// OperationStatusJobsExtendedInfo operation status extended info for list of jobs.
type OperationStatusJobsExtendedInfo struct {
	// JobIds - IDs of the jobs created for the protected item.
	JobIds *[]string `json:"jobIds,omitempty"`
	// FailedJobsError - Stores all the failed jobs along with the corresponding error codes.
	FailedJobsError map[string]*string `json:"failedJobsError"`
	// ObjectType - Possible values include: 'ObjectTypeOperationStatusExtendedInfo', 'ObjectTypeOperationStatusJobExtendedInfo', 'ObjectTypeOperationStatusJobsExtendedInfo', 'ObjectTypeOperationStatusProvisionILRExtendedInfo'
	ObjectType ObjectTypeBasicOperationStatusExtendedInfo `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationStatusJobsExtendedInfo.
func (osjei OperationStatusJobsExtendedInfo) MarshalJSON() ([]byte, error) {
	osjei.ObjectType = ObjectTypeOperationStatusJobsExtendedInfo
	objectMap := make(map[string]interface{})
	if osjei.JobIds != nil {
		objectMap["jobIds"] = osjei.JobIds
	}
	if osjei.FailedJobsError != nil {
		objectMap["failedJobsError"] = osjei.FailedJobsError
	}
	if osjei.ObjectType != "" {
		objectMap["objectType"] = osjei.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsOperationStatusJobExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobsExtendedInfo.
func (osjei OperationStatusJobsExtendedInfo) AsOperationStatusJobExtendedInfo() (*OperationStatusJobExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusJobsExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobsExtendedInfo.
func (osjei OperationStatusJobsExtendedInfo) AsOperationStatusJobsExtendedInfo() (*OperationStatusJobsExtendedInfo, bool) {
	return &osjei, true
}

// AsOperationStatusProvisionILRExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobsExtendedInfo.
func (osjei OperationStatusJobsExtendedInfo) AsOperationStatusProvisionILRExtendedInfo() (*OperationStatusProvisionILRExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobsExtendedInfo.
func (osjei OperationStatusJobsExtendedInfo) AsOperationStatusExtendedInfo() (*OperationStatusExtendedInfo, bool) {
	return nil, false
}

// AsBasicOperationStatusExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobsExtendedInfo.
func (osjei OperationStatusJobsExtendedInfo) AsBasicOperationStatusExtendedInfo() (BasicOperationStatusExtendedInfo, bool) {
	return &osjei, true
}

// OperationStatusProvisionILRExtendedInfo operation status extended info for ILR provision action.
type OperationStatusProvisionILRExtendedInfo struct {
	// RecoveryTarget - Target details for file / folder restore.
	RecoveryTarget *InstantItemRecoveryTarget `json:"recoveryTarget,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeOperationStatusExtendedInfo', 'ObjectTypeOperationStatusJobExtendedInfo', 'ObjectTypeOperationStatusJobsExtendedInfo', 'ObjectTypeOperationStatusProvisionILRExtendedInfo'
	ObjectType ObjectTypeBasicOperationStatusExtendedInfo `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationStatusProvisionILRExtendedInfo.
func (ospiei OperationStatusProvisionILRExtendedInfo) MarshalJSON() ([]byte, error) {
	ospiei.ObjectType = ObjectTypeOperationStatusProvisionILRExtendedInfo
	objectMap := make(map[string]interface{})
	if ospiei.RecoveryTarget != nil {
		objectMap["recoveryTarget"] = ospiei.RecoveryTarget
	}
	if ospiei.ObjectType != "" {
		objectMap["objectType"] = ospiei.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsOperationStatusJobExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusProvisionILRExtendedInfo.
func (ospiei OperationStatusProvisionILRExtendedInfo) AsOperationStatusJobExtendedInfo() (*OperationStatusJobExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusJobsExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusProvisionILRExtendedInfo.
func (ospiei OperationStatusProvisionILRExtendedInfo) AsOperationStatusJobsExtendedInfo() (*OperationStatusJobsExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusProvisionILRExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusProvisionILRExtendedInfo.
func (ospiei OperationStatusProvisionILRExtendedInfo) AsOperationStatusProvisionILRExtendedInfo() (*OperationStatusProvisionILRExtendedInfo, bool) {
	return &ospiei, true
}

// AsOperationStatusExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusProvisionILRExtendedInfo.
func (ospiei OperationStatusProvisionILRExtendedInfo) AsOperationStatusExtendedInfo() (*OperationStatusExtendedInfo, bool) {
	return nil, false
}

// AsBasicOperationStatusExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusProvisionILRExtendedInfo.
func (ospiei OperationStatusProvisionILRExtendedInfo) AsBasicOperationStatusExtendedInfo() (BasicOperationStatusExtendedInfo, bool) {
	return &ospiei, true
}

// OperationWorkerResponse this is the base class for operation result responses.
type OperationWorkerResponse struct {
	// StatusCode - HTTP Status Code of the operation. Possible values include: 'Continue', 'SwitchingProtocols', 'OK', 'Created', 'Accepted', 'NonAuthoritativeInformation', 'NoContent', 'ResetContent', 'PartialContent', 'MultipleChoices', 'Ambiguous', 'MovedPermanently', 'Moved', 'Found', 'Redirect', 'SeeOther', 'RedirectMethod', 'NotModified', 'UseProxy', 'Unused', 'TemporaryRedirect', 'RedirectKeepVerb', 'BadRequest', 'Unauthorized', 'PaymentRequired', 'Forbidden', 'NotFound', 'MethodNotAllowed', 'NotAcceptable', 'ProxyAuthenticationRequired', 'RequestTimeout', 'Conflict', 'Gone', 'LengthRequired', 'PreconditionFailed', 'RequestEntityTooLarge', 'RequestURITooLong', 'UnsupportedMediaType', 'RequestedRangeNotSatisfiable', 'ExpectationFailed', 'UpgradeRequired', 'InternalServerError', 'NotImplemented', 'BadGateway', 'ServiceUnavailable', 'GatewayTimeout', 'HTTPVersionNotSupported'
	StatusCode HTTPStatusCode `json:"statusCode,omitempty"`
	// Headers - HTTP headers associated with this operation.
	Headers map[string][]string `json:"headers"`
}

// MarshalJSON is the custom marshaler for OperationWorkerResponse.
func (owr OperationWorkerResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if owr.StatusCode != "" {
		objectMap["statusCode"] = owr.StatusCode
	}
	if owr.Headers != nil {
		objectMap["headers"] = owr.Headers
	}
	return json.Marshal(objectMap)
}

// PointInTimeRange provides details for log ranges
type PointInTimeRange struct {
	// StartTime - Start time of the time range for log recovery.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - End time of the time range for log recovery.
	EndTime *date.Time `json:"endTime,omitempty"`
}

// PreBackupValidation pre-backup validation for Azure VM Workload provider.
type PreBackupValidation struct {
	// Status - Status of protectable item, i.e. InProgress,Succeeded,Failed. Possible values include: 'InquiryStatusInvalid', 'InquiryStatusSuccess', 'InquiryStatusFailed'
	Status InquiryStatus `json:"status,omitempty"`
	// Code - Error code of protectable item
	Code *string `json:"code,omitempty"`
	// Message - Message corresponding to the error code for the protectable item
	Message *string `json:"message,omitempty"`
}

// PreValidateEnableBackupRequest contract to validate if backup can be enabled on the given resource in a
// given vault and given configuration.
// It will validate followings
// 1. Vault capacity
// 2. VM is already protected
// 3. Any VM related configuration passed in properties.
type PreValidateEnableBackupRequest struct {
	// ResourceType - ProtectedItem Type- VM, SqlDataBase, AzureFileShare etc. Possible values include: 'DataSourceTypeInvalid', 'DataSourceTypeVM', 'DataSourceTypeFileFolder', 'DataSourceTypeAzureSQLDb', 'DataSourceTypeSQLDB', 'DataSourceTypeExchange', 'DataSourceTypeSharepoint', 'DataSourceTypeVMwareVM', 'DataSourceTypeSystemState', 'DataSourceTypeClient', 'DataSourceTypeGenericDataSource', 'DataSourceTypeSQLDataBase', 'DataSourceTypeAzureFileShare', 'DataSourceTypeSAPHanaDatabase', 'DataSourceTypeSAPAseDatabase'
	ResourceType DataSourceType `json:"resourceType,omitempty"`
	// ResourceID - ARM Virtual Machine Id
	ResourceID *string `json:"resourceId,omitempty"`
	// VaultID - ARM id of the Recovery Services Vault
	VaultID *string `json:"vaultId,omitempty"`
	// Properties - Configuration of VM if any needs to be validated like OS type etc
	Properties *string `json:"properties,omitempty"`
}

// PreValidateEnableBackupResponse response contract for enable backup validation request
type PreValidateEnableBackupResponse struct {
	autorest.Response `json:"-"`
	// Status - Validation Status. Possible values include: 'ValidationStatusInvalid', 'ValidationStatusSucceeded', 'ValidationStatusFailed'
	Status ValidationStatus `json:"status,omitempty"`
	// ErrorCode - Response error code
	ErrorCode *string `json:"errorCode,omitempty"`
	// ErrorMessage - Response error message
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// Recommendation - Recommended action for user
	Recommendation *string `json:"recommendation,omitempty"`
	// ContainerName - Specifies the product specific container name. E.g. iaasvmcontainer;iaasvmcontainer;rgname;vmname. This is required
	// for portal
	ContainerName *string `json:"containerName,omitempty"`
	// ProtectedItemName - Specifies the product specific ds name. E.g. vm;iaasvmcontainer;rgname;vmname. This is required for portal
	ProtectedItemName *string `json:"protectedItemName,omitempty"`
}

// BasicProtectableContainer protectable Container Class.
type BasicProtectableContainer interface {
	AsAzureStorageProtectableContainer() (*AzureStorageProtectableContainer, bool)
	AsAzureVMAppContainerProtectableContainer() (*AzureVMAppContainerProtectableContainer, bool)
	AsProtectableContainer() (*ProtectableContainer, bool)
}

// ProtectableContainer protectable Container Class.
type ProtectableContainer struct {
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerID - Fabric Id of the container such as ARM Id.
	ContainerID *string `json:"containerId,omitempty"`
	// ProtectableContainerType - Possible values include: 'ProtectableContainerTypeProtectableContainer', 'ProtectableContainerTypeStorageContainer', 'ProtectableContainerTypeVMAppContainer'
	ProtectableContainerType ProtectableContainerType `json:"protectableContainerType,omitempty"`
}

func unmarshalBasicProtectableContainer(body []byte) (BasicProtectableContainer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["protectableContainerType"] {
	case string(ProtectableContainerTypeStorageContainer):
		var aspc AzureStorageProtectableContainer
		err := json.Unmarshal(body, &aspc)
		return aspc, err
	case string(ProtectableContainerTypeVMAppContainer):
		var avacpc AzureVMAppContainerProtectableContainer
		err := json.Unmarshal(body, &avacpc)
		return avacpc, err
	default:
		var pc ProtectableContainer
		err := json.Unmarshal(body, &pc)
		return pc, err
	}
}
func unmarshalBasicProtectableContainerArray(body []byte) ([]BasicProtectableContainer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	pcArray := make([]BasicProtectableContainer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		pc, err := unmarshalBasicProtectableContainer(*rawMessage)
		if err != nil {
			return nil, err
		}
		pcArray[index] = pc
	}
	return pcArray, nil
}

// MarshalJSON is the custom marshaler for ProtectableContainer.
func (pc ProtectableContainer) MarshalJSON() ([]byte, error) {
	pc.ProtectableContainerType = ProtectableContainerTypeProtectableContainer
	objectMap := make(map[string]interface{})
	if pc.FriendlyName != nil {
		objectMap["friendlyName"] = pc.FriendlyName
	}
	if pc.BackupManagementType != "" {
		objectMap["backupManagementType"] = pc.BackupManagementType
	}
	if pc.HealthStatus != nil {
		objectMap["healthStatus"] = pc.HealthStatus
	}
	if pc.ContainerID != nil {
		objectMap["containerId"] = pc.ContainerID
	}
	if pc.ProtectableContainerType != "" {
		objectMap["protectableContainerType"] = pc.ProtectableContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureStorageProtectableContainer is the BasicProtectableContainer implementation for ProtectableContainer.
func (pc ProtectableContainer) AsAzureStorageProtectableContainer() (*AzureStorageProtectableContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectableContainer is the BasicProtectableContainer implementation for ProtectableContainer.
func (pc ProtectableContainer) AsAzureVMAppContainerProtectableContainer() (*AzureVMAppContainerProtectableContainer, bool) {
	return nil, false
}

// AsProtectableContainer is the BasicProtectableContainer implementation for ProtectableContainer.
func (pc ProtectableContainer) AsProtectableContainer() (*ProtectableContainer, bool) {
	return &pc, true
}

// AsBasicProtectableContainer is the BasicProtectableContainer implementation for ProtectableContainer.
func (pc ProtectableContainer) AsBasicProtectableContainer() (BasicProtectableContainer, bool) {
	return &pc, true
}

// ProtectableContainerResource protectable Container Class.
type ProtectableContainerResource struct {
	// Properties - ProtectableContainerResource properties
	Properties BasicProtectableContainer `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for ProtectableContainerResource.
func (pcr ProtectableContainerResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = pcr.Properties
	if pcr.Location != nil {
		objectMap["location"] = pcr.Location
	}
	if pcr.Tags != nil {
		objectMap["tags"] = pcr.Tags
	}
	if pcr.ETag != nil {
		objectMap["eTag"] = pcr.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProtectableContainerResource struct.
func (pcr *ProtectableContainerResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicProtectableContainer(*v)
				if err != nil {
					return err
				}
				pcr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pcr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pcr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pcr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pcr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pcr.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				pcr.ETag = &eTag
			}
		}
	}

	return nil
}

// ProtectableContainerResourceList list of ProtectableContainer resources
type ProtectableContainerResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of resources.
	Value *[]ProtectableContainerResource `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProtectableContainerResourceListIterator provides access to a complete listing of
// ProtectableContainerResource values.
type ProtectableContainerResourceListIterator struct {
	i    int
	page ProtectableContainerResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProtectableContainerResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProtectableContainerResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProtectableContainerResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProtectableContainerResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProtectableContainerResourceListIterator) Response() ProtectableContainerResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProtectableContainerResourceListIterator) Value() ProtectableContainerResource {
	if !iter.page.NotDone() {
		return ProtectableContainerResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProtectableContainerResourceListIterator type.
func NewProtectableContainerResourceListIterator(page ProtectableContainerResourceListPage) ProtectableContainerResourceListIterator {
	return ProtectableContainerResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pcrl ProtectableContainerResourceList) IsEmpty() bool {
	return pcrl.Value == nil || len(*pcrl.Value) == 0
}

// protectableContainerResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pcrl ProtectableContainerResourceList) protectableContainerResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if pcrl.NextLink == nil || len(to.String(pcrl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pcrl.NextLink)))
}

// ProtectableContainerResourceListPage contains a page of ProtectableContainerResource values.
type ProtectableContainerResourceListPage struct {
	fn   func(context.Context, ProtectableContainerResourceList) (ProtectableContainerResourceList, error)
	pcrl ProtectableContainerResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProtectableContainerResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProtectableContainerResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.pcrl)
	if err != nil {
		return err
	}
	page.pcrl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProtectableContainerResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProtectableContainerResourceListPage) NotDone() bool {
	return !page.pcrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProtectableContainerResourceListPage) Response() ProtectableContainerResourceList {
	return page.pcrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProtectableContainerResourceListPage) Values() []ProtectableContainerResource {
	if page.pcrl.IsEmpty() {
		return nil
	}
	return *page.pcrl.Value
}

// Creates a new instance of the ProtectableContainerResourceListPage type.
func NewProtectableContainerResourceListPage(getNextPage func(context.Context, ProtectableContainerResourceList) (ProtectableContainerResourceList, error)) ProtectableContainerResourceListPage {
	return ProtectableContainerResourceListPage{fn: getNextPage}
}

// BasicProtectedItem base class for backup items.
type BasicProtectedItem interface {
	AsAzureFileshareProtectedItem() (*AzureFileshareProtectedItem, bool)
	AsAzureIaaSClassicComputeVMProtectedItem() (*AzureIaaSClassicComputeVMProtectedItem, bool)
	AsAzureIaaSComputeVMProtectedItem() (*AzureIaaSComputeVMProtectedItem, bool)
	AsAzureIaaSVMProtectedItem() (*AzureIaaSVMProtectedItem, bool)
	AsBasicAzureIaaSVMProtectedItem() (BasicAzureIaaSVMProtectedItem, bool)
	AsAzureSQLProtectedItem() (*AzureSQLProtectedItem, bool)
	AsAzureVMWorkloadProtectedItem() (*AzureVMWorkloadProtectedItem, bool)
	AsBasicAzureVMWorkloadProtectedItem() (BasicAzureVMWorkloadProtectedItem, bool)
	AsAzureVMWorkloadSAPAseDatabaseProtectedItem() (*AzureVMWorkloadSAPAseDatabaseProtectedItem, bool)
	AsAzureVMWorkloadSAPHanaDatabaseProtectedItem() (*AzureVMWorkloadSAPHanaDatabaseProtectedItem, bool)
	AsAzureVMWorkloadSQLDatabaseProtectedItem() (*AzureVMWorkloadSQLDatabaseProtectedItem, bool)
	AsDPMProtectedItem() (*DPMProtectedItem, bool)
	AsGenericProtectedItem() (*GenericProtectedItem, bool)
	AsMabFileFolderProtectedItem() (*MabFileFolderProtectedItem, bool)
	AsProtectedItem() (*ProtectedItem, bool)
}

// ProtectedItem base class for backup items.
type ProtectedItem struct {
	// BackupManagementType - Type of backup management for the backed up item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload this item represents. Possible values include: 'DataSourceTypeInvalid', 'DataSourceTypeVM', 'DataSourceTypeFileFolder', 'DataSourceTypeAzureSQLDb', 'DataSourceTypeSQLDB', 'DataSourceTypeExchange', 'DataSourceTypeSharepoint', 'DataSourceTypeVMwareVM', 'DataSourceTypeSystemState', 'DataSourceTypeClient', 'DataSourceTypeGenericDataSource', 'DataSourceTypeSQLDataBase', 'DataSourceTypeAzureFileShare', 'DataSourceTypeSAPHanaDatabase', 'DataSourceTypeSAPAseDatabase'
	WorkloadType DataSourceType `json:"workloadType,omitempty"`
	// ContainerName - Unique name of container
	ContainerName *string `json:"containerName,omitempty"`
	// SourceResourceID - ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// PolicyID - ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`
	// LastRecoveryPoint - Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *date.Time `json:"lastRecoveryPoint,omitempty"`
	// BackupSetName - Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`
	// CreateMode - Create mode to indicate recovery of existing soft deleted data source or creation of new data source. Possible values include: 'CreateModeInvalid', 'CreateModeDefault', 'CreateModeRecover'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// DeferredDeleteTimeInUTC - Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *date.Time `json:"deferredDeleteTimeInUTC,omitempty"`
	// IsScheduledForDeferredDelete - Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`
	// DeferredDeleteTimeRemaining - Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`
	// IsDeferredDeleteScheduleUpcoming - Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`
	// IsRehydrate - Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`
	// ProtectedItemType - Possible values include: 'ProtectedItemTypeProtectedItem', 'ProtectedItemTypeAzureFileShareProtectedItem', 'ProtectedItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectedItemTypeMicrosoftComputevirtualMachines', 'ProtectedItemTypeAzureIaaSVMProtectedItem', 'ProtectedItemTypeMicrosoftSqlserversdatabases', 'ProtectedItemTypeAzureVMWorkloadProtectedItem', 'ProtectedItemTypeAzureVMWorkloadSAPAseDatabase', 'ProtectedItemTypeAzureVMWorkloadSAPHanaDatabase', 'ProtectedItemTypeAzureVMWorkloadSQLDatabase', 'ProtectedItemTypeDPMProtectedItem', 'ProtectedItemTypeGenericProtectedItem', 'ProtectedItemTypeMabFileFolderProtectedItem'
	ProtectedItemType ProtectedItemType `json:"protectedItemType,omitempty"`
}

func unmarshalBasicProtectedItem(body []byte) (BasicProtectedItem, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["protectedItemType"] {
	case string(ProtectedItemTypeAzureFileShareProtectedItem):
		var afpi AzureFileshareProtectedItem
		err := json.Unmarshal(body, &afpi)
		return afpi, err
	case string(ProtectedItemTypeMicrosoftClassicComputevirtualMachines):
		var aisccvpi AzureIaaSClassicComputeVMProtectedItem
		err := json.Unmarshal(body, &aisccvpi)
		return aisccvpi, err
	case string(ProtectedItemTypeMicrosoftComputevirtualMachines):
		var aiscvpi AzureIaaSComputeVMProtectedItem
		err := json.Unmarshal(body, &aiscvpi)
		return aiscvpi, err
	case string(ProtectedItemTypeAzureIaaSVMProtectedItem):
		var aispi AzureIaaSVMProtectedItem
		err := json.Unmarshal(body, &aispi)
		return aispi, err
	case string(ProtectedItemTypeMicrosoftSqlserversdatabases):
		var aspi AzureSQLProtectedItem
		err := json.Unmarshal(body, &aspi)
		return aspi, err
	case string(ProtectedItemTypeAzureVMWorkloadProtectedItem):
		var avwpi AzureVMWorkloadProtectedItem
		err := json.Unmarshal(body, &avwpi)
		return avwpi, err
	case string(ProtectedItemTypeAzureVMWorkloadSAPAseDatabase):
		var avwsadpi AzureVMWorkloadSAPAseDatabaseProtectedItem
		err := json.Unmarshal(body, &avwsadpi)
		return avwsadpi, err
	case string(ProtectedItemTypeAzureVMWorkloadSAPHanaDatabase):
		var avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectedItem
		err := json.Unmarshal(body, &avwshdpi)
		return avwshdpi, err
	case string(ProtectedItemTypeAzureVMWorkloadSQLDatabase):
		var avwsdpi AzureVMWorkloadSQLDatabaseProtectedItem
		err := json.Unmarshal(body, &avwsdpi)
		return avwsdpi, err
	case string(ProtectedItemTypeDPMProtectedItem):
		var dpi DPMProtectedItem
		err := json.Unmarshal(body, &dpi)
		return dpi, err
	case string(ProtectedItemTypeGenericProtectedItem):
		var gpi GenericProtectedItem
		err := json.Unmarshal(body, &gpi)
		return gpi, err
	case string(ProtectedItemTypeMabFileFolderProtectedItem):
		var mffpi MabFileFolderProtectedItem
		err := json.Unmarshal(body, &mffpi)
		return mffpi, err
	default:
		var pi ProtectedItem
		err := json.Unmarshal(body, &pi)
		return pi, err
	}
}
func unmarshalBasicProtectedItemArray(body []byte) ([]BasicProtectedItem, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	piArray := make([]BasicProtectedItem, len(rawMessages))

	for index, rawMessage := range rawMessages {
		pi, err := unmarshalBasicProtectedItem(*rawMessage)
		if err != nil {
			return nil, err
		}
		piArray[index] = pi
	}
	return piArray, nil
}

// MarshalJSON is the custom marshaler for ProtectedItem.
func (pi ProtectedItem) MarshalJSON() ([]byte, error) {
	pi.ProtectedItemType = ProtectedItemTypeProtectedItem
	objectMap := make(map[string]interface{})
	if pi.BackupManagementType != "" {
		objectMap["backupManagementType"] = pi.BackupManagementType
	}
	if pi.WorkloadType != "" {
		objectMap["workloadType"] = pi.WorkloadType
	}
	if pi.ContainerName != nil {
		objectMap["containerName"] = pi.ContainerName
	}
	if pi.SourceResourceID != nil {
		objectMap["sourceResourceId"] = pi.SourceResourceID
	}
	if pi.PolicyID != nil {
		objectMap["policyId"] = pi.PolicyID
	}
	if pi.LastRecoveryPoint != nil {
		objectMap["lastRecoveryPoint"] = pi.LastRecoveryPoint
	}
	if pi.BackupSetName != nil {
		objectMap["backupSetName"] = pi.BackupSetName
	}
	if pi.CreateMode != "" {
		objectMap["createMode"] = pi.CreateMode
	}
	if pi.DeferredDeleteTimeInUTC != nil {
		objectMap["deferredDeleteTimeInUTC"] = pi.DeferredDeleteTimeInUTC
	}
	if pi.IsScheduledForDeferredDelete != nil {
		objectMap["isScheduledForDeferredDelete"] = pi.IsScheduledForDeferredDelete
	}
	if pi.DeferredDeleteTimeRemaining != nil {
		objectMap["deferredDeleteTimeRemaining"] = pi.DeferredDeleteTimeRemaining
	}
	if pi.IsDeferredDeleteScheduleUpcoming != nil {
		objectMap["isDeferredDeleteScheduleUpcoming"] = pi.IsDeferredDeleteScheduleUpcoming
	}
	if pi.IsRehydrate != nil {
		objectMap["isRehydrate"] = pi.IsRehydrate
	}
	if pi.ProtectedItemType != "" {
		objectMap["protectedItemType"] = pi.ProtectedItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileshareProtectedItem is the BasicProtectedItem implementation for ProtectedItem.
func (pi ProtectedItem) AsAzureFileshareProtectedItem() (*AzureFileshareProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectedItem is the BasicProtectedItem implementation for ProtectedItem.
func (pi ProtectedItem) AsAzureIaaSClassicComputeVMProtectedItem() (*AzureIaaSClassicComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectedItem is the BasicProtectedItem implementation for ProtectedItem.
func (pi ProtectedItem) AsAzureIaaSComputeVMProtectedItem() (*AzureIaaSComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for ProtectedItem.
func (pi ProtectedItem) AsAzureIaaSVMProtectedItem() (*AzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for ProtectedItem.
func (pi ProtectedItem) AsBasicAzureIaaSVMProtectedItem() (BasicAzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsAzureSQLProtectedItem is the BasicProtectedItem implementation for ProtectedItem.
func (pi ProtectedItem) AsAzureSQLProtectedItem() (*AzureSQLProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for ProtectedItem.
func (pi ProtectedItem) AsAzureVMWorkloadProtectedItem() (*AzureVMWorkloadProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectedItem is the BasicProtectedItem implementation for ProtectedItem.
func (pi ProtectedItem) AsBasicAzureVMWorkloadProtectedItem() (BasicAzureVMWorkloadProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseDatabaseProtectedItem is the BasicProtectedItem implementation for ProtectedItem.
func (pi ProtectedItem) AsAzureVMWorkloadSAPAseDatabaseProtectedItem() (*AzureVMWorkloadSAPAseDatabaseProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectedItem is the BasicProtectedItem implementation for ProtectedItem.
func (pi ProtectedItem) AsAzureVMWorkloadSAPHanaDatabaseProtectedItem() (*AzureVMWorkloadSAPHanaDatabaseProtectedItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectedItem is the BasicProtectedItem implementation for ProtectedItem.
func (pi ProtectedItem) AsAzureVMWorkloadSQLDatabaseProtectedItem() (*AzureVMWorkloadSQLDatabaseProtectedItem, bool) {
	return nil, false
}

// AsDPMProtectedItem is the BasicProtectedItem implementation for ProtectedItem.
func (pi ProtectedItem) AsDPMProtectedItem() (*DPMProtectedItem, bool) {
	return nil, false
}

// AsGenericProtectedItem is the BasicProtectedItem implementation for ProtectedItem.
func (pi ProtectedItem) AsGenericProtectedItem() (*GenericProtectedItem, bool) {
	return nil, false
}

// AsMabFileFolderProtectedItem is the BasicProtectedItem implementation for ProtectedItem.
func (pi ProtectedItem) AsMabFileFolderProtectedItem() (*MabFileFolderProtectedItem, bool) {
	return nil, false
}

// AsProtectedItem is the BasicProtectedItem implementation for ProtectedItem.
func (pi ProtectedItem) AsProtectedItem() (*ProtectedItem, bool) {
	return &pi, true
}

// AsBasicProtectedItem is the BasicProtectedItem implementation for ProtectedItem.
func (pi ProtectedItem) AsBasicProtectedItem() (BasicProtectedItem, bool) {
	return &pi, true
}

// ProtectedItemQueryObject filters to list backup items.
type ProtectedItemQueryObject struct {
	// HealthState - Health State for the backed up item. Possible values include: 'HealthStatePassed', 'HealthStateActionRequired', 'HealthStateActionSuggested', 'HealthStateInvalid'
	HealthState HealthState `json:"healthState,omitempty"`
	// BackupManagementType - Backup management type for the backed up item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// ItemType - Type of workload this item represents. Possible values include: 'DataSourceTypeInvalid', 'DataSourceTypeVM', 'DataSourceTypeFileFolder', 'DataSourceTypeAzureSQLDb', 'DataSourceTypeSQLDB', 'DataSourceTypeExchange', 'DataSourceTypeSharepoint', 'DataSourceTypeVMwareVM', 'DataSourceTypeSystemState', 'DataSourceTypeClient', 'DataSourceTypeGenericDataSource', 'DataSourceTypeSQLDataBase', 'DataSourceTypeAzureFileShare', 'DataSourceTypeSAPHanaDatabase', 'DataSourceTypeSAPAseDatabase'
	ItemType DataSourceType `json:"itemType,omitempty"`
	// PolicyName - Backup policy name associated with the backup item.
	PolicyName *string `json:"policyName,omitempty"`
	// ContainerName - Name of the container.
	ContainerName *string `json:"containerName,omitempty"`
	// BackupEngineName - Backup Engine name
	BackupEngineName *string `json:"backupEngineName,omitempty"`
	// FriendlyName - Friendly name of protected item
	FriendlyName *string `json:"friendlyName,omitempty"`
	// FabricName - Name of the fabric.
	FabricName *string `json:"fabricName,omitempty"`
	// BackupSetName - Name of the backup set.
	BackupSetName *string `json:"backupSetName,omitempty"`
}

// ProtectedItemResource base class for backup items.
type ProtectedItemResource struct {
	autorest.Response `json:"-"`
	// Properties - ProtectedItemResource properties
	Properties BasicProtectedItem `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for ProtectedItemResource.
func (pir ProtectedItemResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = pir.Properties
	if pir.Location != nil {
		objectMap["location"] = pir.Location
	}
	if pir.Tags != nil {
		objectMap["tags"] = pir.Tags
	}
	if pir.ETag != nil {
		objectMap["eTag"] = pir.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProtectedItemResource struct.
func (pir *ProtectedItemResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicProtectedItem(*v)
				if err != nil {
					return err
				}
				pir.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pir.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pir.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pir.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pir.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pir.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				pir.ETag = &eTag
			}
		}
	}

	return nil
}

// ProtectedItemResourceList list of ProtectedItem resources
type ProtectedItemResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of resources.
	Value *[]ProtectedItemResource `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProtectedItemResourceListIterator provides access to a complete listing of ProtectedItemResource values.
type ProtectedItemResourceListIterator struct {
	i    int
	page ProtectedItemResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProtectedItemResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProtectedItemResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProtectedItemResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProtectedItemResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProtectedItemResourceListIterator) Response() ProtectedItemResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProtectedItemResourceListIterator) Value() ProtectedItemResource {
	if !iter.page.NotDone() {
		return ProtectedItemResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProtectedItemResourceListIterator type.
func NewProtectedItemResourceListIterator(page ProtectedItemResourceListPage) ProtectedItemResourceListIterator {
	return ProtectedItemResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pirl ProtectedItemResourceList) IsEmpty() bool {
	return pirl.Value == nil || len(*pirl.Value) == 0
}

// protectedItemResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pirl ProtectedItemResourceList) protectedItemResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if pirl.NextLink == nil || len(to.String(pirl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pirl.NextLink)))
}

// ProtectedItemResourceListPage contains a page of ProtectedItemResource values.
type ProtectedItemResourceListPage struct {
	fn   func(context.Context, ProtectedItemResourceList) (ProtectedItemResourceList, error)
	pirl ProtectedItemResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProtectedItemResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProtectedItemResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.pirl)
	if err != nil {
		return err
	}
	page.pirl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProtectedItemResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProtectedItemResourceListPage) NotDone() bool {
	return !page.pirl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProtectedItemResourceListPage) Response() ProtectedItemResourceList {
	return page.pirl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProtectedItemResourceListPage) Values() []ProtectedItemResource {
	if page.pirl.IsEmpty() {
		return nil
	}
	return *page.pirl.Value
}

// Creates a new instance of the ProtectedItemResourceListPage type.
func NewProtectedItemResourceListPage(getNextPage func(context.Context, ProtectedItemResourceList) (ProtectedItemResourceList, error)) ProtectedItemResourceListPage {
	return ProtectedItemResourceListPage{fn: getNextPage}
}

// BasicProtectionContainer base class for container with backup items. Containers with specific workloads are derived
// from this class.
type BasicProtectionContainer interface {
	AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool)
	AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool)
	AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool)
	AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool)
	AsAzureSQLContainer() (*AzureSQLContainer, bool)
	AsAzureStorageContainer() (*AzureStorageContainer, bool)
	AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool)
	AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool)
	AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool)
	AsDpmContainer() (*DpmContainer, bool)
	AsBasicDpmContainer() (BasicDpmContainer, bool)
	AsGenericContainer() (*GenericContainer, bool)
	AsIaaSVMContainer() (*IaaSVMContainer, bool)
	AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool)
	AsMabContainer() (*MabContainer, bool)
	AsProtectionContainer() (*ProtectionContainer, bool)
}

// ProtectionContainer base class for container with backup items. Containers with specific workloads are
// derived from this class.
type ProtectionContainer struct {
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - Type of backup management for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - Possible values include: 'ContainerTypeProtectionContainer', 'ContainerTypeAzureBackupServerContainer1', 'ContainerTypeMicrosoftClassicComputevirtualMachines', 'ContainerTypeMicrosoftComputevirtualMachines', 'ContainerTypeSQLAGWorkLoadContainer1', 'ContainerTypeAzureSQLContainer1', 'ContainerTypeStorageContainer1', 'ContainerTypeVMAppContainer1', 'ContainerTypeAzureWorkloadContainer', 'ContainerTypeDPMContainer1', 'ContainerTypeGenericContainer1', 'ContainerTypeIaaSVMContainer', 'ContainerTypeWindows1'
	ContainerType ContainerTypeBasicProtectionContainer `json:"containerType,omitempty"`
}

func unmarshalBasicProtectionContainer(body []byte) (BasicProtectionContainer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["containerType"] {
	case string(ContainerTypeAzureBackupServerContainer1):
		var absc AzureBackupServerContainer
		err := json.Unmarshal(body, &absc)
		return absc, err
	case string(ContainerTypeMicrosoftClassicComputevirtualMachines):
		var aisccvc AzureIaaSClassicComputeVMContainer
		err := json.Unmarshal(body, &aisccvc)
		return aisccvc, err
	case string(ContainerTypeMicrosoftComputevirtualMachines):
		var aiscvc AzureIaaSComputeVMContainer
		err := json.Unmarshal(body, &aiscvc)
		return aiscvc, err
	case string(ContainerTypeSQLAGWorkLoadContainer1):
		var aswcpc AzureSQLAGWorkloadContainerProtectionContainer
		err := json.Unmarshal(body, &aswcpc)
		return aswcpc, err
	case string(ContainerTypeAzureSQLContainer1):
		var asc AzureSQLContainer
		err := json.Unmarshal(body, &asc)
		return asc, err
	case string(ContainerTypeStorageContainer1):
		var asc AzureStorageContainer
		err := json.Unmarshal(body, &asc)
		return asc, err
	case string(ContainerTypeVMAppContainer1):
		var avacpc AzureVMAppContainerProtectionContainer
		err := json.Unmarshal(body, &avacpc)
		return avacpc, err
	case string(ContainerTypeAzureWorkloadContainer):
		var awc AzureWorkloadContainer
		err := json.Unmarshal(body, &awc)
		return awc, err
	case string(ContainerTypeDPMContainer1):
		var dc DpmContainer
		err := json.Unmarshal(body, &dc)
		return dc, err
	case string(ContainerTypeGenericContainer1):
		var gc GenericContainer
		err := json.Unmarshal(body, &gc)
		return gc, err
	case string(ContainerTypeIaaSVMContainer):
		var isc IaaSVMContainer
		err := json.Unmarshal(body, &isc)
		return isc, err
	case string(ContainerTypeWindows1):
		var mc MabContainer
		err := json.Unmarshal(body, &mc)
		return mc, err
	default:
		var pc ProtectionContainer
		err := json.Unmarshal(body, &pc)
		return pc, err
	}
}
func unmarshalBasicProtectionContainerArray(body []byte) ([]BasicProtectionContainer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	pcArray := make([]BasicProtectionContainer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		pc, err := unmarshalBasicProtectionContainer(*rawMessage)
		if err != nil {
			return nil, err
		}
		pcArray[index] = pc
	}
	return pcArray, nil
}

// MarshalJSON is the custom marshaler for ProtectionContainer.
func (pc ProtectionContainer) MarshalJSON() ([]byte, error) {
	pc.ContainerType = ContainerTypeProtectionContainer
	objectMap := make(map[string]interface{})
	if pc.FriendlyName != nil {
		objectMap["friendlyName"] = pc.FriendlyName
	}
	if pc.BackupManagementType != "" {
		objectMap["backupManagementType"] = pc.BackupManagementType
	}
	if pc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = pc.RegistrationStatus
	}
	if pc.HealthStatus != nil {
		objectMap["healthStatus"] = pc.HealthStatus
	}
	if pc.ContainerType != "" {
		objectMap["containerType"] = pc.ContainerType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsAzureBackupServerContainer() (*AzureBackupServerContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureSQLAGWorkloadContainerProtectionContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsAzureSQLAGWorkloadContainerProtectionContainer() (*AzureSQLAGWorkloadContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsAzureStorageContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsAzureStorageContainer() (*AzureStorageContainer, bool) {
	return nil, false
}

// AsAzureVMAppContainerProtectionContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsAzureVMAppContainerProtectionContainer() (*AzureVMAppContainerProtectionContainer, bool) {
	return nil, false
}

// AsAzureWorkloadContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsAzureWorkloadContainer() (*AzureWorkloadContainer, bool) {
	return nil, false
}

// AsBasicAzureWorkloadContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsBasicAzureWorkloadContainer() (BasicAzureWorkloadContainer, bool) {
	return nil, false
}

// AsDpmContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsDpmContainer() (*DpmContainer, bool) {
	return nil, false
}

// AsBasicDpmContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsBasicDpmContainer() (BasicDpmContainer, bool) {
	return nil, false
}

// AsGenericContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsGenericContainer() (*GenericContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return nil, false
}

// AsMabContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return &pc, true
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &pc, true
}

// ProtectionContainerResource base class for container with backup items. Containers with specific
// workloads are derived from this class.
type ProtectionContainerResource struct {
	autorest.Response `json:"-"`
	// Properties - ProtectionContainerResource properties
	Properties BasicProtectionContainer `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for ProtectionContainerResource.
func (pcr ProtectionContainerResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = pcr.Properties
	if pcr.Location != nil {
		objectMap["location"] = pcr.Location
	}
	if pcr.Tags != nil {
		objectMap["tags"] = pcr.Tags
	}
	if pcr.ETag != nil {
		objectMap["eTag"] = pcr.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProtectionContainerResource struct.
func (pcr *ProtectionContainerResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicProtectionContainer(*v)
				if err != nil {
					return err
				}
				pcr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pcr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pcr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pcr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pcr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pcr.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				pcr.ETag = &eTag
			}
		}
	}

	return nil
}

// ProtectionContainerResourceList list of ProtectionContainer resources
type ProtectionContainerResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of resources.
	Value *[]ProtectionContainerResource `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProtectionContainerResourceListIterator provides access to a complete listing of
// ProtectionContainerResource values.
type ProtectionContainerResourceListIterator struct {
	i    int
	page ProtectionContainerResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProtectionContainerResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProtectionContainerResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProtectionContainerResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProtectionContainerResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProtectionContainerResourceListIterator) Response() ProtectionContainerResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProtectionContainerResourceListIterator) Value() ProtectionContainerResource {
	if !iter.page.NotDone() {
		return ProtectionContainerResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProtectionContainerResourceListIterator type.
func NewProtectionContainerResourceListIterator(page ProtectionContainerResourceListPage) ProtectionContainerResourceListIterator {
	return ProtectionContainerResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pcrl ProtectionContainerResourceList) IsEmpty() bool {
	return pcrl.Value == nil || len(*pcrl.Value) == 0
}

// protectionContainerResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pcrl ProtectionContainerResourceList) protectionContainerResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if pcrl.NextLink == nil || len(to.String(pcrl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pcrl.NextLink)))
}

// ProtectionContainerResourceListPage contains a page of ProtectionContainerResource values.
type ProtectionContainerResourceListPage struct {
	fn   func(context.Context, ProtectionContainerResourceList) (ProtectionContainerResourceList, error)
	pcrl ProtectionContainerResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProtectionContainerResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProtectionContainerResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.pcrl)
	if err != nil {
		return err
	}
	page.pcrl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProtectionContainerResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProtectionContainerResourceListPage) NotDone() bool {
	return !page.pcrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProtectionContainerResourceListPage) Response() ProtectionContainerResourceList {
	return page.pcrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProtectionContainerResourceListPage) Values() []ProtectionContainerResource {
	if page.pcrl.IsEmpty() {
		return nil
	}
	return *page.pcrl.Value
}

// Creates a new instance of the ProtectionContainerResourceListPage type.
func NewProtectionContainerResourceListPage(getNextPage func(context.Context, ProtectionContainerResourceList) (ProtectionContainerResourceList, error)) ProtectionContainerResourceListPage {
	return ProtectionContainerResourceListPage{fn: getNextPage}
}

// BasicProtectionIntent base class for backup ProtectionIntent.
type BasicProtectionIntent interface {
	AsAzureRecoveryServiceVaultProtectionIntent() (*AzureRecoveryServiceVaultProtectionIntent, bool)
	AsBasicAzureRecoveryServiceVaultProtectionIntent() (BasicAzureRecoveryServiceVaultProtectionIntent, bool)
	AsAzureResourceProtectionIntent() (*AzureResourceProtectionIntent, bool)
	AsAzureWorkloadAutoProtectionIntent() (*AzureWorkloadAutoProtectionIntent, bool)
	AsBasicAzureWorkloadAutoProtectionIntent() (BasicAzureWorkloadAutoProtectionIntent, bool)
	AsAzureWorkloadSQLAutoProtectionIntent() (*AzureWorkloadSQLAutoProtectionIntent, bool)
	AsProtectionIntent() (*ProtectionIntent, bool)
}

// ProtectionIntent base class for backup ProtectionIntent.
type ProtectionIntent struct {
	// BackupManagementType - Type of backup management for the backed up item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// SourceResourceID - ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// ItemID - ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
	ItemID *string `json:"itemId,omitempty"`
	// PolicyID - ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`
	// ProtectionState - Backup state of this backup item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectionIntentItemType - Possible values include: 'ProtectionIntentItemTypeProtectionIntent', 'ProtectionIntentItemTypeRecoveryServiceVaultItem', 'ProtectionIntentItemTypeAzureResourceItem', 'ProtectionIntentItemTypeAzureWorkloadAutoProtectionIntent', 'ProtectionIntentItemTypeAzureWorkloadSQLAutoProtectionIntent'
	ProtectionIntentItemType ProtectionIntentItemType `json:"protectionIntentItemType,omitempty"`
}

func unmarshalBasicProtectionIntent(body []byte) (BasicProtectionIntent, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["protectionIntentItemType"] {
	case string(ProtectionIntentItemTypeRecoveryServiceVaultItem):
		var arsvpi AzureRecoveryServiceVaultProtectionIntent
		err := json.Unmarshal(body, &arsvpi)
		return arsvpi, err
	case string(ProtectionIntentItemTypeAzureResourceItem):
		var arpi AzureResourceProtectionIntent
		err := json.Unmarshal(body, &arpi)
		return arpi, err
	case string(ProtectionIntentItemTypeAzureWorkloadAutoProtectionIntent):
		var awapi AzureWorkloadAutoProtectionIntent
		err := json.Unmarshal(body, &awapi)
		return awapi, err
	case string(ProtectionIntentItemTypeAzureWorkloadSQLAutoProtectionIntent):
		var awsapi AzureWorkloadSQLAutoProtectionIntent
		err := json.Unmarshal(body, &awsapi)
		return awsapi, err
	default:
		var pi ProtectionIntent
		err := json.Unmarshal(body, &pi)
		return pi, err
	}
}
func unmarshalBasicProtectionIntentArray(body []byte) ([]BasicProtectionIntent, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	piArray := make([]BasicProtectionIntent, len(rawMessages))

	for index, rawMessage := range rawMessages {
		pi, err := unmarshalBasicProtectionIntent(*rawMessage)
		if err != nil {
			return nil, err
		}
		piArray[index] = pi
	}
	return piArray, nil
}

// MarshalJSON is the custom marshaler for ProtectionIntent.
func (pi ProtectionIntent) MarshalJSON() ([]byte, error) {
	pi.ProtectionIntentItemType = ProtectionIntentItemTypeProtectionIntent
	objectMap := make(map[string]interface{})
	if pi.BackupManagementType != "" {
		objectMap["backupManagementType"] = pi.BackupManagementType
	}
	if pi.SourceResourceID != nil {
		objectMap["sourceResourceId"] = pi.SourceResourceID
	}
	if pi.ItemID != nil {
		objectMap["itemId"] = pi.ItemID
	}
	if pi.PolicyID != nil {
		objectMap["policyId"] = pi.PolicyID
	}
	if pi.ProtectionState != "" {
		objectMap["protectionState"] = pi.ProtectionState
	}
	if pi.ProtectionIntentItemType != "" {
		objectMap["protectionIntentItemType"] = pi.ProtectionIntentItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureRecoveryServiceVaultProtectionIntent is the BasicProtectionIntent implementation for ProtectionIntent.
func (pi ProtectionIntent) AsAzureRecoveryServiceVaultProtectionIntent() (*AzureRecoveryServiceVaultProtectionIntent, bool) {
	return nil, false
}

// AsBasicAzureRecoveryServiceVaultProtectionIntent is the BasicProtectionIntent implementation for ProtectionIntent.
func (pi ProtectionIntent) AsBasicAzureRecoveryServiceVaultProtectionIntent() (BasicAzureRecoveryServiceVaultProtectionIntent, bool) {
	return nil, false
}

// AsAzureResourceProtectionIntent is the BasicProtectionIntent implementation for ProtectionIntent.
func (pi ProtectionIntent) AsAzureResourceProtectionIntent() (*AzureResourceProtectionIntent, bool) {
	return nil, false
}

// AsAzureWorkloadAutoProtectionIntent is the BasicProtectionIntent implementation for ProtectionIntent.
func (pi ProtectionIntent) AsAzureWorkloadAutoProtectionIntent() (*AzureWorkloadAutoProtectionIntent, bool) {
	return nil, false
}

// AsBasicAzureWorkloadAutoProtectionIntent is the BasicProtectionIntent implementation for ProtectionIntent.
func (pi ProtectionIntent) AsBasicAzureWorkloadAutoProtectionIntent() (BasicAzureWorkloadAutoProtectionIntent, bool) {
	return nil, false
}

// AsAzureWorkloadSQLAutoProtectionIntent is the BasicProtectionIntent implementation for ProtectionIntent.
func (pi ProtectionIntent) AsAzureWorkloadSQLAutoProtectionIntent() (*AzureWorkloadSQLAutoProtectionIntent, bool) {
	return nil, false
}

// AsProtectionIntent is the BasicProtectionIntent implementation for ProtectionIntent.
func (pi ProtectionIntent) AsProtectionIntent() (*ProtectionIntent, bool) {
	return &pi, true
}

// AsBasicProtectionIntent is the BasicProtectionIntent implementation for ProtectionIntent.
func (pi ProtectionIntent) AsBasicProtectionIntent() (BasicProtectionIntent, bool) {
	return &pi, true
}

// ProtectionIntentQueryObject filters to list protection intent.
type ProtectionIntentQueryObject struct {
	// BackupManagementType - Backup management type for the backed up item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// ItemType - Type of workload this item represents. Possible values include: 'IntentItemTypeInvalid', 'IntentItemTypeSQLInstance', 'IntentItemTypeSQLAvailabilityGroupContainer'
	ItemType IntentItemType `json:"itemType,omitempty"`
	// ParentName - Parent name of the intent
	ParentName *string `json:"parentName,omitempty"`
	// ItemName - Item name of the intent
	ItemName *string `json:"itemName,omitempty"`
}

// ProtectionIntentResource base class for backup ProtectionIntent.
type ProtectionIntentResource struct {
	autorest.Response `json:"-"`
	// Properties - ProtectionIntentResource properties
	Properties BasicProtectionIntent `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for ProtectionIntentResource.
func (pir ProtectionIntentResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = pir.Properties
	if pir.Location != nil {
		objectMap["location"] = pir.Location
	}
	if pir.Tags != nil {
		objectMap["tags"] = pir.Tags
	}
	if pir.ETag != nil {
		objectMap["eTag"] = pir.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProtectionIntentResource struct.
func (pir *ProtectionIntentResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicProtectionIntent(*v)
				if err != nil {
					return err
				}
				pir.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pir.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pir.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pir.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pir.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pir.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				pir.ETag = &eTag
			}
		}
	}

	return nil
}

// ProtectionIntentResourceList list of ProtectionIntent resources
type ProtectionIntentResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of resources.
	Value *[]ProtectionIntentResource `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProtectionIntentResourceListIterator provides access to a complete listing of ProtectionIntentResource
// values.
type ProtectionIntentResourceListIterator struct {
	i    int
	page ProtectionIntentResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProtectionIntentResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProtectionIntentResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProtectionIntentResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProtectionIntentResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProtectionIntentResourceListIterator) Response() ProtectionIntentResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProtectionIntentResourceListIterator) Value() ProtectionIntentResource {
	if !iter.page.NotDone() {
		return ProtectionIntentResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProtectionIntentResourceListIterator type.
func NewProtectionIntentResourceListIterator(page ProtectionIntentResourceListPage) ProtectionIntentResourceListIterator {
	return ProtectionIntentResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pirl ProtectionIntentResourceList) IsEmpty() bool {
	return pirl.Value == nil || len(*pirl.Value) == 0
}

// protectionIntentResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pirl ProtectionIntentResourceList) protectionIntentResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if pirl.NextLink == nil || len(to.String(pirl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pirl.NextLink)))
}

// ProtectionIntentResourceListPage contains a page of ProtectionIntentResource values.
type ProtectionIntentResourceListPage struct {
	fn   func(context.Context, ProtectionIntentResourceList) (ProtectionIntentResourceList, error)
	pirl ProtectionIntentResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProtectionIntentResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProtectionIntentResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.pirl)
	if err != nil {
		return err
	}
	page.pirl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProtectionIntentResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProtectionIntentResourceListPage) NotDone() bool {
	return !page.pirl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProtectionIntentResourceListPage) Response() ProtectionIntentResourceList {
	return page.pirl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProtectionIntentResourceListPage) Values() []ProtectionIntentResource {
	if page.pirl.IsEmpty() {
		return nil
	}
	return *page.pirl.Value
}

// Creates a new instance of the ProtectionIntentResourceListPage type.
func NewProtectionIntentResourceListPage(getNextPage func(context.Context, ProtectionIntentResourceList) (ProtectionIntentResourceList, error)) ProtectionIntentResourceListPage {
	return ProtectionIntentResourceListPage{fn: getNextPage}
}

// BasicProtectionPolicy base class for backup policy. Workload-specific backup policies are derived from this class.
type BasicProtectionPolicy interface {
	AsAzureVMWorkloadProtectionPolicy() (*AzureVMWorkloadProtectionPolicy, bool)
	AsAzureFileShareProtectionPolicy() (*AzureFileShareProtectionPolicy, bool)
	AsAzureIaaSVMProtectionPolicy() (*AzureIaaSVMProtectionPolicy, bool)
	AsAzureSQLProtectionPolicy() (*AzureSQLProtectionPolicy, bool)
	AsGenericProtectionPolicy() (*GenericProtectionPolicy, bool)
	AsMabProtectionPolicy() (*MabProtectionPolicy, bool)
	AsProtectionPolicy() (*ProtectionPolicy, bool)
}

// ProtectionPolicy base class for backup policy. Workload-specific backup policies are derived from this
// class.
type ProtectionPolicy struct {
	// ProtectedItemsCount - Number of items associated with this policy.
	ProtectedItemsCount *int32 `json:"protectedItemsCount,omitempty"`
	// BackupManagementType - Possible values include: 'BackupManagementTypeProtectionPolicy', 'BackupManagementTypeAzureWorkload', 'BackupManagementTypeAzureStorage', 'BackupManagementTypeAzureIaasVM', 'BackupManagementTypeAzureSQL', 'BackupManagementTypeGenericProtectionPolicy', 'BackupManagementTypeMAB'
	BackupManagementType ManagementTypeBasicProtectionPolicy `json:"backupManagementType,omitempty"`
}

func unmarshalBasicProtectionPolicy(body []byte) (BasicProtectionPolicy, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["backupManagementType"] {
	case string(BackupManagementTypeAzureWorkload):
		var avwpp AzureVMWorkloadProtectionPolicy
		err := json.Unmarshal(body, &avwpp)
		return avwpp, err
	case string(BackupManagementTypeAzureStorage):
		var afspp AzureFileShareProtectionPolicy
		err := json.Unmarshal(body, &afspp)
		return afspp, err
	case string(BackupManagementTypeAzureIaasVM):
		var aispp AzureIaaSVMProtectionPolicy
		err := json.Unmarshal(body, &aispp)
		return aispp, err
	case string(BackupManagementTypeAzureSQL):
		var aspp AzureSQLProtectionPolicy
		err := json.Unmarshal(body, &aspp)
		return aspp, err
	case string(BackupManagementTypeGenericProtectionPolicy):
		var gpp GenericProtectionPolicy
		err := json.Unmarshal(body, &gpp)
		return gpp, err
	case string(BackupManagementTypeMAB):
		var mpp MabProtectionPolicy
		err := json.Unmarshal(body, &mpp)
		return mpp, err
	default:
		var pp ProtectionPolicy
		err := json.Unmarshal(body, &pp)
		return pp, err
	}
}
func unmarshalBasicProtectionPolicyArray(body []byte) ([]BasicProtectionPolicy, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ppArray := make([]BasicProtectionPolicy, len(rawMessages))

	for index, rawMessage := range rawMessages {
		pp, err := unmarshalBasicProtectionPolicy(*rawMessage)
		if err != nil {
			return nil, err
		}
		ppArray[index] = pp
	}
	return ppArray, nil
}

// MarshalJSON is the custom marshaler for ProtectionPolicy.
func (pp ProtectionPolicy) MarshalJSON() ([]byte, error) {
	pp.BackupManagementType = BackupManagementTypeProtectionPolicy
	objectMap := make(map[string]interface{})
	if pp.ProtectedItemsCount != nil {
		objectMap["protectedItemsCount"] = pp.ProtectedItemsCount
	}
	if pp.BackupManagementType != "" {
		objectMap["backupManagementType"] = pp.BackupManagementType
	}
	return json.Marshal(objectMap)
}

// AsAzureVMWorkloadProtectionPolicy is the BasicProtectionPolicy implementation for ProtectionPolicy.
func (pp ProtectionPolicy) AsAzureVMWorkloadProtectionPolicy() (*AzureVMWorkloadProtectionPolicy, bool) {
	return nil, false
}

// AsAzureFileShareProtectionPolicy is the BasicProtectionPolicy implementation for ProtectionPolicy.
func (pp ProtectionPolicy) AsAzureFileShareProtectionPolicy() (*AzureFileShareProtectionPolicy, bool) {
	return nil, false
}

// AsAzureIaaSVMProtectionPolicy is the BasicProtectionPolicy implementation for ProtectionPolicy.
func (pp ProtectionPolicy) AsAzureIaaSVMProtectionPolicy() (*AzureIaaSVMProtectionPolicy, bool) {
	return nil, false
}

// AsAzureSQLProtectionPolicy is the BasicProtectionPolicy implementation for ProtectionPolicy.
func (pp ProtectionPolicy) AsAzureSQLProtectionPolicy() (*AzureSQLProtectionPolicy, bool) {
	return nil, false
}

// AsGenericProtectionPolicy is the BasicProtectionPolicy implementation for ProtectionPolicy.
func (pp ProtectionPolicy) AsGenericProtectionPolicy() (*GenericProtectionPolicy, bool) {
	return nil, false
}

// AsMabProtectionPolicy is the BasicProtectionPolicy implementation for ProtectionPolicy.
func (pp ProtectionPolicy) AsMabProtectionPolicy() (*MabProtectionPolicy, bool) {
	return nil, false
}

// AsProtectionPolicy is the BasicProtectionPolicy implementation for ProtectionPolicy.
func (pp ProtectionPolicy) AsProtectionPolicy() (*ProtectionPolicy, bool) {
	return &pp, true
}

// AsBasicProtectionPolicy is the BasicProtectionPolicy implementation for ProtectionPolicy.
func (pp ProtectionPolicy) AsBasicProtectionPolicy() (BasicProtectionPolicy, bool) {
	return &pp, true
}

// ProtectionPolicyQueryObject filters the list backup policies API.
type ProtectionPolicyQueryObject struct {
	// BackupManagementType - Backup management type for the backup policy. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL', 'ManagementTypeAzureStorage', 'ManagementTypeAzureWorkload', 'ManagementTypeDefaultBackup'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// FabricName - Fabric name for filter
	FabricName *string `json:"fabricName,omitempty"`
	// WorkloadType - Workload type for the backup policy. Possible values include: 'WorkloadTypeInvalid', 'WorkloadTypeVM', 'WorkloadTypeFileFolder', 'WorkloadTypeAzureSQLDb', 'WorkloadTypeSQLDB', 'WorkloadTypeExchange', 'WorkloadTypeSharepoint', 'WorkloadTypeVMwareVM', 'WorkloadTypeSystemState', 'WorkloadTypeClient', 'WorkloadTypeGenericDataSource', 'WorkloadTypeSQLDataBase', 'WorkloadTypeAzureFileShare', 'WorkloadTypeSAPHanaDatabase', 'WorkloadTypeSAPAseDatabase'
	WorkloadType WorkloadType `json:"workloadType,omitempty"`
}

// ProtectionPolicyResource base class for backup policy. Workload-specific backup policies are derived
// from this class.
type ProtectionPolicyResource struct {
	autorest.Response `json:"-"`
	// Properties - ProtectionPolicyResource properties
	Properties BasicProtectionPolicy `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for ProtectionPolicyResource.
func (ppr ProtectionPolicyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = ppr.Properties
	if ppr.Location != nil {
		objectMap["location"] = ppr.Location
	}
	if ppr.Tags != nil {
		objectMap["tags"] = ppr.Tags
	}
	if ppr.ETag != nil {
		objectMap["eTag"] = ppr.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProtectionPolicyResource struct.
func (ppr *ProtectionPolicyResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicProtectionPolicy(*v)
				if err != nil {
					return err
				}
				ppr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ppr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ppr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ppr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ppr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ppr.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				ppr.ETag = &eTag
			}
		}
	}

	return nil
}

// ProtectionPolicyResourceList list of ProtectionPolicy resources
type ProtectionPolicyResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of resources.
	Value *[]ProtectionPolicyResource `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProtectionPolicyResourceListIterator provides access to a complete listing of ProtectionPolicyResource
// values.
type ProtectionPolicyResourceListIterator struct {
	i    int
	page ProtectionPolicyResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProtectionPolicyResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProtectionPolicyResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProtectionPolicyResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProtectionPolicyResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProtectionPolicyResourceListIterator) Response() ProtectionPolicyResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProtectionPolicyResourceListIterator) Value() ProtectionPolicyResource {
	if !iter.page.NotDone() {
		return ProtectionPolicyResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProtectionPolicyResourceListIterator type.
func NewProtectionPolicyResourceListIterator(page ProtectionPolicyResourceListPage) ProtectionPolicyResourceListIterator {
	return ProtectionPolicyResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pprl ProtectionPolicyResourceList) IsEmpty() bool {
	return pprl.Value == nil || len(*pprl.Value) == 0
}

// protectionPolicyResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pprl ProtectionPolicyResourceList) protectionPolicyResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if pprl.NextLink == nil || len(to.String(pprl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pprl.NextLink)))
}

// ProtectionPolicyResourceListPage contains a page of ProtectionPolicyResource values.
type ProtectionPolicyResourceListPage struct {
	fn   func(context.Context, ProtectionPolicyResourceList) (ProtectionPolicyResourceList, error)
	pprl ProtectionPolicyResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProtectionPolicyResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProtectionPolicyResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.pprl)
	if err != nil {
		return err
	}
	page.pprl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProtectionPolicyResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProtectionPolicyResourceListPage) NotDone() bool {
	return !page.pprl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProtectionPolicyResourceListPage) Response() ProtectionPolicyResourceList {
	return page.pprl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProtectionPolicyResourceListPage) Values() []ProtectionPolicyResource {
	if page.pprl.IsEmpty() {
		return nil
	}
	return *page.pprl.Value
}

// Creates a new instance of the ProtectionPolicyResourceListPage type.
func NewProtectionPolicyResourceListPage(getNextPage func(context.Context, ProtectionPolicyResourceList) (ProtectionPolicyResourceList, error)) ProtectionPolicyResourceListPage {
	return ProtectionPolicyResourceListPage{fn: getNextPage}
}

// BasicRecoveryPoint base class for backup copies. Workload-specific backup copies are derived from this class.
type BasicRecoveryPoint interface {
	AsAzureFileShareRecoveryPoint() (*AzureFileShareRecoveryPoint, bool)
	AsAzureWorkloadPointInTimeRecoveryPoint() (*AzureWorkloadPointInTimeRecoveryPoint, bool)
	AsBasicAzureWorkloadPointInTimeRecoveryPoint() (BasicAzureWorkloadPointInTimeRecoveryPoint, bool)
	AsAzureWorkloadRecoveryPoint() (*AzureWorkloadRecoveryPoint, bool)
	AsBasicAzureWorkloadRecoveryPoint() (BasicAzureWorkloadRecoveryPoint, bool)
	AsAzureWorkloadSAPHanaPointInTimeRecoveryPoint() (*AzureWorkloadSAPHanaPointInTimeRecoveryPoint, bool)
	AsAzureWorkloadSAPHanaRecoveryPoint() (*AzureWorkloadSAPHanaRecoveryPoint, bool)
	AsAzureWorkloadSQLPointInTimeRecoveryPoint() (*AzureWorkloadSQLPointInTimeRecoveryPoint, bool)
	AsAzureWorkloadSQLRecoveryPoint() (*AzureWorkloadSQLRecoveryPoint, bool)
	AsBasicAzureWorkloadSQLRecoveryPoint() (BasicAzureWorkloadSQLRecoveryPoint, bool)
	AsGenericRecoveryPoint() (*GenericRecoveryPoint, bool)
	AsIaasVMRecoveryPoint() (*IaasVMRecoveryPoint, bool)
	AsRecoveryPoint() (*RecoveryPoint, bool)
}

// RecoveryPoint base class for backup copies. Workload-specific backup copies are derived from this class.
type RecoveryPoint struct {
	// ObjectType - Possible values include: 'ObjectTypeRecoveryPoint', 'ObjectTypeAzureFileShareRecoveryPoint', 'ObjectTypeAzureWorkloadPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadRecoveryPoint', 'ObjectTypeAzureWorkloadSAPHanaPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadSAPHanaRecoveryPoint', 'ObjectTypeAzureWorkloadSQLPointInTimeRecoveryPoint', 'ObjectTypeAzureWorkloadSQLRecoveryPoint', 'ObjectTypeGenericRecoveryPoint', 'ObjectTypeIaasVMRecoveryPoint'
	ObjectType ObjectTypeBasicRecoveryPoint `json:"objectType,omitempty"`
}

func unmarshalBasicRecoveryPoint(body []byte) (BasicRecoveryPoint, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeAzureFileShareRecoveryPoint):
		var afsrp AzureFileShareRecoveryPoint
		err := json.Unmarshal(body, &afsrp)
		return afsrp, err
	case string(ObjectTypeAzureWorkloadPointInTimeRecoveryPoint):
		var awpitrp AzureWorkloadPointInTimeRecoveryPoint
		err := json.Unmarshal(body, &awpitrp)
		return awpitrp, err
	case string(ObjectTypeAzureWorkloadRecoveryPoint):
		var awrp AzureWorkloadRecoveryPoint
		err := json.Unmarshal(body, &awrp)
		return awrp, err
	case string(ObjectTypeAzureWorkloadSAPHanaPointInTimeRecoveryPoint):
		var awshpitrp AzureWorkloadSAPHanaPointInTimeRecoveryPoint
		err := json.Unmarshal(body, &awshpitrp)
		return awshpitrp, err
	case string(ObjectTypeAzureWorkloadSAPHanaRecoveryPoint):
		var awshrp AzureWorkloadSAPHanaRecoveryPoint
		err := json.Unmarshal(body, &awshrp)
		return awshrp, err
	case string(ObjectTypeAzureWorkloadSQLPointInTimeRecoveryPoint):
		var awspitrp AzureWorkloadSQLPointInTimeRecoveryPoint
		err := json.Unmarshal(body, &awspitrp)
		return awspitrp, err
	case string(ObjectTypeAzureWorkloadSQLRecoveryPoint):
		var awsrp AzureWorkloadSQLRecoveryPoint
		err := json.Unmarshal(body, &awsrp)
		return awsrp, err
	case string(ObjectTypeGenericRecoveryPoint):
		var grp GenericRecoveryPoint
		err := json.Unmarshal(body, &grp)
		return grp, err
	case string(ObjectTypeIaasVMRecoveryPoint):
		var ivrp IaasVMRecoveryPoint
		err := json.Unmarshal(body, &ivrp)
		return ivrp, err
	default:
		var rp RecoveryPoint
		err := json.Unmarshal(body, &rp)
		return rp, err
	}
}
func unmarshalBasicRecoveryPointArray(body []byte) ([]BasicRecoveryPoint, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rpArray := make([]BasicRecoveryPoint, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rp, err := unmarshalBasicRecoveryPoint(*rawMessage)
		if err != nil {
			return nil, err
		}
		rpArray[index] = rp
	}
	return rpArray, nil
}

// MarshalJSON is the custom marshaler for RecoveryPoint.
func (rp RecoveryPoint) MarshalJSON() ([]byte, error) {
	rp.ObjectType = ObjectTypeRecoveryPoint
	objectMap := make(map[string]interface{})
	if rp.ObjectType != "" {
		objectMap["objectType"] = rp.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareRecoveryPoint is the BasicRecoveryPoint implementation for RecoveryPoint.
func (rp RecoveryPoint) AsAzureFileShareRecoveryPoint() (*AzureFileShareRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for RecoveryPoint.
func (rp RecoveryPoint) AsAzureWorkloadPointInTimeRecoveryPoint() (*AzureWorkloadPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for RecoveryPoint.
func (rp RecoveryPoint) AsBasicAzureWorkloadPointInTimeRecoveryPoint() (BasicAzureWorkloadPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadRecoveryPoint is the BasicRecoveryPoint implementation for RecoveryPoint.
func (rp RecoveryPoint) AsAzureWorkloadRecoveryPoint() (*AzureWorkloadRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadRecoveryPoint is the BasicRecoveryPoint implementation for RecoveryPoint.
func (rp RecoveryPoint) AsBasicAzureWorkloadRecoveryPoint() (BasicAzureWorkloadRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSAPHanaPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for RecoveryPoint.
func (rp RecoveryPoint) AsAzureWorkloadSAPHanaPointInTimeRecoveryPoint() (*AzureWorkloadSAPHanaPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSAPHanaRecoveryPoint is the BasicRecoveryPoint implementation for RecoveryPoint.
func (rp RecoveryPoint) AsAzureWorkloadSAPHanaRecoveryPoint() (*AzureWorkloadSAPHanaRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSQLPointInTimeRecoveryPoint is the BasicRecoveryPoint implementation for RecoveryPoint.
func (rp RecoveryPoint) AsAzureWorkloadSQLPointInTimeRecoveryPoint() (*AzureWorkloadSQLPointInTimeRecoveryPoint, bool) {
	return nil, false
}

// AsAzureWorkloadSQLRecoveryPoint is the BasicRecoveryPoint implementation for RecoveryPoint.
func (rp RecoveryPoint) AsAzureWorkloadSQLRecoveryPoint() (*AzureWorkloadSQLRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureWorkloadSQLRecoveryPoint is the BasicRecoveryPoint implementation for RecoveryPoint.
func (rp RecoveryPoint) AsBasicAzureWorkloadSQLRecoveryPoint() (BasicAzureWorkloadSQLRecoveryPoint, bool) {
	return nil, false
}

// AsGenericRecoveryPoint is the BasicRecoveryPoint implementation for RecoveryPoint.
func (rp RecoveryPoint) AsGenericRecoveryPoint() (*GenericRecoveryPoint, bool) {
	return nil, false
}

// AsIaasVMRecoveryPoint is the BasicRecoveryPoint implementation for RecoveryPoint.
func (rp RecoveryPoint) AsIaasVMRecoveryPoint() (*IaasVMRecoveryPoint, bool) {
	return nil, false
}

// AsRecoveryPoint is the BasicRecoveryPoint implementation for RecoveryPoint.
func (rp RecoveryPoint) AsRecoveryPoint() (*RecoveryPoint, bool) {
	return &rp, true
}

// AsBasicRecoveryPoint is the BasicRecoveryPoint implementation for RecoveryPoint.
func (rp RecoveryPoint) AsBasicRecoveryPoint() (BasicRecoveryPoint, bool) {
	return &rp, true
}

// RecoveryPointDiskConfiguration disk configuration
type RecoveryPointDiskConfiguration struct {
	// NumberOfDisksIncludedInBackup - Number of disks included in backup
	NumberOfDisksIncludedInBackup *int32 `json:"numberOfDisksIncludedInBackup,omitempty"`
	// NumberOfDisksAttachedToVM - Number of disks attached to the VM
	NumberOfDisksAttachedToVM *int32 `json:"numberOfDisksAttachedToVm,omitempty"`
	// IncludedDiskList - Information of disks included in backup
	IncludedDiskList *[]DiskInformation `json:"includedDiskList,omitempty"`
	// ExcludedDiskList - Information of disks excluded from backup
	ExcludedDiskList *[]DiskInformation `json:"excludedDiskList,omitempty"`
}

// RecoveryPointResource base class for backup copies. Workload-specific backup copies are derived from
// this class.
type RecoveryPointResource struct {
	autorest.Response `json:"-"`
	// Properties - RecoveryPointResource properties
	Properties BasicRecoveryPoint `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPointResource.
func (rpr RecoveryPointResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = rpr.Properties
	if rpr.Location != nil {
		objectMap["location"] = rpr.Location
	}
	if rpr.Tags != nil {
		objectMap["tags"] = rpr.Tags
	}
	if rpr.ETag != nil {
		objectMap["eTag"] = rpr.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RecoveryPointResource struct.
func (rpr *RecoveryPointResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicRecoveryPoint(*v)
				if err != nil {
					return err
				}
				rpr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rpr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rpr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rpr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rpr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rpr.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				rpr.ETag = &eTag
			}
		}
	}

	return nil
}

// RecoveryPointResourceList list of RecoveryPoint resources
type RecoveryPointResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of resources.
	Value *[]RecoveryPointResource `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// RecoveryPointResourceListIterator provides access to a complete listing of RecoveryPointResource values.
type RecoveryPointResourceListIterator struct {
	i    int
	page RecoveryPointResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RecoveryPointResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecoveryPointResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RecoveryPointResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RecoveryPointResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RecoveryPointResourceListIterator) Response() RecoveryPointResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RecoveryPointResourceListIterator) Value() RecoveryPointResource {
	if !iter.page.NotDone() {
		return RecoveryPointResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RecoveryPointResourceListIterator type.
func NewRecoveryPointResourceListIterator(page RecoveryPointResourceListPage) RecoveryPointResourceListIterator {
	return RecoveryPointResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rprl RecoveryPointResourceList) IsEmpty() bool {
	return rprl.Value == nil || len(*rprl.Value) == 0
}

// recoveryPointResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rprl RecoveryPointResourceList) recoveryPointResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if rprl.NextLink == nil || len(to.String(rprl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rprl.NextLink)))
}

// RecoveryPointResourceListPage contains a page of RecoveryPointResource values.
type RecoveryPointResourceListPage struct {
	fn   func(context.Context, RecoveryPointResourceList) (RecoveryPointResourceList, error)
	rprl RecoveryPointResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RecoveryPointResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecoveryPointResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rprl)
	if err != nil {
		return err
	}
	page.rprl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RecoveryPointResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RecoveryPointResourceListPage) NotDone() bool {
	return !page.rprl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RecoveryPointResourceListPage) Response() RecoveryPointResourceList {
	return page.rprl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RecoveryPointResourceListPage) Values() []RecoveryPointResource {
	if page.rprl.IsEmpty() {
		return nil
	}
	return *page.rprl.Value
}

// Creates a new instance of the RecoveryPointResourceListPage type.
func NewRecoveryPointResourceListPage(getNextPage func(context.Context, RecoveryPointResourceList) (RecoveryPointResourceList, error)) RecoveryPointResourceListPage {
	return RecoveryPointResourceListPage{fn: getNextPage}
}

// RecoveryPointTierInformation recovery point tier information.
type RecoveryPointTierInformation struct {
	// Type - Recovery point tier type. Possible values include: 'RecoveryPointTierTypeInvalid', 'RecoveryPointTierTypeInstantRP', 'RecoveryPointTierTypeHardenedRP'
	Type RecoveryPointTierType `json:"type,omitempty"`
	// Status - Recovery point tier status. Possible values include: 'RecoveryPointTierStatusInvalid', 'RecoveryPointTierStatusValid', 'RecoveryPointTierStatusDisabled', 'RecoveryPointTierStatusDeleted'
	Status RecoveryPointTierStatus `json:"status,omitempty"`
}

// BasicRequest base class for backup request. Workload-specific backup requests are derived from this class.
type BasicRequest interface {
	AsAzureFileShareBackupRequest() (*AzureFileShareBackupRequest, bool)
	AsAzureWorkloadBackupRequest() (*AzureWorkloadBackupRequest, bool)
	AsIaasVMBackupRequest() (*IaasVMBackupRequest, bool)
	AsRequest() (*Request, bool)
}

// Request base class for backup request. Workload-specific backup requests are derived from this class.
type Request struct {
	// ObjectType - Possible values include: 'ObjectTypeBackupRequest', 'ObjectTypeAzureFileShareBackupRequest', 'ObjectTypeAzureWorkloadBackupRequest', 'ObjectTypeIaasVMBackupRequest'
	ObjectType ObjectTypeBasicRequest `json:"objectType,omitempty"`
}

func unmarshalBasicRequest(body []byte) (BasicRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeAzureFileShareBackupRequest):
		var afsbr AzureFileShareBackupRequest
		err := json.Unmarshal(body, &afsbr)
		return afsbr, err
	case string(ObjectTypeAzureWorkloadBackupRequest):
		var awbr AzureWorkloadBackupRequest
		err := json.Unmarshal(body, &awbr)
		return awbr, err
	case string(ObjectTypeIaasVMBackupRequest):
		var ivbr IaasVMBackupRequest
		err := json.Unmarshal(body, &ivbr)
		return ivbr, err
	default:
		var r Request
		err := json.Unmarshal(body, &r)
		return r, err
	}
}
func unmarshalBasicRequestArray(body []byte) ([]BasicRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rArray := make([]BasicRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		r, err := unmarshalBasicRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		rArray[index] = r
	}
	return rArray, nil
}

// MarshalJSON is the custom marshaler for Request.
func (r Request) MarshalJSON() ([]byte, error) {
	r.ObjectType = ObjectTypeBackupRequest
	objectMap := make(map[string]interface{})
	if r.ObjectType != "" {
		objectMap["objectType"] = r.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareBackupRequest is the BasicRequest implementation for Request.
func (r Request) AsAzureFileShareBackupRequest() (*AzureFileShareBackupRequest, bool) {
	return nil, false
}

// AsAzureWorkloadBackupRequest is the BasicRequest implementation for Request.
func (r Request) AsAzureWorkloadBackupRequest() (*AzureWorkloadBackupRequest, bool) {
	return nil, false
}

// AsIaasVMBackupRequest is the BasicRequest implementation for Request.
func (r Request) AsIaasVMBackupRequest() (*IaasVMBackupRequest, bool) {
	return nil, false
}

// AsRequest is the BasicRequest implementation for Request.
func (r Request) AsRequest() (*Request, bool) {
	return &r, true
}

// AsBasicRequest is the BasicRequest implementation for Request.
func (r Request) AsBasicRequest() (BasicRequest, bool) {
	return &r, true
}

// RequestResource base class for backup request. Workload-specific backup requests are derived from this
// class.
type RequestResource struct {
	// Properties - BackupRequestResource properties
	Properties BasicRequest `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for RequestResource.
func (rr RequestResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = rr.Properties
	if rr.Location != nil {
		objectMap["location"] = rr.Location
	}
	if rr.Tags != nil {
		objectMap["tags"] = rr.Tags
	}
	if rr.ETag != nil {
		objectMap["eTag"] = rr.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RequestResource struct.
func (rr *RequestResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicRequest(*v)
				if err != nil {
					return err
				}
				rr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rr.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				rr.ETag = &eTag
			}
		}
	}

	return nil
}

// Resource ARM Resource.
type Resource struct {
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	if r.ETag != nil {
		objectMap["eTag"] = r.ETag
	}
	return json.Marshal(objectMap)
}

// ResourceConfig the resource storage details.
type ResourceConfig struct {
	// StorageModelType - Storage type. Possible values include: 'StorageTypeInvalid', 'StorageTypeGeoRedundant', 'StorageTypeLocallyRedundant'
	StorageModelType StorageType `json:"storageModelType,omitempty"`
	// StorageType - Storage type. Possible values include: 'StorageTypeInvalid', 'StorageTypeGeoRedundant', 'StorageTypeLocallyRedundant'
	StorageType StorageType `json:"storageType,omitempty"`
	// StorageTypeState - Locked or Unlocked. Once a machine is registered against a resource, the storageTypeState is always Locked. Possible values include: 'StorageTypeStateInvalid', 'StorageTypeStateLocked', 'StorageTypeStateUnlocked'
	StorageTypeState StorageTypeState `json:"storageTypeState,omitempty"`
}

// ResourceConfigResource the resource storage details.
type ResourceConfigResource struct {
	autorest.Response `json:"-"`
	// Properties - BackupResourceConfigResource properties
	Properties *ResourceConfig `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceConfigResource.
func (rcr ResourceConfigResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcr.Properties != nil {
		objectMap["properties"] = rcr.Properties
	}
	if rcr.Location != nil {
		objectMap["location"] = rcr.Location
	}
	if rcr.Tags != nil {
		objectMap["tags"] = rcr.Tags
	}
	if rcr.ETag != nil {
		objectMap["eTag"] = rcr.ETag
	}
	return json.Marshal(objectMap)
}

// ResourceList base for all lists of resources.
type ResourceList struct {
	// NextLink - The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceVaultConfig backup resource vault config details.
type ResourceVaultConfig struct {
	// StorageModelType - Storage type. Possible values include: 'StorageTypeInvalid', 'StorageTypeGeoRedundant', 'StorageTypeLocallyRedundant'
	StorageModelType StorageType `json:"storageModelType,omitempty"`
	// StorageType - Storage type. Possible values include: 'StorageTypeInvalid', 'StorageTypeGeoRedundant', 'StorageTypeLocallyRedundant'
	StorageType StorageType `json:"storageType,omitempty"`
	// StorageTypeState - Locked or Unlocked. Once a machine is registered against a resource, the storageTypeState is always Locked. Possible values include: 'StorageTypeStateInvalid', 'StorageTypeStateLocked', 'StorageTypeStateUnlocked'
	StorageTypeState StorageTypeState `json:"storageTypeState,omitempty"`
	// EnhancedSecurityState - Enabled or Disabled. Possible values include: 'EnhancedSecurityStateInvalid', 'EnhancedSecurityStateEnabled', 'EnhancedSecurityStateDisabled'
	EnhancedSecurityState EnhancedSecurityState `json:"enhancedSecurityState,omitempty"`
	// SoftDeleteFeatureState - Soft Delete feature state. Possible values include: 'SoftDeleteFeatureStateInvalid', 'SoftDeleteFeatureStateEnabled', 'SoftDeleteFeatureStateDisabled'
	SoftDeleteFeatureState SoftDeleteFeatureState `json:"softDeleteFeatureState,omitempty"`
}

// ResourceVaultConfigResource backup resource vault config details.
type ResourceVaultConfigResource struct {
	autorest.Response `json:"-"`
	// Properties - BackupResourceVaultConfigResource properties
	Properties *ResourceVaultConfig `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceVaultConfigResource.
func (rvcr ResourceVaultConfigResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rvcr.Properties != nil {
		objectMap["properties"] = rvcr.Properties
	}
	if rvcr.Location != nil {
		objectMap["location"] = rvcr.Location
	}
	if rvcr.Tags != nil {
		objectMap["tags"] = rvcr.Tags
	}
	if rvcr.ETag != nil {
		objectMap["eTag"] = rvcr.ETag
	}
	return json.Marshal(objectMap)
}

// RestoreFileSpecs restore file specs like file path, type and target folder path info.
type RestoreFileSpecs struct {
	// Path - Source File/Folder path
	Path *string `json:"path,omitempty"`
	// FileSpecType - Indicates what the Path variable stands for
	FileSpecType *string `json:"fileSpecType,omitempty"`
	// TargetFolderPath - Destination folder path in target FileShare
	TargetFolderPath *string `json:"targetFolderPath,omitempty"`
}

// BasicRestoreRequest base class for restore request. Workload-specific restore requests are derived from this class.
type BasicRestoreRequest interface {
	AsAzureFileShareRestoreRequest() (*AzureFileShareRestoreRequest, bool)
	AsAzureWorkloadPointInTimeRestoreRequest() (*AzureWorkloadPointInTimeRestoreRequest, bool)
	AsAzureWorkloadRestoreRequest() (*AzureWorkloadRestoreRequest, bool)
	AsBasicAzureWorkloadRestoreRequest() (BasicAzureWorkloadRestoreRequest, bool)
	AsAzureWorkloadSAPHanaPointInTimeRestoreRequest() (*AzureWorkloadSAPHanaPointInTimeRestoreRequest, bool)
	AsAzureWorkloadSAPHanaRestoreRequest() (*AzureWorkloadSAPHanaRestoreRequest, bool)
	AsBasicAzureWorkloadSAPHanaRestoreRequest() (BasicAzureWorkloadSAPHanaRestoreRequest, bool)
	AsAzureWorkloadSQLPointInTimeRestoreRequest() (*AzureWorkloadSQLPointInTimeRestoreRequest, bool)
	AsAzureWorkloadSQLRestoreRequest() (*AzureWorkloadSQLRestoreRequest, bool)
	AsBasicAzureWorkloadSQLRestoreRequest() (BasicAzureWorkloadSQLRestoreRequest, bool)
	AsIaasVMRestoreRequest() (*IaasVMRestoreRequest, bool)
	AsRestoreRequest() (*RestoreRequest, bool)
}

// RestoreRequest base class for restore request. Workload-specific restore requests are derived from this
// class.
type RestoreRequest struct {
	// ObjectType - Possible values include: 'ObjectTypeRestoreRequest', 'ObjectTypeAzureFileShareRestoreRequest', 'ObjectTypeAzureWorkloadPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadRestoreRequest', 'ObjectTypeAzureWorkloadSAPHanaPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadSAPHanaRestoreRequest', 'ObjectTypeAzureWorkloadSQLPointInTimeRestoreRequest', 'ObjectTypeAzureWorkloadSQLRestoreRequest', 'ObjectTypeIaasVMRestoreRequest'
	ObjectType ObjectTypeBasicRestoreRequest `json:"objectType,omitempty"`
}

func unmarshalBasicRestoreRequest(body []byte) (BasicRestoreRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeAzureFileShareRestoreRequest):
		var afsrr AzureFileShareRestoreRequest
		err := json.Unmarshal(body, &afsrr)
		return afsrr, err
	case string(ObjectTypeAzureWorkloadPointInTimeRestoreRequest):
		var awpitrr AzureWorkloadPointInTimeRestoreRequest
		err := json.Unmarshal(body, &awpitrr)
		return awpitrr, err
	case string(ObjectTypeAzureWorkloadRestoreRequest):
		var awrr AzureWorkloadRestoreRequest
		err := json.Unmarshal(body, &awrr)
		return awrr, err
	case string(ObjectTypeAzureWorkloadSAPHanaPointInTimeRestoreRequest):
		var awshpitrr AzureWorkloadSAPHanaPointInTimeRestoreRequest
		err := json.Unmarshal(body, &awshpitrr)
		return awshpitrr, err
	case string(ObjectTypeAzureWorkloadSAPHanaRestoreRequest):
		var awshrr AzureWorkloadSAPHanaRestoreRequest
		err := json.Unmarshal(body, &awshrr)
		return awshrr, err
	case string(ObjectTypeAzureWorkloadSQLPointInTimeRestoreRequest):
		var awspitrr AzureWorkloadSQLPointInTimeRestoreRequest
		err := json.Unmarshal(body, &awspitrr)
		return awspitrr, err
	case string(ObjectTypeAzureWorkloadSQLRestoreRequest):
		var awsrr AzureWorkloadSQLRestoreRequest
		err := json.Unmarshal(body, &awsrr)
		return awsrr, err
	case string(ObjectTypeIaasVMRestoreRequest):
		var ivrr IaasVMRestoreRequest
		err := json.Unmarshal(body, &ivrr)
		return ivrr, err
	default:
		var rr RestoreRequest
		err := json.Unmarshal(body, &rr)
		return rr, err
	}
}
func unmarshalBasicRestoreRequestArray(body []byte) ([]BasicRestoreRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rrArray := make([]BasicRestoreRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rr, err := unmarshalBasicRestoreRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		rrArray[index] = rr
	}
	return rrArray, nil
}

// MarshalJSON is the custom marshaler for RestoreRequest.
func (rr RestoreRequest) MarshalJSON() ([]byte, error) {
	rr.ObjectType = ObjectTypeRestoreRequest
	objectMap := make(map[string]interface{})
	if rr.ObjectType != "" {
		objectMap["objectType"] = rr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareRestoreRequest is the BasicRestoreRequest implementation for RestoreRequest.
func (rr RestoreRequest) AsAzureFileShareRestoreRequest() (*AzureFileShareRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadPointInTimeRestoreRequest is the BasicRestoreRequest implementation for RestoreRequest.
func (rr RestoreRequest) AsAzureWorkloadPointInTimeRestoreRequest() (*AzureWorkloadPointInTimeRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadRestoreRequest is the BasicRestoreRequest implementation for RestoreRequest.
func (rr RestoreRequest) AsAzureWorkloadRestoreRequest() (*AzureWorkloadRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureWorkloadRestoreRequest is the BasicRestoreRequest implementation for RestoreRequest.
func (rr RestoreRequest) AsBasicAzureWorkloadRestoreRequest() (BasicAzureWorkloadRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSAPHanaPointInTimeRestoreRequest is the BasicRestoreRequest implementation for RestoreRequest.
func (rr RestoreRequest) AsAzureWorkloadSAPHanaPointInTimeRestoreRequest() (*AzureWorkloadSAPHanaPointInTimeRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSAPHanaRestoreRequest is the BasicRestoreRequest implementation for RestoreRequest.
func (rr RestoreRequest) AsAzureWorkloadSAPHanaRestoreRequest() (*AzureWorkloadSAPHanaRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureWorkloadSAPHanaRestoreRequest is the BasicRestoreRequest implementation for RestoreRequest.
func (rr RestoreRequest) AsBasicAzureWorkloadSAPHanaRestoreRequest() (BasicAzureWorkloadSAPHanaRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSQLPointInTimeRestoreRequest is the BasicRestoreRequest implementation for RestoreRequest.
func (rr RestoreRequest) AsAzureWorkloadSQLPointInTimeRestoreRequest() (*AzureWorkloadSQLPointInTimeRestoreRequest, bool) {
	return nil, false
}

// AsAzureWorkloadSQLRestoreRequest is the BasicRestoreRequest implementation for RestoreRequest.
func (rr RestoreRequest) AsAzureWorkloadSQLRestoreRequest() (*AzureWorkloadSQLRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureWorkloadSQLRestoreRequest is the BasicRestoreRequest implementation for RestoreRequest.
func (rr RestoreRequest) AsBasicAzureWorkloadSQLRestoreRequest() (BasicAzureWorkloadSQLRestoreRequest, bool) {
	return nil, false
}

// AsIaasVMRestoreRequest is the BasicRestoreRequest implementation for RestoreRequest.
func (rr RestoreRequest) AsIaasVMRestoreRequest() (*IaasVMRestoreRequest, bool) {
	return nil, false
}

// AsRestoreRequest is the BasicRestoreRequest implementation for RestoreRequest.
func (rr RestoreRequest) AsRestoreRequest() (*RestoreRequest, bool) {
	return &rr, true
}

// AsBasicRestoreRequest is the BasicRestoreRequest implementation for RestoreRequest.
func (rr RestoreRequest) AsBasicRestoreRequest() (BasicRestoreRequest, bool) {
	return &rr, true
}

// RestoreRequestResource base class for restore request. Workload-specific restore requests are derived
// from this class.
type RestoreRequestResource struct {
	// Properties - RestoreRequestResource properties
	Properties BasicRestoreRequest `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for RestoreRequestResource.
func (rrr RestoreRequestResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = rrr.Properties
	if rrr.Location != nil {
		objectMap["location"] = rrr.Location
	}
	if rrr.Tags != nil {
		objectMap["tags"] = rrr.Tags
	}
	if rrr.ETag != nil {
		objectMap["eTag"] = rrr.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestoreRequestResource struct.
func (rrr *RestoreRequestResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicRestoreRequest(*v)
				if err != nil {
					return err
				}
				rrr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rrr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rrr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rrr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rrr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rrr.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				rrr.ETag = &eTag
			}
		}
	}

	return nil
}

// RetentionDuration retention duration.
type RetentionDuration struct {
	// Count - Count of duration types. Retention duration is obtained by the counting the duration type Count times.
	// For example, when Count = 3 and DurationType = Weeks, retention duration will be three weeks.
	Count *int32 `json:"count,omitempty"`
	// DurationType - Retention duration type of retention policy. Possible values include: 'RetentionDurationTypeInvalid', 'RetentionDurationTypeDays', 'RetentionDurationTypeWeeks', 'RetentionDurationTypeMonths', 'RetentionDurationTypeYears'
	DurationType RetentionDurationType `json:"durationType,omitempty"`
}

// BasicRetentionPolicy base class for retention policy.
type BasicRetentionPolicy interface {
	AsLongTermRetentionPolicy() (*LongTermRetentionPolicy, bool)
	AsSimpleRetentionPolicy() (*SimpleRetentionPolicy, bool)
	AsRetentionPolicy() (*RetentionPolicy, bool)
}

// RetentionPolicy base class for retention policy.
type RetentionPolicy struct {
	// RetentionPolicyType - Possible values include: 'RetentionPolicyTypeRetentionPolicy', 'RetentionPolicyTypeLongTermRetentionPolicy', 'RetentionPolicyTypeSimpleRetentionPolicy'
	RetentionPolicyType RetentionPolicyType `json:"retentionPolicyType,omitempty"`
}

func unmarshalBasicRetentionPolicy(body []byte) (BasicRetentionPolicy, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["retentionPolicyType"] {
	case string(RetentionPolicyTypeLongTermRetentionPolicy):
		var ltrp LongTermRetentionPolicy
		err := json.Unmarshal(body, &ltrp)
		return ltrp, err
	case string(RetentionPolicyTypeSimpleRetentionPolicy):
		var srp SimpleRetentionPolicy
		err := json.Unmarshal(body, &srp)
		return srp, err
	default:
		var rp RetentionPolicy
		err := json.Unmarshal(body, &rp)
		return rp, err
	}
}
func unmarshalBasicRetentionPolicyArray(body []byte) ([]BasicRetentionPolicy, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rpArray := make([]BasicRetentionPolicy, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rp, err := unmarshalBasicRetentionPolicy(*rawMessage)
		if err != nil {
			return nil, err
		}
		rpArray[index] = rp
	}
	return rpArray, nil
}

// MarshalJSON is the custom marshaler for RetentionPolicy.
func (rp RetentionPolicy) MarshalJSON() ([]byte, error) {
	rp.RetentionPolicyType = RetentionPolicyTypeRetentionPolicy
	objectMap := make(map[string]interface{})
	if rp.RetentionPolicyType != "" {
		objectMap["retentionPolicyType"] = rp.RetentionPolicyType
	}
	return json.Marshal(objectMap)
}

// AsLongTermRetentionPolicy is the BasicRetentionPolicy implementation for RetentionPolicy.
func (rp RetentionPolicy) AsLongTermRetentionPolicy() (*LongTermRetentionPolicy, bool) {
	return nil, false
}

// AsSimpleRetentionPolicy is the BasicRetentionPolicy implementation for RetentionPolicy.
func (rp RetentionPolicy) AsSimpleRetentionPolicy() (*SimpleRetentionPolicy, bool) {
	return nil, false
}

// AsRetentionPolicy is the BasicRetentionPolicy implementation for RetentionPolicy.
func (rp RetentionPolicy) AsRetentionPolicy() (*RetentionPolicy, bool) {
	return &rp, true
}

// AsBasicRetentionPolicy is the BasicRetentionPolicy implementation for RetentionPolicy.
func (rp RetentionPolicy) AsBasicRetentionPolicy() (BasicRetentionPolicy, bool) {
	return &rp, true
}

// BasicSchedulePolicy base class for backup schedule.
type BasicSchedulePolicy interface {
	AsLogSchedulePolicy() (*LogSchedulePolicy, bool)
	AsLongTermSchedulePolicy() (*LongTermSchedulePolicy, bool)
	AsSimpleSchedulePolicy() (*SimpleSchedulePolicy, bool)
	AsSchedulePolicy() (*SchedulePolicy, bool)
}

// SchedulePolicy base class for backup schedule.
type SchedulePolicy struct {
	// SchedulePolicyType - Possible values include: 'SchedulePolicyTypeSchedulePolicy', 'SchedulePolicyTypeLogSchedulePolicy', 'SchedulePolicyTypeLongTermSchedulePolicy', 'SchedulePolicyTypeSimpleSchedulePolicy'
	SchedulePolicyType SchedulePolicyType `json:"schedulePolicyType,omitempty"`
}

func unmarshalBasicSchedulePolicy(body []byte) (BasicSchedulePolicy, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["schedulePolicyType"] {
	case string(SchedulePolicyTypeLogSchedulePolicy):
		var lsp LogSchedulePolicy
		err := json.Unmarshal(body, &lsp)
		return lsp, err
	case string(SchedulePolicyTypeLongTermSchedulePolicy):
		var ltsp LongTermSchedulePolicy
		err := json.Unmarshal(body, &ltsp)
		return ltsp, err
	case string(SchedulePolicyTypeSimpleSchedulePolicy):
		var ssp SimpleSchedulePolicy
		err := json.Unmarshal(body, &ssp)
		return ssp, err
	default:
		var sp SchedulePolicy
		err := json.Unmarshal(body, &sp)
		return sp, err
	}
}
func unmarshalBasicSchedulePolicyArray(body []byte) ([]BasicSchedulePolicy, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	spArray := make([]BasicSchedulePolicy, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sp, err := unmarshalBasicSchedulePolicy(*rawMessage)
		if err != nil {
			return nil, err
		}
		spArray[index] = sp
	}
	return spArray, nil
}

// MarshalJSON is the custom marshaler for SchedulePolicy.
func (sp SchedulePolicy) MarshalJSON() ([]byte, error) {
	sp.SchedulePolicyType = SchedulePolicyTypeSchedulePolicy
	objectMap := make(map[string]interface{})
	if sp.SchedulePolicyType != "" {
		objectMap["schedulePolicyType"] = sp.SchedulePolicyType
	}
	return json.Marshal(objectMap)
}

// AsLogSchedulePolicy is the BasicSchedulePolicy implementation for SchedulePolicy.
func (sp SchedulePolicy) AsLogSchedulePolicy() (*LogSchedulePolicy, bool) {
	return nil, false
}

// AsLongTermSchedulePolicy is the BasicSchedulePolicy implementation for SchedulePolicy.
func (sp SchedulePolicy) AsLongTermSchedulePolicy() (*LongTermSchedulePolicy, bool) {
	return nil, false
}

// AsSimpleSchedulePolicy is the BasicSchedulePolicy implementation for SchedulePolicy.
func (sp SchedulePolicy) AsSimpleSchedulePolicy() (*SimpleSchedulePolicy, bool) {
	return nil, false
}

// AsSchedulePolicy is the BasicSchedulePolicy implementation for SchedulePolicy.
func (sp SchedulePolicy) AsSchedulePolicy() (*SchedulePolicy, bool) {
	return &sp, true
}

// AsBasicSchedulePolicy is the BasicSchedulePolicy implementation for SchedulePolicy.
func (sp SchedulePolicy) AsBasicSchedulePolicy() (BasicSchedulePolicy, bool) {
	return &sp, true
}

// Settings common settings field for backup management
type Settings struct {
	// TimeZone - TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
	TimeZone *string `json:"timeZone,omitempty"`
	// Issqlcompression - SQL compression flag
	Issqlcompression *bool `json:"issqlcompression,omitempty"`
	// IsCompression - Workload compression flag. This has been added so that 'isSqlCompression'
	// will be deprecated once clients upgrade to consider this flag.
	IsCompression *bool `json:"isCompression,omitempty"`
}

// SimpleRetentionPolicy simple policy retention.
type SimpleRetentionPolicy struct {
	// RetentionDuration - Retention duration of the protection policy.
	RetentionDuration *RetentionDuration `json:"retentionDuration,omitempty"`
	// RetentionPolicyType - Possible values include: 'RetentionPolicyTypeRetentionPolicy', 'RetentionPolicyTypeLongTermRetentionPolicy', 'RetentionPolicyTypeSimpleRetentionPolicy'
	RetentionPolicyType RetentionPolicyType `json:"retentionPolicyType,omitempty"`
}

// MarshalJSON is the custom marshaler for SimpleRetentionPolicy.
func (srp SimpleRetentionPolicy) MarshalJSON() ([]byte, error) {
	srp.RetentionPolicyType = RetentionPolicyTypeSimpleRetentionPolicy
	objectMap := make(map[string]interface{})
	if srp.RetentionDuration != nil {
		objectMap["retentionDuration"] = srp.RetentionDuration
	}
	if srp.RetentionPolicyType != "" {
		objectMap["retentionPolicyType"] = srp.RetentionPolicyType
	}
	return json.Marshal(objectMap)
}

// AsLongTermRetentionPolicy is the BasicRetentionPolicy implementation for SimpleRetentionPolicy.
func (srp SimpleRetentionPolicy) AsLongTermRetentionPolicy() (*LongTermRetentionPolicy, bool) {
	return nil, false
}

// AsSimpleRetentionPolicy is the BasicRetentionPolicy implementation for SimpleRetentionPolicy.
func (srp SimpleRetentionPolicy) AsSimpleRetentionPolicy() (*SimpleRetentionPolicy, bool) {
	return &srp, true
}

// AsRetentionPolicy is the BasicRetentionPolicy implementation for SimpleRetentionPolicy.
func (srp SimpleRetentionPolicy) AsRetentionPolicy() (*RetentionPolicy, bool) {
	return nil, false
}

// AsBasicRetentionPolicy is the BasicRetentionPolicy implementation for SimpleRetentionPolicy.
func (srp SimpleRetentionPolicy) AsBasicRetentionPolicy() (BasicRetentionPolicy, bool) {
	return &srp, true
}

// SimpleSchedulePolicy simple policy schedule.
type SimpleSchedulePolicy struct {
	// ScheduleRunFrequency - Frequency of the schedule operation of this policy. Possible values include: 'ScheduleRunTypeInvalid', 'ScheduleRunTypeDaily', 'ScheduleRunTypeWeekly'
	ScheduleRunFrequency ScheduleRunType `json:"scheduleRunFrequency,omitempty"`
	// ScheduleRunDays - List of days of week this schedule has to be run.
	ScheduleRunDays *[]DayOfWeek `json:"scheduleRunDays,omitempty"`
	// ScheduleRunTimes - List of times of day this schedule has to be run.
	ScheduleRunTimes *[]date.Time `json:"scheduleRunTimes,omitempty"`
	// ScheduleWeeklyFrequency - At every number weeks this schedule has to be run.
	ScheduleWeeklyFrequency *int32 `json:"scheduleWeeklyFrequency,omitempty"`
	// SchedulePolicyType - Possible values include: 'SchedulePolicyTypeSchedulePolicy', 'SchedulePolicyTypeLogSchedulePolicy', 'SchedulePolicyTypeLongTermSchedulePolicy', 'SchedulePolicyTypeSimpleSchedulePolicy'
	SchedulePolicyType SchedulePolicyType `json:"schedulePolicyType,omitempty"`
}

// MarshalJSON is the custom marshaler for SimpleSchedulePolicy.
func (ssp SimpleSchedulePolicy) MarshalJSON() ([]byte, error) {
	ssp.SchedulePolicyType = SchedulePolicyTypeSimpleSchedulePolicy
	objectMap := make(map[string]interface{})
	if ssp.ScheduleRunFrequency != "" {
		objectMap["scheduleRunFrequency"] = ssp.ScheduleRunFrequency
	}
	if ssp.ScheduleRunDays != nil {
		objectMap["scheduleRunDays"] = ssp.ScheduleRunDays
	}
	if ssp.ScheduleRunTimes != nil {
		objectMap["scheduleRunTimes"] = ssp.ScheduleRunTimes
	}
	if ssp.ScheduleWeeklyFrequency != nil {
		objectMap["scheduleWeeklyFrequency"] = ssp.ScheduleWeeklyFrequency
	}
	if ssp.SchedulePolicyType != "" {
		objectMap["schedulePolicyType"] = ssp.SchedulePolicyType
	}
	return json.Marshal(objectMap)
}

// AsLogSchedulePolicy is the BasicSchedulePolicy implementation for SimpleSchedulePolicy.
func (ssp SimpleSchedulePolicy) AsLogSchedulePolicy() (*LogSchedulePolicy, bool) {
	return nil, false
}

// AsLongTermSchedulePolicy is the BasicSchedulePolicy implementation for SimpleSchedulePolicy.
func (ssp SimpleSchedulePolicy) AsLongTermSchedulePolicy() (*LongTermSchedulePolicy, bool) {
	return nil, false
}

// AsSimpleSchedulePolicy is the BasicSchedulePolicy implementation for SimpleSchedulePolicy.
func (ssp SimpleSchedulePolicy) AsSimpleSchedulePolicy() (*SimpleSchedulePolicy, bool) {
	return &ssp, true
}

// AsSchedulePolicy is the BasicSchedulePolicy implementation for SimpleSchedulePolicy.
func (ssp SimpleSchedulePolicy) AsSchedulePolicy() (*SchedulePolicy, bool) {
	return nil, false
}

// AsBasicSchedulePolicy is the BasicSchedulePolicy implementation for SimpleSchedulePolicy.
func (ssp SimpleSchedulePolicy) AsBasicSchedulePolicy() (BasicSchedulePolicy, bool) {
	return &ssp, true
}

// SQLDataDirectory sQLDataDirectory info
type SQLDataDirectory struct {
	// Type - Type of data directory mapping. Possible values include: 'SQLDataDirectoryTypeInvalid', 'SQLDataDirectoryTypeData', 'SQLDataDirectoryTypeLog'
	Type SQLDataDirectoryType `json:"type,omitempty"`
	// Path - File path
	Path *string `json:"path,omitempty"`
	// LogicalName - Logical name of the file
	LogicalName *string `json:"logicalName,omitempty"`
}

// SQLDataDirectoryMapping encapsulates information regarding data directory
type SQLDataDirectoryMapping struct {
	// MappingType - Type of data directory mapping. Possible values include: 'SQLDataDirectoryTypeInvalid', 'SQLDataDirectoryTypeData', 'SQLDataDirectoryTypeLog'
	MappingType SQLDataDirectoryType `json:"mappingType,omitempty"`
	// SourceLogicalName - Restore source logical name path
	SourceLogicalName *string `json:"sourceLogicalName,omitempty"`
	// SourcePath - Restore source path
	SourcePath *string `json:"sourcePath,omitempty"`
	// TargetPath - Target path
	TargetPath *string `json:"targetPath,omitempty"`
}

// StatusRequest backupStatus request.
type StatusRequest struct {
	// ResourceType - Container Type - VM, SQLPaaS, DPM, AzureFileShare. Possible values include: 'DataSourceTypeInvalid', 'DataSourceTypeVM', 'DataSourceTypeFileFolder', 'DataSourceTypeAzureSQLDb', 'DataSourceTypeSQLDB', 'DataSourceTypeExchange', 'DataSourceTypeSharepoint', 'DataSourceTypeVMwareVM', 'DataSourceTypeSystemState', 'DataSourceTypeClient', 'DataSourceTypeGenericDataSource', 'DataSourceTypeSQLDataBase', 'DataSourceTypeAzureFileShare', 'DataSourceTypeSAPHanaDatabase', 'DataSourceTypeSAPAseDatabase'
	ResourceType DataSourceType `json:"resourceType,omitempty"`
	// ResourceID - Entire ARM resource id of the resource
	ResourceID *string `json:"resourceId,omitempty"`
	// PoLogicalName - Protectable Item Logical Name
	PoLogicalName *string `json:"poLogicalName,omitempty"`
}

// StatusResponse backupStatus response.
type StatusResponse struct {
	autorest.Response `json:"-"`
	// ProtectionStatus - Specifies whether the container is registered or not. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionStatus ProtectionStatus `json:"protectionStatus,omitempty"`
	// VaultID - Specifies the arm resource id of the vault
	VaultID *string `json:"vaultId,omitempty"`
	// FabricName - Specifies the fabric name - Azure or AD. Possible values include: 'FabricNameInvalid', 'FabricNameAzure'
	FabricName FabricName `json:"fabricName,omitempty"`
	// ContainerName - Specifies the product specific container name. E.g. iaasvmcontainer;iaasvmcontainer;csname;vmname.
	ContainerName *string `json:"containerName,omitempty"`
	// ProtectedItemName - Specifies the product specific ds name. E.g. vm;iaasvmcontainer;csname;vmname.
	ProtectedItemName *string `json:"protectedItemName,omitempty"`
	// ErrorCode - ErrorCode in case of intent failed
	ErrorCode *string `json:"errorCode,omitempty"`
	// ErrorMessage - ErrorMessage in case of intent failed.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// PolicyName - Specifies the policy name which is used for protection
	PolicyName *string `json:"policyName,omitempty"`
	// RegistrationStatus - Container registration status
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
}

// SubProtectionPolicy sub-protection policy which includes schedule and retention
type SubProtectionPolicy struct {
	// PolicyType - Type of backup policy type. Possible values include: 'PolicyTypeInvalid', 'PolicyTypeFull', 'PolicyTypeDifferential', 'PolicyTypeLog', 'PolicyTypeCopyOnlyFull'
	PolicyType PolicyType `json:"policyType,omitempty"`
	// SchedulePolicy - Backup schedule specified as part of backup policy.
	SchedulePolicy BasicSchedulePolicy `json:"schedulePolicy,omitempty"`
	// RetentionPolicy - Retention policy with the details on backup copy retention ranges.
	RetentionPolicy BasicRetentionPolicy `json:"retentionPolicy,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for SubProtectionPolicy struct.
func (spp *SubProtectionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "policyType":
			if v != nil {
				var policyType PolicyType
				err = json.Unmarshal(*v, &policyType)
				if err != nil {
					return err
				}
				spp.PolicyType = policyType
			}
		case "schedulePolicy":
			if v != nil {
				schedulePolicy, err := unmarshalBasicSchedulePolicy(*v)
				if err != nil {
					return err
				}
				spp.SchedulePolicy = schedulePolicy
			}
		case "retentionPolicy":
			if v != nil {
				retentionPolicy, err := unmarshalBasicRetentionPolicy(*v)
				if err != nil {
					return err
				}
				spp.RetentionPolicy = retentionPolicy
			}
		}
	}

	return nil
}

// TargetAFSRestoreInfo target Azure File Share Info.
type TargetAFSRestoreInfo struct {
	// Name - File share name
	Name *string `json:"name,omitempty"`
	// TargetResourceID - Target file share resource ARM ID
	TargetResourceID *string `json:"targetResourceId,omitempty"`
}

// TargetRestoreInfo details about target workload during restore operation.
type TargetRestoreInfo struct {
	// OverwriteOption - Can Overwrite if Target DataBase already exists. Possible values include: 'OverwriteOptionsInvalid', 'OverwriteOptionsFailOnConflict', 'OverwriteOptionsOverwrite'
	OverwriteOption OverwriteOptions `json:"overwriteOption,omitempty"`
	// ContainerID - Resource Id name of the container in which Target DataBase resides
	ContainerID *string `json:"containerId,omitempty"`
	// DatabaseName - Database name InstanceName/DataBaseName for SQL or System/DbName for SAP Hana
	DatabaseName *string `json:"databaseName,omitempty"`
	// TargetDirectoryForFileRestore - Target directory location for restore as files.
	TargetDirectoryForFileRestore *string `json:"targetDirectoryForFileRestore,omitempty"`
}

// TokenInformation the token information details.
type TokenInformation struct {
	autorest.Response `json:"-"`
	// Token - Token value.
	Token *string `json:"token,omitempty"`
	// ExpiryTimeInUtcTicks - Expiry time of token.
	ExpiryTimeInUtcTicks *int64 `json:"expiryTimeInUtcTicks,omitempty"`
	// SecurityPIN - Security PIN
	SecurityPIN *string `json:"securityPIN,omitempty"`
}

// ValidateIaasVMRestoreOperationRequest azureRestoreValidation request.
type ValidateIaasVMRestoreOperationRequest struct {
	// RestoreRequest - Sets restore request to be validated
	RestoreRequest BasicRestoreRequest `json:"restoreRequest,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeValidateOperationRequest', 'ObjectTypeValidateIaasVMRestoreOperationRequest', 'ObjectTypeValidateRestoreOperationRequest'
	ObjectType ObjectTypeBasicValidateOperationRequest `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for ValidateIaasVMRestoreOperationRequest.
func (vivror ValidateIaasVMRestoreOperationRequest) MarshalJSON() ([]byte, error) {
	vivror.ObjectType = ObjectTypeValidateIaasVMRestoreOperationRequest
	objectMap := make(map[string]interface{})
	objectMap["restoreRequest"] = vivror.RestoreRequest
	if vivror.ObjectType != "" {
		objectMap["objectType"] = vivror.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsValidateIaasVMRestoreOperationRequest is the BasicValidateOperationRequest implementation for ValidateIaasVMRestoreOperationRequest.
func (vivror ValidateIaasVMRestoreOperationRequest) AsValidateIaasVMRestoreOperationRequest() (*ValidateIaasVMRestoreOperationRequest, bool) {
	return &vivror, true
}

// AsValidateRestoreOperationRequest is the BasicValidateOperationRequest implementation for ValidateIaasVMRestoreOperationRequest.
func (vivror ValidateIaasVMRestoreOperationRequest) AsValidateRestoreOperationRequest() (*ValidateRestoreOperationRequest, bool) {
	return nil, false
}

// AsBasicValidateRestoreOperationRequest is the BasicValidateOperationRequest implementation for ValidateIaasVMRestoreOperationRequest.
func (vivror ValidateIaasVMRestoreOperationRequest) AsBasicValidateRestoreOperationRequest() (BasicValidateRestoreOperationRequest, bool) {
	return &vivror, true
}

// AsValidateOperationRequest is the BasicValidateOperationRequest implementation for ValidateIaasVMRestoreOperationRequest.
func (vivror ValidateIaasVMRestoreOperationRequest) AsValidateOperationRequest() (*ValidateOperationRequest, bool) {
	return nil, false
}

// AsBasicValidateOperationRequest is the BasicValidateOperationRequest implementation for ValidateIaasVMRestoreOperationRequest.
func (vivror ValidateIaasVMRestoreOperationRequest) AsBasicValidateOperationRequest() (BasicValidateOperationRequest, bool) {
	return &vivror, true
}

// UnmarshalJSON is the custom unmarshaler for ValidateIaasVMRestoreOperationRequest struct.
func (vivror *ValidateIaasVMRestoreOperationRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "restoreRequest":
			if v != nil {
				restoreRequest, err := unmarshalBasicRestoreRequest(*v)
				if err != nil {
					return err
				}
				vivror.RestoreRequest = restoreRequest
			}
		case "objectType":
			if v != nil {
				var objectType ObjectTypeBasicValidateOperationRequest
				err = json.Unmarshal(*v, &objectType)
				if err != nil {
					return err
				}
				vivror.ObjectType = objectType
			}
		}
	}

	return nil
}

// BasicValidateOperationRequest base class for validate operation request.
type BasicValidateOperationRequest interface {
	AsValidateIaasVMRestoreOperationRequest() (*ValidateIaasVMRestoreOperationRequest, bool)
	AsValidateRestoreOperationRequest() (*ValidateRestoreOperationRequest, bool)
	AsBasicValidateRestoreOperationRequest() (BasicValidateRestoreOperationRequest, bool)
	AsValidateOperationRequest() (*ValidateOperationRequest, bool)
}

// ValidateOperationRequest base class for validate operation request.
type ValidateOperationRequest struct {
	// ObjectType - Possible values include: 'ObjectTypeValidateOperationRequest', 'ObjectTypeValidateIaasVMRestoreOperationRequest', 'ObjectTypeValidateRestoreOperationRequest'
	ObjectType ObjectTypeBasicValidateOperationRequest `json:"objectType,omitempty"`
}

func unmarshalBasicValidateOperationRequest(body []byte) (BasicValidateOperationRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeValidateIaasVMRestoreOperationRequest):
		var vivror ValidateIaasVMRestoreOperationRequest
		err := json.Unmarshal(body, &vivror)
		return vivror, err
	case string(ObjectTypeValidateRestoreOperationRequest):
		var vror ValidateRestoreOperationRequest
		err := json.Unmarshal(body, &vror)
		return vror, err
	default:
		var vor ValidateOperationRequest
		err := json.Unmarshal(body, &vor)
		return vor, err
	}
}
func unmarshalBasicValidateOperationRequestArray(body []byte) ([]BasicValidateOperationRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	vorArray := make([]BasicValidateOperationRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		vor, err := unmarshalBasicValidateOperationRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		vorArray[index] = vor
	}
	return vorArray, nil
}

// MarshalJSON is the custom marshaler for ValidateOperationRequest.
func (vor ValidateOperationRequest) MarshalJSON() ([]byte, error) {
	vor.ObjectType = ObjectTypeValidateOperationRequest
	objectMap := make(map[string]interface{})
	if vor.ObjectType != "" {
		objectMap["objectType"] = vor.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsValidateIaasVMRestoreOperationRequest is the BasicValidateOperationRequest implementation for ValidateOperationRequest.
func (vor ValidateOperationRequest) AsValidateIaasVMRestoreOperationRequest() (*ValidateIaasVMRestoreOperationRequest, bool) {
	return nil, false
}

// AsValidateRestoreOperationRequest is the BasicValidateOperationRequest implementation for ValidateOperationRequest.
func (vor ValidateOperationRequest) AsValidateRestoreOperationRequest() (*ValidateRestoreOperationRequest, bool) {
	return nil, false
}

// AsBasicValidateRestoreOperationRequest is the BasicValidateOperationRequest implementation for ValidateOperationRequest.
func (vor ValidateOperationRequest) AsBasicValidateRestoreOperationRequest() (BasicValidateRestoreOperationRequest, bool) {
	return nil, false
}

// AsValidateOperationRequest is the BasicValidateOperationRequest implementation for ValidateOperationRequest.
func (vor ValidateOperationRequest) AsValidateOperationRequest() (*ValidateOperationRequest, bool) {
	return &vor, true
}

// AsBasicValidateOperationRequest is the BasicValidateOperationRequest implementation for ValidateOperationRequest.
func (vor ValidateOperationRequest) AsBasicValidateOperationRequest() (BasicValidateOperationRequest, bool) {
	return &vor, true
}

// ValidateOperationResponse base class for validate operation response.
type ValidateOperationResponse struct {
	// ValidationResults - Gets the validation result
	ValidationResults *[]ErrorDetail `json:"validationResults,omitempty"`
}

// ValidateOperationsResponse ...
type ValidateOperationsResponse struct {
	autorest.Response         `json:"-"`
	ValidateOperationResponse *ValidateOperationResponse `json:"validateOperationResponse,omitempty"`
}

// BasicValidateRestoreOperationRequest azureRestoreValidation request.
type BasicValidateRestoreOperationRequest interface {
	AsValidateIaasVMRestoreOperationRequest() (*ValidateIaasVMRestoreOperationRequest, bool)
	AsValidateRestoreOperationRequest() (*ValidateRestoreOperationRequest, bool)
}

// ValidateRestoreOperationRequest azureRestoreValidation request.
type ValidateRestoreOperationRequest struct {
	// RestoreRequest - Sets restore request to be validated
	RestoreRequest BasicRestoreRequest `json:"restoreRequest,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeValidateOperationRequest', 'ObjectTypeValidateIaasVMRestoreOperationRequest', 'ObjectTypeValidateRestoreOperationRequest'
	ObjectType ObjectTypeBasicValidateOperationRequest `json:"objectType,omitempty"`
}

func unmarshalBasicValidateRestoreOperationRequest(body []byte) (BasicValidateRestoreOperationRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeValidateIaasVMRestoreOperationRequest):
		var vivror ValidateIaasVMRestoreOperationRequest
		err := json.Unmarshal(body, &vivror)
		return vivror, err
	default:
		var vror ValidateRestoreOperationRequest
		err := json.Unmarshal(body, &vror)
		return vror, err
	}
}
func unmarshalBasicValidateRestoreOperationRequestArray(body []byte) ([]BasicValidateRestoreOperationRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	vrorArray := make([]BasicValidateRestoreOperationRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		vror, err := unmarshalBasicValidateRestoreOperationRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		vrorArray[index] = vror
	}
	return vrorArray, nil
}

// MarshalJSON is the custom marshaler for ValidateRestoreOperationRequest.
func (vror ValidateRestoreOperationRequest) MarshalJSON() ([]byte, error) {
	vror.ObjectType = ObjectTypeValidateRestoreOperationRequest
	objectMap := make(map[string]interface{})
	objectMap["restoreRequest"] = vror.RestoreRequest
	if vror.ObjectType != "" {
		objectMap["objectType"] = vror.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsValidateIaasVMRestoreOperationRequest is the BasicValidateOperationRequest implementation for ValidateRestoreOperationRequest.
func (vror ValidateRestoreOperationRequest) AsValidateIaasVMRestoreOperationRequest() (*ValidateIaasVMRestoreOperationRequest, bool) {
	return nil, false
}

// AsValidateRestoreOperationRequest is the BasicValidateOperationRequest implementation for ValidateRestoreOperationRequest.
func (vror ValidateRestoreOperationRequest) AsValidateRestoreOperationRequest() (*ValidateRestoreOperationRequest, bool) {
	return &vror, true
}

// AsBasicValidateRestoreOperationRequest is the BasicValidateOperationRequest implementation for ValidateRestoreOperationRequest.
func (vror ValidateRestoreOperationRequest) AsBasicValidateRestoreOperationRequest() (BasicValidateRestoreOperationRequest, bool) {
	return &vror, true
}

// AsValidateOperationRequest is the BasicValidateOperationRequest implementation for ValidateRestoreOperationRequest.
func (vror ValidateRestoreOperationRequest) AsValidateOperationRequest() (*ValidateOperationRequest, bool) {
	return nil, false
}

// AsBasicValidateOperationRequest is the BasicValidateOperationRequest implementation for ValidateRestoreOperationRequest.
func (vror ValidateRestoreOperationRequest) AsBasicValidateOperationRequest() (BasicValidateOperationRequest, bool) {
	return &vror, true
}

// UnmarshalJSON is the custom unmarshaler for ValidateRestoreOperationRequest struct.
func (vror *ValidateRestoreOperationRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "restoreRequest":
			if v != nil {
				restoreRequest, err := unmarshalBasicRestoreRequest(*v)
				if err != nil {
					return err
				}
				vror.RestoreRequest = restoreRequest
			}
		case "objectType":
			if v != nil {
				var objectType ObjectTypeBasicValidateOperationRequest
				err = json.Unmarshal(*v, &objectType)
				if err != nil {
					return err
				}
				vror.ObjectType = objectType
			}
		}
	}

	return nil
}

// WeeklyRetentionFormat weekly retention format.
type WeeklyRetentionFormat struct {
	// DaysOfTheWeek - List of days of the week.
	DaysOfTheWeek *[]DayOfWeek `json:"daysOfTheWeek,omitempty"`
	// WeeksOfTheMonth - List of weeks of month.
	WeeksOfTheMonth *[]WeekOfMonth `json:"weeksOfTheMonth,omitempty"`
}

// WeeklyRetentionSchedule weekly retention schedule.
type WeeklyRetentionSchedule struct {
	// DaysOfTheWeek - List of days of week for weekly retention policy.
	DaysOfTheWeek *[]DayOfWeek `json:"daysOfTheWeek,omitempty"`
	// RetentionTimes - Retention times of retention policy.
	RetentionTimes *[]date.Time `json:"retentionTimes,omitempty"`
	// RetentionDuration - Retention duration of retention Policy.
	RetentionDuration *RetentionDuration `json:"retentionDuration,omitempty"`
}

// WorkloadInquiryDetails details of an inquired protectable item.
type WorkloadInquiryDetails struct {
	// Type - Type of the Workload such as SQL, Oracle etc.
	Type *string `json:"type,omitempty"`
	// ItemCount - Contains the protectable item Count inside this Container.
	ItemCount *int64 `json:"itemCount,omitempty"`
	// InquiryValidation - Inquiry validation such as permissions and other backup validations.
	InquiryValidation *InquiryValidation `json:"inquiryValidation,omitempty"`
}

// BasicWorkloadItem base class for backup item. Workload-specific backup items are derived from this class.
type BasicWorkloadItem interface {
	AsAzureVMWorkloadItem() (*AzureVMWorkloadItem, bool)
	AsBasicAzureVMWorkloadItem() (BasicAzureVMWorkloadItem, bool)
	AsAzureVMWorkloadSAPAseDatabaseWorkloadItem() (*AzureVMWorkloadSAPAseDatabaseWorkloadItem, bool)
	AsAzureVMWorkloadSAPAseSystemWorkloadItem() (*AzureVMWorkloadSAPAseSystemWorkloadItem, bool)
	AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem() (*AzureVMWorkloadSAPHanaDatabaseWorkloadItem, bool)
	AsAzureVMWorkloadSAPHanaSystemWorkloadItem() (*AzureVMWorkloadSAPHanaSystemWorkloadItem, bool)
	AsAzureVMWorkloadSQLDatabaseWorkloadItem() (*AzureVMWorkloadSQLDatabaseWorkloadItem, bool)
	AsAzureVMWorkloadSQLInstanceWorkloadItem() (*AzureVMWorkloadSQLInstanceWorkloadItem, bool)
	AsWorkloadItem() (*WorkloadItem, bool)
}

// WorkloadItem base class for backup item. Workload-specific backup items are derived from this class.
type WorkloadItem struct {
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// WorkloadItemType - Possible values include: 'WorkloadItemTypeWorkloadItem', 'WorkloadItemTypeAzureVMWorkloadItem', 'WorkloadItemTypeSAPAseDatabase1', 'WorkloadItemTypeSAPAseSystem1', 'WorkloadItemTypeSAPHanaDatabase1', 'WorkloadItemTypeSAPHanaSystem1', 'WorkloadItemTypeSQLDataBase1', 'WorkloadItemTypeSQLInstance1'
	WorkloadItemType WorkloadItemTypeBasicWorkloadItem `json:"workloadItemType,omitempty"`
}

func unmarshalBasicWorkloadItem(body []byte) (BasicWorkloadItem, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["workloadItemType"] {
	case string(WorkloadItemTypeAzureVMWorkloadItem):
		var avwi AzureVMWorkloadItem
		err := json.Unmarshal(body, &avwi)
		return avwi, err
	case string(WorkloadItemTypeSAPAseDatabase1):
		var avwsadwi AzureVMWorkloadSAPAseDatabaseWorkloadItem
		err := json.Unmarshal(body, &avwsadwi)
		return avwsadwi, err
	case string(WorkloadItemTypeSAPAseSystem1):
		var avwsaswi AzureVMWorkloadSAPAseSystemWorkloadItem
		err := json.Unmarshal(body, &avwsaswi)
		return avwsaswi, err
	case string(WorkloadItemTypeSAPHanaDatabase1):
		var avwshdwi AzureVMWorkloadSAPHanaDatabaseWorkloadItem
		err := json.Unmarshal(body, &avwshdwi)
		return avwshdwi, err
	case string(WorkloadItemTypeSAPHanaSystem1):
		var avwshswi AzureVMWorkloadSAPHanaSystemWorkloadItem
		err := json.Unmarshal(body, &avwshswi)
		return avwshswi, err
	case string(WorkloadItemTypeSQLDataBase1):
		var avwsdwi AzureVMWorkloadSQLDatabaseWorkloadItem
		err := json.Unmarshal(body, &avwsdwi)
		return avwsdwi, err
	case string(WorkloadItemTypeSQLInstance1):
		var avwsiwi AzureVMWorkloadSQLInstanceWorkloadItem
		err := json.Unmarshal(body, &avwsiwi)
		return avwsiwi, err
	default:
		var wi WorkloadItem
		err := json.Unmarshal(body, &wi)
		return wi, err
	}
}
func unmarshalBasicWorkloadItemArray(body []byte) ([]BasicWorkloadItem, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	wiArray := make([]BasicWorkloadItem, len(rawMessages))

	for index, rawMessage := range rawMessages {
		wi, err := unmarshalBasicWorkloadItem(*rawMessage)
		if err != nil {
			return nil, err
		}
		wiArray[index] = wi
	}
	return wiArray, nil
}

// MarshalJSON is the custom marshaler for WorkloadItem.
func (wi WorkloadItem) MarshalJSON() ([]byte, error) {
	wi.WorkloadItemType = WorkloadItemTypeWorkloadItem
	objectMap := make(map[string]interface{})
	if wi.BackupManagementType != nil {
		objectMap["backupManagementType"] = wi.BackupManagementType
	}
	if wi.WorkloadType != nil {
		objectMap["workloadType"] = wi.WorkloadType
	}
	if wi.FriendlyName != nil {
		objectMap["friendlyName"] = wi.FriendlyName
	}
	if wi.ProtectionState != "" {
		objectMap["protectionState"] = wi.ProtectionState
	}
	if wi.WorkloadItemType != "" {
		objectMap["workloadItemType"] = wi.WorkloadItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureVMWorkloadItem is the BasicWorkloadItem implementation for WorkloadItem.
func (wi WorkloadItem) AsAzureVMWorkloadItem() (*AzureVMWorkloadItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadItem is the BasicWorkloadItem implementation for WorkloadItem.
func (wi WorkloadItem) AsBasicAzureVMWorkloadItem() (BasicAzureVMWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseDatabaseWorkloadItem is the BasicWorkloadItem implementation for WorkloadItem.
func (wi WorkloadItem) AsAzureVMWorkloadSAPAseDatabaseWorkloadItem() (*AzureVMWorkloadSAPAseDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseSystemWorkloadItem is the BasicWorkloadItem implementation for WorkloadItem.
func (wi WorkloadItem) AsAzureVMWorkloadSAPAseSystemWorkloadItem() (*AzureVMWorkloadSAPAseSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem is the BasicWorkloadItem implementation for WorkloadItem.
func (wi WorkloadItem) AsAzureVMWorkloadSAPHanaDatabaseWorkloadItem() (*AzureVMWorkloadSAPHanaDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemWorkloadItem is the BasicWorkloadItem implementation for WorkloadItem.
func (wi WorkloadItem) AsAzureVMWorkloadSAPHanaSystemWorkloadItem() (*AzureVMWorkloadSAPHanaSystemWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseWorkloadItem is the BasicWorkloadItem implementation for WorkloadItem.
func (wi WorkloadItem) AsAzureVMWorkloadSQLDatabaseWorkloadItem() (*AzureVMWorkloadSQLDatabaseWorkloadItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceWorkloadItem is the BasicWorkloadItem implementation for WorkloadItem.
func (wi WorkloadItem) AsAzureVMWorkloadSQLInstanceWorkloadItem() (*AzureVMWorkloadSQLInstanceWorkloadItem, bool) {
	return nil, false
}

// AsWorkloadItem is the BasicWorkloadItem implementation for WorkloadItem.
func (wi WorkloadItem) AsWorkloadItem() (*WorkloadItem, bool) {
	return &wi, true
}

// AsBasicWorkloadItem is the BasicWorkloadItem implementation for WorkloadItem.
func (wi WorkloadItem) AsBasicWorkloadItem() (BasicWorkloadItem, bool) {
	return &wi, true
}

// WorkloadItemResource base class for backup item. Workload-specific backup items are derived from this
// class.
type WorkloadItemResource struct {
	// Properties - WorkloadItemResource properties
	Properties BasicWorkloadItem `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadItemResource.
func (wir WorkloadItemResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = wir.Properties
	if wir.Location != nil {
		objectMap["location"] = wir.Location
	}
	if wir.Tags != nil {
		objectMap["tags"] = wir.Tags
	}
	if wir.ETag != nil {
		objectMap["eTag"] = wir.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkloadItemResource struct.
func (wir *WorkloadItemResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicWorkloadItem(*v)
				if err != nil {
					return err
				}
				wir.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wir.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wir.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wir.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				wir.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wir.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				wir.ETag = &eTag
			}
		}
	}

	return nil
}

// WorkloadItemResourceList list of WorkloadItem resources
type WorkloadItemResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of resources.
	Value *[]WorkloadItemResource `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkloadItemResourceListIterator provides access to a complete listing of WorkloadItemResource values.
type WorkloadItemResourceListIterator struct {
	i    int
	page WorkloadItemResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkloadItemResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadItemResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkloadItemResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkloadItemResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkloadItemResourceListIterator) Response() WorkloadItemResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkloadItemResourceListIterator) Value() WorkloadItemResource {
	if !iter.page.NotDone() {
		return WorkloadItemResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkloadItemResourceListIterator type.
func NewWorkloadItemResourceListIterator(page WorkloadItemResourceListPage) WorkloadItemResourceListIterator {
	return WorkloadItemResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wirl WorkloadItemResourceList) IsEmpty() bool {
	return wirl.Value == nil || len(*wirl.Value) == 0
}

// workloadItemResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wirl WorkloadItemResourceList) workloadItemResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if wirl.NextLink == nil || len(to.String(wirl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wirl.NextLink)))
}

// WorkloadItemResourceListPage contains a page of WorkloadItemResource values.
type WorkloadItemResourceListPage struct {
	fn   func(context.Context, WorkloadItemResourceList) (WorkloadItemResourceList, error)
	wirl WorkloadItemResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkloadItemResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadItemResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.wirl)
	if err != nil {
		return err
	}
	page.wirl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkloadItemResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkloadItemResourceListPage) NotDone() bool {
	return !page.wirl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkloadItemResourceListPage) Response() WorkloadItemResourceList {
	return page.wirl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkloadItemResourceListPage) Values() []WorkloadItemResource {
	if page.wirl.IsEmpty() {
		return nil
	}
	return *page.wirl.Value
}

// Creates a new instance of the WorkloadItemResourceListPage type.
func NewWorkloadItemResourceListPage(getNextPage func(context.Context, WorkloadItemResourceList) (WorkloadItemResourceList, error)) WorkloadItemResourceListPage {
	return WorkloadItemResourceListPage{fn: getNextPage}
}

// BasicWorkloadProtectableItem base class for backup item. Workload-specific backup items are derived from this class.
type BasicWorkloadProtectableItem interface {
	AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool)
	AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool)
	AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool)
	AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool)
	AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool)
	AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool)
	AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool)
	AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool)
	AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool)
	AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool)
	AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool)
	AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool)
	AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool)
	AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool)
}

// WorkloadProtectableItem base class for backup item. Workload-specific backup items are derived from this
// class.
type WorkloadProtectableItem struct {
	// BackupManagementType - Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// WorkloadType - Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
	// FriendlyName - Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - State of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected', 'ProtectionStatusProtectionFailed'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeAzureFileShare', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeAzureVMWorkloadProtectableItem', 'ProtectableItemTypeSAPAseSystem', 'ProtectableItemTypeSAPHanaDatabase', 'ProtectableItemTypeSAPHanaSystem', 'ProtectableItemTypeSQLAvailabilityGroupContainer', 'ProtectableItemTypeSQLDataBase', 'ProtectableItemTypeSQLInstance', 'ProtectableItemTypeIaaSVMProtectableItem'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

func unmarshalBasicWorkloadProtectableItem(body []byte) (BasicWorkloadProtectableItem, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["protectableItemType"] {
	case string(ProtectableItemTypeAzureFileShare):
		var afspi AzureFileShareProtectableItem
		err := json.Unmarshal(body, &afspi)
		return afspi, err
	case string(ProtectableItemTypeMicrosoftClassicComputevirtualMachines):
		var aisccvpi AzureIaaSClassicComputeVMProtectableItem
		err := json.Unmarshal(body, &aisccvpi)
		return aisccvpi, err
	case string(ProtectableItemTypeMicrosoftComputevirtualMachines):
		var aiscvpi AzureIaaSComputeVMProtectableItem
		err := json.Unmarshal(body, &aiscvpi)
		return aiscvpi, err
	case string(ProtectableItemTypeAzureVMWorkloadProtectableItem):
		var avwpi AzureVMWorkloadProtectableItem
		err := json.Unmarshal(body, &avwpi)
		return avwpi, err
	case string(ProtectableItemTypeSAPAseSystem):
		var avwsaspi AzureVMWorkloadSAPAseSystemProtectableItem
		err := json.Unmarshal(body, &avwsaspi)
		return avwsaspi, err
	case string(ProtectableItemTypeSAPHanaDatabase):
		var avwshdpi AzureVMWorkloadSAPHanaDatabaseProtectableItem
		err := json.Unmarshal(body, &avwshdpi)
		return avwshdpi, err
	case string(ProtectableItemTypeSAPHanaSystem):
		var avwshspi AzureVMWorkloadSAPHanaSystemProtectableItem
		err := json.Unmarshal(body, &avwshspi)
		return avwshspi, err
	case string(ProtectableItemTypeSQLAvailabilityGroupContainer):
		var avwsagpi AzureVMWorkloadSQLAvailabilityGroupProtectableItem
		err := json.Unmarshal(body, &avwsagpi)
		return avwsagpi, err
	case string(ProtectableItemTypeSQLDataBase):
		var avwsdpi AzureVMWorkloadSQLDatabaseProtectableItem
		err := json.Unmarshal(body, &avwsdpi)
		return avwsdpi, err
	case string(ProtectableItemTypeSQLInstance):
		var avwsipi AzureVMWorkloadSQLInstanceProtectableItem
		err := json.Unmarshal(body, &avwsipi)
		return avwsipi, err
	case string(ProtectableItemTypeIaaSVMProtectableItem):
		var ispi IaaSVMProtectableItem
		err := json.Unmarshal(body, &ispi)
		return ispi, err
	default:
		var wpi WorkloadProtectableItem
		err := json.Unmarshal(body, &wpi)
		return wpi, err
	}
}
func unmarshalBasicWorkloadProtectableItemArray(body []byte) ([]BasicWorkloadProtectableItem, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	wpiArray := make([]BasicWorkloadProtectableItem, len(rawMessages))

	for index, rawMessage := range rawMessages {
		wpi, err := unmarshalBasicWorkloadProtectableItem(*rawMessage)
		if err != nil {
			return nil, err
		}
		wpiArray[index] = wpi
	}
	return wpiArray, nil
}

// MarshalJSON is the custom marshaler for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) MarshalJSON() ([]byte, error) {
	wpi.ProtectableItemType = ProtectableItemTypeWorkloadProtectableItem
	objectMap := make(map[string]interface{})
	if wpi.BackupManagementType != nil {
		objectMap["backupManagementType"] = wpi.BackupManagementType
	}
	if wpi.WorkloadType != nil {
		objectMap["workloadType"] = wpi.WorkloadType
	}
	if wpi.FriendlyName != nil {
		objectMap["friendlyName"] = wpi.FriendlyName
	}
	if wpi.ProtectionState != "" {
		objectMap["protectionState"] = wpi.ProtectionState
	}
	if wpi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = wpi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureFileShareProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsAzureFileShareProtectableItem() (*AzureFileShareProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsAzureVMWorkloadProtectableItem() (*AzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicAzureVMWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsBasicAzureVMWorkloadProtectableItem() (BasicAzureVMWorkloadProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPAseSystemProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsAzureVMWorkloadSAPAseSystemProtectableItem() (*AzureVMWorkloadSAPAseSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsAzureVMWorkloadSAPHanaDatabaseProtectableItem() (*AzureVMWorkloadSAPHanaDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSAPHanaSystemProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsAzureVMWorkloadSAPHanaSystemProtectableItem() (*AzureVMWorkloadSAPHanaSystemProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsAzureVMWorkloadSQLAvailabilityGroupProtectableItem() (*AzureVMWorkloadSQLAvailabilityGroupProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLDatabaseProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsAzureVMWorkloadSQLDatabaseProtectableItem() (*AzureVMWorkloadSQLDatabaseProtectableItem, bool) {
	return nil, false
}

// AsAzureVMWorkloadSQLInstanceProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsAzureVMWorkloadSQLInstanceProtectableItem() (*AzureVMWorkloadSQLInstanceProtectableItem, bool) {
	return nil, false
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return nil, false
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return nil, false
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return &wpi, true
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &wpi, true
}

// WorkloadProtectableItemResource base class for backup item. Workload-specific backup items are derived
// from this class.
type WorkloadProtectableItemResource struct {
	// Properties - WorkloadProtectableItemResource properties
	Properties BasicWorkloadProtectableItem `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadProtectableItemResource.
func (wpir WorkloadProtectableItemResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = wpir.Properties
	if wpir.Location != nil {
		objectMap["location"] = wpir.Location
	}
	if wpir.Tags != nil {
		objectMap["tags"] = wpir.Tags
	}
	if wpir.ETag != nil {
		objectMap["eTag"] = wpir.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkloadProtectableItemResource struct.
func (wpir *WorkloadProtectableItemResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicWorkloadProtectableItem(*v)
				if err != nil {
					return err
				}
				wpir.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wpir.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wpir.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wpir.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				wpir.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wpir.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				wpir.ETag = &eTag
			}
		}
	}

	return nil
}

// WorkloadProtectableItemResourceList list of WorkloadProtectableItem resources
type WorkloadProtectableItemResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of resources.
	Value *[]WorkloadProtectableItemResource `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkloadProtectableItemResourceListIterator provides access to a complete listing of
// WorkloadProtectableItemResource values.
type WorkloadProtectableItemResourceListIterator struct {
	i    int
	page WorkloadProtectableItemResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkloadProtectableItemResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadProtectableItemResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkloadProtectableItemResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkloadProtectableItemResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkloadProtectableItemResourceListIterator) Response() WorkloadProtectableItemResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkloadProtectableItemResourceListIterator) Value() WorkloadProtectableItemResource {
	if !iter.page.NotDone() {
		return WorkloadProtectableItemResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkloadProtectableItemResourceListIterator type.
func NewWorkloadProtectableItemResourceListIterator(page WorkloadProtectableItemResourceListPage) WorkloadProtectableItemResourceListIterator {
	return WorkloadProtectableItemResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wpirl WorkloadProtectableItemResourceList) IsEmpty() bool {
	return wpirl.Value == nil || len(*wpirl.Value) == 0
}

// workloadProtectableItemResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wpirl WorkloadProtectableItemResourceList) workloadProtectableItemResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if wpirl.NextLink == nil || len(to.String(wpirl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wpirl.NextLink)))
}

// WorkloadProtectableItemResourceListPage contains a page of WorkloadProtectableItemResource values.
type WorkloadProtectableItemResourceListPage struct {
	fn    func(context.Context, WorkloadProtectableItemResourceList) (WorkloadProtectableItemResourceList, error)
	wpirl WorkloadProtectableItemResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkloadProtectableItemResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadProtectableItemResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.wpirl)
	if err != nil {
		return err
	}
	page.wpirl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkloadProtectableItemResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkloadProtectableItemResourceListPage) NotDone() bool {
	return !page.wpirl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkloadProtectableItemResourceListPage) Response() WorkloadProtectableItemResourceList {
	return page.wpirl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkloadProtectableItemResourceListPage) Values() []WorkloadProtectableItemResource {
	if page.wpirl.IsEmpty() {
		return nil
	}
	return *page.wpirl.Value
}

// Creates a new instance of the WorkloadProtectableItemResourceListPage type.
func NewWorkloadProtectableItemResourceListPage(getNextPage func(context.Context, WorkloadProtectableItemResourceList) (WorkloadProtectableItemResourceList, error)) WorkloadProtectableItemResourceListPage {
	return WorkloadProtectableItemResourceListPage{fn: getNextPage}
}

// YearlyRetentionSchedule yearly retention schedule.
type YearlyRetentionSchedule struct {
	// RetentionScheduleFormatType - Retention schedule format for yearly retention policy. Possible values include: 'RetentionScheduleFormatInvalid', 'RetentionScheduleFormatDaily', 'RetentionScheduleFormatWeekly'
	RetentionScheduleFormatType RetentionScheduleFormat `json:"retentionScheduleFormatType,omitempty"`
	// MonthsOfYear - List of months of year of yearly retention policy.
	MonthsOfYear *[]MonthOfYear `json:"monthsOfYear,omitempty"`
	// RetentionScheduleDaily - Daily retention format for yearly retention policy.
	RetentionScheduleDaily *DailyRetentionFormat `json:"retentionScheduleDaily,omitempty"`
	// RetentionScheduleWeekly - Weekly retention format for yearly retention policy.
	RetentionScheduleWeekly *WeeklyRetentionFormat `json:"retentionScheduleWeekly,omitempty"`
	// RetentionTimes - Retention times of retention policy.
	RetentionTimes *[]date.Time `json:"retentionTimes,omitempty"`
	// RetentionDuration - Retention duration of retention Policy.
	RetentionDuration *RetentionDuration `json:"retentionDuration,omitempty"`
}
