---
type: docs
title: Mentorship
menu: contributing
---

# Thanos / Prometheus Open Source Mentorship

Both Thanos and Prometheus projects participate in various, periodic mentoring programs.

[Follow us on Twitter](https://thanos.io/tip/contributing/community.md/#twitter) to be up-to-date with application process and announcements.

Programs we participated / are participating:

- [LFX Mentorship (previously Community Bridge)](https://github.com/cncf/mentoring/tree/master/lfx-mentorship)
- [Google Summer of Code](https://github.com/cncf/mentoring/tree/master/summerofcode)
- [Red Hat Beyond](https://research.redhat.com/blog/2020/05/24/open-source-development-course-and-devops-methodology/)

## For Mentees

You have been selected for mentorship with Prometheus or Thanos? Congratulations! Here is some short quick information for a quick start!

### Onboarding Check List

- [X] Please see and acknowledge our [Code of Conduct](https://thanos.io/tip/contributing/code_of_conduct.md/). A similar one is for the Prometheus project. TL;DR: Be nice and friendly!
- [X] Create an account on the [CNCF Slack](https://slack.cncf.io/). Please add any profile photo to make it unique. (: This is Thanos's main chat provider. You can reach any of the mentors there.
- [X] If you are a Prometheus mentee OR if your task will involve collaborating with the Prometheus project, it's also recommended to set up an IRC account e.g by [joining Element](https://prometheus.io/community/). This the main channel Prometheus Team is using currently.
- [X] Send your mentors your slack account handle, so we can join you to private channels. We have one with just you and your main mentors, and second with all mentees, ex-mentees and mentors.
- [X] Join main [Thanos channels](https://thanos.io/tip/contributing/community.md/#slack) and write a few sentences to about yourself, say hello! 💜
- [X] You are welcome to join Twitter, start following others and gather your own followers! Who knows maybe you will get addicted? (: Feel free to post any related content around Thanos while mentioning `@ThanosMetrics`.
- [X] Ask maintainers to set up some weekly 2:1 meeting (highly recommended).
- [X] Read our [contributing guides](https://thanos.io/tip/contributing/contributing.md/)
- [X] Read carefully your main GitHub issue and start thinking about it, but don't stress out! It's better to start slowly with a smaller task to get things going. 🚀

### Suggestions

There are certain rules you can follow to make the MOST from your time with us!

- Blocked on the PR, looking for someone to review your contribution, or have some quick question around failed CI? Prefer `public` communication channels. Both Prometheus and Thanos have a large community that can quickly help you with any issues. There also other mentees who might have had similar questions already! (:
- Say hello to fellow mentees and ex-mentees. We even created a special channel for that goal, so you can team up and build something bigger together: Relation, maybe a future project together or just helping each other out! Take an example from Summer 2020. Previous Thanos mentees started [Friday fun hangouts](https://twitter.com/bwplotka/status/1270016551664488451) without mentors knowledge and it went pretty awesome! Want to start something similar? Ask fellow ex-mentees for their tips. 🤗
- Think out of the box. Do you feel like something is really painful in project development, functionality or community? Help us improve things and suggest improvements!
- Participate in the Project life cycles. We are active in many conferences e.g. KubeCon, PromCon, FOSDEM, GoDays. We participate in the CNCF SIGs, many side initiatives, blog posts and videos. Please help us! You are welcome to boost your social media visibility, start blog posting, or even start talking at conferences. Feel free to ask your mentors for guidance on whatever you are passionate with! We would love to help.
- You are **welcome** or even encouraged to contribute to anything you want during your internship. It's common to wait for a review of your PR some time (it's open source after all!), so it's not uncommon to drive 2 or 3 things at the time. You don't need to limit contributions to Thanos project as well. It's totally ok to contribute to some other project we depend on or relate (e.g [Yash](https://twitter.com/yashrsharma44) was heavily contributing to [go-grpc-middleware](https://github.com/grpc-ecosystem/go-grpc-middleware)). It's also encouraged for Thanos mentee to contribute to Prometheus or Cortex and vice versa. This is because we are part of a bigger **Prometheus Ecosystem Family**.
- Try to be independent and responsible for the feature you want to deliver. The sooner you start to lead your task, the better for you! It's hard in the beginning but try to think about the user experience. Is it hard or easy to make mistake using it? How difficult is it to migrate to this feature? Is there anything we can do to reduce data loss errors?
- Try to help others by **reviewing** other contributors, mentees or mentors' Pull Requests! It sounds scary, but this is actually the best way to learn about coding practices, patterns and how to maintain high quality codebase! (GIFs on PRs are welcome as well!)
- Try using an [iterative process for development](https://en.wikipedia.org/wiki/Iterative_and_incremental_development). Start with small and simple assumptions, and once you have a working example ready, keep improving and discussing with the mentors. Small changes are easy to review and easy to accept 😄.
- Try working out a [proof of concept](https://en.wikipedia.org/wiki/Proof_of_concept), which can be used as a baseline, and can be improved upon. These are real-world projects, so it's not possible to have a deterministic solution everytime, and proof of concepts are quick way to determine feasibility.

> At the end of mentorship, it's not the end! You are welcome to join our Community Office Hours. See [this](https://docs.google.com/document/d/137XnxfOT2p1NcNUq6NWZjwmtlSdA6Wyti86Pd6cyQhs/edit#) for details. This is the meeting for any Thanos contributor, but you will find fellow current and ex-mentees on the meeting too.

### Mentees Meetup

In order to allow mentees to share the knowledge their learned and allow them to improve public speaking skills, at the end of mentorship cycles we can (optionally) organize virtual "Mentees Meetup". How to organize it:

1. Talk to mentees, check if at least two mentees are interested to present the state of their project or what they learned and how. On top of presenting, check if they are interested in organizing meetup together (organizational skills!). Check if mentors have time to help organizing too.
2. Help mentees to propose the title, description and outline for 15-20 minutes talk with 5m Q&A.
3. Consider preparing the agenda of the meetup with mentees talk first then with the "Learnings" talk.

> Potential flow of learning talk is to have mentors go through some filtered list of learnings we gathered from retrospective. On the talk, all mentees might be part of the meeting to chime in anytime and have it more discussion oriented with Q&A time.

1. Find a suitable time slot, typically 2h in the evening.
2. Announce meetup on (...) platform. Describe agenda, mention timing, how to join, Code of conduct and who is a target audience!

> Target Audience: Other potential mentees, students, other project mentors and community who would like to teach others more, potential Thanos contributors

1. Choose MC! (Someone who leads the meetup).
2. Create Zoom webinar on Thanos account (use cloud recording).
3. Perform it! (:

## For Mentors

This section explains some process around selecting mentees (TBD) and [retrospective](#retrospective) process.

### Retrospective

On the last meeting of the mentorship we want to finish with some *actionable learnings*. The experience of both Mentors and Mentees is always different due to differences among us, different task and circumstances. We always want to summarize our experience, no matter if we met the initial goals or not. If goals were not met, then it's extra important to discuss this in honest, blameless atmosphere. If the experience was mostly positive we also want to know what worked to reinforce best practices.

The example retrospective process looks as follows:

* Week before last meeting Mentors are reminding Mentees about the last session and how retrospective will look like. This allows everyone to think through the week about things that worked and not.
* On the last meeting, start first with retrospective. This is the most important part of meeting, don't let other things (e.g project status) to get in the path.
  * Write in the Working doc 2 sections: `What we did well`, `What we could do better`.
  * Give everyone 5m to write down (e.g live) items in those two sections. Be specific, blameless and honest. It's not about offending anyone, but looking for improvements for both Mentor and Mentees work. Be critical to yourself, but also try to balance the good and to improve parts. There is always something we could do better or worse.
  * When everyone has finished, create new section: `Learnings`.
  * Go through all elements on the list. Discuss the details. Try to find ideas how to mitigate problem or what to continue doing. Write down those things in `Learning` section.
  * At the end share the learnings to the team on mailing list.
  * Consider composing all learnings into nice presentation we can show in [Mentees Meetup](#mentees-meetup)

### Mentees Selection

TBD
