---
type: docs
title: Community
menu: contributing
---

# Community

Thanos is an open source project from the very first commit. We always value and welcome new contributors and members of the community. Here are ways to get in touch with the community:

### Social Media and Announcements

Follow and interact with us on Twitter: [@ThanosMetrics](https://twitter.com/ThanosMetrics)

### Thanos Community Meetings

Thanos Community Meeting is a **public** and **recorded** monthly meeting every second Wednesday 13:00 UTC ([Time zone converter](https://www.thetimezoneconverter.com/?t=13%3A00%20pm&tz=UTC%20(Coordinated%20Universal%20Time)&)).

Thanos maintainers & the community meet to discuss open issues, features and other Thanos related things. Everyone is welcome to join & add items to the agenda. The meeting happens in Zoom. Right now meeting is in a Webinar format, where only small amount of people will have ability to speak and video share, due to recent [Zoombombing](https://en.wikipedia.org/wiki/Zoombombing) issues.

* When: Monthly, every second Wednesday 12:00 UTC ([Time zone converter](https://www.thetimezoneconverter.com/?t=12%3A00%20pm&tz=UTC%20(Coordinated%20Universal%20Time)&)).
* Google Calendar: [Google Calendar](https://calendar.google.com/calendar/embed?src=go39q7eu71vvu3gfrkbup6b254%40group.calendar.google.com)
* Agenda: [https://bit.ly/thanos-community-agenda](https://bit.ly/thanos-community-agenda)
* Link to join zoom webinar: [https://zoom.us/j/96476403386](https://zoom.us/j/96476403386)

If you have any suggestions, how we can run the meeting better, please let `@povilasv` or `@metalmatze` know in the CNCF slack.

### Thanos Contributor Office Hours

Thanos Contributor Office Hours are public weekly meetings focused on Thanos development and contributions. It’s meant for developers and maintainers to meet, get unblocked, pair review, and discuss development aspects of Thanos and related projects. Read more [here](https://docs.google.com/document/d/137XnxfOT2p1NcNUq6NWZjwmtlSdA6Wyti86Pd6cyQhs/edit#heading=h.oy8b2jtupl8m).

### Slack

* General channel: [#thanos](https://slack.cncf.io/)
* Development related channel, PR discussions: [#thanos-dev](https://slack.cncf.io/)

### Prometheus Communication Channels

Since we are active Prometheus contributors and, some of us, maintainers we are also available on [Prometheus IRC and email-list channels](https://prometheus.io/community/)

### Prometheus Community & Ecosystem Meetings

The Prometheus & The Ecosystem community meeting is intended to provide a holistic overview of community activities, critical release information, and governance updates for Prometheus & the Ecosystem projects.

Thanos Maintainers regularly join and give announcements and updates.

Meeting details: [https://bit.ly/prometheus-community-agenda](https://bit.ly/prometheus-community-agenda)

### Mentorships

We participate in periodic mentorship programs. Read more [here](https://thanos.io/tip/contributing/mentorship.md/).

### Further Questions

Feel free to contact any of the [Maintainers](https://thanos.io/tip/thanos/maintainers.md/)
