# Core Maintainers of this repository

| Name                  | Email                  | Slack                    | GitHub                                      | Company           |
|-----------------------|------------------------|--------------------------|---------------------------------------------|-------------------|
| Bartłomiej Płotka     | bwplotka@gmail.com     | `@bwplotka`              | [@bwplotka](https://github.com/bwplotka)    | Red Hat           |
| Frederic Branczyk     | fbranczyk@gmail.com    | `@brancz`                | [@brancz](https://github.com/brancz)        | Red Hat           |
| Giedrius Statkevičius | giedriuswork@gmail.com | `@Giedrius Statkevičius` | [@GiedriusS](https://github.com/GiedriusS)  | AdForm            |
| Kemal Akkoyun         | kakkoyun@gmail.com     | `@kakkoyun`              | [@kakkoyun](https://github.com/kakkoyun)    | Red Hat           |
| Lucas Servén Marín    | lserven@gmail.com      | `@squat`                 | [@squat](https://github.com/squat)          | Red Hat           |
| Povilas Versockas     | p.versockas@gmail.com  | `@povilasv`              | [@povilasv](https://github.com/povilasv)    | Utility Warehouse |
| Prem Saraswat         | prmsrswt@gmail.com     | `@Prem Saraswat`         | [@prmsrswt](https://github.com/prmsrswt)    | Atlan             |
| Marco Pracucci        | marco@pracucci.com     | `@pracucci`              | [@pracucci](https://github.com/pracucci)    | Grafana Labs      |
| Matthias Loibl        | mail@matthiasloibl.com | `@metalmatze`            | [@metalmatze](https://github.com/metalmatze)| Red Hat           |

We are bunch of people from different companies with various interests and skills.
We are from different parts of Europe: Germany, Italy, Lithuania, Poland, and UK and India.
We have something in common though: We all share the love for OpenSource, Go, Prometheus, :coffee: and Observability topics.

As either Software Developers or SRE (or both!) we've chosen to maintain (mostly in our free time) Thanos, the de facto way to scale awesome [Prometheus](https://prometheus.io) project.

Feel free to contact us (preferably on Slack) anytime for feedback, questions or :beers:/:coffee:/:tea:.

Especially feedback, please share if you have ideas what we can do better!

You can reach us under `thanos-io@googlegroups.com` email.

## Triage

We also have some nice souls that help triaging issues and PRs. See [here](https://help.github.com/en/articles/repository-permission-levels-for-an-organization#permission-levels-for-repositories-owned-by-an-organization)
for details about the role's permission.

Full list of triage persons is displayed below:

| Name                  | Slack                    | GitHub                                                     |
|-----------------------|--------------------------|------------------------------------------------------------|
| Adrien Fillon         | `@Adrien F`              | [@adrien-f](https://github.com/adrien-f)                   |
| Ben Ye                | `@yeya24`                | [@yeya24](https://github.com/yeya24)                       |
| Martin Chodur         | `@FUSAKLA`               | [@fusakla](https://github.com/fusakla)                     |
| Michael Dai           | `@jojohappy`             | [@jojohappy](https://github.com/jojohappy)                 |
| Xiang Dai             | `@daixiang0`             | [@daixiang0](https://github.com/daixiang0)                 |

Please reach any of the maintainer on slack or email if you want to help as well.

### Triage labels

To improve navigating through issues and PRs we introduce various [labels](https://github.com/thanos-io/thanos/issues/labels). Part of triaging process for Triage and Maintainers
is to adjust those labels if needed manual. The `Prow` system can automate a portion of this in future.

The main labels are:

#### Component

`component: *` and `website/docs` labels indicate an area related to the change or issue.

#### Difficulty

`difficulty: easy|medium|hard` labels indicate the approximate difficulty for the change (in terms of reviewing) or the issue (in terms of addressing).

This helps to also estimate how long it can potentially take to review the PR or address the issue with this label.

#### Help wanted

`help wanted ` label should be present if the issue is not really assigned (or the PR has to be reviewed) and we are looking for the volunteers (:

#### Good first issue

`good first issue` is similar as help wanted but present *only* on the issues when it's newcomer friendly. This means:

* issue has a clear acceptance criteria
* issue has limited scope
* issue is well described

#### Priority

`priority: P0` should be assigned for the changes or the issues that are critical and should be addressed in first order.

#### State

Github shows some basic states, but sometimes PR is stale due to requested changes, but it's not clear from first glance.
That's why `state: changes-requested` is helpful on those.

#### Other

Self explanatory ones:

* `question` label indicates an issue with question.
* `proposal` label indicates an issue / PR with official proposal.
* `duplicate`
* `feature request / improvement`
* `bug` and `bugfix`

## Storage plugins maintainers

Maintainers of bucket storage clients are available [here](/docs/storage.md#implementations)

## How to be maintainer?

Any [contributor](/CONTRIBUTING.md) that shows effort and willingness in maintaining Thanos repository can join maintainer team.

Open Source is all about the trust, which is the key factor in decision to add write permissions.

In time we plan to set up maintainers team that will be organization independent. Reach us if you have any questions or want to join
maintainer team.

## Initial authors

Fabian Reinartz @fabxc and Bartłomiej Płotka @bwplotka

