// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/openshift/ptp-operator/pkg/apis/ptp/v1"
	scheme "github.com/openshift/ptp-operator/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// PtpOperatorConfigsGetter has a method to return a PtpOperatorConfigInterface.
// A group's client should implement this interface.
type PtpOperatorConfigsGetter interface {
	PtpOperatorConfigs(namespace string) PtpOperatorConfigInterface
}

// PtpOperatorConfigInterface has methods to work with PtpOperatorConfig resources.
type PtpOperatorConfigInterface interface {
	Create(ctx context.Context, ptpOperatorConfig *v1.PtpOperatorConfig, opts metav1.CreateOptions) (*v1.PtpOperatorConfig, error)
	Update(ctx context.Context, ptpOperatorConfig *v1.PtpOperatorConfig, opts metav1.UpdateOptions) (*v1.PtpOperatorConfig, error)
	UpdateStatus(ctx context.Context, ptpOperatorConfig *v1.PtpOperatorConfig, opts metav1.UpdateOptions) (*v1.PtpOperatorConfig, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.PtpOperatorConfig, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.PtpOperatorConfigList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.PtpOperatorConfig, err error)
	PtpOperatorConfigExpansion
}

// ptpOperatorConfigs implements PtpOperatorConfigInterface
type ptpOperatorConfigs struct {
	client rest.Interface
	ns     string
}

// newPtpOperatorConfigs returns a PtpOperatorConfigs
func newPtpOperatorConfigs(c *PtpV1Client, namespace string) *ptpOperatorConfigs {
	return &ptpOperatorConfigs{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the ptpOperatorConfig, and returns the corresponding ptpOperatorConfig object, and an error if there is any.
func (c *ptpOperatorConfigs) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.PtpOperatorConfig, err error) {
	result = &v1.PtpOperatorConfig{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("ptpoperatorconfigs").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of PtpOperatorConfigs that match those selectors.
func (c *ptpOperatorConfigs) List(ctx context.Context, opts metav1.ListOptions) (result *v1.PtpOperatorConfigList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.PtpOperatorConfigList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("ptpoperatorconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested ptpOperatorConfigs.
func (c *ptpOperatorConfigs) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("ptpoperatorconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a ptpOperatorConfig and creates it.  Returns the server's representation of the ptpOperatorConfig, and an error, if there is any.
func (c *ptpOperatorConfigs) Create(ctx context.Context, ptpOperatorConfig *v1.PtpOperatorConfig, opts metav1.CreateOptions) (result *v1.PtpOperatorConfig, err error) {
	result = &v1.PtpOperatorConfig{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("ptpoperatorconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ptpOperatorConfig).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a ptpOperatorConfig and updates it. Returns the server's representation of the ptpOperatorConfig, and an error, if there is any.
func (c *ptpOperatorConfigs) Update(ctx context.Context, ptpOperatorConfig *v1.PtpOperatorConfig, opts metav1.UpdateOptions) (result *v1.PtpOperatorConfig, err error) {
	result = &v1.PtpOperatorConfig{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("ptpoperatorconfigs").
		Name(ptpOperatorConfig.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ptpOperatorConfig).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *ptpOperatorConfigs) UpdateStatus(ctx context.Context, ptpOperatorConfig *v1.PtpOperatorConfig, opts metav1.UpdateOptions) (result *v1.PtpOperatorConfig, err error) {
	result = &v1.PtpOperatorConfig{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("ptpoperatorconfigs").
		Name(ptpOperatorConfig.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ptpOperatorConfig).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the ptpOperatorConfig and deletes it. Returns an error if one occurs.
func (c *ptpOperatorConfigs) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("ptpoperatorconfigs").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *ptpOperatorConfigs) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("ptpoperatorconfigs").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched ptpOperatorConfig.
func (c *ptpOperatorConfigs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.PtpOperatorConfig, err error) {
	result = &v1.PtpOperatorConfig{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("ptpoperatorconfigs").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
