// Copyright 2019 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by gapic-generator. DO NOT EDIT.

package automl

import (
	"context"
	"flag"
	"fmt"
	"io"
	"log"
	"net"
	"os"
	"strings"
	"testing"

	"github.com/golang/protobuf/proto"
	"github.com/golang/protobuf/ptypes"
	emptypb "github.com/golang/protobuf/ptypes/empty"
	"google.golang.org/api/option"
	automlpb "google.golang.org/genproto/googleapis/cloud/automl/v1"
	longrunningpb "google.golang.org/genproto/googleapis/longrunning"
	field_maskpb "google.golang.org/genproto/protobuf/field_mask"

	status "google.golang.org/genproto/googleapis/rpc/status"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/metadata"

	gstatus "google.golang.org/grpc/status"
)

var _ = io.EOF
var _ = ptypes.MarshalAny
var _ status.Status

type mockAutoMlServer struct {
	// Embed for forward compatibility.
	// Tests will keep working if more methods are added
	// in the future.
	automlpb.AutoMlServer

	reqs []proto.Message

	// If set, all calls return this error.
	err error

	// responses to return if err == nil
	resps []proto.Message
}

func (s *mockAutoMlServer) CreateDataset(ctx context.Context, req *automlpb.CreateDatasetRequest) (*longrunningpb.Operation, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*longrunningpb.Operation), nil
}

func (s *mockAutoMlServer) GetDataset(ctx context.Context, req *automlpb.GetDatasetRequest) (*automlpb.Dataset, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*automlpb.Dataset), nil
}

func (s *mockAutoMlServer) ListDatasets(ctx context.Context, req *automlpb.ListDatasetsRequest) (*automlpb.ListDatasetsResponse, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*automlpb.ListDatasetsResponse), nil
}

func (s *mockAutoMlServer) UpdateDataset(ctx context.Context, req *automlpb.UpdateDatasetRequest) (*automlpb.Dataset, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*automlpb.Dataset), nil
}

func (s *mockAutoMlServer) DeleteDataset(ctx context.Context, req *automlpb.DeleteDatasetRequest) (*longrunningpb.Operation, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*longrunningpb.Operation), nil
}

func (s *mockAutoMlServer) ImportData(ctx context.Context, req *automlpb.ImportDataRequest) (*longrunningpb.Operation, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*longrunningpb.Operation), nil
}

func (s *mockAutoMlServer) ExportData(ctx context.Context, req *automlpb.ExportDataRequest) (*longrunningpb.Operation, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*longrunningpb.Operation), nil
}

func (s *mockAutoMlServer) GetAnnotationSpec(ctx context.Context, req *automlpb.GetAnnotationSpecRequest) (*automlpb.AnnotationSpec, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*automlpb.AnnotationSpec), nil
}

func (s *mockAutoMlServer) CreateModel(ctx context.Context, req *automlpb.CreateModelRequest) (*longrunningpb.Operation, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*longrunningpb.Operation), nil
}

func (s *mockAutoMlServer) GetModel(ctx context.Context, req *automlpb.GetModelRequest) (*automlpb.Model, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*automlpb.Model), nil
}

func (s *mockAutoMlServer) ListModels(ctx context.Context, req *automlpb.ListModelsRequest) (*automlpb.ListModelsResponse, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*automlpb.ListModelsResponse), nil
}

func (s *mockAutoMlServer) DeleteModel(ctx context.Context, req *automlpb.DeleteModelRequest) (*longrunningpb.Operation, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*longrunningpb.Operation), nil
}

func (s *mockAutoMlServer) UpdateModel(ctx context.Context, req *automlpb.UpdateModelRequest) (*automlpb.Model, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*automlpb.Model), nil
}

func (s *mockAutoMlServer) DeployModel(ctx context.Context, req *automlpb.DeployModelRequest) (*longrunningpb.Operation, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*longrunningpb.Operation), nil
}

func (s *mockAutoMlServer) UndeployModel(ctx context.Context, req *automlpb.UndeployModelRequest) (*longrunningpb.Operation, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*longrunningpb.Operation), nil
}

func (s *mockAutoMlServer) ExportModel(ctx context.Context, req *automlpb.ExportModelRequest) (*longrunningpb.Operation, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*longrunningpb.Operation), nil
}

func (s *mockAutoMlServer) GetModelEvaluation(ctx context.Context, req *automlpb.GetModelEvaluationRequest) (*automlpb.ModelEvaluation, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*automlpb.ModelEvaluation), nil
}

func (s *mockAutoMlServer) ListModelEvaluations(ctx context.Context, req *automlpb.ListModelEvaluationsRequest) (*automlpb.ListModelEvaluationsResponse, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*automlpb.ListModelEvaluationsResponse), nil
}

type mockPredictionServer struct {
	// Embed for forward compatibility.
	// Tests will keep working if more methods are added
	// in the future.
	automlpb.PredictionServiceServer

	reqs []proto.Message

	// If set, all calls return this error.
	err error

	// responses to return if err == nil
	resps []proto.Message
}

func (s *mockPredictionServer) Predict(ctx context.Context, req *automlpb.PredictRequest) (*automlpb.PredictResponse, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*automlpb.PredictResponse), nil
}

func (s *mockPredictionServer) BatchPredict(ctx context.Context, req *automlpb.BatchPredictRequest) (*longrunningpb.Operation, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*longrunningpb.Operation), nil
}

// clientOpt is the option tests should use to connect to the test server.
// It is initialized by TestMain.
var clientOpt option.ClientOption

var (
	mockAutoMl     mockAutoMlServer
	mockPrediction mockPredictionServer
)

func TestMain(m *testing.M) {
	flag.Parse()

	serv := grpc.NewServer()
	automlpb.RegisterAutoMlServer(serv, &mockAutoMl)
	automlpb.RegisterPredictionServiceServer(serv, &mockPrediction)

	lis, err := net.Listen("tcp", "localhost:0")
	if err != nil {
		log.Fatal(err)
	}
	go serv.Serve(lis)

	conn, err := grpc.Dial(lis.Addr().String(), grpc.WithInsecure())
	if err != nil {
		log.Fatal(err)
	}
	clientOpt = option.WithGRPCConn(conn)

	os.Exit(m.Run())
}

func TestAutoMlCreateDataset(t *testing.T) {
	var name string = "name3373707"
	var displayName string = "displayName1615086568"
	var description string = "description-1724546052"
	var exampleCount int32 = 1517063674
	var etag string = "etag3123477"
	var expectedResponse = &automlpb.Dataset{
		Name:         name,
		DisplayName:  displayName,
		Description:  description,
		ExampleCount: exampleCount,
		Etag:         etag,
	}

	mockAutoMl.err = nil
	mockAutoMl.reqs = nil

	any, err := ptypes.MarshalAny(expectedResponse)
	if err != nil {
		t.Fatal(err)
	}
	mockAutoMl.resps = append(mockAutoMl.resps[:0], &longrunningpb.Operation{
		Name:   "longrunning-test",
		Done:   true,
		Result: &longrunningpb.Operation_Response{Response: any},
	})

	var formattedParent string = fmt.Sprintf("projects/%s/locations/%s", "[PROJECT]", "[LOCATION]")
	var dataset *automlpb.Dataset = &automlpb.Dataset{}
	var request = &automlpb.CreateDatasetRequest{
		Parent:  formattedParent,
		Dataset: dataset,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	respLRO, err := c.CreateDataset(context.Background(), request)
	if err != nil {
		t.Fatal(err)
	}
	resp, err := respLRO.Wait(context.Background())

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockAutoMl.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestAutoMlCreateDatasetError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockAutoMl.err = nil
	mockAutoMl.resps = append(mockAutoMl.resps[:0], &longrunningpb.Operation{
		Name: "longrunning-test",
		Done: true,
		Result: &longrunningpb.Operation_Error{
			Error: &status.Status{
				Code:    int32(errCode),
				Message: "test error",
			},
		},
	})

	var formattedParent string = fmt.Sprintf("projects/%s/locations/%s", "[PROJECT]", "[LOCATION]")
	var dataset *automlpb.Dataset = &automlpb.Dataset{}
	var request = &automlpb.CreateDatasetRequest{
		Parent:  formattedParent,
		Dataset: dataset,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	respLRO, err := c.CreateDataset(context.Background(), request)
	if err != nil {
		t.Fatal(err)
	}
	resp, err := respLRO.Wait(context.Background())

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestAutoMlUpdateDataset(t *testing.T) {
	var name string = "name3373707"
	var displayName string = "displayName1615086568"
	var description string = "description-1724546052"
	var exampleCount int32 = 1517063674
	var etag string = "etag3123477"
	var expectedResponse = &automlpb.Dataset{
		Name:         name,
		DisplayName:  displayName,
		Description:  description,
		ExampleCount: exampleCount,
		Etag:         etag,
	}

	mockAutoMl.err = nil
	mockAutoMl.reqs = nil

	mockAutoMl.resps = append(mockAutoMl.resps[:0], expectedResponse)

	var dataset *automlpb.Dataset = &automlpb.Dataset{}
	var updateMask *field_maskpb.FieldMask = &field_maskpb.FieldMask{}
	var request = &automlpb.UpdateDatasetRequest{
		Dataset:    dataset,
		UpdateMask: updateMask,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.UpdateDataset(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockAutoMl.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestAutoMlUpdateDatasetError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockAutoMl.err = gstatus.Error(errCode, "test error")

	var dataset *automlpb.Dataset = &automlpb.Dataset{}
	var updateMask *field_maskpb.FieldMask = &field_maskpb.FieldMask{}
	var request = &automlpb.UpdateDatasetRequest{
		Dataset:    dataset,
		UpdateMask: updateMask,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.UpdateDataset(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestAutoMlGetDataset(t *testing.T) {
	var name2 string = "name2-1052831874"
	var displayName string = "displayName1615086568"
	var description string = "description-1724546052"
	var exampleCount int32 = 1517063674
	var etag string = "etag3123477"
	var expectedResponse = &automlpb.Dataset{
		Name:         name2,
		DisplayName:  displayName,
		Description:  description,
		ExampleCount: exampleCount,
		Etag:         etag,
	}

	mockAutoMl.err = nil
	mockAutoMl.reqs = nil

	mockAutoMl.resps = append(mockAutoMl.resps[:0], expectedResponse)

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/datasets/%s", "[PROJECT]", "[LOCATION]", "[DATASET]")
	var request = &automlpb.GetDatasetRequest{
		Name: formattedName,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.GetDataset(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockAutoMl.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestAutoMlGetDatasetError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockAutoMl.err = gstatus.Error(errCode, "test error")

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/datasets/%s", "[PROJECT]", "[LOCATION]", "[DATASET]")
	var request = &automlpb.GetDatasetRequest{
		Name: formattedName,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.GetDataset(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestAutoMlListDatasets(t *testing.T) {
	var nextPageToken string = ""
	var datasetsElement *automlpb.Dataset = &automlpb.Dataset{}
	var datasets = []*automlpb.Dataset{datasetsElement}
	var expectedResponse = &automlpb.ListDatasetsResponse{
		NextPageToken: nextPageToken,
		Datasets:      datasets,
	}

	mockAutoMl.err = nil
	mockAutoMl.reqs = nil

	mockAutoMl.resps = append(mockAutoMl.resps[:0], expectedResponse)

	var formattedParent string = fmt.Sprintf("projects/%s/locations/%s", "[PROJECT]", "[LOCATION]")
	var request = &automlpb.ListDatasetsRequest{
		Parent: formattedParent,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.ListDatasets(context.Background(), request).Next()

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockAutoMl.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	want := (interface{})(expectedResponse.Datasets[0])
	got := (interface{})(resp)
	var ok bool

	switch want := (want).(type) {
	case proto.Message:
		ok = proto.Equal(want, got.(proto.Message))
	default:
		ok = want == got
	}
	if !ok {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestAutoMlListDatasetsError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockAutoMl.err = gstatus.Error(errCode, "test error")

	var formattedParent string = fmt.Sprintf("projects/%s/locations/%s", "[PROJECT]", "[LOCATION]")
	var request = &automlpb.ListDatasetsRequest{
		Parent: formattedParent,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.ListDatasets(context.Background(), request).Next()

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestAutoMlDeleteDataset(t *testing.T) {
	var expectedResponse *emptypb.Empty = &emptypb.Empty{}

	mockAutoMl.err = nil
	mockAutoMl.reqs = nil

	any, err := ptypes.MarshalAny(expectedResponse)
	if err != nil {
		t.Fatal(err)
	}
	mockAutoMl.resps = append(mockAutoMl.resps[:0], &longrunningpb.Operation{
		Name:   "longrunning-test",
		Done:   true,
		Result: &longrunningpb.Operation_Response{Response: any},
	})

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/datasets/%s", "[PROJECT]", "[LOCATION]", "[DATASET]")
	var request = &automlpb.DeleteDatasetRequest{
		Name: formattedName,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	respLRO, err := c.DeleteDataset(context.Background(), request)
	if err != nil {
		t.Fatal(err)
	}
	err = respLRO.Wait(context.Background())

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockAutoMl.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

}

func TestAutoMlDeleteDatasetError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockAutoMl.err = nil
	mockAutoMl.resps = append(mockAutoMl.resps[:0], &longrunningpb.Operation{
		Name: "longrunning-test",
		Done: true,
		Result: &longrunningpb.Operation_Error{
			Error: &status.Status{
				Code:    int32(errCode),
				Message: "test error",
			},
		},
	})

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/datasets/%s", "[PROJECT]", "[LOCATION]", "[DATASET]")
	var request = &automlpb.DeleteDatasetRequest{
		Name: formattedName,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	respLRO, err := c.DeleteDataset(context.Background(), request)
	if err != nil {
		t.Fatal(err)
	}
	err = respLRO.Wait(context.Background())

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
}
func TestAutoMlImportData(t *testing.T) {
	var expectedResponse *emptypb.Empty = &emptypb.Empty{}

	mockAutoMl.err = nil
	mockAutoMl.reqs = nil

	any, err := ptypes.MarshalAny(expectedResponse)
	if err != nil {
		t.Fatal(err)
	}
	mockAutoMl.resps = append(mockAutoMl.resps[:0], &longrunningpb.Operation{
		Name:   "longrunning-test",
		Done:   true,
		Result: &longrunningpb.Operation_Response{Response: any},
	})

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/datasets/%s", "[PROJECT]", "[LOCATION]", "[DATASET]")
	var inputConfig *automlpb.InputConfig = &automlpb.InputConfig{}
	var request = &automlpb.ImportDataRequest{
		Name:        formattedName,
		InputConfig: inputConfig,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	respLRO, err := c.ImportData(context.Background(), request)
	if err != nil {
		t.Fatal(err)
	}
	err = respLRO.Wait(context.Background())

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockAutoMl.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

}

func TestAutoMlImportDataError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockAutoMl.err = nil
	mockAutoMl.resps = append(mockAutoMl.resps[:0], &longrunningpb.Operation{
		Name: "longrunning-test",
		Done: true,
		Result: &longrunningpb.Operation_Error{
			Error: &status.Status{
				Code:    int32(errCode),
				Message: "test error",
			},
		},
	})

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/datasets/%s", "[PROJECT]", "[LOCATION]", "[DATASET]")
	var inputConfig *automlpb.InputConfig = &automlpb.InputConfig{}
	var request = &automlpb.ImportDataRequest{
		Name:        formattedName,
		InputConfig: inputConfig,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	respLRO, err := c.ImportData(context.Background(), request)
	if err != nil {
		t.Fatal(err)
	}
	err = respLRO.Wait(context.Background())

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
}
func TestAutoMlExportData(t *testing.T) {
	var expectedResponse *emptypb.Empty = &emptypb.Empty{}

	mockAutoMl.err = nil
	mockAutoMl.reqs = nil

	any, err := ptypes.MarshalAny(expectedResponse)
	if err != nil {
		t.Fatal(err)
	}
	mockAutoMl.resps = append(mockAutoMl.resps[:0], &longrunningpb.Operation{
		Name:   "longrunning-test",
		Done:   true,
		Result: &longrunningpb.Operation_Response{Response: any},
	})

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/datasets/%s", "[PROJECT]", "[LOCATION]", "[DATASET]")
	var outputConfig *automlpb.OutputConfig = &automlpb.OutputConfig{}
	var request = &automlpb.ExportDataRequest{
		Name:         formattedName,
		OutputConfig: outputConfig,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	respLRO, err := c.ExportData(context.Background(), request)
	if err != nil {
		t.Fatal(err)
	}
	err = respLRO.Wait(context.Background())

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockAutoMl.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

}

func TestAutoMlExportDataError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockAutoMl.err = nil
	mockAutoMl.resps = append(mockAutoMl.resps[:0], &longrunningpb.Operation{
		Name: "longrunning-test",
		Done: true,
		Result: &longrunningpb.Operation_Error{
			Error: &status.Status{
				Code:    int32(errCode),
				Message: "test error",
			},
		},
	})

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/datasets/%s", "[PROJECT]", "[LOCATION]", "[DATASET]")
	var outputConfig *automlpb.OutputConfig = &automlpb.OutputConfig{}
	var request = &automlpb.ExportDataRequest{
		Name:         formattedName,
		OutputConfig: outputConfig,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	respLRO, err := c.ExportData(context.Background(), request)
	if err != nil {
		t.Fatal(err)
	}
	err = respLRO.Wait(context.Background())

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
}
func TestAutoMlGetAnnotationSpec(t *testing.T) {
	var name2 string = "name2-1052831874"
	var displayName string = "displayName1615086568"
	var exampleCount int32 = 1517063674
	var expectedResponse = &automlpb.AnnotationSpec{
		Name:         name2,
		DisplayName:  displayName,
		ExampleCount: exampleCount,
	}

	mockAutoMl.err = nil
	mockAutoMl.reqs = nil

	mockAutoMl.resps = append(mockAutoMl.resps[:0], expectedResponse)

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/datasets/%s/annotationSpecs/%s", "[PROJECT]", "[LOCATION]", "[DATASET]", "[ANNOTATION_SPEC]")
	var request = &automlpb.GetAnnotationSpecRequest{
		Name: formattedName,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.GetAnnotationSpec(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockAutoMl.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestAutoMlGetAnnotationSpecError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockAutoMl.err = gstatus.Error(errCode, "test error")

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/datasets/%s/annotationSpecs/%s", "[PROJECT]", "[LOCATION]", "[DATASET]", "[ANNOTATION_SPEC]")
	var request = &automlpb.GetAnnotationSpecRequest{
		Name: formattedName,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.GetAnnotationSpec(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestAutoMlCreateModel(t *testing.T) {
	var name string = "name3373707"
	var displayName string = "displayName1615086568"
	var datasetId string = "datasetId-2115646910"
	var etag string = "etag3123477"
	var expectedResponse = &automlpb.Model{
		Name:        name,
		DisplayName: displayName,
		DatasetId:   datasetId,
		Etag:        etag,
	}

	mockAutoMl.err = nil
	mockAutoMl.reqs = nil

	any, err := ptypes.MarshalAny(expectedResponse)
	if err != nil {
		t.Fatal(err)
	}
	mockAutoMl.resps = append(mockAutoMl.resps[:0], &longrunningpb.Operation{
		Name:   "longrunning-test",
		Done:   true,
		Result: &longrunningpb.Operation_Response{Response: any},
	})

	var formattedParent string = fmt.Sprintf("projects/%s/locations/%s", "[PROJECT]", "[LOCATION]")
	var model *automlpb.Model = &automlpb.Model{}
	var request = &automlpb.CreateModelRequest{
		Parent: formattedParent,
		Model:  model,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	respLRO, err := c.CreateModel(context.Background(), request)
	if err != nil {
		t.Fatal(err)
	}
	resp, err := respLRO.Wait(context.Background())

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockAutoMl.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestAutoMlCreateModelError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockAutoMl.err = nil
	mockAutoMl.resps = append(mockAutoMl.resps[:0], &longrunningpb.Operation{
		Name: "longrunning-test",
		Done: true,
		Result: &longrunningpb.Operation_Error{
			Error: &status.Status{
				Code:    int32(errCode),
				Message: "test error",
			},
		},
	})

	var formattedParent string = fmt.Sprintf("projects/%s/locations/%s", "[PROJECT]", "[LOCATION]")
	var model *automlpb.Model = &automlpb.Model{}
	var request = &automlpb.CreateModelRequest{
		Parent: formattedParent,
		Model:  model,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	respLRO, err := c.CreateModel(context.Background(), request)
	if err != nil {
		t.Fatal(err)
	}
	resp, err := respLRO.Wait(context.Background())

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestAutoMlGetModel(t *testing.T) {
	var name2 string = "name2-1052831874"
	var displayName string = "displayName1615086568"
	var datasetId string = "datasetId-2115646910"
	var etag string = "etag3123477"
	var expectedResponse = &automlpb.Model{
		Name:        name2,
		DisplayName: displayName,
		DatasetId:   datasetId,
		Etag:        etag,
	}

	mockAutoMl.err = nil
	mockAutoMl.reqs = nil

	mockAutoMl.resps = append(mockAutoMl.resps[:0], expectedResponse)

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/models/%s", "[PROJECT]", "[LOCATION]", "[MODEL]")
	var request = &automlpb.GetModelRequest{
		Name: formattedName,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.GetModel(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockAutoMl.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestAutoMlGetModelError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockAutoMl.err = gstatus.Error(errCode, "test error")

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/models/%s", "[PROJECT]", "[LOCATION]", "[MODEL]")
	var request = &automlpb.GetModelRequest{
		Name: formattedName,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.GetModel(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestAutoMlUpdateModel(t *testing.T) {
	var name string = "name3373707"
	var displayName string = "displayName1615086568"
	var datasetId string = "datasetId-2115646910"
	var etag string = "etag3123477"
	var expectedResponse = &automlpb.Model{
		Name:        name,
		DisplayName: displayName,
		DatasetId:   datasetId,
		Etag:        etag,
	}

	mockAutoMl.err = nil
	mockAutoMl.reqs = nil

	mockAutoMl.resps = append(mockAutoMl.resps[:0], expectedResponse)

	var model *automlpb.Model = &automlpb.Model{}
	var updateMask *field_maskpb.FieldMask = &field_maskpb.FieldMask{}
	var request = &automlpb.UpdateModelRequest{
		Model:      model,
		UpdateMask: updateMask,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.UpdateModel(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockAutoMl.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestAutoMlUpdateModelError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockAutoMl.err = gstatus.Error(errCode, "test error")

	var model *automlpb.Model = &automlpb.Model{}
	var updateMask *field_maskpb.FieldMask = &field_maskpb.FieldMask{}
	var request = &automlpb.UpdateModelRequest{
		Model:      model,
		UpdateMask: updateMask,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.UpdateModel(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestAutoMlListModels(t *testing.T) {
	var nextPageToken string = ""
	var modelElement *automlpb.Model = &automlpb.Model{}
	var model = []*automlpb.Model{modelElement}
	var expectedResponse = &automlpb.ListModelsResponse{
		NextPageToken: nextPageToken,
		Model:         model,
	}

	mockAutoMl.err = nil
	mockAutoMl.reqs = nil

	mockAutoMl.resps = append(mockAutoMl.resps[:0], expectedResponse)

	var formattedParent string = fmt.Sprintf("projects/%s/locations/%s", "[PROJECT]", "[LOCATION]")
	var request = &automlpb.ListModelsRequest{
		Parent: formattedParent,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.ListModels(context.Background(), request).Next()

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockAutoMl.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	want := (interface{})(expectedResponse.Model[0])
	got := (interface{})(resp)
	var ok bool

	switch want := (want).(type) {
	case proto.Message:
		ok = proto.Equal(want, got.(proto.Message))
	default:
		ok = want == got
	}
	if !ok {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestAutoMlListModelsError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockAutoMl.err = gstatus.Error(errCode, "test error")

	var formattedParent string = fmt.Sprintf("projects/%s/locations/%s", "[PROJECT]", "[LOCATION]")
	var request = &automlpb.ListModelsRequest{
		Parent: formattedParent,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.ListModels(context.Background(), request).Next()

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestAutoMlDeleteModel(t *testing.T) {
	var expectedResponse *emptypb.Empty = &emptypb.Empty{}

	mockAutoMl.err = nil
	mockAutoMl.reqs = nil

	any, err := ptypes.MarshalAny(expectedResponse)
	if err != nil {
		t.Fatal(err)
	}
	mockAutoMl.resps = append(mockAutoMl.resps[:0], &longrunningpb.Operation{
		Name:   "longrunning-test",
		Done:   true,
		Result: &longrunningpb.Operation_Response{Response: any},
	})

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/models/%s", "[PROJECT]", "[LOCATION]", "[MODEL]")
	var request = &automlpb.DeleteModelRequest{
		Name: formattedName,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	respLRO, err := c.DeleteModel(context.Background(), request)
	if err != nil {
		t.Fatal(err)
	}
	err = respLRO.Wait(context.Background())

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockAutoMl.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

}

func TestAutoMlDeleteModelError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockAutoMl.err = nil
	mockAutoMl.resps = append(mockAutoMl.resps[:0], &longrunningpb.Operation{
		Name: "longrunning-test",
		Done: true,
		Result: &longrunningpb.Operation_Error{
			Error: &status.Status{
				Code:    int32(errCode),
				Message: "test error",
			},
		},
	})

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/models/%s", "[PROJECT]", "[LOCATION]", "[MODEL]")
	var request = &automlpb.DeleteModelRequest{
		Name: formattedName,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	respLRO, err := c.DeleteModel(context.Background(), request)
	if err != nil {
		t.Fatal(err)
	}
	err = respLRO.Wait(context.Background())

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
}
func TestAutoMlDeployModel(t *testing.T) {
	var expectedResponse *emptypb.Empty = &emptypb.Empty{}

	mockAutoMl.err = nil
	mockAutoMl.reqs = nil

	any, err := ptypes.MarshalAny(expectedResponse)
	if err != nil {
		t.Fatal(err)
	}
	mockAutoMl.resps = append(mockAutoMl.resps[:0], &longrunningpb.Operation{
		Name:   "longrunning-test",
		Done:   true,
		Result: &longrunningpb.Operation_Response{Response: any},
	})

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/models/%s", "[PROJECT]", "[LOCATION]", "[MODEL]")
	var request = &automlpb.DeployModelRequest{
		Name: formattedName,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	respLRO, err := c.DeployModel(context.Background(), request)
	if err != nil {
		t.Fatal(err)
	}
	err = respLRO.Wait(context.Background())

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockAutoMl.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

}

func TestAutoMlDeployModelError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockAutoMl.err = nil
	mockAutoMl.resps = append(mockAutoMl.resps[:0], &longrunningpb.Operation{
		Name: "longrunning-test",
		Done: true,
		Result: &longrunningpb.Operation_Error{
			Error: &status.Status{
				Code:    int32(errCode),
				Message: "test error",
			},
		},
	})

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/models/%s", "[PROJECT]", "[LOCATION]", "[MODEL]")
	var request = &automlpb.DeployModelRequest{
		Name: formattedName,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	respLRO, err := c.DeployModel(context.Background(), request)
	if err != nil {
		t.Fatal(err)
	}
	err = respLRO.Wait(context.Background())

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
}
func TestAutoMlUndeployModel(t *testing.T) {
	var expectedResponse *emptypb.Empty = &emptypb.Empty{}

	mockAutoMl.err = nil
	mockAutoMl.reqs = nil

	any, err := ptypes.MarshalAny(expectedResponse)
	if err != nil {
		t.Fatal(err)
	}
	mockAutoMl.resps = append(mockAutoMl.resps[:0], &longrunningpb.Operation{
		Name:   "longrunning-test",
		Done:   true,
		Result: &longrunningpb.Operation_Response{Response: any},
	})

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/models/%s", "[PROJECT]", "[LOCATION]", "[MODEL]")
	var request = &automlpb.UndeployModelRequest{
		Name: formattedName,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	respLRO, err := c.UndeployModel(context.Background(), request)
	if err != nil {
		t.Fatal(err)
	}
	err = respLRO.Wait(context.Background())

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockAutoMl.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

}

func TestAutoMlUndeployModelError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockAutoMl.err = nil
	mockAutoMl.resps = append(mockAutoMl.resps[:0], &longrunningpb.Operation{
		Name: "longrunning-test",
		Done: true,
		Result: &longrunningpb.Operation_Error{
			Error: &status.Status{
				Code:    int32(errCode),
				Message: "test error",
			},
		},
	})

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/models/%s", "[PROJECT]", "[LOCATION]", "[MODEL]")
	var request = &automlpb.UndeployModelRequest{
		Name: formattedName,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	respLRO, err := c.UndeployModel(context.Background(), request)
	if err != nil {
		t.Fatal(err)
	}
	err = respLRO.Wait(context.Background())

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
}
func TestAutoMlExportModel(t *testing.T) {
	var expectedResponse *emptypb.Empty = &emptypb.Empty{}

	mockAutoMl.err = nil
	mockAutoMl.reqs = nil

	any, err := ptypes.MarshalAny(expectedResponse)
	if err != nil {
		t.Fatal(err)
	}
	mockAutoMl.resps = append(mockAutoMl.resps[:0], &longrunningpb.Operation{
		Name:   "longrunning-test",
		Done:   true,
		Result: &longrunningpb.Operation_Response{Response: any},
	})

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/models/%s", "[PROJECT]", "[LOCATION]", "[MODEL]")
	var outputConfig *automlpb.ModelExportOutputConfig = &automlpb.ModelExportOutputConfig{}
	var request = &automlpb.ExportModelRequest{
		Name:         formattedName,
		OutputConfig: outputConfig,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	respLRO, err := c.ExportModel(context.Background(), request)
	if err != nil {
		t.Fatal(err)
	}
	err = respLRO.Wait(context.Background())

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockAutoMl.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

}

func TestAutoMlExportModelError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockAutoMl.err = nil
	mockAutoMl.resps = append(mockAutoMl.resps[:0], &longrunningpb.Operation{
		Name: "longrunning-test",
		Done: true,
		Result: &longrunningpb.Operation_Error{
			Error: &status.Status{
				Code:    int32(errCode),
				Message: "test error",
			},
		},
	})

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/models/%s", "[PROJECT]", "[LOCATION]", "[MODEL]")
	var outputConfig *automlpb.ModelExportOutputConfig = &automlpb.ModelExportOutputConfig{}
	var request = &automlpb.ExportModelRequest{
		Name:         formattedName,
		OutputConfig: outputConfig,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	respLRO, err := c.ExportModel(context.Background(), request)
	if err != nil {
		t.Fatal(err)
	}
	err = respLRO.Wait(context.Background())

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
}
func TestAutoMlGetModelEvaluation(t *testing.T) {
	var name2 string = "name2-1052831874"
	var annotationSpecId string = "annotationSpecId60690191"
	var displayName string = "displayName1615086568"
	var evaluatedExampleCount int32 = 277565350
	var expectedResponse = &automlpb.ModelEvaluation{
		Name:                  name2,
		AnnotationSpecId:      annotationSpecId,
		DisplayName:           displayName,
		EvaluatedExampleCount: evaluatedExampleCount,
	}

	mockAutoMl.err = nil
	mockAutoMl.reqs = nil

	mockAutoMl.resps = append(mockAutoMl.resps[:0], expectedResponse)

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/models/%s/modelEvaluations/%s", "[PROJECT]", "[LOCATION]", "[MODEL]", "[MODEL_EVALUATION]")
	var request = &automlpb.GetModelEvaluationRequest{
		Name: formattedName,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.GetModelEvaluation(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockAutoMl.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestAutoMlGetModelEvaluationError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockAutoMl.err = gstatus.Error(errCode, "test error")

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/models/%s/modelEvaluations/%s", "[PROJECT]", "[LOCATION]", "[MODEL]", "[MODEL_EVALUATION]")
	var request = &automlpb.GetModelEvaluationRequest{
		Name: formattedName,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.GetModelEvaluation(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestAutoMlListModelEvaluations(t *testing.T) {
	var nextPageToken string = ""
	var modelEvaluationElement *automlpb.ModelEvaluation = &automlpb.ModelEvaluation{}
	var modelEvaluation = []*automlpb.ModelEvaluation{modelEvaluationElement}
	var expectedResponse = &automlpb.ListModelEvaluationsResponse{
		NextPageToken:   nextPageToken,
		ModelEvaluation: modelEvaluation,
	}

	mockAutoMl.err = nil
	mockAutoMl.reqs = nil

	mockAutoMl.resps = append(mockAutoMl.resps[:0], expectedResponse)

	var formattedParent string = fmt.Sprintf("projects/%s/locations/%s/models/%s", "[PROJECT]", "[LOCATION]", "[MODEL]")
	var filter string = "filter-1274492040"
	var request = &automlpb.ListModelEvaluationsRequest{
		Parent: formattedParent,
		Filter: filter,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.ListModelEvaluations(context.Background(), request).Next()

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockAutoMl.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	want := (interface{})(expectedResponse.ModelEvaluation[0])
	got := (interface{})(resp)
	var ok bool

	switch want := (want).(type) {
	case proto.Message:
		ok = proto.Equal(want, got.(proto.Message))
	default:
		ok = want == got
	}
	if !ok {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestAutoMlListModelEvaluationsError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockAutoMl.err = gstatus.Error(errCode, "test error")

	var formattedParent string = fmt.Sprintf("projects/%s/locations/%s/models/%s", "[PROJECT]", "[LOCATION]", "[MODEL]")
	var filter string = "filter-1274492040"
	var request = &automlpb.ListModelEvaluationsRequest{
		Parent: formattedParent,
		Filter: filter,
	}

	c, err := NewClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.ListModelEvaluations(context.Background(), request).Next()

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestPredictionServicePredict(t *testing.T) {
	var expectedResponse *automlpb.PredictResponse = &automlpb.PredictResponse{}

	mockPrediction.err = nil
	mockPrediction.reqs = nil

	mockPrediction.resps = append(mockPrediction.resps[:0], expectedResponse)

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/models/%s", "[PROJECT]", "[LOCATION]", "[MODEL]")
	var payload *automlpb.ExamplePayload = &automlpb.ExamplePayload{}
	var request = &automlpb.PredictRequest{
		Name:    formattedName,
		Payload: payload,
	}

	c, err := NewPredictionClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.Predict(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockPrediction.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestPredictionServicePredictError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockPrediction.err = gstatus.Error(errCode, "test error")

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/models/%s", "[PROJECT]", "[LOCATION]", "[MODEL]")
	var payload *automlpb.ExamplePayload = &automlpb.ExamplePayload{}
	var request = &automlpb.PredictRequest{
		Name:    formattedName,
		Payload: payload,
	}

	c, err := NewPredictionClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.Predict(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
func TestPredictionServiceBatchPredict(t *testing.T) {
	var expectedResponse *automlpb.BatchPredictResult = &automlpb.BatchPredictResult{}

	mockPrediction.err = nil
	mockPrediction.reqs = nil

	any, err := ptypes.MarshalAny(expectedResponse)
	if err != nil {
		t.Fatal(err)
	}
	mockPrediction.resps = append(mockPrediction.resps[:0], &longrunningpb.Operation{
		Name:   "longrunning-test",
		Done:   true,
		Result: &longrunningpb.Operation_Response{Response: any},
	})

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/models/%s", "[PROJECT]", "[LOCATION]", "[MODEL]")
	var inputConfig *automlpb.BatchPredictInputConfig = &automlpb.BatchPredictInputConfig{}
	var outputConfig *automlpb.BatchPredictOutputConfig = &automlpb.BatchPredictOutputConfig{}
	var request = &automlpb.BatchPredictRequest{
		Name:         formattedName,
		InputConfig:  inputConfig,
		OutputConfig: outputConfig,
	}

	c, err := NewPredictionClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	respLRO, err := c.BatchPredict(context.Background(), request)
	if err != nil {
		t.Fatal(err)
	}
	resp, err := respLRO.Wait(context.Background())

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockPrediction.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestPredictionServiceBatchPredictError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockPrediction.err = nil
	mockPrediction.resps = append(mockPrediction.resps[:0], &longrunningpb.Operation{
		Name: "longrunning-test",
		Done: true,
		Result: &longrunningpb.Operation_Error{
			Error: &status.Status{
				Code:    int32(errCode),
				Message: "test error",
			},
		},
	})

	var formattedName string = fmt.Sprintf("projects/%s/locations/%s/models/%s", "[PROJECT]", "[LOCATION]", "[MODEL]")
	var inputConfig *automlpb.BatchPredictInputConfig = &automlpb.BatchPredictInputConfig{}
	var outputConfig *automlpb.BatchPredictOutputConfig = &automlpb.BatchPredictOutputConfig{}
	var request = &automlpb.BatchPredictRequest{
		Name:         formattedName,
		InputConfig:  inputConfig,
		OutputConfig: outputConfig,
	}

	c, err := NewPredictionClient(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	respLRO, err := c.BatchPredict(context.Background(), request)
	if err != nil {
		t.Fatal(err)
	}
	resp, err := respLRO.Wait(context.Background())

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
