package main

import (
	"flag"
	"fmt"
	"log"
	"os"

	bluemix "github.com/IBM-Cloud/bluemix-go"
	"github.com/IBM-Cloud/bluemix-go/session"

	v2 "github.com/IBM-Cloud/bluemix-go/api/container/containerv2"

	"github.com/IBM-Cloud/bluemix-go/trace"
)

func main() {

	c := new(bluemix.Config)

	var cluster string
	flag.StringVar(&cluster, "cluster", "", "Clusetr Name")

	var InstanceID string
	flag.StringVar(&InstanceID, "InstanceID", "", " monitoring InstanceID")
	flag.Parse()

	trace.Logger = trace.NewLogger("true")
	if cluster == "" || InstanceID == "" {
		flag.Usage()
		os.Exit(1)
	}

	sess, err := session.New(c)
	if err != nil {
		log.Fatal(err)
	}

	if err != nil {
		log.Fatal(err)
	}

	target := v2.LoggingTargetHeader{}

	loggingClient, err := v2.New(sess)
	if err != nil {
		log.Fatal(err)
	}
	loggingAPI := loggingClient.Logging()

	var loggingInfo = v2.LoggingDeleteRequest{
		Cluster:  cluster,
		Instance: InstanceID,
	}

	response, err1 := loggingAPI.DeleteLoggingConfig(loggingInfo, target)
	if err1 != nil {
		log.Fatal(err)
	}
	fmt.Println("Logging instance successfully deleted", response)

}
