// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// IPSecPolicyTemplate IP sec policy template
// swagger:model IPSecPolicyTemplate
type IPSecPolicyTemplate struct {

	// ipSecPolicy Authentication default value
	// Required: true
	Authentication *string `json:"authentication"`

	// ipSecPolicy DHGroup default value
	// Required: true
	DhGroup *int64 `json:"dhGroup"`

	// ipSecPolicy Encryption default value
	// Required: true
	Encryption *string `json:"encryption"`

	// key lifetime
	// Required: true
	KeyLifetime KeyLifetime `json:"keyLifetime"`
}

// Validate validates this IP sec policy template
func (m *IPSecPolicyTemplate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAuthentication(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDhGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEncryption(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateKeyLifetime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IPSecPolicyTemplate) validateAuthentication(formats strfmt.Registry) error {

	if err := validate.Required("authentication", "body", m.Authentication); err != nil {
		return err
	}

	return nil
}

func (m *IPSecPolicyTemplate) validateDhGroup(formats strfmt.Registry) error {

	if err := validate.Required("dhGroup", "body", m.DhGroup); err != nil {
		return err
	}

	return nil
}

func (m *IPSecPolicyTemplate) validateEncryption(formats strfmt.Registry) error {

	if err := validate.Required("encryption", "body", m.Encryption); err != nil {
		return err
	}

	return nil
}

func (m *IPSecPolicyTemplate) validateKeyLifetime(formats strfmt.Registry) error {

	if err := m.KeyLifetime.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("keyLifetime")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IPSecPolicyTemplate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IPSecPolicyTemplate) UnmarshalBinary(b []byte) error {
	var res IPSecPolicyTemplate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
