// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// VPNConnection v p n connection
// swagger:model VPNConnection
type VPNConnection struct {

	// dead peer detection
	// Required: true
	DeadPeerDetection *DeadPeerDetection `json:"deadPeerDetection"`

	// unique identifier for VPN Connection
	// Required: true
	ID *string `json:"id"`

	// ike policy
	// Required: true
	IkePolicy *IKEPolicyRef `json:"ikePolicy"`

	// ip sec policy
	// Required: true
	IPSecPolicy *IPSecPolicyRef `json:"ipSecPolicy"`

	// local Gateway address, only in 'route' mode.
	// Required: true
	LocalGatewayAddress *string `json:"localGatewayAddress"`

	// Mode used by this VPNConnection, either policy-based, or route-based, this attribute is set at the creation and cannot be updated later.
	// Required: true
	// Enum: [policy route]
	Mode *string `json:"mode"`

	// VPN Connection name
	// Required: true
	Name *string `json:"name"`

	// an array of network IDs
	// Required: true
	NetworkIds []string `json:"networkIDs"`

	// peer gateway address
	// Required: true
	// Format: ipv4
	PeerGatewayAddress PeerGatewayAddress `json:"peerGatewayAddress"`

	// an array of strings containing CIDR of peer subnets
	// Required: true
	PeerSubnets []string `json:"peerSubnets"`

	// status of the VPN connection
	// Required: true
	// Enum: [active warning disabled]
	Status *string `json:"status"`

	// public IP address of the VPN Gateway (vSRX) attached to this VPNConnection
	// Required: true
	VpnGatewayAddress *string `json:"vpnGatewayAddress"`
}

// Validate validates this v p n connection
func (m *VPNConnection) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDeadPeerDetection(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIkePolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPSecPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocalGatewayAddress(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetworkIds(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePeerGatewayAddress(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePeerSubnets(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVpnGatewayAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *VPNConnection) validateDeadPeerDetection(formats strfmt.Registry) error {

	if err := validate.Required("deadPeerDetection", "body", m.DeadPeerDetection); err != nil {
		return err
	}

	if m.DeadPeerDetection != nil {
		if err := m.DeadPeerDetection.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("deadPeerDetection")
			}
			return err
		}
	}

	return nil
}

func (m *VPNConnection) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *VPNConnection) validateIkePolicy(formats strfmt.Registry) error {

	if err := validate.Required("ikePolicy", "body", m.IkePolicy); err != nil {
		return err
	}

	if m.IkePolicy != nil {
		if err := m.IkePolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ikePolicy")
			}
			return err
		}
	}

	return nil
}

func (m *VPNConnection) validateIPSecPolicy(formats strfmt.Registry) error {

	if err := validate.Required("ipSecPolicy", "body", m.IPSecPolicy); err != nil {
		return err
	}

	if m.IPSecPolicy != nil {
		if err := m.IPSecPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipSecPolicy")
			}
			return err
		}
	}

	return nil
}

func (m *VPNConnection) validateLocalGatewayAddress(formats strfmt.Registry) error {

	if err := validate.Required("localGatewayAddress", "body", m.LocalGatewayAddress); err != nil {
		return err
	}

	return nil
}

var vPNConnectionTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["policy","route"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		vPNConnectionTypeModePropEnum = append(vPNConnectionTypeModePropEnum, v)
	}
}

const (

	// VPNConnectionModePolicy captures enum value "policy"
	VPNConnectionModePolicy string = "policy"

	// VPNConnectionModeRoute captures enum value "route"
	VPNConnectionModeRoute string = "route"
)

// prop value enum
func (m *VPNConnection) validateModeEnum(path, location string, value string) error {
	if err := validate.Enum(path, location, value, vPNConnectionTypeModePropEnum); err != nil {
		return err
	}
	return nil
}

func (m *VPNConnection) validateMode(formats strfmt.Registry) error {

	if err := validate.Required("mode", "body", m.Mode); err != nil {
		return err
	}

	// value enum
	if err := m.validateModeEnum("mode", "body", *m.Mode); err != nil {
		return err
	}

	return nil
}

func (m *VPNConnection) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *VPNConnection) validateNetworkIds(formats strfmt.Registry) error {

	if err := validate.Required("networkIDs", "body", m.NetworkIds); err != nil {
		return err
	}

	return nil
}

func (m *VPNConnection) validatePeerGatewayAddress(formats strfmt.Registry) error {

	if err := m.PeerGatewayAddress.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("peerGatewayAddress")
		}
		return err
	}

	return nil
}

func (m *VPNConnection) validatePeerSubnets(formats strfmt.Registry) error {

	if err := validate.Required("peerSubnets", "body", m.PeerSubnets); err != nil {
		return err
	}

	return nil
}

var vPNConnectionTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["active","warning","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		vPNConnectionTypeStatusPropEnum = append(vPNConnectionTypeStatusPropEnum, v)
	}
}

const (

	// VPNConnectionStatusActive captures enum value "active"
	VPNConnectionStatusActive string = "active"

	// VPNConnectionStatusWarning captures enum value "warning"
	VPNConnectionStatusWarning string = "warning"

	// VPNConnectionStatusDisabled captures enum value "disabled"
	VPNConnectionStatusDisabled string = "disabled"
)

// prop value enum
func (m *VPNConnection) validateStatusEnum(path, location string, value string) error {
	if err := validate.Enum(path, location, value, vPNConnectionTypeStatusPropEnum); err != nil {
		return err
	}
	return nil
}

func (m *VPNConnection) validateStatus(formats strfmt.Registry) error {

	if err := validate.Required("status", "body", m.Status); err != nil {
		return err
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *VPNConnection) validateVpnGatewayAddress(formats strfmt.Registry) error {

	if err := validate.Required("vpnGatewayAddress", "body", m.VpnGatewayAddress); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *VPNConnection) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *VPNConnection) UnmarshalBinary(b []byte) error {
	var res VPNConnection
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
