// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// StoragePool storage pool
// swagger:model StoragePool
type StoragePool struct {

	// display name of storage pool
	// Required: true
	DisplayName *string `json:"displayName"`

	// indicates if the storage pool is disaster recovery (dr) enabled
	// Required: true
	DrEnabled *bool `json:"drEnabled"`

	// name of storage pool
	// Required: true
	Name *string `json:"name"`

	// threshold override settings of a pool
	OverrideThresholds *Thresholds `json:"overrideThresholds,omitempty"`

	// state of storage pool
	// Required: true
	// Enum: [closed opened]
	State *string `json:"state"`

	// type of storage pool
	// Required: true
	Type *string `json:"type"`
}

// Validate validates this storage pool
func (m *StoragePool) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDisplayName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDrEnabled(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOverrideThresholds(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StoragePool) validateDisplayName(formats strfmt.Registry) error {

	if err := validate.Required("displayName", "body", m.DisplayName); err != nil {
		return err
	}

	return nil
}

func (m *StoragePool) validateDrEnabled(formats strfmt.Registry) error {

	if err := validate.Required("drEnabled", "body", m.DrEnabled); err != nil {
		return err
	}

	return nil
}

func (m *StoragePool) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *StoragePool) validateOverrideThresholds(formats strfmt.Registry) error {

	if swag.IsZero(m.OverrideThresholds) { // not required
		return nil
	}

	if m.OverrideThresholds != nil {
		if err := m.OverrideThresholds.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("overrideThresholds")
			}
			return err
		}
	}

	return nil
}

var storagePoolTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["closed","opened"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storagePoolTypeStatePropEnum = append(storagePoolTypeStatePropEnum, v)
	}
}

const (

	// StoragePoolStateClosed captures enum value "closed"
	StoragePoolStateClosed string = "closed"

	// StoragePoolStateOpened captures enum value "opened"
	StoragePoolStateOpened string = "opened"
)

// prop value enum
func (m *StoragePool) validateStateEnum(path, location string, value string) error {
	if err := validate.Enum(path, location, value, storagePoolTypeStatePropEnum); err != nil {
		return err
	}
	return nil
}

func (m *StoragePool) validateState(formats strfmt.Registry) error {

	if err := validate.Required("state", "body", m.State); err != nil {
		return err
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *StoragePool) validateType(formats strfmt.Registry) error {

	if err := validate.Required("type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *StoragePool) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StoragePool) UnmarshalBinary(b []byte) error {
	var res StoragePool
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
