// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PlacementGroup placement group
// swagger:model PlacementGroup
type PlacementGroup struct {

	// The id of the Placement Group
	// Required: true
	ID *string `json:"id"`

	// The List of PVM Instance IDs associated with the Placement Group
	// Required: true
	Members []string `json:"members"`

	// The name of the Placement Group
	// Required: true
	Name *string `json:"name"`

	// The Placement Group Policy
	// Required: true
	// Enum: [affinity anti-affinity]
	Policy *string `json:"policy"`
}

// Validate validates this placement group
func (m *PlacementGroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMembers(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PlacementGroup) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *PlacementGroup) validateMembers(formats strfmt.Registry) error {

	if err := validate.Required("members", "body", m.Members); err != nil {
		return err
	}

	return nil
}

func (m *PlacementGroup) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

var placementGroupTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["affinity","anti-affinity"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		placementGroupTypePolicyPropEnum = append(placementGroupTypePolicyPropEnum, v)
	}
}

const (

	// PlacementGroupPolicyAffinity captures enum value "affinity"
	PlacementGroupPolicyAffinity string = "affinity"

	// PlacementGroupPolicyAntiAffinity captures enum value "anti-affinity"
	PlacementGroupPolicyAntiAffinity string = "anti-affinity"
)

// prop value enum
func (m *PlacementGroup) validatePolicyEnum(path, location string, value string) error {
	if err := validate.Enum(path, location, value, placementGroupTypePolicyPropEnum); err != nil {
		return err
	}
	return nil
}

func (m *PlacementGroup) validatePolicy(formats strfmt.Registry) error {

	if err := validate.Required("policy", "body", m.Policy); err != nil {
		return err
	}

	// value enum
	if err := m.validatePolicyEnum("policy", "body", *m.Policy); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PlacementGroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PlacementGroup) UnmarshalBinary(b []byte) error {
	var res PlacementGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
