// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// IKEPolicyUpdate IKE Policy object used for update
// swagger:model IKEPolicyUpdate
type IKEPolicyUpdate struct {

	// authentication
	Authentication IKEPolicyAuthentication `json:"authentication,omitempty"`

	// DH group of the IKE Policy
	// Enum: [1 2 5 14 19 20 24]
	DhGroup int64 `json:"dhGroup,omitempty"`

	// encryption of the IKE Policy
	// Enum: [3des-cbc aes-128-cbc aes-128-gcm aes-192-cbc aes-256-cbc aes-256-gcm des-cbc]
	Encryption string `json:"encryption,omitempty"`

	// key lifetime
	KeyLifetime KeyLifetime `json:"keyLifetime,omitempty"`

	// name of the IKE Policy
	// Max Length: 47
	// Min Length: 1
	Name string `json:"name,omitempty"`

	// Preshared key used in this IKE Policy (length of preshared key must be even)
	PresharedKey string `json:"presharedKey,omitempty"`

	// version of the IKE Policy
	// Enum: [1 2]
	Version int64 `json:"version,omitempty"`

	// i k e policy update additional properties
	IKEPolicyUpdateAdditionalProperties map[string]interface{} `json:"-"`
}

// UnmarshalJSON unmarshals this object with additional properties from JSON
func (m *IKEPolicyUpdate) UnmarshalJSON(data []byte) error {
	// stage 1, bind the properties
	var stage1 struct {

		// authentication
		Authentication IKEPolicyAuthentication `json:"authentication,omitempty"`

		// DH group of the IKE Policy
		// Enum: [1 2 5 14 19 20 24]
		DhGroup int64 `json:"dhGroup,omitempty"`

		// encryption of the IKE Policy
		// Enum: [3des-cbc aes-128-cbc aes-128-gcm aes-192-cbc aes-256-cbc aes-256-gcm des-cbc]
		Encryption string `json:"encryption,omitempty"`

		// key lifetime
		KeyLifetime KeyLifetime `json:"keyLifetime,omitempty"`

		// name of the IKE Policy
		// Max Length: 47
		// Min Length: 1
		Name string `json:"name,omitempty"`

		// Preshared key used in this IKE Policy (length of preshared key must be even)
		PresharedKey string `json:"presharedKey,omitempty"`

		// version of the IKE Policy
		// Enum: [1 2]
		Version int64 `json:"version,omitempty"`
	}
	if err := json.Unmarshal(data, &stage1); err != nil {
		return err
	}
	var rcv IKEPolicyUpdate

	rcv.Authentication = stage1.Authentication

	rcv.DhGroup = stage1.DhGroup

	rcv.Encryption = stage1.Encryption

	rcv.KeyLifetime = stage1.KeyLifetime

	rcv.Name = stage1.Name

	rcv.PresharedKey = stage1.PresharedKey

	rcv.Version = stage1.Version

	*m = rcv

	// stage 2, remove properties and add to map
	stage2 := make(map[string]json.RawMessage)
	if err := json.Unmarshal(data, &stage2); err != nil {
		return err
	}

	delete(stage2, "authentication")

	delete(stage2, "dhGroup")

	delete(stage2, "encryption")

	delete(stage2, "keyLifetime")

	delete(stage2, "name")

	delete(stage2, "presharedKey")

	delete(stage2, "version")

	// stage 3, add additional properties values
	if len(stage2) > 0 {
		result := make(map[string]interface{})
		for k, v := range stage2 {
			var toadd interface{}
			if err := json.Unmarshal(v, &toadd); err != nil {
				return err
			}
			result[k] = toadd
		}
		m.IKEPolicyUpdateAdditionalProperties = result
	}

	return nil
}

// MarshalJSON marshals this object with additional properties into a JSON object
func (m IKEPolicyUpdate) MarshalJSON() ([]byte, error) {
	var stage1 struct {

		// authentication
		Authentication IKEPolicyAuthentication `json:"authentication,omitempty"`

		// DH group of the IKE Policy
		// Enum: [1 2 5 14 19 20 24]
		DhGroup int64 `json:"dhGroup,omitempty"`

		// encryption of the IKE Policy
		// Enum: [3des-cbc aes-128-cbc aes-128-gcm aes-192-cbc aes-256-cbc aes-256-gcm des-cbc]
		Encryption string `json:"encryption,omitempty"`

		// key lifetime
		KeyLifetime KeyLifetime `json:"keyLifetime,omitempty"`

		// name of the IKE Policy
		// Max Length: 47
		// Min Length: 1
		Name string `json:"name,omitempty"`

		// Preshared key used in this IKE Policy (length of preshared key must be even)
		PresharedKey string `json:"presharedKey,omitempty"`

		// version of the IKE Policy
		// Enum: [1 2]
		Version int64 `json:"version,omitempty"`
	}

	stage1.Authentication = m.Authentication

	stage1.DhGroup = m.DhGroup

	stage1.Encryption = m.Encryption

	stage1.KeyLifetime = m.KeyLifetime

	stage1.Name = m.Name

	stage1.PresharedKey = m.PresharedKey

	stage1.Version = m.Version

	// make JSON object for known properties
	props, err := json.Marshal(stage1)
	if err != nil {
		return nil, err
	}

	if len(m.IKEPolicyUpdateAdditionalProperties) == 0 {
		return props, nil
	}

	// make JSON object for the additional properties
	additional, err := json.Marshal(m.IKEPolicyUpdateAdditionalProperties)
	if err != nil {
		return nil, err
	}

	if len(props) < 3 {
		return additional, nil
	}

	// concatenate the 2 objects
	props[len(props)-1] = ','
	return append(props, additional[1:]...), nil
}

// Validate validates this i k e policy update
func (m *IKEPolicyUpdate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAuthentication(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDhGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEncryption(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateKeyLifetime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *IKEPolicyUpdate) validateAuthentication(formats strfmt.Registry) error {

	if swag.IsZero(m.Authentication) { // not required
		return nil
	}

	if err := m.Authentication.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("authentication")
		}
		return err
	}

	return nil
}

var iKEPolicyUpdateTypeDhGroupPropEnum []interface{}

func init() {
	var res []int64
	if err := json.Unmarshal([]byte(`[1,2,5,14,19,20,24]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		iKEPolicyUpdateTypeDhGroupPropEnum = append(iKEPolicyUpdateTypeDhGroupPropEnum, v)
	}
}

// prop value enum
func (m *IKEPolicyUpdate) validateDhGroupEnum(path, location string, value int64) error {
	if err := validate.Enum(path, location, value, iKEPolicyUpdateTypeDhGroupPropEnum); err != nil {
		return err
	}
	return nil
}

func (m *IKEPolicyUpdate) validateDhGroup(formats strfmt.Registry) error {

	if swag.IsZero(m.DhGroup) { // not required
		return nil
	}

	// value enum
	if err := m.validateDhGroupEnum("dhGroup", "body", m.DhGroup); err != nil {
		return err
	}

	return nil
}

var iKEPolicyUpdateTypeEncryptionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["3des-cbc","aes-128-cbc","aes-128-gcm","aes-192-cbc","aes-256-cbc","aes-256-gcm","des-cbc"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		iKEPolicyUpdateTypeEncryptionPropEnum = append(iKEPolicyUpdateTypeEncryptionPropEnum, v)
	}
}

const (

	// IKEPolicyUpdateEncryptionNr3desCbc captures enum value "3des-cbc"
	IKEPolicyUpdateEncryptionNr3desCbc string = "3des-cbc"

	// IKEPolicyUpdateEncryptionAes128Cbc captures enum value "aes-128-cbc"
	IKEPolicyUpdateEncryptionAes128Cbc string = "aes-128-cbc"

	// IKEPolicyUpdateEncryptionAes128Gcm captures enum value "aes-128-gcm"
	IKEPolicyUpdateEncryptionAes128Gcm string = "aes-128-gcm"

	// IKEPolicyUpdateEncryptionAes192Cbc captures enum value "aes-192-cbc"
	IKEPolicyUpdateEncryptionAes192Cbc string = "aes-192-cbc"

	// IKEPolicyUpdateEncryptionAes256Cbc captures enum value "aes-256-cbc"
	IKEPolicyUpdateEncryptionAes256Cbc string = "aes-256-cbc"

	// IKEPolicyUpdateEncryptionAes256Gcm captures enum value "aes-256-gcm"
	IKEPolicyUpdateEncryptionAes256Gcm string = "aes-256-gcm"

	// IKEPolicyUpdateEncryptionDesCbc captures enum value "des-cbc"
	IKEPolicyUpdateEncryptionDesCbc string = "des-cbc"
)

// prop value enum
func (m *IKEPolicyUpdate) validateEncryptionEnum(path, location string, value string) error {
	if err := validate.Enum(path, location, value, iKEPolicyUpdateTypeEncryptionPropEnum); err != nil {
		return err
	}
	return nil
}

func (m *IKEPolicyUpdate) validateEncryption(formats strfmt.Registry) error {

	if swag.IsZero(m.Encryption) { // not required
		return nil
	}

	// value enum
	if err := m.validateEncryptionEnum("encryption", "body", m.Encryption); err != nil {
		return err
	}

	return nil
}

func (m *IKEPolicyUpdate) validateKeyLifetime(formats strfmt.Registry) error {

	if swag.IsZero(m.KeyLifetime) { // not required
		return nil
	}

	if err := m.KeyLifetime.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("keyLifetime")
		}
		return err
	}

	return nil
}

func (m *IKEPolicyUpdate) validateName(formats strfmt.Registry) error {

	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", string(m.Name), 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", string(m.Name), 47); err != nil {
		return err
	}

	return nil
}

var iKEPolicyUpdateTypeVersionPropEnum []interface{}

func init() {
	var res []int64
	if err := json.Unmarshal([]byte(`[1,2]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		iKEPolicyUpdateTypeVersionPropEnum = append(iKEPolicyUpdateTypeVersionPropEnum, v)
	}
}

// prop value enum
func (m *IKEPolicyUpdate) validateVersionEnum(path, location string, value int64) error {
	if err := validate.Enum(path, location, value, iKEPolicyUpdateTypeVersionPropEnum); err != nil {
		return err
	}
	return nil
}

func (m *IKEPolicyUpdate) validateVersion(formats strfmt.Registry) error {

	if swag.IsZero(m.Version) { // not required
		return nil
	}

	// value enum
	if err := m.validateVersionEnum("version", "body", m.Version); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *IKEPolicyUpdate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *IKEPolicyUpdate) UnmarshalBinary(b []byte) error {
	var res IKEPolicyUpdate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
