// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SSHKey SSH key
// swagger:model SSHKey
type SSHKey struct {

	// Date of sshkey creation
	// Format: date-time
	CreationDate *strfmt.DateTime `json:"creationDate,omitempty" datastore:"creationDate"`

	// User defined name for the SSH key
	// Required: true
	Name *string `json:"name" datastore:"name"`

	// SSH RSA key
	// Required: true
	SSHKey *string `json:"sshKey" datastore:"sshKey"`
}

// Validate validates this SSH key
func (m *SSHKey) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCreationDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSSHKey(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SSHKey) validateCreationDate(formats strfmt.Registry) error {

	if swag.IsZero(m.CreationDate) { // not required
		return nil
	}

	if err := validate.FormatOf("creationDate", "body", "date-time", m.CreationDate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *SSHKey) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *SSHKey) validateSSHKey(formats strfmt.Registry) error {

	if err := validate.Required("sshKey", "body", m.SSHKey); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SSHKey) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SSHKey) UnmarshalBinary(b []byte) error {
	var res SSHKey
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
