// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PVMInstanceOperation p VM instance operation
// swagger:model PVMInstanceOperation
type PVMInstanceOperation struct {

	// operation
	// Required: true
	Operation *Operations `json:"operation"`

	// Name of the operation to execute; can be job or boot
	// Required: true
	// Enum: [job boot]
	OperationType *string `json:"operationType"`
}

// Validate validates this p VM instance operation
func (m *PVMInstanceOperation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateOperation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOperationType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PVMInstanceOperation) validateOperation(formats strfmt.Registry) error {

	if err := validate.Required("operation", "body", m.Operation); err != nil {
		return err
	}

	if m.Operation != nil {
		if err := m.Operation.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("operation")
			}
			return err
		}
	}

	return nil
}

var pVmInstanceOperationTypeOperationTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["job","boot"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		pVmInstanceOperationTypeOperationTypePropEnum = append(pVmInstanceOperationTypeOperationTypePropEnum, v)
	}
}

const (

	// PVMInstanceOperationOperationTypeJob captures enum value "job"
	PVMInstanceOperationOperationTypeJob string = "job"

	// PVMInstanceOperationOperationTypeBoot captures enum value "boot"
	PVMInstanceOperationOperationTypeBoot string = "boot"
)

// prop value enum
func (m *PVMInstanceOperation) validateOperationTypeEnum(path, location string, value string) error {
	if err := validate.Enum(path, location, value, pVmInstanceOperationTypeOperationTypePropEnum); err != nil {
		return err
	}
	return nil
}

func (m *PVMInstanceOperation) validateOperationType(formats strfmt.Registry) error {

	if err := validate.Required("operationType", "body", m.OperationType); err != nil {
		return err
	}

	// value enum
	if err := m.validateOperationTypeEnum("operationType", "body", *m.OperationType); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PVMInstanceOperation) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PVMInstanceOperation) UnmarshalBinary(b []byte) error {
	var res PVMInstanceOperation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
