// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// CloudConnectionGRETunnelCreate cloud connection g r e tunnel create
// swagger:model CloudConnectionGRETunnelCreate
type CloudConnectionGRETunnelCreate struct {

	// gre network in CIDR notation (192.168.0.0/24)
	// Required: true
	Cidr *string `json:"cidr"`

	// gre destination IP address
	// Required: true
	DestIPAddress *string `json:"destIPAddress"`
}

// Validate validates this cloud connection g r e tunnel create
func (m *CloudConnectionGRETunnelCreate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCidr(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDestIPAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloudConnectionGRETunnelCreate) validateCidr(formats strfmt.Registry) error {

	if err := validate.Required("cidr", "body", m.Cidr); err != nil {
		return err
	}

	return nil
}

func (m *CloudConnectionGRETunnelCreate) validateDestIPAddress(formats strfmt.Registry) error {

	if err := validate.Required("destIPAddress", "body", m.DestIPAddress); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CloudConnectionGRETunnelCreate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CloudConnectionGRETunnelCreate) UnmarshalBinary(b []byte) error {
	var res CloudConnectionGRETunnelCreate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
