package instance

import (
	"context"
	"fmt"

	"github.com/IBM-Cloud/power-go-client/errors"
	"github.com/IBM-Cloud/power-go-client/helpers"

	"github.com/IBM-Cloud/power-go-client/ibmpisession"
	"github.com/IBM-Cloud/power-go-client/power/client/p_cloud_system_pools"
	"github.com/IBM-Cloud/power-go-client/power/models"
)

// IBMPISystemPoolClient ...
type IBMPISystemPoolClient struct {
	IBMPIClient
}

// NewIBMPISystemPoolClient ...
func NewIBMPISystemPoolClient(ctx context.Context, sess *ibmpisession.IBMPISession, cloudInstanceID string) *IBMPISystemPoolClient {
	return &IBMPISystemPoolClient{
		*NewIBMPIClient(ctx, sess, cloudInstanceID),
	}
}

//Get the System Pools
func (f *IBMPISystemPoolClient) Get(id string) (models.SystemPools, error) {
	params := p_cloud_system_pools.NewPcloudSystempoolsGetParams().
		WithContext(f.ctx).WithTimeout(helpers.PIGetTimeOut).
		WithCloudInstanceID(id)
	resp, err := f.session.Power.PCloudSystemPools.PcloudSystempoolsGet(params, f.authInfo)
	if err != nil {
		return nil, fmt.Errorf(errors.GetSystemPoolsOperationFailed, id, err)
	}
	if resp == nil || resp.Payload == nil {
		return nil, fmt.Errorf("failed to perform Get System Pools Operation for cloud instance id %s", id)
	}
	return resp.Payload, nil
}
