/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	egressfirewallv1 "github.com/ovn-org/ovn-kubernetes/go-controller/pkg/crd/egressfirewall/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeEgressFirewalls implements EgressFirewallInterface
type FakeEgressFirewalls struct {
	Fake *FakeK8sV1
	ns   string
}

var egressfirewallsResource = schema.GroupVersionResource{Group: "k8s.ovn.org", Version: "v1", Resource: "egressfirewalls"}

var egressfirewallsKind = schema.GroupVersionKind{Group: "k8s.ovn.org", Version: "v1", Kind: "EgressFirewall"}

// Get takes name of the egressFirewall, and returns the corresponding egressFirewall object, and an error if there is any.
func (c *FakeEgressFirewalls) Get(ctx context.Context, name string, options v1.GetOptions) (result *egressfirewallv1.EgressFirewall, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(egressfirewallsResource, c.ns, name), &egressfirewallv1.EgressFirewall{})

	if obj == nil {
		return nil, err
	}
	return obj.(*egressfirewallv1.EgressFirewall), err
}

// List takes label and field selectors, and returns the list of EgressFirewalls that match those selectors.
func (c *FakeEgressFirewalls) List(ctx context.Context, opts v1.ListOptions) (result *egressfirewallv1.EgressFirewallList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(egressfirewallsResource, egressfirewallsKind, c.ns, opts), &egressfirewallv1.EgressFirewallList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &egressfirewallv1.EgressFirewallList{ListMeta: obj.(*egressfirewallv1.EgressFirewallList).ListMeta}
	for _, item := range obj.(*egressfirewallv1.EgressFirewallList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested egressFirewalls.
func (c *FakeEgressFirewalls) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(egressfirewallsResource, c.ns, opts))

}

// Create takes the representation of a egressFirewall and creates it.  Returns the server's representation of the egressFirewall, and an error, if there is any.
func (c *FakeEgressFirewalls) Create(ctx context.Context, egressFirewall *egressfirewallv1.EgressFirewall, opts v1.CreateOptions) (result *egressfirewallv1.EgressFirewall, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(egressfirewallsResource, c.ns, egressFirewall), &egressfirewallv1.EgressFirewall{})

	if obj == nil {
		return nil, err
	}
	return obj.(*egressfirewallv1.EgressFirewall), err
}

// Update takes the representation of a egressFirewall and updates it. Returns the server's representation of the egressFirewall, and an error, if there is any.
func (c *FakeEgressFirewalls) Update(ctx context.Context, egressFirewall *egressfirewallv1.EgressFirewall, opts v1.UpdateOptions) (result *egressfirewallv1.EgressFirewall, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(egressfirewallsResource, c.ns, egressFirewall), &egressfirewallv1.EgressFirewall{})

	if obj == nil {
		return nil, err
	}
	return obj.(*egressfirewallv1.EgressFirewall), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeEgressFirewalls) UpdateStatus(ctx context.Context, egressFirewall *egressfirewallv1.EgressFirewall, opts v1.UpdateOptions) (*egressfirewallv1.EgressFirewall, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(egressfirewallsResource, "status", c.ns, egressFirewall), &egressfirewallv1.EgressFirewall{})

	if obj == nil {
		return nil, err
	}
	return obj.(*egressfirewallv1.EgressFirewall), err
}

// Delete takes name of the egressFirewall and deletes it. Returns an error if one occurs.
func (c *FakeEgressFirewalls) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(egressfirewallsResource, c.ns, name), &egressfirewallv1.EgressFirewall{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeEgressFirewalls) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(egressfirewallsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &egressfirewallv1.EgressFirewallList{})
	return err
}

// Patch applies the patch and returns the patched egressFirewall.
func (c *FakeEgressFirewalls) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *egressfirewallv1.EgressFirewall, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(egressfirewallsResource, c.ns, name, pt, data, subresources...), &egressfirewallv1.EgressFirewall{})

	if obj == nil {
		return nil, err
	}
	return obj.(*egressfirewallv1.EgressFirewall), err
}
