// Code generated by "libovsdb.modelgen"
// DO NOT EDIT.

package nbdb

import "github.com/ovn-org/libovsdb/model"

type (
	MeterUnit = string
)

var (
	MeterUnitKbps  MeterUnit = "kbps"
	MeterUnitPktps MeterUnit = "pktps"
)

// Meter defines an object in Meter table
type Meter struct {
	UUID        string            `ovsdb:"_uuid"`
	Bands       []string          `ovsdb:"bands"`
	ExternalIDs map[string]string `ovsdb:"external_ids"`
	Fair        *bool             `ovsdb:"fair"`
	Name        string            `ovsdb:"name"`
	Unit        MeterUnit         `ovsdb:"unit"`
}

func copyMeterBands(a []string) []string {
	if a == nil {
		return nil
	}
	b := make([]string, len(a))
	copy(b, a)
	return b
}

func equalMeterBands(a, b []string) bool {
	if (a == nil) != (b == nil) {
		return false
	}
	if len(a) != len(b) {
		return false
	}
	for i, v := range a {
		if b[i] != v {
			return false
		}
	}
	return true
}

func copyMeterExternalIDs(a map[string]string) map[string]string {
	if a == nil {
		return nil
	}
	b := make(map[string]string, len(a))
	for k, v := range a {
		b[k] = v
	}
	return b
}

func equalMeterExternalIDs(a, b map[string]string) bool {
	if (a == nil) != (b == nil) {
		return false
	}
	if len(a) != len(b) {
		return false
	}
	for k, v := range a {
		if w, ok := b[k]; !ok || v != w {
			return false
		}
	}
	return true
}

func copyMeterFair(a *bool) *bool {
	if a == nil {
		return nil
	}
	b := *a
	return &b
}

func equalMeterFair(a, b *bool) bool {
	if (a == nil) != (b == nil) {
		return false
	}
	if a == b {
		return true
	}
	return *a == *b
}

func (a *Meter) DeepCopyInto(b *Meter) {
	*b = *a
	b.Bands = copyMeterBands(a.Bands)
	b.ExternalIDs = copyMeterExternalIDs(a.ExternalIDs)
	b.Fair = copyMeterFair(a.Fair)
}

func (a *Meter) DeepCopy() *Meter {
	b := new(Meter)
	a.DeepCopyInto(b)
	return b
}

func (a *Meter) CloneModelInto(b model.Model) {
	c := b.(*Meter)
	a.DeepCopyInto(c)
}

func (a *Meter) CloneModel() model.Model {
	return a.DeepCopy()
}

func (a *Meter) Equals(b *Meter) bool {
	return a.UUID == b.UUID &&
		equalMeterBands(a.Bands, b.Bands) &&
		equalMeterExternalIDs(a.ExternalIDs, b.ExternalIDs) &&
		equalMeterFair(a.Fair, b.Fair) &&
		a.Name == b.Name &&
		a.Unit == b.Unit
}

func (a *Meter) EqualsModel(b model.Model) bool {
	c := b.(*Meter)
	return a.Equals(c)
}

var _ model.CloneableModel = &Meter{}
var _ model.ComparableModel = &Meter{}
