// Code generated by "libovsdb.modelgen"
// DO NOT EDIT.

package nbdb

import "github.com/ovn-org/libovsdb/model"

type (
	LoadBalancerProtocol        = string
	LoadBalancerSelectionFields = string
)

var (
	LoadBalancerProtocolTCP           LoadBalancerProtocol        = "tcp"
	LoadBalancerProtocolUDP           LoadBalancerProtocol        = "udp"
	LoadBalancerProtocolSCTP          LoadBalancerProtocol        = "sctp"
	LoadBalancerSelectionFieldsEthSrc LoadBalancerSelectionFields = "eth_src"
	LoadBalancerSelectionFieldsEthDst LoadBalancerSelectionFields = "eth_dst"
	LoadBalancerSelectionFieldsIPSrc  LoadBalancerSelectionFields = "ip_src"
	LoadBalancerSelectionFieldsIPDst  LoadBalancerSelectionFields = "ip_dst"
	LoadBalancerSelectionFieldsTpSrc  LoadBalancerSelectionFields = "tp_src"
	LoadBalancerSelectionFieldsTpDst  LoadBalancerSelectionFields = "tp_dst"
)

// LoadBalancer defines an object in Load_Balancer table
type LoadBalancer struct {
	UUID            string                        `ovsdb:"_uuid"`
	ExternalIDs     map[string]string             `ovsdb:"external_ids"`
	HealthCheck     []string                      `ovsdb:"health_check"`
	IPPortMappings  map[string]string             `ovsdb:"ip_port_mappings"`
	Name            string                        `ovsdb:"name"`
	Options         map[string]string             `ovsdb:"options"`
	Protocol        *LoadBalancerProtocol         `ovsdb:"protocol"`
	SelectionFields []LoadBalancerSelectionFields `ovsdb:"selection_fields"`
	Vips            map[string]string             `ovsdb:"vips"`
}

func copyLoadBalancerExternalIDs(a map[string]string) map[string]string {
	if a == nil {
		return nil
	}
	b := make(map[string]string, len(a))
	for k, v := range a {
		b[k] = v
	}
	return b
}

func equalLoadBalancerExternalIDs(a, b map[string]string) bool {
	if (a == nil) != (b == nil) {
		return false
	}
	if len(a) != len(b) {
		return false
	}
	for k, v := range a {
		if w, ok := b[k]; !ok || v != w {
			return false
		}
	}
	return true
}

func copyLoadBalancerHealthCheck(a []string) []string {
	if a == nil {
		return nil
	}
	b := make([]string, len(a))
	copy(b, a)
	return b
}

func equalLoadBalancerHealthCheck(a, b []string) bool {
	if (a == nil) != (b == nil) {
		return false
	}
	if len(a) != len(b) {
		return false
	}
	for i, v := range a {
		if b[i] != v {
			return false
		}
	}
	return true
}

func copyLoadBalancerIPPortMappings(a map[string]string) map[string]string {
	if a == nil {
		return nil
	}
	b := make(map[string]string, len(a))
	for k, v := range a {
		b[k] = v
	}
	return b
}

func equalLoadBalancerIPPortMappings(a, b map[string]string) bool {
	if (a == nil) != (b == nil) {
		return false
	}
	if len(a) != len(b) {
		return false
	}
	for k, v := range a {
		if w, ok := b[k]; !ok || v != w {
			return false
		}
	}
	return true
}

func copyLoadBalancerOptions(a map[string]string) map[string]string {
	if a == nil {
		return nil
	}
	b := make(map[string]string, len(a))
	for k, v := range a {
		b[k] = v
	}
	return b
}

func equalLoadBalancerOptions(a, b map[string]string) bool {
	if (a == nil) != (b == nil) {
		return false
	}
	if len(a) != len(b) {
		return false
	}
	for k, v := range a {
		if w, ok := b[k]; !ok || v != w {
			return false
		}
	}
	return true
}

func copyLoadBalancerProtocol(a *LoadBalancerProtocol) *LoadBalancerProtocol {
	if a == nil {
		return nil
	}
	b := *a
	return &b
}

func equalLoadBalancerProtocol(a, b *LoadBalancerProtocol) bool {
	if (a == nil) != (b == nil) {
		return false
	}
	if a == b {
		return true
	}
	return *a == *b
}

func copyLoadBalancerSelectionFields(a []LoadBalancerSelectionFields) []LoadBalancerSelectionFields {
	if a == nil {
		return nil
	}
	b := make([]LoadBalancerSelectionFields, len(a))
	copy(b, a)
	return b
}

func equalLoadBalancerSelectionFields(a, b []LoadBalancerSelectionFields) bool {
	if (a == nil) != (b == nil) {
		return false
	}
	if len(a) != len(b) {
		return false
	}
	for i, v := range a {
		if b[i] != v {
			return false
		}
	}
	return true
}

func copyLoadBalancerVips(a map[string]string) map[string]string {
	if a == nil {
		return nil
	}
	b := make(map[string]string, len(a))
	for k, v := range a {
		b[k] = v
	}
	return b
}

func equalLoadBalancerVips(a, b map[string]string) bool {
	if (a == nil) != (b == nil) {
		return false
	}
	if len(a) != len(b) {
		return false
	}
	for k, v := range a {
		if w, ok := b[k]; !ok || v != w {
			return false
		}
	}
	return true
}

func (a *LoadBalancer) DeepCopyInto(b *LoadBalancer) {
	*b = *a
	b.ExternalIDs = copyLoadBalancerExternalIDs(a.ExternalIDs)
	b.HealthCheck = copyLoadBalancerHealthCheck(a.HealthCheck)
	b.IPPortMappings = copyLoadBalancerIPPortMappings(a.IPPortMappings)
	b.Options = copyLoadBalancerOptions(a.Options)
	b.Protocol = copyLoadBalancerProtocol(a.Protocol)
	b.SelectionFields = copyLoadBalancerSelectionFields(a.SelectionFields)
	b.Vips = copyLoadBalancerVips(a.Vips)
}

func (a *LoadBalancer) DeepCopy() *LoadBalancer {
	b := new(LoadBalancer)
	a.DeepCopyInto(b)
	return b
}

func (a *LoadBalancer) CloneModelInto(b model.Model) {
	c := b.(*LoadBalancer)
	a.DeepCopyInto(c)
}

func (a *LoadBalancer) CloneModel() model.Model {
	return a.DeepCopy()
}

func (a *LoadBalancer) Equals(b *LoadBalancer) bool {
	return a.UUID == b.UUID &&
		equalLoadBalancerExternalIDs(a.ExternalIDs, b.ExternalIDs) &&
		equalLoadBalancerHealthCheck(a.HealthCheck, b.HealthCheck) &&
		equalLoadBalancerIPPortMappings(a.IPPortMappings, b.IPPortMappings) &&
		a.Name == b.Name &&
		equalLoadBalancerOptions(a.Options, b.Options) &&
		equalLoadBalancerProtocol(a.Protocol, b.Protocol) &&
		equalLoadBalancerSelectionFields(a.SelectionFields, b.SelectionFields) &&
		equalLoadBalancerVips(a.Vips, b.Vips)
}

func (a *LoadBalancer) EqualsModel(b model.Model) bool {
	c := b.(*LoadBalancer)
	return a.Equals(c)
}

var _ model.CloneableModel = &LoadBalancer{}
var _ model.ComparableModel = &LoadBalancer{}
